import Panel from "../../Module/Panel";
import { _decorator, Button } from "cc";
import { LOG_TYPE, sendLog, sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";
import { showToast } from "../../Module/UIFast";
import ShareCenter from "../ShareCenter";
import { SHARE_TYPE } from "../const";


const { ccclass, property } = _decorator;

@ccclass('InvitePanel')
export default class InvitePanel extends Panel {

    static skin = "InvitePanel";
    static group = "InvitePanel";


    async start() {
        this.view["close"].on(Button.EventType.CLICK, this.hidePanel, this);
        this.view["shareBtn"].on(Button.EventType.CLICK, this.shareHandle, this);

        sendLog(LOG_TYPE.EXPOSURE, 12)
    }

    /** 送惊喜 立即分享 */
    async shareHandle() {
        sendLog(LOG_TYPE.CLICK, 12)
        ShareCenter.ins.doShare(SHARE_TYPE.SURPRISE)
    }

}
