import { _decorator, Component, Node, Button, Label, tween, UIOpacity, Vec3, v3, easing } from "cc";
import Svga from "../../Component/Svga/Svga";
import Panel from "../../Module/Panel";
import { changeScene, hideAllPanel } from "../../Module/UIFast";
import GameMgr from "../GameMgr";
import { MainGame } from "../Scenes/MainGame";
import { LOG_TYPE, sendLog, sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";
const { ccclass, property } = _decorator;

@ccclass("GuidePrizePanel")
export class GuidePrizePanel extends Panel {
  static bundle: string = "";
  static skin = "GuidePrizePanel";
  static group = "GuidePrizePanel";

  /** 我知道了 */
  @property(Node)
  mainBtn: Node = null;
  /** 标题氛围 */
  @property(Node)
  titleSvga: Node = null;
  /** 标题 */
  @property(Node)
  title: Node = null;

  mainBtnTween = null;

  start() {
    sendLog(LOG_TYPE.EXPOSURE, 19);
    this.mainBtn.on(Button.EventType.CLICK, this.closePannel, this);

    this.mainBtnTween = tween(this.mainBtn)
      .repeatForever(
        tween(this.mainBtn)
          .to(0.5, { scale: v3(1.1, 1.1, 1.1) }, { easing: easing.smooth })
          .to(0.5, { scale: v3(0.9, 0.9, 0.9) }, { easing: easing.smooth })
      )
      .start();

    this.titleSvga.getComponent(Svga).play();
    this.titleSvga.on(Svga.EventType.END_FRAME, () => {
      this.title.getComponent(UIOpacity).opacity = 255;
      tween(this.title)
        .to(0.2, { scale: new Vec3(1, 1, 1) })
        .start();
    });
    // this.pannelRender();
  }

  /** 渲染 */
  async pannelRender() {}

  /** 关闭弹窗 */
  async closePannel() {
    sendLog(LOG_TYPE.CLICK, 19);
    hideAllPanel();
    try {
      const success = await GameMgr.ins.start();
      if (success) {
        await changeScene(MainGame);
      }
    } catch (e) {
      console.error(e);
    }
  }
}
