import Panel from "../../Module/Panel";
import {_decorator, Button, Node} from "cc";
import {changeScene} from "db://assets/Module/UIFast";
import {HomeScene} from "db://assets/Scripts/Scenes/HomeScene";
import {LOG_TYPE, sendLog} from "db://assets/Scripts/Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@ccclass('BackPanel')
export default class BackPanel extends Panel {

    static skin = "BackPanel";
    static group = "BackPanel";

    @property(Node)
    cancel: Node = null;

    @property(Node)
    ok: Node = null;

    @property(Node)
    close: Node = null;

    async start() {
        this.ok.on(Button.EventType.CLICK, this.clickOk, this);
        this.cancel.on(Button.EventType.CLICK, this.clickCancel, this);
        this.close.on(Button.EventType.CLICK, this.onClose, this);

        sendLog(LOG_TYPE.EXPOSURE, 43);
        sendLog(LOG_TYPE.EXPOSURE, 44);
    }

    clickOk() {
        sendLog(LOG_TYPE.CLICK, 44);
        this.hidePanel();
        changeScene(HomeScene);
    }

    clickCancel() {
        sendLog(LOG_TYPE.CLICK, 43);
        this.data.cancel();
        this.hidePanel();
    }

    onClose() {
        this.data.cancel();
        this.hidePanel();
    }

}
