import { showPanel, showToast } from "../Module/UIFast";
import { sendWebNetWithToken, WebNetName } from "./Utils/WebNet/WebNet";
import { SHARE_TYPE } from "./const";
import ShareCenter from "./ShareCenter";
import PosterPanel from "./Panels/PosterPanel";
import BrowseImgPanel from "./Panels/BrowseImgPanel";
import store from "../store/store";
import { appJump } from "../AppTool";
import { getQueryParamValue, getUrlParam } from "./Utils/Utils";

const levelToast = {
    3: "恭喜您今日运势极佳，可领取3次挑战次数",
    2: "恭喜您今日运势上佳，可领取2次挑战次数",
    1: "恭喜您今日运势上等，可领取1次挑战次数",
};

const beforeDoComplete = (item: any, func: Function) => {
    const hasBtnText = !!item?.buttonText;
    const time = hasBtnText ? 1000 : 0;
    if (hasBtnText) {
        showToast(item?.buttonText);
    }
    setTimeout(()  => {
        !!func && func();
    }, time);
}

export default class TaskCenter {

   static async doCompleted(taskCode: string) {
        const {success, data} = await sendWebNetWithToken(WebNetName.doCompleted, {taskCode: taskCode});
        if (!success) return;
        store.updateTask();
    }

    /** 任务处理中心 */
   static async handleClickTask(item: any = {}) {

        const {code, jumpUrl, id} = item;

        /** 邀请任务 */
        if (code?.startsWith("it")) {
            beforeDoComplete(item, () => {
                ShareCenter.ins.doShare();
            });
        }
        /** 浏览任务 */
        else if (code?.startsWith("bt_")) {
            if (code == "bt_real") {
                // 真浏览-浏览长图任务
                showPanel(BrowseImgPanel, {
                    panelType: "topNoScale",
                    doneFun: async () => {
                        const {success, data} = await sendWebNetWithToken(
                            WebNetName.finishBrowseTask,
                            {taskCode: code, taskId: id}
                        );
                        if (!success) return;
                        store.updateTask();
                    }
                })
            } else if (code == "bt_mrys") {
                // 浏览每日运势任务
                showPanel(PosterPanel, {
                    sharedFun: async (level) => {
                        const {success, data} = await sendWebNetWithToken(
                            WebNetName.finishBrowseTask,
                            {taskCode: code, taskId: id, ysLevel: level}
                        );
                        if (!success) return;
                        store.updateTask();
                        showToast(levelToast[level]);
                    }
                });
            } else {
                beforeDoComplete(item, async () => {
                    await sendWebNetWithToken(
                        WebNetName.finishBrowseTask,
                        {taskCode: code, taskId: id}
                    );
                    // location.href = jumpUrl;
                    //获取跳转方式
                    let type = getQueryParamValue(jumpUrl,"type");
                    console.info("跳转方式type",type )
                    if(type == "1"){ //跳转方式1
                        (jumpUrl && jumpUrl != '/' ) && appJump(jumpUrl);
                    }else if(type == "2"){//跳转方式2

                    }else{ //不拼方式不跳了，害怕跳错了

                    } 
                    
                });
            }
        }
        /** 行方任务 */
        else if (code?.startsWith("bank_")) {
            console.info('11111')
            beforeDoComplete(item, async () => {
                // if (!item?.extra || item?.extra == 0) { // 未领取任务 调领取行方任务接口
                //     await sendWebNetWithToken(
                //         WebNetName.claimThirdTask,
                //         {taskCode: code, taskId: id}
                //     );
                // }
                // const type = code.split("_")[1];
                // if (type == "t") { // 行方交易任务
                //     appJump(jumpUrl)
                // } else if (type == "s") { // 行方签约任务
                //     appJump(ju mpUrl)
                // }
                // location.href = jumpUrl;
                console.info('jumpUrl', jumpUrl);
                (jumpUrl && jumpUrl != '/' ) && appJump(jumpUrl);
            })
        }
        /** 会员等级达标任务 */
        else if (code == 'hydjdb') {
            // 能给链接跳转 就配置正常配置jumpUrl
            // 不能跳转 jumpUrl配置$$$ 需要toast提示就配置buttonText
            beforeDoComplete(item, () => {
                (jumpUrl && jumpUrl != '/' ) && appJump(jumpUrl);
            });
        }
    }

    /** 领取奖励 */
    static async receivePrize(item) {
        const {code, prizePendingCode} = item;


        const {success, data} = await sendWebNetWithToken(
            WebNetName.sendPrize,
            {taskCode: code, prizePendingCode}
        );
        if (!success) return;

        store.updateTask();
        store.updateIndex();
        showToast("任务完成，奖励已发放");
    }

}
