import { _decorator, Component, Node, Label, Sprite, Button } from 'cc';
import { dateFormatter, strFormat } from '../../Utils/Utils';
import { ScrollListItem } from "../../ScrollList/ScrollListItem";
import { appJump } from "../../../AppTool";

const {ccclass, property} = _decorator;

@ccclass("PrizeItem")
export class PrizeItem extends ScrollListItem {

    @property(Sprite)
    img: Sprite = null;

    @property(Label)
    nameTxt: Label = null;

    @property(Label)
    dateTxt: Label = null;

    protected onLoad() {
        this.node.on(Button.EventType.CLICK, this.clickItem, this);
    }

    clickItem() {
        const {id, url, boolBankPrize, prizeId} = this.data;


        setTimeout(() => {

            if (prizeId.indexOf("third") == 0) {
                appJump(window["voucherPackUrl"]);
                return;
            }

            // 行方奖品
            if (boolBankPrize) {
                // 行方商城奖品详情页：jfscddlb
                // appJump('jfscddlb');
                return;
            }

            if (url) {
                location.href = url
            } else {
                location.href = `/aaw/projectx/takePrize?projectOrderNo=${id}`;
            }
        }, 50)

    }

    /** 元素渲染 */
    onItemRender(data, index) {
        super.onItemRender(data, index);
        this.img.spriteFrame = data.extra.icon;
        this.nameTxt.string = strFormat(data.extra.name || "", 22);
        this.dateTxt.string = dateFormatter(data.gmtCreate, "yyyy年M月d日h:m获得");
    }
}

