import {
    _decorator,
    Node,
    Button,
} from 'cc';
import Scene from "db://assets/Module/Scene";
import { changeScene } from "db://assets/Module/UIFast";
import { ScrollList, SCROLL_VERTICAL } from "db://assets/Scripts/ScrollList/ScrollList";
import { LOG_TYPE, sendLog, sendWebNet, WebNetName } from 'db://assets/Scripts/Utils/WebNet/WebNet';
import { HomeScene } from 'db://assets/Scripts/Scenes/HomeScene';

const {ccclass, property} = _decorator;

@ccclass("PrizeScene")
export class PrizeScene extends Scene {
    static skin: string = "PrizeScene";
    static group: string[] = ["PrizeScene"];

    @property({type: ScrollList, tooltip: "竖行滚动容器"})
    private vScroll: ScrollList;

    @property(Node)
    backBtn: Node = null;

    @property(Node)
    empty: Node = null;

    start() {
        sendLog(LOG_TYPE.EXPOSURE,24)
        this.getPrizeRecord();
        this.backBtn.on(Button.EventType.CLICK, this.clickBackBtn, this);
    }

    async getPrizeRecord() {
        const {success, data = []} = await sendWebNet(WebNetName.prizeRecord);
        if (!success) {
            return;
        }

        const list = [];
        data.forEach((item) => {
            if (
                ["sp_challenge_times", "sp_rich_man"].indexOf(item.prizeId) > -1
            ) {
                return;
            }
            list.push(item);
        });

        this.vScroll.setDataList(list, SCROLL_VERTICAL, [0, 0, 16]);
        this.vScroll.scrollToTop(0);
        this.empty.active = (list.length <= 0);
    }

    /** 返回首页 */
    clickBackBtn() {
        changeScene(HomeScene);
    }

}

