import Panel from "../../Module/Panel";
import { _decorator, Button, Node } from "cc";
import { showPanel, showToast } from "../../Module/UIFast";
import { sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import GoodsDetailPanel from "./GoodsDetailPanel";
import { getUrlParam } from "../Utils/Utils";


const { ccclass, property } = _decorator;

@ccclass('ChoosePrizePanel')
export default class ChoosePrizePanel extends Panel {

    static skin = "ChoosePrizePanel";
    static group = "ChoosePrizePanel";

    /** 确认按钮 */
    @property(Node)
    confirmBtn: Node = null;

    chooseId; // 选择的奖品


    async start() {
        this.view["prize_list/prize_item1/hasSelected"].active = false
        this.view["prize_list/prize_item2/hasSelected"].active = false
        this.view["prize_list/prize_item1/prizeImgBgLight"].active = false
        this.view["prize_list/prize_item2/prizeImgBgLight"].active = false

        this.confirmBtn.on(Button.EventType.CLICK, this.confirmHandle, this);
        this.view["prize_list/prize_item1/detailBtn"].on(Button.EventType.CLICK, () => this.detailHandle('1'), this);
        this.view["prize_list/prize_item2/detailBtn"].on(Button.EventType.CLICK, () => this.detailHandle('2'), this);
        this.view["prize_list/prize_item1/noSelect"].on(Button.EventType.CLICK, () => this.selectHandle('1'), this);
        this.view["prize_list/prize_item1/hasSelected"].on(Button.EventType.CLICK, () => this.selectHandle('1'), this);
        this.view["prize_list/prize_item2/noSelect"].on(Button.EventType.CLICK, () => this.selectHandle('2'), this);
        this.view["prize_list/prize_item2/hasSelected"].on(Button.EventType.CLICK, () => this.selectHandle('2'), this);
    }

    /** 查看详情 */
    async detailHandle(id: string) {
        showPanel(GoodsDetailPanel, { chooseId: id });
    }

    /** 选择 */
    async selectHandle(id: string) {
        this.chooseId = id
        if (this.chooseId == '1') {
            this.view["prize_list/prize_item1/hasSelected"].active = true
            this.view["prize_list/prize_item1/noSelect"].active = false
            this.view["prize_list/prize_item2/hasSelected"].active = false
            this.view["prize_list/prize_item2/noSelect"].active = true
            this.view["prize_list/prize_item1/prizeImgBgLight"].active = true
            this.view["prize_list/prize_item2/prizeImgBgLight"].active = false
        } else {
            this.view["prize_list/prize_item1/hasSelected"].active = false
            this.view["prize_list/prize_item1/noSelect"].active = true
            this.view["prize_list/prize_item2/hasSelected"].active = true
            this.view["prize_list/prize_item2/noSelect"].active = false
            this.view["prize_list/prize_item1/prizeImgBgLight"].active = false
            this.view["prize_list/prize_item2/prizeImgBgLight"].active = true
        }
    }

    /** 确认 */
    async confirmHandle() {

        if (!this.chooseId) return showToast("请先选择一个奖品哦")
        
        this.btnEnable(this.confirmBtn, false);
        const { success } = await sendWebNetWithToken(WebNetName.chooseRankPrize, { chooseId: this.chooseId })
        if (success) {
            showToast("选择成功，请在奖品页填写地址！")
            setTimeout(() => {
                this.hidePanel()
                window.location.href = `prize.html?appID=${getUrlParam("appID")}&channel=${getUrlParam("channel")}`
            }, 2000)
        }
        this.btnEnable(this.confirmBtn, false);
    }

}
