import Panel from "../../Module/Panel";
import { _decorator, Button, RichText, UITransform } from "cc";

const { ccclass, property } = _decorator;

@ccclass('GoodsDetailPanel')
export default class GoodsDetailPanel extends Panel {

    static bundle: string = "";
    static skin = "GoodsDetailPanel";
    static group = "GoodsDetailPanel";

    DETAIL_CONTENT = {
        "1": "【上海迪士尼门票礼品票-非指定常规日全年通用单日票】权益<br />“上海迪士尼门票礼品票-非指定常规日全年通用单日票”可兑换于常规日入园的“上海迪士尼门票指定单日成人票或儿童，老人票”一张。常规日涵盖部分春季和秋季日期，大部分冬季日期。（具体日期请以官网为准） <br /><br />使用须知： <br />1.仅含上海迪士尼乐园成人常规日通用票; <br />2.扫描礼品卡上的二维码，进入官方兑换网址； <br />3.按照提示进行迪士尼门票兑换。 <br /><br />注意事项：<br />1.为了方便您合理的安排出行时间，须提前3-10天以上兑换; <br />2.兑换卡一经兑换不得退改，不找零； <br />3.有效日期：2024-12-31。<br /><br />条款及条件： <br />使用此门票，即表示您同意与此门票相关的条款及条件以及公布于上海迪士尼乐园官网 https://www.shanghaidisneyresort.com/《上海迪士尼乐园及上海迪士尼入园须知》的约束 <br />1.此门票仅限所选日期使用。<br />2.此门票不得篡改、复制、转让、转售或用于其他任何商业用途。此门票仅限绑定有效身份证件者本人使用。对于购买方或使用者将此门票用于其他任何商业用途的行为，上海迪士尼乐园有权追究其法律责任。<br />3.不包括停车服务。<br />4.门票变更和退款政策:除非适用法律另有规定，门票不可变更和退款。 <br />5.门票不能与其他优惠或折扣叠加使用，也不能用于单独售票的活动或贵宾体验。 <br />6.门票使用者须自行承担因其故意或过失造成的一切人身伤害或财产损失。 <br />7.极端天气，恶劣天气或空气质量状况将影响我们的运营(如:遭遇雨雪、冰雹、雷电，沙尘暴、空气污染等)，或出于园区的承载能力、健康与安全需要，特殊活动或其他必要原因的考虑，上海迪士尼可能部分或全部不定期变更或关闭，恕不另行通知，除非适用法律另有规定，上海迪士尼乐园不承担责任。 <br />8.出于园区安全、游园秩序的考虑，或者在其他我们认为必要的情况下，对于任何不遵守《上海迪士尼乐园度假区及上海迪士尼乐园入园须知》，成本条款及条件、或相关法律法规和政策的门票使用者，我们有权拒绝向其提供各类产品或服务、或拒绝其入园，或要求其立即离园。<br />9.园区营业时间请见 https://www.shanghaidisneyresort.com/ <br />10.仅限在上海迪士尼乐园使用。 <br />11.本产品不记名，不挂失，遗失不补，不提供发票，不兑换现金，密码区刮开后不退不换。<br /><br />由上海执力实业有限公司提供售后服务，如有疑问，请致电我司客服电话：4008213427，服务时间：周一至周五9:00-18:00。",
        "2": "【北京环球影城门票礼品券-乐享】权益<br />“北京环球影城门票礼品券-乐享” 可兑换于淡季日入园的“北京环球影城指定单日门票-礼品券兑换门票”一张。淡季日涵盖部分春季和秋季日期、大部分冬季日期。（具体日期请以官网为准）<br /><br />使用须知：<br />1.包含北京环球影城非指定淡季单日成人门票;<br />2.扫描礼品票上的二维码，进入官方预约通道;<br />3.按照提示进行北京环球影城门票进行预约兑换。<br /><br />注意事项:<br />1.为了方便您的合理安排出行时间，须提前3-10天以上进行预约兑换;<br />2.兑换卡一经预约兑换，不得退改，不设找零。<br />3.有效日期：2024-12-31<br /><br />条款及条件：<br />1.该门票礼品券兑换有效期与经兑换的北京环球影城门票可用日期无关。<br />2.此门票礼品券需在有效期内兑换成为“北京环球影城指定单日门票-礼品券兑换门票”后方可入园。<br />3. “北京环球影城指定单日门票-礼品券兑换门票”采用四级票价结构，于淡季日、平季日、旺季日或特定日入园的门票的官方市场售价可能有所区别。除非适用法律另有规定，如果选择兑换票价较低的日期入园，不同票价间的差额部分不可退款。<br />4.您可能无法在购买、接收或兑换此门票礼品券时即获知您期望的入园日期属于淡季日、平季日、旺季日或特定日。您可以于北京环球度假区官方App查询最新的门票日历。该日历将滚动更新，以方便游客提前规划行程。<br />5.本产品接收者领取成功后需注册北京环球度假区官方App或微信小程序进行礼品券兑换，即绑定“北京环球影城指定单日门票-礼品券兑换门票”使用者姓名、有效身份证件、联系方式，并选择门票使用日期。兑换为门票后，游客在入园前，还需提前预约入园时段，分时段有序入园。<br />6.此门票礼品券不得篡改、复制、转售或用于其它任何商业用途。对于购买方或接收方将此门票礼品券用于其他任何商业用途的行为，北京环球度假区有权追究其法律责任。<br />7.门票礼品券使用者须自行承担因其故意或过失造成的一切人身伤害或财产损失。<br /><br />由上海执力实业有限公司提供售后服务，如有疑问，请致电我司客服电话：4008213427，服务时间：周一至周五9:00-18:00。",
    }

    async start() {
        this.setContent(this.DETAIL_CONTENT[this.data.chooseId]);
        this.view["close"].on(Button.EventType.CLICK, () => {
            this.hidePanel()
        }, this);
    }

    setContent(txt) {
        console.log('txt', txt);
        
        const detailNode = this.view['ScrollView/view/content/detailTxt'];
        const detailTxt = detailNode.getComponent(RichText);
        const content = this.view['ScrollView/view/content'];
        detailTxt.maxWidth = content.getComponent(UITransform).width;

        this.scheduleOnce(() => {
            detailTxt.string = txt.replace(/<p\b.*?(?:\>|\/>)/gi,"").replace(/<\/p\>/gi,"<br/>");
            content.getComponent(UITransform).height = detailNode.getComponent(UITransform).height;
        }, 0.188);
    }



}
