import { _decorator, Component, Node, Label, Color } from 'cc';
import { dateFormatter, strFormat } from 'db://assets/Scripts/Utils/Utils';
import { ScrollListItem } from 'db://assets/Scripts/ScrollList/ScrollListItem';
const { ccclass, property } = _decorator;

@ccclass("RecordScrollListItem")
export class RecordScrollListItem extends ScrollListItem {
  start() {}

  onItemRender(data, ...param: any[]) {
    if (Object.keys(data).includes("ifGetPrize")) {
        this.node.getChildByName("Title").getComponent(Label).string = `获得${data?.score || 0}游园币`;
        this.node.getChildByName("Time").getComponent(Label).string = `${dateFormatter(data?.timestamp, "yyyy.MM.dd hh:mm")}`;
        if(!!data?.ifGetPrize) {
            this.node.getChildByName("Desc").getComponent(Label).color = new Color(255, 5, 0, 255);
            this.node.getChildByName("Desc").getComponent(Label).string = `获得宝箱`;
        } else {
            this.node.getChildByName("Desc").getComponent(Label).string = `未获得宝箱`;
            this.node.getChildByName("Desc").getComponent(Label).color = new Color(16, 168, 73, 255);
        }
    } else {
        this.node.getChildByName("Title").getComponent(Label).string = strFormat(data?.source, 30);
        this.node.getChildByName("Time").getComponent(Label).string = `${dateFormatter(data?.timestamp, "yyyy.MM.dd hh:mm")}`;
        this.node.getChildByName("Desc").getComponent(Label).string = `挑战次数${data?.type || ""}${data?.num}`;
        if (data?.type == "-") {
            this.node.getChildByName("Desc").getComponent(Label).color = new Color(16, 168, 73, 255);
        } else {
            this.node.getChildByName("Desc").getComponent(Label).color = new Color(255, 5, 0, 255);
        }
    }
  }
}

