import {
    _decorator,
    Node,
    UIOpacity,
    Prefab,
} from 'cc';
import Scene from "db://assets/Module/Scene";
import { changeScene } from "db://assets/Module/UIFast";
import { ScrollList, SCROLL_VERTICAL } from "db://assets/Scripts/ScrollList/ScrollList";
import { sendWebNet, WebNetName } from 'db://assets/Scripts/Utils/WebNet/WebNet';
import { HomeScene } from 'db://assets/Scripts/Scenes/HomeScene';

const {ccclass, property} = _decorator;

@ccclass("RecordScene")
export class RecordScene extends Scene {
    static skin: string = "RecordScene";
    static group: string[] = ["RecordScene"];

    /** 明细页类别 */
    private _type: string = "1";

    get type() {
        return this._type;
    }

    set type(type: string) {
        this._type = type;
    }

    @property({type: ScrollList, tooltip: "竖行滚动容器"})
    private vScroll: ScrollList;

    @property(Node)
    RecordBox: Node = null;

    @property(Node)
    gameBg: Node = null;

    @property(Node)
    countBg: Node = null;

    start() {
        this.getCountRecordInfo();
    }

    /** 获取次数明细 */
    async getCountRecordInfo() {
        const res = await sendWebNet(WebNetName.changeDetails);
        if (res?.success) {
            this.recordRender(res?.data || []);
        }
    }

    /** 获取游戏记录 */
    async getGameRecordInfo() {
        const res = await sendWebNet(WebNetName.gameRecord);
        if (res?.success) {
            this.recordRender(res?.data || []);
        }
    }

    /** 明细渲染 */
    recordRender(recordInfo = []) {
        this.vScroll.setDataList(recordInfo, SCROLL_VERTICAL, [0, 0, 0]);
        this.vScroll.scrollToTop(0);
        if (recordInfo.length <= 0) {
            this.node.getChildByName("Empty").getComponent(UIOpacity).opacity = 255;
        } else {
            this.node.getChildByName("Empty").getComponent(UIOpacity).opacity = 0;
        }
    }

    /** 切换tab */
    handleClickTab(event, data) {
        this.type = data;
        if (data == "1") {
            this.countBg.active = true;
            this.gameBg.active = false;
            this.getCountRecordInfo();
        } else if (data == "2") {
            this.countBg.active = false;
            this.gameBg.active = true;
            this.getGameRecordInfo();
        }
    }

    /** 返回首页 */
    handleClickBackBtn() {
        changeScene(HomeScene);
    }

}

