import { Asset, assetManager, AssetManager, ImageAsset, resources, SpriteFrame, Texture2D } from "cc";

namespace RES {

    export const bundles: { [key in string]: AssetManager.Bundle } = {};

    export function loadBundle(name: string) {
        const url = window["__remoteAssets__"] || "";
        return new Promise((resolve, reject) => {
            assetManager.loadBundle(url + name, (err, bundle) => {
                if (err !== null) {
                    console.log("[RES]:Load AssetsBundle Error: " + name);
                    bundles[name] = null;
                    reject(err);
                } else {
                    console.log("[RES]:Load AssetsBundle Success: " + name);
                    bundles[name] = bundle;
                    resolve(true);
                }
            });
        });
    }

    export const getRes = resources.get.bind(resources);

    export function loadRes<T extends Asset>(path: string, type?: typeof Asset): Promise<T | null> {
        return new Promise((resolve) => {
            resources.load(path, type, (err, asset: T) => {
                if (err) {
                    console.warn(`资源 ${path} 加载失败:`, err);
                    resolve(null);
                } else if (!asset) {
                    resolve(null);
                } else {
                    resolve(asset);
                }
            });
        });
    }


    export function loadRemote<T extends Asset>(url: string): Promise<T | null> {
        return new Promise(resolve => {
            assetManager.loadRemote(url, (err, asset: T) => {
                if (err || !asset) {
                    console.warn(`资源 ${url} 加载失败:`, err);
                    resolve(null);
                } else {
                    resolve(asset)
                }
            })
        })
    }

    export async function loadRemoteImg(url: string): Promise<Texture2D> {
        return await RES.loadRemote<Texture2D>(url);
    }

    export async function loadLocalImg(url: string): Promise<SpriteFrame> {
        return new Promise(resolve => {
            resources.load<ImageAsset>(url, (err, asset) => {
                if (err || !asset) {
                    console.warn(`资源 ${url} 加载失败:`, err);
                    resolve(null);
                } else {
                    resolve(SpriteFrame.createWithImage(asset));
                }
            })
        })
    }

    export function loadDir<T extends Asset>(path: string, onProgress: (finish: number, total: number) => void = () => 0): Promise<boolean> {
        // const bundle = bundles["resources"];
        // if (!bundle) {
        // 	console.warn("resources 未初始化");
        // }

        return new Promise((resolve) => {
            resources.loadDir(path, onProgress, (err, assets: Array<T>) => {
                if (err) {
                    console.warn(`资源 ${path} 加载失败:`, err);
                    resolve(false);
                } else {
                    resolve(true);
                }
            });
        });
    }
}
export default RES;
