import { _decorator, Component, Node, Button, Label, view, Widget, UITransform, Prefab, instantiate, UIOpacity, Color } from "cc";
import Panel from "db://assets/Module/Panel";
import { ScrollList, SCROLL_VERTICAL } from "../../ScrollList/ScrollList";
import TaskCenter from "../../TaskCenter";
import { LOG_TYPE, sendLog } from "../../Utils/WebNet/WebNet";
import { unwatchPageVisibility, watchPageVisibility } from "../../Utils/pageVisibilityNotify";
const { ccclass, property } = _decorator;
const MD_MAP = {
    0: 1,
    1: 2,
};

@ccclass("TaskPanel")
export class TaskPanel extends Panel {
  static bundle: string = "";
  static skin = "TaskPanel";
  static group = "TaskPanel";

  @property({ type: ScrollList, tooltip: "竖行滚动容器" })
  private vScroll: ScrollList;

  /** 关闭按钮 */
  @property(Node)
  closeBtn: Node = null;

  /** tab对象 */
  @property(Prefab)
  tebItem: Prefab = null;

  isClick: boolean = false;

  /** 首页节点 */
  homeNode: Node = null;

  async start() {
    // 20240227 去掉tab
    this.node.getChildByName("Tab").active = false
    this.closeBtn.on(Button.EventType.CLICK, this.closePannel, this);
    this.homeNode = this.data?.homeNode || {};
    this.setTaskBoxHeight();
    await TaskCenter.ins.getTaskInfo();
    this.pannelRender();

    watchPageVisibility(this.pageVChange)
  }

  /** 页面显示 */
  pageVChange = async (visible) => {
    console.log('页面', visible ? '可见' : '不可见')
    if (visible) {
      await TaskCenter.ins.getTaskInfo();
      this.taskRender();
    }
  }

  /** 渲染 */
  async pannelRender() {
    this.taskRender();
    // 20240227 去掉tab
    // this.tabRender();
  }

  /** 任务区域获取 */
  setTaskBoxHeight() {
    const taskCanvas = view.getVisibleSize();
    let taskHeightX = taskCanvas.height;
    /** 弹窗中的可滚动总区域，未减去屏幕差 */
    const tab = this.node.getChildByName("Tab");
    // let totalHeight = 1624 - tab.getComponent(Widget).top - tab.getComponent(UITransform).height / 2 - 70;
    // 20240227 去掉tab
    let totalHeight = 1624 - tab.getComponent(Widget).top - 20;
    /** 可滚动区域 */
    const taskListHeight = Math.max(totalHeight -(1624 - taskHeightX) / 2, 200);
    const taskList = this.node.getChildByName("ScrollView");
    const viewContent = taskList.getChildByName("view");
    viewContent.getComponent(UITransform).height = taskListHeight;
    taskList.getComponent(UITransform).height = taskListHeight;
    console.log("scrollView高度: ", taskListHeight);
  }

  /** 任务渲染 */
  async taskRender() {
    this.vScroll.setDataList(TaskCenter.ins.taskTabInfo, SCROLL_VERTICAL, [0, 0, 20], null, this.homeNode, this.node);
    this.vScroll.scrollToTop(0);
    this.logExposure();
  }

  /** tab 渲染 */
  tabRender() {
    for (let key of Object.keys(TaskCenter.ins.taskInfo)) {
      const node = instantiate(this.tebItem);
      node.getChildByName("TabName").getComponent(Label).string = key;
      if (TaskCenter.ins.tab == key) {
        node.getChildByName("Select").getComponent(UIOpacity).opacity = 255;
        node.getChildByName("TabName").getComponent(Label).color = new Color(195, 98, 12);
      }
      node.on(Button.EventType.CLICK, this.changeTab(key), this);
      this.node.getChildByName("Tab").addChild(node);
    }

  }

  /** 切换tab */
  changeTab(tabName: string) {
    return () => {
      if (this.isClick) return;
      this.isClick = true;
      setTimeout(() => {
        this.isClick = false;
      }, 500)
      TaskCenter.ins.setTab(tabName);
      /** tab更新 */
      for (let node of this.node.getChildByName("Tab").children) {
        const tabName = node.getChildByName("TabName");
        if (tabName.getComponent(Label).string == TaskCenter.ins.tab) {
          node.getChildByName("Select").getComponent(UIOpacity).opacity = 255;
          tabName.getComponent(Label).color = new Color(195, 98, 12);
        } else {
          node.getChildByName("Select").getComponent(UIOpacity).opacity = 0;
          tabName.getComponent(Label).color = new Color(255, 255, 255);
        }
      }
      /** 更新任务展示 */
      this.taskRender();
    }
  }

  /** 关闭弹窗 */
  closePannel() {
    this.hidePanel();
    unwatchPageVisibility(this.pageVChange)
  }

  /** 曝光 */
  logExposure() {
    const list = TaskCenter.ins.taskTabInfo;
    for (let item of list) {
      sendLog(LOG_TYPE.EXPOSURE, 11, 1, item.code, MD_MAP[item.taskStatus]);
    }
  }
}
