import Panel from "../../Module/Panel";
import { _decorator, assetManager, Button, ImageAsset, Label, Node, Sprite, SpriteFrame, Texture2D } from "cc";
import { changeScene } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import ShareCenter from "../ShareCenter";
import { SHARE_TYPE } from "../const";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@ccclass('PrizePanel')
export default class PrizePanel extends Panel {

    static bundle: string = "";
    static skin = "PrizePanel";
    static group = "PrizePanel";

    @property(Node)
    close: Node = null!;

    @property(Node)
    get: Node = null!;

    @property(Node)
    share: Node = null!;

    @property(Label)
    score: Label = null!;

    @property(Label)
    prizeName: Label = null!;

    @property(Sprite)
    img: Sprite = null!;

    async start() {
        sendLog(LOG_TYPE.EXPOSURE, 21);
        sendLog(LOG_TYPE.EXPOSURE, 22);
        this.close.on(Button.EventType.CLICK, this.onClose, this);
        this.get.on(Button.EventType.CLICK, this.onClose, this);
        this.share.on(Button.EventType.CLICK, this.onShare, this);

        const {prizeName, prizeImg, score} = this.data;

        this.score.string = `本次积分：${score}`;
        this.prizeName.string = prizeName;

        assetManager.loadRemote(prizeImg, (err, imageAsset) => {
            const texture = new Texture2D();
            texture.image = imageAsset;
            const sp = new SpriteFrame();
            sp.texture = texture;
            this.img.spriteFrame = sp;
        });
    }

    /**
     * 返回首页
     */
    onClose = () => {
        sendLog(LOG_TYPE.CLICK, 21)
        changeScene(HomeScene);
        this.hidePanel();
    }

    onShare = () => {
        // 去炫耀 分享
        sendLog(LOG_TYPE.CLICK, 22)
        ShareCenter.ins.doShare(SHARE_TYPE.FLAUNT)
    }

}
