import { _decorator, Component, Node, Button, Label } from "cc";
import Panel from "../../Module/Panel";
import { changeScene, hideAllPanel } from "../../Module/UIFast";
import GameMgr from "../GameMgr";
import { MainGame } from "../Scenes/MainGame";
import { LOG_TYPE, sendLog, sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";
const { ccclass, property } = _decorator;

@ccclass("BeautyPanel")
export class BeautyPanel extends Panel {
  static bundle: string = "";
  static skin = "BeautyPanel";
  static group = "BeautyPanel";

  /** 关闭按钮 */
  @property(Node)
  closeBtn: Node = null;
  /** 我知道了 */
  @property(Node)
  mainBtn: Node = null;

  start() {
    sendLog(LOG_TYPE.EXPOSURE, 13)
    this.mainBtn.on(Button.EventType.CLICK, this.handleClickMainBtn, this);
    this.closeBtn.on(Button.EventType.CLICK, this.closePannel, this);
    // this.pannelRender();
  }

  /** 渲染 */
  async pannelRender() {

  }

  /** 关闭弹窗 */
  closePannel() {
    this.hidePanel();
  }

  /** 跳转游戏 */
  async handleClickMainBtn() {
    sendLog(LOG_TYPE.CLICK, 13);
    hideAllPanel();
    try {
      const success = await GameMgr.ins.start();
      if (success) {
        await changeScene(MainGame);
      }
    } catch (e) {
      console.error(e);
    }
  }
}
