import Panel from "../../Module/Panel";
import { _decorator, Button, RichText } from "cc";
import { showPanel } from "../../Module/UIFast";
import ToolBuyConfirmPanel from "./ToolBuyConfirmPanel";
import { getWebData, LOG_TYPE, sendLog, WebNetName } from "../Utils/WebNet/WebNet";


const { ccclass, property } = _decorator;

@ccclass('ToolBuyPanel')
export default class ToolBuyPanel extends Panel {

    static skin = "ToolBuyPanel";
    static group = "ToolBuyPanel";


    async start() {
        const { data } = getWebData(WebNetName.index) || {}
        // 购买天降财神道具所需苏银豆
        const { buyRichSpSyd = 0 } = data
        this.view["RichText"].getComponent(RichText).string = `<color=#C62F3A>您可消耗</color><color=#fe0114><size=34><b>${buyRichSpSyd}</b></size></color><color=#C62F3A>苏银豆购买道具～</color>`;

        this.view["close"].on(Button.EventType.CLICK, this.hidePanel, this);
        this.view["buyBtn"].on(Button.EventType.CLICK, this.buyHandle, this);
        sendLog(LOG_TYPE.EXPOSURE, 38)
    }

    /** 立即购买 */
    async buyHandle() {
        sendLog(LOG_TYPE.CLICK, 38)
        this.hidePanel()
        showPanel(ToolBuyConfirmPanel)
    }

}
