import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node } from "cc";
import { changeScene } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import GameMgr from "db://assets/Scripts/GameMgr";
import { MainGame } from "db://assets/Scripts/Scenes/MainGame";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@ccclass('NoBoxPanel')
export default class NoBoxPanel extends Panel {

    static bundle: string = "";
    static skin = "NoBoxPanel";
    static group = "NoBoxPanel";

    @property(Node)
    close: Node = null!;

    @property(Node)
    cancel: Node = null!;

    @property(Node)
    ok: Node = null!;

    @property(Label)
    score: Label = null!;

    @property(Label)
    total: Label = null!;

    async start() {
        sendLog(LOG_TYPE.EXPOSURE, 26);
        sendLog(LOG_TYPE.EXPOSURE, 27);
        this.ok.on(Button.EventType.CLICK, this.onOk, this);
        this.close.on(Button.EventType.CLICK, this.onClose, this);
        this.cancel.on(Button.EventType.CLICK, this.onClose, this);

        const {totalScore, score,} = this.data;

        this.score.string = score.toString();
        this.total.string = `累计游园积分：${totalScore}`;
    }

    /**
     * 再来一局
     */
    onOk = async () => {
        sendLog(LOG_TYPE.CLICK, 27);
        this.btnEnable(this.ok, false);
        const success = await GameMgr.ins.start();
        this.btnEnable(this.ok, true);
        if (success) {
            changeScene(MainGame);
            this.hidePanel();
        }
    }

    /**
     * 返回首页
     */
    onClose = () => {
        sendLog(LOG_TYPE.CLICK, 26);
        changeScene(HomeScene);
        this.hidePanel();
    }

}
