import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, RichText } from "cc";
import { showPanel } from "../../Module/UIFast";
import ToolBuyConfirmPanel from "./ToolBuyConfirmPanel";
import store from "../../store/store";


const {ccclass, property} = _decorator;

@ccclass('ToolBuyPanel')
export default class ToolBuyPanel extends Panel {

    static skin = "ToolBuyPanel";
    static group = "ToolBuyPanel";

    @property(Label)
    tip: Label = null;

    @property(Node)
    close: Node = null;

    @property(Node)
    buyBtn: Node = null;


    async start() {
        const {buyRichSpCredits} = store.homeInfo;

        // this.view["RichText"].getComponent(RichText).string = `<color=#C62F3A>您可消耗</color><color=#fe0114><size=34><b>${buyRichSpCredits}</b></size></color><color=#C62F3A>积分购买道具～</color>`;
        this.tip.string = `您可消耗${buyRichSpCredits}积分购买道具～`;

        this.close.on(Button.EventType.CLICK, this.hidePanel, this);
        this.buyBtn.on(Button.EventType.CLICK, this.buyHandle, this);
    }

    /** 立即购买 */
    async buyHandle() {
        this.hidePanel()
        showPanel(ToolBuyConfirmPanel);
    }

}
