import { showPanel, showToast } from "../Module/UIFast";
import { sendWebNetWithToken, WebNetName } from "./Utils/WebNet/WebNet";
import { SHARE_TYPE } from "./const";
import ShareCenter from "./ShareCenter";
import PosterPanel from "./Panels/PosterPanel";
import BrowseImgPanel from "./Panels/BrowseImgPanel";
import store from "../store/store";
import { appJump, appJumpToMini } from "../AppTool";
import { getQueryParamValue, getUrlParam } from "./Utils/Utils";

const levelToast = {
    3: "恭喜您今日运势极佳，可领取3次挑战次数",
    2: "恭喜您今日运势上佳，可领取2次挑战次数",
    1: "恭喜您今日运势上等，可领取1次挑战次数",
};

const beforeDoComplete = (item: any, func: Function) => {
    const hasBtnText = !!item?.buttonText;
    const time = hasBtnText ? 1000 : 0;
    if (hasBtnText) {
        showToast(item?.buttonText);
    }
    setTimeout(() => {
        !!func && func();
    }, time);
}

export default class TaskCenter {

    static async doCompleted(taskCode: string) {
        const {success, data} = await sendWebNetWithToken(WebNetName.doCompleted, {taskCode: taskCode});
        if (!success) return;
        store.updateTask();
    }


    // 链接处理-二级页面
    //
    // 旭哥：
    // 1、bank_1401：进行手机话费充值-（A需要）
    // 2、bank_1406：开通生物识别登录方式--（待定-不确认）
    // 3、bt_2：跳转个人养老金页面-（A需要）
    // 4、bt_3：跳转月度账单月份列表页-（A需要）
    // 5、bt_4：跳转财富诊断功能-（应该需要）
    // 6、bt_5：跳转购买理财-（应该需要）
    // 7、bt_6：跳转购买基金（不需要）
    // 8、bt_7：跳转购买存款------（应该需要）
    // 9、bt_8：跳转积分明细--（A需要）
    // 10、bt_9：跳转亲子专区--（A需要）
    // 11、bt_10：跳转预约转账-（A需要）
    //
    //
    // bank_1406：开通生物识别登录方式--（待定-不确认）
    // 这个任务也有跳转链接，但是任务已完成，不确认

    // 基金  财富诊断  亲子专区返回的时候是回到手机银行首页的

    /** 任务处理中心 */
    static async handleClickTask(item: any = {}) {

        let {code, jumpUrl, id, title = ""} = item;

        /** 邀请任务 */
        if (code?.startsWith("it")) {
            beforeDoComplete(item, () => {
                ShareCenter.ins.doShare();
            });
            return;
        }

        const paramArr = title.split("@");

        const needNav = paramArr[1] == "1";
        const needUid = paramArr[2] == "1";
        const needBackParam = paramArr[3] == "1";

        if (needUid) {
            // 判断链接符号
            let symbol = jumpUrl.indexOf("?") == -1 ? "?" : "&";
            // 链接拼接，
            jumpUrl += `${symbol}cifCustomerNo=${store.baseInfo.uid}&channelCode=MOB001`;
        }

        /** 浏览任务 */
        if (code?.startsWith("bt_")) {
            if (code == "bt_real") {
                // 真浏览-浏览长图任务
                showPanel(BrowseImgPanel, {
                    panelType: "topNoScale",
                    doneFun: async () => {
                        const {success, data} = await sendWebNetWithToken(
                            WebNetName.finishBrowseTask,
                            {taskCode: code, taskId: id}
                        );
                        if (!success) return;
                        store.updateTask();
                    }
                })
            } else if (code == "bt_mrys") {
                // 浏览每日运势任务
                showPanel(PosterPanel, {
                    sharedFun: async (level) => {
                        const {success, data} = await sendWebNetWithToken(
                            WebNetName.finishBrowseTask,
                            {taskCode: code, taskId: id, ysLevel: level}
                        );
                        if (!success) return;
                        store.updateTask();
                        showToast(levelToast[level]);
                    }
                });
            } else if(code == "bt_13"){
                beforeDoComplete(item, async () => {
                    await sendWebNetWithToken(
                        WebNetName.finishBrowseTask,
                        {taskCode: code, taskId: id}
                    );
                    window["MarsJSBridge"].invoke("toggleAppMode", {
                        funcType: "1" // 1: 跳转到设置页面 , 其他: 跳到应用设置页面
                    }, function() {
                        // 没有回调
                    });

                    window["MarsJSBridge"].invoke("popPage", {
                        matchUri: "https://mobapp.czbank.com/homeChanels/home.html" // 1: 跳转到设置页面 , 其他: 跳到应用设置页面
                    }, function() {
                        // 没有回调
                    });
                    // location.href = jumpUrl;
                    //获取跳转方式
                    // let type = getQueryParamValue(jumpUrl, "type");
                    // console.info("跳转方式type", type)
                    // if (type == "1") { //跳转方式1
                    //     (jumpUrl && jumpUrl != '/') && appJump(jumpUrl, needNav);
                    // } else if (type == "2") {//跳转方式2
                    //     appJumpToMini(
                    //         "username",
                    //         jumpUrl,
                    //     );
                    // } else { //不拼方式不跳了，害怕跳错了
                    //
                    // }
                });
            } else {
                beforeDoComplete(item, async () => {
                    await sendWebNetWithToken(
                        WebNetName.finishBrowseTask,
                        {taskCode: code, taskId: id}
                    );
                    (jumpUrl && jumpUrl != '/') && appJump(jumpUrl, needNav);

                    // location.href = jumpUrl;
                    //获取跳转方式
                    // let type = getQueryParamValue(jumpUrl, "type");
                    // console.info("跳转方式type", type)
                    // if (type == "1") { //跳转方式1
                    //     (jumpUrl && jumpUrl != '/') && appJump(jumpUrl, needNav);
                    // } else if (type == "2") {//跳转方式2
                    //     appJumpToMini(
                    //         "username",
                    //         jumpUrl,
                    //     );
                    // } else { //不拼方式不跳了，害怕跳错了
                    //
                    // }

                });
            }

            return;
        }

        /** 行方任务 */
        if (code?.startsWith("bank_")) {
            console.info('11111')
            beforeDoComplete(item, async () => {
                // if (!item?.extra || item?.extra == 0) { // 未领取任务 调领取行方任务接口
                //     await sendWebNetWithToken(
                //         WebNetName.claimThirdTask,
                //         {taskCode: code, taskId: id}
                //     );
                // }
                // const type = code.split("_")[1];
                // if (type == "t") { // 行方交易任务
                //     appJump(jumpUrl, needNav)
                // } else if (type == "s") { // 行方签约任务
                //     appJump(ju mpUrl, needNav)
                // }
                // location.href = jumpUrl;
                console.info('jumpUrl', jumpUrl);
                (jumpUrl && jumpUrl != '/') && appJump(jumpUrl, needNav);
            });
            return;
        }


        /** 会员等级达标任务 */
        if (code == 'hydjdb') {
            // 能给链接跳转 就配置正常配置jumpUrl
            // 不能跳转 jumpUrl配置$$$ 需要toast提示就配置buttonText
            beforeDoComplete(item, () => {
                (jumpUrl && jumpUrl != '/') && appJump(jumpUrl, needNav);
            });
            return;
        }
    }

    /** 领取奖励 */
    static async receivePrize(item) {
        const {code, prizePendingCode} = item;


        const {success, data} = await sendWebNetWithToken(
            WebNetName.sendPrize,
            {taskCode: code, prizePendingCode}
        );
        if (!success) return;

        store.updateTask();
        store.updateIndex();
        showToast("任务完成，奖励已发放");
    }

}
