import { showToast } from "./Module/UIFast";
import { sendWebNet } from "./Scripts/Utils/WebNet/WebNet";
import { ajax } from "./Scripts/Utils/WebNet/web/ajax";


export function isIos() {
    return navigator.userAgent.match(/iphone|ipod|ipad/gi)
}

export function popPage() {
    window["MarsJSBridge"].invoke("popPage", {
        index: -1,
        data: {},
    });
}

export function disableGestureReturn() {
    try {
        if (isIos()) {
            window["MarsJSBridge"].invoke("setGestureHandle", {
                enable: 0,
            });
        } else {
            window["MarsJSBridge"].invoke("setInterceptBack", {
                enableIntercept: true,
                function(res) {
                    // console.log("截断物理返回");
                },
            });
        }
    } catch (e) {
        console.log("disableGestureReturn error", e);
    }
}

export function isLogin() {
    return new Promise((resolve) => {
        window["MarsJSBridge"].invoke("isLogin", {},
            function (res) {
                resolve(res?.result?.isLogin);
            });
    });
}

export function appJump(url) {
    console.info('22222')
    sendWebNet("/autoLogin/tempSaveCookie", null, null, true)
    .then((res) => {
            console.info('3333')
            res?.data && localStorage.setItem("db_zheshang_cookie", res.data);
        })
        .finally(() => {
            console.info('44444')
            window["MarsJSBridge"].invoke("pushPage", {
                uri: url,
            });
        })
}


export function resetBackCookie(duibaTempCookieId) {
    return new Promise(async (resolve) => {
        ajax({
            url: "/autoLogin/resetCookie", //请求地址
            type: 'GET',   //请求方式
            data: {duibaTempCookieId}, //请求参数
            dataType: "json",     // 返回值类型的设定,暂时只有json
            async: true,   //是否异步
            success: () => {
                resolve('success');
            },
            error: (e) => {
                resolve(e);
            },
        });
    });
}

// 接口请求
export function appRequest(url, params = {}) {
    const options = Object.assign({
        url
    }, params);
    console.log('接口请求options: ', options);
    return new Promise((resolve, reject) => {
        window["MarsJSBridge"]?.invoke('httpRequest', options, res => {
            console.log('接口请求res: ', res);
            // 如果调用失败则返回失败结果
            if (res && res.code && res.code !== '0') {
                reject(res);
            } else {
                if (res.result.code === "0") {
                    // 如果请求成功
                    resolve(res.result);
                } else {
                    // 如果成功获得返回但是近回的状态码异常则返回请求结果
                    reject(res);
                }
            }
        });
    });
}

export function saveFunc(imageUrl) {
    window["MarsJSBridge"]?.invoke(
        "jsToWeChatShare", {
            saveAlbum: "1", // 11保存相册 1打开保存相册入口 0关闭入口
            weChatMoments: "0", // 分享到朋友圈 1-打开分享到朋友圈入口 0-关闭入口
            friendList: "0", // 分享给好友 1-打开分享给好友入口 0-关闭入口
            url: "xxx", // 链接地址
            image: imageUrl, // 保存分享图片
            simplelmage: "xx", // 分享链接缩略图 缩略图大小不超过64K
            description: "xx", // 内容简介
        },
        function (res) {
            console.log(res);
        }
    );
}

let appSystemInfo = null;


// 获取系统信息
export async function getSystemInfo() {
    if (!appSystemInfo) {
        await new Promise<void>((resolve) => {
            window["MarsJSBridge"]?.invoke('getSystemInfo', {}, res => {
                appSystemInfo = res.result;
                resolve();
            });
        });
    }
    return appSystemInfo;
}

// 分享 拉起面板的版本
export async function appShareWx(options) {
    const {
        saveAlbum = '0',
        weChatMoments = '1',
        friendList = '1',
        url = '',
        imageBase64 = '',
        simpleImage = '',
        title = '',
        description = '',
    } = options || {};

    const appSystemInfo = await getSystemInfo();

    if (compareVersion(appSystemInfo?.version, '5.0.12') != -1) {
        window["MarsJSBridge"]?.invoke("jsToWeChatShare", {
            saveAlbum: saveAlbum, // 保存相册     1 打开保存相册入口     0 关闭入口
            weChatMoments: weChatMoments, // 分享到朋友圈  1 打开分享到朋友圈入口  0 关闭入口
            friendList: friendList, // 分享给好友   1 打开分享给好友入口    0 关闭入口
            url: url, // 链接地址
            image: imageBase64, // 保存分享图片 base64
            simpleImage: simpleImage, // 分享链接缩略图 备:图大小不超过64K
            title: title, // 标题
            description: description, // 内容简介
        }, res => {
            console.log('weChat', res);
            if (res.code === '0') {
                console.log('分享成功');
            } else if (res.code === '1') {
                showToast(res.result);
            }
        });
    } else {
        showToast('当前版本暂未支持，请升级最新版本。');
    }
}

/**
 * 版本比较方法
 * 1: V1 > V2
 * 0: V1 = V2
 * -1: v1 < V2
 */
export function compareVersion(v1, v2) {
    console.log('compareVersion v1===> ', v1);
    console.log('compareVersion v2===> ', v2);
    v1 = v1?.split(".") || [];
    v2 = v2.split(".");
    const len = Math.max(v1.length, v2.length);
    // 调整两版本号位数相同
    while (v1.length < len) {
        v1.push('0');
    }
    while (v2.length < len) {
        v2.push('0');
    }
    // 遍历每位大小
    for (let i = 0; i < len; i++) {
        const num1 = parseInt(v1[i]);
        const num2 = parseInt(v2[i]);
        if (num1 > num2) {
            return 1;
        } else if (num1 < num2) {
            return -1;
        }
    }
    return 0;
}

// 分享
export function shareFunc(type, imageUrl) {
    window["MarsJSBridge"]?.invoke(
        "jsToSaveAlbumOrShareWeChat", {
            type: type, // 0-保存相册 1-微信好友 2-微信朋友圈
            image: imageUrl, // base64后的数据 不超过64k
            // url, // 分享链接
            // title, // 链接标题
            // description, // 简介内容
        },
        (res) => {
            // 返回值:{code:"0",message:"",result:""}
            // code:0 成功
            // code:1 失败, message:1(取图片失败)/2(未安装微信)/3(没有相册读取权限),result:失败原因;
            // 注意事项:
            // 1.type='0' 保存相册 除了相册权限问题message为3,其它情况message和result都为空
            // 2.type='1' 微信分享 除了微信未安装message为2,其它情况message为空,取result值结果
            // 3.解析imagebase64数据失败 message为1
            console.log('jsToSaveAlbumOrShareWeChat res ===> ', res);
            if (typeof res === 'string') {
                res = res ? JSON.parse(res) : {}
            }
            const {
                code,
                result
            } = res
            if (type == '0') { // 保存
                if (code == '0') {
                    showToast("已保存到本地照片")
                } else {
                    showToast(result || "保存失败")
                }
            } else { // 分享
                if (code == '1') {
                    showToast(result || "分享失败")
                }
            }
        }
    );
}


// 获取登录状态
export function getLoginStatus() {
    return new Promise((resolve) => {
        window["MarsJSBridge"]?.invoke('isLogin', {}, res => {
            resolve(res.result)
        })
    })
}


export const appShare = (shareParams) => {
    return new Promise((r) => {
        window['MarsJSBridge'].invoke("jsToWeChatShare", {
            saveAlbum: '0', // 保存相册        1 打开保存相册入口           0 关闭入口
            weChatMoments: '1', // 分享到朋友圈 1 打开分享到朋友圈入口    0 关闭入口
            friendList: '1', // 分享给好友     1 打开分享给好友入口        0 关闭入口
            url: shareParams.url, // 链接地址
            // image: '', // 保存分享图片
            simpleImage: shareParams.thumbnail, // 分享链接缩略图 备：缩略图大小不超过64K
            title: shareParams.title, // 标题
            description: shareParams.content, // 内容简介
        }, function (res) {
            console.log(11111, res);
            r(res);
            // 返回值: {code:'0',message:'', result:'xxx'}
            // {
            //   code: '1',
            //   message: '1',
            //   result: '读取图片失败'
            // } {
            //   code: '1',
            //   message: '2',
            //   result: '手机未安装微信'
            // } {
            //   code: '1',
            //   message: '3',
            //   result: '没有相册权限'
            // }
        });
    });
}
