declare module "cc" {
    /**
     * @en
     * Predefined constants, see [[Macro]] for detailed contents.
     * @zh
     * Ԥ峣ݲο [[Macro]] ĵ
     */
    export const macro: Macro;
    /**
     * @en
     * Predefined constants, see [[Macro]] for detailed contents.
     * @zh
     * Ԥ峣ݲο [[Macro]] ĵ
     */
    /**
     * @en Interface declaration for predefined constants, for usage you should be importing [[macro]] directly.
     * @zh Ԥ峣ĽӿʵʹӦֱӵ [[macro]]
     */
    export interface Macro {
        /**
         * @en
         * The image format supported by the engine, the actual supported formats may differ in different build platforms and device types.
         * Currently contains ['.astc', '.pkm', '.pvr', '.webp', '.jpg', '.jpeg', '.bmp', '.png'].
         * @zh
         * Ĭֵ֧ͼƬʽʵʱֵ֧ĸʽڲͬĹƽ̨豸
         * Ŀǰĸʽ ['.astc', '.pkm', '.pvr', '.webp', '.jpg', '.jpeg', '.bmp', '.png']
         */
        SUPPORT_TEXTURE_FORMATS: string[];
        /**
         * @en Key map for keyboard event
         * @zh ¼İֵ
         * @example {@link cocos/core/platform/CCCommon/KEY.js}
         * @deprecated since v3.3 please use [[KeyCode]] instead
         */
        KEY: typeof __private._cocos_core_platform_macro__KEY;
        /**
         * @en One angle in radian, equals to PI / 180
         * @zh еĵλǶȣͬ PI / 180
         */
        RAD: number;
        /**
         * @en One radian in angle, equals to 180 / PI
         * @zh Ƕеĵλȣͬ 180 / PI
         */
        DEG: number;
        /**
         * @en A maximum value of number representing infinity repeat times
         * @zh ظִеֵʵȡֵΪֵֵ
         */
        REPEAT_FOREVER: number;
        /**
         * @en A float value for representing a minimum error in comparison
         * @zh ڱȽʱɺԵĸֵ
         */
        FLT_EPSILON: number;
        /**
         * @en Oriented vertically
         * @zh 
         */
        ORIENTATION_PORTRAIT: number;
        /**
         * @en Inverted portrait orientation, with the device bottom facing upward.
         * @zh 豸ײ
         */
        ORIENTATION_PORTRAIT_UPSIDE_DOWN: number;
        /**
         * @en Oriented horizontally. Users cannot directly listen to this value; they need to listen for ORIENTATION_LANDSCAPE_LEFT or ORIENTATION_LANDSCAPE_RIGHT.
         * @zh , ⲿֱӼֵҪ ORIENTATION_LANDSCAPE_LEFT  ORIENTATION_LANDSCAPE_RIGHT
         */
        ORIENTATION_LANDSCAPE: number;
        /**
         * @en Oriented horizontally, top side facing to the left. Supported only on mobile devices.
         * @zh ˮƽ򣬶;ƶ֧
         */
        ORIENTATION_LANDSCAPE_LEFT: number;
        /**
         * @en Oriented horizontally, top side facing to the right. Supported only on mobile devices.
         * @zh ˮƽ򣬶Ҳ;ƶ֧
         */
        ORIENTATION_LANDSCAPE_RIGHT: number;
        /**
         * @en Oriented automatically
         * @zh Զ䳯
         */
        ORIENTATION_AUTO: number;
        /**
         * @en
         * Whether or not enabled tiled map auto culling. If you set the TiledMap skew or rotation,
         * then need to manually disable this, otherwise, the rendering will be wrong.
         * Currently not used in 3D engine
         * @zh
         * ǷƬͼԶüܡƬͼ skew, rotation ĻҪֶرգȾ
         *  3D ʱЧ
         * @default true
         * @deprecated since v3.0
         */
        ENABLE_TILEDMAP_CULLING: boolean;
        /**
         * @en
         * The timeout to determine whether a touch is no longer active and should be removed.
         * The reason to add this timeout is due to an issue in X5 browser core,
         * when X5 is presented in wechat on Android, if a touch is glissed from the bottom up, and leave the page area,
         * no touch cancel event is triggered, and the touch will be considered active forever.
         * After multiple times of this action, our maximum touches number will be reached and all new touches will be ignored.
         * So this new mechanism can remove the touch that should be inactive if it's not updated during the last 5000 milliseconds.
         * Though it might remove a real touch if it's just not moving for the last 5 seconds,
         * which is not easy with the sensibility of mobile touch screen.
         * You can modify this value to have a better behavior if you find it's not enough.
         * @zh
         * һǷѾʧЧҿԱƳʱʱ
         * ʱԭ X5 ں΢гֵһ bug
         * £ûһӵƳҳ򣬽ᴥκ touch cancel  touch end ¼ᱻԶͣҳϵЧ㡣
         * ظ֮ĻϵĴﵽǵ¼ϵͳֵ֧ߴ֮еĴ¼ԡ
         * µĻƿڴһʱûκθµΪʧЧ㲢¼ϵͳƳ
         * ȻҲƳһʵĴ㣬ûĴһʱȫûƶڵǰֻĻ»ѣ
         * ޸ֵҪЧĬֵ 5000 롣
         * @default 5000
         */
        TOUCH_TIMEOUT: number;
        /**
         * @en
         * Boolean that indicates if the canvas contains an alpha channel, default sets to false for better performance.
         * Though if you want to make your canvas background transparent and show other dom elements at the background,
         * you can set it to true before [[game.init]].
         * Web only.
         * @zh
         *  Canvas Ƿ֧ alpha ͨĬΪ falseиߵܱ֡
         * ϣ Canvas ͸ģʾ DOM Ԫأ [[game.init]] ֮ǰֵΪ true
         * ֧ Web
         * @default false
         */
        ENABLE_TRANSPARENT_CANVAS: boolean;
        /**
         * @en
         * Boolean that indicates if the GL context is created with `antialias` option turned on, default value is false.
         * Set it to true could make your game graphics slightly smoother, like texture hard edges when rotated.
         * Whether to use this really depend on your game design and targeted platform,
         * device with retina display usually have good detail on graphics with or without this option,
         * you probably don't want antialias if your game style is pixel art based.
         * Also, it could have great performance impact with some browser / device using software MSAA.
         * You can set it to true before [[game.init]].
         * Only affect OpenGL ES and WebGL backend
         * @zh
         * ڴ GL Context ʱǷѡĬֵ false
         * ѡΪ true ϷƽһЩתӲͼʱľݡǷѡ̶ܴȡϷƽ̨
         * ڴӵ retina Ļ豸û޷ѡı仯ϷѡҲ벻뿪ѡ
         * ͬʱٲʹ𿹾㷨豸ϣѡܲȽϴӰ졣
         *  [[game.init]] ֮ǰֵЧ
         * Ӱ WebGL 
         * @default true
         */
        ENABLE_WEBGL_ANTIALIAS: boolean;
        /**
         * @en
         * Used to set float output render target, more accurate multiple light sources, fog, and translucent effects, custom pipeline only, the default value is false.
         * @zh
         * ڿʽRT, ȷĶԴͰ͸Ч, Զ, ĬֵΪ false
         * @default false
         */
        ENABLE_FLOAT_OUTPUT: boolean;
        /**
         * @en
         * Whether to clear the original image cache after uploaded a texture to GPU.
         * If cleared, [Dynamic Atlas](https://docs.cocos.com/creator/manual/en/advanced-topics/dynamic-atlas.html) will not be supported.
         * Normally you don't need to enable this option on the web platform, because Image object doesn't consume too much memory.
         * But on Wechat Game platform, the current version cache decoded data in Image object, which has high memory usage.
         * So we enabled this option by default on Wechat, so that we can release Image cache immediately after uploaded to GPU.
         * Currently not useful in 3D engine
         * @zh
         * Ƿڽͼϴ GPU ֮ɾԭʼͼƬ棬ɾ֮ͼƬ޷ [̬ͼ](https://docs.cocos.com/creator/manual/zh/advanced-topics/dynamic-atlas.html)
         *  Web ƽ̨ͨҪѡΪ Web ƽ̨ Image ռõڴС
         * ΢СϷƽ̨ĵǰ汾Image ỺͼƬݣռõڴռܴ
         * ΢ƽ̨ĬϿѡǾͿϴ GL ͼ֮ͷ Image ڴ棬ߵڴռá
         *  3D ʱЧ
         * @default false
         */
        CLEANUP_IMAGE_CACHE: boolean;
        /**
         * @en
         * Whether to enable multi-touch.
         * @zh
         * Ƿ㴥
         * @default true
         */
        ENABLE_MULTI_TOUCH: boolean;
        /**
         * @en
         * The maximum size of the canvas pool used by Label, please adjust according to the number of label component in the same scene of the project
         * @zh
         * Label ʹõ canvas pool СĿͬ label е
         * @default 20
         */
        MAX_LABEL_CANVAS_POOL_SIZE: number;
        /**
         * @en
         * Boolean that indicates if enable highp precision data in structure with fragment shader.
         * Enable this option will make the variables defined by the HIGHP_VALUE_STRUCT_DEFINE macro in the shader more accurate, such as position.
         * Enable this option can avoid some distorted lighting effects. That depends on whether your game has abnormal lighting effects on this platform.
         * There will be a slight performance loss if enable this option, but the impact is not significant.
         * Only affect WebGL backend
         * @zh
         * ǷƬԪɫʹýṹʱеʹhighp
         * ѡΪ true shaderʹHIGHP_VALUE_STRUCT_DEFINE궨ıȸߣλϢȣһЩʧĹЧǷѡ̶ܴȡϷڴƽ̨Ƿ쳣ı֡
         * ΢ʧӰ첻
         * Ӱ WebGL 
         * @default false
         */
        ENABLE_WEBGL_HIGHP_STRUCT_VALUES: boolean;
        /**
         * @zh Batcher2D ڴĴСKB
         * ֵ˵дڵ 2d ȾĶǰ batcher2D пɵĶʱڴ
         * ֵԽ󣬹ͬһ meshBuffer  2d Ⱦ࣬ÿռõڴҲ
         * Ĭֵڱ׼ʽ[[VertexFormat.vfmtPosUvColor]]¿ 4096 㣨4096*9*4/1024ÿοɵԪ
         * @en The MeshBuffer chunk size in Batcher2D (KB)
         * This value determines the increase in memory expansion,
         * when the number of vertices of 2d rendering components present in the scene exceeds the number of vertices,
         * that can be accommodated in the current batcher2D.
         * The larger this value is, the more 2d rendering components will share the same meshBuffer, but the more memory will be used for each expansion
         * The default size can contain 4096 standard vertex ([[VertexFormat.vfmtPosUvColor]]) in one buffer,
         * you can user larger buffer size to increase the elements count per 2d draw batch.
         * @default 144 KB
         */
        BATCHER2D_MEM_INCREMENT: number;
        /**
         * @zh ԶȾߵ֣ʵԣ
         * ִӦȾߣWebƽ̨ΪգԶȾߡ
         * Ŀǰ֧'Forward', 'Deferred'֡
         * @en The name of custom rendering pipeline (experimental)
         * Engine will use the name to create the custom pipeline (Web only). If the name is empty, custom pipeline will be disabled.
         * Currently only 'Forward' and 'Deferred' are supported.
         */
        CUSTOM_PIPELINE_NAME: string;
        /**
         * @internal
         */
        init(): void;
    }
    /**
     * @en JS Implementation of MurmurHash2. Original implementation is http://github.com/garycourt/murmurhash-js.
     * @zh MurmurHash2  JS ʵ֡ԭʼʵ http://github.com/garycourt/murmurhash-js 
     * @param input @en ASCII string or a Uint8Array to be hashed. @zh ϣϣ ASCII ַ Uint8Array.
     * @param seed @en Hash seed. Should be a positive integer. @zh ϣӡǸ
     * @returns @en 32-bit positive integer hash. @zh 32λϣֵ
     */
    export function murmurhash2_32_gc(input: string | Uint8Array, seed: number): number;
    export class ReflectionProbeManager {
        static probeManager: ReflectionProbeManager;
        /**
         * @en Set and get whether to detect objects leaving or entering the reflection probe's bounding box at runtime.
         * @zh úͻȡǷʱ뿪߽뷴̽İΧС
         */
        set updateForRuntime(val: boolean);
        get updateForRuntime(): boolean;
        /**
         * @en Refresh all reflection probe.
         * @zh ˢз̽롣
         */
        onUpdateProbes(): void;
        /**
         * @en filter models that use planar reflection.
         * @zh ɸѡʹƽ淴ģ
         */
        filterModelsForPlanarReflection(): void;
        /**
         * @en Get all reflection probes in the scene.
         * @zh ȡеķ̽
         */
        getProbes(): renderer.scene.ReflectionProbe[];
        /**
         * @en Get reflection probe by id.
         * @zh idȡ̽
         */
        getProbeById(probeId: number): renderer.scene.ReflectionProbe | null;
        /**
         * @en Update the cubemap captured by the reflection probe.
         * @zh ·̽벶cubemap
         * @param probe update the texture for this probe
         */
        updateBakedCubemap(probe: renderer.scene.ReflectionProbe): void;
        /**
         * @en Update the plane reflection map for reflection probe render.
         * @zh ·̽Ⱦƽ淴ͼ
         * @param probe update the texture for this probe
         */
        updatePlanarMap(probe: renderer.scene.ReflectionProbe, texture: gfx.Texture | null): void;
        /**
         * @en Selecting the appropriate reflection probe for the model, it will use the closest one based on distance.
         * @zh Ϊģѡõķ̽룬ʹþġ
         * @param model select for this model
         */
        selectReflectionProbe(model: renderer.scene.Model): void;
        /**
         * @en Update the preview sphere of the Reflection Probe cube mode.
         * @zh ·̽cubeģʽԤ
         */
        updatePreviewSphere(probe: renderer.scene.ReflectionProbe): void;
        /**
         * @en Update the preview plane of the Reflection Probe planar mode.
         * @zh ·̽Ԥƽ
         */
        updatePreviewPlane(probe: renderer.scene.ReflectionProbe): void;
        /**
         * @en Update reflection probe data of model bind.
         * @zh ģͰ󶨵ķ̽ݡ
         */
        updateProbeData(): void;
        /**
         * @en get max value of probe id.
         * @zh ȡ̽idֵ
         */
        getMaxProbeId(): number;
        /**
         * @en Get the reflection probe used by the model.
         * @zh ȡģʹõķ̽롣
         */
        getUsedReflectionProbe(model: renderer.scene.Model, planarReflection: boolean): renderer.scene.ReflectionProbe | null | undefined;
        /**
         * @en Set reflection probe used by the model.
         * @zh ֶģʹõķ̽롣
         * @param model set the probe for this model
         * @param probe reflection probe to be set
         * @param blendProbe reflection probe for blend
         */
        setReflectionProbe(model: renderer.scene.Model, probe: renderer.scene.ReflectionProbe, blendProbe?: renderer.scene.ReflectionProbe | null): void;
    }
    /**
     * @en Mesh buffer used for 2d rendering, used internally and not of concern to the user.
     * @zh 2d Ⱦʹõ񻺳ݣڲʹãûġ
     * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
     */
    export class MeshBuffer {
        /**
         * @en The vertex attributes of the buffer.
         * @zh buffer Ķԡ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get attributes(): gfx.Attribute[];
        /**
         * @en Number of bytes in vertex format.
         * @zh ʽֽ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get vertexFormatBytes(): number;
        protected _byteOffset: number;
        /**
         * @en byte offset.
         * @zh ֽƫ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get byteOffset(): number;
        set byteOffset(val: number);
        protected _vertexOffset: number;
        /**
         * @en Vertexes offset.
         * @zh ƫơ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get vertexOffset(): number;
        set vertexOffset(val: number);
        protected _indexOffset: number;
        /**
         * @en Indices offset.
         * @zh ƫơ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get indexOffset(): number;
        set indexOffset(val: number);
        protected _dirty: boolean;
        /**
         * @en Dirty flag.
         * @zh ǡ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get dirty(): boolean;
        set dirty(val: boolean);
        protected _floatsPerVertex: number;
        /**
         * @en Float numbers per vertex.
         * @zh ÿĸȡ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get floatsPerVertex(): number;
        set floatsPerVertex(val: number);
        protected _vData: Float32Array;
        /**
         * @en Vertexes data.
         * @zh ݡ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get vData(): Float32Array;
        set vData(val: Float32Array);
        protected _iData: Uint16Array;
        /**
         * @en Indices data.
         * @zh ݡ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get iData(): Uint16Array;
        set iData(val: Uint16Array);
        protected _nativeObj: __private._cocos_2d_renderer_native_2d__NativeUIMeshBuffer;
        /**
         * @en Native object.
         * @zh ԭ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get nativeObj(): __private._cocos_2d_renderer_native_2d__NativeUIMeshBuffer;
        protected _sharedBuffer: Uint32Array;
        /**
         * @en Native shared buffer.
         * @zh ԭ塣
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get sharedBuffer(): Uint32Array;
        /**
         * @en Initial native shared buffer.
         * @zh ʼԭ塣
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        initSharedBuffer(): void;
        /**
         * @en Synchronized native shared buffer.
         * @zh ͬԭ塣
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        syncSharedBufferToNative(): void;
        constructor();
        /**
         * @en Initialize mesh buffer.
         * @zh ʼ
         * @param device @en The GFX device. @zh GFX豸
         * @param attrs @en The vertex attributes of the buffer. @zh Ķԡ
         * @param vFloatCount @en The vertexes float count. @zh ÿ float 
         * @param iCount @en The indices count. @zh 
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        initialize(device: gfx.Device, attrs: gfx.Attribute[], vFloatCount: number, iCount: number): void;
        /**
         * @en Reset state.
         * @zh ״̬
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        reset(): void;
        destroy(): void;
        /**
         * @en Set dirty flag.
         * @zh ǩ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setDirty(): void;
        /**
         * @deprecated since v3.4.0, please use BufferAccessor's request
         * @see [[BufferAccessor.request]]
         */
        request(vertexCount: number, indexCount: number): boolean;
        /**
         * @en require Free input assembler.
         * @zh õ㼯
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        requireFreeIA(device: gfx.Device): gfx.InputAssembler;
        /**
         * @en recycle input assembler.
         * @zh 㼯
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        recycleIA(ia: gfx.InputAssembler): void;
        /**
         * @en check capacity.
         * @zh ɷ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        checkCapacity(vertexCount: number, indexCount: number): boolean;
        /**
         * @en Upload and update buffers data.
         * @zh ϴ»ݡ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        uploadBuffers(): void;
    }
    /**
     * @en Stencil state manager.
     * @zh ģ״̬
     * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
     */
    export class StencilManager {
        static sharedManager: StencilManager | null;
        /**
         * @en Stencil stage.
         * @zh ģ建׶Ρ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get stage(): __private._cocos_2d_renderer_stencil_manager__Stage;
        set stage(val: __private._cocos_2d_renderer_stencil_manager__Stage);
        /**
         * @en Stencil pattern.
         * @zh ģ建ʽ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get pattern(): {
            stencilTest: boolean;
            func: gfx.ComparisonFunc;
            stencilMask: number;
            writeMask: number;
            failOp: gfx.StencilOp;
            zFailOp: gfx.StencilOp;
            passOp: gfx.StencilOp;
            ref: number;
        };
        /**
         * @en Add mask nesting.
         * @zh maskǶס
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        pushMask(mask: any): void;
        /**
         * @en clear stencil stage.
         * @zh ģ״̬
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        clear(comp: UIRenderer | UIMeshRenderer): __private._cocos_2d_renderer_stencil_manager__Stage;
        /**
         * @en Open stencil stage to enabled.
         * @zh ģ״̬
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        enableMask(): void;
        /**
         * @en exit stencil.
         * @zh ˳ģ״̬
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        exitMask(): void;
        /**
         * @en Get write mask count.
         * @zh ȡдģ建λ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getWriteMask(): number;
        /**
         * @en Get write mask count when exit.
         * @zh ȡ˳ʱģ建λ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getExitWriteMask(): number;
        /**
         * @en Get mask nesting count.
         * @zh ȡmaskǶ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getMaskStackSize(): number;
        /**
         * @en Reset stencil stage.
         * @zh ģ״̬
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        reset(): void;
        destroy(): void;
        /**
         * @en Get stencil stage.
         * @zh ȡģ״̬
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getStencilStage(stage: __private._cocos_2d_renderer_stencil_manager__Stage, mat?: Material): gfx.DepthStencilState;
        /**
         * @en Get stencil hash.
         * @zh ȡģ״̬Ĺϣֵ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        getStencilHash(stage: __private._cocos_2d_renderer_stencil_manager__Stage): number;
    }
    export const spriteAssembler: IAssemblerManager;
    export const labelAssembler: IAssemblerManager;
    export const graphicsAssembler: IAssemblerManager;
    /**
     * @en
     * Class for sprite atlas handling.
     * @zh
     * ͼԴࡣ
     */
    export class SpriteAtlas extends Asset {
        /**
         * @en All sprite frames in the sprite atlas.
         * @zh ͼео顣
         */
        spriteFrames: __private._cocos_2d_assets_sprite_atlas__ISpriteFrameList;
        /**
         * @en Get the [[Texture2D]] asset of the atlas.
         * @zh ȡͼͼ
         * @returns @en The texture2d asset. @zh άͼԴ
         */
        getTexture(): __private._cocos_asset_assets_texture_base__TextureBase | null;
        /**
         * @en Gets the [[SpriteFrame]] correspond to the given key in sprite atlas.
         * @zh ݼֵȡ顣
         *
         * @param key @en The SpriteFrame name. @zh ֡
         * @returns @en The SpriteFrame asset. @zh Դ
         */
        getSpriteFrame(key: string): SpriteFrame | null;
        /**
         * @en Returns all sprite frames in the sprite atlas.
         * @zh ȡͼо顣
         * @returns @en All sprite frames. @zh еľԴ
         */
        getSpriteFrames(): (SpriteFrame | null)[];
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _serialize(ctxForExporting: any): any;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _deserialize(serializeData: any, handle: any): void;
    }
    /**
     * @en Class for TTFFont asset.
     * @zh TTF Դࡣ
     */
    export class TTFFont extends Font {
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _fontFamily: string | null;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _nativeAsset(): string | null;
        set _nativeAsset(value: string | null);
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _nativeDep(): {
            uuid: string;
            __nativeName__: string;
            ext: string;
            __isNative__: boolean;
        };
        /**
         * @en default init.
         * @zh Ĭϳʼ
         * @param uuid @en Asset uuid. @zh Դ uuid
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        initDefault(uuid?: string): void;
    }
    /**
     * @en Class for LabelAtlas handling.
     * @zh Դࡣ
     *
     */
    export class LabelAtlas extends BitmapFont {
    }
    /**
     * @en Class for BitmapFont handling.
     * @zh λͼԴࡣ
     */
    export class BitmapFont extends Font {
        /**
         * @deprecated since v3.7.0, Useless Code.
         */
        fntDataStr: string;
        /**
         * @en [[SpriteFrame]] of the bitmap font.
         * @zh λͼʹõľ顣
         */
        spriteFrame: SpriteFrame | null;
        /**
         * @en The font size.
         * @zh ֳߴ硣
         */
        fontSize: number;
        /**
         * @en Font configuration.
         * @zh á
         */
        fntConfig: __private._cocos_2d_assets_bitmap_font__IConfig | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        fontDefDictionary: __private._cocos_2d_assets_bitmap_font__FontAtlas;
        onLoaded(): void;
    }
    /**
     * @en Class for Font handling.
     * @zh Դࡣ
     */
    export class Font extends Asset {
    }
    /**
     * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
     */
    export interface IUV {
        u: number;
        v: number;
    }
    /**
     * @en Information object interface for initialize a [[SpriteFrame]] asset.
     * @zh ڳʼ [[SpriteFrame]] ԴĶӿ
     */
    export interface ISpriteFrameInitInfo {
        /**
         * @en The texture of the sprite frame, could be `TextureBase`.
         * @zh ͼԴ `TextureBase` ͡
         */
        texture?: __private._cocos_asset_assets_texture_base__TextureBase;
        /**
         * @en The original size of the sprite frame.
         * @zh ֡ԭʼߴ硣
         */
        originalSize?: math.Size;
        /**
         * @en The rect of the sprite frame in atlas texture.
         * @zh ֡оΡ
         */
        rect?: math.Rect;
        /**
         * @en The offset of the sprite frame center from the original center of the original rect.
         * Sprite frame in an atlas texture could be trimmed for clipping the transparent pixels, so the trimmed rect is smaller than the original one,
         * the offset defines the distance from the original center to the trimmed center.
         * @zh ֡ƫ
         * ͼеľܻ֡ᱻ޳͸ԻøߵĿռ޳ľγߴȼǰСƫָǴԭʼεĵúľĵľ롣
         */
        offset?: math.Vec2;
        /**
         * @en Top side border for sliced 9 frame.
         * @zh Ź֡ϱ߽硣
         * @default 0
         */
        borderTop?: number;
        /**
         * @en Bottom side border for sliced 9 frame.
         * @zh Ź֡±߽硣
         * @default 0
         */
        borderBottom?: number;
        /**
         * @en Left side border for sliced 9 frame.
         * @zh Ź߽֡硣
         * @default 0
         */
        borderLeft?: number;
        /**
         * @en Right side border for sliced 9 frame.
         * @zh Ź֡ұ߽硣
         * @default 0
         */
        borderRight?: number;
        /**
         * @en Whether the content of sprite frame is rotated.
         * @zh Ƿת
         */
        isRotate?: boolean;
        /**
         * @en Whether the uv is flipped.
         * @zh Ƿת UV
         */
        isFlipUv?: boolean;
    }
    /**
     * @en
     * A `SpriteFrame` support several types.
     *  1. Rectangle sprite frame
     *  2. Sliced 9 sprite frame
     *  3. Mesh sprite frame
     * It mainly contains:<br/>
     *  - texture: A `TextureBase` that will be used by render process.<br/>
     *  - rectangle: A rectangle of the texture.
     *  - Sliced 9 border insets: The distance of each side from the internal rect to the sprite frame rect.
     *  - vertices: Vertex list for the mesh type sprite frame.
     *  - uv: The quad uv.
     *  - uvSliced: The sliced 9 uv.
     *
     * @zh
     * ֡Դ
     * һ SpriteFrame ֶ֧
     *  1. ξ֡
     *  2. Ź֡
     *  3. ֡
     * Ҫݣ<br/>
     *  - ᱻȾʹõ `TextureBase` Դ<br/>
     *  - Σеľ
     *  - ŹϢŹڲĸ߾ SpriteFrame ⲿεľ롣
     *  - Ϣ;֡жб
     *  - uv: ı UV
     *  - uvSliced: Ź UV
     * ͨ `SpriteFrame` ȡ
     *
     * @example
     * ```ts
     * import { resources } from 'cc';
     * // First way to use a SpriteFrame
     * const url = "assets/PurpleMonster/icon/spriteFrame";
     * resources.load(url, (err, spriteFrame) => {
     *   const node = new Node("New Sprite");
     *   const sprite = node.addComponent(Sprite);
     *   sprite.spriteFrame = spriteFrame;
     *   node.parent = self.node;
     * });
     *
     * // Second way to use a SpriteFrame
     * const self = this;
     * const url = "test_assets/PurpleMonster";
     * resources.load(url, (err, imageAsset) => {
     *  if(err){
     *    return;
     *  }
     *
     *  const node = new Node("New Sprite");
     *  const sprite = node.addComponent(Sprite);
     *  const spriteFrame = new SpriteFrame();
     *  const tex = imageAsset._texture;
     *  spriteFrame.texture = tex;
     *  sprite.spriteFrame = spriteFrame;
     *  node.parent = self.node;
     * });
     *
     * // Third way to use a SpriteFrame
     * const self = this;
     * const cameraComp = this.getComponent(Camera);
     * const renderTexture = new RenderTexture();
     * renderTexture.reset({
     *   width: 512,
     *   height: 512,
     *   depthStencilFormat: RenderTexture.DepthStencilFormat.DEPTH_24_STENCIL_8
     * });
     *
     * cameraComp.targetTexture = renderTexture;
     * const spriteFrame = new SpriteFrame();
     * spriteFrame.texture = renderTexture;
     * ```
     */
    export class SpriteFrame extends Asset {
        /**
         * @en Create a SpriteFrame object by an image asset or an native image asset.
         * @zh ͨ Image Դƽ̨ Image 󴴽һ SpriteFrame Դ
         * @param imageSourceOrImageAsset @en ImageAsset or ImageSource, ImageSource could be HTMLCanvasElement, HTMLImageElement, IMemoryImageSource.
         *                                @zh ͼԴͼԭʼͼԴͼԭʼͼԴ֧ HTMLCanvasElement HTMLImageElement IMemoryImageSource Դ
         * @returns @en SpriteFrame asset. @zh Դ
         */
        static createWithImage(imageSourceOrImageAsset: __private._cocos_asset_assets_image_asset__ImageSource | ImageAsset): SpriteFrame;
        /**
         * @en uv update event.
         * @zh uv ¼
         */
        static EVENT_UV_UPDATED: string;
        static MeshType: typeof __private._cocos_2d_assets_sprite_frame__MeshType;
        /**
         * @en Top border distance of sliced 9 rect.
         * @zh Źڲζ߿ SpriteFrame εľ롣
         */
        get insetTop(): number;
        set insetTop(value: number);
        /**
         * @en Bottom border distance of sliced 9 rect.
         * @zh Źڲεײ߿ SpriteFrame εľ롣
         */
        get insetBottom(): number;
        set insetBottom(value: number);
        /**
         * @en Left border distance of sliced 9 rect.
         * @zh Źڲ߿ SpriteFrame εľ롣
         */
        get insetLeft(): number;
        set insetLeft(value: number);
        /**
         * @en Right border distance of sliced 9 rect.
         * @zh Źڲұ߿ SpriteFrame εľ롣
         */
        get insetRight(): number;
        set insetRight(value: number);
        /**
         * @en Returns the rect of the sprite frame in the texture.
         * If it's an atlas texture, a transparent pixel area is proposed for the actual mapping of the current texture.
         * @zh ȡ SpriteFrame 
         * һ atlas ͼΪǰͼʵ޳͸
         */
        get rect(): math.Rect;
        set rect(value: math.Rect);
        /**
         * @en The original size before trimmed.
         * @zh ޼ǰԭʼС
         */
        get originalSize(): math.Size;
        set originalSize(value: math.Size);
        /**
         * @en The offset of the sprite frame center.
         * Sprite frame in an atlas texture could be trimmed for clipping the transparent pixels, so the trimmed rect is smaller than the original one,
         * the offset defines the distance from the original center to the trimmed center.
         * @zh ֡ƫ
         * ͼеľܻ֡ᱻ޳͸ԻøߵĿռ޳ľγߴȼǰСƫָǴԭʼεĵúľĵľ롣
         */
        get offset(): math.Vec2;
        set offset(value: math.Vec2);
        /**
         * @en Whether the content of sprite frame is rotated.
         * @zh Ƿת
         */
        get rotated(): boolean;
        set rotated(rotated: boolean);
        /**
         * @en The texture of the sprite frame, could be `TextureBase`.
         * @zh ͼԴ `TextureBase` ͡
         */
        get texture(): __private._cocos_asset_assets_texture_base__TextureBase;
        set texture(value: __private._cocos_asset_assets_texture_base__TextureBase);
        /**
         * @en The uuid of the atlas asset, if exists.
         * @zh ͼԴ uuid
         */
        get atlasUuid(): string;
        set atlasUuid(value: string);
        /**
         * @en The pixel width of the sprite frame.
         * @zh ֡ؿȡ
         */
        get width(): number;
        /**
         * @en The pixel height of the sprite frame.
         * @zh ֡ظ߶ȡ
         */
        get height(): number;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        set _textureSource(value: __private._cocos_asset_assets_texture_base__TextureBase);
        /**
         * @en Whether flip the uv in X direction.
         * @zh  X ᷽, ת UV
         */
        get flipUVX(): boolean;
        set flipUVX(value: boolean);
        /**
         * @en Whether flip the uv in Y direction.
         * @zh  Y ᷽, ת UV
         */
        get flipUVY(): boolean;
        set flipUVY(value: boolean);
        /**
         * @en Sets whether sprite can be packed into dynamic atlas.
         * @zh þǷԶͼ
         */
        get packable(): boolean;
        set packable(value: boolean);
        /**
         * @en Original information before packed to dynamic atlas, includes texture, width, height. It's null before being packed to dynamic atlas.
         * @zh Զͼ֮ǰԭʼ texture ͿϢڲԶͼ֮ǰֵΪ null
         */
        get original(): {
            _texture: __private._cocos_asset_assets_texture_base__TextureBase;
            _x: number;
            _y: number;
        } | null;
        /**
         * @en Number of pixels corresponding to unit size in world space (pixels per unit).
         * @zh ռеĵλСӦÿλ
         */
        get pixelsToUnit(): number;
        /**
         * @en Local origin position when generating the mesh.
         * @zh  mesh ʱԭλá
         */
        get pivot(): math.Vec2;
        /**
         * @en mesh information, you should call the [[ensureMeshData]] function before using it.
         * @zh mesh ϢӦʹ֮ǰ [[ensureMeshData]] ȷá
         */
        get mesh(): Mesh | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get trimmedBorder(): math.Vec4;
        /**
         * @en Vertex list for the mesh type sprite frame.
         * @zh ;֡жб
         */
        vertices: __private._cocos_2d_assets_sprite_frame__IVertices | null;
        /**
         * @en UV for quad vertices.
         * @zh εĶ UV
         */
        uv: number[];
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        unbiasUV: number[];
        /**
         * @en UV for sliced 9 vertices.
         * @zh ŹĶ UV
         */
        uvSliced: IUV[];
        protected _rect: math.Rect;
        protected _trimmedBorder: math.Vec4;
        protected _offset: math.Vec2;
        protected _originalSize: math.Size;
        protected _rotated: boolean;
        protected _capInsets: number[];
        protected _atlasUuid: string;
        protected _texture: __private._cocos_asset_assets_texture_base__TextureBase;
        protected _isFlipUVY: boolean;
        protected _isFlipUVX: boolean;
        protected _original: {
            _texture: __private._cocos_asset_assets_texture_base__TextureBase;
            _x: number;
            _y: number;
        } | null;
        protected _packable: boolean;
        protected _pixelsToUnit: number;
        protected _pivot: math.Vec2;
        protected _meshType: __private._cocos_2d_assets_sprite_frame__MeshType;
        protected _extrude: number;
        protected _customOutLine: never[];
        protected _mesh: Mesh | null;
        protected _minPos: math.Vec3;
        protected _maxPos: math.Vec3;
        constructor();
        /**
         * @en
         * Returns whether the texture have been loaded.
         * @zh
         * ǷѼؾ֡
         *
         * @deprecated since v3.3, Useless Code.
         */
        textureLoaded(): boolean;
        /**
         * @en
         * Returns whether the sprite frame is rotated in the texture.
         * @zh
         * ȡ SpriteFrame Ƿת
         * @deprecated since v1.2, please use [[rotated]] instead.
         */
        isRotated(): boolean;
        /**
         * @en
         * Set whether the sprite frame is rotated in the texture.
         * @zh
         *  SpriteFrame Ƿת
         * @param rotated @en rotated.  @zh Ƿת
         * @deprecated since v1.2, please use [[rotated]] instead.
         */
        setRotated(rotated: boolean): void;
        /**
         * @en Returns the rect of the sprite frame in the texture.
         * If it's an atlas texture, a transparent pixel area is proposed for the actual mapping of the current texture.
         * @zh ȡ SpriteFrame 
         * һ atlas ͼΪǰͼʵ޳͸
         * @param out @en The output rect. @zh ľ
         * @returns @en The rect. @zh 
         * @deprecated since v1.2, please use [[rect]].
         */
        getRect(out?: math.Rect): math.Rect;
        /**
         * @en Sets the rect of the sprite frame in the texture.
         * @zh  SpriteFrame 
         * @param rect @en The new rect. @zh Ҫõ rect
         * @deprecated since v1.2, please use [[rect]].
         */
        setRect(rect: math.Rect): void;
        /**
         * @en Returns the original size before trimmed.
         * @zh ȡ޼ǰԭʼС
         * @param out @en The output original size. @zh ԭʼС
         * @returns @en The original size. @zh ԭʼС
         * @deprecated since v1.2, please use [[originalSize]].
         */
        getOriginalSize(out?: math.Size): math.Size;
        /**
         * @en Sets the original size before trimmed.
         * @zh ޼ǰԭʼС
         * @param size @en The new original size. @zh õԭʼС
         * @deprecated since v1.2, please use [[originalSize]].
         */
        setOriginalSize(size: math.Size): void;
        /**
         * @en Gets the offset of the frame.
         * @zh ȡƫ
         * @param out @en The output offset object. @zh ƫ
         * @returns @en The offset object. @zh ƫ
         * @deprecated since v1.2, please use [[offset]]
         */
        getOffset(out?: math.Vec2): math.Vec2;
        /**
         * @en Sets the offset of the frame.
         * @zh ƫ
         * @param offset @en The new offset. @zh õƫ
         * @deprecated since v1.2, please use [[offset]]
         */
        setOffset(offset: math.Vec2): void;
        /**
         * @en Gets the related GFX [[gfx.Texture]] resource.
         * @zh ȡȾͼ GFX Դ
         * @returns @en Gfx Texture resource. @zh GFX ͼԴ
         */
        getGFXTexture(): gfx.Texture | null;
        /**
         * @en Gets the GFX sampler of its texture.
         * @zh ͼԴĲ
         * @returns @en The GFX sampler resource. @zh GFXͼ
         */
        getGFXSampler(): gfx.Sampler;
        /**
         * @en Gets the hash of its texture.
         * @zh ͼԴĹϣֵ
         * @returns @en Texture`s hash. @zh ͼϣֵ
         */
        getHash(): number;
        /**
         * @en Gets the sampler hash of its texture.
         * @zh ͼԴĲϣֵ
         * @returns @en Sampler`s hash. @zh ϣֵ
         */
        getSamplerInfo(): Readonly<gfx.SamplerInfo>;
        /**
         * @en Resets the sprite frame data.
         * @zh  SpriteFrame ݡ
         * @param info @en SpriteFrame initialization information. @zh SpriteFrame ʼϢ
         * @param clearData @en Clear Data before initialization. @zh Ƿڳʼǰԭݡ
         */
        reset(info?: ISpriteFrameInitInfo, clearData?: boolean): void;
        /**
         * @en Check whether the rect of the sprite frame is out of the texture boundary.
         * @zh жϾľǷԽ硣
         * @param texture @en Texture resources for sprite frame. @zh SpriteFrame ͼԴ
         * @returns @en Out of the texture boundary or not. @zh ǷԽ硣
         */
        checkRect(texture: __private._cocos_asset_assets_texture_base__TextureBase): boolean;
        /**
         * @en Make sure the mesh is available, you should call it before using the mesh.
         * @zh ȷ mesh ãӦʹ mesh ֮ǰ
         */
        ensureMeshData(): void;
        destroy(): boolean;
        /**
         * Calculate UV for sliced
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _calculateSlicedUV(): void;
        /**
         * Calculate UV
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _calculateUV(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _setDynamicAtlasFrame(frame: any): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _resetDynamicAtlasFrame(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _checkPackable(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _serialize(ctxForExporting: any): any;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _deserialize(serializeData: any, handle: any): void;
        /**
         * @en clone a sprite frame.
         * @zh ¡ǰ sprite frame
         */
        clone(): SpriteFrame;
        protected _refreshTexture(texture: __private._cocos_asset_assets_texture_base__TextureBase): void;
        /**
         * @en complete loading callback.
         * @zh ɻص
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        onLoaded(): void;
        /**
         * @en default init.
         * @zh Ĭϳʼ
         * @param uuid @en Asset uuid. @zh Դ uuid
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        initDefault(uuid?: string): void;
        /**
         * @en Check whether the sprite frame is validate.
         * @zh 鵱ǰ sprite frame ǷЧġ
         * @returns @en validate or not. @zh ǷЧ
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        validate(): boolean;
        protected _initVertices(): void;
        protected _updateMeshVertices(): void;
        protected _createMesh(): void;
        protected _updateMesh(): void;
    }
    /**
     * @en
     * The root node of UI.
     * Provide an aligned window for all child nodes, also provides ease of setting screen adaptation policy interfaces from the editor.
     * Line-of-sight range is -999 to 1000.
     *
     * @zh
     * Ϊ UI ڵ㣬ΪӽڵṩӴṩĻԽӿڣӱ༭á
     * עڱڵĳߴĻ죬 anchorPoint ֻ֧ (0.5, 0.5)䲻ͬĻʱƫ
     * UI Ӿ෶Χ -999  1000.
     */
    export class Canvas extends RenderRoot2D {
        /**
         * @en
         * The render mode of Canvas.
         * When you choose the mode of INTERSPERSE, You can specify the rendering order of the Canvas with the camera in the scene.
         * When you choose the mode of OVERLAY, the builtin camera of Canvas will render after all scene cameras are rendered.
         * NOTE: The cameras in the scene (including the Canvas built-in camera) must have a ClearFlag selection of SOLID_COLOR,
         * otherwise a splash screen may appear on the mobile device.
         *
         * @zh
         * Canvas Ⱦģʽ
         * intersperse ¿ָ Canvas 볡еȾ˳overlay  Canvas гȾɺȾ
         * ע⣺ Canvas õһ ClearFlag ѡ SOLID_COLORƶ˿ܻ
         *
         * @deprecated since v3.0, please use [[Camera.priority]] to control overlapping between cameras.
         */
        get renderMode(): number;
        set renderMode(val: number);
        /**
         * @en The camera component that will be aligned with this canvas
         * @zh  canvas 
         */
        get cameraComponent(): Camera | null;
        set cameraComponent(value: Camera | null);
        /**
         * @en Align canvas with screen
         * @zh ǷʹĻ뻭
         */
        get alignCanvasWithScreen(): boolean;
        set alignCanvasWithScreen(value: boolean);
        protected _cameraComponent: Camera | null;
        protected _alignCanvasWithScreen: boolean;
        protected _thisOnCameraResized: () => void;
        protected fitDesignResolution_EDITOR: (() => void) | undefined;
        constructor();
        __preload(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        protected _onResizeCamera(): void;
    }
    /**
     * @en Legacy 2D base class for rendering component, please use [[UIRenderer]] instead.
     * This component will setup NodeUIProperties.uiComp in its owner [[Node]].
     * @zh ɵ 2D Ⱦ࣬ʹ [[UIRenderer]] 
     *  [[Node]] ϵ NodeUIProperties.uiComp
     * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
     */
    export class UIComponent extends Component {
        protected _lastParent: Node | null;
        __preload(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en Post render data submission procedure, it's executed after assembler updated for all children.
         * It may assemble some extra render data to the geometry buffers, or it may only change some render states.
         * Don't call it unless you know what you are doing.
         * @zh ȾװӽڵȾװɺ󱻵á
         * ܻװȾݵݻҲֻһЩȾ״̬
         * ע⣺Ҫֶøú̡
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        postUpdateAssembler(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        /**
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        markForUpdateRenderData(enable?: boolean): void;
        /**
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        stencilStage: __private._cocos_2d_renderer_stencil_manager__Stage;
        /**
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        setNodeDirty(): void;
        /**
         * @deprecated since v3.4.1, please use [[UIRenderer]] instead.
         */
        setTextureDirty(): void;
    }
    /**
     * @en
     * The shader property type of the material after instantiation.
     *
     * @zh
     * ʵĲʵɫ͡
     */
    export enum InstanceMaterialType {
        /**
         * @en
         * The shader only has color properties.
         *
         * @zh
         * ɫֻɫԡ
         */
        ADD_COLOR = 0,
        /**
         * @en
         * The shader has color and texture properties.
         *
         * @zh
         * ɫɫͼԡ
         */
        ADD_COLOR_AND_TEXTURE = 1,
        /**
         * @en
         * The shader has color and texture properties and uses grayscale mode.
         *
         * @zh
         * ɫɫͼ,ʹûҶģʽ
         */
        GRAYSCALE = 2,
        /**
         * @en
         * The shader has color and texture properties and uses embedded alpha mode.
         *
         * @zh
         * ɫɫͼ,ʹ͸ͨͼ
         */
        USE_ALPHA_SEPARATED = 3,
        /**
         * @en
         * The shader has color and texture properties and uses embedded alpha and grayscale mode.
         *
         * @zh
         * ɫɫͼ,ʹûҶģʽ
         */
        USE_ALPHA_SEPARATED_AND_GRAY = 4
    }
    /**
     * @en Base class for UI components which supports rendering features.
     * This component will setup NodeUIProperties.uiComp in its owner [[Node]]
     *
     * @zh ֧Ⱦ UI Ļࡣ
     *  [[Node]] ϵ NodeUIProperties.uiComp
     */
    export class UIRenderer extends Renderer {
        /**
         * @en The blend factor enums
         * @zh ģʽö
         * @see [[gfx.BlendFactor]]
         * @internal
         */
        static BlendState: typeof gfx.BlendFactor;
        /**
         * @en The render data assembler
         * @zh Ⱦװ
         * @internal
         */
        static Assembler: IAssemblerManager;
        /**
         * @en The post render data assembler
         * @zh Ⱦװ
         * @internal
         */
        static PostAssembler: IAssemblerManager | null;
        constructor();
        get sharedMaterials(): (Material | null)[];
        set sharedMaterials(val: (Material | null)[]);
        /**
         * @en The customMaterial
         * @zh ûԶ
         */
        get customMaterial(): Material | null;
        set customMaterial(val: Material | null);
        /**
         * @en Main color for rendering, it normally multiplies with texture color.
         * @zh Ⱦɫһ»ͼɫˡ
         */
        get color(): Readonly<math.Color>;
        set color(value: Readonly<math.Color>);
        protected _renderData: RenderData | null;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get renderData(): RenderData | null;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get useVertexOpacity(): boolean;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         * @en The component stencil stage (please do not any modification directly on this object)
         * @zh ģ建״̬ (ע⣺벻Ҫֱ޸ֵ)
         */
        get stencilStage(): __private._cocos_2d_renderer_stencil_manager__Stage;
        set stencilStage(val: __private._cocos_2d_renderer_stencil_manager__Stage);
        protected _materials: (Material | null)[];
        protected _customMaterial: Material | null;
        protected _srcBlendFactor: gfx.BlendFactor;
        protected _dstBlendFactor: gfx.BlendFactor;
        protected _color: math.Color;
        protected _stencilStage: __private._cocos_2d_renderer_stencil_manager__Stage;
        protected _assembler: IAssembler | null;
        protected _postAssembler: IAssembler | null;
        protected _renderDataFlag: boolean;
        protected _renderFlag: boolean;
        protected _renderEntity: __private._cocos_2d_renderer_render_entity__RenderEntity;
        protected _instanceMaterialType: number;
        protected _srcBlendFactorCache: gfx.BlendFactor;
        protected _dstBlendFactorCache: gfx.BlendFactor;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        _dirtyVersion: number;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        _internalId: number;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get batcher(): UI;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get renderEntity(): __private._cocos_2d_renderer_render_entity__RenderEntity;
        /**
         * @en Marks for calculating opacity per vertex
         * @zh Ƿ𶥵͸
         */
        protected _useVertexOpacity: boolean;
        protected _lastParent: Node | null;
        onLoad(): void;
        __preload(): void;
        onEnable(): void;
        onRestore(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en Marks the render data of the current component as modified so that the render data is recalculated.
         * @zh ǵǰȾΪ޸״̬ȾݲŻ¼㡣
         * @param enable Marked necessary to update or not
         */
        markForUpdateRenderData(enable?: boolean): void;
        /**
         * @en Request new render data object.
         * @zh µȾݶ
         * @return @en The new render data. @zh µȾݡ
         */
        requestRenderData(drawInfoType?: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType): RenderData;
        /**
         * @en Destroy current render data.
         * @zh ٵǰȾݡ
         */
        destroyRenderData(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        updateRenderer(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        fillBuffers(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        /**
         * @en Post render data submission procedure, it's executed after assembler updated for all children.
         * It may assemble some extra render data to the geometry buffers, or it may only change some render states.
         * Don't call it unless you know what you are doing.
         * @zh ȾװӽڵȾװɺ󱻵á
         * ܻװȾݵݻҲֻһЩȾ״̬
         * ע⣺Ҫֶøú̡
         */
        postUpdateAssembler(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _postRender(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _canRender(): boolean;
        protected _postCanRender(): void;
        protected _updateColor(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        static setEntityColorDirtyRecursively(node: Node, dirty: boolean): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setEntityColor(color: math.Color): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setEntityOpacity(opacity: number): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setEntityEnabled(enabled: boolean): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _updateBlendFunc(): void;
        protected _nodeStateChange(transformType: TransformBit): void;
        protected _colorDirty(): void;
        protected _onMaterialModified(idx: number, material: Material | null): void;
        protected _updateBuiltinMaterial(): Material;
        protected _flushAssembler?(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setNodeDirty(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setTextureDirty(): void;
        protected createRenderEntity(): __private._cocos_2d_renderer_render_entity__RenderEntity;
    }
    /**
     * @en
     * The component of transform in UI.
     *
     * @zh
     * UI 任
     */
    export class UITransform extends Component {
        /**
         * @en
         * Size of the UI node.
         *
         * @zh
         * ݳߴ硣
         */
        get contentSize(): Readonly<math.Size>;
        set contentSize(value: Readonly<math.Size>);
        /**
         * @en
         * component width.
         * @zh
         * ȡ
         */
        get width(): number;
        set width(value: number);
        /**
         * @en
         * component height.
         * @zh
         * ߶ȡ
         */
        get height(): number;
        set height(value: number);
        /**
         * @en
         * Anchor point of the UI node.
         *
         * @zh
         * êλá
         */
        get anchorPoint(): Readonly<math.Vec2>;
        set anchorPoint(value: Readonly<math.Vec2>);
        /**
         * @en
         * The x-axis anchor of the node.
         *
         * @zh
         * êλõ X ꡣ
         */
        get anchorX(): number;
        set anchorX(value: number);
        /**
         * @en
         * The y-axis anchor of the node.
         *
         * @zh
         * êλõ Y ꡣ
         */
        get anchorY(): number;
        set anchorY(value: number);
        /**
         * @en
         * Render sequence.
         * Note: UI rendering is only about priority.
         *
         * @zh
         * ȾȺ˳򣬰չȾУͬڵ½һС
         * @deprecated Since v3.1
         */
        get priority(): number;
        set priority(value: number);
        protected _priority: number;
        /**
         * @en Get the visibility bit-mask of the rendering camera
         * @zh ұȾĿɼ롣
         * @deprecated since v3.0
         */
        get visibility(): number;
        /**
         * @en Get the priority of the rendering camera
         * @zh ұȾȾȼ
         */
        get cameraPriority(): number;
        static EventType: typeof NodeEventType;
        protected _contentSize: math.Size;
        protected _anchorPoint: math.Vec2;
        __preload(): void;
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en
         * Sets the untransformed size of the ui transform.<br/>
         * The contentSize remains the same no matter if the node is scaled or rotated.<br/>
         * @zh
         * ýڵ UI Transform ԭʼСܸýڵǷŻתӰ졣
         *
         * @param size @en The size of the UI transform. @zh UI Transform  Size С
         * @example
         * ```ts
         * import { Size } from 'cc';
         * node.setContentSize(new Size(100, 100));
         * ```
         */
        setContentSize(size: math.Size): void;
        /**
         * @en
         * Sets the untransformed size of the ui transform.<br/>
         * The contentSize remains the same no matter if the node is scaled or rotated.<br/>
         * @zh
         * ýڵ UI Transform ԭʼСܸýڵǷŻתӰ졣
         *
         * @param width  @en The width of the UI transform. @zh UI Transform Ŀ
         * @param height @en The height of the UI transform. @zh UI Transform ĸߡ
         * @example
         * ```ts
         * import { Size } from 'cc';
         * node.setContentSize(100, 100);
         * ```
         */
        setContentSize(width: number, height: number): void;
        /**
         * @en
         * Sets the anchor point in percent. <br/>
         * anchor point is the point around which all transformations and positioning manipulations take place. <br/>
         * It's like a pin in the node where it is "attached" to its parent. <br/>
         * The anchorPoint is normalized, like a percentage. (0,0) means the bottom-left corner and (1,1) means the top-right corner.<br/>
         * But you can use values higher than (1,1) and lower than (0,0) too.<br/>
         * The default anchor point is (0.5,0.5), so it starts at the center of the node.
         *
         * @zh
         * êİٷֱȡ<br>
         * êӦб任Ĳڽڵ丸ڵĴͷ롣<br>
         * êǱ׼ģٷֱһ(00) ʾ½ǣ(11) ʾϽǡ<br>
         * ʹñȣ11ߵֵ߱ȣ00͵ֵ<br>
         * Ĭϵêǣ0.50.5ʼڽڵλá<br>
         * ע⣺Creator еêڶλڵĽڵ㣬ӽڵĶλӰ졣
         *
         * @param point @en Node anchor point or node x-axis anchor.
         *              @zh ڵêڵ x ê
         * @param y @en The y-axis anchor of the node.
         *          @zh ڵ y ê
         * @example
         * ```ts
         * import { Vec2 } from 'cc';
         * node.setAnchorPoint(new Vec2(1, 1));
         * node.setAnchorPoint(1, 1);
         * ```
         */
        setAnchorPoint(point: math.Vec2 | Readonly<math.Vec2> | number, y?: number): void;
        /**
         * @zh UI ռеĵԡ
         * @en Hit test with point in UI Space.
         *
         * @param uiPoint point in UI Space.
         * @deprecated since v3.5.0, please use `uiTransform.hitTest(screenPoint: Vec2)` instead.
         */
        isHit(uiPoint: math.Vec2): boolean;
        /**
         * @zh Ļռеĵԡ
         * @en Hit test with point in Screen Space.
         *
         * @param screenPoint @en point in Screen Space. @zh Ļеĵ㡣
         */
        hitTest(screenPoint: math.Vec2, windowId?: number): boolean;
        /**
         * @en
         * Converts a Point to node (local) space coordinates.
         *
         * @zh
         * һ UI ڵϵµתһ UI ڵ (ֲ) ռϵϵêΪԭ㡣
         *  UI ڵת UI ڵ(ֲ) ռϵ Camera  `convertToUINode`
         *
         * @param worldPoint @en Point in world space.
         *                   @zh 㡣
         * @param out @en Point in local space.
         *            @zh תꡣ
         * @returns @en Return the relative position to the target node.
         *          @zh Ŀڵλá
         * @example
         * ```ts
         * const newVec3 = uiTransform.convertToNodeSpaceAR(cc.v3(100, 100, 0));
         * ```
         */
        convertToNodeSpaceAR(worldPoint: math.Vec3, out?: math.Vec3): math.Vec3;
        /**
         * @en
         * Converts a Point in node coordinates to world space coordinates.
         *
         * @zh
         * ൱ǰڵϵµһתϵ
         *
         * @param nodePoint @en Point in local space.
         *                  @zh ڵꡣ
         * @param out @en Point in world space.
         *            @zh תꡣ
         * @returns @en Returns the coordinates in the UI world coordinate system.
         *          @zh  UI ϵ
         * @example
         * ```ts
         * const newVec3 = uiTransform.convertToWorldSpaceAR(3(100, 100, 0));
         * ```
         */
        convertToWorldSpaceAR(nodePoint: math.Vec3, out?: math.Vec3): math.Vec3;
        /**
         * @en
         * Returns an axis aligned bounding box of this node in local space coordinate.
         * The returned box is relative only to its parent, and it doesn't contain any child nodes.
         * The behavior is slightly different with [[getBoundingBoxToWorld]] and [[getBoundingBoxTo]].
         *
         * @zh
         * ظϵµİΧС
         * صİΧнֻǰڵΧУӽڵ㡣
         *  API Ϊ [[getBoundingBoxToWorld]]  [[getBoundingBoxTo]] вͬ
         *
         * @returns @en An axis aligned bounding box of this node in local space coordinate.  @zh ϵµİΧС
         * @example
         * ```ts
         * const boundingBox = uiTransform.getBoundingBox();
         * ```
         */
        getBoundingBox(): math.Rect;
        /**
         * @en
         * Returns an axis aligned bounding box of this node in world space coordinate.
         * The bounding box contains self and active children's world bounding box, and it will eliminate all zero sized nodes.
         * @zh
         * ؽڵϵµĶİΧУAABB
         * ñ߿Ѽӽڵ߿򣬵޳СĽڵ㡣
         * @returns @en An axis aligned bounding box of this node in world space coordinate. @zh ϵ°ΧС
         * @example
         * ```ts
         * const newRect = uiTransform.getBoundingBoxToWorld();
         * ```
         */
        getBoundingBoxToWorld(): math.Rect;
        /**
         * @en
         * Returns the minimum bounding box in the coordinate system of the target node.
         * The result contains the current node and its child node tree, and it will eliminates all zero size nodes.
         * E.g. passing an identical matrix will return the world bounding box of the current node tree.
         * @zh
         * Ŀڵϵ°ǰΧмӽڵΧеСܰΧУ޳СĽڵ㡣
         * 뵥λ󣬽õϵµİΧС
         *
         * @param targetMat @en The target node's world matrix representing its coordinate system.
         *                  @zh ʾĿڵϵ
         * @returns @en The minimum bounding box containing the current bounding box and its child nodes.
         *          @zh ǰڵΧмӽڵΧеСΧС
         */
        getBoundingBoxTo(targetMat: math.Mat4): math.Rect;
        /**
         * @en
         * Compute the corresponding aabb in world space for raycast.
         * @zh
         *  UI_2D ڵռµ aabb ΧС
         * @param out @en The out object of aabb bounding box of the node in world space.  @zh ڵռµ aabb ΧС
         * @returns @en The aabb bounding box of the node in world space. @zh ڵռµ aabb ΧС
         */
        getComputeAABB(out?: geometry.AABB): geometry.AABB;
        protected _selfBoundingBox(out: math.Rect): math.Rect;
        protected _parentChanged(node: Node): void;
    }
    /**
     * @en The entry node for 2D object data collection, all 2D rendering objects need to be rendered under the RenderRoot node.
     * @zh 2D ռڽڵ㣬е 2DȾ RenderRoot ڵ²ſԱȾ
     */
    export class RenderRoot2D extends Component {
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
    }
    /**
     * @en 2D rendering component that provides the ability to render sprite in 3D space.
     * @zh 2D ȾṩȾ 3D ռе
     */
    export class SpriteRenderer extends ModelRenderer {
        /**
         * @en The spriteFrame that the component should render.
         * @zh ӦȾ spriteFrame
         */
        get spriteFrame(): SpriteFrame | null;
        set spriteFrame(value: SpriteFrame | null);
        /**
         * @en Rendering model of the component.
         * @zh Ⱦģ͡
         */
        get model(): renderer.scene.Model | null;
        protected _spriteFrame: SpriteFrame | null;
        protected _mode: __private._cocos_2d_framework_sprite_renderer__SpriteMode;
        protected _color: math.Color;
        protected _flipX: boolean;
        protected _flipY: boolean;
        protected _size: math.Vec2;
        onLoad(): void;
        onRestore(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        protected _updateModels(): void;
        protected _createModel(): void;
        protected _updateModelParams(): void;
        protected _getBuiltinMaterial(): Material;
        protected _onMaterialModified(idx: number, material: Material | null): void;
        protected _onUpdateLocalDescriptorSet(): void;
        protected _attachToScene(): void;
    }
    /**
     * @en
     * The Mask Component.
     *
     * @zh
     * 
     */
    export class Mask extends Component {
        /**
         * @en The type for mask.
         *
         * @zh ͡
         */
        static Type: typeof __private._cocos_2d_components_mask__MaskType;
        /**
         * @en
         * The mask type.
         *
         * @zh
         * ͡
         */
        get type(): __private._cocos_2d_components_mask__MaskType;
        set type(value: __private._cocos_2d_components_mask__MaskType);
        /**
         * @en
         * Reverse mask.
         * @zh
         * ֡
         */
        get inverted(): boolean;
        set inverted(value: boolean);
        /**
         * @en
         * The segments for ellipse mask.
         *
         * TODO: remove segments, not supported by graphics
         * @zh
         * Բֵϸ
         */
        get segments(): number;
        set segments(value: number);
        /**
         * @en
         * The mask image.
         *
         * @zh
         * Ҫͼ
         * @deprecated since v3.6.1
         */
        get spriteFrame(): SpriteFrame | null;
        set spriteFrame(value: SpriteFrame | null);
        /**
         * @en
         * The alpha threshold.(Not supported Canvas Mode) <br/>
         * The content is drawn only where the stencil have pixel with alpha greater than the alphaThreshold. <br/>
         * Should be a float between 0 and 1. <br/>
         * This default to 0.1.
         * When it's set to 1, the stencil will discard all pixels, nothing will be shown.
         * @zh
         * Alpha ֵ֧ Canvas ģʽ<br/>
         * ֻеģص alpha ڵ alphaThreshold ʱŻݡ<br/>
         * ֵ 0 ~ 1 ֮ĸĬֵΪ 0.1
         * Ϊ 1 ʱᶪɰأԲʾκ
         */
        get alphaThreshold(): number;
        set alphaThreshold(value: number);
        /**
         * @en Rendering component for providing stencil buffer information.
         * @zh ṩ stencil buffer ϢȾ
         */
        get subComp(): Sprite | Graphics | null;
        protected _type: __private._cocos_2d_components_mask__MaskType;
        protected _inverted: boolean;
        protected _segments: number;
        protected _alphaThreshold: number;
        protected _sprite: Sprite | null;
        protected _graphics: Graphics | null;
        protected _stencilStage: __private._cocos_2d_renderer_stencil_manager__Stage;
        onLoad(): void;
        onEnable(): void;
        onRestore(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en Hit test with point in World Space.
         * @zh ռеĵԡ
         * @param worldPt @en point in World Space. @zh ռеĵ㡣
         */
        isHit(worldPt: math.Vec2): boolean;
        protected _nodeStateChange(type: TransformBit): void;
        protected _createSprite(): void;
        protected _createGraphics(): void;
        protected _updateGraphics(): void;
        protected _enableRender(): void;
        protected _disableRender(): void;
        protected _removeMaskNode(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get customMaterial(): Material | null;
        set customMaterial(val: Material | null);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get color(): math.Color | null;
        set color(value: math.Color | null);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        markForUpdateRenderData(enable?: boolean): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        requestRenderData(any: any): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        destroyRenderData(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        updateRenderer(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        fillBuffers(render: any): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        postUpdateAssembler(render: any): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        setNodeDirty(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        setTextureDirty(): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get sharedMaterial(): Material | null;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get sharedMaterials(): (Material | null)[] | null;
        set sharedMaterials(val: (Material | null)[] | null);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get material(): any;
        set material(val: any);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        get materials(): (any)[];
        set materials(val: (any)[]);
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        getMaterial(idx: number): any;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        setMaterial(material: Material | renderer.MaterialInstance | null, index: number): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        getMaterialInstance(idx: number): any;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        setMaterialInstance(matInst: Material | renderer.MaterialInstance | null, index: number): void;
        /**
         * @deprecated Since v3.6, Because mask changes the inheritance relationship,
         * you can directly manipulate the rendering components under the same node to complete the operation
         */
        getRenderMaterial(index: number): any;
    }
    /**
     * @en
     * The RichText Component.
     *
     * @zh
     * ı
     */
    export class RichText extends Component {
        /**
         * @en
         * Content string of RichText.
         *
         * @zh
         * ıʾıݡ
         */
        get string(): string;
        set string(value: string);
        /**
         * @en
         * Horizontal Alignment of each line in RichText.
         *
         * @zh
         * ıݵˮƽ뷽ʽ
         */
        get horizontalAlign(): HorizontalTextAlignment;
        set horizontalAlign(value: HorizontalTextAlignment);
        /**
         * @en
         * Vertical Alignment of each line in RichText.
         *
         * @zh
         * ıݵֱ뷽ʽ
         */
        get verticalAlign(): VerticalTextAlignment;
        set verticalAlign(value: VerticalTextAlignment);
        /**
         * @en
         * Font size of RichText.
         *
         * @zh
         * ıС
         */
        get fontSize(): number;
        set fontSize(value: number);
        /**
         * @en
         * Font color of RichText. Works when the text content does not have a color parameter set. Transparency cascade is not supported.
         *
         * @zh
         * ıĬɫıûɫʱЧݲ֧ɫ
         */
        get fontColor(): math.Color;
        set fontColor(value: math.Color);
        /**
         * @en
         * Custom System font of RichText.
         *
         * @zh
         * ıϵͳ塣
         */
        get fontFamily(): string;
        set fontFamily(value: string);
        /**
         * @en
         * Custom System font of RichText.
         *
         * @zh
         * ı塣
         */
        get font(): TTFFont | null;
        set font(value: TTFFont | null);
        /**
         * @en
         * Whether use system font name or not.
         *
         * @zh
         * Ƿʹϵͳ塣
         */
        get useSystemFont(): boolean;
        set useSystemFont(value: boolean);
        /**
         * @en
         * The cache mode of label. This mode only supports system fonts.
         *
         * @zh
         * ıģʽ, ģʽֻ֧ϵͳ塣
         */
        get cacheMode(): CacheMode;
        set cacheMode(value: CacheMode);
        /**
         * @en
         * The maximize width of the RichText.
         *
         * @zh
         * ıȡ
         */
        get maxWidth(): number;
        set maxWidth(value: number);
        /**
         * @en
         * Line Height of RichText.
         *
         * @zh
         * ıиߡ
         */
        get lineHeight(): number;
        set lineHeight(value: number);
        /**
         * @en
         * The image atlas for the img tag. For each src value in the img tag, there should be a valid spriteFrame in the image atlas.
         *
         * @zh
         *  img ǩ src ƣҪ imageAtlas ҵһЧ spriteFrame img tag жΪЧ
         */
        get imageAtlas(): SpriteAtlas | null;
        set imageAtlas(value: SpriteAtlas | null);
        /**
         * @en
         * Once checked, the RichText will block all input events (mouse and touch) within
         * the bounding box of the node, preventing the input from penetrating into the underlying node.
         *
         * @zh
         * ѡдѡRichText ֹڵ߽е¼ʹӶֹ¼͸ײڵ㡣
         */
        get handleTouchEvent(): boolean;
        set handleTouchEvent(value: boolean);
        /**
         * @en Enum for horizontal text alignment.
         *
         * @zh ı͡
         */
        static HorizontalAlign: typeof HorizontalTextAlignment;
        /**
         * @en Enum for vertical text alignment.
         *
         * @zh ıֱ͡
         */
        static VerticalAlign: typeof VerticalTextAlignment;
        protected _lineHeight: number;
        protected _string: string;
        protected _horizontalAlign: HorizontalTextAlignment;
        protected _verticalAlign: VerticalTextAlignment;
        protected _fontSize: number;
        protected _fontColor: math.Color;
        protected _maxWidth: number;
        protected _fontFamily: string;
        protected _font: TTFFont | null;
        protected _isSystemFontUsed: boolean;
        protected _userDefinedFont: TTFFont | null;
        protected _cacheMode: CacheMode;
        protected _imageAtlas: SpriteAtlas | null;
        protected _handleTouchEvent: boolean;
        protected _textArray: IHtmlTextParserResultObj[];
        protected _segments: __private._cocos_2d_components_rich_text__ISegment[];
        protected _labelSegmentsCache: __private._cocos_2d_components_rich_text__ISegment[];
        protected _linesWidth: number[];
        protected _lineCount: number;
        protected _labelWidth: number;
        protected _labelHeight: number;
        protected _layoutDirty: boolean;
        protected _lineOffsetX: number;
        protected _updateRichTextStatus: () => void;
        protected _labelChildrenNum: number;
        constructor();
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        onRestore(): void;
        onDestroy(): void;
        protected _addEventListeners(): void;
        protected _removeEventListeners(): void;
        protected _updateLabelSegmentTextAttributes(): void;
        protected _createFontLabel(str: string): __private._cocos_2d_components_rich_text__ISegment;
        protected _createImage(spriteFrame: SpriteFrame): __private._cocos_2d_components_rich_text__ISegment;
        protected _onTTFLoaded(): void;
        protected _measureText(styleIndex: number, string?: string): number | ((s: string) => number);
        protected _onTouchEnded(event: EventTouch): void;
        protected _containsTouchLocation(label: __private._cocos_2d_components_rich_text__ISegment, point: math.Vec2): boolean;
        protected _resetState(): void;
        protected _activateChildren(active: any): void;
        protected _addLabelSegment(stringToken: string, styleIndex: number): __private._cocos_2d_components_rich_text__ISegment;
        protected _updateRichTextWithMaxWidth(labelString: string, labelWidth: number, styleIndex: number): void;
        protected _isLastComponentCR(stringToken: any): boolean;
        protected _updateLineInfo(): void;
        protected _needsUpdateTextLayout(newTextArray: IHtmlTextParserResultObj[]): boolean;
        protected _addRichTextImageElement(richTextElement: IHtmlTextParserResultObj): void;
        protected _updateTextDefaultColor(): void;
        protected _updateRichText(): void;
        protected _getFirstWordLen(text: string, startIndex: number, textLen: number): number;
        protected _updateRichTextPosition(): void;
        protected _convertLiteralColorValue(color: string): math.Color;
        protected _applyTextAttribute(labelSeg: __private._cocos_2d_components_rich_text__ISegment): void;
        protected _applyLayer(): void;
        protected _resetLabelState(label: Label): void;
    }
    /**
     * @en
     * Renders a sprite in the scene.
     *
     * @zh
     * Ⱦ
     */
    export class Sprite extends UIRenderer {
        /**
         * @en
         * The sprite atlas where the sprite is.
         *
         * @zh
         * ͼ
         */
        get spriteAtlas(): SpriteAtlas | null;
        set spriteAtlas(value: SpriteAtlas | null);
        /**
         * @en
         * The sprite frame of the sprite.
         *
         * @zh
         * ľ֡
         */
        get spriteFrame(): SpriteFrame | null;
        set spriteFrame(value: SpriteFrame | null);
        /**
         * @en
         * The sprite render type.
         *
         * @zh
         * Ⱦ͡
         *
         * @example
         * ```ts
         * import { Sprite } from 'cc';
         * sprite.type = Sprite.Type.SIMPLE;
         * ```
         */
        get type(): __private._cocos_2d_components_sprite__SpriteType;
        set type(value: __private._cocos_2d_components_sprite__SpriteType);
        /**
         * @en
         * The fill type, This will only have any effect if the "type" is set to Sprite.Type.FILLED.
         *
         * @zh
         * ͣȾΪ Sprite.Type.FILLED ʱЧ
         *
         * @example
         * ```ts
         * import { Sprite } from 'cc';
         * sprite.fillType = Sprite.FillType.HORIZONTAL;
         * ```
         */
        get fillType(): __private._cocos_2d_components_sprite__FillType;
        set fillType(value: __private._cocos_2d_components_sprite__FillType);
        /**
         * @en
         * The fill Center, This will only have any effect if the "type" is set to Sprite.Type.FILLED.
         *
         * @zh
         * ĵ㣬ȾΪ Sprite.Type.FILLED ʱЧ
         *
         * @example
         * ```ts
         * import { Vec2 } from 'cc';
         * sprite.fillCenter = new Vec2(0, 0);
         * ```
         */
        get fillCenter(): math.Vec2;
        set fillCenter(value: math.Vec2);
        /**
         * @en
         * The fill Start, This will only have any effect if the "type" is set to Sprite.Type.FILLED.
         *
         * @zh
         * ʼ㣬ȾΪ Sprite.Type.FILLED ʱЧ
         *
         * @example
         * ```ts
         * // -1 To 1 between the numbers
         * sprite.fillStart = 0.5;
         * ```
         */
        get fillStart(): number;
        set fillStart(value: number);
        /**
         * @en
         * The fill Range, This will only have any effect if the "type" is set to Sprite.Type.FILLED.
         *
         * @zh
         * ䷶ΧȾΪ Sprite.Type.FILLED ʱЧ
         *
         * @example
         * ```ts
         * // -1 To 1 between the numbers
         * sprite.fillRange = 1;
         * ```
         */
        get fillRange(): number;
        set fillRange(value: number);
        /**
         * @en
         * specify the frame is trimmed or not.
         *
         * @zh
         * Ƿʹòüģʽ
         *
         * @example
         * ```ts
         * sprite.trim = true;
         * ```
         */
        get trim(): boolean;
        set trim(value: boolean);
        /**
         * @en Grayscale mode.
         * @zh ǷԻҶģʽȾ
         */
        get grayscale(): boolean;
        set grayscale(value: boolean);
        /**
         * @en
         * Specify the size tracing mode.
         *
         * @zh
         * ߴģʽ
         *
         * @example
         * ```ts
         * import { Sprite } from 'cc';
         * sprite.sizeMode = Sprite.SizeMode.CUSTOM;
         * ```
         */
        get sizeMode(): __private._cocos_2d_components_sprite__SizeMode;
        set sizeMode(value: __private._cocos_2d_components_sprite__SizeMode);
        /**
         * @en Enum for fill type.
         * @zh ͡
         */
        static FillType: typeof __private._cocos_2d_components_sprite__FillType;
        /**
         * @en Enum for sprite type.
         * @zh Sprite ͡
         */
        static Type: typeof __private._cocos_2d_components_sprite__SpriteType;
        /**
         * @en Sprite's size mode, including trimmed size, raw size, and none.
         * @zh ߴģʽ
         */
        static SizeMode: typeof __private._cocos_2d_components_sprite__SizeMode;
        /**
         * @en Event types for sprite.
         * @zh sprite ¼͡
         */
        static EventType: typeof __private._cocos_2d_components_sprite__EventType;
        protected _spriteFrame: SpriteFrame | null;
        protected _type: __private._cocos_2d_components_sprite__SpriteType;
        protected _fillType: __private._cocos_2d_components_sprite__FillType;
        protected _sizeMode: __private._cocos_2d_components_sprite__SizeMode;
        protected _fillCenter: math.Vec2;
        protected _fillStart: number;
        protected _fillRange: number;
        protected _isTrimmedMode: boolean;
        protected _useGrayscale: boolean;
        protected _atlas: SpriteAtlas | null;
        __preload(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en
         * Quickly switch to other sprite frame in the sprite atlas.
         * If there is no atlas, the switch fails.
         *
         * @zh
         * ѡȡʹþͼе顣
         * @param name @en Name of the spriteFrame to switch. @zh Ҫл spriteFrame ֡
         */
        changeSpriteFrameFromAtlas(name: string): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        changeMaterialForDefine(): void;
        protected _updateBuiltinMaterial(): Material;
        protected _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _canRender(): boolean;
        protected _flushAssembler(): void;
    }
    /**
     * @en
     * The component of model.
     * When you place particles or models in the UI, you must add this component to render.
     * The component must be placed on a node with the [[MeshRenderer]] or the [[ParticleSystem]].
     *
     * @zh
     * UI ģͻ
     *  UI зģͻӵʱ򣬱ӸȾڴ [[MeshRenderer]]  [[ParticleSystem]] Ľڵϡ
     * @deprecated This component is not recommended to be used, please use Render Texture instead.
     * See [UIMeshRenderer Reference](https://docs.cocos.com/creator/manual/en/ui-system/components/editor/ui-model.html)
     */
    export class UIMeshRenderer extends Component {
        constructor();
        /**
         * @en Get the model component on this node
         * @zh ȡͬڵ model 
         */
        get modelComponent(): ModelRenderer | null;
        protected _renderEntity: __private._cocos_2d_renderer_render_entity__RenderEntity;
        _dirtyVersion: number;
        _internalId: number;
        __preload(): void;
        onEnable(): void;
        onDisable(): void;
        onLoad(): void;
        onDestroy(): void;
        /**
         * @en Render data submission procedure, it update and assemble the render data to 2D data buffers before all children submission process.
         * Usually called each frame when the ui flow assemble all render data to geometry buffers.
         * Don't call it unless you know what you are doing.
         * @zh Ⱦװӽڵװ֮ǰ²װǰȾݵ UI ĶݻС
         * һ UI ȾеãװеȾݵݻ
         * ע⣺Ҫֶøú̡
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): boolean;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        fillBuffers(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        updateRenderer(): void;
        /**
         * @en Post render data submission procedure, it's executed after assembler updated for all children.
         * It may assemble some extra render data to the geometry buffers, or it may only change some render states.
         * Don't call it unless you know what you are doing.
         * @zh ȾװӽڵȾװɺ󱻵á
         * ܻװȾݵݻҲֻһЩȾ״̬
         * ע⣺Ҫֶøú̡
         */
        postUpdateAssembler(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        update(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        markForUpdateRenderData(enable?: boolean): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        stencilStage: __private._cocos_2d_renderer_stencil_manager__Stage;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setNodeDirty(): void;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setTextureDirty(): void;
        protected _canRender(): boolean;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get renderEntity(): __private._cocos_2d_renderer_render_entity__RenderEntity;
        protected _renderData: RenderData | null;
        /**
         * @deprecated Since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get renderData(): RenderData | null;
    }
    /**
     * @en
     * Outline effect used to change the display, only for system fonts or TTF fonts.
     *
     * @zh
     * Ч,,ֻϵͳ塣
     *
     * @deprecated since v3.8.2, please use [[Label.enableOutline]] instead.
     */
    export class LabelOutline extends Component {
        /**
         * @en
         * Outline color.
         *
         * @zh
         * ıߵɫ
         *
         * @deprecated since v3.8.2, please use [[Label.outlineColor]] instead.
         */
        get color(): Readonly<math.Color>;
        set color(value: Readonly<math.Color>);
        /**
         * @en
         * Change the outline width.
         *
         * @zh
         * ıߵĿȡ
         *
         * @deprecated since v3.8.2, please use [[Label.outlineWidth]] instead.
         */
        get width(): number;
        set width(value: number);
        /**
         * @deprecated since v3.8.2, please use [[Label.enableOutline]] instead.
         */
        onEnable(): void;
        /**
         * @deprecated since v3.8.2, please use [[Label.enableOutline]] instead.
         */
        onDisable(): void;
    }
    /**
     * @en
     * Graphics component.
     *
     * @zh
     * Զͼࡣ
     */
    export class Graphics extends UIRenderer {
        /**
         * @en
         * Current line width.
         *
         * @zh
         * ǰȡ
         */
        get lineWidth(): number;
        set lineWidth(value: number);
        /**
         * @en
         * Determines how two connecting segments (of lines, arcs or curves) with non-zero lengths in a shape are joined together.
         *
         * @zh
         * 2ȲΪ0֣߶ΣԲߣһԡ
         */
        get lineJoin(): __private._cocos_2d_assembler_graphics_types__LineJoin;
        set lineJoin(value: __private._cocos_2d_assembler_graphics_types__LineJoin);
        /**
         * @en
         * Determines how the end points of every line are drawn.
         *
         * @zh
         * ָλÿһ߶ĩˡ
         */
        get lineCap(): __private._cocos_2d_assembler_graphics_types__LineCap;
        set lineCap(value: __private._cocos_2d_assembler_graphics_types__LineCap);
        /**
         * @en
         * Brush stroke color.
         *
         * @zh
         * ʴɫ
         */
        get strokeColor(): Readonly<math.Color>;
        set strokeColor(value: Readonly<math.Color>);
        /**
         * @en
         * Fill paint color.
         *
         * @zh
         * 滭ɫ
         */
        get fillColor(): Readonly<math.Color>;
        set fillColor(value: Readonly<math.Color>);
        /**
         * @en
         * Set the miter limit ratio.
         *
         * @zh
         * бƱ
         */
        get miterLimit(): number;
        set miterLimit(value: number);
        get color(): math.Color;
        set color(value: math.Color);
        static LineJoin: typeof __private._cocos_2d_assembler_graphics_types__LineJoin;
        static LineCap: typeof __private._cocos_2d_assembler_graphics_types__LineCap;
        impl: __private._cocos_2d_assembler_graphics_webgl_impl__Impl | null;
        /**
         * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
         */
        model: renderer.scene.Model | null;
        protected _lineWidth: number;
        protected _strokeColor: math.Color;
        protected _lineJoin: __private._cocos_2d_assembler_graphics_types__LineJoin;
        protected _lineCap: __private._cocos_2d_assembler_graphics_types__LineCap;
        protected _fillColor: math.Color;
        protected _miterLimit: number;
        protected _isDrawing: boolean;
        protected _isNeedUploadData: boolean;
        protected _graphicsNativeProxy: __private._cocos_2d_renderer_native_2d__NativeUIModelProxy;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get graphicsNativeProxy(): __private._cocos_2d_renderer_native_2d__NativeUIModelProxy;
        constructor();
        onRestore(): void;
        onLoad(): void;
        onEnable(): void;
        onDestroy(): void;
        /**
         * @en
         * Move path start point to (x,y).
         *
         * @zh
         * ƶ·㵽(x, y)
         *
         * @param x @en The x-axis coordinate of the target position.
         *          @zh Ŀλõ X ꡣ
         * @param y @en The y-axis coordinate of the target position.
         *          @zh Ŀλõ y ꡣ
         */
        moveTo(x: number, y: number): void;
        /**
         * @en
         * Adds a straight line to the path.
         *
         * @zh
         * ֱ·
         *
         * @param x @en The x-axis coordinate of the target position.
         *          @zh Ŀλõ x ꡣ
         * @param y @en The x-axis coordinate of the target position.
         *          @zh Ŀλõ y ꡣ
         */
        lineTo(x: number, y: number): void;
        /**
         * @en
         * Adds a cubic Bzier curve to the path.
         *
         * @zh
         * α·
         *
         * @param c1x @en The x-axis coordinate of the first control point.
         *            @zh һƵ x ꡣ
         * @param c1y @en The y-axis coordinate of the first control point.
         *            @zh һƵ y ꡣ
         * @param c2x @en The x-axis coordinate of the second control point.
         *            @zh ڶƵ x ꡣ
         * @param c2y @en The y-axis coordinate of the second control point.
         *            @zh ڶƵ y ꡣ
         * @param x @en The x-axis coordinate of the last control point.
         *          @zh һƵ x ꡣ
         * @param y @en The y-axis coordinate of the last control point.
         *          @zh һƵ y ꡣ
         */
        bezierCurveTo(c1x: number, c1y: number, c2x: number, c2y: number, x: number, y: number): void;
        /**
         * @en
         * Adds a quadratic Bzier curve to the path.
         *
         * @zh
         * ƶα·
         *
         * @param cx @en The x-axis coordinate of the starting control point.
         *           @zh ʼƵ x ꡣ
         * @param cy @en The y-axis coordinate of the starting control point.
         *           @zh ʼƵ y ꡣ
         * @param x @en The x-axis coordinates of the endpoint control point.
         *          @zh յƵ x ꡣ
         * @param y @en The y-axis coordinates of the endpoint control point.
         *          @zh յƵ x ꡣ
         */
        quadraticCurveTo(cx: number, cy: number, x: number, y: number): void;
        /**
         * @en
         * Adds an arc to the path which is centered at (cx, cy) position with radius r starting at startAngle
         * and ending at endAngle going in the given direction by counterclockwise (defaulting to false).
         *
         * @zh
         * Բ·Բ·Բ (cx, cy) λã뾶Ϊ r  counterclockwise ĬΪfalseָķ startAngle ʼƣ endAngle 
         *
         * @param cx @en The coordinate x-axis of the central control point.
         *           @zh ĿƵ x ᡣ
         * @param cy @en The coordinate y-axis of the central control point.
         *           @zh ĿƵ y ᡣ
         * @param r @en Angle in Radian.
         *          @zh Բȡ
         * @param startAngle @en The starting angle in radian, measured clockwise from the positive x-axis.
         *                   @zh 㣬 x ˳ʱ뷽
         * @param endAngle @en The ending angle in radian, measured clockwise from the positive x-axis.
         *                 @zh յ㣬 x ˳ʱ뷽
         * @param counterclockwise @en If true, draws counterclockwise between the two angles. Default is clockwise.
         *                         @zh Ϊ棬Ƕ֮ʱơĬ˳ʱ롣
         */
        arc(cx: number, cy: number, r: number, startAngle: number, endAngle: number, counterclockwise: boolean): void;
        /**
         * @en
         * Adds an ellipse to the path.
         *
         * @zh
         * Բ·
         *
         * @param cx @en The x-axis coordinates of the center point.
         *           @zh ĵ x ꡣ
         * @param cy @en The y-axis coordinates of the center point.
         *           @zh ĵ y ꡣ
         * @param rx @en The radius of the x-axis of the ellipse.
         *           @zh Բ x 뾶
         * @param ry @en The radius of the y-axis of the ellipse.
         *           @zh Բ y 뾶
         */
        ellipse(cx: number, cy: number, rx: number, ry: number): void;
        /**
         * @en
         * Adds a circle to the path.
         *
         * @zh
         * Բ·
         *
         * @param cx @en The x-axis coordinates of the center point.
         *           @zh ĵ x ꡣ
         * @param cy @en The y-axis coordinates of the center point.
         *           @zh ĵ y ꡣ
         * @param r @en Radius.
         *          @zh Բ뾶
         */
        circle(cx: number, cy: number, r: number): void;
        /**
         * @en
         * Adds a rectangle to the path.
         *
         * @zh
         * ƾ·
         *
         * @param x @en The x-axis coordinate of the top left point of the rectangle.
         *          @zh ʼ x ꡣ
         * @param y @en The y-axis coordinate of the top left point of the rectangle.
         *          @zh ʼ y ꡣ
         * @param w @en The width of the rectangle.
         *          @zh οȡ
         * @param h @en The height of the rectangle.
         *          @zh θ߶ȡ
         */
        rect(x: number, y: number, w: number, h: number): void;
        /**
         * @en
         * Adds a round corner rectangle to the path.
         *
         * @zh
         * ԲǾ·
         *
         * @param x @en The x-axis coordinate of the top left point of the rectangle.
         *          @zh ʼ x ꡣ
         * @param y @en The y-axis coordinate of the top left point of the rectangle.
         *          @zh ʼ y ꡣ
         * @param w @en The width of the rectangle.
         *          @zh οȡ
         * @param h @en The height of the rectangle.
         *          @zh θ߶ȡ
         * @param r @en Radius of rectangular rounded corners.
         *          @zh Բǰ뾶
         */
        roundRect(x: number, y: number, w: number, h: number, r: number): void;
        /**
         * @en
         * Draws a filled rectangle.
         *
         * @zh
         * Ρ
         *
         * @param x @en The x-axis coordinate of the top left point of the rectangle.
         *          @zh ʼ x ꡣ
         * @param y @en The y-axis coordinate of the top left point of the rectangle.
         *          @zh ʼ y ꡣ
         * @param w @en The width of the rectangle.
         *          @zh οȡ
         * @param h @en The height of the rectangle.
         *          @zh θ߶ȡ
         */
        fillRect(x: number, y: number, w: number, h: number): void;
        /**
         * @en
         * Erasing any previously drawn content.
         *
         * @zh
         * ֮ǰƵݵķ
         */
        clear(): void;
        /**
         * @en
         * Causes the point of the pen to move back to the start of the current path.
         * It tries to add a straight line from the current point to the start.
         *
         * @zh
         * ʵ㷵صǰ·ʼġԴӵǰ㵽ʼһֱߡ
         */
        close(): void;
        /**
         * @en
         * Strokes the current or given path with the current stroke style.
         *
         * @zh
         * ݵǰĻʽƵǰѾڵ·
         */
        stroke(): void;
        /**
         * @en
         * Fills the current or given path with the current fill style.
         *
         * @zh
         * ݵǰĻʽ䵱ǰѾڵ·
         */
        fill(): void;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        activeSubModel(idx: number): void;
        protected _uploadData(): void;
        protected _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _flushAssembler(): void;
        protected _canRender(): boolean;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        updateRenderer(): void;
        protected createRenderEntity(): __private._cocos_2d_renderer_render_entity__RenderEntity;
    }
    /**
     * @en
     * Static batch component of UI.
     * This component is placed on the root node of all node objects that need to be batch.
     * Only sprites and label participate in the batch.
     * Static batch must be enabled manually, otherwise dynamic batch is still used.
     * Note: Do not place mask, Graphics, and objects such as UI models or particles under child nodes,
     * otherwise rendering will be skipped after static batching is enabled.
     *
     * @zh
     * UI ̬
     * Ҫ̬ĽڵĸڵϣӽڵöǾı󲻲뾲̬
     * ûֶͨʽռ̬[[markAsDirty]]ʽȻö̬ɼݵͬ˺ȾǲռĺȾݣӽڵκ޸ĽЧ
     * ע⣺ӽڵ²Ҫ MaskGraphicsԼ UI ģͻ֮󣬷꾲̬Ⱦ
     *
     * @deprecated Since v3.4.1, We have adopted a new rendering batching policy in v3.4.1,
     * which will result in an effective performance improvement for normal dynamic batching components,
     * so manual management with the UIStaticBatch component is no longer recommended and will be removed in the future
     */
    export class UIStaticBatch extends UIRenderer {
        get color(): Readonly<math.Color>;
        set color(value: Readonly<math.Color>);
        get drawBatchList(): __private._cocos_2d_renderer_draw_batch__DrawBatch2D[];
        protected _init: boolean;
        protected _bufferAccessor: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor | null;
        protected _dirty: boolean;
        postUpdateAssembler(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        /**
         * @en
         * Recollect data tags.
         * The render data will be recollected during the render phase of the current frame, and the next frame will be rendered using fixed data.
         * Note: ҪƵô˽ӿ, һڴ.
         *
         * @zh
         * ²ɼݱǣڵǰ֡Ⱦ׶²ɼȾݣһ֡ʼʹù̶ݽȾ
         * ע⣺ҪƵô˽ӿڣΪԭȴ洢 ia ²ɼһڴġ
         */
        markAsDirty(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _requireDrawBatch(): __private._cocos_2d_renderer_draw_batch__DrawBatch2D;
        protected _clearData(): void;
        protected _getBatcher(): UI | null;
    }
    /**
     * @en Shadow effect for Label component, only for system fonts or TTF fonts.
     * @zh ڸ Label ӰЧֻϵͳ ttf 塣
     *
     * @deprecated since v3.8.2, please use [[Label.enableShadow]] instead.
     */
    export class LabelShadow extends Component {
        /**
         * @en
         * Shadow color.
         *
         * @zh
         * Ӱɫ
         *
         * @deprecated since v3.8.2, please use [[Label.shadowColor]] instead.
         */
        get color(): Readonly<math.Color>;
        set color(value: Readonly<math.Color>);
        /**
         * @en
         * Offset between font and shadow.
         *
         * @zh
         * Ӱƫơ
         *
         * @deprecated since v3.8.2, please use [[Label.shadowOffset]] instead.
         */
        get offset(): math.Vec2;
        set offset(value: math.Vec2);
        /**
         * @en
         * A non-negative float specifying the level of shadow blur.
         *
         * @zh
         * Ӱģ̶ȡ
         *
         * @deprecated since v3.8.2, please use [[Label.shadowBlur]] instead.
         */
        get blur(): number;
        set blur(value: number);
        /**
         * @deprecated since v3.8.2, please use [[Label.enableShadow]] instead.
         */
        onEnable(): void;
        /**
         * @deprecated since v3.8.2, please use [[Label.enableShadow]] instead.
         */
        onDisable(): void;
    }
    /**
     * @en
     * Set the UI transparency component.
     * This component can be used to influence subsequent render nodes.
     * Nodes that already have a rendering component can modify the alpha channel of color directly.
     *
     * @zh
     * UI ͸ͨ͸ӰȾڵ㡣ѾȾĽڵֱ޸ color  alpha ͨ
     */
    export class UIOpacity extends Component {
        /**
         * @en
         * The transparency value of the impact.
         *
         * @zh
         * ͸ȡ
         */
        get opacity(): number;
        set opacity(value: number);
        static setEntityLocalOpacityDirtyRecursively(node: Node, dirty: boolean, interruptParentOpacity: number, setByParent: boolean): void;
        protected _opacity: number;
        onEnable(): void;
        onDisable(): void;
    }
    /**
     * @en Enum for horizontal text alignment.
     *
     * @zh ı͡
     */
    export enum HorizontalTextAlignment {
        /**
         * @en Alignment left for text.
         *
         * @zh 롣
         */
        LEFT = 0,
        /**
         * @en Alignment center for text.
         *
         * @zh Ķ롣
         */
        CENTER = 1,
        /**
         * @en Alignment right for text.
         *
         * @zh Ҷ롣
         */
        RIGHT = 2
    }
    /**
     * @en Enum for vertical text alignment.
     *
     * @zh ıֱ͡
     */
    export enum VerticalTextAlignment {
        /**
         * @en Alignment top for text.
         *
         * @zh ϶롣
         */
        TOP = 0,
        /**
         * @en Alignment center for text.
         *
         * @zh Ķ롣
         */
        CENTER = 1,
        /**
         * @en Alignment bottom for text.
         *
         * @zh ¶롣
         */
        BOTTOM = 2
    }
    /**
     * @en Enum for Overflow.
     *
     * @zh ıΪ͡
     */
    export enum Overflow {
        /**
         * @en None.
         *
         * @zh κơ
         */
        NONE = 0,
        /**
         * @en In CLAMP mode, when label content goes out of the bounding box, it will be clipped.
         *
         * @zh CLAMP ģʽУıݳ߽ʱĻᱻضϡ
         */
        CLAMP = 1,
        /**
         * @en In SHRINK mode, the font size will change dynamically to adapt the content size.
         * This mode may takes up more CPU resources when the label is refreshed.
         *
         * @zh SHRINK ģʽСᶯ̬仯ӦݴСģʽıˢµʱܻռý϶ CPU Դ
         */
        SHRINK = 2,
        /**
         * @en In RESIZE_HEIGHT mode, you can only change the width of label and the height is changed automatically.
         *
         * @zh  RESIZE_HEIGHT ģʽ£ֻܸıĿȣ߶Զıġ
         */
        RESIZE_HEIGHT = 3
    }
    /**
     * @en Enum for cache mode.
     *
     * @zh ıͼ͡
     */
    export enum CacheMode {
        /**
         * @en Do not do any caching.
         *
         * @zh κλ档
         */
        NONE = 0,
        /**
         * @en In BITMAP mode, cache the label as a static image and add it to the dynamic atlas for batch rendering,
         * and can batching with Sprites using broken images.
         *
         * @zh BITMAP ģʽ label ɾ̬ͼ񲢼뵽̬ͼԱκϲʹͼ Sprite к
         * ע̬ͼ Chrome Լ΢СϷʱرգùЧ
         */
        BITMAP = 1,
        /**
         * @en In CHAR mode, split text into characters and cache characters into a dynamic atlas which the size of 1024 * 1024.
         *
         * @zh CHAR ģʽıΪַַ浽һŵĴСΪ 1024 * 1024 ͼнظʹãʹö̬ͼ
         * עͼʱٽл棬ʱ֧ SHRINK Ӧıߴ磨ƣ
         */
        CHAR = 2
    }
    /**
     * @en
     * The Label Component.
     *
     * @zh
     * ֱǩ
     */
    export class Label extends UIRenderer {
        /**
         * @en Enum for horizontal text alignment.
         *
         * @zh ı͡
         */
        static HorizontalAlign: typeof HorizontalTextAlignment;
        /**
         * @en Enum for vertical text alignment.
         *
         * @zh ıֱ͡
         */
        static VerticalAlign: typeof VerticalTextAlignment;
        /**
         * @en Enum for label overflow mode.
         *
         * @zh ıΪ͡
         */
        static Overflow: typeof Overflow;
        /**
         * @en Enum for cache mode.
         *
         * @zh ıͼ͡
         */
        static CacheMode: typeof CacheMode;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        static _canvasPool: __private._cocos_2d_assembler_label_font_utils__CanvasPool;
        /**
         * @en
         * Content string of label.
         *
         * @zh
         * ǩʾıݡ
         */
        get string(): string;
        set string(value: string);
        /**
         * @en
         * Horizontal Alignment of label.
         *
         * @zh
         * ıݵˮƽ뷽ʽ
         */
        get horizontalAlign(): HorizontalTextAlignment;
        set horizontalAlign(value: HorizontalTextAlignment);
        /**
         * @en
         * Vertical Alignment of label.
         *
         * @zh
         * ıݵĴֱ뷽ʽ
         */
        get verticalAlign(): VerticalTextAlignment;
        set verticalAlign(value: VerticalTextAlignment);
        /**
         * @en
         * The actual rendering font size in shrink mode.
         *
         * @zh
         * SHRINK ģʽıʵȾС
         */
        get actualFontSize(): number;
        set actualFontSize(value: number);
        /**
         * @en
         * Font size of label.
         *
         * @zh
         * ıС
         */
        get fontSize(): number;
        set fontSize(value: number);
        /**
         * @en
         * Line Height of label.
         *
         * @zh
         * ıиߡ
         */
        get lineHeight(): number;
        set lineHeight(value: number);
        /**
         * @en
         * The spacing between text characters, only available in BMFont.
         *
         * @zh
         * ıַ֮ļࡣʹ BMFont λͼʱЧ
         */
        get spacingX(): number;
        set spacingX(value: number);
        /**
         * @en
         * Overflow of label.
         *
         * @zh
         * ʾΧʱĴʽ
         */
        get overflow(): Overflow;
        set overflow(value: Overflow);
        /**
         * @en
         * Whether auto wrap label when string width is large than label width.
         *
         * @zh
         * ǷԶС
         */
        get enableWrapText(): boolean;
        set enableWrapText(value: boolean);
        /**
         * @en
         * Whether use system font name or not.
         *
         * @zh
         * Ƿʹϵͳ塣
         */
        get useSystemFont(): boolean;
        set useSystemFont(value: boolean);
        /**
         * @en
         * Font family of label, only take effect when useSystemFont property is true.
         *
         * @zh
         * ı, ֻ useSystemFont Ϊ true ʱЧ
         */
        get fontFamily(): string;
        set fontFamily(value: string);
        /**
         * @en
         * The font of label.
         *
         * @zh
         * ı塣
         */
        get font(): Font | null;
        set font(value: Font | null);
        /**
         * @en
         * The cache mode of label. This mode only supports system fonts.
         *
         * @zh
         * ıģʽ, ģʽֻ֧ϵͳ塣
         */
        get cacheMode(): CacheMode;
        set cacheMode(value: CacheMode);
        /**
         * @en
         * Whether the font is bold.
         *
         * @zh
         * ǷӴ֡
         */
        get isBold(): boolean;
        set isBold(value: boolean);
        /**
         * @en
         * Whether the font is italic.
         *
         * @zh
         * Ƿб
         */
        get isItalic(): boolean;
        set isItalic(value: boolean);
        /**
         * @en
         * Whether the font is underline.
         *
         * @zh
         * Ƿ»ߡ
         */
        get isUnderline(): boolean;
        set isUnderline(value: boolean);
        /**
         * @en The height of underline.
         * @zh »߸߶ȡ
         */
        get underlineHeight(): number;
        set underlineHeight(value: number);
        /**
         ** @en
         ** Outline effect used to change the display, only for system fonts or TTF fonts.
         **
         ** @zh
         ** Ч,,ֻϵͳ ttf 塣
         **/
        get enableOutline(): boolean;
        set enableOutline(value: boolean);
        /**
         * @en
         * Outline color.
         *
         * @zh
         * ıߵɫ
         */
        get outlineColor(): math.Color;
        set outlineColor(value: math.Color);
        /**
         * @en
         * Change the outline width.
         *
         * @zh
         * ıߵĿȡ
         */
        get outlineWidth(): number;
        set outlineWidth(value: number);
        /**
         * @en Shadow effect for Label component, only for system fonts or TTF fonts. Disabled when cache mode is char.
         * @zh ڸ Label ӰЧֻϵͳ ttf 塣ڻģʽΪ char ʱá
         */
        get enableShadow(): boolean;
        set enableShadow(value: boolean);
        /**
         * @en
         * Shadow color.
         *
         * @zh
         * Ӱɫ
         */
        get shadowColor(): math.Color;
        set shadowColor(value: math.Color);
        /**
         * @en
         * Offset between font and shadow.
         *
         * @zh
         * Ӱƫơ
         */
        get shadowOffset(): math.Vec2;
        set shadowOffset(value: math.Vec2);
        /**
         * @en
         * A non-negative float specifying the level of shadow blur.
         *
         * @zh
         * Ӱģ̶ȡ
         */
        get shadowBlur(): number;
        set shadowBlur(value: number);
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get spriteFrame(): SpriteFrame | __private._cocos_2d_assembler_label_font_utils__LetterRenderTexture | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get ttfSpriteFrame(): SpriteFrame | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get assemblerData(): __private._cocos_2d_assembler_label_font_utils__ISharedLabelData | null;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        get fontAtlas(): __private._cocos_2d_assets_bitmap_font__FontAtlas | null;
        set fontAtlas(value: __private._cocos_2d_assets_bitmap_font__FontAtlas | null);
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _bmFontOriginalSize(): number;
        protected _string: string;
        protected _horizontalAlign: HorizontalTextAlignment;
        protected _verticalAlign: VerticalTextAlignment;
        protected _actualFontSize: number;
        protected _fontSize: number;
        protected _fontFamily: string;
        protected _lineHeight: number;
        protected _overflow: Overflow;
        protected _enableWrapText: boolean;
        protected _font: Font | null;
        protected _isSystemFontUsed: boolean;
        protected _spacingX: number;
        protected _isItalic: boolean;
        protected _isBold: boolean;
        protected _isUnderline: boolean;
        protected _underlineHeight: number;
        protected _cacheMode: CacheMode;
        protected _enableOutline: boolean;
        protected _outlineColor: math.Color;
        protected _outlineWidth: number;
        protected _enableShadow: boolean;
        protected _shadowColor: math.Color;
        protected _shadowOffset: math.Vec2;
        protected _shadowBlur: number;
        protected _N$file: Font | null;
        protected _texture: SpriteFrame | __private._cocos_2d_assembler_label_font_utils__LetterRenderTexture | null;
        protected _ttfSpriteFrame: SpriteFrame | null;
        protected _userDefinedFont: Font | null;
        protected _assemblerData: __private._cocos_2d_assembler_label_font_utils__ISharedLabelData | null;
        protected _fontAtlas: __private._cocos_2d_assets_bitmap_font__FontAtlas | null;
        protected _letterTexture: __private._cocos_2d_assembler_label_font_utils__LetterRenderTexture | null;
        protected _contentWidth: number;
        protected _textStyle: __private._cocos_2d_assembler_label_text_style__TextStyle | null;
        protected _textLayout: __private._cocos_2d_assembler_label_text_layout__TextLayout | null;
        protected _textRenderData: __private._cocos_2d_assembler_label_text_output_data__TextOutputRenderData | null;
        protected _textLayoutData: __private._cocos_2d_assembler_label_text_output_data__TextOutputLayoutData | null;
        constructor();
        onEnable(): void;
        _onPreDestroy(): void;
        onDestroy(): void;
        /**
         * @en update render data.
         * @zh Ⱦݡ
         * @param force @en Whether to force an immediate update. @zh ǷǿƸȾݡ
         */
        updateRenderData(force?: boolean): void;
        protected _render(render: __private._cocos_2d_renderer_i_batcher__IBatcher): void;
        protected _updateColor(): void;
        /**
         * @deprecated since v3.7.0, this is an engine private interface that will be removed in the future.
         */
        setEntityColor(color: math.Color): void;
        protected _canRender(): boolean;
        protected _flushAssembler(): void;
        protected _applyFontTexture(): void;
        protected changeMaterialForDefine(): void;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export interface IRenderData {
        x: number;
        y: number;
        z: number;
        u: number;
        v: number;
        color: math.Color;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class BaseRenderData {
        get vertexCount(): number;
        get indexCount(): number;
        get stride(): number;
        get floatStride(): number;
        get vertexFormat(): gfx.Attribute[];
        get drawInfoType(): __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType;
        set drawInfoType(type: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType);
        chunk: __private._cocos_2d_renderer_static_vb_accessor__StaticVBChunk;
        protected _renderDrawInfo: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfo;
        get renderDrawInfo(): __private._cocos_2d_renderer_render_draw_info__RenderDrawInfo;
        protected _material: Material | null;
        get material(): Material | null;
        set material(val: Material | null);
        protected _dataHash: number;
        get dataHash(): number;
        set dataHash(val: number);
        _isMeshBuffer: boolean;
        protected _vc: number;
        protected _ic: number;
        protected _floatStride: number;
        protected _vertexFormat: gfx.Attribute[];
        protected _drawInfoType: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType;
        protected _multiOwner: boolean;
        get multiOwner(): boolean;
        set multiOwner(val: boolean);
        protected _batcher: UI | null;
        get batcher(): UI;
        constructor(vertexFormat?: gfx.Attribute[]);
        isValid(): false | __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        initRenderDrawInfo(comp: UIRenderer, drawInfoType?: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfoType): void;
        removeRenderDrawInfo(comp: UIRenderer): void;
        protected setRenderDrawInfoAttributes(): void;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class RenderData extends BaseRenderData {
        static add(vertexFormat?: gfx.Attribute[], accessor?: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor): RenderData;
        static remove(data: RenderData): void;
        get dataLength(): number;
        set dataLength(length: number);
        get data(): IRenderData[];
        _vertDirty: boolean;
        get vertDirty(): boolean;
        set vertDirty(val: boolean);
        protected _textureHash: number;
        get textureHash(): number;
        set textureHash(val: number);
        indices: Uint16Array | null;
        set frame(val: SpriteFrame | __private._cocos_asset_assets_texture_base__TextureBase | null);
        get frame(): SpriteFrame | __private._cocos_asset_assets_texture_base__TextureBase | null;
        layer: number;
        nodeDirty: boolean;
        passDirty: boolean;
        textureDirty: boolean;
        hashDirty: boolean;
        protected _accessor: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        get accessor(): __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        vertexRow: number;
        vertexCol: number;
        constructor(vertexFormat?: gfx.Attribute[], accessor?: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor);
        resize(vertexCount: number, indexCount: number): void;
        protected setRenderDrawInfoAttributes(): void;
        /**
         * @internal
         */
        fillDrawInfoAttributes(drawInfo: __private._cocos_2d_renderer_render_draw_info__RenderDrawInfo): void;
        protected syncRender2dBuffer(): void;
        resizeAndCopy(vertexCount: number, indexCount: number): void;
        getMeshBuffer(): MeshBuffer | null;
        updateNode(comp: UIRenderer): void;
        updatePass(comp: UIRenderer): void;
        updateTexture(frame: SpriteFrame | __private._cocos_asset_assets_texture_base__TextureBase): void;
        updateHash(): void;
        updateRenderData(comp: UIRenderer, frame: SpriteFrame | __private._cocos_asset_assets_texture_base__TextureBase): void;
        clear(): void;
        static createStaticVBAccessor(attributes: gfx.Attribute[], vCount?: number, iCount?: number): __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class MeshRenderData extends BaseRenderData {
        static add(vertexFormat?: gfx.Attribute[]): MeshRenderData;
        static remove(data: MeshRenderData): void;
        /**
         * @deprecated
         */
        set formatByte(value: number);
        get formatByte(): number;
        get floatStride(): number;
        /**
         * Index of Float32Array: vData
         */
        get vDataOffset(): number;
        _isMeshBuffer: boolean;
        vData: Float32Array;
        iData: Uint16Array;
        /**
         * First vertex used in the current IA
         */
        vertexStart: number;
        /**
         * Vertex count used in the current IA
         */
        vertexRange: number;
        /**
         * First index used in the current IA
         */
        indexStart: number;
        /**
         * Index count used in the current IA
         */
        indexRange: number;
        lastFilledIndex: number;
        lastFilledVertex: number;
        frame: any;
        constructor(vertexFormat?: gfx.Attribute[]);
        request(vertexCount: number, indexCount: number): boolean;
        reserve(vertexCount: number, indexCount: number): boolean;
        resize(vertexCount: number, indexCount: number): void;
        updateRange(vertOffset: number, vertexCount: number, indexOffset: number, indexCount: number): void;
        requestIA(device: gfx.Device): gfx.InputAssembler;
        uploadBuffers(): void;
        freeIAPool(): void;
        reset(): void;
        clear(): void;
        protected _initIAInfo(device: gfx.Device): void;
        protected _reallocBuffer(vCount: any, iCount: any): void;
        setRenderDrawInfoAttributes(): void;
        particleInitRenderDrawInfo(entity: __private._cocos_2d_renderer_render_entity__RenderEntity): void;
    }
    /**
     * @internal
     */
    export interface IAssembler {
        [key: string]: any;
    }
    /**
     * @internal
     */
    export interface IAssemblerManager {
        getAssembler(component: UIRenderer): IAssembler;
    }
    export namespace UIVertexFormat {
        /**
         * @en Get total components count for all attributes per vertex.
         * @zh ȡÿԵķܺ
         * @param attrs All attributes of the vertex format
         * @returns Total components count
         */
        export function getComponentPerVertex(attrs: gfx.Attribute[]): number;
        /**
         * @en Get total stride for all attributes per vertex.
         * @zh ȡÿԵܲ
         * @param attrs All attributes of the vertex format
         * @returns Total stride
         */
        export function getAttributeStride(attrs: gfx.Attribute[]): number;
        /**
         * @en Vertex format with vector 3 position attribute
         * @zh άλԵĶʽ
         */
        export const vfmt: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout.
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 4 color attribute (Float32)
         * @zh ݵĶʽ
         * 1. άλԣFloat32
         * 2. RGBA ɫԣFloat32
         */
        export const vfmtPosColor: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 2 uv attribute (Float32)
         * 3. Vector 4 color attribute (Float32)
         * @zh ݵĶʽ
         * 1. άλԣFloat32
         * 2. άͼ UV ԣFloat32
         * 3. RGBA ɫԣFloat32
         */
        export const vfmtPosUvColor: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 2 uv attribute (Float32)
         * 3. Byte 4 color attribute (Byte)
         * @zh ݵĶʽ
         * 1. άλԣFloat32
         * 2. άͼ UV ԣFloat32
         * 3. RGBA ɫԣByte
         */
        export const vfmtPosUvColor4B: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 2 uv attribute (Float32)
         * 3. First vector 4 color attribute (Float32)
         * 4. Second vector 4 color attribute (Float32)
         * @zh ݵĶʽ
         * 1. άλԣFloat32
         * 2. άͼ UV ԣFloat32
         * 3. һ RGBA ɫԣFloat32
         * 4. ڶ RGBA ɫԣFloat32
         */
        export const vfmtPosUvTwoColor: gfx.Attribute[];
        /**
         * @en Vertex format with the following layout
         * 1. Vector 3 position attribute (Float32)
         * 2. Vector 2 uv attribute (Float32)
         * 3. First byte 4 color attribute (Byte)
         * 4. Second byte 4 color attribute (Byte)
         * @zh ݵĶʽ
         * 1. άλԣFloat32
         * 2. άͼ UV ԣFloat32
         * 3. һ RGBA ɫԣByte
         * 4. ڶ RGBA ɫԣByte
         */
        export const vfmtPosUvTwoColor4B: gfx.Attribute[];
    }
    /**
     * @en UI rendering process
     * @zh UI Ⱦ
     */
    export class UI implements __private._cocos_2d_renderer_i_batcher__IBatcher {
        protected _nativeObj: __private._cocos_2d_renderer_native_2d__NativeBatcher2d;
        get nativeObj(): __private._cocos_2d_renderer_native_2d__NativeBatcher2d;
        get currBufferAccessor(): __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        get batches(): memop.CachedArray<__private._cocos_2d_renderer_draw_batch__DrawBatch2D>;
        set currStaticRoot(value: UIStaticBatch | null);
        set currIsStatic(value: boolean);
        device: gfx.Device;
        constructor(_root: Root);
        initialize(): boolean;
        destroy(): void;
        /**
         * @en
         * Add the managed Canvas.
         *
         * @zh
         * Ļ
         *
         * @param comp @en The render root of 2d.
         *             @zh 2d Ⱦ
         */
        addScreen(comp: RenderRoot2D): void;
        /**
         * @zh
         * Removes the Canvas from the list.
         *
         * @param comp @en The target to removed.
         *             @zh ƳĻ
         */
        removeScreen(comp: RenderRoot2D): void;
        sortScreens(): void;
        getFirstRenderCamera(node: Node): renderer.scene.Camera | null;
        update(): void;
        uploadBuffers(): void;
        reset(): void;
        /**
         * @zh бҪΪӦĶ㲼л񻺳
         * @en Switch the mesh buffer for corresponding vertex layout if necessary.
         * @param attributes use VertexFormat.vfmtPosUvColor by default
         */
        switchBufferAccessor(attributes?: gfx.Attribute[]): __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor;
        registerBufferAccessor(key: number, accessor: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor): void;
        updateBuffer(attributes: gfx.Attribute[], bid: number): void;
        /**
         * @en
         * Render component data submission process of UI.
         * The submitted vertex data is the UI for world coordinates.
         * For example: The UI components except Graphics and UIModel.
         *
         * @zh
         * UI Ⱦύ̣ύĶύ̣磺 Graphics  UIModel Ĵ󲿷 ui 
         * ˴ջҪύȾ model ݡ
         *
         * @param comp - The committed renderable component
         * @param renderData - The render data being committed
         * @param frame - Texture or sprite frame related to the draw batch, could be null
         * @param assembler - The assembler for the current component, could be null
         * @param transform - Node type transform, if passed, then batcher will consider it's using model matrix, could be null
         */
        commitComp(comp: UIRenderer, renderData: BaseRenderData | null, frame: __private._cocos_asset_assets_texture_base__TextureBase | SpriteFrame | null, assembler: any, transform: Node | null): void;
        /**
         * @en
         * Render component data submission process for individual [[gfx.InputAssembler]]
         * @zh
         * ȾԶ [[gfx.InputAssembler]] ύ
         * 磺Spine  DragonBones Ȱ̬ݺͲʵڲ IA ύ
         * @param comp - The committed renderable component
         * @param ia - The committed [[gfx.InputAssembler]]
         * @param tex - The texture used
         * @param mat - The material used
         * @param [transform] - The related node transform if the render data is based on node's local coordinates
         * @deprecated since v3.6.2, please use [[commitMiddleware]] instead
         */
        commitIA(renderComp: UIRenderer, ia: gfx.InputAssembler, tex?: __private._cocos_asset_assets_texture_base__TextureBase, mat?: Material, transform?: Node): void;
        /**
         * @en
         * Render component data submission process for middleware2d components
         * @zh
         * Ⱦ2DмȾݵύ
         * 磺Spine  DragonBones ̬ݺͲʵ
         * @param comp - The committed renderable component
         * @param meshBuffer - The MeshBuffer used
         * @param indexOffset - indices offset
         * @param indexCount - indices count
         * @param tex - The texture used
         * @param mat - The material used
         * @param enableBatch - component support multi draw batch or not
         */
        commitMiddleware(comp: UIRenderer, meshBuffer: MeshBuffer, indexOffset: number, indexCount: number, tex: __private._cocos_asset_assets_texture_base__TextureBase, mat: Material, enableBatch: boolean): void;
        /**
         * @en
         * Render component data submission process of UI.
         * The submitted vertex data is the UI for local coordinates.
         * For example: The UI components of Graphics and UIModel.
         *
         * @zh
         * UI Ⱦύ̣磺 Graphics  UIModel ΪӴ ui 
         *
         * @param comp - The committed renderable component
         * @param model - The committed model
         * @param mat - The material used, could be null
         */
        commitModel(comp: UIMeshRenderer | UIRenderer, model: renderer.scene.Model | null, mat: Material | null): void;
        setupStaticBatch(staticComp: UIStaticBatch, bufferAccessor: __private._cocos_2d_renderer_static_vb_accessor__StaticVBAccessor): void;
        endStaticBatch(): void;
        /**
         * @en
         * Submit separate render data.
         * This data does not participate in the batch.
         *
         * @zh
         * ύȾ.
         * @param comp @en The UIStaticBatch component.
         *             @zh ̬
         */
        commitStaticBatch(comp: UIStaticBatch): void;
        /**
         * @en
         * End a section of render data and submit according to the batch condition.
         *
         * @zh
         * ݺһȾݲύ
         */
        autoMergeBatches(renderComp?: UIRenderer): void;
        /**
         * @en
         * Force changes to current batch data and merge
         *
         * @zh
         * ǿ޸ĵǰݲϲ
         *
         * @param material @en The material of the current batch.
         *                 @zh ǰεĲʡ
         * @param sprite @en Sprite frame of current batch.
         *               @zh ǰεľ֡
         */
        forceMergeBatches(material: Material, frame: __private._cocos_asset_assets_texture_base__TextureBase | SpriteFrame | null, renderComp: UIRenderer): void;
        resetRenderStates(): void;
        /**
         * @en
         * Forced to merge the data of the previous batch to start a new batch.
         *
         * @zh
         * ǿƺϲһεݣһֺ
         */
        finishMergeBatches(): void;
        /**
         * @en
         * Force to change the current material.
         *
         * @zh
         * ǿˢ²ʡ
         */
        flushMaterial(mat: Material): void;
        walk(node: Node, level?: number): void;
        syncMeshBuffersToNative(accId: number, buffers: MeshBuffer[]): void;
    }
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     * @internal
     */
    export class UIDrawBatch extends __private._cocos_2d_renderer_draw_batch__DrawBatch2D {
    }
    export class QuadRenderData extends MeshRenderData {
        constructor(vertexFormat: any);
    }
    /**
     * @en A utils class for parsing HTML texts. The parsed results will be an object array.
     * @zh һڽHTMLıĹࡣĽһ顣
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export interface IHtmlTextParserResultObj {
        text?: string;
        style?: IHtmlTextParserStack;
    }
    /**
     * @en Html Text Parser Stack interface
     * @zh Html ıӿ
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export interface IHtmlTextParserStack {
        color?: string;
        size?: number;
        event?: {
            [k: string]: string;
        };
        isNewLine?: boolean;
        isImage?: boolean;
        src?: string;
        imageWidth?: number;
        imageHeight?: number;
        imageOffset?: string;
        imageAlign?: string;
        underline?: boolean;
        italic?: boolean;
        bold?: boolean;
        outline?: {
            color: string;
            width: number;
        };
    }
    /**
     * @en Html Text Parser Stack
     * @zh Html ı
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class HtmlTextParser {
        constructor();
        parse(htmlString: string): IHtmlTextParserResultObj[];
    }
    export function getBaselineOffset(): number;
    /**
     * @deprecated since v3.7.2, this is an engine private interface that will be removed in the future.
     */
    export function isUnicodeCJK(ch: string): boolean;
    /**
     * @deprecated since v3.7.2, this is an engine private interface that will be removed in the future.
     */
    export function isUnicodeSpace(ch: string): boolean;
    /**
     * @deprecated since v3.7.2, this is an engine private interface that will be removed in the future.
     */
    export function safeMeasureText(ctx: CanvasRenderingContext2D, string: string, desc?: string): number;
    export function getSymbolLength(str: string): number;
    export function getSymbolAt(str: string, index: number): string;
    export function getSymbolCodeAt(str: string, index: number): string;
    /**
     * @deprecated since v3.7.2, this is an engine private interface that will be removed in the future.
     */
    export function fragmentText(stringToken: string, allWidth: number, maxWidth: number, measureText: (string: string) => number): string[];
    export const BASELINE_RATIO = 0.26;
    export const MIDDLE_RATIO: number;
    export class LRUCache {
        constructor(size: any);
        moveToHead(node: any): void;
        put(key: any, value: any): void;
        remove(node: any): void;
        get(key: any): number | null;
        clear(): void;
        has(key: any): boolean;
        delete(key: any): void;
    }
    /**
     * @en The dynamic atlas manager which manages all runtime dynamic packed atlas texture for UI rendering.
     * It generates a maximum of [[maxAtlasCount]] atlas texture, all atlas texture have the size of [[textureSize]].
     * Normally the [[Root.batcher2D]] is in charge of submitting sprite frames to the dynamic atlas manager, the process is transparent to user.
     * Note that the first committed sprite frame will define the filter settings of the atlas textures,
     * only sprite frame with the same setting will be accepted afterward.
     * @zh ̬ͼĹʱ̬ϳɵͼҪ UI Ⱦ
     * ù֧ [[maxAtlasCount]] Ŷ̬ͼкͼͬ [[textureSize]] سߴ硣
     * һ˵ [[Root.batcher2D]] ύ [[SpriteFrame]] ̬ͼУ̶ڿ͸ġ
     * Ҫעǣһύ [[SpriteFrame]] ͼĹڴֻ֮ͬͼŻᱻܡ
     */
    export class DynamicAtlasManager extends System {
        static instance: DynamicAtlasManager;
        /**
         * @en
         * Enable or disable the dynamic atlas.
         *
         * @zh
         * رն̬ͼ
         */
        get enabled(): boolean;
        set enabled(value: boolean);
        /**
         * @en
         * The maximum number of atlases that can be created.
         *
         * @zh
         * Դͼ
         */
        get maxAtlasCount(): number;
        set maxAtlasCount(value: number);
        /**
         * @en
         * Get the current created atlas count.
         *
         * @zh
         * ȡǰѾͼ
         */
        get atlasCount(): number;
        /**
         * @en
         * Whether to enable textureBleeding.
         *
         * @zh
         * Ƿ textureBleeding
         */
        get textureBleeding(): boolean;
        set textureBleeding(enable: boolean);
        /**
         * @en
         * The size of the created atlas.
         *
         * @zh
         * ͼĿߡ
         */
        get textureSize(): number;
        set textureSize(value: number);
        /**
         * @en
         * The maximum size of the picture that can be added to the atlas.
         *
         * @zh
         * ӽͼͼƬߴ硣
         */
        get maxFrameSize(): number;
        set maxFrameSize(value: number);
        /**
         * @internal
         */
        init(): void;
        /**
         * @en
         * Append a sprite frame into the dynamic atlas.
         *
         * @zh
         * ͼ붯̬ͼ
         *
         * @method insertSpriteFrame
         * @param spriteFrame  the sprite frame that will be inserted in the atlas.
         */
        insertSpriteFrame(spriteFrame: any): {
            x: number;
            y: number;
            texture: __private._cocos_2d_utils_dynamic_atlas_atlas__DynamicAtlasTexture;
        } | null;
        /**
         * @en
         * Reset all dynamic atlases, and all existing ones will be destroyed.
         *
         * @zh
         * ж̬ͼеĶ̬ͼᱻ١
         *
         * @method reset
         */
        reset(): void;
        /**
         * @en
         * Delete a sprite from the atlas.
         *
         * @zh
         * Ӷ̬ͼɾĳͼ
         *
         * @method deleteAtlasSpriteFrame
         * @param spriteFrame  the sprite frame that will be removed from the atlas.
         */
        deleteAtlasSpriteFrame(spriteFrame: any): void;
        /**
         * @en
         * Delete a texture from the atlas.
         *
         * @zh
         * Ӷ̬ͼɾĳ
         *
         * @method deleteAtlasTexture
         * @param texture  the texture that will be removed from the atlas.
         */
        deleteAtlasTexture(texture: any): void;
        /**
         * @en
         * Pack the sprite in the dynamic atlas and update the atlas information of the sprite frame.
         *
         * @zh
         * ͼƬ붯̬ͼ¸ͼƬͼϢ
         *
         * @method packToDynamicAtlas
         * @param frame  the sprite frame that will be packed in the dynamic atlas.
         */
        packToDynamicAtlas(comp: any, frame: any): void;
    }
    /**
     * @en The singleton instance of [[DynamicAtlasManager]], please use [[DynamicAtlasManager.instance]] instead.
     * @zh [[DynamicAtlasManager]] ĵֱʹ [[DynamicAtlasManager.instance]]
     * @deprecated since v3.7
     */
    export const dynamicAtlasManager: DynamicAtlasManager;
    export namespace utils {
        /**
         * @en Finds a node by hierarchy path, the path is case-sensitive.
         * It will traverse the hierarchy by splitting the path using '/' character.
         * This function will still returns the node even if it is inactive.
         * It is recommended to not use this function every frame instead cache the result at startup.
         * @zh ͨ·ӽڵвҽڵķ·ǴСдеģͨ `/` ָڵ㼶
         * ʹڵ״̬δõҲҵ齫棬ÿҪȥҡ
         * @param path The path of the target node
         * @param referenceNode If given, the search will be limited in the sub node tree of the reference node
         */
        export function find(path: string, referenceNode?: Node): Node | null;
        /**
         * @en
         * save a color buffer to a PPM file
         * @zh
         * һɫ嵽 PPM ļ
         * @param buffer color buffer
         * @param w width
         * @param h height
         */
        export function toPPM(buffer: Uint8Array, w: number, h: number): string;
        export function readMesh(mesh: Mesh, iPrimitive?: number): primitives.IGeometry;
        /**
         * @deprecated
         */
        export function createMesh(geometry: primitives.IGeometry, out?: Mesh, options?: primitives.ICreateMeshOptions): Mesh;
        export namespace createMesh {
            /**
             * @deprecated
             */
            export interface IOptions {
                /**
                 * @en calculate mesh's aabb or not
                 * @zh Ƿģ͵İΧС
                 */
                calculateBounds?: boolean;
            }
        }
        /**
         * @en mesh utility class, use to create mesh.
         * @zh 񹤾࣬ڴ
         */
        export class MeshUtils {
            /**
             * @en create a static mesh.
             * @zh һ̬
             * @param geometry @en geometry data use for creating @zh ڴļ
             * @param out @en output static mesh @zh ľ̬
             * @param options @en options of creating @zh ѡ
             * @return @en The created static mesh, which is same as out @zh ´ľ̬ͬ out 
             */
            static createMesh(geometry: primitives.IGeometry, out?: Mesh, options?: primitives.ICreateMeshOptions): Mesh;
            /**
             * @en create a dynamic mesh.
             * @zh һ̬
             * @param primitiveIndex @en sub mesh index @zh 
             * @param geometry @en geometry data use for creating @zh ڴļ
             * @param out @en output dynamic mesh @zh Ķ̬
             * @param options @en options of creating @zh ѡ
             * @return @en The created dynamic mesh, which is same as out @zh ´Ķ̬ͬ out 
             */
            static createDynamicMesh(primitiveIndex: number, geometry: primitives.IDynamicGeometry, out?: Mesh, options?: primitives.ICreateDynamicMeshOptions): Mesh;
        }
        export function readBuffer(target: DataView, format?: gfx.Format, offset?: number, length?: number, stride?: number, out?: number[]): number[];
        export function writeBuffer(target: DataView, data: number[], format?: gfx.Format, offset?: number, stride?: number): void;
        export function mapBuffer(target: DataView, callback: (cur: number, idx: number, view: DataView) => number, format?: gfx.Format, offset?: number, length?: number, stride?: number, out?: DataView): DataView;
    }
    /**
     * @en Utility for 3d model static batching
     * @zh  3D ģ;̬Ĺ
     */
    export class BatchingUtility {
        /**
         * @en
         * Collect the Models under `staticModelRoot`,
         * merge all the meshes statically into one (while disabling each component),
         * and attach it to a new Model on `batchedRoot`.
         * The world transform of each model is guaranteed to be preserved.
         *
         * For a more fine-grained control over the process, use `Mesh.merge` directly.
         * @zh
         * `staticModelRoot`ռģ͡
         * е̬غϲһͬʱÿ
         * 丽ӵ `batchedRoot` ϵһģ͡
         * ÿģ͵任֤
         * Ҫ̽иϸĿƣֱʹ `Mesh.merge`
         * @param staticModelRoot root of all the static models to be batched
         * @param batchedRoot the target output node
         */
        static batchStaticModel(staticModelRoot: Node, batchedRoot: Node): boolean;
        /**
         * @en
         * Undoes everything `batchStaticModel` did.
         * @zh
         *  `batchStaticModel` Ĺ
         *
         * @param staticModelRoot root of all the static models to be batched
         * @param batchedRoot the target output node
         */
        static unbatchStaticModel(staticModelRoot: Node, batchedRoot: Node): boolean;
    }
    /**
     * @en A representation of a mesh asset
     * A mesh can contain multiple sub-mesh resources. The mesh mainly provides data such as vertices and indices for model instances.
     * @zh һԴ
     * һɰԴҪΪģʵṩ㣬
     */
    export class Mesh extends Asset {
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _nativeAsset(): ArrayBuffer;
        set _nativeAsset(value: ArrayBuffer);
        /**
         * @en The sub meshes count of the mesh.
         * @zh 
         * @deprecated Please use [[renderingSubMeshes.length]] instead
         */
        get subMeshCount(): number;
        /**
         * @en The minimum position of all vertices in the mesh
         * @zh Сڵڴκζλõλá
         * @deprecated Please use [[struct.minPosition]] instead
         */
        get minPosition(): Readonly<math.Vec3> | undefined;
        /**
         * @en The maximum position of all vertices in the mesh
         * @zh ڵڴκζλõλá
         * @deprecated Please use [[struct.maxPosition]] instead
         */
        get maxPosition(): Readonly<math.Vec3> | undefined;
        /**
         * @en The struct of the mesh
         * @zh Ľṹ
         */
        get struct(): Mesh.IStruct;
        /**
         * @en The actual data of the mesh
         * @zh ݡ
         */
        get data(): Uint8Array;
        /**
         * @en The hash of the mesh
         * @zh Ĺϣֵ
         */
        get hash(): number;
        /**
         * @en The index of the joint buffer of all sub meshes in the joint map buffers
         * @zh Ĺؽ
         */
        get jointBufferIndices(): number[];
        /**
         * @en The sub meshes for rendering. Mesh could be split into different sub meshes for rendering.
         * @zh 񴴽Ⱦ
         */
        get renderingSubMeshes(): RenderingSubMesh[];
        /**
         * @en morph rendering data
         * @zh Ⱦ
         */
        morphRendering: __private._cocos_3d_assets_morph_rendering__MorphRendering | null;
        constructor();
        /**
         * @en complete loading callback
         * @zh ɻص
         */
        onLoaded(): void;
        /**
         * @en mesh init
         * @zh ʼ
         */
        initialize(): void;
        /**
         * @en update dynamic sub mesh geometry
         * @zh ¶̬ļ
         * @param primitiveIndex @en sub mesh index @zh 
         * @param dynamicGeometry @en sub mesh geometry data @zh 񼸺
         */
        updateSubMesh(primitiveIndex: number, dynamicGeometry: primitives.IDynamicGeometry): void;
        /**
         * @en Destroy the mesh and release all related GPU resources
         * @zh ٴ񣬲ͷռе GPU Դ
         */
        destroy(): boolean;
        /**
         * @en Release all related GPU resources
         * @zh ͷŴռе GPU Դ
         */
        destroyRenderingMesh(): void;
        /**
         * @en Reset the struct and data of the mesh
         * @zh ôĽṹݡ
         * @param struct @en The new struct @zh ½ṹ
         * @param data @en The new data @zh 
         * @deprecated Will be removed in v3.0.0, please use [[reset]] instead
         */
        assign(struct: Mesh.IStruct, data: Uint8Array): void;
        /**
         * @en Reset the mesh with mesh creation information
         * @zh ô
         * @param info @en Mesh creation information including struct and data @zh 񴴽Ϣṹ
         */
        reset(info: Mesh.ICreateInfo): void;
        /**
         * @en Get [[geometry.AABB]] bounds in the skeleton's bone space
         * @zh ȡ任ռµ [[geometry.AABB]] Χ
         * @param skeleton @en skeleton data @zh Ϣ
         * @param skeleton @en skeleton data @zh Ϣ
         */
        getBoneSpaceBounds(skeleton: Skeleton): (geometry.AABB | null)[];
        /**
         * @en Merge the given mesh into the current mesh
         * @zh ϲָ񵽴С
         * @param mesh @en The mesh to be merged @zh Ҫϲ
         * @param worldMatrix @en The world matrix of the given mesh @zh ģͱ任
         * @param validate @en Whether to validate the mesh @zh Ƿ֤񶥵㲼
         * @returns @en whether the merging was successful or not @zh غϲɹ
         */
        merge(mesh: Mesh, worldMatrix?: math.Mat4, validate?: boolean): boolean;
        /**
         * @en Validation for whether the given mesh can be merged into the current mesh.
         * To pass the validation, it must satisfy either of these two requirements:
         * - When the current mesh have no data
         * - When the two mesh have the same vertex bundle count, the same sub meshes count, and the same sub mesh layout.
         *
         * Same mesh layout means:
         * - They have the same primitive type and reference to the same amount vertex bundle with the same indices.
         * - And they all have or don't have index view
         * @zh ָ֤ǷԺϲǰ
         *
         * ֮һʱָԺϲǰ
         *  - ǰݶϲݣ
         *  - ǵĶĿͬҶӦĲһ£ǵĿͬҶӦĲһ¡
         *
         * 鲼һµҽ
         *  - ǾͬĶҶӦĶԾͬԸʽ
         *
         * 񲼾һ£ҽ
         *  - ǾͬͼԪͲͬͬĶ飻ң
         *  - ҪôҪƣҪôҪơ
         * @param mesh @en The other mesh to be validated @zh ֤
         */
        validateMergingMesh(mesh: Mesh): boolean;
        /**
         * @en Read the requested attribute of the given sub mesh
         * @zh ȡָԡ
         * @param primitiveIndex @en Sub mesh index @zh 
         * @param attributeName @en Attribute name @zh 
         * @returns @en Return null if not found or can't read, otherwise, will create a large enough typed array to contain all data of the attribute,
         * the array type will match the data type of the attribute. @zh ȡʧܷ null 򷵻ضӦ
         */
        readAttribute(primitiveIndex: number, attributeName: gfx.AttributeName): __private.__types_globals__TypedArray | null;
        /**
         * @en Read the requested attribute of the given sub mesh and fill into the given buffer.
         * @zh ȡָԵĿ껺С
         * @param primitiveIndex @en Sub mesh index @zh 
         * @param attributeName @en Attribute name @zh 
         * @param buffer @en The target array buffer @zh Ŀ껺
         * @param stride @en attribute stride @zh Կ
         * @param offset @en The offset of the first attribute in the target buffer @zh һĿ껺ƫ
         * @returns @en false if failed to access attribute, true otherwise @zh Ƿɹ
         */
        copyAttribute(primitiveIndex: number, attributeName: gfx.AttributeName, buffer: ArrayBuffer, stride: number, offset: number): boolean;
        /**
         * @en Read the indices data of the given sub mesh
         * @zh ȡݡ
         * @param primitiveIndex @en Sub mesh index @zh 
         * @returns @en Return null if not found or can't read, otherwise, will create a large enough typed array to contain all indices data,
         * the array type will use the corresponding stride size. @zh ȡʧܷ null򷵻
         */
        readIndices(primitiveIndex: number): Uint8Array | Uint16Array | Uint32Array | null;
        /**
         * @en Read the indices data of the given sub mesh and fill into the given array
         * @zh ȡݵĿС
         * @param primitiveIndex @en Sub mesh index @zh 
         * @param outputArray @en The target output array @zh Ŀ
         * @returns @en Return false if failed to access the indices data, return true otherwise. @zh ʧܷ false 򷵻 true
         */
        copyIndices(primitiveIndex: number, outputArray: number[] | ArrayBufferView): boolean;
        /**
         * @en Read the format by attributeName of submesh
         * @zh ȡϢ
         * @param primitiveIndex @en Sub mesh index @zh 
         * @param attributeName @en Attribute name @zh 
         * @returns @en Return null if failed to read format, return the format otherwise. @zh ȡʧܷ null 򷵻 format
         */
        readAttributeFormat(primitiveIndex: number, attributeName: gfx.AttributeName): gfx.FormatInfo | null;
        /**
         * @en default init
         * @zh Ĭϳʼ
         * @param uuid @en asset uuid @zh Դ uuid
         */
        initDefault(uuid?: string): void;
        /**
         * @en Set whether the data of this mesh could be accessed (read or wrote), it could be used only for static mesh
         * @zh ôǷɱȡ˽ӿֻԾ̬ԴЧ
         * @param allowDataAccess @en Indicate whether the data of this mesh could be accessed (read or wrote) @zh Ƿȡ
         */
        set allowDataAccess(allowDataAccess: boolean);
        /**
         * @en Get whether the data of this mesh could be read or wrote
         * @zh ȡǷɱȡ
         * @return @en whether the data of this mesh could be accessed (read or wrote) @zh Ƿɱȡ
         */
        get allowDataAccess(): boolean;
    }
    export namespace Mesh {
        export interface IBufferView {
            offset: number;
            length: number;
            count: number;
            stride: number;
        }
        /**
         * @en Vertex bundle, it describes a set of interleaved vertex attributes and their values.
         * @zh 顣һ****interleavedĶԲ洢˶Եʵݡ<br>
         * ָʵݵĻУÿУǳһ֮ǰ
         */
        export interface IVertexBundle {
            /**
             * @en The actual value for all vertex attributes.
             * You must use DataView to access the data.
             * Because there is no guarantee that the starting offsets of all properties are byte aligned as required by TypedArray.
             * @zh жԵʵݿ顣
             * ʹ DataView ȡݡ
             * Ϊܱ֤Եʼƫƶ TypedArray Ҫֽڶ롣
             */
            view: IBufferView;
            /**
             * @en All attributes included in the bundle
             * @zh жԡ
             */
            attributes: gfx.Attribute[];
        }
        export interface IMeshCluster {
            clusterView: IBufferView;
            triangleView: IBufferView;
            vertexView: IBufferView;
            coneView?: IBufferView;
        }
        /**
         * @en Sub mesh contains a list of primitives with the same type (Point, Line or Triangle)
         * @zh һϵͬ͵ͼԪɣ㡢ߡȣ
         */
        export interface ISubMesh {
            /**
             * @en The vertex bundle references used by the sub mesh.
             * @zh õĶ飬Ķ顣
             */
            vertexBundelIndices: number[];
            /**
             * @en The primitive mode of the sub mesh
             * @zh ͼԪ͡
             */
            primitiveMode: gfx.PrimitiveMode;
            /**
             * @en The index data of the sub mesh
             * @zh ʹõݡ
             */
            indexView?: IBufferView;
            /**
             * @en The joint map index in [[IStruct.jointMaps]]. Could be absent
             * @zh ʹõĹؽӳ [[IStruct.jointMaps]] е
             * δָӳڣĬ VB йؽֱӶӦԴݡ
             */
            jointMapIndex?: number;
            /**
             * @en The cluster data of the sub mesh
             */
            cluster?: IMeshCluster;
        }
        /**
         * @en dynamic info used to create dyanmic mesh
         * @zh ̬Ϣڴ̬
         */
        export interface IDynamicInfo {
            /**
             * @en max submesh count
             * @zh ģ͸
             */
            maxSubMeshes: number;
            /**
             * @en max submesh vertex count
             * @zh ģ󶥵
             */
            maxSubMeshVertices: number;
            /**
             * @en max submesh index count
             * @zh ģ
             */
            maxSubMeshIndices: number;
        }
        /**
         * @en dynamic struct
         * @zh ̬ṹ
         */
        export interface IDynamicStruct {
            /**
             * @en dynamic mesh info
             * @zh ̬ģϢ
             */
            info: IDynamicInfo;
            /**
             * @en dynamic submesh bounds
             * @zh ̬ģͰΧС
             */
            bounds: geometry.AABB[];
        }
        /**
         * @en The structure of the mesh
         * @zh Ľṹ
         */
        export interface IStruct {
            /**
             * @en All vertex bundles of the mesh
             * @zh еĶ顣
             */
            vertexBundles: IVertexBundle[];
            /**
             * @en All sub meshes
             * @zh 
             */
            primitives: ISubMesh[];
            /**
             * @en The minimum position of all vertices in the mesh
             * @zh Сڵڴκζλõλá
             */
            minPosition?: math.Vec3;
            /**
             * @en The maximum position of all vertices in the mesh
             * @zh ڵڴκζλõСλá
             */
            maxPosition?: math.Vec3;
            /**
             * @en The joint index map list.
             * @zh ʹõĹؽӳϵб鳤ӦΪģʵʹõйؽڣ
             * ÿԪضӦһԭԴģ VB ڵʵС
             */
            jointMaps?: number[][];
            /**
             * @en The morph information of the mesh
             * @zh α
             */
            morph?: Morph;
            /**
             * @en The specific data of the dynamic mesh
             * @zh ̬
             */
            dynamic?: IDynamicStruct;
            /**
             * @en Whether the mesh data is quantized to reduce memory usage
             * @zh Ƿ񾭹Լڴռá
             */
            quantized?: boolean;
            /**
             * @en Whether the mesh data is encoded to reduce memory usage
             * @zh
             */
            encoded?: boolean;
            /**
             * @en Whether the mesh data is compressed to reduce memory usage
             * @zh Ƿ񾭹ѹԼڴռá
             */
            compressed?: boolean;
            /**
             * @en Whether the mesh contains cluster data
             * @zh Ƿ cluster ݡ
             */
            cluster?: boolean;
        }
        /**
         * @en The create info of the mesh
         * @zh 񴴽Ϣ
         */
        export interface ICreateInfo {
            /**
             * @en Mesh structure
             * @zh ṹ
             */
            struct: Mesh.IStruct;
            /**
             * @en Mesh binary data
             * @zh ݡ
             */
            data: Uint8Array;
        }
    }
    /**
     * @en The skeleton asset. It stores the path related to [[SkinnedMeshRenderer.skinningRoot]] of all bones and its bind pose matrix.
     * @zh ԴԴ¼ÿؽڣ [[SkinnedMeshRenderer.skinningRoot]]·Լİƾ
     */
    export class Skeleton extends Asset {
        /**
         * @en The path of all bones, the length always equals the length of [[bindposes]]
         * @zh йؽڵ·ĳʼ [[bindposes]] ĳͬ
         */
        get joints(): string[];
        set joints(value: string[]);
        /**
         * @en The bind poses matrix of all bones, the length always equals the length of [[joints]]
         * @zh йؽڵİƾ󡣸ĳʼ [[joints]] ĳͬ
         */
        get bindposes(): math.Mat4[];
        set bindposes(value: math.Mat4[]);
        /**
         * @en Gets the inverse bind poses matrix
         * @zh ȡƾ
         */
        get inverseBindposes(): math.Mat4[];
        /**
         * @en Gets the hash of the skeleton asset
         * @zh ȡԴĹϣֵ
         */
        get hash(): number;
        destroy(): boolean;
        /**
         * @en Check whether the skeleton is validate which means it has both joints and bindposes data.
         * @zh 鵱ǰǷЧģȡǷؽ·Ͱݡ
         * @returns @en Whether the skeleton is valid or not @zh ˹ǷЧ
         */
        validate(): boolean;
    }
    /**
     * @en Mesh morph data structure to describe the sub meshes data of all sub meshes,
     * it also contains all sub mesh morphs, global weights configuration and target names.
     * Normally the global weights configuration should be identical to the sub mesh morph weights,
     * but if not, the global weights in morph is less prioritized.
     * @zh αݽṹαݣȫֵȨúαĿơ
     * һ˵ȫȨúαбһ£в죬αеȨΪ׼
     */
    export interface Morph {
        /**
         * Morph data of each sub-mesh.
         */
        subMeshMorphs: (SubMeshMorph | null)[];
        /**
         * Common initial weights of each sub-mesh.
         */
        weights?: number[];
        /**
         * Name of each target of each sub-mesh morph.
         * This field is only meaningful if every sub-mesh has the same number of targets.
         */
        targetNames?: string[];
    }
    /**
     * @en Morph target contains all displacements data of each vertex attribute like position and normal.
     * @zh αĿݰ񶥵αµı仯ֵܰλơߵ
     */
    export interface MorphTarget {
        /**
         * Displacement of each target attribute.
         */
        displacements: Mesh.IBufferView[];
    }
    /**
     * @en Sub mesh morph data describes all morph targets for one sub mesh,
     * including attributes in each morph target, morph targets data and weights corresponding each targets.
     * @zh αһеαĿݣαԣαĿݺͶӦÿαĿȨء
     */
    export interface SubMeshMorph {
        /**
         * Attributes to morph.
         */
        attributes: gfx.AttributeName[];
        /**
         * Targets.
         */
        targets: MorphTarget[];
        /**
         * Initial weights of each target.
         */
        weights?: number[];
    }
    /**
     * @en Mesh renderer component for general 3d model rendering, it generates and link to a Model in the render scene.
     * It supports real time lighting and shadow, baked light map, and morph rendering.
     * @zh ͨģȾȾᴴһȾеģͶ
     * ֧ʵʱպӰԤ決ͼαȾ
     */
    export class MeshRenderer extends ModelRenderer {
        /**
         * @en Shadow projection mode enumeration.
         * @zh ӰͶ䷽ʽö١
         */
        static ShadowCastingMode: {
            /**
             * @en Disable shadow projection.
             * @zh ͶӰ
             */
            OFF: number;
            /**
             * @en Enable shadow projection.
             * @zh ӰͶ䡣
             */
            ON: number;
        };
        /**
         * @en Shadow receive mode enumeration.
         * @zh Ӱշʽö١
         */
        static ShadowReceivingMode: {
            /**
             * @en Disable shadow receiving.
             * @zh Ӱ
             */
            OFF: number;
            /**
             * @en Enable shadow receiving.
             * @zh ӰͶ䡣
             */
            ON: number;
        };
        /**
         * @en The settings for GI baking, it was called lightmapSettings before
         * @zh ȫֹպ決ãǰΪlightmapSettings
         */
        bakeSettings: __private._cocos_3d_framework_mesh_renderer__ModelBakeSettings;
        protected _mesh: Mesh | null;
        protected _shadowCastingMode: number;
        protected _shadowReceivingMode: number;
        protected _shadowBias: number;
        protected _shadowNormalBias: number;
        protected _reflectionProbeId: number;
        protected _reflectionProbeBlendId: number;
        protected _reflectionProbeBlendWeight: number;
        protected _enabledGlobalStandardSkinObject: boolean;
        protected _reflectionProbeDataMap: Texture2D | null;
        /**
         * @en Local shadow bias for real time lighting.
         * @zh ʵʱģ;ֲӰƫơ
         */
        get shadowBias(): number;
        set shadowBias(val: number);
        /**
         * @en local shadow normal bias for real time lighting.
         * @zh ʵʱģ;ֲӰƫơ
         */
        get shadowNormalBias(): number;
        set shadowNormalBias(val: number);
        /**
         * @en Shadow projection mode.
         * @zh ʵʱӰͶ䷽ʽ
         */
        get shadowCastingMode(): number;
        set shadowCastingMode(val: number);
        get shadowCastingModeForInspector(): boolean;
        set shadowCastingModeForInspector(val: boolean);
        /**
         * @en Is received direction Light.
         * @zh Ƿƽйա
         * @param visibility @en direction light visibility. @zh Ŀɼԡ
         */
        onUpdateReceiveDirLight(visibility: number, forceClose?: boolean): void;
        /**
         * @en receive shadow.
         * @zh ʵʱǷӰ
         */
        get receiveShadow(): number;
        set receiveShadow(val: number);
        get receiveShadowForInspector(): boolean;
        set receiveShadowForInspector(val: boolean);
        /**
         * @en Gets or sets the mesh of the model.
         * Note, when set, all morph targets' weights would be reset to zero.
         * @zh ȡģ͵ݡ
         * ע⣬ʱαĿȨض㡣
         */
        get mesh(): Mesh | null;
        set mesh(val: Mesh | null);
        /**
         * @en Gets the model in [[RenderScene]].
         * @zh ȡȾ [[RenderScene]] жӦģ͡
         */
        get model(): renderer.scene.Model | null;
        /**
         * @en Whether to enable morph rendering.
         * @zh ǷαȾ
         */
        get enableMorph(): boolean;
        set enableMorph(value: boolean);
        /**
         * @en Set the Separable-SSS skin standard model component.
         * @zh Ƿȫֵ4s׼ģ
         */
        get isGlobalStandardSkinObject(): boolean;
        set isGlobalStandardSkinObject(val: boolean);
        protected _modelType: typeof renderer.scene.Model;
        protected _model: renderer.scene.Model | null;
        constructor();
        onLoad(): void;
        onRestore(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        onGeometryChanged(): void;
        /**
         * @zh ȡָαĿȨء
         * @en Gets the weight at specified morph target of the specified sub mesh.
         * @param subMeshIndex Index to the sub mesh.
         * @param shapeIndex Index to the morph target of the sub mesh.
         * @returns The weight.
         */
        getWeight(subMeshIndex: number, shapeIndex: number): number;
        /**
         * @zh
         * αĿȨء
         * `subMeshIndex` Ч `weights` ĳȲƥαĿʱ˷Ч
         * @en
         * Sets weights of each morph target of the specified sub mesh.
         * If takes no effect if `subMeshIndex` is out of bounds or if `weights` has a different length with morph targets count of the sub mesh.
         * @param weights The weights.
         * @param subMeshIndex Index to the sub mesh.
         */
        setWeights(weights: number[], subMeshIndex: number): void;
        /**
         * @zh
         * ָεȨء
         * `subMeshIndex`  `shapeIndex` Чʱ˷Ч
         * @en
         * Sets the weight at specified shape of specified sub mesh.
         * If takes no effect if
         * `subMeshIndex` or `shapeIndex` out of bounds.
         * @param weight The weight.
         * @param subMeshIndex Index to the sub mesh.
         * @param shapeIndex Index to the shape of the sub mesh.
         */
        setWeight(weight: number, subMeshIndex: number, shapeIndex: number): void;
        setInstancedAttribute(name: string, value: ArrayLike<number>): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _updateLightmap(lightmap: Texture2D | null, uOff: number, vOff: number, scale: number, lum: number): void;
        /**
         * @zh
         * ·̽決cubemap
         * @en
         * Updat cubemap baked with reflection probes.
         * @param cubeMap baked cubemap.
         * @param useDefaultTexture if the reflection probe has not been baked, is the skybox used instead.
         */
        updateProbeCubemap(cubeMap: TextureCube | null): void;
        /**
         * @zh
         * ڻϵķ̽決cubemap
         * @en
         * Updat cubemap baked with reflection probes for blending.
         * @param cubeMap baked cubemap.
         */
        updateProbeBlendCubemap(cubeMap: TextureCube | null): void;
        /**
         * @zh
         * ƽ淴Ⱦ
         * @en
         * Update the reflection rendering texture.
         * @param planarMap render texture.
         */
        updateProbePlanarMap(planarMap: gfx.Texture | null): void;
        /**
         * @zh
         * ·̽ͼ
         * @en
         * Update the data mapping of the reflection probe.
         * @param dataMap data mapping with data saved all reflection probe data.
         */
        updateReflectionProbeDataMap(dataMap: Texture2D | null): void;
        /**
         * @zh
         * ·̽id
         * @en
         * Update the id of the reflection probe.
         * @param probeId probe id.
         */
        updateReflectionProbeId(probeId: number): void;
        /**
         * @zh
         * ڻϵķ̽id
         * @en
         * Update the id of the reflection probe used for blending.
         * @param blendProbeId probe id of blend.
         */
        updateReflectionProbeBlendId(blendProbeId: number): void;
        /**
         * @zh
         * »Ȩء
         * @en
         * Update blending weight.
         * @param weight blending weight.
         */
        updateReflectionProbeBlendWeight(weight: number): void;
        protected _updateReflectionProbeTexture(): void;
        protected _updateModels(): void;
        protected _updateReceiveDirLight(): void;
        protected _createModel(): void;
        protected _attachToScene(): void;
        protected _updateModelParams(): void;
        protected _onUpdateLightingmap(): void;
        protected _onUpdateLocalShadowBiasAndProbeId(): void;
        protected _onUpdateLocalReflectionProbeData(): void;
        protected _onUpdateReflectionProbeDataMap(): void;
        protected _onMaterialModified(idx: number, material: Material | null): void;
        protected _onMeshChanged(old: Mesh | null): void;
        protected _clearMaterials(): void;
        protected _getBuiltinMaterial(): Material;
        protected _onVisibilityChange(val: number): void;
        protected _updateShadowBias(): void;
        protected _updateShadowNormalBias(): void;
        protected _updateCastShadow(): void;
        protected _updateReceiveShadow(): void;
        protected onMobilityChanged(): void;
        protected onLightProbeBakingChanged(): void;
        protected onUseLightProbeChanged(): void;
        protected onReflectionProbeChanged(): void;
        protected onBakeToReflectionProbeChanged(): void;
        protected _updateUseLightProbe(): void;
        protected _isBatchingEnabled(): boolean;
        protected _updateUseReflectionProbe(): void;
        protected _updateUseReflectionProbeType(): void;
        protected _updateBakeToReflectionProbe(): void;
    }
    export namespace MeshRenderer {
        /**
         * @en Shadow projection mode.
         * @zh ӰͶ䷽ʽ
         */
        export type ShadowCastingMode = __private.__types_globals__EnumAlias<typeof __private._cocos_3d_framework_mesh_renderer__ModelShadowCastingMode>;
        /**
         * @en Shadow receive mode.
         * @zh Ӱշʽ
         */
        export type ShadowReceivingMode = __private.__types_globals__EnumAlias<typeof __private._cocos_3d_framework_mesh_renderer__ModelShadowReceivingMode>;
    }
    /**
     * @en The directional light component, only one real time directional light is permitted in one scene, it act as the main light of the scene.
     * @zh ƽйԴһֻһʵʱƽйԴΪԴڡ
     */
    export class DirectionalLight extends Light {
        /**
         * @en The light source intensity.
         * @zh Դǿȡ
         */
        get illuminance(): number;
        set illuminance(val: number);
        /**
         * @en Whether activate real time shadow.
         * @zh ǷʵʱӰ
         */
        get shadowEnabled(): boolean;
        set shadowEnabled(val: boolean);
        /**
         * @en The shadow pcf for real time shadow.
         * @zh ʵʱӰеӰ pcf ȼ
         */
        get shadowPcf(): number;
        set shadowPcf(val: number);
        /**
         * @en The shadow map sampler offset for real time shadow.
         * @zh ʵʱӰеӰƫֵ
         */
        get shadowBias(): number;
        set shadowBias(val: number);
        /**
         * @en The global normal bias for real time shadow.
         * @zh ʵʱӰеķƫơ
         */
        get shadowNormalBias(): number;
        set shadowNormalBias(val: number);
        /**
         * @en The shadow color saturation for real time shadow.
         * @zh ʵʱӰеӰɫͶȡ
         */
        get shadowSaturation(): number;
        set shadowSaturation(val: number);
        /**
         * @en The potential shadow distance from the camera for real time shadow.
         * @zh ʵʱӰǱӰķΧ
         */
        get shadowDistance(): number;
        set shadowDistance(val: number);
        /**
         * @en The occlusion range for real time shadow.
         * @zh ʵʱӰ޳ӰķΧ
         */
        get shadowInvisibleOcclusionRange(): number;
        set shadowInvisibleOcclusionRange(val: number);
        /**
         * @en get or set shadow CSM level
         * @zh ȡӰ㼶
         */
        get csmLevel(): number;
        set csmLevel(val: number);
        /**
         * @en enable csm
         * @zh ر csm ģʽ
         */
        get enableCSM(): boolean;
        set enableCSM(val: boolean);
        /**
         * @en get or set shadow CSM level ratio
         * @zh ȡӰ㼶ϵ
         */
        get csmLayerLambda(): number;
        set csmLayerLambda(val: number);
        /**
         * @en get or set shadow CSM performance optimization mode
         * @zh ȡüӰŻģʽ
         * @internal
         */
        get csmOptimizationMode(): number;
        set csmOptimizationMode(val: number);
        /**
         * @en Whether to use fixed area shadow in real time shadow.
         * @zh ʵʱӰǷʹù̶Ӱ
         */
        get shadowFixedArea(): boolean;
        set shadowFixedArea(val: boolean);
        /**
         * @en The near clip plane of the shadow camera for fixed area shadow
         * @zh ̶ӰӰü
         */
        get shadowNear(): number;
        set shadowNear(val: number);
        /**
         * @en The far clip plane of the shadow camera for fixed area shadow.
         * @zh ̶ӰӰԶü档
         */
        get shadowFar(): number;
        set shadowFar(val: number);
        /**
         * @en The orthogonal size of the shadow camera for fixed area shadow.
         * @zh ̶ӰӰߴ
         */
        get shadowOrthoSize(): number;
        set shadowOrthoSize(val: number);
        /**
         * @en Enabled shadow advanced options
         * @zh Ƿø߼ѡ
         */
        get csmAdvancedOptions(): boolean;
        set csmAdvancedOptions(val: boolean);
        /**
         * @en Enabled csm layers transition
         * @zh ǷüӰ㼶ɣ
         */
        get csmLayersTransition(): boolean;
        set csmLayersTransition(val: boolean);
        /**
         * @en get or set csm layers transition range
         * @zh ȡüӰ㼶ɷΧ
         */
        get csmTransitionRange(): number;
        set csmTransitionRange(val: number);
        constructor();
        protected _createLight(): void;
        protected _onUpdateReceiveDirLight(): void;
    }
    /**
     * @en The base class of all light components, contains basic light settings for both real time light and baked light.
     * @zh Դ࣬ʵʱԴͺ決ԴĻϢ
     */
    export class Light extends Component {
        /**
         * @en The light type enumeration.
         * @zh Դö١
         */
        static Type: typeof renderer.scene.LightType;
        /**
         * @en The physical term used for light.
         * @zh Դʹõλ
         */
        static PhotometricTerm: {
            LUMINOUS_FLUX: number;
            LUMINANCE: number;
        };
        protected _color: math.Color;
        protected _useColorTemperature: boolean;
        protected _colorTemperature: number;
        protected _staticSettings: __private._cocos_3d_lights_light_component__StaticLightSettings;
        protected _visibility: number;
        protected _type: renderer.scene.LightType;
        protected _lightType: typeof renderer.scene.Light;
        protected _light: renderer.scene.Light | null;
        /**
         * @en The color of the light.
         * @zh Դɫ
         */
        get color(): Readonly<math.Color>;
        set color(val: Readonly<math.Color>);
        /**
         * @en
         * Whether to enable light color temperature.
         * @zh
         * ǷùԴɫ¡
         */
        get useColorTemperature(): boolean;
        set useColorTemperature(enable: boolean);
        /**
         * @en
         * The light color temperature.
         * @zh
         * Դɫ¡
         */
        get colorTemperature(): number;
        set colorTemperature(val: number);
        /**
         * @en
         * static light settings.
         * @zh
         * ̬ƹá
         */
        get staticSettings(): __private._cocos_3d_lights_light_component__StaticLightSettings;
        set staticSettings(val: __private._cocos_3d_lights_light_component__StaticLightSettings);
        /**
         * @en The light type.
         * @zh Դ͡
         */
        get type(): renderer.scene.LightType;
        /**
         * @en Whether the light is baked
         * @zh ԴǷ񱻺決
         */
        get baked(): boolean;
        set baked(val: boolean);
        /**
         * @en Visibility mask of the light, declaring a set of node layers that will be visible to this light.
         * @zh յĿɼ룬ڵǰпɼĽڵ㼶ϡ
         */
        set visibility(vis: number);
        get visibility(): number;
        constructor();
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        protected _createLight(): void;
        protected _destroyLight(): void;
        protected _attachToScene(): void;
        protected _detachFromScene(): void;
        protected _onUpdateReceiveDirLight(): void;
    }
    export namespace Light {
        export type Type = __private.__types_globals__EnumAlias<typeof renderer.scene.LightType>;
        export type PhotometricTerm = __private.__types_globals__EnumAlias<typeof __private._cocos_3d_lights_light_component__PhotometricTerm>;
    }
    /**
     * @en The sphere light component, multiple sphere lights can be added to one scene.
     * @zh ԴпӶԴ
     */
    export class SphereLight extends Light {
        /**
         * @en Luminous flux of the light.
         * @zh ͨ
         */
        get luminousFlux(): number;
        set luminousFlux(val: number);
        /**
         * @en Luminance of the light.
         * @zh ȡ
         */
        get luminance(): number;
        set luminance(val: number);
        /**
         * @en The photometric term currently being used.
         * @zh ǰʹõĹѧλ
         */
        get term(): number;
        set term(val: number);
        /**
         * @en
         * Size of the light.
         * @zh
         * ԴС
         */
        get size(): number;
        set size(val: number);
        /**
         * @en
         * Range of the light.
         * @zh
         * ԴΧ
         */
        get range(): number;
        set range(val: number);
        constructor();
        protected _createLight(): void;
    }
    /**
     * @en The spot light component, multiple spot lights can be added to one scene.
     * @zh ۹ƹԴпӶ۹ƹԴ
     */
    export class SpotLight extends Light {
        /**
         * @en Luminous flux of the light.
         * @zh ͨ
         */
        get luminousFlux(): number;
        set luminousFlux(val: number);
        /**
         * @en Luminance of the light.
         * @zh ȡ
         */
        get luminance(): number;
        set luminance(val: number);
        /**
         * @en The photometric term currently being used.
         * @zh ǰʹõĹѧλ
         */
        get term(): number;
        set term(val: number);
        /**
         * @en
         * Size of the light.
         * @zh
         * ԴС
         */
        get size(): number;
        set size(val: number);
        /**
         * @en
         * Range of the light.
         * @zh
         * ԴΧ
         */
        get range(): number;
        set range(val: number);
        /**
         * @en
         * The spot light cone angle.
         * @zh
         * ۹׶ǡ
         */
        get spotAngle(): number;
        set spotAngle(val: number);
        /**
         * @en The angle attenuation strength of the spot light.
         * The larger the value, the softer the edge, and the smaller the value, the harder the edge.
         * @zh ۹ƽǶ˥ǿȡֵԽ󣬱ԵԽֵͣԽСԵԽӲ
         */
        get angleAttenuationStrength(): number;
        set angleAttenuationStrength(val: number);
        /**
         * @en Whether activate shadow
         * @zh ǷӰ
         */
        get shadowEnabled(): boolean;
        set shadowEnabled(val: boolean);
        /**
         * @en The pcf level of the shadow generation.
         * @zh ȡӰ pcf ȼ
         */
        get shadowPcf(): number;
        set shadowPcf(val: number);
        /**
         * @en The depth offset of shadow to avoid moire pattern artifacts
         * @zh Ӱƫ, Լصµ״ʧ
         */
        get shadowBias(): number;
        set shadowBias(val: number);
        /**
         * @en The normal bias of the shadow map.
         * @zh û߻ȡƫơ
         */
        get shadowNormalBias(): number;
        set shadowNormalBias(val: number);
        constructor();
        protected _createLight(): void;
    }
    /**
     * @en The point light component, multiple point lights can be added to one scene.
     * @zh ԴпӶԴ
     */
    export class PointLight extends Light {
        /**
         * @en Luminous flux of the light.
         * @zh ͨ
         */
        get luminousFlux(): number;
        set luminousFlux(val: number);
        /**
         * @en Luminance of the light.
         * @zh ȡ
         */
        get luminance(): number;
        set luminance(val: number);
        /**
         * @en The photometric term currently being used.
         * @zh ǰʹõĹѧλ
         */
        get term(): number;
        set term(val: number);
        /**
         * @en Range of the light.
         * @zh ԴΧ
         */
        get range(): number;
        set range(val: number);
        constructor();
        protected _createLight(): void;
    }
    /**
     * @en The ranged directional light component, Multiple ranged directional light sources are allowed in a scene.
     * @zh ΧƽйԴһڶΧƽйԴ
     */
    export class RangedDirectionalLight extends Light {
        /**
         * @en The light source intensity.
         * @zh Դǿȡ
         */
        get illuminance(): number;
        set illuminance(val: number);
        constructor();
        protected _createLight(): void;
    }
    /**
     * @en The skinned mesh renderer component.
     * @zh ƤȾ
     */
    export class SkinnedMeshRenderer extends MeshRenderer {
        protected _skeleton: Skeleton | null;
        protected _skinningRoot: Node | null;
        protected _clip: AnimationClip | null;
        /**
         * @en The skeleton asset.
         * @zh Դ
         */
        get skeleton(): Skeleton | null;
        set skeleton(val: Skeleton | null);
        /**
         * @en The skinning root. (The node where the controlling Animation is located)
         * @zh ڵãӦƴģ͵Ķڽڵ㡣
         */
        get skinningRoot(): Node | null;
        set skinningRoot(value: Node | null);
        get model(): __private._cocos_3d_models_skinning_model__SkinningModel | __private._cocos_3d_models_baked_skinning_model__BakedSkinningModel | null;
        /**
         * Set associated animation.
         * @internal This method only friends to skeletal animation component.
         */
        associatedAnimation: SkeletalAnimation | null;
        constructor();
        onLoad(): void;
        onDestroy(): void;
        uploadAnimation(clip: AnimationClip | null): void;
        /**
         * Set if bake mode should be used.
         * @internal This method only friends to skeletal animation component.
         */
        setUseBakedAnimation(val?: boolean, force?: boolean): void;
        setSharedMaterial(material: Material | null, index: number): void;
        protected _updateModelParams(): void;
    }
    /**
     * @en The skinned mesh batch renderer component, batches multiple skeleton-sharing [[SkinnedMeshRenderer]].
     * @zh ƤģͺںϲƹͬһԴƤ
     */
    export class SkinnedMeshBatchRenderer extends SkinnedMeshRenderer {
        /**
         * @en Size of the generated texture atlas.
         * @zh ͼɵͼı߳
         */
        atlasSize: number;
        /**
         * @en
         * Texture properties that will be actually using the generated atlas.<br>
         * The first unit's texture will be used if not specified.
         * @zh
         * ͼͼԣͳһʹõһ unit ͼ
         */
        batchableTextureNames: string[];
        /**
         * @en Source skinning model components, containing all the data to be batched.
         * @zh ǰƤģ飬ҪԴ
         */
        units: SkinnedMeshUnit[];
        get mesh(): Mesh | null;
        set mesh(val: Mesh | null);
        get skeleton(): Skeleton | null;
        set skeleton(val: Skeleton | null);
        onLoad(): void;
        onDestroy(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _onMaterialModified(idx: number, material: Material | null): void;
        cook(): void;
        cookMaterials(): void;
        cookSkeletons(): void;
        cookMeshes(): void;
        protected cookTextures(target: Texture2D, prop: string, passIdx: number): void;
        protected createTexture(prop: string): Texture2D;
        protected resizeAtlases(): void;
    }
    export class SkinnedMeshUnit {
        /**
         * @en Skinned mesh of this unit.
         * @zh Ƥģ͵ģ͡
         */
        mesh: Mesh | null;
        /**
         * @en Skeleton of this unit.
         * @zh Ƥģ͵Ĺ
         */
        skeleton: Skeleton | null;
        /**
         * @en Skinning material of this unit.
         * @zh ƤģʹõĲʡ
         */
        material: Material | null;
        /**
         * @en Local transform matrix
         * @zh ر任
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _localTransform: math.Mat4;
        /**
         * @en UV offset on texture atlas.
         * @zh ͼе uv ƫơ
         */
        set offset(offset: math.Vec2);
        get offset(): math.Vec2;
        /**
         * @en UV extent on texture atlas.
         * @zh ͼռ UV ߴ硣
         */
        set size(size: math.Vec2);
        get size(): math.Vec2;
        /**
         * @en Convenient setter, copying all necessary information from target [[SkinnedMeshRenderer]] component.
         * @zh Ŀ [[SkinnedMeshRenderer]] ԵԪá
         */
        set copyFrom(comp: SkinnedMeshRenderer | null);
        get copyFrom(): SkinnedMeshRenderer | null;
    }
    export class LOD {
        protected _screenUsagePercentage: number;
        protected _renderers: MeshRenderer[];
        constructor();
        /**
         * @en Minimum percentage of screen usage for the current lod in effect, range in [0, 1]
         * @zh 㼶ЧʱռĻСٷֱ, ȡֵΧ[0, 1]
         */
        get screenUsagePercentage(): number;
        set screenUsagePercentage(val: number);
        /**
         * @en Get the list of [[MeshRenderer]] used by the current lod.
         * @zh ȡǰlodʹõ [[MeshRenderer]] б
         */
        get renderers(): readonly MeshRenderer[];
        /**
         * @en reset _renderers to meshList or [], LODData's model will be reset too.
         * @zh  _renderers Ϊ meshList, LODDataϵmodelҲᱻ
         */
        set renderers(meshList: readonly MeshRenderer[]);
        /**
         * @en Get the number of LOD.
         * @zh ȡLOD
         */
        get rendererCount(): number;
        /**
         * @en Insert a [[MeshRenderer]] before specific index position.
         * @zh ָһ[[MeshRenderer]]
         * @param index @en The rendering array is indexed from 0. If - 1 is passed, it will be added to the end of the list.
         * @zh renderers0ʼ-1ᱻӵбĩβ
         * @param renderer @en The mesh-renderer object. @zh [[MeshRenderer]] 
         * @returns @en The inserted [[MeshRenderer]] @zh ر [[MeshRenderer]] 
         */
        insertRenderer(index: number, renderer: MeshRenderer): MeshRenderer;
        /**
         * @en Delete the [[MeshRenderer]] at specific index position.
         * @zh ɾָ[[MeshRenderer]]
         * @param index @en 0 indexed position in renderer array, when -1 is specified, the last element will be deleted.
         * @zh _renderers0ʼ-1һԪػᱻɾ
         * @returns @en The deleted [[MeshRenderer]], or null if the specified index does not exist. @zh ָĶڣرɾ򷵻null
         */
        deleteRenderer(index: number): MeshRenderer | null;
        /**
         * @en Get the [[MeshRenderer]] at specific index position.
         * @zh ȡָ[[MeshRenderer]]
         * @param index @en Value range from 0 to _renderers's length. @zh ȡֵΧ[0, _renderers]
         * @return @en Returns the [[MeshRenderer]] at the specified index, or null if the specified index does not exist. @zh ָĶ򷵻null
         */
        getRenderer(index: number): MeshRenderer | null;
        /**
         * @en Update the [[MeshRenderer]] at specific index position.
         * @zh ָ [[MeshRenderer]]
         * @param index @en Value range from 0 to _renderers's length @zh ȡֵΧ [0, _renderers鳤]
         */
        setRenderer(index: number, renderer: MeshRenderer): void;
    }
    export class LODGroup extends Component {
        /**
         * @en Object reference point in local space, e.g. center of the bound volume for all LODs
         */
        protected _localBoundaryCenter: math.Vec3;
        /**
         * @en Object Size in local space, may be auto-calculated value from object bounding box or value from user input.
         */
        protected _objectSize: number;
        /**
         *@en The array of LODs
         */
        protected _LODs: LOD[];
        constructor();
        /**
         * @en Obtain LOD level numbers.
         * @zh ȡLOD㼶
         */
        get lodCount(): number;
        /**
         * @en Set current AABB's size.
         * @zh õǰΧеĴС
         */
        set objectSize(val: number);
        /**
         * @en Get current AABB's size.
         * @zh ȡǰΧеĴС
         */
        get objectSize(): number;
        /**
         * @en Get LOD array config.
         * @zh ȡ LOD 
         */
        get LODs(): readonly LOD[];
        /**
         * @en Reset current LODs to new value.
         * @  LODs Ϊǰõֵ
         */
        set LODs(valArray: readonly LOD[]);
        /**
         * @en Insert the [[LOD]] at specific index position, [[LOD]] will be inserted to the last position if index less than 0 or greater than lodCount.
         * @zh ָ [[LOD]], Ϊ򳬹lodCountĩβ
         * @param index @en location where lod is added. @zh lodλ
         * @param screenUsagePercentage @en The minimum screen usage percentage that the currently set lod starts to use, range in[0, 1].
         * @zh lodЧʱĻʾٷֱҪȡֵΧ[0, 1]
         * @param lod @en If this parameter is not set, it will be created by default. @zh ûڲ
         * @returns @en The new lod added. @zh رӵlod
         */
        insertLOD(index: number, screenUsagePercentage?: number, lod?: LOD): LOD;
        /**
         * @en Erase the [[LOD]] at specific index position.
         * @zh ɾָ [[LOD]]
         * @param index @en Index of the erased lod, range in [0, lodCount]. @zh ɾ, ȡֵΧ[0, lodCount]
         * @returns @en Erased lod. @zh ɾĶ
         */
        eraseLOD(index: number): LOD | null;
        /**
         * @en Get [[LOD]] at specific index position.
         * @zh ȡָ [[LOD]]
         * @param index @en Range in [0, lodCount]. @zh ȡֵΧ[0, lodCount]
         * @returns @en Lod at specified index, or null. @zh ָlodnull
         */
        getLOD(index: number): LOD | null;
        /**
         * @en Update the [[LOD]] at specific index position.
         * @zh ָ [[LOD]]
         * @param index, update lod at specified index.
         * @param lod, the updated lod.
         */
        setLOD(index: number, lod: LOD): void;
        /**
         * @en Recalculate the bounding box, and the interface will recalculate the localBoundaryCenter and objectSize
         * @zh ¼ΧУýӿڻ localBoundaryCenter  objectSize
         */
        recalculateBounds(): void;
        /**
         * @en reset current objectSize to 1, and recalculate screenUsagePercentage.
         * @zh  objectSize ĴСΪ1ýӿڻ¼ screenUsagePercentage
         */
        resetObjectSize(): void;
        /**
         * @zh ǿʹĳһLOD
         * @en Force LOD level to use.
         * lodLevel @en The LOD level to use. Passing lodLevel < 0 will return to standard LOD processing. @zh ҪʹõLOD㼶Ϊʱʹñ׼Ĵ
         */
        forceLOD(lodLevel: number): void;
        /**
         * @en Force multi LOD level to use, This function is only called in editor.<br/>
         * @zh ǿʹĳLOD,ýӿֻڱ༭µá
         * lodIndexArray @en The LOD level array. Passing [] will return to standard LOD processing. @zh ҪʹõLOD㼶飬[]ʱʹñ׼Ĵ̡
         */
        forceLODs(lodIndexArray: number[]): void;
        onLoad(): void;
        _onRemove(comp: Component): void;
        onRestore(): void;
        onEnable(): void;
        onDisable(): void;
    }
    export class ReflectionProbe extends Component {
        protected static readonly DEFAULT_CUBE_SIZE: Readonly<math.Vec3>;
        protected static readonly DEFAULT_PLANER_SIZE: Readonly<math.Vec3>;
        protected readonly _lastSize: math.Vec3;
        protected _resolution: number;
        protected _clearFlag: renderer.scene.ProbeClearFlag;
        protected _backgroundColor: math.Color;
        protected _visibility: number;
        protected _probeType: renderer.scene.ProbeType;
        protected _cubemap: TextureCube | null;
        protected readonly _size: math.Vec3;
        protected _sourceCamera: Camera | null;
        protected _probe: renderer.scene.ReflectionProbe | null;
        protected _previewSphere: Node | null;
        protected _previewPlane: Node | null;
        /**
         * @en
         * Gets or sets the size of the box
         * @zh
         * ȡðΧеĴС
         */
        set size(value: math.Vec3);
        get size(): math.Vec3;
        /**
         * @en Environment reflection or plane reflection.
         * @zh ̽ͣƽ淴
         */
        set probeType(value: renderer.scene.ProbeType);
        get probeType(): renderer.scene.ProbeType;
        /**
         * @en set render texture size
         * @zh ȾС
         */
        set resolution(value: number);
        get resolution(): number;
        /**
         * @en Clearing flags of the camera, specifies which part of the framebuffer will be actually cleared every frame.
         * @zh Ļ־λָ֡ĲҪÿ֡
         */
        set clearFlag(value: number);
        get clearFlag(): number;
        /**
         * @en Clearing color of the camera.
         * @zh ɫĬֵ
         */
        set backgroundColor(val: math.Color);
        get backgroundColor(): math.Color;
        /**
         * @en Visibility mask, declaring a set of node layers that will be visible to this camera.
         * @zh ɼ룬ڵǰпɼĽڵ㼶ϡ
         */
        get visibility(): number;
        set visibility(val: number);
        /**
         * @en The camera to render planar reflections, specified by the user
         * @zh ҪȾƽ淴ûָ
         */
        set sourceCamera(camera: Camera);
        get sourceCamera(): Camera;
        /**
         * @en fast bake no convolution.
         * @zh ٺ決о
         */
        get fastBake(): boolean;
        set fastBake(val: boolean);
        set cubemap(val: TextureCube | null);
        get cubemap(): TextureCube | null;
        get probe(): renderer.scene.ReflectionProbe;
        /**
         * @en Reflection probe cube mode preview sphere
         * @zh ̽cubeģʽԤС
         */
        set previewSphere(val: Node | null);
        get previewSphere(): Node | null;
        /**
         * @en Reflection probe planar mode preview plane
         * @zh ̽PlanarģʽԤƽ
         */
        set previewPlane(val: Node);
        get previewPlane(): Node;
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        start(): void;
        onDestroy(): void;
        update(dt: number): void;
        /**
         * @en Clear the baked cubemap.
         * @zh 決cubemap
         */
        clearBakedCubemap(): void;
    }
    /**
     * @en Use Reflection probe
     * @zh ʹ÷̽롣
     */
    export enum ReflectionProbeType {
        /**
         * @en Use the default skybox.
         * @zh ʹĬպС
         */
        NONE = 0,
        /**
         * @en Cubemap generate by probe.
         * @zh Probe決cubemap
         */
        BAKED_CUBEMAP = 1,
        /**
         * @en Realtime planar reflection.
         * @zh ʵʱƽ淴䡣
         */
        PLANAR_REFLECTION = 2,
        /**
         * @en Mixing between reflection probe.
         * @zh ֮̽лϡ
         */
        BLEND_PROBES = 3,
        /**
         * @en Mixing between reflection probe and skybox.
         * @zh ֮̽ϻ̽պ֮ϡ
         */
        BLEND_PROBES_AND_SKYBOX = 4
    }
    /**
     * @zh ʾһʹö༭༭Ĺؼ֡ⲿĹ
     * ҪΪ㣺ؼ֡ߡ
     * @en The animation clip represents a sequence of key frame animation created with the animation editor or skeletal animation other DCC tools.
     * The data is divided in different levels: tracks, key frames, curves.
     */
    export class AnimationClip extends Asset {
        static WrapMode: typeof __private._cocos_animation_types__WrapMode;
        /**
         * @en Crate clip with a set of sprite frames
         * @zh ʹһ֡ͼƬ
         * @example
         * ```
         * import { AnimationClip } from 'cc';
         * const clip = AnimationClip.createWithSpriteFrames(spriteFrames, 10);
         * ```
         */
        static createWithSpriteFrames(spriteFrames: SpriteFrame[], sample: number): AnimationClip;
        /**
         * @zh ֡ʣλΪ֡/롣עԽڱ༭༭
         * @en Animation frame rate: frames per second.
         * Note this property is only used for animation editing in Editor.
         */
        sample: number;
        /**
         * @zh Ĳٶȡ
         * @en Animation playback speed.
         */
        speed: number;
        /**
         * @zh ѭģʽ
         * @en Animation loop mode.
         */
        wrapMode: __private._cocos_animation_types__WrapMode;
        /**
         * Sets if node TRS curves in this animation can be blended.
         * Normally this flag is enabled for model animation and disabled for other case.
         * @internal This is an internal slot. Never use it in your code.
         */
        enableTrsBlending: boolean;
        /**
         * @zh ڡ
         * @en Animation duration.
         */
        get duration(): number;
        set duration(value: number);
        /**
         * @en
         * Gets the count of tracks this animation owns.
         * @zh
         * ȡ˶еĹ
         */
        get tracksCount(): number;
        /**
         * @en
         * Gets an iterable to tracks.
         * @zh
         * ȡڵĶ
         */
        get tracks(): Iterable<animation.Track>;
        get hash(): number;
        /**
         * @zh ¼ݡ
         * @en Associated event data.
         */
        get events(): AnimationClip.IEvent[];
        set events(value: AnimationClip.IEvent[]);
        get [exoticAnimationTag](): ExoticAnimation | null;
        set [exoticAnimationTag](value: ExoticAnimation | null);
        /**
         * Gets if this animation clip contains additive animation.
         * @experimental
         */
        get isAdditive_experimental(): boolean;
        /**
         * Accesses the additive animation settings.
         * @internal
         */
        get [additiveSettingsTag](): AnimationClipAdditiveSettings;
        onLoaded(): void;
        /**
         * @en
         * Counts the time range that the tracks within this animation span.
         * @zh
         * ȡ˶йռݵʱ䷶Χ
         * @returns The time range.
         */
        range(): __private._cocos_animation_tracks_utils__Range;
        /**
         * @en
         * Gets the specified track.
         * @zh
         * ȡָĹ
         * @param index Index to the track.
         * @returns The track.
         */
        getTrack(index: number): animation.Track;
        /**
         * @en
         * Adds a track into this animation.
         * @zh
         * һ˶С
         * @param track The track.
         * @returns Index to the track.
         */
        addTrack(track: animation.Track): number;
        /**
         * @en
         * Removes a track from this animation.
         * @zh
         * Ƴ˶еָ
         * @param index Index to the track.
         */
        removeTrack(index: number): void;
        /**
         * @en
         * Removes all tracks from this animation.
         * @zh
         * Ƴ˶й
         */
        clearTracks(): void;
        /**
         * Returns if this clip has any event.
         * @internal Do not use this in your code.
         */
        containsAnyEvent(): boolean;
        /**
         * Creates an event evaluator for this animation.
         * @param targetNode Target node used to fire events.
         * @internal Do not use this in your code.
         */
        createEventEvaluator(targetNode: Node): __private._cocos_animation_animation_clip__EventEvaluator;
        /**
         * Returns if this clip has any embedded player.
         * @internal Do not use this in your code.
         */
        containsAnyEmbeddedPlayer(): boolean;
        /**
         * Creates an embedded player evaluator for this animation.
         * @param targetNode Target node.
         * @internal Do not use this in your code.
         */
        createEmbeddedPlayerEvaluator(targetNode: Node): __private._cocos_animation_animation_clip__EmbeddedPlayerEvaluation;
        /**
         * Creates an evaluator for this animation.
         * @param context The context.
         * @returns The evaluator.
         * @internal Do not use this in your code.
         */
        createEvaluator(context: __private._cocos_animation_animation_clip__AnimationClipEvalContext): __private._cocos_animation_animation_clip__AnimationClipEvaluation;
        destroy(): boolean;
        [__private._cocos_animation_internal_symbols__BAKE_SKELETON_CURVE_SYMBOL](start: number, samples: number, frames: number): __private._cocos_animation_animation_clip__SkeletonAnimationBakeInfo;
        /**
         * Convert all untyped tracks into typed ones and delete the original.
         * @param refine How to decide the type on specified path.
         * @internal DO NOT USE THIS IN YOUR CODE.
         */
        upgradeUntypedTracks(refine: __private._cocos_animation_tracks_untyped_track__UntypedTrackRefine): void;
        /**
         * @internal Export for test.
         */
        [__private._cocos_animation_animation_clip__searchForRootBonePathSymbol](): string;
        /**
         * @zh ߿õʱᡣ
         * @en Frame keys referenced by curves.
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get keys(): number[][];
        set keys(value: number[][]);
        /**
         * @zh ˶ߡ
         * @en Curves this animation contains.
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get curves(): AnimationClip._legacy.LegacyClipCurve[];
        set curves(value: AnimationClip._legacy.LegacyClipCurve[]);
        /**
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get commonTargets(): AnimationClip._legacy.LegacyCommonTarget[];
        set commonTargets(value: AnimationClip._legacy.LegacyCommonTarget[]);
        /**
         * @en
         * The animation's data.
         * @zh
         * ˶ݡ
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get data(): Uint8Array | null;
        /**
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        getPropertyCurves(): readonly AnimationClip._legacy.LegacyRuntimeCurve[];
        /**
         * @deprecated Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        get eventGroups(): readonly __private._cocos_animation_animation_clip__IAnimationEventGroup[];
        /**
         * @zh ύ¼ݵ޸ġ
         * ޸ `this.events` ʱ `this.updateEventDatas()` ʹ޸Ч
         * @en
         * Commit event data update.
         * You should call this function after you changed the `events` data to take effect.
         * @deprecated Since V3.3. Please Assign to `this.events`.
         */
        updateEventDatas(): void;
        /**
         * @zh رǷ¼ݡ
         * @en Returns if this animation contains event data.
         * @protected
         */
        hasEvents(): boolean;
        /**
         * Migrates legacy data into tracks.
         * NOTE: This method tend to be used as internal purpose or patch.
         * DO NOT use it in your code since it might be removed for the future at any time.
         * @internal Since V3.3. Please reference to the track/channel/curve mechanism introduced in V3.3.
         */
        syncLegacyData(): void;
        /**
         * @internal
         */
        get [embeddedPlayerCountTag](): number;
        /**
         * @internal
         */
        [getEmbeddedPlayersTag](): Iterable<EmbeddedPlayer>;
        /**
         * @internal
         */
        [addEmbeddedPlayerTag](embeddedPlayer: EmbeddedPlayer): void;
        /**
         * @internal
         */
        [removeEmbeddedPlayerTag](embeddedPlayer: EmbeddedPlayer): void;
        /**
         * @internal
         */
        [clearEmbeddedPlayersTag](): void;
        /**
         * @zh ȡ˶еĸ
         * @en Gets the count of auxiliary curves within this animation clip.
         */
        get auxiliaryCurveCount_experimental(): number;
        /**
         * @zh ش˶иߵơ
         * @en Returns names of all auxiliary curves within this animation clip.
         */
        getAuxiliaryCurveNames_experimental(): readonly string[];
        /**
         * @zh ش˶Ƿָĸߡ
         * @en Returns if the specified auxiliary curve exists in this animation clip.
         */
        hasAuxiliaryCurve_experimental(name: string): boolean;
        /**
         * @zh һߡѴͬĸߣֱӷء
         * @en Adds an auxiliary curve. Directly return if there is already such named auxiliary curve.
         * @param name @zh ߵơ@en The auxiliary curve's name.
         * @returns @zh Ѵڵĸߡ @en The newly created or existing auxiliary curve.
         * @experimental
         */
        addAuxiliaryCurve_experimental(name: string): RealCurve;
        /**
         * @zh ȡָĸߡ
         * @en Gets the specified auxiliary curve.
         * @param name @zh ߵơ@en The auxiliary curve's name.
         * @returns @zh ָĸߡ@en The specified auxiliary curve.
         * @experimental
         */
        getAuxiliaryCurve_experimental(name: string): RealCurve;
        /**
         * @zh ָĸߡ
         * @en Renames the specified auxiliary curve.
         * @param name @zh Ҫĸߵơ@en Name of the auxiliary curve to rename.
         * @param newName @zh ơ@en New name.
         */
        renameAuxiliaryCurve_experimental(name: string, newName: string): void;
        /**
         * @zh Ƴָĸߡ
         * @en Removes the specified auxiliary curve.
         * @param name @zh ߵơ@en The auxiliary curve's name.
         * @experimental
         */
        removeAuxiliaryCurve_experimental(name: string): void;
        /**
         * @internal
         */
        _trySyncLegacyData(): void;
    }
    export namespace AnimationClip {
        export interface IEvent {
            frame: number;
            func: string;
            params: string[];
        }
        export namespace _legacy {
            export class AnimationClipLegacyData {
                constructor(duration: number);
                get keys(): number[][];
                set keys(value: number[][]);
                get curves(): LegacyClipCurve[];
                set curves(value: LegacyClipCurve[]);
                get commonTargets(): LegacyCommonTarget[];
                set commonTargets(value: LegacyCommonTarget[]);
                /**
                 * ˶ݡ
                 */
                get data(): Uint8Array | null;
                getPropertyCurves(): readonly LegacyRuntimeCurve[];
                toTracks(): animation.Track[];
                protected _createPropertyCurves(): void;
            }
            /**
             * Legacy curve uses time based bezier curve interpolation.
             * That's, interpolate time 'x'(time ratio between two frames, eg.[0, 1])
             * and then use the interpolated time to sample curve.
             * Now we need to compute the the end tangent of previous frame and the start tangent of the next frame.
             * @param timeBezierPoints Bezier points used for legacy time interpolation.
             * @param previousTime Time of the previous keyframe.
             * @param previousValue Value of the previous keyframe.
             * @param nextTime Time of the next keyframe.
             * @param nextValue Value of the next keyframe.
             */
            export function timeBezierToTangents(timeBezierPoints: BezierControlPoints, previousTime: number, previousKeyframe: RealKeyframeValue, nextTime: number, nextKeyframe: RealKeyframeValue): void;
            /**
             * ʾֵֵͣϲֵʽҪ
             */
            export type LegacyCurveValue = any;
            /**
             * ʾߵĿ
             */
            export type LegacyCurveTarget = Record<string, any>;
            /**
             * ֡ʱ佥䷽ʽơ
             */
            export type LegacyEasingMethodName = keyof (typeof easing);
            /**
             * ֡ʱ佥䷽ʽΪ֡ʱ佥䷽ʽƻƵ㡣
             */
            export type LegacyEasingMethod = LegacyEasingMethodName | BezierControlPoints;
            export type LegacyCompressedEasingMethods = Record<number, LegacyEasingMethod>;
            export type LegacyLerpFunction<T = any> = (from: T, to: T, t: number, dt: number) => T;
            export interface LegacyClipCurveData {
                /**
                 * ʹõʱᡣ
                 * @see {AnimationClip.keys}
                 */
                keys: number;
                /**
                 * ֵֵӦ `keys` ʱ֡ͬ
                 */
                values: LegacyCurveValue[];
                /**
                 * ֡ʱĽ䷽ʽ `easingMethods === undefined` ʱֶβЧ
                 */
                easingMethod?: LegacyEasingMethod;
                /**
                 * ÿһ֡ʱ䵽һ֡ʱ֮Ľ䷽ʽ
                 */
                easingMethods?: LegacyEasingMethod[] | LegacyCompressedEasingMethods;
                /**
                 * Ƿвֵ
                 * @default true
                 */
                interpolate?: boolean;
                /**
                 * For internal usage only.
                 */
                _arrayLength?: number;
            }
            export interface LegacyClipCurve {
                commonTarget?: number;
                modifiers: animation.TargetPath[];
                valueAdapter?: animation.IValueProxyFactory;
                data: LegacyClipCurveData;
            }
            export interface LegacyCommonTarget {
                modifiers: animation.TargetPath[];
                valueAdapter?: animation.IValueProxyFactory;
            }
            export type LegacyMaybeCompactCurve = Omit<LegacyClipCurve, "data"> & {
                data: Omit<LegacyClipCurveData, "values"> & {
                    values: any[] | CompactValueTypeArray;
                };
            };
            export type LegacyMaybeCompactKeys = Array<number[] | CompactValueTypeArray>;
            export type LegacyRuntimeCurve = Pick<LegacyClipCurve, "modifiers" | "valueAdapter" | "commonTarget"> & {
                /**
                 * ߡ
                 */
                curve: AnimCurve;
                /**
                 * ߲
                 */
                sampler: RatioSampler | null;
            };
            export interface LegacyObjectCurveData {
                [propertyName: string]: LegacyClipCurveData;
            }
            export interface LegacyComponentsCurveData {
                [componentName: string]: LegacyObjectCurveData;
            }
            export interface LegacyNodeCurveData {
                props?: LegacyObjectCurveData;
                comps?: LegacyComponentsCurveData;
            }
        }
        export type WrapMode = __private._cocos_animation_animation_clip__WrapMode_;
    }
    /**
     * @en
     * The AnimationState gives full control over animation playback process.
     * In most cases the Animation Component is sufficient and easier to use. Use the AnimationState if you need full control.
     * @zh
     * AnimationState ȫƶŹ̡<br/>
     *   㹻ʹõġҪĶƽӿڣʹ AnimationState
     *
     */
    export class AnimationState extends __private._cocos_animation_playable__Playable {
        /**
         * @en The clip that is being played by this animation state.
         * @zh ˶״̬ڲŵļ
         */
        get clip(): AnimationClip;
        /**
         * @en The name of the playing animation.
         * @zh ֡
         */
        get name(): string;
        get length(): number;
        /**
         * @en
         * Wrapping mode of the playing animation.
         * Notice : dynamic change wrapMode will reset time and repeatCount property
         * @zh
         * ѭʽ
         * Ҫעǣ̬޸ wrapMode ʱ time Լ repeatCount
         * @default: WrapMode.Normal
         */
        get wrapMode(): __private._cocos_animation_types__WrapMode;
        set wrapMode(value: __private._cocos_animation_types__WrapMode);
        /**
         * @en The animation's iteration count property.
         *
         * A real number greater than or equal to zero (including positive infinity) representing the number of times
         * to repeat the animation node.
         *
         * Values less than zero and NaN values are treated as the value 1.0 for the purpose of timing model
         * calculations.
         *
         * @zh ָŶٴκ, normalize time  2.52ΰ룩
         *
         * @default 1
         */
        get repeatCount(): number;
        set repeatCount(value: number);
        /**
         * @en The start delay which represents the number of seconds from an animation's start time to the start of
         * the active interval.
         * @zh ӳٶ벥š
         * @default 0
         */
        get delay(): number;
        set delay(value: number);
        /**
         * @en The iteration duration of this animation in seconds. (length)
         * @zh ζĳʱ䣬롣ȣ
         * @readOnly
         */
        duration: number;
        /**
         * @en
         * Gets or sets the playback range.
         * The `min` and `max` field of the range are measured in seconds.
         * While setting, the range object should be a valid range.
         * The actual playback range would be the inclusion of this field and [0, duration].
         * Set this field would reset the accumulated play time.
         * If `min === max`, the animation always play at `min`.
         * @zh
         * ȡòŷΧ
         * Χ `min``max` ֶζΪλġ
         * ʱӦָһЧķΧʵʵĲŷΧǸֶκ [0, ] ֮Ľ
         * òŷΧʱۼƲʱ䡣
         *  `min === max`öһֱ `min` š
         */
        get playbackRange(): Readonly<{
            min: number;
            max: number;
        }>;
        set playbackRange(value: Readonly<{
            min: number;
            max: number;
        }>);
        /**
         * @en The animation's playback speed. 1 is normal playback speed.
         * @zh ʡ
         * @default: 1.0
         */
        get speed(): number;
        set speed(value: number);
        /**
         * @en The current accumulated time of this animation in seconds.
         * @zh ǰ**ۼƲ**ʱ䣬λΪ롣
         * @default 0
         */
        time: number;
        /**
         * @en Gets the time progress, in seconds.
         * @zh ȡʱȣλΪ롣
         */
        get current(): number;
        /**
         * @en Gets the playback ratio.
         * @zh ȡŵıʱ䡣
         */
        get ratio(): number;
        /**
         * @en
         * The weight of this animation state.
         * @zh
         * ˶״̬Ȩء
         */
        get weight(): number;
        set weight(value: number);
        frameRate: number;
        /**
         * @internal This field is only visible from within internal.
         */
        protected _targetNode: Node | null;
        /**
         * @internal This field is only visible from within internal.
         */
        protected _curveLoaded: boolean;
        /**
         * @internal For internal usage. Really hack...
         */
        protected _doNotCreateEval: boolean;
        constructor(clip: AnimationClip, name?: string);
        /**
         * This method is used for internal purpose only.
         */
        get curveLoaded(): boolean;
        initialize(root: Node, blendStateBuffer?: __private._cocos_3d_skeletal_animation_skeletal_animation_blending__BlendStateBuffer, mask?: AnimationMask): void;
        destroy(): void;
        /**
         * @deprecated Since V1.1.1, animation states were no longer defined as event targets.
         * To process animation events, use `Animation` instead.
         */
        emit(...args: any[]): void;
        /**
         * @deprecated Since V1.1.1, animation states were no longer defined as event targets.
         * To process animation events, use `Animation` instead.
         */
        on(type: string, callback: Function, target?: any): void | null;
        /**
         * @deprecated Since V1.1.1, animation states were no longer defined as event targets.
         * To process animation events, use `Animation` instead.
         */
        once(type: string, callback: Function, target?: any): void | null;
        /**
         * @deprecated Since V1.1.1, animation states were no longer defined as event targets.
         * To process animation events, use `Animation` instead.
         */
        off(type: string, callback: Function, target?: any): void;
        /**
         * @zh
         * Ƿ `LastFrame` ¼
         * ÷ڲ;
         * @en
         * Whether `LastFrame` should be triggered.
         * @param allowed True if the last frame events may be triggered.
         * This method is only used for internal purpose only.
         */
        allowLastFrameEvent(allowed: boolean): void;
        /**
         * This method is used for internal purpose only.
         * @internal
         */
        _setEventTarget(target: any): void;
        setTime(time: number): void;
        update(delta: number): void;
        sample(): __private._cocos_animation_types__WrappedInfo;
        protected onPlay(): void;
        protected onStop(): void;
        protected onResume(): void;
        protected onPause(): void;
        /**
         * @internal
         */
        protected _sampleCurves(time: number): void;
    }
    /**
     * @en
     * Animation component governs a group of animation states to control playback of the states.
     * For convenient, it stores a group of animation clips.
     * Each of those clips would have an associated animation state uniquely created.
     * Animation component is eventful, it dispatch a serials playback status events.
     * See [[EventType]].
     * @zh
     * һ鶯״̬ǵĲš
     * Ϊ˷㣬洢һ鶯
     * ÿԴһĶ״̬
     * ¼ԣɷһϵв״̬ص¼
     * ο [[EventType]]
     */
    export class Animation extends __private._cocos_animation_animation_component__Animation_base {
        /**
         * @en
         * Gets or sets clips this component governs.
         * When set, associated animation state of each existing clip will be stopped.
         * If the existing default clip is not in the set of new clips, default clip will be reset to null.
         * @zh
         * ȡôļ
         * ʱмĶ״ֹ̬ͣĬϼµĶУΪա
         */
        get clips(): (AnimationClip | null)[];
        set clips(value: (AnimationClip | null)[]);
        /**
         * @en
         * Gets or sets the default clip.
         * Two clips that both have same non-empty UUID are treat as equivalent.
         * @zh
         * ȡĬϼ
         * ʱָļ `this.clips` ᱻԶ `this.clips`
         * ͬķǿ UUID Ϊͬġ
         * @see [[playOnLoad]]
         */
        get defaultClip(): AnimationClip | null;
        set defaultClip(value: AnimationClip | null);
        static EventType: typeof __private._cocos_animation_animation_state__EventType;
        /**
         * @en
         * Whether the default clip should get into playing when this components starts.
         * Note, this field takes no effect if `crossFade()` or `play()` has been called before this component starts.
         * @zh
         * ǷʼʱԶĬϼ
         * ע⣬ʼǰ `crossFade`  `play()`ֶνЧ
         */
        playOnLoad: boolean;
        /**
         * @internal
         */
        protected _crossFade: __private._cocos_animation_cross_fade__CrossFade;
        /**
         * @internal
         */
        protected _nameToState: Record<string, AnimationState>;
        /**
         * @internal
         */
        protected _clips: (AnimationClip | null)[];
        /**
         * @internal
         */
        protected _defaultClip: AnimationClip | null;
        onLoad(): void;
        start(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en
         * Switch to play specified animation state, without fading.
         * @zh
         * лָ״̬
         * @param name The name of the animation to be played, if absent, the default clip will be played
         */
        play(name?: string): void;
        /**
         * @en
         * Smoothly switch to play specified animation state.
         * @zh
         * ƽлָ״̬
         * @param name The name of the animation to switch to
         * @param duration The duration of the cross fade, default value is 0.3s
         */
        crossFade(name: string, duration?: number): void;
        /**
         * @en
         * Pause all animation states and all switching.
         * @zh
         * ͣж״̬ͣл
         */
        pause(): void;
        /**
         * @en
         * Resume all animation states and all switching.
         * @zh
         * ָж״ָ̬л
         */
        resume(): void;
        /**
         * @en
         * Stop all animation states and all switching.
         * @zh
         * ֹͣж״ֹ̬ͣл
         */
        stop(): void;
        /**
         * @en
         * Get specified animation state.
         * @zh
         * ȡָĶ״̬
         * @param name The name of the animation
         * @returns If no animation found, return null, otherwise the correspond animation state is returned
         */
        getState(name: string): AnimationState;
        /**
         * @en
         * Creates a state for specified clip.
         * If there is already a clip with same name, the existing animation state will be stopped and overridden.
         * @zh
         * ʹָĶһ״̬
         * ָƵĶ״̬ѴڣѴڵĶ״̬ȱΪֹͣǡ
         * @param clip The animation clip
         * @param name The animation state name, if absent, the default clip's name will be used
         * @returns The animation state created
         */
        createState(clip: AnimationClip, name?: string): AnimationState;
        /**
         * @en
         * Stops and removes specified clip.
         * @zh
         * ֹͣƳָĶ״̬
         * @param name The name of the animation state
         */
        removeState(name: string): void;
        /**
         * @zh
         * һ `this.clips`вԴ˼״̬
         * @en
         * Adds an animation clip into this component and creates a animation state for this clip.
         * @param clip The animation clip
         * @param name The animation state name, if absent, the default clip's name will be used
         * @returns The created animation state
         */
        addClip(clip: AnimationClip, name?: string): AnimationState;
        /**
         * @en
         * Remove clip from the animation list. This will remove the clip and any animation states based on it.<br>
         * If there are animation states depend on the clip are playing or clip is defaultClip, it will not delete the clip.<br>
         * But if force is true, then will always remove the clip and any animation states based on it. If clip is defaultClip,
         * defaultClip will be reset to null
         * @zh
         * ӶбƳָĶ<br/>
         *  clip  AnimationState ڲŻ clip  defaultClip ĻĬǲɾ clip ġ<br/>
         *  force Ϊ trueǿֹͣöȻƳöصĶʱ clip  defaultClipdefaultClip ᱻΪ null<br/>
         * @param force - If force is true, then will always remove the clip and any animation states based on it.
         */
        removeClip(clip: AnimationClip, force?: boolean): void;
        /**
         * @en
         * Register animation event callback.<bg>
         * The event arguments will provide the AnimationState which emit the event.<bg>
         * When play an animation, will auto register the event callback to the AnimationState,<bg>
         * and unregister the event callback from the AnimationState when animation stopped.
         * @zh
         * עᶯ¼ص<bg>
         * ص¼ｫḽϷ¼ AnimationState<bg>
         * һʱԶ¼עᵽӦ AnimationState ϣֹͣʱὫ¼ AnimationState ȡעᡣ
         * @param type The event type to listen to
         * @param callback The callback when event triggered
         * @param target The callee when invoke the callback, could be absent
         * @return The registered callback
         * @example
         * ```ts
         * onPlay: function (type, state) {
         *     // callback
         * }
         *
         * // register event to all animation
         * animation.on('play', this.onPlay, this);
         * ```
         */
        on<TFunction extends (...any: any[]) => void>(type: __private._cocos_animation_animation_state__EventType, callback: TFunction, thisArg?: any, once?: boolean): TFunction;
        once<TFunction extends (...any: any[]) => void>(type: __private._cocos_animation_animation_state__EventType, callback: TFunction, thisArg?: any): TFunction;
        /**
         * @en
         * Unregister animation event callback.
         * @zh
         * ȡעᶯ¼ص
         * @param {String} type The event type to unregister
         * @param {Function} callback The callback to unregister
         * @param {Object} target The callee of the callback, could be absent
         * @example
         * ```ts
         * // unregister event to all animation
         * animation.off('play', this.onPlay, this);
         * ```
         */
        off(type: __private._cocos_animation_animation_state__EventType, callback?: (...any: any[]) => void, thisArg?: any): void;
        /**
         * @internal
         */
        protected _createState(clip: AnimationClip, name?: string): AnimationState;
        /**
         * @internal
         */
        protected _doCreateState(clip: AnimationClip, name: string): AnimationState;
        /**
         * @internal This method only friends to skeletal animation component.
         */
        protected doPlayOrCrossFade(state: AnimationState, duration: number): void;
    }
    export namespace Animation {
        export type EventType = __private._cocos_animation_animation_component__EventType_;
    }
    export namespace animation {
        /**
         * @en
         * Represents variable's value.
         * @zh
         * ʾֵ
         */
        export type Value_experimental = Value | Readonly<math.Vec3> | Readonly<math.Quat>;
        /**
         * @en
         * Represents animation graph variable types.
         * @zh
         * ʾͼ͡
         */
        export enum VariableType {
            /**
             * @en
             * A floating.
             * @zh
             * 
             */
            FLOAT = 0,
            /**
             * @en
             * A boolean.
             * @zh
             * ֵ
             */
            BOOLEAN = 1,
            /**
             * @en
             * A trigger.
             * @zh
             * 
             */
            TRIGGER = 2,
            /**
             * @en
             * An integer.
             * @zh
             * 
             */
            INTEGER = 3,
            /**
             * @zh
             * ά
             * @en
             * Vector 3d.
             */
            VEC3_experimental = 4,
            /**
             * @zh
             * Ԫ
             * @en
             * Quaternion.
             */
            QUAT_experimental = 5
        }
        /**
         * @en
         * Value proxy factory for setting uniform on material target.
         * @zh
         * òĿָ Uniform ֵ
         */
        export class UniformProxyFactory implements IValueProxyFactory {
            /**
             * @en Pass index.
             * @zh Pass 
             */
            passIndex: number;
            /**
             * @en Uniform name.
             * @zh Uniform ơ
             */
            uniformName: string;
            /**
             * @en
             * Specify the aimed channel of the uniform.
             * Use this when you're aiming at a single channel of the uniform instead of who uniform.
             * For example, only green(1) channel of a color uniform.
             * @zh
             * ָĿ Uniform ͨ
             * ϣ Uniform ͨ Uniform ʱӦõʹôֶΡ
             * 磬ɫ Uniform ĺɫͨ
             */
            channelIndex: number | undefined;
            constructor(uniformName?: string, passIndex?: number);
            forTarget(target: unknown): IValueProxy | undefined;
        }
        /**
         * @en
         * Value proxy factory for setting morph weights of specified sub-mesh on model component target.
         * @zh
         * ģĿָָ״αȨصֵ
         */
        export class MorphWeightValueProxy implements IValueProxyFactory {
            /**
             * @en Sub mesh index.
             * @zh 
             */
            subMeshIndex: number;
            /**
             * @en Shape Index.
             * @zh ״
             */
            shapeIndex: number;
            forTarget(target: MeshRenderer): {
                set: (value: number) => void;
            };
        }
        /**
         * @en
         * Value proxy factory for setting morph weights of specified sub-mesh on model component target.
         * @zh
         * ģĿָαȨصֵ
         */
        export class MorphWeightsValueProxy implements IValueProxyFactory {
            /**
             * @en Sub-mesh index.
             * @zh 
             */
            subMeshIndex: number;
            forTarget(target: MeshRenderer): {
                set: (value: number[]) => void;
            };
        }
        /**
         * @en
         * Value proxy factory for setting morph weights of each sub-mesh on model component target.
         * @zh
         * ģĿαȨصֵ
         */
        export class MorphWeightsAllValueProxy implements IValueProxyFactory {
            forTarget(target: MeshRenderer): {
                set: (value: number[]) => void;
            };
        }
        /**
         * @en
         * A track describes how to trace the target and how to animate it.
         * It's the basic unit of animation clip.
         * @zh
         * ˶Ŀ·ͶķʽǶĻԪ
         */
        export abstract class Track {
            /**
             * @en Track path.
             * @zh ·
             */
            get path(): Readonly<TrackPath>;
            set path(value: Readonly<TrackPath>);
            /**
             * @en Value proxy for the target.
             * @zh Ŀֵ
             */
            get proxy(): IValueProxyFactory | undefined;
            set proxy(value: IValueProxyFactory | undefined);
            /**
             * @internal
             */
            get [__private._cocos_animation_tracks_track__trackBindingTag](): __private._cocos_animation_tracks_track__TrackBinding;
            /**
             * @en Channels on this track.
             * @zh ˹ϵͨ
             * @returns Iterator to the channels.
             */
            channels(): Iterable<__private._cocos_animation_tracks_track__Channel>;
            /**
             * @en Time range of this track.
             * @zh ˹ʱ䷶Χ
             * @returns The time range.
             */
            range(): __private._cocos_animation_tracks_utils__Range;
            /**
             * @internal
             */
            abstract [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_track__TrackEval<any>;
        }
        /**
         * @en Describes how to find the animation target.
         * @zh ѰַĿꡣ
         */
        export class TrackPath {
            /**
             * @en The length of the path.
             * @zh ·Ķ
             */
            get length(): number;
            /**
             * @en Appends a property path.
             * @zh һ·
             * @param name The property's name.
             * @returns `this`
             */
            toProperty(name: string): TrackPath;
            /**
             * @en Appends an array element path.
             * @zh һԪ·
             * @param index The element's index.
             * @returns `this`
             */
            toElement(index: number): TrackPath;
            /**
             * @en Appends a hierarchy path.
             * @zh һβ㼶·
             * @param nodePath Path to the children.
             * @returns `this`
             */
            toHierarchy(nodePath: string): TrackPath;
            /**
             * @en Appends a component path.
             * @zh һ·
             * @param constructor @en The constructor of the component. @zh Ĺ캯
             * @returns `this`
             */
            toComponent<T extends Component>(constructor: __private.__types_globals__Constructor<T> | string): TrackPath;
            /**
             * @internal Reserved for backward compatibility. DO NOT USE IT IN YOUR CODE.
             */
            toCustomized(resolver: __private._cocos_animation_tracks_track__CustomizedTrackPathResolver): TrackPath;
            /**
             * @en Appends paths to this path.
             * @zh ָ··
             * @param trackPaths Paths to append.
             * @returns `this`.
             */
            append(...trackPaths: TrackPath[]): TrackPath;
            /**
             * @zh жָ·Ƿ·
             * @en Decides if the specific path segment is property path.
             * @param index Index to the segment
             * @returns The judgement result.
             */
            isPropertyAt(index: number): boolean;
            /**
             * @zh ָ·Ϊ·ȡԡ
             * @en Treats the path segment as a property path. Obtains the property it describes.
             * @param index Index to the segment
             * @returns The property.
             */
            parsePropertyAt(index: number): string;
            /**
             * @zh жָ·ǷԪ·
             * @en Decides if the specific path segment is an array element path.
             * @param index Index to the segment
             * @returns The judgement result.
             */
            isElementAt(index: number): boolean;
            /**
             * @zh ָ·ΪԪ·ȡԪء
             * @en Treats the path segment as an array element path. Obtains the element index it describes.
             * @param index Index to the segment
             * @returns The element index.
             */
            parseElementAt(index: number): number;
            /**
             * @zh жָ·Ƿǲ㼶·
             * @en Decides if the specific path segment is a hierarchy path.
             * @param index Index to the segment
             * @returns The judgement result.
             */
            isHierarchyAt(index: number): boolean;
            /**
             * @zh ָ·Ϊ㼶·ȡĲ㼶·
             * @en Treats the path segment as a hierarchy path. Obtains the hierarchy path it describes.
             * @param index Index to the segment
             * @returns The hierarchy path.
             */
            parseHierarchyAt(index: number): string;
            /**
             * @zh жָ·Ƿ·
             * @en Decides if the specific path segment is a component path.
             * @param index Index to the segment
             * @returns The judgement result.
             */
            isComponentAt(index: number): boolean;
            /**
             * @zh ָ·Ϊ·ȡ·
             * @en Treats the path segment as a hierarchy path. Obtains the component path it describes.
             * @param index Index to the segment
             * @returns The component path.
             */
            parseComponentAt(index: number): string;
            /**
             * @en Slices a interval of the path.
             * @zh ָָϵ·
             * @param beginIndex Begin index to the segment. Default to 0.
             * @param endIndex End index to the segment. Default to the last segment.
             * @returns The new path.
             */
            slice(beginIndex?: number, endIndex?: number): TrackPath;
            /**
             * @internal
             */
            trace(object: unknown, beginIndex?: number, endIndex?: number): unknown;
            /**
             * @internal
             */
            [__private._cocos_animation_tracks_track__parseTrsPathTag](): {
                node: string;
                property: "position" | "scale" | "rotation" | "eulerAngles";
            } | null;
            /**
             * @internal
             */
            [__private._cocos_animation_tracks_track__normalizedFollowTag](root: unknown, beginIndex: number, endIndex: number): unknown;
        }
        /**
         * @en
         * A real track animates a scalar attribute of target.
         * @zh
         * ʵĿĳԵĶ
         */
        export class RealTrack extends __private._cocos_animation_tracks_track__SingleChannelTrack<RealCurve> {
            /**
             * @internal
             */
            protected createCurve(): RealCurve;
        }
        /**
         * @en
         * A vector track animates a vector(in 2, 3, 4 dimension) attribute of target.
         * @zh
         * ĿĳάԵĶ
         */
        export class VectorTrack extends Track {
            constructor();
            /**
             * @en Gets or sets the count of components(dimension) available while evaluating of this track.
             * @zh ȡô˹ֵʱЧķάȣ
             */
            get componentsCount(): number;
            set componentsCount(value: number);
            /**
             * @en The four channel of the track.
             * @zh ش˹ͨ
             * @returns An readonly four length array in which
             * the element at n denotes the channel of n-th vector component.
             */
            channels(): [
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel
            ];
            /**
             * @internal
             */
            [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_vector_track__Vec2TrackEval | __private._cocos_animation_tracks_vector_track__Vec3TrackEval | __private._cocos_animation_tracks_vector_track__Vec4TrackEval;
        }
        /**
         * @en
         * A quaternion track animates a quaternion(rotation) attribute of target.
         * @zh
         * ԪĿĳԪתԵĶ
         */
        export class QuatTrack extends __private._cocos_animation_tracks_track__SingleChannelTrack<QuatCurve> {
            /**
             * @internal
             */
            protected createCurve(): QuatCurve;
            /**
             * @internal
             */
            [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_quat_track__QuatTrackEval;
        }
        /**
         * @en
         * A color track animates a color attribute of target.
         * @zh
         * ɫĿĳɫԵĶ
         */
        export class ColorTrack extends Track {
            constructor();
            /**
             * @en The four channel of the track.
             * @zh ش˹ͨ
             * @returns An readonly four length array in which
             * the element at n denotes the channel of n-th(in order of RGBA) color component(in form of integer within 0-255).
             */
            channels(): [
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel
            ];
            /**
             * @internal
             */
            [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_color_track__ColorTrackEval;
        }
        /**
         * @en
         * A size track animates a size attribute of target.
         * @zh
         * ߴĿĳߴԵĶ
         */
        export class SizeTrack extends Track {
            constructor();
            /**
             * @en The width channel and the height channel of the track.
             * @zh ش˹Ŀͨ͸߶ͨ
             * @returns An readonly array in which
             * the first element is the width channel and the second element is the height channel.
             */
            channels(): [
                __private._cocos_animation_tracks_track__RealChannel,
                __private._cocos_animation_tracks_track__RealChannel
            ];
            /**
             * @internal
             */
            [__private._cocos_animation_define__createEvalSymbol](): __private._cocos_animation_tracks_size_track__SizeTrackEval;
        }
        /**
         * @en
         * An object track animates an object of attribute of target.
         * @zh
         * Ŀĳ͵ԵĶ
         */
        export class ObjectTrack<T> extends __private._cocos_animation_tracks_track__SingleChannelTrack<ObjectCurve<T>> {
            /**
             * @internal
             */
            protected createCurve(): ObjectCurve<T>;
        }
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export function isPropertyPath(path: TargetPath): path is PropertyPath;
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export function isCustomPath<T extends ICustomTargetPath>(path: TargetPath, constructor: __private.__types_globals__Constructor<T>): path is T;
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export type PropertyPath = string | number;
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export interface ICustomTargetPath {
            /**
             * @en
             * Gets next target from current target.
             * If errors are encountered, `null` should be returned.
             * @zh
             * ӵǰĿлȡһĿꡣ
             * Ӧ `null`
             * @param target
             */
            get(target: any): any;
        }
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export type TargetPath = PropertyPath | ICustomTargetPath;
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export class HierarchyPath implements ICustomTargetPath {
            path: string;
            constructor(path?: string);
            get(target: Node): Node | null;
        }
        /**
         * @deprecated Since V3.3, use [[TrackPath]] instead.
         */
        export class ComponentPath implements ICustomTargetPath {
            component: string;
            constructor(component?: string);
            get(target: Node): Component | null;
        }
        /**
         * @en
         * Value proxies are used to set curve value to target. They are "generalized assignment".
         * Every value proxy associates with a target object.
         * @zh
         * ֵֵĿ꣬ǹĸֵ
         * ÿֵһĿ
         */
        export interface IValueProxy {
            /**
             * @en
             * Gets the value from the target.
             * This method is used for implementing component-wise animation in certain circumstance.
             * @zh
             * ĿлȡֵĳЩ¿Ҫӿʵַ
             */
            get?: () => any;
            /**
             * @en
             * Sets a value.
             * @zh
             * ֵĿϡ
             */
            set: (value: any) => void;
        }
        export interface IValueProxyFactory {
            /**
             * @en
             * Returns a value proxy for specific target.
             * @zh
             * ָĿֵ
             * @param target The target acquiring the value proxy.
             * @returns The value proxy, or undefined if the proxy could not be created.
             * In later case, a warn should be given before returning.
             */
            forTarget(target: any): IValueProxy | undefined;
        }
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const CubicSplineVec2Value: __private._cocos_animation_cubic_spline_value__CubicSplineValueConstructor<math.Vec2>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export type CubicSplineVec2Value = __private._cocos_animation_cubic_spline_value__ICubicSplineValue<math.Vec2>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const CubicSplineVec3Value: __private._cocos_animation_cubic_spline_value__CubicSplineValueConstructor<math.Vec3>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export type CubicSplineVec3Value = __private._cocos_animation_cubic_spline_value__ICubicSplineValue<math.Vec3>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const CubicSplineVec4Value: __private._cocos_animation_cubic_spline_value__CubicSplineValueConstructor<math.Vec4>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export type CubicSplineVec4Value = __private._cocos_animation_cubic_spline_value__ICubicSplineValue<math.Vec4>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const CubicSplineQuatValue: __private._cocos_animation_cubic_spline_value__CubicSplineValueConstructor<math.Quat>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export class CubicSplineNumberValue implements __private._cocos_animation_cubic_spline_value__ICubicSplineValue<number> {
            dataPoint: number;
            inTangent: number;
            outTangent: number;
            constructor(dataPoint: number, inTangent: number, outTangent: number);
            lerp(to: CubicSplineNumberValue, t: number, dt: number): number;
            getNoLerp(): number;
        }
        /**
         * @en
         * An opacity type which denotes what the animation graph seems like outside the engine.
         * @zh
         * һ͸ͣǶͼⲿıʾ
         */
        export interface AnimationGraphRunTime {
            /**
             * @internal
             */
            readonly __brand: "AnimationGraph";
        }
        /**
         * @en
         * An opacity type which denotes what the animation graph variant seems like outside the engine.
         * @zh
         * һ͸ͣǶͼⲿıʾ
         */
        export interface AnimationGraphVariantRunTime {
            /**
             * @internal
             */
            readonly __brand: "AnimationGraphVariant";
        }
        /**
         * @en
         * The animation controller component applies an animation graph
         * to the node which it's attached to.
         * When the controller starts, the animation graph is instantiated.
         * Then you may set variables or query the running statuses of the animation graph instance.
         * @zh
         * ͼӦõصĽڵϡ
         * ʼʱͼᱻʵȻöͼʵеı߲ѯͼ״
         */
        export class AnimationController extends Component {
            /**
             * @zh
             * Ķͼ
             * @en
             * The animation graph associated with the animation controller.
             */
            get graph(): AnimationGraphRunTime | AnimationGraphVariantRunTime | null;
            set graph(value: AnimationGraphRunTime | AnimationGraphVariantRunTime | null);
            /**
             * @zh ȡͼĲ㼶ûָͼ򷵻 0
             * @en Gets the count of layers in the animation graph.
             * If no animation graph is specified, 0 is returned.
             */
            get layerCount(): number;
            __preload(): void;
            onDestroy(): void;
            update(deltaTime: number): void;
            /**
             * @zh ȡͼеб
             * @en Gets all the variables in the animation graph.
             * @returns The iterator to the variables.
             * @example
             * ```ts
             * for (const [name, { type }] of animationController.getVariables()) {
             *   log(`Name: ${name}, Type: ${type}`);
             * }
             * ```
             */
            getVariables(): Iterable<readonly [
                string,
                Readonly<{
                    type: VariableType;
                }>
            ]>;
            /**
             * @zh öͼʵбֵ
             * @en Sets the value of the variable in the animation graph instance.
             * @param name @en Variable's name. @zh ơ
             * @param value @en Variable's value. @zh ֵ
             * @example
             * ```ts
             * animationController.setValue('speed', 3.14);
             * animationController.setValue('crouching', true);
             * animationController.setValue('attack', true);
             * ```
             */
            setValue(name: string, value: Value): void;
            /**
             * @zh öͼʵбֵ
             * @en Sets the value of the variable in the animation graph instance.
             * @param name @en Variable's name. @zh ơ
             * @param value @en Variable's value. @zh ֵ
             * @example
             * ```ts
             * animationController.setValue('speed', 3.14);
             * animationController.setValue('crouching', true);
             * animationController.setValue('attack', true);
             * ```
             * @experimental
             */
            setValue_experimental(name: string, value: Value_experimental): void;
            /**
             * @zh ȡͼʵбֵ
             * @en Gets the value of the variable in the animation graph instance.
             * @param name @en Variable's name. @zh ơ
             * @returns @en Variable's value. @zh ֵ
             */
            getValue(name: string): Value | undefined;
            /**
             * @zh ȡͼʵбֵ
             * @en Gets the value of the variable in the animation graph instance.
             * @param name @en Variable's name. @zh ơ
             * @returns @en Variable's value. @zh ֵ
             */
            getValue_experimental(name: string): Value_experimental | undefined;
            /**
             * @zh ȡͼʵеǰ״̬״
             * @en Gets the running status of the current state in the animation graph instance.
             * @param layer @en Index of the layer. @zh 㼶
             * @returns @en The running status of the current state. `null` is returned if current state is not a motion state.
             *          @zh ǰ״̬״̬ǰ״̬Ƕ״̬򷵻 `null`
             */
            getCurrentStateStatus(layer: number): Readonly<MotionStateStatus> | null;
            /**
             * @zh ȡͼʵеǰ״̬ϰж״
             * @en Gets the running status of all the animation clips added on the current state in the animation graph instance.
             * @param layer @en Index of the layer. @zh 㼶
             * @returns @en Iterable to the animation clip statuses on current state.
             *              An empty iterable is returned if current state is not a motion state.
             *          @zh ״̬ĵǰ״̬Ƕ״̬򷵻һյĵ
             */
            getCurrentClipStatuses(layer: number): Iterable<Readonly<ClipStatus>>;
            /**
             * @zh ȡͼʵеǰڽеĹɵ״
             * @en Gets the running status of the transition currently in progress in the animation graph instance.
             * @param layer @en Index of the layer. @zh 㼶
             * @returns @en Current transition status. `null` is returned in case of no transition.
             *          @zh ǰڽеĹɣûнκιɣ򷵻 `null`
             */
            getCurrentTransition(layer: number): Readonly<TransitionStatus> | null;
            /**
             * @zh ȡͼʵһ״̬״
             * @en Gets the running status of the next state in the animation graph instance.
             * @param layer @en Index of the layer. @zh 㼶
             * @returns @en The running status of the next state. `null` is returned in case of no transition or if next state is not a motion state.
             *          @zh һ״̬״̬δڽйɻһ״̬Ƕ״̬򷵻 `null`
             */
            getNextStateStatus(layer: number): Readonly<MotionStateStatus> | null;
            /**
             * @zh ȡͼʵһ״̬ӵж״
             * @en Gets the running status of all the animation clips added on the next state in the animation graph instance.
             * @param layer @en Index of the layer. @zh 㼶
             * @returns @en Iterable to the animation clip statuses on next state.
             *              An empty iterable is returned in case of no transition or next state is not a motion state.
             *          @zh һ״̬ϰĶ״̬ĵδڽйɻһ״̬Ƕ״̬򷵻һյĵ
             */
            getNextClipStatuses(layer: number): Iterable<Readonly<ClipStatus>>;
            /**
             * @zh ȡ㼶Ȩء
             * @en Gets the weight of specified layer.
             * @param layer @en Index of the layer. @zh 㼶
             */
            getLayerWeight(layer: number): number;
            /**
             * @zh ò㼶Ȩء
             * @en Sets the weight of specified layer.
             * @param layer @en Index of the layer. @zh 㼶
             */
            setLayerWeight(layer: number, weight: number): void;
            /**
             * @zh ǶͼʵеĶ
             * ÿһԴĿ
             * ͼʵеĳֵԴᱻ滻ΪĿͺ񶯻ͼһʼʹõĿ
             * ͼǰת״̬Ȼֲ䣬磺
             *
             * - ״̬漰Ķ滻״̬ĲŽȰٷֱȻֲ䡣
             *
             * - ɵԵģʹĳһ̶ɵԴͷ滻ôɵĽȰٷֱҲȻֲ䡣
             *
             * ܽжٴθǣԴӦһֱָΪԭʼͼеĶ磺
             *
             * ```ts
             * // `originalClip` ԭʼͼеļ󣬵һϣԭΪ `newClip1`ڶϣԭΪ `newClip2`
             * animationController.overrideClips_experimental(new Map([ [originalClip, newClip1] ])); // һθ
             * animationController.overrideClips_experimental(new Map([ [newClip1, newClip2] ])); // 󣺵ڶθ
             * animationController.overrideClips_experimental(new Map([ [originalClip, newClip2] ])); // ȷڶθ
             * ```
             * @en Overrides the animation clips in animation graph instance.
             * TODO
             * @experimental
             */
            overrideClips_experimental(overrides: ___private._cocos_animation_marionette_clip_overriding__ReadonlyClipOverrideMap): void;
            /**
             * @zh ȡָߵĵǰֵ
             * @en Gets the current value of specified auxiliary curve.
             * @param curveName @en Name of the auxiliary curve. @zh ߵ֡
             * @returns @zh ָߵĵǰֵָ߲ڻ򶯻ͼΪ򷵻 0
             * @en The current value of specified auxiliary curve,
             * or 0 if specified adjoint curve does not exist or if the animation graph is null.
             * @experimental
             */
            getAuxiliaryCurveValue_experimental(curveName: string): number;
        }
        /**
         * @en
         * Runtime clip status of a motion state.
         * @zh
         * ״̬аļ״̬
         */
        export interface ClipStatus {
            /**
             * @en
             * The clip object.
             * @zh
             * 
             */
            clip: AnimationClip;
            /**
             * @en
             * The clip's weight.
             * @zh
             * Ȩء
             */
            weight: number;
        }
        /**
         * @en
         * Runtime status of a transition.
         * @zh
         * ɵ״̬
         */
        export interface TransitionStatus {
            /**
             * @en
             * The duration of the transition.
             * @zh
             * ɵڡ
             */
            duration: number;
            /**
             * @en
             * The progress of the transition.
             * @zh
             * ɵĽȡ
             */
            time: number;
        }
        /**
         * @en
         * Runtime status of a motion state.
         * @zh
         * ״̬״̬
         */
        export interface MotionStateStatus {
            /**
             * For testing.
             * TODO: remove it.
             * @internal
             */
            __DEBUG_ID__?: string;
            /**
             * @en
             * The normalized time of the state.
             * It would be the fraction part of `elapsed-time / duration` if elapsed time is non-negative,
             * and would be 1 plus the fraction part of `(elapsed-time / duration)` otherwise.
             * This is **NOT** the clip's progress if the state is not a clip motion or its wrap mode isn't loop.
             * @zh
             * ״̬Ĺ淶ʱ䡣
             * ŵʱǷǸģ `ʱ / ` С֣ `(ʱ / )` Сּ 1
             * һĽȣΪ״̬ܲһѭģʽѭ
             */
            progress: number;
        }
        /**
         * @en State machine component.
         * @zh ״̬
         */
        export class StateMachineComponent {
            /**
             * @en
             * Called when a motion state right after it entered.
             * @zh
             * ڸոս붯״̬ʱá
             * @param controller The animation controller it within.
             * @param motionStateStatus The status of the motion.
             */
            onMotionStateEnter(controller: AnimationController, motionStateStatus: Readonly<MotionStateStatus>): void;
            /**
             * @en
             * Called when a motion state is going to be exited.
             * @zh
             * ڼ˳״̬ʱá
             * @param controller The animation controller it within.
             * @param motionStateStatus The status of the motion.
             */
            onMotionStateExit(controller: AnimationController, motionStateStatus: Readonly<MotionStateStatus>): void;
            /**
             * @en
             * Called when a motion state updated except for the first and last frame.
             * @zh
             * ڶ״̬ʱãڵһκһʱá
             * @param controller The animation controller it within.
             * @param motionStateStatus The status of the motion.
             */
            onMotionStateUpdate(controller: AnimationController, motionStateStatus: Readonly<MotionStateStatus>): void;
            /**
             * @en
             * Called when a state machine right after it entered.
             * @zh
             * ڸոս״̬ʱá
             * @param controller The animation controller it within.
             */
            onStateMachineEnter(controller: AnimationController): void;
            /**
             * @en
             * Called when a state machine is going to be exited.
             * @zh
             * ڼ˳״̬ʱá
             * @param controller The animation controller it within.
             */
            onStateMachineExit(controller: AnimationController): void;
        }
        export type Value = number | string | boolean;
    }
    export interface ILerpable {
        /**
         * ڵǰֵĿֵֵ֮
         * @param to Ŀֵ
         * @param t ֵʡ
         * @param dt ǰֵĿֵʱλΪ롣
         * @returns ֵ
         */
        lerp(to: any, t: number, dt: number): any;
        /**
         * ֱʹֵΪʱĽֵӦõͬڲֵΪ 0 ʱĲֵ
         * @returns ֵΪ 0 ʱĲֵ
         */
        getNoLerp?(): any;
    }
    /**
     * @zh
     * ߡ
     * @en
     * Samples an animation curve.
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     * @param curve @zh ߡ@en The curve.
     * @param sampler @zh @en The sampler.
     * @param ratio @zh ʡ@en Sample ratio([0, 1]).
     */
    export function sampleAnimationCurve(curve: AnimCurve, sampler: RatioSampler, ratio: number): any;
    /**
     * @en
     * Compute a new ratio by curve type.
     * @zh
     * ͼµı
     * @param ratio - The origin ratio
     * @param type - If it's Array, then ratio will be computed with bezierByTime.
     * If it's string, then ratio will be computed with cc.easing function
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export function computeRatioByType(ratio: number, type: AnimationClip._legacy.LegacyEasingMethod): number;
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class RatioSampler {
        ratios: number[];
        constructor(ratios: number[]);
        sample(ratio: number): number;
    }
    /**
     * @en
     * Animation curve.
     * @zh
     * ߡ
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export class AnimCurve {
        static Linear: null;
        static Bezier(controlPoints: number[]): BezierControlPoints;
        types?: Array<(AnimationClip._legacy.LegacyEasingMethod | null)>;
        type?: AnimationClip._legacy.LegacyEasingMethod | null;
        constructor(propertyCurveData: Omit<AnimationClip._legacy.LegacyClipCurveData, "keys">, duration: number);
        hasLerp(): boolean;
        valueAt(index: number): any;
        valueBetween(ratio: number, from: number, fromRatio: number, to: number, toRatio: number): any;
        empty(): boolean;
        /**
         * Returns if this curve only yields constants.
         */
        constant(): boolean;
    }
    export class EventInfo {
        events: any[];
        /**
         * @param func event function
         * @param params event params
         */
        add(func: string, params: any[]): void;
    }
    export class AnimationManager extends System {
        get blendState(): __private._cocos_3d_skeletal_animation_skeletal_animation_blending__LegacyBlendStateBuffer;
        static ID: string;
        addCrossFade(crossFade: __private._cocos_animation_cross_fade__CrossFade): void;
        removeCrossFade(crossFade: __private._cocos_animation_cross_fade__CrossFade): void;
        update(dt: number): void;
        destruct(): void;
        addAnimation(anim: AnimationState): void;
        removeAnimation(anim: AnimationState): void;
        pushDelayEvent(fn: (...args: any[]) => void, thisArg: any, args: any[]): void;
        addSockets(root: Node, sockets: Socket[]): void;
        removeSockets(root: Node, sockets: Socket[]): void;
    }
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export function getPathFromRoot(target: Node | null, root: Node): string;
    /**
     * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
     */
    export function getWorldTransformUntilRoot(target: Node, root: Node, outMatrix: math.Mat4): math.Mat4;
    /**
     * @en
     * The audio clip asset.
     * @zh
     * ƵƬԴ
     */
    export class AudioClip extends Asset {
        static AudioType: typeof __private._pal_audio_type__AudioType;
        protected _duration: number;
        protected _loadMode: __private._pal_audio_type__AudioType;
        protected _meta: __private._cocos_audio_audio_clip__AudioMeta | null;
        destroy(): boolean;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        set _nativeAsset(meta: __private._cocos_audio_audio_clip__AudioMeta | null);
        get _nativeAsset(): __private._cocos_audio_audio_clip__AudioMeta | null;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _nativeDep(): {
            uuid: string;
            audioLoadMode: __private._pal_audio_type__AudioType;
            ext: string;
            __isNative__: boolean;
        };
        get loadMode(): __private._pal_audio_type__AudioType;
        validate(): boolean;
        getDuration(): number;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.state instead.
         */
        get state(): __private._pal_audio_type__AudioState;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.getCurrentTime() instead.
         */
        getCurrentTime(): number;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.getVolume() instead.
         */
        getVolume(): number;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.getLoop() instead.
         */
        getLoop(): boolean;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.setCurrentTime() instead.
         */
        setCurrentTime(time: number): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.setVolume() instead.
         */
        setVolume(volume: number): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.setLoop() instead.
         */
        setLoop(loop: boolean): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.play() instead.
         */
        play(): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.pause() instead.
         */
        pause(): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.stop() instead.
         */
        stop(): void;
        /**
         * @deprecated since v3.1.0, please use AudioSource.prototype.playOneShot() instead.
         */
        playOneShot(volume?: number): void;
    }
    /**
     * @en
     * A representation of a single audio source, <br>
     * contains basic functionalities like play, pause and stop.
     * @zh
     * ƵԴṩšֹͣͣȻܡ
     */
    export class AudioSource extends Component {
        static get maxAudioChannel(): number;
        static AudioState: typeof __private._pal_audio_type__AudioState;
        static EventType: typeof __private._cocos_audio_audio_source__AudioSourceEventType;
        protected _clip: AudioClip | null;
        protected _player: __private._pal_audio__AudioPlayer | null;
        protected _loop: boolean;
        protected _playOnAwake: boolean;
        protected _volume: number;
        /**
         * @en
         * The default AudioClip to be played for this audio source.
         * @zh
         * 趨ҪŵƵ
         */
        set clip(val: AudioClip | null);
        get clip(): AudioClip | null;
        /**
         * @en
         * Is looping enabled for this audio source?
         * @zh
         * ǷѭƵ
         */
        set loop(val: boolean);
        get loop(): boolean;
        /**
         * @en
         * Is the autoplay enabled? <br>
         * Note that for most platform autoplay will only start <br>
         * after a user gesture is received, according to the latest autoplay policy: <br>
         * https://www.chromium.org/audio-video/autoplay
         * @zh
         * ǷԶš <br>
         * ע⣬µԶŲԣڶԴƽ̨ԶֻڵһյûЧ <br>
         * οhttps://www.chromium.org/audio-video/autoplay
         */
        set playOnAwake(val: boolean);
        get playOnAwake(): boolean;
        /**
         * @en
         * The volume of this audio source (0.0 to 1.0).<br>
         * Note: Volume control may be ineffective on some platforms.
         * @zh
         * ƵСΧΪ 0.0  1.0<br>
         * ע⣬ĳЩƽ̨ϣƿܲЧ<br>
         */
        set volume(val: number);
        get volume(): number;
        onLoad(): void;
        onEnable(): void;
        onDisable(): void;
        onDestroy(): void;
        /**
         * @en
         * Get PCM data from specified channel.
         * Currently it is only available in Native platform and Web Audio (including Web and ByteDance platforms).
         *
         * @zh
         * ָͨͨȡƵ PCM data
         * Ŀǰԭƽ̨ Web Audio Web  ֽƽ̨пá
         *
         * @param channelIndex The channel index. 0 is left channel, 1 is right channel.
         * @returns A Promise to get the PCM data after audio is loaded.
         *
         * @example
         * ```ts
         * audioSource.getPCMData(0).then(dataView => {
         *   if (!dataView)  return;
         *   for (let i = 0; i < dataView.length; ++i) {
         *     console.log('data: ' + dataView.getData(i));
         *   }
         * });
         * ```
         */
        getPCMData(channelIndex: number): Promise<AudioPCMDataView | undefined>;
        /**
         * @en
         * Get the sample rate of audio.
         * Currently it is only available in Native platform and Web Audio (including Web and ByteDance platforms).
         *
         * @zh
         * ȡƵĲʡ
         * Ŀǰԭƽ̨ Web Audio Web  ֽƽ̨пá
         *
         * @returns A Promise to get the sample rate after audio is loaded.
         */
        getSampleRate(): Promise<number>;
        /**
         * @en
         * Play the clip.<br>
         * Restart if already playing.<br>
         * Resume if paused.
         *
         * NOTE: On Web platforms, the Auto Play Policy bans auto playing audios at the first time, because the user gesture is required.
         * there are 2 ways to play audios at the first time:
         * - play audios in the callback of TOUCH_END or MOUSE_UP event
         * - play audios straightly, the engine will auto play audios at the next user gesture.
         *
         * @zh
         * ʼš<br>
         * Ƶڲ״̬¿ʼƵ<br>
         * Ƶͣ״̬Ƶ
         *
         * ע: Web ƽ̨Auto Play Policy ֹ״ԶƵΪҪû֮ܲƵ
         * ַʽʵƵ״Զţ
         * -  TOUCH_END  MOUSE_UP ¼صﲥƵ
         * - ֱӲƵһηûʱԶš
         */
        play(): void;
        /**
         * @en
         * Pause the clip.
         * @zh
         * ͣš
         */
        pause(): void;
        /**
         * @en
         * Stop the clip.
         * @zh
         * ֹͣš
         */
        stop(): void;
        /**
         * @en
         * Plays an AudioClip, and scales volume by volumeScale. The result volume is `audioSource.volume * volumeScale`. <br>
         * @zh
         * ָһƵһΡղŵΪ `audioSource.volume * volumeScale` <br>
         * @param clip The audio clip to be played.
         * @param volumeScale volume scaling factor wrt. current value.
         */
        playOneShot(clip: AudioClip, volumeScale?: number): void;
        protected _syncStates(): void;
        /**
         * @en
         * Set current playback time, in seconds.
         * @zh
         * Ϊλõǰʱ䡣
         * @param num playback time to jump to.
         */
        set currentTime(num: number);
        /**
         * @en
         * Get the current playback time, in seconds.
         * @zh
         * Ϊλȡǰʱ䡣
         */
        get currentTime(): number;
        /**
         * @en
         * Get the audio duration, in seconds.
         * @zh
         * ȡΪλƵʱ
         */
        get duration(): number;
        /**
         * @en
         * Get current audio state.
         * @zh
         * ȡǰƵ״̬
         */
        get state(): __private._pal_audio_type__AudioState;
        /**
         * @en
         * Is the audio currently playing?
         * @zh
         * ǰƵǷڲţ
         */
        get playing(): boolean;
    }
    export class AudioPCMDataView {
        constructor(arrayBufferView: __private._pal_audio_type__AudioBufferView, normalizeFactor: number);
        constructor(arrayBuffer: ArrayBuffer, Ctor: __private.__types_globals__Constructor<__private._pal_audio_type__AudioBufferView>, normalizeFactor: number);
        get length(): number;
        getData(offset: number): number;
    }
    /**
     * @en The root manager of the renderer which manages all device resources and the render pipeline.
     * @zh Ⱦ࣬豸صԴԼȾߡ
     */
    export class Root {
        /**
         * @en The GFX device
         * @zh GFX 豸
         */
        get device(): gfx.Device;
        /**
         * @en The main window
         * @zh 
         */
        get mainWindow(): __private._cocos_render_scene_core_render_window__RenderWindow | null;
        /**
         * @en The current active window
         * @zh ǰĴ
         */
        set curWindow(window: __private._cocos_render_scene_core_render_window__RenderWindow | null);
        get curWindow(): __private._cocos_render_scene_core_render_window__RenderWindow | null;
        /**
         * @e The temporary window for data transmission
         * @zh ʱڣݴ䣩
         * @internal
         */
        set tempWindow(window: __private._cocos_render_scene_core_render_window__RenderWindow | null);
        get tempWindow(): __private._cocos_render_scene_core_render_window__RenderWindow | null;
        /**
         * @en The windows list
         * @zh б
         */
        get windows(): __private._cocos_render_scene_core_render_window__RenderWindow[];
        /**
         * @zh
         * ԶȾ
         */
        get usesCustomPipeline(): boolean;
        /**
         * @en The render pipeline
         * @zh Ⱦ
         */
        get pipeline(): __private._cocos_rendering_custom_pipeline__PipelineRuntime;
        /**
         * @en The custom render pipeline
         * @zh ԶȾ
         */
        get customPipeline(): rendering.BasicPipeline;
        /**
         * @en The pipeline events
         * @zh Ⱦ¼
         */
        get pipelineEvent(): __private._cocos_rendering_pipeline_event__IPipelineEvent;
        /**
         * @en The draw batch manager for 2D UI, for engine internal usage, user do not need to use this.
         * @zh 2D UI Ⱦڲʹãûʹô˽ӿ
         */
        get batcher2D(): UI;
        /**
         * @en Render scenes list
         * @zh Ⱦб
         */
        get scenes(): renderer.RenderScene[];
        /**
         * @en The debug view manager for rendering
         * @zh ȾԹ
         */
        get debugView(): DebugView;
        /**
         * @en The time cumulated in seconds since the game began running.
         * @zh ۼʱ䣨룩
         */
        get cumulativeTime(): number;
        /**
         * @en The current frame time in seconds.
         * @zh ֡ʱ䣨룩
         */
        get frameTime(): number;
        /**
         * @en The frame count during the last second
         * @zh һڵۼ֡
         */
        get frameCount(): number;
        /**
         * @en The recent frame rate for the last second
         * @zh ǰÿ֡
         */
        get fps(): number;
        /**
         * @en The wanted frame rate set by user
         * @zh ÿ趨֡
         */
        set fixedFPS(fps: number);
        get fixedFPS(): number;
        /**
         * @internal
         */
        get dataPoolManager(): __private._cocos_3d_skeletal_animation_data_pool_manager__DataPoolManager;
        /**
         * @en Whether the built-in deferred pipeline is used.
         * @zh ǷӳȾ
         */
        get useDeferredPipeline(): boolean;
        get cameraList(): renderer.scene.Camera[];
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _createSceneFun: (root: Root) => renderer.RenderScene;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _createWindowFun: (root: Root) => __private._cocos_render_scene_core_render_window__RenderWindow;
        /**
         * @en The constructor of the root, user shouldn't create the root instance, it's managed by the [[Director]].
         * @zh 캯ûӦԼκ Root  [[Director]] ġ
         * @param device GFX device
         */
        constructor(device: gfx.Device);
        /**
         * @en The initialization function, user shouldn't initialize the root, it's managed by the [[Director]].
         * @zh ʼûӦԼʼ Root [[Director]] ġ
         * @param info Root initialization information
         */
        initialize(info: __private._cocos_root__IRootInfo): void;
        /**
         * @en Destroy the root, user shouldn't invoke this function, it will cause undefined behavior.
         * @zh  RootûӦõô˷δ֪Ϊ
         */
        destroy(): void;
        /**
         * @en Resize the on-screen render windows.
         * @zh ڵĴС
         * @param width The new width of the window.
         * @param height The new height of the window.
         * @param windowId The system window ID, optional for now.
         */
        resize(width: number, height: number, windowId?: number): void;
        /**
         * @en Setup the render pipeline
         * @zh Ⱦ
         * @param rppl The render pipeline
         * @returns The setup is successful or not
         */
        setRenderPipeline(rppl?: RenderPipeline): boolean;
        /**
         * @en Notify the pipeline and all scenes that the global pipeline state have been updated so that they can update their render data and states.
         * @zh ֪ͨȾߺгȫֹ״̬Ѹ£Ҫ״̬
         */
        onGlobalPipelineStateChanged(): void;
        /**
         * @en Active the render window as the [[curWindow]]
         * @zh ָΪǰ [[curWindow]]
         * @param window The render window to be activated
         */
        activeWindow(window: __private._cocos_render_scene_core_render_window__RenderWindow): void;
        /**
         * @en Reset the time cumulated
         * @zh ۼʱ
         */
        resetCumulativeTime(): void;
        /**
         * @en The entry function of the render process for every frame.
         * @zh ÿִ֡Ⱦ̵ں
         * @param deltaTime @en The delta time since last update. @zh һ֡ʱ
         */
        frameMove(deltaTime: number): void;
        /**
         * @en Create a render window
         * @zh һµĴ
         * @param info @en The window creation information @zh Ϣ
         */
        createWindow(info: __private._cocos_render_scene_core_render_window__IRenderWindowInfo): __private._cocos_render_scene_core_render_window__RenderWindow | null;
        /**
         * @en Destroy a render window
         * @zh ָĴ
         * @param window The render window to be destroyed
         */
        destroyWindow(window: __private._cocos_render_scene_core_render_window__RenderWindow): void;
        /**
         * @en Destroy all render windows
         * @zh ȫ
         */
        destroyWindows(): void;
        /**
         * @en Create a render scene
         * @zh Ⱦ
         * @param info @en The creation information for render scene @zh ȾϢ
         */
        createScene(info: renderer.IRenderSceneInfo): renderer.RenderScene;
        /**
         * @en Destroy the given render scene
         * @zh ָȾ
         * @param scene @en The render scene to be destroyed. @zh ҪٵȾ
         */
        destroyScene(scene: renderer.RenderScene): void;
        /**
         * @en Destroy all render scenes.
         * @zh ȫ
         */
        destroyScenes(): void;
        /**
         * @en Create a model
         * @zh ģ
         * @param ModelCtor @en The class of the model @zh ģ͵
         * @returns The model created
         */
        createModel<T extends renderer.scene.Model>(ModelCtor: typeof renderer.scene.Model): T;
        /**
         * @en Destroy the given model
         * @zh ָģ
         * @param m @en The model to be destroyed @zh Ҫٵģ
         */
        destroyModel(m: renderer.scene.Model): void;
        /**
         * @en Create a camera
         * @zh һ
         * @returns The camera created.
         */
        createCamera(): renderer.scene.Camera;
        /**
         * @en Create a light source
         * @zh Դ
         * @param LightCtor @en The class of the light @zh Դ
         * @returns The light created
         */
        createLight<T extends renderer.scene.Light>(LightCtor: new () => T): T;
        /**
         * @en Destroy the given light
         * @zh ָĹԴ
         * @param l @en The light to be destroyed @zh ҪٵĹԴ
         */
        destroyLight(l: renderer.scene.Light): void;
        /**
         * @en recycle the given light to light object pool
         * @zh ָĹԴ
         * @param l @en The light to be recycled @zh ҪյĹԴ
         */
        recycleLight(l: renderer.scene.Light): void;
    }
    export namespace gfx {
        /**
         * @en GFX sampler.
         * @zh GFX 
         */
        export class Sampler extends GFXObject {
            get info(): Readonly<SamplerInfo>;
            get hash(): number;
            protected _info: SamplerInfo;
            protected _hash: number;
            constructor(info: Readonly<SamplerInfo>, hash: number);
            static computeHash(info: Readonly<SamplerInfo>): Filter;
            static unpackFromHash(hash: number): SamplerInfo;
        }
        export class SamplerInfo {
            minFilter: Filter;
            magFilter: Filter;
            mipFilter: Filter;
            addressU: Address;
            addressV: Address;
            addressW: Address;
            maxAnisotropy: number;
            cmpFunc: ComparisonFunc;
            constructor(minFilter?: Filter, magFilter?: Filter, mipFilter?: Filter, addressU?: Address, addressV?: Address, addressW?: Address, maxAnisotropy?: number, cmpFunc?: ComparisonFunc);
            copy(info: Readonly<SamplerInfo>): SamplerInfo;
        }
        /**
         * @en Get the memory size of the specified type.
         * @zh õ GFX ͵ĴС
         * @param type The target type.
         */
        export function GetTypeSize(type: Type): number;
        /**
         * @en GFX descriptor sets.
         * @zh GFX 顣
         */
        export abstract class DescriptorSet extends GFXObject {
            get layout(): DescriptorSetLayout;
            protected _layout: DescriptorSetLayout | null;
            protected _buffers: Buffer[];
            protected _textures: Texture[];
            protected _samplers: Sampler[];
            protected _isDirty: boolean;
            constructor();
            abstract initialize(info: Readonly<DescriptorSetInfo>): void;
            abstract destroy(): void;
            abstract update(): void;
            /**
             * @en Bind buffer to the specified descriptor.
             * @zh ָλϰ󶨻塣
             * @param binding The target binding.
             * @param buffer The buffer to be bound.
             */
            bindBuffer(binding: number, buffer: Buffer, index?: number): void;
            /**
             * @en Bind sampler to the specified descriptor.
             * @zh ָλϰ󶨲
             * @param binding The target binding.
             * @param sampler The sampler to be bound.
             */
            bindSampler(binding: number, sampler: Sampler, index?: number): void;
            /**
             * @en Bind texture to the specified descriptor.
             * @zh ָλϰ
             * @param binding The target binding.
             * @param texture The texture to be bound.
             */
            bindTexture(binding: number, texture: Texture, index?: number, flags?: AccessFlags): void;
            /**
             * @en Get buffer from the specified binding location.
             * @zh ȡǰָλϵĻ塣
             * @param binding The target binding.
             */
            getBuffer(binding: number, index?: number): Buffer;
            /**
             * @en Get sampler from the specified binding location.
             * @zh ȡǰָλϵĲ
             * @param binding The target binding.
             */
            getSampler(binding: number, index?: number): Sampler;
            /**
             * @en Get texture from the specified binding location.
             * @zh ȡǰָλϵͼ
             * @param binding The target binding.
             */
            getTexture(binding: number, index?: number): Texture;
        }
        /**
         * @en GFX buffer.
         * @zh GFX 塣
         */
        export abstract class Buffer extends GFXObject {
            /**
             * @en Usage type of the buffer.
             * @zh ʹ÷ʽ
             */
            get usage(): BufferUsage;
            /**
             * @en Memory usage of the buffer.
             * @zh ڴʹ÷ʽ
             */
            get memUsage(): MemoryUsage;
            /**
             * @en Size of the buffer.
             * @zh С
             */
            get size(): number;
            /**
             * @en Stride of the buffer.
             * @zh 岽
             */
            get stride(): number;
            /**
             * @en Count of the buffer wrt. stride.
             * @zh Ŀ
             */
            get count(): number;
            get flags(): BufferFlags;
            protected _usage: BufferUsage;
            protected _memUsage: MemoryUsage;
            protected _size: number;
            protected _stride: number;
            protected _count: number;
            protected _flags: BufferFlags;
            protected _isBufferView: boolean;
            constructor();
            abstract initialize(info: Readonly<BufferInfo> | Readonly<BufferViewInfo>): void;
            abstract destroy(): void;
            /**
             * @en Resize the buffer.
             * @zh ûС
             * @param size The new buffer size.
             */
            abstract resize(size: number): void;
            /**
             * @en Update the buffer data.
             * @zh »ݡ
             * @param buffer The new buffer data.
             * @param size Size in bytes to be updated.
             */
            abstract update(buffer: Readonly<BufferSource>, size?: number): void;
        }
        /**
         * @en GFX command buffer.
         * @zh GFX 塣
         */
        export abstract class CommandBuffer extends GFXObject {
            /**
             * @en Type of the command buffer.
             * @zh ͡
             */
            get type(): CommandBufferType;
            /**
             * @en Type of the command buffer.
             * @zh ͡
             */
            get queue(): Queue;
            /**
             * @en Number of draw calls currently recorded.
             * @zh Ƶô
             */
            get numDrawCalls(): number;
            /**
             * @en Number of instances currently recorded.
             * @zh  Instance 
             */
            get numInstances(): number;
            /**
             * @en Number of triangles currently recorded.
             * @zh 
             */
            get numTris(): number;
            protected _queue: Queue | null;
            protected _type: CommandBufferType;
            protected _numDrawCalls: number;
            protected _numInstances: number;
            protected _numTris: number;
            constructor();
            abstract initialize(info: Readonly<CommandBufferInfo>): void;
            abstract destroy(): void;
            /**
             * @en Begin recording commands.
             * @zh ʼ¼
             * @param renderPass [Secondary Command Buffer Only] The render pass the subsequent commands will be executed in
             * @param subpass [Secondary Command Buffer Only] The subpass the subsequent commands will be executed in
             * @param frameBuffer [Secondary Command Buffer Only, Optional] The framebuffer to be used in the subpass
             */
            abstract begin(renderPass?: RenderPass, subpass?: number, frameBuffer?: Framebuffer): void;
            /**
             * @en End recording commands.
             * @zh ¼
             */
            abstract end(): void;
            /**
             * @en Begin render pass.
             * @zh ʼ RenderPass
             * @param framebuffer The frame buffer used.
             * @param renderArea The target render area.
             * @param clearFlag The clear flags.
             * @param clearColors The clearing colors.
             * @param clearDepth The clearing depth.
             * @param clearStencil The clearing stencil.
             */
            abstract beginRenderPass(renderPass: RenderPass, framebuffer: Framebuffer, renderArea: Readonly<Rect>, clearColors: Readonly<Color[]>, clearDepth: number, clearStencil: number): void;
            /**
             * @en End render pass.
             * @zh  RenderPass
             */
            abstract endRenderPass(): void;
            /**
             * @en Bind pipeline state.
             * @zh  GFX ״̬
             * @param pipelineState The pipeline state to be bound.
             */
            abstract bindPipelineState(pipelineState: PipelineState): void;
            /**
             * @en Bind a descriptor set. Note that the corresponding PiplieneState has to be bound first
             * before calling this function, or the dynamic offset specified may be invalidated.
             * @zh  GFX עڵô˺ǰȰ󶨶Ӧ PipelineState dynamic offset Ч
             * @param set The target descriptor set index.
             * @param descriptorSet The descriptor set to be bound.
             * @param dynamicOffsets The offset numbers for dynamic bindings.
             */
            abstract bindDescriptorSet(set: number, descriptorSet: DescriptorSet, dynamicOffsets?: Readonly<number[]>): void;
            /**
             * @en Bind input assembler.
             * @zh  GFX 㼯
             * @param inputAssembler The input assembler to be bound.
             */
            abstract bindInputAssembler(inputAssembler: InputAssembler): void;
            /**
             * @en Set viewport.
             * @zh ӿڡ
             * @param viewport The new viewport.
             */
            abstract setViewport(viewport: Readonly<Viewport>): void;
            /**
             * @en Set scissor range.
             * @zh ü
             * @param scissor The new scissor range.
             */
            abstract setScissor(scissor: Readonly<Rect>): void;
            /**
             * @en Set line width.
             * @zh ߿
             * @param lineWidth The new line width.
             */
            abstract setLineWidth(lineWidth: number): void;
            /**
             * @en Set depth bias.
             * @zh ƫơ
             * @param depthBiasConstantFactor The new depth bias factor.
             * @param depthBiasClamp The new depth bias clamp threshold.
             * @param depthBiasSlopeFactor  The new depth bias slope factor.
             */
            abstract setDepthBias(depthBiasConstantFactor: number, depthBiasClamp: number, depthBiasSlopeFactor: number): void;
            /**
             * @en Set blend constants.
             * @zh ûӡ
             * @param blendConstants The new blend constants.
             */
            abstract setBlendConstants(blendConstants: Readonly<Color>): void;
            /**
             * @en Set depth bound.
             * @zh ȱ߽硣
             * @param minDepthBounds The new minimum depth bound.
             * @param maxDepthBounds The new maximum depth bound.
             */
            abstract setDepthBound(minDepthBounds: number, maxDepthBounds: number): void;
            /**
             * @en Set stencil write mask.
             * @zh ģд롣
             * @param face The effective triangle face.
             * @param writeMask The new stencil write mask.
             */
            abstract setStencilWriteMask(face: StencilFace, writeMask: number): void;
            /**
             * @en Set stencil compare mask.
             * @zh ģȽ롣
             * @param face The effective triangle face.
             * @param reference The new stencil reference constant.
             * @param compareMask The new stencil read mask.
             */
            abstract setStencilCompareMask(face: StencilFace, reference: number, compareMask: number): void;
            /**
             * @en Draw the specified primitives.
             * @zh ơ
             * @param infoOrAssembler The draw call information.
             */
            abstract draw(infoOrAssembler: Readonly<DrawInfo> | Readonly<InputAssembler>): void;
            /**
             * @en Update buffer.
             * @zh »塣
             * @param buffer The buffer to be updated.
             * @param data The source data.
             * @param size Size in bytes to be updated.
             */
            abstract updateBuffer(buffer: Buffer, data: Readonly<ArrayBuffer>, size?: number): void;
            /**
             * @en Copy buffer to texture.
             * @zh 嵽
             * @param srcBuff The buffer to be copied.
             * @param dstTex The texture to copy to.
             * @param dstLayout The target texture layout.
             * @param regions The region descriptions.
             */
            abstract copyBuffersToTexture(buffers: Readonly<ArrayBufferView[]>, texture: Texture, regions: Readonly<BufferTextureCopy[]>): void;
            /**
             * @en Execute specified command buffers.
             * @zh ִһ塣
             * @param cmdBuffs The command buffers to be executed.
             * @param count The number of command buffers to be executed.
             */
            abstract execute(cmdBuffs: Readonly<CommandBuffer[]>, count: number): void;
            /**
             * @en Insert pipeline memory barriers.
             * @zh ڴϡ
             * @param barrier The global memory barrier to apply.
             * @param textureBarriers The texture memory barriers to apply.
             */
            abstract pipelineBarrier(barrier: Readonly<GeneralBarrier> | null, bufferBarriers?: Readonly<__private._cocos_gfx_base_states_buffer_barrier__BufferBarrier[]>, buffers?: Readonly<Buffer[]>, textureBarriers?: Readonly<TextureBarrier[]>, textures?: Readonly<Texture[]>): void;
            /**
             * @en blit data from regions of source texture to regions of destination texture.
             * @zh ݴԴ򿽱Ŀ
             *
             * @param srcTexture The source texture.
             * @param dstTexture The destination texture.
             * @param regions The region descriptions.
             * @param filter The filter to use.
             */
            abstract blitTexture(srcTexture: Readonly<Texture>, dstTexture: Texture, regions: Readonly<TextureBlit[]>, filter: Filter): void;
        }
        export function IsPowerOf2(x: number): boolean;
        /**
         * @en Get memory size of the specified fomat.
         * @zh ȡָʽӦڴС
         * @param format The target format.
         * @param width The target width.
         * @param height The target height.
         * @param depth The target depth.
         */
        export function FormatSize(format: Format, width: number, height: number, depth: number): number;
        /**
         * @en Get memory size of the specified surface.
         * @zh GFX ʽڴС
         * @param format The target format.
         * @param width The target width.
         * @param height The target height.
         * @param depth The target depth.
         * @param mips The target mip levels.
         */
        export function FormatSurfaceSize(format: Format, width: number, height: number, depth: number, mips: number): number;
        export function getTypedArrayConstructor(info: FormatInfo): __private.__types_globals__TypedArrayConstructor;
        export function formatAlignment(format: Format): FormatAlignment;
        export function alignTo(size: number, alignment: number): number;
        /**
         * ========================= !DO NOT CHANGE THE FOLLOWING SECTION MANUALLY! =========================
         * The following section is auto-generated from native/cocos/renderer/core/gfx/GFXDef-common.h
         * by the script native/tools/gfx-define-generator/generate.js.
         * Changes to these public interfaces should be made there first and synced back.
         * ========================= !DO NOT CHANGE THE FOLLOWING SECTION MANUALLY! =========================
         */
        /**
         * @en Graphics object type
         * @zh ͼAPI
         */
        export enum ObjectType {
            UNKNOWN = 0,
            SWAPCHAIN = 1,
            BUFFER = 2,
            TEXTURE = 3,
            RENDER_PASS = 4,
            FRAMEBUFFER = 5,
            SAMPLER = 6,
            SHADER = 7,
            DESCRIPTOR_SET_LAYOUT = 8,
            PIPELINE_LAYOUT = 9,
            PIPELINE_STATE = 10,
            DESCRIPTOR_SET = 11,
            INPUT_ASSEMBLER = 12,
            COMMAND_BUFFER = 13,
            QUEUE = 14,
            QUERY_POOL = 15,
            GLOBAL_BARRIER = 16,
            TEXTURE_BARRIER = 17,
            BUFFER_BARRIER = 18,
            COUNT = 19
        }
        export enum Status {
            UNREADY = 0,
            FAILED = 1,
            SUCCESS = 2
        }
        export enum API {
            UNKNOWN = 0,
            GLES2 = 1,
            GLES3 = 2,
            METAL = 3,
            VULKAN = 4,
            NVN = 5,
            WEBGL = 6,
            WEBGL2 = 7,
            WEBGPU = 8
        }
        export enum SurfaceTransform {
            IDENTITY = 0,
            ROTATE_90 = 1,
            ROTATE_180 = 2,
            ROTATE_270 = 3
        }
        export enum Feature {
            ELEMENT_INDEX_UINT = 0,
            INSTANCED_ARRAYS = 1,
            MULTIPLE_RENDER_TARGETS = 2,
            BLEND_MINMAX = 3,
            COMPUTE_SHADER = 4,
            INPUT_ATTACHMENT_BENEFIT = 5,
            SUBPASS_COLOR_INPUT = 6,
            SUBPASS_DEPTH_STENCIL_INPUT = 7,
            RASTERIZATION_ORDER_COHERENT = 8,
            MULTI_SAMPLE_RESOLVE_DEPTH_STENCIL = 9,
            COUNT = 10
        }
        export enum Format {
            UNKNOWN = 0,
            A8 = 1,
            L8 = 2,
            LA8 = 3,
            R8 = 4,
            R8SN = 5,
            R8UI = 6,
            R8I = 7,
            R16F = 8,
            R16UI = 9,
            R16I = 10,
            R32F = 11,
            R32UI = 12,
            R32I = 13,
            RG8 = 14,
            RG8SN = 15,
            RG8UI = 16,
            RG8I = 17,
            RG16F = 18,
            RG16UI = 19,
            RG16I = 20,
            RG32F = 21,
            RG32UI = 22,
            RG32I = 23,
            RGB8 = 24,
            SRGB8 = 25,
            RGB8SN = 26,
            RGB8UI = 27,
            RGB8I = 28,
            RGB16F = 29,
            RGB16UI = 30,
            RGB16I = 31,
            RGB32F = 32,
            RGB32UI = 33,
            RGB32I = 34,
            RGBA8 = 35,
            BGRA8 = 36,
            SRGB8_A8 = 37,
            RGBA8SN = 38,
            RGBA8UI = 39,
            RGBA8I = 40,
            RGBA16F = 41,
            RGBA16UI = 42,
            RGBA16I = 43,
            RGBA32F = 44,
            RGBA32UI = 45,
            RGBA32I = 46,
            R5G6B5 = 47,
            R11G11B10F = 48,
            RGB5A1 = 49,
            RGBA4 = 50,
            RGB10A2 = 51,
            RGB10A2UI = 52,
            RGB9E5 = 53,
            DEPTH = 54,
            DEPTH_STENCIL = 55,
            BC1 = 56,
            BC1_ALPHA = 57,
            BC1_SRGB = 58,
            BC1_SRGB_ALPHA = 59,
            BC2 = 60,
            BC2_SRGB = 61,
            BC3 = 62,
            BC3_SRGB = 63,
            BC4 = 64,
            BC4_SNORM = 65,
            BC5 = 66,
            BC5_SNORM = 67,
            BC6H_UF16 = 68,
            BC6H_SF16 = 69,
            BC7 = 70,
            BC7_SRGB = 71,
            ETC_RGB8 = 72,
            ETC2_RGB8 = 73,
            ETC2_SRGB8 = 74,
            ETC2_RGB8_A1 = 75,
            ETC2_SRGB8_A1 = 76,
            ETC2_RGBA8 = 77,
            ETC2_SRGB8_A8 = 78,
            EAC_R11 = 79,
            EAC_R11SN = 80,
            EAC_RG11 = 81,
            EAC_RG11SN = 82,
            PVRTC_RGB2 = 83,
            PVRTC_RGBA2 = 84,
            PVRTC_RGB4 = 85,
            PVRTC_RGBA4 = 86,
            PVRTC2_2BPP = 87,
            PVRTC2_4BPP = 88,
            ASTC_RGBA_4X4 = 89,
            ASTC_RGBA_5X4 = 90,
            ASTC_RGBA_5X5 = 91,
            ASTC_RGBA_6X5 = 92,
            ASTC_RGBA_6X6 = 93,
            ASTC_RGBA_8X5 = 94,
            ASTC_RGBA_8X6 = 95,
            ASTC_RGBA_8X8 = 96,
            ASTC_RGBA_10X5 = 97,
            ASTC_RGBA_10X6 = 98,
            ASTC_RGBA_10X8 = 99,
            ASTC_RGBA_10X10 = 100,
            ASTC_RGBA_12X10 = 101,
            ASTC_RGBA_12X12 = 102,
            ASTC_SRGBA_4X4 = 103,
            ASTC_SRGBA_5X4 = 104,
            ASTC_SRGBA_5X5 = 105,
            ASTC_SRGBA_6X5 = 106,
            ASTC_SRGBA_6X6 = 107,
            ASTC_SRGBA_8X5 = 108,
            ASTC_SRGBA_8X6 = 109,
            ASTC_SRGBA_8X8 = 110,
            ASTC_SRGBA_10X5 = 111,
            ASTC_SRGBA_10X6 = 112,
            ASTC_SRGBA_10X8 = 113,
            ASTC_SRGBA_10X10 = 114,
            ASTC_SRGBA_12X10 = 115,
            ASTC_SRGBA_12X12 = 116,
            COUNT = 117
        }
        export enum FormatType {
            NONE = 0,
            UNORM = 1,
            SNORM = 2,
            UINT = 3,
            INT = 4,
            UFLOAT = 5,
            FLOAT = 6
        }
        export enum Type {
            UNKNOWN = 0,
            BOOL = 1,
            BOOL2 = 2,
            BOOL3 = 3,
            BOOL4 = 4,
            INT = 5,
            INT2 = 6,
            INT3 = 7,
            INT4 = 8,
            UINT = 9,
            UINT2 = 10,
            UINT3 = 11,
            UINT4 = 12,
            FLOAT = 13,
            FLOAT2 = 14,
            FLOAT3 = 15,
            FLOAT4 = 16,
            MAT2 = 17,
            MAT2X3 = 18,
            MAT2X4 = 19,
            MAT3X2 = 20,
            MAT3 = 21,
            MAT3X4 = 22,
            MAT4X2 = 23,
            MAT4X3 = 24,
            MAT4 = 25,
            SAMPLER1D = 26,
            SAMPLER1D_ARRAY = 27,
            SAMPLER2D = 28,
            SAMPLER2D_ARRAY = 29,
            SAMPLER3D = 30,
            SAMPLER_CUBE = 31,
            SAMPLER = 32,
            TEXTURE1D = 33,
            TEXTURE1D_ARRAY = 34,
            TEXTURE2D = 35,
            TEXTURE2D_ARRAY = 36,
            TEXTURE3D = 37,
            TEXTURE_CUBE = 38,
            IMAGE1D = 39,
            IMAGE1D_ARRAY = 40,
            IMAGE2D = 41,
            IMAGE2D_ARRAY = 42,
            IMAGE3D = 43,
            IMAGE_CUBE = 44,
            SUBPASS_INPUT = 45,
            COUNT = 46
        }
        export enum BufferUsageBit {
            NONE = 0,
            TRANSFER_SRC = 1,
            TRANSFER_DST = 2,
            INDEX = 4,
            VERTEX = 8,
            UNIFORM = 16,
            STORAGE = 32,
            INDIRECT = 64
        }
        export enum BufferFlagBit {
            NONE = 0
        }
        export enum MemoryAccessBit {
            NONE = 0,
            READ_ONLY = 1,
            WRITE_ONLY = 2,
            READ_WRITE = 3
        }
        export enum MemoryUsageBit {
            NONE = 0,
            DEVICE = 1,
            HOST = 2
        }
        export enum TextureType {
            TEX1D = 0,
            TEX2D = 1,
            TEX3D = 2,
            CUBE = 3,
            TEX1D_ARRAY = 4,
            TEX2D_ARRAY = 5
        }
        export enum TextureUsageBit {
            NONE = 0,
            TRANSFER_SRC = 1,
            TRANSFER_DST = 2,
            SAMPLED = 4,
            STORAGE = 8,
            COLOR_ATTACHMENT = 16,
            DEPTH_STENCIL_ATTACHMENT = 32,
            INPUT_ATTACHMENT = 64
        }
        export enum TextureFlagBit {
            NONE = 0,
            GEN_MIPMAP = 1,
            GENERAL_LAYOUT = 2,
            EXTERNAL_OES = 4,
            EXTERNAL_NORMAL = 8,
            LAZILY_ALLOCATED = 16,
            MUTABLE_VIEW_FORMAT = 64,
            MUTABLE_STORAGE = 128
        }
        export enum FormatFeatureBit {
            NONE = 0,
            RENDER_TARGET = 1,
            SAMPLED_TEXTURE = 2,
            LINEAR_FILTER = 4,
            STORAGE_TEXTURE = 8,
            VERTEX_ATTRIBUTE = 16
        }
        export enum SampleCount {
            X1 = 1,
            X2 = 2,
            X4 = 4,
            X8 = 8,
            X16 = 16,
            X32 = 32,
            X64 = 64
        }
        export enum VsyncMode {
            OFF = 0,
            ON = 1,
            RELAXED = 2,
            MAILBOX = 3,
            HALF = 4
        }
        export enum Filter {
            NONE = 0,
            POINT = 1,
            LINEAR = 2,
            ANISOTROPIC = 3
        }
        export enum Address {
            WRAP = 0,
            MIRROR = 1,
            CLAMP = 2,
            BORDER = 3
        }
        export enum ComparisonFunc {
            NEVER = 0,
            LESS = 1,
            EQUAL = 2,
            LESS_EQUAL = 3,
            GREATER = 4,
            NOT_EQUAL = 5,
            GREATER_EQUAL = 6,
            ALWAYS = 7
        }
        export enum StencilOp {
            ZERO = 0,
            KEEP = 1,
            REPLACE = 2,
            INCR = 3,
            DECR = 4,
            INVERT = 5,
            INCR_WRAP = 6,
            DECR_WRAP = 7
        }
        export enum BlendFactor {
            ZERO = 0,
            ONE = 1,
            SRC_ALPHA = 2,
            DST_ALPHA = 3,
            ONE_MINUS_SRC_ALPHA = 4,
            ONE_MINUS_DST_ALPHA = 5,
            SRC_COLOR = 6,
            DST_COLOR = 7,
            ONE_MINUS_SRC_COLOR = 8,
            ONE_MINUS_DST_COLOR = 9,
            SRC_ALPHA_SATURATE = 10,
            CONSTANT_COLOR = 11,
            ONE_MINUS_CONSTANT_COLOR = 12,
            CONSTANT_ALPHA = 13,
            ONE_MINUS_CONSTANT_ALPHA = 14
        }
        export enum BlendOp {
            ADD = 0,
            SUB = 1,
            REV_SUB = 2,
            MIN = 3,
            MAX = 4
        }
        export enum ColorMask {
            NONE = 0,
            R = 1,
            G = 2,
            B = 4,
            A = 8,
            ALL = 15
        }
        export enum ShaderStageFlagBit {
            NONE = 0,
            VERTEX = 1,
            CONTROL = 2,
            EVALUATION = 4,
            GEOMETRY = 8,
            FRAGMENT = 16,
            COMPUTE = 32,
            ALL = 63
        }
        export enum LoadOp {
            LOAD = 0,
            CLEAR = 1,
            DISCARD = 2
        }
        export enum StoreOp {
            STORE = 0,
            DISCARD = 1
        }
        export enum AccessFlagBit {
            NONE = 0,
            INDIRECT_BUFFER = 1,
            INDEX_BUFFER = 2,
            VERTEX_BUFFER = 4,
            VERTEX_SHADER_READ_UNIFORM_BUFFER = 8,
            VERTEX_SHADER_READ_TEXTURE = 16,
            VERTEX_SHADER_READ_OTHER = 32,
            FRAGMENT_SHADER_READ_UNIFORM_BUFFER = 64,
            FRAGMENT_SHADER_READ_TEXTURE = 128,
            FRAGMENT_SHADER_READ_COLOR_INPUT_ATTACHMENT = 256,
            FRAGMENT_SHADER_READ_DEPTH_STENCIL_INPUT_ATTACHMENT = 512,
            FRAGMENT_SHADER_READ_OTHER = 1024,
            COLOR_ATTACHMENT_READ = 2048,
            DEPTH_STENCIL_ATTACHMENT_READ = 4096,
            COMPUTE_SHADER_READ_UNIFORM_BUFFER = 8192,
            COMPUTE_SHADER_READ_TEXTURE = 16384,
            COMPUTE_SHADER_READ_OTHER = 32768,
            TRANSFER_READ = 65536,
            HOST_READ = 131072,
            PRESENT = 262144,
            VERTEX_SHADER_WRITE = 524288,
            FRAGMENT_SHADER_WRITE = 1048576,
            COLOR_ATTACHMENT_WRITE = 2097152,
            DEPTH_STENCIL_ATTACHMENT_WRITE = 4194304,
            COMPUTE_SHADER_WRITE = 8388608,
            TRANSFER_WRITE = 16777216,
            HOST_PREINITIALIZED = 33554432,
            HOST_WRITE = 67108864
        }
        export enum ResolveMode {
            NONE = 0,
            SAMPLE_ZERO = 1,
            AVERAGE = 2,
            MIN = 3,
            MAX = 4
        }
        export enum PipelineBindPoint {
            GRAPHICS = 0,
            COMPUTE = 1,
            RAY_TRACING = 2
        }
        export enum PrimitiveMode {
            POINT_LIST = 0,
            LINE_LIST = 1,
            LINE_STRIP = 2,
            LINE_LOOP = 3,
            LINE_LIST_ADJACENCY = 4,
            LINE_STRIP_ADJACENCY = 5,
            ISO_LINE_LIST = 6,
            TRIANGLE_LIST = 7,
            TRIANGLE_STRIP = 8,
            TRIANGLE_FAN = 9,
            TRIANGLE_LIST_ADJACENCY = 10,
            TRIANGLE_STRIP_ADJACENCY = 11,
            TRIANGLE_PATCH_ADJACENCY = 12,
            QUAD_PATCH_LIST = 13
        }
        export enum PolygonMode {
            FILL = 0,
            POINT = 1,
            LINE = 2
        }
        export enum ShadeModel {
            GOURAND = 0,
            FLAT = 1
        }
        export enum CullMode {
            NONE = 0,
            FRONT = 1,
            BACK = 2
        }
        export enum DynamicStateFlagBit {
            NONE = 0,
            LINE_WIDTH = 1,
            DEPTH_BIAS = 2,
            BLEND_CONSTANTS = 4,
            DEPTH_BOUNDS = 8,
            STENCIL_WRITE_MASK = 16,
            STENCIL_COMPARE_MASK = 32
        }
        export enum StencilFace {
            FRONT = 1,
            BACK = 2,
            ALL = 3
        }
        export enum DescriptorType {
            UNKNOWN = 0,
            UNIFORM_BUFFER = 1,
            DYNAMIC_UNIFORM_BUFFER = 2,
            STORAGE_BUFFER = 4,
            DYNAMIC_STORAGE_BUFFER = 8,
            SAMPLER_TEXTURE = 16,
            SAMPLER = 32,
            TEXTURE = 64,
            STORAGE_IMAGE = 128,
            INPUT_ATTACHMENT = 256
        }
        export enum QueueType {
            GRAPHICS = 0,
            COMPUTE = 1,
            TRANSFER = 2
        }
        export enum QueryType {
            OCCLUSION = 0,
            PIPELINE_STATISTICS = 1,
            TIMESTAMP = 2
        }
        export enum CommandBufferType {
            PRIMARY = 0,
            SECONDARY = 1
        }
        export enum ClearFlagBit {
            NONE = 0,
            COLOR = 1,
            DEPTH = 2,
            STENCIL = 4,
            DEPTH_STENCIL = 6,
            ALL = 7
        }
        export enum BarrierType {
            FULL = 0,
            SPLIT_BEGIN = 1,
            SPLIT_END = 2
        }
        export enum PassType {
            RASTER = 0,
            COMPUTE = 1,
            COPY = 2,
            MOVE = 3,
            RAYTRACE = 4,
            PRESENT = 5
        }
        export type BufferUsage = BufferUsageBit;
        export type BufferFlags = BufferFlagBit;
        export type MemoryAccess = MemoryAccessBit;
        export type MemoryUsage = MemoryUsageBit;
        export type TextureUsage = TextureUsageBit;
        export type TextureFlags = TextureFlagBit;
        export type FormatFeature = FormatFeatureBit;
        export type ShaderStageFlags = ShaderStageFlagBit;
        export type AccessFlags = AccessFlagBit;
        export type DynamicStateFlags = DynamicStateFlagBit;
        export type ClearFlags = ClearFlagBit;
        export class Size {
            x: number;
            y: number;
            z: number;
            constructor(x?: number, y?: number, z?: number);
            copy(info: Readonly<Size>): Size;
        }
        export class DeviceCaps {
            maxVertexAttributes: number;
            maxVertexUniformVectors: number;
            maxFragmentUniformVectors: number;
            maxTextureUnits: number;
            maxImageUnits: number;
            maxVertexTextureUnits: number;
            maxColorRenderTargets: number;
            maxShaderStorageBufferBindings: number;
            maxShaderStorageBlockSize: number;
            maxUniformBufferBindings: number;
            maxUniformBlockSize: number;
            maxTextureSize: number;
            maxCubeMapTextureSize: number;
            maxArrayTextureLayers: number;
            max3DTextureSize: number;
            uboOffsetAlignment: number;
            maxComputeSharedMemorySize: number;
            maxComputeWorkGroupInvocations: number;
            maxComputeWorkGroupSize: Size;
            maxComputeWorkGroupCount: Size;
            supportQuery: boolean;
            clipSpaceMinZ: number;
            screenSpaceSignY: number;
            clipSpaceSignY: number;
            constructor(maxVertexAttributes?: number, maxVertexUniformVectors?: number, maxFragmentUniformVectors?: number, maxTextureUnits?: number, maxImageUnits?: number, maxVertexTextureUnits?: number, maxColorRenderTargets?: number, maxShaderStorageBufferBindings?: number, maxShaderStorageBlockSize?: number, maxUniformBufferBindings?: number, maxUniformBlockSize?: number, maxTextureSize?: number, maxCubeMapTextureSize?: number, maxArrayTextureLayers?: number, max3DTextureSize?: number, uboOffsetAlignment?: number, maxComputeSharedMemorySize?: number, maxComputeWorkGroupInvocations?: number, maxComputeWorkGroupSize?: Size, maxComputeWorkGroupCount?: Size, supportQuery?: boolean, clipSpaceMinZ?: number, screenSpaceSignY?: number, clipSpaceSignY?: number);
            copy(info: Readonly<DeviceCaps>): DeviceCaps;
        }
        export class DeviceOptions {
            enableBarrierDeduce: boolean;
            constructor(enableBarrierDeduce?: boolean);
            copy(info: Readonly<DeviceOptions>): DeviceOptions;
        }
        export class Offset {
            x: number;
            y: number;
            z: number;
            constructor(x?: number, y?: number, z?: number);
            copy(info: Readonly<Offset>): Offset;
        }
        export class Rect {
            x: number;
            y: number;
            width: number;
            height: number;
            constructor(x?: number, y?: number, width?: number, height?: number);
            copy(info: Readonly<Rect>): Rect;
        }
        export class Extent {
            width: number;
            height: number;
            depth: number;
            constructor(width?: number, height?: number, depth?: number);
            copy(info: Readonly<Extent>): Extent;
        }
        export class TextureSubresLayers {
            mipLevel: number;
            baseArrayLayer: number;
            layerCount: number;
            constructor(mipLevel?: number, baseArrayLayer?: number, layerCount?: number);
            copy(info: Readonly<TextureSubresLayers>): TextureSubresLayers;
        }
        export class TextureSubresRange {
            baseMipLevel: number;
            levelCount: number;
            baseArrayLayer: number;
            layerCount: number;
            constructor(baseMipLevel?: number, levelCount?: number, baseArrayLayer?: number, layerCount?: number);
            copy(info: Readonly<TextureSubresRange>): TextureSubresRange;
        }
        export class TextureCopy {
            srcSubres: TextureSubresLayers;
            srcOffset: Offset;
            dstSubres: TextureSubresLayers;
            dstOffset: Offset;
            extent: Extent;
            constructor(srcSubres?: TextureSubresLayers, srcOffset?: Offset, dstSubres?: TextureSubresLayers, dstOffset?: Offset, extent?: Extent);
            copy(info: Readonly<TextureCopy>): TextureCopy;
        }
        export class TextureBlit {
            srcSubres: TextureSubresLayers;
            srcOffset: Offset;
            srcExtent: Extent;
            dstSubres: TextureSubresLayers;
            dstOffset: Offset;
            dstExtent: Extent;
            constructor(srcSubres?: TextureSubresLayers, srcOffset?: Offset, srcExtent?: Extent, dstSubres?: TextureSubresLayers, dstOffset?: Offset, dstExtent?: Extent);
            copy(info: Readonly<TextureBlit>): TextureBlit;
        }
        export class BufferTextureCopy {
            buffOffset: number;
            buffStride: number;
            buffTexHeight: number;
            texOffset: Offset;
            texExtent: Extent;
            texSubres: TextureSubresLayers;
            constructor(buffOffset?: number, buffStride?: number, buffTexHeight?: number, texOffset?: Offset, texExtent?: Extent, texSubres?: TextureSubresLayers);
            copy(info: Readonly<BufferTextureCopy>): BufferTextureCopy;
        }
        export class Viewport {
            left: number;
            top: number;
            width: number;
            height: number;
            minDepth: number;
            maxDepth: number;
            constructor(left?: number, top?: number, width?: number, height?: number, minDepth?: number, maxDepth?: number);
            copy(info: Readonly<Viewport>): Viewport;
            reset(): void;
        }
        export class Color {
            x: number;
            y: number;
            z: number;
            w: number;
            constructor(x?: number, y?: number, z?: number, w?: number);
            copy(info: Readonly<Color>): Color;
            set(x: number, y: number, z: number, w: number): Color;
            reset(): void;
        }
        export class BindingMappingInfo {
            maxBlockCounts: number[];
            maxSamplerTextureCounts: number[];
            maxSamplerCounts: number[];
            maxTextureCounts: number[];
            maxBufferCounts: number[];
            maxImageCounts: number[];
            maxSubpassInputCounts: number[];
            setIndices: number[];
            constructor(maxBlockCounts?: number[], maxSamplerTextureCounts?: number[], maxSamplerCounts?: number[], maxTextureCounts?: number[], maxBufferCounts?: number[], maxImageCounts?: number[], maxSubpassInputCounts?: number[], setIndices?: number[]);
            copy(info: Readonly<BindingMappingInfo>): BindingMappingInfo;
        }
        export class SwapchainInfo {
            windowId: number;
            windowHandle: HTMLCanvasElement;
            vsyncMode: VsyncMode;
            width: number;
            height: number;
            constructor(windowId?: number, windowHandle?: HTMLCanvasElement, vsyncMode?: VsyncMode, width?: number, height?: number);
            copy(info: Readonly<SwapchainInfo>): SwapchainInfo;
        }
        export class DeviceInfo {
            bindingMappingInfo: BindingMappingInfo;
            constructor(bindingMappingInfo?: BindingMappingInfo);
            copy(info: Readonly<DeviceInfo>): DeviceInfo;
        }
        export class BufferInfo {
            usage: BufferUsage;
            memUsage: MemoryUsage;
            size: number;
            stride: number;
            flags: BufferFlags;
            constructor(usage?: BufferUsage, memUsage?: MemoryUsage, size?: number, stride?: number, flags?: BufferFlags);
            copy(info: Readonly<BufferInfo>): BufferInfo;
        }
        export class BufferViewInfo {
            buffer: Buffer;
            offset: number;
            range: number;
            constructor(buffer?: Buffer, offset?: number, range?: number);
            copy(info: Readonly<BufferViewInfo>): BufferViewInfo;
        }
        export class DrawInfo {
            vertexCount: number;
            firstVertex: number;
            indexCount: number;
            firstIndex: number;
            vertexOffset: number;
            instanceCount: number;
            firstInstance: number;
            constructor(vertexCount?: number, firstVertex?: number, indexCount?: number, firstIndex?: number, vertexOffset?: number, instanceCount?: number, firstInstance?: number);
            copy(info: Readonly<DrawInfo>): DrawInfo;
        }
        export class DispatchInfo {
            groupCountX: number;
            groupCountY: number;
            groupCountZ: number;
            indirectBuffer: Buffer | null;
            indirectOffset: number;
            constructor(groupCountX?: number, groupCountY?: number, groupCountZ?: number, indirectBuffer?: Buffer | null, indirectOffset?: number);
            copy(info: Readonly<DispatchInfo>): DispatchInfo;
        }
        export class IndirectBuffer {
            drawInfos: DrawInfo[];
            constructor(drawInfos?: DrawInfo[]);
            copy(info: Readonly<IndirectBuffer>): IndirectBuffer;
        }
        export class TextureInfo {
            type: TextureType;
            usage: TextureUsage;
            format: Format;
            width: number;
            height: number;
            flags: TextureFlags;
            layerCount: number;
            levelCount: number;
            samples: SampleCount;
            depth: number;
            externalRes: number;
            constructor(type?: TextureType, usage?: TextureUsage, format?: Format, width?: number, height?: number, flags?: TextureFlags, layerCount?: number, levelCount?: number, samples?: SampleCount, depth?: number, externalRes?: number);
            copy(info: Readonly<TextureInfo>): TextureInfo;
        }
        export class TextureViewInfo {
            texture: Texture;
            type: TextureType;
            format: Format;
            baseLevel: number;
            levelCount: number;
            baseLayer: number;
            layerCount: number;
            constructor(texture?: Texture, type?: TextureType, format?: Format, baseLevel?: number, levelCount?: number, baseLayer?: number, layerCount?: number);
            copy(info: Readonly<TextureViewInfo>): TextureViewInfo;
        }
        export class Uniform {
            name: string;
            type: Type;
            count: number;
            constructor(name?: string, type?: Type, count?: number);
            copy(info: Readonly<Uniform>): Uniform;
        }
        export class UniformBlock {
            set: number;
            binding: number;
            name: string;
            members: Uniform[];
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, members?: Uniform[], count?: number, flattened?: number);
            copy(info: Readonly<UniformBlock>): UniformBlock;
        }
        export class UniformSamplerTexture {
            set: number;
            binding: number;
            name: string;
            type: Type;
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, type?: Type, count?: number, flattened?: number);
            copy(info: Readonly<UniformSamplerTexture>): UniformSamplerTexture;
        }
        export class UniformSampler {
            set: number;
            binding: number;
            name: string;
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, count?: number, flattened?: number);
            copy(info: Readonly<UniformSampler>): UniformSampler;
        }
        export class UniformTexture {
            set: number;
            binding: number;
            name: string;
            type: Type;
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, type?: Type, count?: number, flattened?: number);
            copy(info: Readonly<UniformTexture>): UniformTexture;
        }
        export class UniformStorageImage {
            set: number;
            binding: number;
            name: string;
            type: Type;
            count: number;
            memoryAccess: MemoryAccess;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, type?: Type, count?: number, memoryAccess?: MemoryAccess, flattened?: number);
            copy(info: Readonly<UniformStorageImage>): UniformStorageImage;
        }
        export class UniformStorageBuffer {
            set: number;
            binding: number;
            name: string;
            count: number;
            memoryAccess: MemoryAccess;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, count?: number, memoryAccess?: MemoryAccess, flattened?: number);
            copy(info: Readonly<UniformStorageBuffer>): UniformStorageBuffer;
        }
        export class UniformInputAttachment {
            set: number;
            binding: number;
            name: string;
            count: number;
            flattened: number;
            constructor(set?: number, binding?: number, name?: string, count?: number, flattened?: number);
            copy(info: Readonly<UniformInputAttachment>): UniformInputAttachment;
        }
        export class ShaderStage {
            stage: ShaderStageFlagBit;
            source: string;
            constructor(stage?: ShaderStageFlagBit, source?: string);
            copy(info: Readonly<ShaderStage>): ShaderStage;
        }
        export class Attribute {
            name: string;
            format: Format;
            isNormalized: boolean;
            stream: number;
            isInstanced: boolean;
            location: number;
            constructor(name?: string, format?: Format, isNormalized?: boolean, stream?: number, isInstanced?: boolean, location?: number);
            copy(info: Readonly<Attribute>): Attribute;
        }
        export class ShaderInfo {
            name: string;
            stages: ShaderStage[];
            attributes: Attribute[];
            blocks: UniformBlock[];
            buffers: UniformStorageBuffer[];
            samplerTextures: UniformSamplerTexture[];
            samplers: UniformSampler[];
            textures: UniformTexture[];
            images: UniformStorageImage[];
            subpassInputs: UniformInputAttachment[];
            constructor(name?: string, stages?: ShaderStage[], attributes?: Attribute[], blocks?: UniformBlock[], buffers?: UniformStorageBuffer[], samplerTextures?: UniformSamplerTexture[], samplers?: UniformSampler[], textures?: UniformTexture[], images?: UniformStorageImage[], subpassInputs?: UniformInputAttachment[]);
            copy(info: Readonly<ShaderInfo>): ShaderInfo;
        }
        export class InputAssemblerInfo {
            attributes: Attribute[];
            vertexBuffers: Buffer[];
            indexBuffer: Buffer | null;
            indirectBuffer: Buffer | null;
            constructor(attributes?: Attribute[], vertexBuffers?: Buffer[], indexBuffer?: Buffer | null, indirectBuffer?: Buffer | null);
            copy(info: Readonly<InputAssemblerInfo>): InputAssemblerInfo;
        }
        export class ColorAttachment {
            format: Format;
            sampleCount: SampleCount;
            loadOp: LoadOp;
            storeOp: StoreOp;
            barrier: GeneralBarrier;
            constructor(format?: Format, sampleCount?: SampleCount, loadOp?: LoadOp, storeOp?: StoreOp, barrier?: GeneralBarrier);
            copy(info: Readonly<ColorAttachment>): ColorAttachment;
        }
        export class DepthStencilAttachment {
            format: Format;
            sampleCount: SampleCount;
            depthLoadOp: LoadOp;
            depthStoreOp: StoreOp;
            stencilLoadOp: LoadOp;
            stencilStoreOp: StoreOp;
            barrier: GeneralBarrier;
            constructor(format?: Format, sampleCount?: SampleCount, depthLoadOp?: LoadOp, depthStoreOp?: StoreOp, stencilLoadOp?: LoadOp, stencilStoreOp?: StoreOp, barrier?: GeneralBarrier);
            copy(info: Readonly<DepthStencilAttachment>): DepthStencilAttachment;
        }
        export class SubpassInfo {
            inputs: number[];
            colors: number[];
            resolves: number[];
            preserves: number[];
            depthStencil: number;
            depthStencilResolve: number;
            depthResolveMode: ResolveMode;
            stencilResolveMode: ResolveMode;
            constructor(inputs?: number[], colors?: number[], resolves?: number[], preserves?: number[], depthStencil?: number, depthStencilResolve?: number, depthResolveMode?: ResolveMode, stencilResolveMode?: ResolveMode);
            copy(info: Readonly<SubpassInfo>): SubpassInfo;
        }
        export class SubpassDependency {
            srcSubpass: number;
            dstSubpass: number;
            generalBarrier: GeneralBarrier;
            prevAccesses: AccessFlags[];
            nextAccesses: AccessFlags[];
            constructor(srcSubpass?: number, dstSubpass?: number, generalBarrier?: GeneralBarrier, prevAccesses?: AccessFlags[], nextAccesses?: AccessFlags[]);
            copy(info: Readonly<SubpassDependency>): SubpassDependency;
        }
        export class RenderPassInfo {
            colorAttachments: ColorAttachment[];
            depthStencilAttachment: DepthStencilAttachment;
            depthStencilResolveAttachment: DepthStencilAttachment;
            subpasses: SubpassInfo[];
            dependencies: SubpassDependency[];
            constructor(colorAttachments?: ColorAttachment[], depthStencilAttachment?: DepthStencilAttachment, depthStencilResolveAttachment?: DepthStencilAttachment, subpasses?: SubpassInfo[], dependencies?: SubpassDependency[]);
            copy(info: Readonly<RenderPassInfo>): RenderPassInfo;
        }
        export class GeneralBarrierInfo {
            prevAccesses: AccessFlags;
            nextAccesses: AccessFlags;
            type: BarrierType;
            constructor(prevAccesses?: AccessFlags, nextAccesses?: AccessFlags, type?: BarrierType);
            copy(info: Readonly<GeneralBarrierInfo>): GeneralBarrierInfo;
        }
        export class TextureBarrierInfo {
            prevAccesses: AccessFlags;
            nextAccesses: AccessFlags;
            type: BarrierType;
            baseMipLevel: number;
            levelCount: number;
            baseSlice: number;
            sliceCount: number;
            discardContents: boolean;
            srcQueue: Queue | null;
            dstQueue: Queue | null;
            constructor(prevAccesses?: AccessFlags, nextAccesses?: AccessFlags, type?: BarrierType, baseMipLevel?: number, levelCount?: number, baseSlice?: number, sliceCount?: number, discardContents?: boolean, srcQueue?: Queue | null, dstQueue?: Queue | null);
            copy(info: Readonly<TextureBarrierInfo>): TextureBarrierInfo;
        }
        export class BufferBarrierInfo {
            prevAccesses: AccessFlags;
            nextAccesses: AccessFlags;
            type: BarrierType;
            offset: number;
            size: number;
            discardContents: boolean;
            srcQueue: Queue | null;
            dstQueue: Queue | null;
            constructor(prevAccesses?: AccessFlags, nextAccesses?: AccessFlags, type?: BarrierType, offset?: number, size?: number, discardContents?: boolean, srcQueue?: Queue | null, dstQueue?: Queue | null);
            copy(info: Readonly<BufferBarrierInfo>): BufferBarrierInfo;
        }
        export class FramebufferInfo {
            renderPass: RenderPass;
            colorTextures: Texture[];
            depthStencilTexture: Texture | null;
            depthStencilResolveTexture: Texture | null;
            constructor(renderPass?: RenderPass, colorTextures?: Texture[], depthStencilTexture?: Texture | null, depthStencilResolveTexture?: Texture | null);
            copy(info: Readonly<FramebufferInfo>): FramebufferInfo;
        }
        export class DescriptorSetLayoutBinding {
            binding: number;
            descriptorType: DescriptorType;
            count: number;
            stageFlags: ShaderStageFlags;
            immutableSamplers: Sampler[];
            constructor(binding?: number, descriptorType?: DescriptorType, count?: number, stageFlags?: ShaderStageFlags, immutableSamplers?: Sampler[]);
            copy(info: Readonly<DescriptorSetLayoutBinding>): DescriptorSetLayoutBinding;
        }
        export class DescriptorSetLayoutInfo {
            bindings: DescriptorSetLayoutBinding[];
            constructor(bindings?: DescriptorSetLayoutBinding[]);
            copy(info: Readonly<DescriptorSetLayoutInfo>): DescriptorSetLayoutInfo;
            reset(): void;
        }
        export class DescriptorSetInfo {
            layout: DescriptorSetLayout;
            constructor(layout?: DescriptorSetLayout);
            copy(info: Readonly<DescriptorSetInfo>): DescriptorSetInfo;
        }
        export class PipelineLayoutInfo {
            setLayouts: DescriptorSetLayout[];
            constructor(setLayouts?: DescriptorSetLayout[]);
            copy(info: Readonly<PipelineLayoutInfo>): PipelineLayoutInfo;
        }
        export class InputState {
            attributes: Attribute[];
            constructor(attributes?: Attribute[]);
            copy(info: Readonly<InputState>): InputState;
        }
        export class CommandBufferInfo {
            queue: Queue;
            type: CommandBufferType;
            constructor(queue?: Queue, type?: CommandBufferType);
            copy(info: Readonly<CommandBufferInfo>): CommandBufferInfo;
        }
        export class QueueInfo {
            type: QueueType;
            constructor(type?: QueueType);
            copy(info: Readonly<QueueInfo>): QueueInfo;
        }
        export class QueryPoolInfo {
            type: QueryType;
            maxQueryObjects: number;
            forceWait: boolean;
            constructor(type?: QueryType, maxQueryObjects?: number, forceWait?: boolean);
            copy(info: Readonly<QueryPoolInfo>): QueryPoolInfo;
        }
        export class FormatInfo {
            readonly name: string;
            readonly size: number;
            readonly count: number;
            readonly type: FormatType;
            readonly hasAlpha: boolean;
            readonly hasDepth: boolean;
            readonly hasStencil: boolean;
            readonly isCompressed: boolean;
            constructor(name?: string, size?: number, count?: number, type?: FormatType, hasAlpha?: boolean, hasDepth?: boolean, hasStencil?: boolean, isCompressed?: boolean);
        }
        export class MemoryStatus {
            bufferSize: number;
            textureSize: number;
            constructor(bufferSize?: number, textureSize?: number);
            copy(info: Readonly<MemoryStatus>): MemoryStatus;
        }
        export class DynamicStencilStates {
            writeMask: number;
            compareMask: number;
            reference: number;
            constructor(writeMask?: number, compareMask?: number, reference?: number);
            copy(info: Readonly<DynamicStencilStates>): DynamicStencilStates;
        }
        export class DynamicStates {
            viewport: Viewport;
            scissor: Rect;
            blendConstant: Color;
            lineWidth: number;
            depthBiasConstant: number;
            depthBiasClamp: number;
            depthBiasSlope: number;
            depthMinBounds: number;
            depthMaxBounds: number;
            stencilStatesFront: DynamicStencilStates;
            stencilStatesBack: DynamicStencilStates;
            constructor(viewport?: Viewport, scissor?: Rect, blendConstant?: Color, lineWidth?: number, depthBiasConstant?: number, depthBiasClamp?: number, depthBiasSlope?: number, depthMinBounds?: number, depthMaxBounds?: number, stencilStatesFront?: DynamicStencilStates, stencilStatesBack?: DynamicStencilStates);
            copy(info: Readonly<DynamicStates>): DynamicStates;
        }
        /**
         * ========================= !DO NOT CHANGE THE ABOVE SECTION MANUALLY! =========================
         * The above section is auto-generated from native/cocos/renderer/core/gfx/GFXDef-common.h
         * by the script native/tools/gfx-define-generator/generate.js.
         * Changes to these public interfaces should be made there first and synced back.
         * ========================= !DO NOT CHANGE THE ABOVE SECTION MANUALLY! =========================
         */
        /**
         * @en GFX base object.
         * @zh GFX 
         */
        export class GFXObject extends __private._cocos_core_data_gc_object__GCObject {
            get objectType(): ObjectType;
            get objectID(): number;
            get typedID(): number;
            protected _objectType: ObjectType;
            protected _objectID: number;
            protected _typedID: number;
            constructor(objectType: ObjectType);
        }
        export interface ISwapchainTextureInfo {
            swapchain: Swapchain;
            format: Format;
            width: number;
            height: number;
        }
        export enum AttributeName {
            ATTR_POSITION = "a_position",
            ATTR_NORMAL = "a_normal",
            ATTR_TANGENT = "a_tangent",
            ATTR_BITANGENT = "a_bitangent",
            ATTR_WEIGHTS = "a_weights",
            ATTR_JOINTS = "a_joints",
            ATTR_COLOR = "a_color",
            ATTR_COLOR1 = "a_color1",
            ATTR_COLOR2 = "a_color2",
            ATTR_TEX_COORD = "a_texCoord",
            ATTR_TEX_COORD1 = "a_texCoord1",
            ATTR_TEX_COORD2 = "a_texCoord2",
            ATTR_TEX_COORD3 = "a_texCoord3",
            ATTR_TEX_COORD4 = "a_texCoord4",
            ATTR_TEX_COORD5 = "a_texCoord5",
            ATTR_TEX_COORD6 = "a_texCoord6",
            ATTR_TEX_COORD7 = "a_texCoord7",
            ATTR_TEX_COORD8 = "a_texCoord8",
            ATTR_BATCH_ID = "a_batch_id",
            ATTR_BATCH_UV = "a_batch_uv"
        }
        export const FormatInfos: readonly FormatInfo[];
        export const DESCRIPTOR_BUFFER_TYPE: number;
        export const DESCRIPTOR_SAMPLER_TYPE: number;
        export const DESCRIPTOR_DYNAMIC_TYPE: number;
        export const DRAW_INFO_SIZE = 28;
        export type BufferSource = ArrayBuffer | IndirectBuffer;
        export interface FormatAlignment {
            width: number;
            height: number;
        }
        /**
         * @en GFX Device.
         * @zh GFX 豸
         */
        export abstract class Device {
            /**
             * @en Current rendering API.
             * @zh ǰ GFX ʹõȾ API
             */
            get gfxAPI(): API;
            /**
             * @en GFX default queue.
             * @zh GFX Ĭ϶С
             */
            get queue(): Queue;
            /**
             * @en GFX default command buffer.
             * @zh GFX Ĭ塣
             */
            get commandBuffer(): CommandBuffer;
            /**
             * @en Renderer description.
             * @zh Ⱦ
             */
            get renderer(): string;
            /**
             * @en Vendor description.
             * @zh 
             */
            get vendor(): string;
            /**
             * @en Number of draw calls currently recorded.
             * @zh Ƶô
             */
            get numDrawCalls(): number;
            /**
             * @en Number of instances currently recorded.
             * @zh  Instance 
             */
            get numInstances(): number;
            /**
             * @en Number of triangles currently recorded.
             * @zh Ⱦ
             */
            get numTris(): number;
            /**
             * @en Total memory size currently allocated.
             * @zh ڴ״̬
             */
            get memoryStatus(): MemoryStatus;
            /**
             * @en Current device capabilities.
             * @zh ǰ豸ݡ
             */
            get capabilities(): DeviceCaps;
            /**
             * @en Current device binding mappings.
             * @zh ǰ豸İ󶨲λӳϵ
             */
            get bindingMappingInfo(): BindingMappingInfo;
            protected _gfxAPI: API;
            protected _renderer: string;
            protected _vendor: string;
            protected _features: boolean[];
            protected _formatFeatures: FormatFeatureBit[];
            protected _queue: Queue | null;
            protected _cmdBuff: CommandBuffer | null;
            protected _numDrawCalls: number;
            protected _numInstances: number;
            protected _numTris: number;
            protected _memoryStatus: MemoryStatus;
            protected _caps: DeviceCaps;
            protected _bindingMappingInfo: BindingMappingInfo;
            protected _samplers: Map<number, Sampler>;
            protected _generalBarrierss: Map<number, GeneralBarrier>;
            protected _textureBarriers: Map<number, TextureBarrier>;
            protected _bufferBarriers: Map<number, __private._cocos_gfx_base_states_buffer_barrier__BufferBarrier>;
            static canvas: HTMLCanvasElement;
            abstract initialize(info: Readonly<DeviceInfo>): boolean;
            abstract destroy(): void;
            /**
             * @en Acquire next swapchain image.
             * @zh ȡһ塣
             */
            abstract acquire(swapchains: Readonly<Swapchain[]>): void;
            /**
             * @en Present current swapchain image.
             * @zh ǰ塣
             */
            abstract present(): void;
            /**
             * @en Flush the specified command buffers.
             * @zh ʵ¼ָ塣
             */
            abstract flushCommands(cmdBuffs: Readonly<CommandBuffer[]>): void;
            /**
             * @en Create command buffer.
             * @zh 塣
             * @param info GFX command buffer description info.
             */
            abstract createCommandBuffer(info: Readonly<CommandBufferInfo>): CommandBuffer;
            /**
             * @en Create swapchain.
             * @zh 
             * @param info GFX swapchain description info.
             */
            abstract createSwapchain(info: Readonly<SwapchainInfo>): Swapchain;
            /**
             * @en Create buffer.
             * @zh 塣
             * @param info GFX buffer description info.
             */
            abstract createBuffer(info: Readonly<BufferInfo> | BufferViewInfo): Buffer;
            /**
             * @en Create texture.
             * @zh 
             * @param info GFX texture description info.
             */
            abstract createTexture(info: Readonly<TextureInfo> | TextureViewInfo): Texture;
            /**
             * @en Create descriptor sets.
             * @zh 顣
             * @param info GFX descriptor sets description info.
             */
            abstract createDescriptorSet(info: Readonly<DescriptorSetInfo>): DescriptorSet;
            /**
             * @en Create shader.
             * @zh ɫ
             * @param info GFX shader description info.
             */
            abstract createShader(info: Readonly<ShaderInfo>): Shader;
            /**
             * @en Create input assembler.
             * @zh 
             * @param info GFX input assembler description info.
             */
            abstract createInputAssembler(info: Readonly<InputAssemblerInfo>): InputAssembler;
            /**
             * @en Create render pass.
             * @zh Ⱦ̡
             * @param info GFX render pass description info.
             */
            abstract createRenderPass(info: Readonly<RenderPassInfo>): RenderPass;
            /**
             * @en Create frame buffer.
             * @zh ֡塣
             * @param info GFX frame buffer description info.
             */
            abstract createFramebuffer(info: Readonly<FramebufferInfo>): Framebuffer;
            /**
             * @en Create descriptor set layout.
             * @zh ֡
             * @param info GFX descriptor set layout description info.
             */
            abstract createDescriptorSetLayout(info: Readonly<DescriptorSetLayoutInfo>): DescriptorSetLayout;
            /**
             * @en Create pipeline layout.
             * @zh ߲֡
             * @param info GFX pipeline layout description info.
             */
            abstract createPipelineLayout(info: Readonly<PipelineLayoutInfo>): PipelineLayout;
            /**
             * @en Create pipeline state.
             * @zh ״̬
             * @param info GFX pipeline state description info.
             */
            abstract createPipelineState(info: Readonly<PipelineStateInfo>): PipelineState;
            /**
             * @en Create queue.
             * @zh С
             * @param info GFX queue description info.
             */
            abstract createQueue(info: Readonly<QueueInfo>): Queue;
            /**
             * @en Create sampler.
             * @zh 
             * @param info GFX sampler description info.
             */
            abstract getSampler(info: Readonly<SamplerInfo>): Sampler;
            /**
             * @en Get swapchains.
             * @zh ȡб
             */
            abstract getSwapchains(): Readonly<Swapchain[]>;
            /**
             * @en Create global barrier.
             * @zh ȫڴϡ
             * @param info GFX global barrier description info.
             */
            abstract getGeneralBarrier(info: Readonly<GeneralBarrierInfo>): GeneralBarrier;
            /**
             * @en Create texture barrier.
             * @zh ͼڴϡ
             * @param info GFX texture barrier description info.
             */
            abstract getTextureBarrier(info: Readonly<TextureBarrierInfo>): TextureBarrier;
            /**
             * @en Create buffer barrier.
             * @zh bufferڴϡ
             * @param info GFX buffer barrier description info.
             */
            abstract getBufferBarrier(info: Readonly<BufferBarrierInfo>): __private._cocos_gfx_base_states_buffer_barrier__BufferBarrier;
            /**
             * @en Copy buffers to texture.
             * @zh 嵽
             * @param buffers The buffers to be copied.
             * @param texture The texture to copy to.
             * @param regions The region descriptions.
             */
            abstract copyBuffersToTexture(buffers: Readonly<ArrayBufferView[]>, texture: Texture, regions: Readonly<BufferTextureCopy[]>): void;
            /**
             * @en Copy texture to buffers
             * @zh 
             * @param texture The texture to be copied.
             * @param buffers The buffer to copy to.
             * @param regions The region descriptions
             */
            abstract copyTextureToBuffers(texture: Readonly<Texture>, buffers: ArrayBufferView[], regions: Readonly<BufferTextureCopy[]>): void;
            /**
             * @en Copy texture images to texture.
             * @zh ͼ
             * @param texImages The texture to be copied.
             * @param texture The texture to copy to.
             * @param regions The region descriptions.
             */
            abstract copyTexImagesToTexture(texImages: Readonly<TexImageSource[]>, texture: Texture, regions: Readonly<BufferTextureCopy[]>): void;
            /**
             * @en Whether the device has specific feature.
             * @zh Ƿ߱ԡ
             * @param feature The GFX feature to be queried.
             */
            hasFeature(feature: Feature): boolean;
            /**
             * @en The extent a specific format is supported by the backend.
             * @zh ˶ضʽ̶ֳ֧ȡ
             * @param format The GFX format to be queried.
             */
            getFormatFeatures(format: Format): FormatFeature;
            /**
             * @en Enable automatically barrier deduction GFX inside, no effect on web.
             * @zh ǷԶGFXڲbarrierƵwebӰ졣
             * @param format The GFX format to be queried.
             */
            enableAutoBarrier(en: boolean): void;
            /**
             * @en Get maximum supported sample count.
             * @zh ȡֵ֧ Samples 
             * @param format The GFX texture format.
             * @param usage The GFX texture usage.
             * @param flags The GFX texture create flags.
             */
            getMaxSampleCount(format: Format, usage: TextureUsage, flags: TextureFlags): SampleCount;
        }
        export class DefaultResource {
            constructor(device: Device);
            getTexture(type: TextureType): Texture | null;
        }
        /**
         * @en GFX Swapchain.
         * @zh GFX 
         */
        export abstract class Swapchain extends GFXObject {
            /**
             * @en The color texture of this swapchain.
             * @zh ǰɫ塣
             */
            get colorTexture(): Texture;
            /**
             * @en The depth stencil texture of this swapchain.
             * @zh ǰģ建塣
             */
            get depthStencilTexture(): Texture;
            /**
             * @en The surface transform to be applied in projection matrices.
             * @zh ҪͶӰӦõı任
             */
            get surfaceTransform(): SurfaceTransform;
            get width(): number;
            get height(): number;
            protected _transform: SurfaceTransform;
            protected _colorTexture: Texture;
            protected _depthStencilTexture: Texture;
            constructor();
            abstract initialize(info: Readonly<SwapchainInfo>): void;
            abstract resize(width: number, height: number, surfaceTransform: SurfaceTransform): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX frame buffer.
         * @zh GFX ֡塣
         */
        export abstract class Framebuffer extends GFXObject {
            /**
             * @en Get current render pass.
             * @zh GFX Ⱦ̡
             */
            get renderPass(): RenderPass;
            /**
             * @en Get current color views.
             * @zh ɫͼ顣
             */
            get colorTextures(): (Texture | null)[];
            /**
             * @en Get current depth stencil views.
             * @zh ģͼ
             */
            get depthStencilTexture(): Texture | null;
            get width(): number;
            get height(): number;
            protected _renderPass: RenderPass | null;
            protected _colorTextures: (Texture | null)[];
            protected _depthStencilTexture: Texture | null;
            protected _width: number;
            protected _height: number;
            constructor();
            abstract initialize(info: Readonly<FramebufferInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX input assembler.
         * @zh GFX 㼯
         */
        export abstract class InputAssembler extends GFXObject {
            /**
             * @en Get current attributes.
             * @zh 顣
             */
            get attributes(): Attribute[];
            /**
             * @en Get current vertex buffers.
             * @zh 㻺顣
             */
            get vertexBuffers(): Buffer[];
            /**
             * @en Get current index buffer.
             * @zh 塣
             */
            get indexBuffer(): Buffer | null;
            /**
             * @en Get the indirect buffer, if present.
             * @zh ӻƻ塣
             */
            get indirectBuffer(): Buffer | null;
            /**
             * @en Get hash of current attributes.
             * @zh ȡĹϣֵ
             */
            get attributesHash(): number;
            /**
             * @en Get current vertex count.
             * @zh 
             */
            set vertexCount(count: number);
            get vertexCount(): number;
            /**
             * @en Get starting vertex.
             * @zh ʼ㡣
             */
            set firstVertex(first: number);
            get firstVertex(): number;
            /**
             * @en Get current index count.
             * @zh 
             */
            set indexCount(count: number);
            get indexCount(): number;
            /**
             * @en Get starting index.
             * @zh ʼ
             */
            set firstIndex(first: number);
            get firstIndex(): number;
            /**
             * @en Get current vertex offset.
             * @zh ƫ
             */
            set vertexOffset(offset: number);
            get vertexOffset(): number;
            /**
             * @en Get current instance count.
             * @zh ʵ
             */
            set instanceCount(count: number);
            get instanceCount(): number;
            /**
             * @en Get starting instance.
             * @zh ʼʵ
             */
            set firstInstance(first: number);
            get firstInstance(): number;
            /**
             * @en set the draw range
             * @zh ȾΧ
             */
            set drawInfo(info: DrawInfo);
            /**
             * @en get the draw range
             * @zh ȡȾΧ
             */
            get drawInfo(): DrawInfo;
            protected _attributes: Attribute[];
            protected _attributesHash: number;
            protected _vertexBuffers: Buffer[];
            protected _indexBuffer: Buffer | null;
            protected _indirectBuffer: Buffer | null;
            protected _drawInfo: DrawInfo;
            constructor();
            /**
             * @en Get the specified vertex buffer.
             * @zh ȡ㻺塣
             * @param stream The stream index of the vertex buffer.
             */
            getVertexBuffer(stream?: number): Buffer | null;
            protected computeAttributesHash(): number;
            abstract initialize(info: Readonly<InputAssemblerInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX descriptor sets layout.
         * @zh GFX ֡
         */
        export abstract class DescriptorSetLayout extends GFXObject {
            get bindings(): DescriptorSetLayoutBinding[];
            get bindingIndices(): number[];
            get descriptorIndices(): number[];
            protected _bindings: DescriptorSetLayoutBinding[];
            protected _bindingIndices: number[];
            protected _descriptorIndices: number[];
            constructor();
            abstract initialize(info: Readonly<DescriptorSetLayoutInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX pipeline layout.
         * @zh GFX ߲֡
         */
        export abstract class PipelineLayout extends GFXObject {
            get setLayouts(): DescriptorSetLayout[];
            protected _setLayouts: DescriptorSetLayout[];
            constructor();
            abstract initialize(info: Readonly<PipelineLayoutInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX blend state.
         * @zh GFX ״̬
         */
        export class BlendState {
            isA2C: boolean;
            isIndepend: boolean;
            blendColor: Color;
            targets: BlendTarget[];
            get native(): BlendState;
            constructor(isA2C?: boolean, isIndepend?: boolean, blendColor?: Color, targets?: BlendTarget[]);
            /**
             * @en Should use this function to set target, or it will not work
             * on native platforms, as native can not support this feature,
             * such as `blendState[i] = target;`.
             *
             * @param index The index to set target.
             * @param target The target to be set.
             */
            setTarget(index: number, target: BlendTarget): void;
            reset(): void;
            destroy(): void;
        }
        /**
         * @en GFX blend target.
         * @zh GFX Ŀꡣ
         */
        export class BlendTarget {
            blend: boolean;
            blendSrc: BlendFactor;
            blendDst: BlendFactor;
            blendEq: BlendOp;
            blendSrcAlpha: BlendFactor;
            blendDstAlpha: BlendFactor;
            blendAlphaEq: BlendOp;
            blendColorMask: ColorMask;
            constructor(blend?: boolean, blendSrc?: BlendFactor, blendDst?: BlendFactor, blendEq?: BlendOp, blendSrcAlpha?: BlendFactor, blendDstAlpha?: BlendFactor, blendAlphaEq?: BlendOp, blendColorMask?: ColorMask);
            reset(): void;
            assign(target: BlendTarget): void;
            destroy(): void;
        }
        /**
         * @en GFX rasterizer state.
         * @zh GFX դ״̬
         */
        export class RasterizerState {
            isDiscard: boolean;
            polygonMode: PolygonMode;
            shadeModel: ShadeModel;
            cullMode: CullMode;
            isFrontFaceCCW: boolean;
            depthBiasEnabled: boolean;
            depthBias: number;
            depthBiasClamp: number;
            depthBiasSlop: number;
            isDepthClip: boolean;
            isMultisample: boolean;
            lineWidth: number;
            get native(): RasterizerState;
            constructor(isDiscard?: boolean, polygonMode?: PolygonMode, shadeModel?: ShadeModel, cullMode?: CullMode, isFrontFaceCCW?: boolean, depthBiasEnabled?: boolean, depthBias?: number, depthBiasClamp?: number, depthBiasSlop?: number, isDepthClip?: boolean, isMultisample?: boolean, lineWidth?: number);
            reset(): void;
            assign(rs: RasterizerState): void;
            destroy(): void;
        }
        /**
         * @en GFX depth stencil state.
         * @zh GFX ģ״̬
         */
        export class DepthStencilState {
            depthTest: boolean;
            depthWrite: boolean;
            depthFunc: ComparisonFunc;
            stencilTestFront: boolean;
            stencilFuncFront: ComparisonFunc;
            stencilReadMaskFront: number;
            stencilWriteMaskFront: number;
            stencilFailOpFront: StencilOp;
            stencilZFailOpFront: StencilOp;
            stencilPassOpFront: StencilOp;
            stencilRefFront: number;
            stencilTestBack: boolean;
            stencilFuncBack: ComparisonFunc;
            stencilReadMaskBack: number;
            stencilWriteMaskBack: number;
            stencilFailOpBack: StencilOp;
            stencilZFailOpBack: StencilOp;
            stencilPassOpBack: StencilOp;
            stencilRefBack: number;
            get native(): DepthStencilState;
            constructor(depthTest?: boolean, depthWrite?: boolean, depthFunc?: ComparisonFunc, stencilTestFront?: boolean, stencilFuncFront?: ComparisonFunc, stencilReadMaskFront?: number, stencilWriteMaskFront?: number, stencilFailOpFront?: StencilOp, stencilZFailOpFront?: StencilOp, stencilPassOpFront?: StencilOp, stencilRefFront?: number, stencilTestBack?: boolean, stencilFuncBack?: ComparisonFunc, stencilReadMaskBack?: number, stencilWriteMaskBack?: number, stencilFailOpBack?: StencilOp, stencilZFailOpBack?: StencilOp, stencilPassOpBack?: StencilOp, stencilRefBack?: number);
            reset(): void;
            assign(dss: DepthStencilState): void;
            destroy(): void;
        }
        export class PipelineStateInfo {
            shader: Shader;
            pipelineLayout: PipelineLayout;
            renderPass: RenderPass;
            inputState: InputState;
            rasterizerState: RasterizerState;
            depthStencilState: DepthStencilState;
            blendState: BlendState;
            primitive: PrimitiveMode;
            dynamicStates: DynamicStateFlags;
            bindPoint: PipelineBindPoint;
            constructor(shader?: Shader, pipelineLayout?: PipelineLayout, renderPass?: RenderPass, inputState?: InputState, rasterizerState?: RasterizerState, depthStencilState?: DepthStencilState, blendState?: BlendState, primitive?: PrimitiveMode, dynamicStates?: DynamicStateFlags, bindPoint?: PipelineBindPoint);
        }
        /**
         * @en GFX pipeline state.
         * @zh GFX ״̬
         */
        export abstract class PipelineState extends GFXObject {
            /**
             * @en Get current shader.
             * @zh GFX ɫ
             */
            get shader(): Shader;
            /**
             * @en Get current pipeline layout.
             * @zh GFX ߲֡
             */
            get pipelineLayout(): PipelineLayout;
            /**
             * @en Get current primitve mode.
             * @zh GFX ͼԪģʽ
             */
            get primitive(): PrimitiveMode;
            /**
             * @en Get current rasterizer state.
             * @zh GFX դ״̬
             */
            get rasterizerState(): RasterizerState;
            /**
             * @en Get current depth stencil state.
             * @zh GFX ģ״̬
             */
            get depthStencilState(): DepthStencilState;
            /**
             * @en Get current blend state.
             * @zh GFX ״̬
             */
            get blendState(): BlendState;
            /**
             * @en Get current input state.
             * @zh GFX ״̬
             */
            get inputState(): InputState;
            /**
             * @en Get current dynamic states.
             * @zh GFX ̬״̬顣
             */
            get dynamicStates(): DynamicStateFlags;
            /**
             * @en Get current render pass.
             * @zh GFX Ⱦ̡
             */
            get renderPass(): RenderPass;
            protected _shader: Shader | null;
            protected _pipelineLayout: PipelineLayout | null;
            protected _primitive: PrimitiveMode;
            protected _is: InputState | null;
            protected _rs: RasterizerState;
            protected _dss: DepthStencilState;
            protected _bs: BlendState;
            protected _dynamicStates: DynamicStateFlags;
            protected _renderPass: RenderPass | null;
            constructor();
            abstract initialize(info: Readonly<PipelineStateInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX Queue.
         * @zh GFX С
         */
        export abstract class Queue extends GFXObject {
            /**
             * @en Get current type.
             * @zh ͡
             */
            get type(): number;
            protected _type: QueueType;
            constructor();
            abstract initialize(info: Readonly<QueueInfo>): void;
            abstract destroy(): void;
            /**
             * @en Submit command buffers.
             * @zh ύ顣
             * @param cmdBuffs The command buffers to be submitted.
             * @param fence The syncing fence.
             */
            abstract submit(cmdBuffs: Readonly<CommandBuffer[]>): void;
        }
        /**
         * @en GFX render pass.
         * @zh GFX Ⱦ̡
         */
        export abstract class RenderPass extends GFXObject {
            protected _colorInfos: ColorAttachment[];
            protected _depthStencilInfo: DepthStencilAttachment | null;
            protected _subpasses: SubpassInfo[];
            protected _hash: number;
            get colorAttachments(): Readonly<ColorAttachment[]>;
            get depthStencilAttachment(): Readonly<DepthStencilAttachment> | null;
            get subPasses(): Readonly<SubpassInfo[]>;
            get hash(): number;
            constructor();
            protected computeHash(): number;
            abstract initialize(info: Readonly<RenderPassInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX shader.
         * @zh GFX ɫ
         */
        export abstract class Shader extends GFXObject {
            get name(): string;
            get attributes(): Attribute[];
            get blocks(): UniformBlock[];
            get samplers(): UniformSampler[];
            get stages(): ShaderStage[];
            protected _name: string;
            protected _stages: ShaderStage[];
            protected _attributes: Attribute[];
            protected _blocks: UniformBlock[];
            protected _samplers: UniformSampler[];
            constructor();
            abstract initialize(info: Readonly<ShaderInfo>): void;
            abstract destroy(): void;
        }
        /**
         * @en GFX texture.
         * @zh GFX 
         */
        export abstract class Texture extends GFXObject {
            /**
             * @en Get texture type.
             * @zh ͡
             */
            get type(): TextureType;
            /**
             * @en Get texture usage.
             * @zh ʹ÷ʽ
             */
            get usage(): TextureUsage;
            /**
             * @en Get texture format.
             * @zh ʽ
             */
            get format(): Format;
            /**
             * @en Get texture width.
             * @zh ȡ
             */
            get width(): number;
            /**
             * @en Get texture height.
             * @zh ߶ȡ
             */
            get height(): number;
            /**
             * @en Get texture depth.
             * @zh ȡ
             */
            get depth(): number;
            /**
             * @en Get texture array layer.
             * @zh 
             */
            get layerCount(): number;
            /**
             * @en Get texture mip level.
             * @zh  mip 㼶
             */
            get levelCount(): number;
            /**
             * @en Get texture samples.
             * @zh 
             */
            get samples(): SampleCount;
            /**
             * @en Get texture flags.
             * @zh ʶλ
             */
            get flags(): TextureFlags;
            /**
             * @en Get texture size.
             * @zh С
             */
            get size(): number;
            /**
             * @en Get texture info.
             * @zh Ϣ
             */
            get info(): Readonly<TextureInfo>;
            /**
             * @en Get view info.
             * @zh ͼϢ
             */
            get viewInfo(): Readonly<TextureViewInfo>;
            /**
             * @en Get texture type.
             * @zh ǷΪͼ
             */
            get isTextureView(): boolean;
            protected _info: TextureInfo;
            protected _viewInfo: TextureViewInfo;
            protected _isPowerOf2: boolean;
            protected _isTextureView: boolean;
            protected _size: number;
            constructor();
            abstract initialize(info: Readonly<TextureInfo> | Readonly<TextureViewInfo>): void;
            abstract destroy(): void;
            abstract getGLTextureHandle(): number;
            /**
             * @en Resize texture.
             * @zh С
             * @param width The new width.
             * @param height The new height.
             */
            abstract resize(width: number, height: number): void;
            static getLevelCount(width: number, height: number): number;
        }
        /**
         * @en GFX global barrier.
         * @zh GFX ȫڴϡ
         */
        export class GeneralBarrier extends GFXObject {
            get info(): Readonly<GeneralBarrierInfo>;
            get hash(): number;
            protected _info: GeneralBarrierInfo;
            protected _hash: number;
            constructor(info: Readonly<GeneralBarrierInfo>, hash: number);
            static computeHash(info: Readonly<GeneralBarrierInfo>): number;
        }
        /**
         * @en GFX texture barrier.
         * @zh GFX ͼڴϡ
         */
        export class TextureBarrier extends GFXObject {
            get info(): Readonly<TextureBarrierInfo>;
            get hash(): number;
            protected _info: TextureBarrierInfo;
            protected _hash: number;
            constructor(info: Readonly<TextureBarrierInfo>, hash: number);
            static computeHash(info: Readonly<TextureBarrierInfo>): number;
        }
        /**
         * @en
         * Sets the renderer type, only useful on web
         *
         * @zh
         * Ⱦģʽ
         * Ⱦͣ web 
         * @internal
         */
        export enum LegacyRenderMode {
            /**
             * @en
             * Automatically chosen by engine.
             * @zh
             * ͨԶѡ
             */
            AUTO = 0,
            /**
             * @en
             * Forced to use canvas renderer.
             * @zh
             * ǿʹ canvas Ⱦ
             */
            CANVAS = 1,
            /**
             * @en
             * Forced to use WebGL renderer, but this will be ignored on mobile browsers.
             * @zh
             * ǿʹ WebGL Ⱦڲ Android ѡᱻԡ
             */
            WEBGL = 2,
            /**
             * @en
             * Use Headless Renderer, which is useful in test or server env, only for internal use by cocos team for now
             * @zh
             * ʹÿȾڲԺͷ˻Ŀǰʱ Cocos ڲʹá
             */
            HEADLESS = 3
        }
        /**
         * @internal
         */
        export enum RenderType {
            UNKNOWN = "Bad expression <-1>",
            CANVAS = 0,
            WEBGL = 1,
            OPENGL = 2,
            HEADLESS = 3
        }
        /**
         * @internal
         */
        export class DeviceManager {
            get gfxDevice(): Device;
            get swapchain(): Swapchain;
            init(canvas: HTMLCanvasElement | null, bindingMappingInfo: BindingMappingInfo): void;
        }
        /**
         * @internal
         */
        export const deviceManager: DeviceManager;
    }
    export namespace renderer {
        export function createIA(device: gfx.Device, data: primitives.IGeometry): gfx.InputAssembler | null;
        export const addStage: (name: any) => void;
        export interface IProgramInfo extends EffectAsset.IShaderInfo {
            effectName: string;
            defines: __private._cocos_render_scene_core_program_lib__IDefineRecord[];
            constantMacros: string;
            uber: boolean;
        }
        export interface ITemplateInfo {
            gfxAttributes: gfx.Attribute[];
            shaderInfo: gfx.ShaderInfo;
            blockSizes: number[];
            setLayouts: gfx.DescriptorSetLayout[];
            pipelineLayout: gfx.PipelineLayout;
            handleMap: Record<string, number>;
            bindings: gfx.DescriptorSetLayoutBinding[];
            samplerStartBinding: number;
        }
        export const programLib: __private._cocos_render_scene_core_program_lib__ProgramLib;
        export function getDeviceShaderVersion(device: gfx.Device): string;
        export namespace scene {
            /**
             * @en The enumeration type for the fixed axis of the camera.
             * The field of view along the corresponding axis would be fixed regardless of screen aspect changes.
             * @zh ӽǵö٣ڶӦϲĻ仯
             */
            export enum CameraFOVAxis {
                /**
                 * @en Vertically fixed camera
                 * @zh ڴֱ
                 */
                VERTICAL = 0,
                /**
                 * @en Horizontally fixed camera
                 * @zh ˮƽ
                 */
                HORIZONTAL = 1
            }
            /**
             * @en The projection type enumeration of the camera.
             * @zh ͶӰö١
             */
            export enum CameraProjection {
                /**
                 * @en Orthogonal projection type
                 * @zh ͶӰ
                 */
                ORTHO = 0,
                /**
                 * @en Perspective projection type
                 * @zh ͸ͶӰ
                 */
                PERSPECTIVE = 1
            }
            /**
             * @en The aperture enumeration of the camera, represent in f-number.
             * The smaller the value is, the bigger the aperture is, and more light it can capture, but less depth it supports.
             * @zh Ŀö٣ʹ f ֵʾf ֵԽСȦԽ󣬽ҲԽ󣬾Խǳ
             */
            export enum CameraAperture {
                /**
                 * f/1.8
                 */
                F1_8 = 0,
                /**
                 * f/2.0
                 */
                F2_0 = 1,
                /**
                 * f/2.2
                 */
                F2_2 = 2,
                /**
                 * f/2.5
                 */
                F2_5 = 3,
                /**
                 * f/2.8
                 */
                F2_8 = 4,
                /**
                 * f/3.2
                 */
                F3_2 = 5,
                /**
                 * f/3.5
                 */
                F3_5 = 6,
                /**
                 * f/4.0
                 */
                F4_0 = 7,
                /**
                 * f/4.5
                 */
                F4_5 = 8,
                /**
                 * f/5.0
                 */
                F5_0 = 9,
                /**
                 * f/5.6
                 */
                F5_6 = 10,
                /**
                 * f/6.3
                 */
                F6_3 = 11,
                /**
                 * f/7.1
                 */
                F7_1 = 12,
                /**
                 * f/8
                 */
                F8_0 = 13,
                /**
                 * f/9
                 */
                F9_0 = 14,
                /**
                 * f/10
                 */
                F10_0 = 15,
                /**
                 * f/11
                 */
                F11_0 = 16,
                /**
                 * f/13
                 */
                F13_0 = 17,
                /**
                 * f/14
                 */
                F14_0 = 18,
                /**
                 * f/16
                 */
                F16_0 = 19,
                /**
                 * f/18
                 */
                F18_0 = 20,
                /**
                 * f/20
                 */
                F20_0 = 21,
                /**
                 * f/22
                 */
                F22_0 = 22
            }
            /**
             * @en The ISO enumeration of the camera, lower ISO means the camera is less sensitive to light.
             * @zh йö٣Խ͵ ISO ֵʾԹӲС
             */
            export enum CameraISO {
                ISO100 = 0,
                ISO200 = 1,
                ISO400 = 2,
                ISO800 = 3
            }
            /**
             * @en Camera shutter enumeration, the value represents the speed of the shutter.
             * @zh ö٣öֵʾٶȡ
             */
            export enum CameraShutter {
                /**
                 * 1 second
                 */
                D1 = 0,
                /**
                 * 1/2 second
                 */
                D2 = 1,
                /**
                 * 1/4 second
                 */
                D4 = 2,
                /**
                 * 1/8 second
                 */
                D8 = 3,
                /**
                 * 1/15 second
                 */
                D15 = 4,
                /**
                 * 1/30 second
                 */
                D30 = 5,
                /**
                 * 1/60 second
                 */
                D60 = 6,
                /**
                 * 1/125 second
                 */
                D125 = 7,
                /**
                 * 1/250 second
                 */
                D250 = 8,
                /**
                 * 1/500 second
                 */
                D500 = 9,
                /**
                 * 1/1000 second
                 */
                D1000 = 10,
                /**
                 * 1/2000 second
                 */
                D2000 = 11,
                /**
                 * 1/4000 second
                 */
                D4000 = 12
            }
            /**
             * @en The type of the camera, mainly for marking different camera usage in XR, it determines the camera's viewport and parameters.
             * @zh ͣҪڱ XR еĲͬ;ӰȾӿںͶӦĲ
             */
            export enum CameraType {
                /**
                 * @en Default camera type
                 * @zh Ĭ
                 */
                DEFAULT = "Bad expression <-1>",
                /**
                 * @en If a camera is set to be left eye, it will be used to render the left eye screen,
                 * otherwise, the left eye screen will be rendered using adjusted parameters based on XR main camera.
                 * @zh ڻĻʱʹã򣬾͸ XR Ĳ۲
                 */
                LEFT_EYE = 0,
                /**
                 * @en If a camera is set to be right eye, it will be used to render the right eye screen,
                 * otherwise, the right eye screen will be rendered using adjusted parameters based on XR main camera.
                 * @zh ڻĻʱʹã򣬾͸ XR Ĳ۲
                 */
                RIGHT_EYE = 1,
                /**
                 * @en The main camera, it could be used to calculate the parameters for both left eye and the right eye cameras.
                 * It could be converted from the default 3d camera.
                 * @zh XR ͨĬתҲֶµ XR ԼԲ
                 */
                MAIN = 2
            }
            /**
             * @en The spatial tracking signal type used by the camera in XR.
             * @zh ʹõ XR ռ䶨λ׷ź͡
             */
            export enum TrackingType {
                /**
                 * @en Camera without signal tracking in XR device.
                 * @zh ׷ XR 豸źŽ׷١
                 */
                NO_TRACKING = 0,
                /**
                 * @en Camera tracking position and rotation signals from XR device.
                 * @zh ׷ XR 豸ƶλúתǶźš
                 */
                POSITION_AND_ROTATION = 1,
                /**
                 * @en Camera only tracking position signals from XR device.
                 * @zh ֻ׷ XR 豸λźš
                 */
                POSITION = 2,
                /**
                 * @en Camera only tracking rotation signals from XR device.
                 * @zh ֻ׷ XR 豸תǶźš
                 */
                ROTATION = 3
            }
            /**
             * @en The usage of the camera, it's an engine internal marker enumeration.
             * @zh ;ö٣ڲʹõıö١
             */
            export enum CameraUsage {
                /**
                 * @en Camera used in editor
                 * @zh ༭ʹõ
                 */
                EDITOR = 0,
                /**
                 * @en Camera used in editor's game view.
                 * @zh ༭ GameView ͼʹõ
                 */
                GAME_VIEW = 1,
                /**
                 * @en Camera used in editor's scene view.
                 * @zh ༭༭ͼʹõ
                 */
                SCENE_VIEW = 2,
                /**
                 * @en Camera used in editor's camera preview window.
                 * @zh ༭ԤСͼʹõ
                 */
                PREVIEW = 3,
                /**
                 * @en Camera used in game, normally user created cameras are all GAME type.
                 * @zh Ϸͼʹõһû GAME ͡
                 */
                GAME = 100
            }
            /**
             * @en The camera creation information struct
             * @zh Ľṹ
             */
            export interface ICameraInfo {
                /**
                 * @en The name of the camera.
                 * @zh 
                 */
                name: string;
                /**
                 * @en The node which the camera is attached to.
                 * @zh صĽڵ㡣
                 */
                node: Node;
                /**
                 * @en The projection type of the camera.
                 * @zh ͶӰ͡
                 */
                projection: CameraProjection;
                /**
                 * @en The id of the target display, if absent, it will be rendered on the default one.
                 * @zh ĿĻȱʡʹĬĻ
                 */
                targetDisplay?: number;
                /**
                 * @en The target render window of the camera, is absent, the camera won't be rendered.
                 * @zh ĿȾڣȱʡִȾ̡
                 */
                window?: __private._cocos_render_scene_core_render_window__RenderWindow | null;
                /**
                 * @en Render priority of the camera. Cameras with higher depth are rendered after cameras with lower depth.
                 * @zh ȾȼֵԽСԽȾ
                 */
                priority: number;
                /**
                 * @internal
                 */
                pipeline?: string;
                /**
                 * @en The type of the camera, mainly for marking different camera usage in XR, it determines the camera's viewport and parameters.
                 * @zh ͣҪڱ XR еĲͬ;ӰȾӿںͶӦĲ
                 */
                cameraType?: CameraType;
                /**
                 * @en The spatial tracking signal type used by the camera in XR.
                 * @zh ʹõ XR ռ䶨λ׷ź͡
                 */
                trackingType?: TrackingType;
                /**
                 * @internal
                 */
                usage?: CameraUsage;
            }
            export const SKYBOX_FLAG: number;
            /**
             * @en The render camera representation in the render scene, it's managed by [[Camera]]
             * @zh ȾеĿ [[Camera]] 
             */
            export class Camera {
                /**
                 * @en This exposure value corresponding to default standard camera exposure parameters.
                 * @zh Ĭعֵ
                 */
                static get standardExposureValue(): number;
                /**
                 * @en The luminance unit scale used by area lights.
                 * @zh ĬϾֲԴʹõȵλš
                 */
                static get standardLightMeterScale(): number;
                /**
                 * @en The name of the camera
                 * @zh 
                 */
                get name(): string | null;
                /**
                 * @en The render scene to which the camera is attached
                 * @zh صĳ
                 */
                get scene(): RenderScene | null;
                /**
                 * @en The node of the camera which determines its transform in world space.
                 * @zh 󶨵Ľڵ㣬ռı任
                 */
                set node(val: Node);
                get node(): Node;
                /**
                 * @en The unique ID of system window which the camera will render to.
                 * @zh ȾID
                 */
                get systemWindowId(): number;
                /**
                 * @en The render window of the camera
                 * @zh Ⱦ
                 */
                set window(val: __private._cocos_render_scene_core_render_window__RenderWindow);
                get window(): __private._cocos_render_scene_core_render_window__RenderWindow;
                /**
                 * @en Whether the camera is enabled, a disabled camera won't be processed in the render pipeline.
                 * @zh ǷãδõᱻȾ
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @en Visibility mask of the camera, declaring a set of node layers that will be visible to this camera.
                 * @zh Ŀɼ룬ڵǰпɼĽڵ㼶ϡ
                 */
                set visibility(vis: number);
                get visibility(): number;
                /**
                 * @en Render priority of the camera. Cameras with higher depth are rendered after cameras with lower depth.
                 * @zh ȾȼֵԽСԽȾ
                 */
                get priority(): number;
                set priority(val: number);
                /**
                 * @en The width of the camera's view size
                 * @zh ͼ
                 */
                get width(): number;
                /**
                 * @en The height of the camera's view size
                 * @zh ͼ߶
                 */
                get height(): number;
                /**
                 * @en The world position of the camera
                 * @zh 
                 */
                set position(val: math.Vec3);
                get position(): math.Vec3;
                /**
                 * @en The forward vector of the camera's look direction
                 * @zh ָ۲췽
                 */
                set forward(val: math.Vec3);
                get forward(): math.Vec3;
                /**
                 * @en Camera aperture, controls the exposure parameter.
                 * @zh ȦӰع
                 */
                set aperture(val: CameraAperture);
                get aperture(): CameraAperture;
                /**
                 * @en Camera aperture value.
                 * @zh Ȧֵ
                 */
                get apertureValue(): number;
                /**
                 * @en Camera shutter, controls the exposure parameter.
                 * @zh ţӰع
                 */
                set shutter(val: CameraShutter);
                get shutter(): CameraShutter;
                /**
                 * @en Camera shutter value.
                 * @zh ֵ
                 */
                get shutterValue(): number;
                /**
                 * @en Camera ISO, controls the exposure parameter.
                 * @zh йȣӰع
                 */
                set iso(val: CameraISO);
                get iso(): CameraISO;
                /**
                 * @en Camera ISO value.
                 * @zh йֵ
                 */
                get isoValue(): number;
                /**
                 * @en The calculated exposure of the camera
                 * @zh ع
                 */
                get exposure(): number;
                /**
                 * @en Clearing flags of the camera, specifies which part of the framebuffer will be actually cleared every frame.
                 * @zh Ļ־λָ֡ĲҪÿ֡
                 */
                get clearFlag(): gfx.ClearFlags;
                set clearFlag(flag: gfx.ClearFlags);
                /**
                 * @en Clearing color of the camera.
                 * @zh ɫĬֵ
                 */
                set clearColor(val: math.IVec4Like);
                get clearColor(): math.IVec4Like;
                /**
                 * @en Clearing depth of the camera.
                 * @zh ȻĬֵ
                 */
                get clearDepth(): number;
                set clearDepth(depth: number);
                /**
                 * @en Clearing stencil of the camera.
                 * @zh ģ建Ĭֵ
                 */
                get clearStencil(): number;
                set clearStencil(stencil: number);
                /**
                 * @en The projection type of the camera.
                 * @zh ͶӰ͡
                 */
                set projectionType(val: CameraProjection);
                get projectionType(): CameraProjection;
                /**
                 * @en The aspect ratio of the camera
                 * @zh ͼĳ
                 */
                get aspect(): number;
                /**
                 * @en The viewport height of the orthogonal type camera.
                 * @zh ӽǸ߶ȡ
                 */
                set orthoHeight(val: number);
                get orthoHeight(): number;
                /**
                 * @en The axis on which the FOV would be fixed regardless of screen aspect changes.
                 * @zh ָӽǵĹ̶ڴϲĻ仯
                 */
                set fovAxis(axis: CameraFOVAxis);
                get fovAxis(): CameraFOVAxis;
                /**
                 * @en Field of view of the camera.
                 * @zh ӽǴС
                 */
                set fov(fov: number);
                get fov(): number;
                /**
                 * @en Near clipping distance of the camera, should be as large as possible within acceptable range.
                 * @zh Ľü룬ӦڿɽܷΧھȡ
                 */
                set nearClip(nearClip: number);
                get nearClip(): number;
                /**
                 * @en Far clipping distance of the camera, should be as small as possible within acceptable range.
                 * @zh Զü룬ӦڿɽܷΧھȡС
                 */
                set farClip(farClip: number);
                get farClip(): number;
                /**
                 * @en The viewport rect of the camera, pre-rotated (i.e. always in identity/portrait mode) if possible.
                 * @zh ӿھΣ豸ĻӿڻԶ״̬Ⱦ̱תȷ
                 */
                get viewport(): math.Rect;
                set viewport(val: math.Rect);
                /**
                 * @en The view frustum of the camera
                 * @zh ׶
                 */
                set frustum(val: geometry.Frustum);
                get frustum(): geometry.Frustum;
                /**
                 * @en The view matrix of the camera
                 * @zh ͼ
                 */
                get matView(): math.Mat4;
                /**
                 * @en The projection matrix of the camera
                 * @zh ͶӰ
                 */
                get matProj(): math.Mat4;
                /**
                 * @en The inverse of the projection matrix of the camera
                 * @zh ͶӰ
                 */
                get matProjInv(): math.Mat4;
                /**
                 * @en The view projection matrix of the camera
                 * @zh ͼͶӰ
                 */
                get matViewProj(): math.Mat4;
                /**
                 * @en The inverse of the view projection matrix of the camera
                 * @zh ͼͶӰ
                 */
                get matViewProjInv(): math.Mat4;
                /**
                 * @en Whether the camera is fixed size or matching the window size.
                 * @zh ǹ̶ߴ绹ǸĻߴ
                 */
                isWindowSize: boolean;
                /**
                 * @en Scale of the internal buffer size,
                 * set to 1 to keep the same with the canvas size.
                 * @zh ڲߴֵ, 1 Ϊ canvas ߴͬ
                 */
                screenScale: number;
                postProcess: postProcess.PostProcess | null;
                usePostProcess: boolean;
                pipeline: string;
                constructor(device: gfx.Device);
                /**
                 * @en Initialize the camera, normally you shouldn't invoke this function, it's managed automatically.
                 * @zh ʼͨӦʹʼԶġ
                 */
                initialize(info: ICameraInfo): void;
                /**
                 * @en Destroy the camera, you shouldn't invoke this function, it's managed by the render scene.
                 * @zh ߲Ӧʹ RenderScene ġ
                 */
                destroy(): void;
                /**
                 * @en Attach the camera to the given render scene so that it will be rendered in it.
                 * @zh ӵصȾУԱԱȾȾ
                 * @param scene @en The render scene @zh Ⱦ
                 */
                attachToScene(scene: RenderScene): void;
                /**
                 * @en Detach the camera from previously attached render scene. It will no longer be rendered.
                 * @zh ֮ǰõȾƳ֮󽫲ٱȾ
                 */
                detachFromScene(): void;
                /**
                 * @en Resize the view size of the camera.
                 * @zh ͼߴ
                 * @param width The width of the view size
                 * @param height The height of the view size
                 */
                resize(width: number, height: number): void;
                /**
                 * @en Set a fixed size for the camera view.
                 * @zh ù̶ͼߴ
                 * @param width The width of the view size
                 * @param height The height of the view size
                 */
                setFixedSize(width: number, height: number): void;
                /**
                 * Editor specific gizmo camera logic
                 * @internal
                 */
                syncCameraEditor(camera: any): void;
                /**
                 * @en Update the camera's builtin matrixes
                 * @zh ͼͶӰȾ
                 * @param forceUpdate If force update, then dirty flag will be ignored
                 */
                update(forceUpdate?: boolean): void;
                get surfaceTransform(): gfx.SurfaceTransform;
                /**
                 * @en Set the viewport in oriented space (equal to the actual screen rotation)
                 * @zh Ŀ곯ռ䣨ʵĻӿ
                 */
                setViewportInOrientedSpace(val: math.Rect): void;
                /**
                 * @en create geometry renderer for this camera
                 * @zh ļȾ
                 */
                initGeometryRenderer(): void;
                /**
                 * @en get geometry renderer of this camera
                 * @zh ȡļȾ
                 * @returns @en return the geometry renderer @zh ؼȾ
                 */
                get geometryRenderer(): GeometryRenderer | null;
                get cameraType(): CameraType;
                set cameraType(type: CameraType);
                get trackingType(): TrackingType;
                set trackingType(type: TrackingType);
                get cameraUsage(): CameraUsage;
                set cameraUsage(usage: CameraUsage);
                /**
                 * @en Change the target render window to another one
                 * @zh ޸ĿȾ
                 * @param window The target render window, could be null
                 */
                changeTargetWindow(window?: __private._cocos_render_scene_core_render_window__RenderWindow | null): void;
                /**
                 * @en Detach camera from the render window
                 * @zh  camera ȾƳ
                 */
                detachCamera(): void;
                /**
                 * @en Transform a screen position (in oriented space) to a world space ray
                 * @zh һĻռ䣨ʵʳ£תռ
                 * @param out the resulting ray
                 * @param x the screen x of the position
                 * @param y the screen y of the position
                 * @returns the resulting ray
                 */
                screenPointToRay(out: geometry.Ray, x: number, y: number): geometry.Ray;
                /**
                 * @en Transform a screen position (in oriented space) to world space
                 * @zh һĻռ䣨ʵʳ£λתռ
                 * @param out the resulting vector
                 * @param screenPos the screen position to be transformed
                 * @returns the resulting vector
                 */
                screenToWorld(out: math.Vec3, screenPos: math.Vec3): math.Vec3;
                /**
                 * @en Transform a world space position to screen space rendered by the camera
                 * @zh һռλתȾĻռ
                 * @param out the resulting vector
                 * @param worldPos the world position to be transformed
                 * @returns the resulting vector
                 */
                worldToScreen(out: math.Vec3, worldPos: math.Vec3 | Readonly<math.Vec3>): math.Vec3;
                /**
                 * @en Transform a world space matrix to screen space rendered by the camera
                 * @zh һռתȾĻռ
                 * @param out the resulting matrix
                 * @param worldMatrix the world space matrix to be transformed
                 * @param width framebuffer width
                 * @param height framebuffer height
                 * @returns the resulting matrix
                 */
                worldMatrixToScreen(out: math.Mat4, worldMatrix: math.Mat4, width: number, height: number): math.Mat4;
                /**
                 * @en Calculate and set oblique view frustum projection matrix.
                 * @zh 㲢б׶ͶӰ
                 * @param clipPlane clip plane in camera space
                 */
                calculateObliqueMat(viewSpacePlane: math.Vec4): void;
                getClipSpaceMinz(): number;
                /**
                 * @en Set exposure with actual value.
                 * @zh عֵ
                 * @param ev100
                 */
                protected setExposure(ev100: any): void;
            }
            export enum ModelType {
                DEFAULT = 0,
                SKINNING = 1,
                BAKED_SKINNING = 2,
                BATCH_2D = 3,
                PARTICLE_BATCH = 4,
                LINE = 5
            }
            /**
             * @en A representation of a model instance
             * The base model class, which is the core component of [[MeshRenderer]],
             * adds its own Model to the rendered scene for rendering submissions when [[MeshRenderer]] is enabled.
             * This type of object represents a rendering instance in a scene, and it can contain multiple sub models,
             * each of which corresponds to a material. These sub models share the same location and form a complete object.
             * Each sub model references a sub mesh resource, which provides vertex and index buffers for rendering.
             * @zh һģʵ
             * ģ࣬ [[MeshRenderer]] ĺɲ֣ [[MeshRenderer]] ʱὫԼ Model ӵȾύȾ
             * ͶһеȾʵ԰ģͣÿģͶӦһʡЩģ͹ͬλãһ塣
             * ÿģһԴṩȾõĶ塣
             */
            export class Model {
                /**
                 * @en Sub models of the current model
                 * @zh ȡģ
                 */
                get subModels(): SubModel[];
                /**
                 * @en Whether the model is initialized
                 * @zh Ƿʼ
                 */
                get inited(): boolean;
                /**
                 * @en The axis-aligned bounding box of the model in the world space
                 * @zh ȡռΧ
                 */
                get worldBounds(): geometry.AABB | null;
                /**
                 * @en The axis-aligned bounding box of the model in the model space
                 * @zh ȡģͿռΧ
                 */
                get modelBounds(): geometry.AABB | null;
                /**
                 * @en The ubo buffer of the model
                 * @zh ȡģ͵ ubo 
                 */
                get localBuffer(): gfx.Buffer | null;
                /**
                 * @en The SH ubo buffer of the model
                 * @zh ȡģ͵г ubo 
                 */
                get localSHBuffer(): gfx.Buffer | null;
                /**
                 * @en The world bound ubo buffer
                 * @zh ȡΧ ubo 
                 */
                get worldBoundBuffer(): gfx.Buffer | null;
                /**
                 * @en The time stamp of last update
                 * @zh ȡϴθʱ
                 */
                get updateStamp(): number;
                /**
                 * @en Use LightProbe or not
                 * @zh ̽뿪
                 */
                get useLightProbe(): boolean;
                set useLightProbe(val: boolean);
                /**
                 * @en located tetrahedron index
                 * @zh ģ
                 */
                get tetrahedronIndex(): number;
                set tetrahedronIndex(index: number);
                /**
                 * @en Model level shadow bias
                 * @zh Ӱƫֵ
                 */
                get shadowBias(): number;
                set shadowBias(val: number);
                /**
                 * @en Model level shadow normal bias
                 * @zh Ӱƫֵ
                 */
                get shadowNormalBias(): number;
                set shadowNormalBias(val: number);
                /**
                 * @en Whether the model should receive shadow
                 * @zh ǷӰ
                 */
                get receiveShadow(): boolean;
                set receiveShadow(val: boolean);
                /**
                 * @en Whether the model should cast shadow
                 * @zh ǷͶӰ
                 */
                get castShadow(): boolean;
                set castShadow(val: boolean);
                /**
                 * @en Gets or sets receive direction Light.
                 * @zh ȡýƽйա
                 */
                get receiveDirLight(): boolean;
                set receiveDirLight(val: boolean);
                /**
                 * @en The node to which the model belongs
                 * @zh ģڵĽڵ
                 */
                get node(): Node;
                set node(n: Node);
                /**
                 * @en Model's transform
                 * @zh ģ͵ı任
                 */
                get transform(): Node;
                set transform(n: Node);
                /**
                 * @en Model's visibility tag
                 * Model's visibility flags, it's different from [[Node.layer]],
                 * but it will also be compared with [[Camera.visibility]] during culling process.
                 * @zh ģ͵ĿɼԱ־
                 * ģ͵ĿɼԱ־ [[Node.layer]] ͬ޳׶ [[Camera.visibility]] бȽ
                 */
                get visFlags(): number;
                set visFlags(val: number);
                /**
                 * @en Whether the model is enabled in the render scene so that it will be rendered
                 * @zh ģǷȾòȾ
                 */
                get enabled(): boolean;
                set enabled(val: boolean);
                /**
                 * @en Rendering priority in the transparent queue of model.
                 * @zh Model ͸еȾȼ
                 */
                get priority(): number;
                set priority(val: number);
                /**
                 * @en Whether the model can be render by the reflection probe
                 * @zh ģǷܱ̽Ⱦ
                 */
                get bakeToReflectionProbe(): boolean;
                set bakeToReflectionProbe(val: boolean);
                /**
                 * @en Reflection probe type
                 * @zh ̽͡
                 */
                get reflectionProbeType(): ReflectionProbeType;
                set reflectionProbeType(val: ReflectionProbeType);
                /**
                 * @en sets or gets reflection probe id
                 * @zh ûȡ̽id
                 */
                get reflectionProbeId(): number;
                set reflectionProbeId(val: number);
                /**
                 * @en Sets or gets the reflection probe id for blend.
                 * @zh ûȡڻϵķ̽id
                 */
                get reflectionProbeBlendId(): number;
                set reflectionProbeBlendId(val: number);
                /**
                 * @en Sets or gets the reflection probe blend weight.
                 * @zh ûȡ̽Ȩء
                 */
                get reflectionProbeBlendWeight(): number;
                set reflectionProbeBlendWeight(val: number);
                /**
                 * @en The type of the model
                 * @zh ģ
                 */
                type: ModelType;
                /**
                 * @en The render scene to which the model belongs
                 * @zh ģڵĳ
                 */
                scene: RenderScene | null;
                /**
                 * @en Whether dynamic batching is enabled for model
                 * @zh Ƿ̬
                 */
                isDynamicBatching: boolean;
                /**
                 * @en The world axis-aligned bounding box
                 * @zh ռΧ
                 */
                protected _worldBounds: geometry.AABB | null;
                /**
                 * @en The model axis-aligned bounding box
                 * @zh ģͿռΧ
                 */
                protected _modelBounds: geometry.AABB | null;
                /**
                 * @en Sub models
                 * @zh ģ
                 */
                protected _subModels: SubModel[];
                /**
                 * @en The node to which the model belongs
                 * @zh ģڵĽڵ
                 */
                protected _node: Node;
                /**
                 * @en Model's transform
                 * @zh ģ͵ı任
                 */
                protected _transform: Node;
                /**
                 * @en Current gfx device
                 * @zh ǰ GFX 豸
                 */
                protected _device: gfx.Device;
                /**
                 * @en Whether the model is initialized
                 * @zh Ƿʼ
                 */
                protected _inited: boolean;
                /**
                 * @en Descriptor set count
                 * @zh ϸ
                 */
                protected _descriptorSetCount: number;
                /**
                 * @en Time stamp for last update
                 * @zh ʱ
                 */
                protected _updateStamp: number;
                /**
                 * @en Local ubo data dirty flag
                 * @zh  ubo Ƿ޸Ĺ
                 */
                protected _localDataUpdated: boolean;
                /**
                 * @en Local ubo data
                 * @zh  ubo 
                 */
                protected _localData: Float32Array;
                /**
                 * @en Local ubo buffer
                 * @zh  ubo 
                 */
                protected _localBuffer: gfx.Buffer | null;
                /**
                 * @en Local SH ubo data
                 * @zh г ubo 
                 */
                protected _localSHData: Float32Array | null;
                /**
                 * @en Local SH ubo buffer
                 * @zh г ubo 
                 */
                protected _localSHBuffer: gfx.Buffer | null;
                /**
                 * @en World AABB buffer
                 * @zh ռΧл
                 */
                protected _worldBoundBuffer: gfx.Buffer | null;
                /**
                 * @en Whether the model should receive shadow
                 * @zh ǷӰ
                 */
                protected _receiveShadow: boolean;
                /**
                 * @en Whether the model should cast shadow
                 * @zh ǷͶӰ
                 */
                protected _castShadow: boolean;
                /**
                 * @en Is received direction Light.
                 * @zh Ƿƽйա
                 */
                protected _receiveDirLight: boolean;
                /**
                 * @en Shadow bias
                 * @zh Ӱƫ
                 */
                protected _shadowBias: number;
                /**
                 * @en Shadow normal bias
                 * @zh Ӱƫ
                 */
                protected _shadowNormalBias: number;
                /**
                 * @en Reflect probe Id
                 * @zh ʹõڼ̽
                 */
                protected _reflectionProbeId: number;
                /**
                 * @en Use which probe to blend
                 * @zh ʹõڼ̽л
                 */
                protected _reflectionProbeBlendId: number;
                /**
                 * @en Reflection probe blend weight
                 * @zh ̽Ȩ
                 */
                protected _reflectionProbeBlendWeight: number;
                /**
                 * @en Whether the model is enabled in the render scene so that it will be rendered
                 * @zh ģǷȾòȾ
                 */
                protected _enabled: boolean;
                /**
                 * @en The visibility flags
                 * @zh ɼԱ־λ
                 */
                protected _visFlags: number;
                protected _priority: number;
                /**
                 * @en Whether the model can be render by the reflection probe
                 * @zh ģǷܱ̽Ⱦ
                 */
                protected _bakeToReflectionProbe: boolean;
                /**
                 * @en Reflection probe type.
                 * @zh ̽͡
                 */
                protected _reflectionProbeType: ReflectionProbeType;
                /**
                 * @internal
                 * @en native object
                 * @zh ԭ
                 */
                /**
                 * @internal
                 * @en return native object
                 * @zh ԭ
                 */
                /**
                 * @en Constructor to create an empty model
                 * @zh һģ
                 */
                constructor();
                /**
                 * @en Initialize the model
                 * @zh ʼģ
                 */
                initialize(): void;
                /**
                 * @en Destroy the model
                 * @zh ģ
                 */
                destroy(): void;
                /**
                 * @en Attach the model to a [[renderer.RenderScene]]
                 * @zh ģ͵Ⱦ [[renderer.RenderScene]] 
                 * @param scene destination scene
                 */
                attachToScene(scene: RenderScene): void;
                /**
                 * @en Detach the model from its render scene
                 * @zh Ƴеģ
                 */
                detachFromScene(): void;
                /**
                 * @en Update the model's transform
                 * @zh ģ͵ı任
                 * @param stamp time stamp
                 */
                updateTransform(stamp: number): void;
                /**
                 * @en Update the model's world AABB
                 * @zh ģ͵ռΧ
                 */
                updateWorldBound(): void;
                /**
                 * @en Update the model's ubo
                 * @zh ģ͵ ubo
                 * @param stamp time stamp
                 */
                updateUBOs(stamp: number): void;
                showTetrahedron(): boolean;
                /**
                 * @en Clear the model's SH ubo
                 * @zh ģ͵г ubo
                 */
                clearSHUBOs(): void;
                /**
                 * @en Update the model's SH ubo
                 * @zh ģ͵г ubo
                 */
                updateSHUBOs(): void;
                /**
                 * @en Create the model's AABB
                 * @zh ģ͵İΧ
                 * @param minPos min position of the AABB
                 * @param maxPos max position of the AABB
                 */
                createBoundingShape(minPos?: math.Vec3, maxPos?: math.Vec3): void;
                /**
                 * @en Initialize a sub model with the sub mesh data and the material.
                 * @zh ݺͲʳʼһģ͡
                 * @param idx sub model's index
                 * @param subMeshData sub mesh
                 * @param mat sub material
                 */
                initSubModel(idx: number, subMeshData: RenderingSubMesh, mat: Material): void;
                /**
                 * @en Set material for a given sub model
                 * @zh Ϊָģò
                 * @param idx sub model's index
                 * @param subMesh sub mesh
                 */
                setSubModelMesh(idx: number, subMesh: RenderingSubMesh): void;
                /**
                 * @en Set a sub material
                 * @zh һӲ
                 * @param idx sub model's index
                 * @param mat sub material
                 */
                setSubModelMaterial(idx: number, mat: Material): void;
                /**
                 * @en Pipeline changed callback
                 * @zh ߸»ص
                 */
                onGlobalPipelineStateChanged(): void;
                /**
                 * @en Shader macro changed callback
                 * @zh Shader »ص
                 */
                onMacroPatchesStateChanged(): void;
                onGeometryChanged(): void;
                /**
                 * @internal
                 * If the model has lighting map
                 * initialize lighting map info before model initializing
                 * because the lighting map will influence the shader
                 */
                initLightingmap(texture: Texture2D | null, uvParam: math.Vec4): void;
                /**
                 * @en Update the light map info
                 * @zh ¹ͼϢ
                 * @param texture light map
                 * @param uvParam uv coordinate
                 */
                updateLightingmap(texture: Texture2D | null, uvParam: math.Vec4): void;
                /**
                 * @en Update the cube map of the reflection probe
                 * @zh ·̽ͼ
                 * @param texture probe cubemap
                 */
                updateReflectionProbeCubemap(texture: TextureCube | null): void;
                /**
                 * @en Update the cube map of the reflection probe for blend
                 * @zh blendķ̽ͼ
                 * @param texture probe cubemap
                 */
                updateReflectionProbeBlendCubemap(texture: TextureCube | null): void;
                /**
                 * @en Update the planar relflection map of the reflection probe
                 * @zh ·̽ƽ淴ͼ
                 * @param texture planar relflection map
                 */
                updateReflectionProbePlanarMap(texture: gfx.Texture | null): void;
                /**
                 * @en Update the data map of the reflection probe
                 * @zh ·̽ͼ
                 * @param texture data map
                 */
                updateReflectionProbeDataMap(texture: Texture2D | null): void;
                /**
                 * @en Update the shadow bias
                 * @zh Ӱƫ
                 */
                updateLocalShadowBias(): void;
                /**
                 * @en Update the id of reflection probe
                 * @zh ʹĸ̽
                 */
                updateReflectionProbeId(): void;
                /**
                 * @en Return shader's macro patches
                 * @zh ȡ shader 
                 * @param subModelIndex sub model's index
                 */
                getMacroPatches(subModelIndex: number): IMacroPatch[] | null;
                protected _updateAttributesAndBinding(subModelIndex: number): void;
                protected _updateInstancedAttributes(attributes: gfx.Attribute[], subModel: SubModel): void;
                protected _initLocalDescriptors(subModelIndex: number): void;
                protected _initLocalSHDescriptors(subModelIndex: number): void;
                protected _initWorldBoundDescriptors(subModelIndex: number): void;
                protected _updateLocalDescriptors(subModelIndex: number, descriptorSet: gfx.DescriptorSet): void;
                protected _updateLocalSHDescriptors(subModelIndex: number, descriptorSet: gfx.DescriptorSet): void;
                protected _updateWorldBoundDescriptors(subModelIndex: number, descriptorSet: gfx.DescriptorSet): void;
            }
            export interface IInstancedAttributeBlock {
                buffer: Uint8Array;
                views: __private.__types_globals__TypedArray[];
                attributes: gfx.Attribute[];
            }
            /**
             * @en A sub part of the model, it describes how to render a specific sub mesh.
             * It contains geometry information in [[RenderingSubMesh]] and all sort of rendering configuration like shaders, macro patches, passes etc.
             * @zh ģͶģͣȾģ͵һ
             *  [[RenderingSubMesh]] ļϢȾҪݣɫɫ궨壬Ⱦ passȡ
             */
            export class SubModel {
                protected _device: gfx.Device | null;
                protected _passes: Pass[] | null;
                protected _shaders: gfx.Shader[] | null;
                protected _subMesh: RenderingSubMesh | null;
                protected _patches: IMacroPatch[] | null;
                protected _priority: pipeline.RenderPriority;
                protected _inputAssembler: gfx.InputAssembler | null;
                protected _descriptorSet: gfx.DescriptorSet | null;
                protected _worldBoundDescriptorSet: gfx.DescriptorSet | null;
                protected _reflectionTex: gfx.Texture | null;
                protected _reflectionSampler: gfx.Sampler | null;
                protected _instancedAttributeBlock: IInstancedAttributeBlock;
                protected _instancedWorldMatrixIndex: number;
                protected _instancedSHIndex: number;
                protected _useReflectionProbeType: number;
                /**
                 * @en
                 * sub model's passes
                 * @zh
                 * ģ͵ passes
                 * @param passes @en The passes @zh õ passes
                 */
                /**
                 * @en Render passes for the sub-model
                 * @zh ģ͵Ⱦ pass
                 */
                set passes(passes: Pass[]);
                get passes(): Pass[];
                /**
                 * @en Shaders for the sub-model, each shader corresponds to one of the [[passes]]
                 * @zh ģ͵ɫбÿɫӦһȾ [[passes]]
                 */
                get shaders(): gfx.Shader[];
                /**
                 * @en The rendering sub mesh for the sub-model, each sub-model can only have one sub mesh.
                 * @zh Ⱦÿģֻܰһ
                 */
                set subMesh(subMesh: RenderingSubMesh);
                get subMesh(): RenderingSubMesh;
                /**
                 * @en The rendering priority of the sub-model
                 * @zh ģ͵Ⱦȼ
                 */
                set priority(val: pipeline.RenderPriority);
                get priority(): pipeline.RenderPriority;
                /**
                 * @en The low level input assembler which contains geometry data
                 * @zh ײȾõ㼯Ϣ
                 */
                get inputAssembler(): gfx.InputAssembler;
                /**
                 * @en The descriptor set used for sub-model rendering
                 * @zh ײȾģõ
                 */
                get descriptorSet(): gfx.DescriptorSet;
                /**
                 * @en The descriptor set for world bound
                 * @zh ڴ洢Χе
                 */
                get worldBoundDescriptorSet(): gfx.DescriptorSet | null;
                /**
                 * @en The macro patches for the shaders
                 * @zh ɫõĺ궨
                 */
                get patches(): Readonly<IMacroPatch[] | null>;
                /**
                 * @en The instance attribute block, access by sub model
                 * @zh Ӳʵԣͨģͷ
                 */
                get instancedAttributeBlock(): IInstancedAttributeBlock;
                /**
                 * @en Get or set instance matrix id, access by sub model
                 * @zh ȡӲʵеľͨģͷ
                 */
                set instancedWorldMatrixIndex(val: number);
                get instancedWorldMatrixIndex(): number;
                /**
                 * @en Get or set instance SH id, access by sub model
                 * @zh ȡӲʵегͨģͷ
                 */
                set instancedSHIndex(val: number);
                get instancedSHIndex(): number;
                /**
                 * @en Gets or sets the type of reflection probe, Used to process instance
                 * @zh ȡʹ÷̽ͣڴinstance
                 */
                set useReflectionProbeType(val: number);
                get useReflectionProbeType(): number;
                /**
                 * @en
                 * init sub model
                 * @zh
                 * ģͳʼ
                 * @param subMesh @en The sub mesh @zh Դ
                 * @param passes @en The passes @zh Ⱦ passes
                 * @param patches @en The shader's macro @zh ɫĺ궨
                 */
                initialize(subMesh: RenderingSubMesh, passes: Pass[], patches?: IMacroPatch[] | null): void;
                /**
                 * @en
                 * destroy sub model
                 * @zh
                 * ģ
                 */
                destroy(): void;
                /**
                 * @en
                 * update sub model
                 * @zh
                 * ģ
                 */
                update(): void;
                /**
                 * @en Pipeline changed callback
                 * @zh ߸»ص
                 */
                onPipelineStateChanged(): void;
                /**
                 * @en Shader macro changed callback
                 * @zh Shader »ص
                 */
                onMacroPatchesStateChanged(patches: IMacroPatch[] | null): void;
                /**
                 * @en
                 * geometry changed callback
                 * @zh
                 * ݸıĻص
                 */
                onGeometryChanged(): void;
                /**
                 * @en
                 * get instanced attribute index
                 * @zh
                 * ȡӲʵ
                 */
                /**
                 * @internal
                 */
                getInstancedAttributeIndex(name: string): number;
                /**
                 * @en
                 * update instancing related data, invoked by model
                 * @zh
                 * Ӳʵݣһmodel
                 */
                /**
                 * @internal
                 */
                updateInstancedWorldMatrix(mat: math.Mat4, idx: number): void;
                /**
                 * @en
                 * update instancing SH data, invoked by model
                 * @zh
                 * Ӳʵгݣһmodel
                 */
                /**
                 * @internal
                 */
                updateInstancedSH(data: Float32Array, idx: number): void;
                /**
                 * @en
                 * update instancing related data, invoked by model
                 * @zh
                 * Ӳʵݣһmodel
                 */
                /**
                 * @internal
                 */
                UpdateInstancedAttributes(attributes: gfx.Attribute[]): void;
                protected _flushPassInfo(): void;
            }
            /**
             * @en Ambient lighting representation in the render scene.
             * The initial data is setup in [[SceneGlobals.ambient]].
             * @zh ȾеĻá
             * ʼֵ [[SceneGlobals.ambient]] õġ
             */
            export class Ambient {
                /**
                 * @en Default sun illuminance
                 * @zh Ĭ̫
                 */
                static SUN_ILLUM: number;
                /**
                 * @en Default sky illuminance
                 * @zh Ĭ
                 */
                static SKY_ILLUM: number;
                /**
                 * @en Enable ambient
                 * @zh Ƿ
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @en Sky color
                 * @zh ɫ
                 */
                get skyColor(): math.Vec4;
                set skyColor(color: math.Vec4);
                /**
                 * @en Sky illuminance
                 * @zh 
                 */
                get skyIllum(): number;
                set skyIllum(illum: number);
                /**
                 * @en Ground color
                 * @zh ɫ
                 */
                get groundAlbedo(): math.Vec4;
                set groundAlbedo(color: math.Vec4);
                protected _groundAlbedoHDR: math.Vec4;
                protected _skyColorHDR: math.Vec4;
                protected _skyIllumHDR: number;
                protected _groundAlbedoLDR: math.Vec4;
                protected _skyColorLDR: math.Vec4;
                protected _skyIllumLDR: number;
                protected _mipmapCount: number;
                protected _enabled: boolean;
                initialize(ambientInfo: AmbientInfo): void;
            }
            export const EnvironmentLightingType: {
                /**
                 * @zh
                 * 
                 * @en
                 * hemisphere diffuse
                 * @readonly
                 */
                HEMISPHERE_DIFFUSE: number;
                /**
                 * @zh
                 * ͻ
                 * @en
                 * hemisphere diffuse and Environment reflection
                 * @readonly
                 */
                AUTOGEN_HEMISPHERE_DIFFUSE_WITH_REFLECTION: number;
                /**
                 * @zh
                 * ͼͻ
                 * @en
                 * diffuse convolution map and environment reflection
                 * @readonly
                 */
                DIFFUSEMAP_WITH_REFLECTION: number;
            };
            /**
             * @en The skybox configuration of the render scene,
             * currently some rendering options like hdr and ibl lighting configuration is also here.
             * @zh ȾպãĿǰһЩȾã HDR ģʽͻҲ Skybox С
             */
            export class Skybox {
                /**
                 * @en The Model object of the skybox
                 * @zh պе Model 
                 */
                get model(): Model | null;
                /**
                 * @en Whether activate skybox in the scene
                 * @zh ǷպУ
                 */
                get enabled(): boolean;
                set enabled(val: boolean);
                /**
                 * @en Whether HDR mode is enabled
                 * @zh ǷHDR
                 */
                get useHDR(): boolean;
                set useHDR(val: boolean);
                /**
                 * @en Whether use image based lighting for PBR materials
                 * @zh ǷIBL
                 */
                get useIBL(): boolean;
                set useIBL(val: boolean);
                /**
                 * @en Whether use diffuse convolution map lighting
                 * @zh ǷΪIBLͼ
                 */
                get useDiffuseMap(): boolean;
                set useDiffuseMap(val: boolean);
                /**
                 * @en Whether enable RGBE data support in skybox shader
                 * @zh ǷҪ shader ڵ RGBE ֧֣
                 */
                get isRGBE(): boolean;
                /**
                 * @en Whether to use offline baked convolutional maps
                 * @zh Ƿʹߺ決ľͼ
                 */
                get useConvolutionMap(): boolean;
                /**
                 * @en The texture cube used for the skybox
                 * @zh ʹõͼ
                 */
                get envmap(): TextureCube | null;
                set envmap(val: TextureCube | null);
                /**
                 * @en The texture cube used diffuse convolution map
                 * @zh ʹõͼ
                 */
                get diffuseMap(): TextureCube | null;
                set diffuseMap(val: TextureCube | null);
                get reflectionMap(): TextureCube | null;
                get editableMaterial(): MaterialInstance | null;
                protected _envmapLDR: TextureCube | null;
                protected _envmapHDR: TextureCube | null;
                protected _diffuseMapLDR: TextureCube | null;
                protected _diffuseMapHDR: TextureCube | null;
                protected _globalDSManager: __private._cocos_rendering_global_descriptor_set_manager__GlobalDSManager | null;
                protected _model: Model | null;
                protected _default: TextureCube | null;
                protected _enabled: boolean;
                protected _useIBL: boolean;
                protected _useHDR: boolean;
                protected _useDiffuseMap: boolean;
                protected _editableMaterial: MaterialInstance | null;
                protected _activated: boolean;
                protected _reflectionHDR: TextureCube | null;
                protected _reflectionLDR: TextureCube | null;
                protected _rotationAngle: number;
                initialize(skyboxInfo: SkyboxInfo): void;
                /**
                 * @en Set the environment maps for HDR and LDR mode
                 * @zh Ϊ HDR  LDR ģʽûͼ
                 * @param envmapHDR @en Environment map for HDR mode @zh HDR ģʽµĻͼ
                 * @param envmapLDR @en Environment map for LDR mode @zh LDR ģʽµĻͼ
                 */
                setEnvMaps(envmapHDR: TextureCube | null, envmapLDR: TextureCube | null): void;
                /**
                 * @en Set the diffuse maps
                 * @zh ûͼ
                 * @param diffuseMapHDR @en Diffuse map for HDR mode @zh HDR ģʽµͼ
                 * @param diffuseMapLDR  @en Diffuse map for LDR mode @zh LDR ģʽµͼ
                 */
                setDiffuseMaps(diffuseMapHDR: TextureCube | null, diffuseMapLDR: TextureCube | null): void;
                /**
                 * @en Set custom skybox material
                 * @zh Զպв
                 * @param skyboxMat  @en Skybox material @zh պв
                 */
                setSkyboxMaterial(skyboxMat: Material | null): void;
                /**
                 * @en Set the environment reflection convolution map
                 * @zh ûͼ
                 * @param reflectionHDR  @en Reflection convolution map for HDR mode @zh HDR ģʽµķͼ
                 * @param reflectionLDR  @en Reflection convolution map for LDR mode @zh LDR ģʽµķͼ
                 */
                setReflectionMaps(reflectionHDR: TextureCube | null, reflectionLDR: TextureCube | null): void;
                /**
                 * @en Set skybox rotation angle
                 * @zh պתǶ
                 * @param angle  @en rotation angle @zh תǶ
                 */
                setRotationAngle(angle: number): void;
                getRotationAngle(): number;
                updateMaterialRenderInfo(): void;
                activate(): void;
                protected _updatePipeline(): void;
                protected _updateGlobalBinding(): void;
                protected _updateSubModes(): void;
            }
            /**
             * @zh Ӱͼֱʡ
             * @en The shadow map size.
             * @static
             * @enum Shadows.ShadowSize
             */
            export const ShadowSize: {
                /**
                 * @zh ֱ 256 * 256
                 * @en shadow resolution 256 * 256.
                 * @readonly
                 */
                Low_256x256: number;
                /**
                 * @zh ֱ 512 * 512
                 * @en shadow resolution 512 * 512.
                 * @readonly
                 */
                Medium_512x512: number;
                /**
                 * @zh ֱ 1024 * 1024
                 * @en shadow resolution 1024 * 1024.
                 * @readonly
                 */
                High_1024x1024: number;
                /**
                 * @zh ֱ 2048 * 2048
                 * @en shadow resolution 2048 * 2048.
                 * @readonly
                 */
                Ultra_2048x2048: number;
            };
            /**
             * @zh Ӱ͡
             * @en The shadow type
             * @enum Shadows.ShadowType
             */
            export const ShadowType: {
                /**
                 * @zh ƽӰ
                 * @en Planar shadow
                 * @property Planar
                 * @readonly
                 */
                Planar: number;
                /**
                 * @zh Ӱͼ
                 * @en Shadow type
                 * @property ShadowMap
                 * @readonly
                 */
                ShadowMap: number;
            };
            /**
             * @zh pcfӰȼ
             * @en The pcf type
             * @static
             * @enum Shadows.PCFType
             */
            export const PCFType: {
                /**
                 * @zh x1 β
                 * @en x1 times
                 * @readonly
                 */
                HARD: number;
                /**
                 * @zh x4 β
                 * @en x4 times
                 * @readonly
                 */
                SOFT: number;
                /**
                 * @zh x9 β
                 * @en x9 times
                 * @readonly
                 */
                SOFT_2X: number;
                /**
                 * @zh x16 β
                 * @en x16 times
                 * @readonly
                 */
                SOFT_4X: number;
            };
            /**
             * @zh Ӱͼ㼶
             * @en The CSM shadow level
             * @enum Shadows.CSMLevel
             */
            export const CSMLevel: {
                /**
                 * @zh 1 㼶
                 * @en level 1
                 * @readonly
                 */
                LEVEL_1: number;
                /**
                 * @zh 2 㼶
                 * @en level 2
                 * @readonly
                 */
                LEVEL_2: number;
                /**
                 * @zh 3 㼶
                 * @en level 3
                 * @readonly
                 */
                LEVEL_3: number;
                /**
                 * @zh 4 㼶
                 * @en level 4
                 * @readonly
                 */
                LEVEL_4: number;
            };
            /**
             * @zh ӰŻģʽ
             * @en The CSM performance optimization mode
             * @enum Shadows.CSMOptimizationMode
             */
            export const CSMOptimizationMode: {
                /**
                 * @zh ûŻ
                 * @en has no performance optimization
                 * @readonly
                 */
                NONE: number;
                /**
                 * @zh ޳֮ظ
                 * @en Eliminate duplicate objects between layers
                 * @readonly
                 */
                RemoveDuplicates: number;
                /**
                 * @zh ȡȶ
                 * @en Disable rotation fix
                 * @readonly
                 */
                DisableRotationFix: number;
            };
            /**
             * @en The global shadow's configuration of the render scene
             * @zh ȾȫӰ
             */
            export class Shadows {
                /**
                 * @en MAX_FAR. This is shadow camera max far.
                 * @zh ӰԶӾࡣ
                 */
                static readonly MAX_FAR: number;
                /**
                 * @en EXPANSION_RATIO. This is shadow boundingBox Coefficient of expansion.
                 * @zh ӰΧϵ
                 */
                static readonly COEFFICIENT_OF_EXPANSION: number;
                /**
                 * @en Whether activate planar shadow.
                 * @zh ǷƽӰ
                 */
                get enabled(): boolean;
                set enabled(val: boolean);
                /**
                 * @en Shadow type.
                 * @zh Ӱ͡
                 */
                get type(): number;
                set type(val: number);
                /**
                 * @en The normal of the plane which receives shadow.
                 * @zh Ӱƽķߡ
                 */
                get normal(): math.Vec3;
                set normal(val: math.Vec3);
                /**
                 * @en The distance from coordinate origin to the receiving plane.
                 * @zh Ӱƽԭľ롣
                 */
                get distance(): number;
                set distance(val: number);
                /**
                 * @en Positional offset values in planar shading calculations.
                 * @zh ƽӰеλƫֵ
                 */
                get planeBias(): number;
                set planeBias(val: number);
                /**
                 * @en Shadow color.
                 * @zh Ӱɫ
                 */
                get shadowColor(): math.Color;
                set shadowColor(color: math.Color);
                /**
                 * @en get or set shadow camera orthoSize.
                 * @zh ȡӰС
                 */
                get size(): math.Vec2;
                set size(val: math.Vec2);
                /**
                 * @en shadow Map size has been modified.
                 * @zh ӰͼСǷ޸ġ
                 */
                get shadowMapDirty(): boolean;
                set shadowMapDirty(val: boolean);
                /**
                 * @en The transform matrix of the light source
                 * @zh Դı任
                 */
                get matLight(): math.Mat4;
                get material(): Material;
                get instancingMaterial(): Material;
                /**
                 * @en The bounding sphere of the shadow map.
                 * @zh ڼ̶Ӱ Shadow map ĳΧ.
                 */
                fixedSphere: geometry.Sphere;
                /**
                 * @en get or set shadow max received.
                 * @zh Ӱյƹ
                 */
                maxReceived: number;
                protected _matLight: math.Mat4;
                protected _material: Material | null;
                protected _instancingMaterial: Material | null;
                protected _enabled: boolean;
                protected _type: number;
                protected _distance: number;
                protected _planeBias: number;
                protected _normal: math.Vec3;
                protected _shadowColor: math.Color;
                protected _size: math.Vec2;
                protected _shadowMapDirty: boolean;
                /**
                 * @en Get the shader for the planar shadow with macro patches
                 * @zh ָͨȡƽӰ Shader 
                 * @param patches The macro patches for the shader
                 * @returns The shader for the planar shadow
                 */
                getPlanarShader(patches: Readonly<IMacroPatch[] | null>): gfx.Shader | null;
                initialize(shadowsInfo: ShadowsInfo): void;
                activate(): void;
                protected _updatePlanarInfo(): void;
                destroy(): void;
            }
            /**
             * @zh
             * ȫ͡
             * @en
             * The global fog type
             * @static
             * @enum FogInfo.FogType
             */
            export const FogType: {
                /**
                 * @zh
                 * 
                 * @en
                 * Linear fog
                 * @readonly
                 */
                LINEAR: number;
                /**
                 * @zh
                 * ָ
                 * @en
                 * Exponential fog
                 * @readonly
                 */
                EXP: number;
                /**
                 * @zh
                 * ָƽ
                 * @en
                 * Exponential square fog
                 * @readonly
                 */
                EXP_SQUARED: number;
                /**
                 * @zh
                 * 
                 * @en
                 * Layered fog
                 * @readonly
                 */
                LAYERED: number;
            };
            export const FOG_TYPE_NONE: number;
            /**
             * @en The fog representation in the render scene.
             * @zh ȾеȫЧ
             */
            export class Fog {
                /**
                 * @zh ǷȫЧ
                 * @en Enable global fog
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @zh ǷþȷЧ()
                 * @en Enable accurate fog (pixel fog)
                 */
                set accurate(val: boolean);
                get accurate(): boolean;
                /**
                 * @zh ȫɫ
                 * @en Global fog color
                 */
                set fogColor(val: math.Color);
                get fogColor(): math.Color;
                /**
                 * @zh ǰ͡
                 * @en The current global fog type.
                 * @returns {FogType}
                 * Returns the current global fog type
                 * - -1:Disable global Fog
                 * - 0:Linear fog
                 * - 1:Exponential fog
                 * - 2:Exponential square fog
                 * - 3:Layered fog
                 */
                get type(): number;
                set type(val: number);
                /**
                 * @zh ȫŨ
                 * @en Global fog density
                 */
                get fogDensity(): number;
                set fogDensity(val: number);
                /**
                 * @zh Чʼλãֻ
                 * @en Global fog start position, only for linear fog
                 */
                get fogStart(): number;
                set fogStart(val: number);
                /**
                 * @zh Чλãֻ
                 * @en Global fog end position, only for linear fog
                 */
                get fogEnd(): number;
                set fogEnd(val: number);
                /**
                 * @zh Ч˥
                 * @en Global fog attenuation
                 */
                get fogAtten(): number;
                set fogAtten(val: number);
                /**
                 * @zh ЧΧֻڲ㼶
                 * @en Global fog top range, only for layered fog
                 */
                get fogTop(): number;
                set fogTop(val: number);
                /**
                 * @zh ЧΧֻڲ㼶
                 * @en Global fog range, only for layered fog
                 */
                get fogRange(): number;
                set fogRange(val: number);
                get colorArray(): Readonly<math.Vec4>;
                protected _fogColor: math.Color;
                protected _colorArray: math.Vec4;
                protected _enabled: boolean;
                protected _accurate: boolean;
                protected _type: number;
                protected _fogDensity: number;
                protected _fogStart: number;
                protected _fogEnd: number;
                protected _fogAtten: number;
                protected _fogTop: number;
                protected _fogRange: number;
                protected _activated: boolean;
                initialize(fogInfo: FogInfo): void;
                activate(): void;
                protected _updatePipeline(): void;
            }
            /**
             * @en The octree culling configuration of the render scene
             * @zh Ⱦİ˲޳
             */
            export class Octree {
                /**
                 * @en Whether octree culling is enabled in the render scene
                 * @zh Ƿ˲޳
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @en Minimum position of the scene's bounding box
                 * @zh ΧСֵ
                 */
                get minPos(): math.Vec3;
                set minPos(val: math.Vec3);
                /**
                 * @en Maximum position of the scene's bounding box
                 * @zh Χֵ
                 */
                get maxPos(): math.Vec3;
                set maxPos(val: math.Vec3);
                /**
                 * @en The depth of the octree
                 * @zh ˲
                 */
                get depth(): number;
                set depth(val: number);
                protected _enabled: boolean;
                protected _minPos: math.Vec3;
                protected _maxPos: math.Vec3;
                protected _depth: number;
                initialize(octreeInfo: OctreeInfo): void;
            }
            /**
             * @en Global skin in the render scene.
             * The initial data is setup in [[SceneGlobals.skip]].
             * @zh ȾеȫƤá
             * ʼֵ [[SceneGlobals.skin]] õġ
             */
            export class Skin {
                /**
                 * @en Enable skip.
                 * @zh ǷƤЧ
                 */
                set enabled(val: boolean);
                get enabled(): boolean;
                /**
                 * @en Getter/Setter sampler width.
                 * @zh û߻ȡȡ
                 */
                set blurRadius(val: number);
                get blurRadius(): number;
                /**
                 * @en Getter/Setter depth unit scale.
                 * @zh û߻ȡȵλ
                 */
                set sssIntensity(val: number);
                get sssIntensity(): number;
                protected _enabled: boolean;
                protected _blurRadius: number;
                protected _sssIntensity: number;
                initialize(skinInfo: SkinInfo): void;
            }
            export function ColorTemperatureToRGB(rgb: math.Vec3, kelvin: number): void;
            /**
             * @en The light type enumeration.
             * @zh Դö١
             */
            export enum LightType {
                DIRECTIONAL = 0,
                SPHERE = 1,
                SPOT = 2,
                POINT = 3,
                RANGED_DIRECTIONAL = 4,
                UNKNOWN = 5
            }
            export const nt2lm: (size: number) => number;
            /**
             * @en The abstract light class of the render scene
             * @zh ȾеĹԴ
             */
            export class Light {
                /**
                 * @en Whether it's a baked light source, baked light will be ignored in real time lighting pass
                 * @zh ǷǺ決Դ決Դʵʱռб
                 */
                get baked(): boolean;
                set baked(val: boolean);
                /**
                 * @en The color of the light
                 * @zh Դɫ
                 */
                set color(color: math.Vec3);
                get color(): math.Vec3;
                /**
                 * @en Whether to use color temperature
                 * @zh ǷʹùԴɫ
                 */
                set useColorTemperature(enable: boolean);
                get useColorTemperature(): boolean;
                /**
                 * @en The color temperature of the light
                 * @zh Դɫ
                 */
                set colorTemperature(val: number);
                get colorTemperature(): number;
                /**
                 * @en The float RGB value of the color temperature, each channel is from 0 to 1
                 * @zh ɫµĸɫֵÿͨǴ 0  1
                 */
                get colorTemperatureRGB(): math.Vec3;
                get finalColor(): Readonly<math.Vec3>;
                set node(n: Node | null);
                /**
                 * @en The node which owns the light source
                 * @zh ԴĽڵ
                 */
                get node(): Node | null;
                /**
                 * @en The type of the light source, e.g. directional light, spot light, etc
                 * @zh Դͣ緽⡢۹Ƶ
                 */
                get type(): LightType;
                /**
                 * @en The name of the light source
                 * @zh Դ
                 */
                get name(): string | null;
                set name(n: string | null);
                /**
                 * @en The render scene which owns the current light
                 * @zh ԴȾ
                 */
                get scene(): RenderScene | null;
                protected _baked: boolean;
                protected _color: math.Vec3;
                protected _colorTemp: number;
                protected _colorTempRGB: math.Vec3;
                protected _scene: RenderScene | null;
                protected _node: Node | null;
                protected _name: string | null;
                protected _useColorTemperature: boolean;
                protected _type: LightType;
                protected _visibility: number;
                initialize(): void;
                /**
                 * @en Attach the light to a render scene
                 * @zh ԴصȾ
                 * @param scene @en The render scene @zh Ⱦ
                 */
                attachToScene(scene: RenderScene): void;
                /**
                 * @en Detach the light from the render scene
                 * @zh ԴȾƳ
                 */
                detachFromScene(): void;
                destroy(): void;
                update(): void;
            }
            /**
             * @en The directional light representation in the render scene, it acts as the main light source in a scene.
             * As main light, only one directional light can be created in a scene, it can generate realtime shadows with configuration.
             * @zh ȾеķǳеԴΪԴÿֻһ⣬ҲӰãʵʱӰ
             */
            export class DirectionalLight extends Light {
                protected _dir: math.Vec3;
                protected _illuminanceHDR: number;
                protected _illuminanceLDR: number;
                protected _shadowEnabled: boolean;
                protected _shadowPcf: number;
                protected _shadowBias: number;
                protected _shadowNormalBias: number;
                protected _shadowSaturation: number;
                protected _shadowDistance: number;
                protected _shadowInvisibleOcclusionRange: number;
                protected _csmLevel: number;
                protected _csmNeedUpdate: boolean;
                protected _csmLayerLambda: number;
                protected _csmOptimizationMode: number;
                protected _csmLayersTransition: boolean;
                protected _csmTransitionRange: number;
                protected _shadowFixedArea: boolean;
                protected _shadowNear: number;
                protected _shadowFar: number;
                protected _shadowOrthoSize: number;
                /**
                 * @en The direction vector of the light
                 * @zh Դķ
                 */
                set direction(dir: math.Vec3);
                get direction(): math.Vec3;
                /**
                 * @en The illuminance of the light in Lux(lx)
                 * @zh Դķնȣλ Lux(lx)
                 */
                get illuminance(): number;
                set illuminance(value: number);
                /**
                 * @en The illuminance of the light in HDR mode
                 * @zh HDR ģʽ¹Դķն
                 */
                get illuminanceHDR(): number;
                set illuminanceHDR(value: number);
                /**
                 * @en The illuminance of the light in LDR mode
                 * @zh LDR ģʽ¹Դķն
                 */
                get illuminanceLDR(): number;
                set illuminanceLDR(value: number);
                /**
                 * @en Whether activate shadow
                 * @zh ǷӰ
                 */
                get shadowEnabled(): boolean;
                set shadowEnabled(val: boolean);
                /**
                 * @en get or set shadow pcf.
                 * @zh ȡӰpcfȼ
                 */
                get shadowPcf(): number;
                set shadowPcf(val: number);
                /**
                 * @en get or set shadow map sampler offset
                 * @zh ȡӰƫֵ
                 */
                get shadowBias(): number;
                set shadowBias(val: number);
                /**
                 * @en get or set normal bias.
                 * @zh û߻ȡƫơ
                 */
                get shadowNormalBias(): number;
                set shadowNormalBias(val: number);
                /**
                 * @en Shadow color saturation
                 * @zh ӰɫͶ
                 */
                get shadowSaturation(): number;
                set shadowSaturation(val: number);
                /**
                 * @en get or set shadow camera far
                 * @zh ȡǱӰķΧ
                 */
                get shadowDistance(): number;
                set shadowDistance(val: number);
                /**
                 * @en get or set shadow camera far
                 * @zh ȡǱӰķΧ
                 */
                get shadowInvisibleOcclusionRange(): number;
                set shadowInvisibleOcclusionRange(val: number);
                /**
                 * @en get or set shadow CSM level
                 * @zh ȡüӰ
                 */
                get csmLevel(): number;
                set csmLevel(val: number);
                /**
                 * @en is CSM need update
                 * @zh ȡüӰǷҪ
                 */
                get csmNeedUpdate(): boolean;
                set csmNeedUpdate(val: boolean);
                /**
                 * @en get or set shadow CSM level ratio
                 * @zh ȡüӰϵ
                 */
                get csmLayerLambda(): number;
                set csmLayerLambda(val: number);
                /**
                 * @en get or set shadow CSM performance optimization mode
                 * @zh ȡüӰŻģʽ
                 */
                get csmOptimizationMode(): number;
                set csmOptimizationMode(val: number);
                /**
                 * @en get or set fixed area shadow
                 * @zh Ƿǹ̶Ӱ
                 */
                get shadowFixedArea(): boolean;
                set shadowFixedArea(val: boolean);
                /**
                 * @en The near clip plane of the shadow camera
                 * @zh ȡӰü
                 */
                get shadowNear(): number;
                set shadowNear(val: number);
                /**
                 * @en The far clip plane of the shadow camera
                 * @zh ȡӰԶü
                 */
                get shadowFar(): number;
                set shadowFar(val: number);
                /**
                 * @en get or set shadow camera orthoSize
                 * @zh ȡӰС
                 */
                get shadowOrthoSize(): number;
                set shadowOrthoSize(val: number);
                /**
                 * @en Enabled csm layers transition
                 * @zh ǷüӰ㼶ɣ
                 */
                get csmLayersTransition(): boolean;
                set csmLayersTransition(val: boolean);
                /**
                 * @en get or set csm layers transition range
                 * @zh ȡüӰ㼶ɷΧ
                 */
                get csmTransitionRange(): number;
                set csmTransitionRange(val: number);
                constructor();
                initialize(): void;
                /**
                 * @en Update the direction
                 * @zh ·
                 */
                update(): void;
            }
            /**
             * @en The sphere light representation in the render scene, it will light up a spherical area in the scene.
             * It doesn't support shadow generation currently.
             * @zh Ⱦе󣬿еһĿǰ֧Ӱ
             */
            export class SphereLight extends Light {
                /**
                 * @en The world position of the light source
                 * @zh Դĵ
                 */
                get position(): math.Vec3;
                /**
                 * @en The size of the light source
                 * @zh Դĳߴ
                 */
                set size(size: number);
                get size(): number;
                /**
                 * @en The lighting range of the light source
                 * @zh ԴĹշΧ
                 */
                set range(range: number);
                get range(): number;
                /**
                 * @en The luminance of the light source
                 * @zh Դ
                 */
                get luminance(): number;
                set luminance(value: number);
                /**
                 * @en The luminance of the light source in HDR mode
                 * @zh HDR ģʽ¹Դ
                 */
                get luminanceHDR(): number;
                set luminanceHDR(value: number);
                /**
                 * @en The luminance of the light source in LDR mode
                 * @zh LDR ģʽ¹Դ
                 */
                set luminanceLDR(value: number);
                /**
                 * @en The AABB bounding box of the lighting area
                 * @zh ܹԴӰ췶Χ AABB Χ
                 */
                get aabb(): geometry.AABB;
                protected _needUpdate: boolean;
                protected _size: number;
                protected _range: number;
                protected _luminanceHDR: number;
                protected _luminanceLDR: number;
                protected _pos: math.Vec3;
                protected _aabb: geometry.AABB;
                constructor();
                initialize(): void;
                /**
                 * @en Update the lighting area
                 * @zh ¹ԴӰ췶Χ
                 */
                update(): void;
            }
            /**
             * @en The spot light representation in the render scene, it will light up a cone area in the direction of the light, it supports shadow generation.
             * @zh Ⱦеľ۹Ƴ󣬿Դϵһ׶֧Ӱ
             */
            export class SpotLight extends Light {
                protected _dir: math.Vec3;
                protected _range: number;
                protected _spotAngle: number;
                protected _angleAttenuationStrength: number;
                protected _pos: math.Vec3;
                protected _aabb: geometry.AABB;
                protected _frustum: geometry.Frustum;
                /**
                 * @en User-specified full-angle radians.
                 * @zh ûָȫǻȡ
                 */
                protected _angle: number;
                protected _needUpdate: boolean;
                protected _size: number;
                protected _luminanceHDR: number;
                protected _luminanceLDR: number;
                protected _shadowEnabled: boolean;
                protected _shadowPcf: number;
                protected _shadowBias: number;
                protected _shadowNormalBias: number;
                /**
                 * @en The world position of the light source
                 * @zh Դ
                 */
                get position(): math.Vec3;
                /**
                 * @en The size of the spot light source
                 * @zh ۹ƵĹԴߴ
                 */
                set size(size: number);
                get size(): number;
                /**
                 * @en The lighting range of the spot light
                 * @zh ۹ƵĹշΧ
                 */
                set range(range: number);
                get range(): number;
                /**
                 * @en The luminance of the light source
                 * @zh Դ
                 */
                get luminance(): number;
                set luminance(value: number);
                /**
                 * @en The luminance of the light source in HDR mode
                 * @zh HDR ģʽ¹Դ
                 */
                get luminanceHDR(): number;
                set luminanceHDR(value: number);
                /**
                 * @en The luminance of the light source in LDR mode
                 * @zh LDR ģʽ¹Դ
                 */
                get luminanceLDR(): number;
                set luminanceLDR(value: number);
                /**
                 * @en The direction of the spot light
                 * @zh ۹Ƶ
                 */
                get direction(): math.Vec3;
                /**
                 * @en The setter will take the value as the cone angle,
                 * but the getter will give you the cosine value of the half cone angle: `cos(angle / 2)`.
                 * As the in-consistence is not acceptable for a property, please do not use it.
                 * @zh ֵʱԻֵ۹ƹ׶ǣǻȡʱص cos(angle / 2)
                 * ֲһԣ벻Ҫʹԡ
                 * @internal
                 */
                get spotAngle(): number;
                set spotAngle(val: number);
                /**
                 * @en The angle attenuation strength of the spot light.
                 * The larger the value, the softer the edge, and the smaller the value, the harder the edge.
                 * @zh ۹ƽǶ˥ǿȡֵԽ󣬱ԵԽֵͣԽСԵԽӲ
                 */
                get angleAttenuationStrength(): number;
                set angleAttenuationStrength(val: number);
                /**
                 * @en The cone angle of the lighting area
                 * @zh ۹׶
                 */
                get angle(): number;
                get aabb(): geometry.AABB;
                /**
                 * @en The frustum of the lighting area
                 * @zh ܹԴӰ췶ΧĽ׵
                 */
                get frustum(): geometry.Frustum;
                /**
                 * @en Whether shadow casting is enabled
                 * @zh ǷӰ
                 */
                get shadowEnabled(): boolean;
                set shadowEnabled(val: boolean);
                /**
                 * @en The pcf level of the shadow generation.
                 * @zh ȡӰ pcf ȼ
                 */
                get shadowPcf(): number;
                set shadowPcf(val: number);
                /**
                 * @en The depth offset of shadow to avoid moire pattern artifacts
                 * @zh Ӱƫ, Լصµ״ʧ
                 */
                get shadowBias(): number;
                set shadowBias(val: number);
                /**
                 * @en The normal bias of the shadow map.
                 * @zh û߻ȡƫơ
                 */
                get shadowNormalBias(): number;
                set shadowNormalBias(val: number);
                constructor();
                initialize(): void;
                update(): void;
            }
            /**
             * @en The point light representation in the render scene, it will light up a spherical area in the scene.
             * It doesn't support shadow generation currently.
             * @zh Ⱦеĵ󣬿еһĿǰ֧Ӱ
             */
            export class PointLight extends Light {
                /**
                 * @en The world position of the light source.
                 * @zh Դĵꡣ
                 */
                get position(): Readonly<math.Vec3>;
                /**
                 * @en The lighting range of the light source.
                 * @zh ԴĹշΧ
                 */
                set range(range: number);
                get range(): number;
                /**
                 * @en The luminance of the light source.
                 * @zh Դȡ
                 */
                get luminance(): number;
                set luminance(value: number);
                /**
                 * @en The luminance of the light source in HDR mode.
                 * @zh HDR ģʽ¹Դȡ
                 */
                get luminanceHDR(): number;
                set luminanceHDR(value: number);
                /**
                 * @en The luminance of the light source in LDR mode.
                 * @zh LDR ģʽ¹Դȡ
                 */
                set luminanceLDR(value: number);
                /**
                 * @en The AABB bounding box of the lighting area.
                 * @zh ܹԴӰ췶Χ AABB ΧС
                 */
                get aabb(): geometry.AABB;
                constructor();
                initialize(): void;
                /**
                 * @en Update the lighting area.
                 * @zh ¹ԴӰ췶Χ
                 */
                update(): void;
            }
            /**
             * @en Render the abstraction of light in the scene, which is a ranged directional light source in the scene. Non main light source,
             * each scene is allowed to have multiple ranged directional light sources without shadows.
             * @zh ȾеĹĳǳеķΧƽйԴԴÿжΧƽйԴӰ
             */
            export class RangedDirectionalLight extends Light {
                /**
                 * @en The direction vector of the light
                 * @zh Դķ
                 */
                get direction(): Readonly<math.Vec3>;
                /**
                 * @en The right vector of the light
                 * @zh Դҷ
                 */
                get right(): Readonly<math.Vec3>;
                /**
                 * @en The world position of the light source
                 * @zh Դ
                 */
                get position(): Readonly<math.Vec3>;
                /**
                 * @en The world scale of the light source
                 * @zh Դ
                 */
                get scale(): Readonly<math.Vec3>;
                /**
                 * @en The illuminance of the light in Lux(lx)
                 * @zh Դķնȣλ Lux(lx)
                 */
                get illuminance(): number;
                set illuminance(value: number);
                /**
                 * @en The illuminance of the light in HDR mode
                 * @zh HDR ģʽ¹Դķն
                 */
                get illuminanceHDR(): number;
                set illuminanceHDR(value: number);
                /**
                 * @en The illuminance of the light in LDR mode
                 * @zh LDR ģʽ¹Դķն
                 */
                get illuminanceLDR(): number;
                set illuminanceLDR(value: number);
                constructor();
                initialize(): void;
                /**
                 * @en Update
                 * @zh 
                 */
                update(): void;
            }
            export enum ProbeClearFlag {
                SKYBOX,
                SOLID_COLOR = 7
            }
            export enum ProbeType {
                CUBE = 0,
                PLANAR = 1
            }
            export class ReflectionProbe {
                bakedCubeTextures: RenderTexture[];
                realtimePlanarTexture: RenderTexture | null;
                protected _resolution: number;
                protected _clearFlag: number;
                protected _backgroundColor: math.Color;
                protected _visibility: number;
                protected _probeType: ProbeType;
                protected _cubemap: TextureCube | null;
                protected readonly _size: math.Vec3;
                /**
                 * @en Reflection probe cube pattern preview sphere
                 * @zh ̽cubeģʽԤС
                 */
                protected _previewSphere: Node | null;
                protected _previewPlane: Node | null;
                /**
                 * @en Set probe type,cube or planar.
                 * @zh ̽ͣcubeplanar
                 */
                set probeType(value: ProbeType);
                get probeType(): ProbeType;
                get resolution(): number;
                /**
                 * @en set render texture size
                 * @zh ȾС
                 */
                set resolution(value: number);
                /**
                 * @en Clearing flags of the camera, specifies which part of the framebuffer will be actually cleared every frame.
                 * @zh Ļ־λָ֡ĲҪÿ֡
                 */
                set clearFlag(value: number);
                get clearFlag(): number;
                /**
                 * @en Clearing color of the camera.
                 * @zh ɫĬֵ
                 */
                set backgroundColor(val: math.Color);
                get backgroundColor(): math.Color;
                /**
                 * @en Visibility mask, declaring a set of node layers that will be visible to this camera.
                 * @zh ɼ룬ڵǰпɼĽڵ㼶ϡ
                 */
                get visibility(): number;
                set visibility(val: number);
                /**
                 * @en Gets or sets the size of the box, in local space.
                 * @zh ȡúеĴС
                 */
                set size(value: math.Vec3);
                get size(): math.Vec3;
                set cubemap(val: TextureCube | null);
                get cubemap(): TextureCube | null;
                /**
                 * @en The node of the probe.
                 * @zh probe󶨵Ľڵ
                 */
                get node(): Node;
                get camera(): Camera;
                /**
                 * @en Refresh the objects that use this probe.
                 * @zh ˢʹøprobe
                 */
                set needRefresh(value: boolean);
                get needRefresh(): boolean;
                set needRender(value: boolean);
                get needRender(): boolean;
                get boundingBox(): geometry.AABB | null;
                set cameraNode(node: Node);
                get cameraNode(): Node;
                /**
                 * @en Reflection probe planar mode preview plane
                 * @zh ̽PlanarģʽԤƽ
                 */
                set previewPlane(val: Node);
                get previewPlane(): Node;
                constructor(id: number);
                initialize(node: Node, cameraNode: Node): void;
                initBakedTextures(): void;
                captureCubemap(): void;
                /**
                 * @en Render real-time planar reflection textures
                 * @zh Ⱦʵʱƽ淴ͼ
                 * @param sourceCamera render planar reflection for this camera
                 */
                renderPlanarReflection(sourceCamera: Camera): void;
                switchProbeType(type: ProbeType, sourceCamera: Camera | null): void;
                getProbeId(): number;
                updateProbeId(id: any): void;
                renderArea(): math.Vec2;
                isFinishedRendering(): boolean;
                validate(): boolean;
                destroy(): void;
                enable(): void;
                disable(): void;
                updateCameraDir(faceIdx: number): void;
                updateBoundingBox(): void;
                hasFrameBuffer(framebuffer: gfx.Framebuffer): boolean;
                isRGBE(): boolean;
            }
            export const ToneMappingType: {
                DEFAULT: number;
                LINEAR: number;
            };
            export class PostSettings {
                protected _toneMappingType: number;
                protected _activated: boolean;
                set toneMappingType(val: number);
                get toneMappingType(): number;
                initialize(postSettingsInfo: PostSettingsInfo): void;
                activate(): void;
                protected _updatePipeline(): void;
            }
        }
        export enum RenderQueue {
            OPAQUE = 0,
            TRANSPARENT = 1,
            OVERLAY = 2
        }
        export enum PassStage {
            DEFAULT = 1,
            FORWARD = 2,
            SHADOWCAST = 4
        }
        /**
         * @en Gets the default values for the given type of uniform
         * @zh ָ Uniform ȡĬֵ
         * @param type The type of the uniform
         */
        export function getDefaultFromType(type: gfx.Type): readonly number[] | string;
        export function getStringFromType(type: gfx.Type): string;
        /**
         * @en Override the preprocess macros
         * @zh дԤ
         * @param target Target preprocess macros to be overridden
         * @param source Preprocess macros used for override
         */
        export function overrideMacros(target: MacroRecord, source: MacroRecord): boolean;
        export const genHandle: (binding: number, type: gfx.Type, count: number, offset?: number) => number;
        export const getTypeFromHandle: (handle: number) => number;
        export const getBindingFromHandle: (handle: number) => number;
        export const getCountFromHandle: (handle: number) => number;
        export const getOffsetFromHandle: (handle: number) => number;
        export const customizeType: (handle: number, type: gfx.Type) => number;
        /**
         * @en Vector type uniforms
         * @zh  uniform
         */
        export type MaterialProperty = number | math.Vec2 | math.Vec3 | math.Vec4 | math.Color | math.Mat3 | math.Mat4 | math.Quat;
        export const type2reader: {
            0: (a: Float32Array, v: number, idx?: number) => void;
            5: (a: Int32Array, v: number, idx?: number) => number;
            6: (a: Int32Array, v: math.IVec2Like, idx?: number) => math.IVec2Like;
            7: (a: Int32Array, v: math.IVec3Like, idx?: number) => math.IVec3Like;
            8: (a: Int32Array, v: math.IVec4Like, idx?: number) => math.IVec4Like;
            13: (a: Float32Array, v: number, idx?: number) => number;
            14: (a: Float32Array, v: math.IVec2Like, idx?: number) => math.IVec2Like;
            15: (a: Float32Array, v: math.IVec3Like, idx?: number) => math.IVec3Like;
            16: (a: Float32Array, v: math.IVec4Like, idx?: number) => math.IVec4Like;
            21: (a: Float32Array, v: math.IMat3Like, idx?: number) => math.IMat3Like;
            25: (a: Float32Array, v: math.IMat4Like, idx?: number) => math.IMat4Like;
        };
        export const type2writer: {
            0: (a: Float32Array, v: number, idx?: number) => void;
            5: (a: Int32Array, v: number, idx?: number) => number;
            6: (a: Int32Array, v: math.Vec2, idx?: number) => Int32Array;
            7: (a: Int32Array, v: math.Vec3, idx?: number) => Int32Array;
            8: (a: Int32Array, v: math.Vec4, idx?: number) => Int32Array;
            13: (a: Float32Array, v: number, idx?: number) => number;
            14: (a: Float32Array, v: math.Vec2, idx?: number) => Float32Array;
            15: (a: Float32Array, v: math.Vec3, idx?: number) => Float32Array;
            16: (a: Float32Array, v: math.Vec4, idx?: number) => Float32Array;
            21: (a: Float32Array, v: math.Mat3, idx?: number) => Float32Array;
            25: (a: Float32Array, v: math.Mat4, idx?: number) => Float32Array;
        };
        export const type2validator: {
            5: (v: number) => boolean;
            13: (v: number) => boolean;
            6: (v: math.Vec2) => boolean;
            14: (v: math.Vec2) => boolean;
            7: (v: math.Vec3) => boolean;
            15: (v: math.Vec3) => boolean;
            8: (v: math.Vec4) => boolean;
            16: (v: math.Vec4 | math.Color | math.Quat) => boolean;
            21: (v: math.Mat3) => boolean;
            25: (v: math.Mat4) => boolean;
        };
        /**
         * @en Combination of preprocess macros
         * @zh Ԥ
         */
        export type MacroRecord = Record<string, number | boolean | string>;
        export interface IPassInfoFull extends EffectAsset.IPassInfo {
            passIndex: number;
            defines: MacroRecord;
            stateOverrides?: PassOverrides;
        }
        export type PassOverrides = __private.__types_globals__RecursivePartial<EffectAsset.IPassStates>;
        export interface IMacroPatch {
            name: string;
            value: boolean | number | string;
        }
        export enum BatchingSchemes {
            NONE = 0,
            INSTANCING = 1
        }
        /**
         * @en Render pass, store actual resources for the rendering process
         * @zh Ⱦ passʵƹ̵ĸԴ
         */
        export class Pass {
            /**
             * @en Get the type of member in uniform buffer object with the handle
             * @zh  handle ȡ uniform ľ͡
             */
            static getTypeFromHandle: (handle: number) => number;
            /**
             * @en Get the binding with handle
             * @zh  handle ȡ binding
             */
            static getBindingFromHandle: (handle: number) => number;
            /**
             * @en Get the array length with handle
             * @zh  handle ȡ鳤ȡ
             */
            static getCountFromHandle: (handle: number) => number;
            protected static getOffsetFromHandle: (handle: number) => number;
            /**
             * @en Fill a pass represented by the given pass handle with the given override info
             * @param hPass The pass handle point to the pass
             * @param info The pass override info
             */
            static fillPipelineInfo(pass: Pass, info: PassOverrides): void;
            /**
             * @en Get pass hash value by [[renderer.Pass]] hash information.
             * @zh  [[renderer.Pass]] ĹϣϢȡϣֵ
             *
             * @param hPass Handle of the pass info used to compute hash value.
             */
            static getPassHash(pass: Pass): number;
            protected _rootBuffer: gfx.Buffer | null;
            protected _buffers: gfx.Buffer[];
            protected _descriptorSet: gfx.DescriptorSet;
            protected _pipelineLayout: gfx.PipelineLayout;
            protected _passIndex: number;
            protected _propertyIndex: number;
            protected _programName: string;
            protected _dynamics: __private._cocos_render_scene_core_pass__IPassDynamics;
            protected _propertyHandleMap: Record<string, number>;
            protected _rootBlock: ArrayBuffer | null;
            protected _blocksInt: Int32Array[];
            protected _blocks: Float32Array[];
            protected _shaderInfo: IProgramInfo;
            protected _defines: MacroRecord;
            protected _properties: Record<string, EffectAsset.IPropertyInfo>;
            protected _shader: gfx.Shader | null;
            protected _bs: gfx.BlendState;
            protected _dss: gfx.DepthStencilState;
            protected _rs: gfx.RasterizerState;
            protected _priority: pipeline.RenderPriority;
            protected _stage: pipeline.RenderPassStage;
            protected _phase: number;
            protected _passID: number;
            protected _subpassID: number;
            protected _phaseID: number;
            protected _primitive: gfx.PrimitiveMode;
            protected _batchingScheme: BatchingSchemes;
            protected _dynamicStates: gfx.DynamicStateFlagBit;
            protected _instancedBuffers: Record<number, InstancedBuffer>;
            protected _hash: number;
            protected _root: Root;
            protected _device: gfx.Device;
            protected _rootBufferDirty: boolean;
            constructor(root: Root);
            /**
             * @en Initialize the pass with given pass info, shader will be compiled in the init process
             * @zh ָʼǰ passshader һ׶ξͳԱ롣
             */
            initialize(info: IPassInfoFull): void;
            /**
             * @en Get the handle of a UBO member, or specific channels of it.
             * @zh ȡָ UBO ԱĶдĬԳԱΪĿдͣдʱ봫Աͬı
             * @param name Name of the target UBO member.
             * @param offset Channel offset into the member.
             * @param targetType Target type of the handle, i.e. the type of data when read/write to it.
             * @example
             * ```
             * import { Vec3, gfx } from 'cc';
             * // say 'pbrParams' is a uniform vec4
             * const hParams = pass.getHandle('pbrParams'); // get the default handle
             * pass.setUniform(hAlbedo, new Vec3(1, 0, 0)); // wrong! pbrParams.w is NaN now
             *
             * // say 'albedoScale' is a uniform vec4, and we only want to modify the w component in the form of a single float
             * const hThreshold = pass.getHandle('albedoScale', 3, gfx.Type.FLOAT);
             * pass.setUniform(hThreshold, 0.5); // now, albedoScale.w = 0.5
             * ```
             */
            getHandle(name: string, offset?: number, targetType?: gfx.Type): number;
            /**
             * @en Gets the uniform binding with its name
             * @zh ȡָ uniform  binding
             * @param name The name of target uniform
             */
            getBinding(name: string): number;
            /**
             * @en Sets a vector type uniform value, if a uniform requires frequent update, please use this method.
             * @zh ָͨ uniform ֵҪƵ뾡ʹô˽ӿڡ
             * @param handle The handle for the target uniform
             * @param value New value
             */
            setUniform(handle: number, value: MaterialProperty): void;
            /**
             * @en Gets a uniform's value.
             * @zh ȡָͨ uniform ֵ
             * @param handle The handle for the target uniform
             * @param out The output property to store the result
             */
            getUniform<T extends MaterialProperty>(handle: number, out: T): T;
            /**
             * @en Sets an array type uniform value, if a uniform requires frequent update, please use this method.
             * @zh ָ uniform ֵҪƵ뾡ʹô˽ӿڡ
             * @param handle The handle for the target uniform
             * @param value New value
             */
            setUniformArray(handle: number, value: MaterialProperty[]): void;
            /**
             * @en Bind a GFX [[gfx.Texture]] the the given uniform binding
             * @zh ʵ GFX [[gfx.Texture]] ָ binding
             * @param binding The binding for target uniform of texture type
             * @param value Target texture
             */
            bindTexture(binding: number, value: gfx.Texture, index?: number): void;
            /**
             * @en Bind a GFX [[gfx.Sampler]] the the given uniform binding
             * @zh ʵ GFX [[gfx.Sampler]] ָ binding
             * @param binding The binding for target uniform of sampler type
             * @param value Target sampler
             */
            bindSampler(binding: number, value: gfx.Sampler, index?: number): void;
            /**
             * @en Sets the dynamic pipeline state property at runtime
             * @zh ʱ pass ڿɶ̬µĹ״̬ԡ
             * @param state Target dynamic state
             * @param value Target value
             */
            setDynamicState(state: gfx.DynamicStateFlagBit, value: number): void;
            /**
             * @en Override all pipeline states with the given pass override info.
             * @zh صǰй״̬
             * @param original The original pass info
             * @param value The override pipeline state info
             */
            overridePipelineStates(original: EffectAsset.IPassInfo, overrides: PassOverrides): void;
            /**
             * @en Update the current uniforms data.
             * @zh µǰ Uniform ݡ
             */
            update(): void;
            getInstancedBuffer(extraKey?: number): InstancedBuffer;
            /**
             * @en Destroy the current pass.
             * @zh ٵǰ pass
             */
            destroy(): void;
            /**
             * @en Resets the value of the given uniform by name to the default value in [[EffectAsset]].
             * This method does not support array type uniform.
             * @zh ָ飩 Uniform Ϊ [[EffectAsset]] Ĭֵ
             */
            resetUniform(name: string): void;
            /**
             * @en Resets the value of the given texture by name to the default value in [[EffectAsset]].
             * @zh ָͼΪ [[EffectAsset]] Ĭֵ
             */
            resetTexture(name: string, index?: number): void;
            /**
             * @en Resets all uniform buffer objects to the default values in [[EffectAsset]]
             * @zh  UBO ΪĬֵ
             */
            resetUBOs(): void;
            /**
             * @en Resets all textures and samplers to the default values in [[EffectAsset]]
             * @zh  texture  sampler ΪʼĬֵ
             */
            resetTextures(): void;
            /**
             * @en Try to compile the shader and retrieve related resources references.
             * @zh Ա shader ȡԴá
             */
            tryCompile(): boolean;
            /**
             * @en Gets the shader variant of the current pass and given macro patches
             * @zh ָıϻȡǰ Pass  Shader Variant
             * @param patches The macro patches
             */
            getShaderVariant(patches?: Readonly<IMacroPatch[] | null>): gfx.Shader | null;
            protected get _isBlend(): boolean;
            /**
             * @private
             */
            beginChangeStatesSilently(): void;
            /**
             * @private
             */
            endChangeStatesSilently(): void;
            protected _doInit(info: IPassInfoFull, copyDefines?: boolean): void;
            protected _syncBatchingScheme(): void;
            get root(): Root;
            get device(): gfx.Device;
            get shaderInfo(): IProgramInfo;
            get localSetLayout(): gfx.DescriptorSetLayout;
            get program(): string;
            get properties(): Record<string, EffectAsset.IPropertyInfo>;
            get defines(): Record<string, string | number | boolean>;
            get passIndex(): number;
            get propertyIndex(): number;
            get dynamics(): __private._cocos_render_scene_core_pass__IPassDynamics;
            get blocks(): Float32Array[];
            get blocksInt(): Int32Array[];
            get rootBufferDirty(): boolean;
            get priority(): pipeline.RenderPriority;
            get primitive(): gfx.PrimitiveMode;
            get stage(): pipeline.RenderPassStage;
            get phase(): number;
            get passID(): number;
            get phaseID(): number;
            get rasterizerState(): gfx.RasterizerState;
            get depthStencilState(): gfx.DepthStencilState;
            get blendState(): gfx.BlendState;
            get dynamicStates(): gfx.DynamicStateFlags;
            get batchingScheme(): BatchingSchemes;
            get descriptorSet(): gfx.DescriptorSet;
            get hash(): number;
            get pipelineLayout(): gfx.PipelineLayout;
        }
        export namespace Pass {
            export type getTypeFromHandle = typeof Pass.getTypeFromHandle;
            export type getBindingFromHandle = typeof Pass.getBindingFromHandle;
            export type fillPipelineInfo = typeof Pass.fillPipelineInfo;
            export type getPassHash = typeof Pass.getPassHash;
            export type getCountFromHandle = typeof Pass.getCountFromHandle;
        }
        export function nearestPOT(num: number): number;
        export interface ITextureBuffer {
            texture: gfx.Texture;
            size: number;
            start: number;
            end: number;
        }
        export interface ITextureBufferHandle {
            chunkIdx: number;
            start: number;
            end: number;
            texture: gfx.Texture;
        }
        export interface ITextureBufferPoolInfo {
            format: gfx.Format;
            inOrderFree?: boolean;
            alignment?: number;
            roundUpFn?: (size: number, formatSize: number) => number;
        }
        export class TextureBufferPool {
            constructor(device: gfx.Device);
            initialize(info: ITextureBufferPoolInfo): void;
            destroy(): void;
            alloc(size: number, chunkIdx?: number): ITextureBufferHandle;
            free(handle: ITextureBufferHandle): void;
            createChunk(length: number): number;
            update(handle: ITextureBufferHandle, buffer: ArrayBuffer): void;
        }
        export interface IMaterialInstanceInfo {
            parent: Material;
            owner?: Renderer;
            subModelIdx?: number;
        }
        /**
         * @zh
         * ʵв޸ʱݲԴģⶨƵʵ
         */
        export class MaterialInstance extends Material {
            get parent(): Material;
            get owner(): Renderer | null;
            protected _passes: PassInstance[];
            constructor(info: IMaterialInstanceInfo);
            recompileShaders(overrides: MacroRecord, passIdx?: number): void;
            overridePipelineStates(overrides: PassOverrides, passIdx?: number): void;
            destroy(): boolean;
            onPassStateChange(dontNotify: boolean): void;
            protected _createPasses(): PassInstance[];
        }
        /**
         * @en A pass instance defines an variant version of the [[renderer.Pass]]
         * @zh ʾ [[renderer.Pass]] һʵ
         */
        export class PassInstance extends Pass {
            /**
             * @en The parent pass
             * @zh ԭʼ Pass
             */
            get parent(): Pass;
            constructor(parent: Pass, owner: MaterialInstance);
            /**
             * @en Override pipeline states with the given pass override info.
             * This won't affect the original pass
             * @zh صǰ Pass Ĺ״̬ⲻӰԭʼ Pass
             * @param original The original pass info
             * @param value The override pipeline state info
             */
            overridePipelineStates(original: EffectAsset.IPassInfo, overrides: PassOverrides): void;
            tryCompile(defineOverrides?: MacroRecord): boolean;
            /**
             * @en Prepare to change states of the pass and do not notify the material to rebuild the pipeline state object
             * @zh ʼĬ޸ Pass ״̬֪ͨȥ¹״̬
             */
            beginChangeStatesSilently(): void;
            /**
             * @en End the silent states changing process, all state changes will be notified.
             * @zh Ĭ״̬޸ģ޸ĽῪʼ֪ͨʡ
             */
            endChangeStatesSilently(): void;
            protected _syncBatchingScheme(): void;
            protected _onStateChange(): void;
        }
        export enum PoolType {
            NODE = 0,
            PASS = 1,
            AABB = 2,
            RENDER2D = 3
        }
        export const NULL_HANDLE: __private._cocos_render_scene_core_memory_pools__IHandle<any>;
        export type Render2dHandle = __private._cocos_render_scene_core_memory_pools__IHandle<PoolType.RENDER2D>;
        export enum Render2dView {
            POSITION = 0,
            UV = 3,
            COLOR = 5,
            COUNT = 9
        }
        export const Render2dPool: __private._cocos_render_scene_core_memory_pools__BufferPool<PoolType.RENDER2D, typeof Render2dView>;
        export type NodeHandle = __private._cocos_render_scene_core_memory_pools__IHandle<PoolType.NODE>;
        export enum NodeView {
            DIRTY_FLAG = 0,
            LAYER = 1,
            WORLD_SCALE = 2,
            WORLD_POSITION = 5,
            WORLD_ROTATION = 8,
            WORLD_MATRIX = 12,
            LOCAL_SCALE = 28,
            LOCAL_POSITION = 31,
            LOCAL_ROTATION = 34,
            COUNT = 38
        }
        export const NodePool: __private._cocos_render_scene_core_memory_pools__BufferPool<PoolType.NODE, typeof NodeView>;
        export type PassHandle = __private._cocos_render_scene_core_memory_pools__IHandle<PoolType.PASS>;
        export enum PassView {
            PRIORITY = 0,
            STAGE = 1,
            PHASE = 2,
            PRIMITIVE = 3,
            BATCHING_SCHEME = 4,
            DYNAMIC_STATE = 5,
            HASH = 6,
            COUNT = 7
        }
        export const PassPool: __private._cocos_render_scene_core_memory_pools__BufferPool<PoolType.PASS, typeof PassView>;
        export type AABBHandle = __private._cocos_render_scene_core_memory_pools__IHandle<PoolType.AABB>;
        export enum AABBView {
            CENTER = 0,
            HALFEXTENTS = 3,
            COUNT = 6
        }
        export const AABBPool: __private._cocos_render_scene_core_memory_pools__BufferPool<PoolType.AABB, typeof AABBView>;
        export interface IRenderSceneInfo {
            name: string;
        }
        export interface ISceneNodeInfo {
            name: string;
            isStatic?: boolean;
        }
        /**
         * @en The result of one raycast operation
         * @zh һ߼Ľ
         */
        export interface IRaycastResult {
            node: Node;
            distance: number;
        }
        /**
         * @en The render scene which is created by the [[Root]] and provides all basic render scene elements for the render process.
         * It manages:
         * 1. [[Camera]]s
         * 2. [[Light]]s
         * 3. Renderable objects: [[renderer.Model]]s and `DrawBatchs`
         * @zh Ⱦ [[Root]] ṩȾ̵гԪء
         * 1. [[Camera]]s
         * 2. [[Light]]sԴ
         * 3. ȾԪأ[[renderer.Model]]s  `DrawBatchs`
         */
        export class RenderScene {
            /**
             * @en The root manager of the renderer.
             * @zh Ⱦ
             */
            get root(): Root;
            /**
             * @en The name of the render scene.
             * @zh Ⱦơ
             */
            get name(): string;
            /**
             * @en All cameras of the render scene.
             * @zh Ⱦ
             */
            get cameras(): scene.Camera[];
            /**
             * @en The main directional light source of the render scene.
             * @zh ȾԴ
             */
            get mainLight(): scene.DirectionalLight | null;
            /**
             * @en All sphere light sources of the render scene.
             * @zh ȾԴ
             */
            get sphereLights(): Readonly<scene.SphereLight[]>;
            /**
             * @en All spot light sources of the render scene.
             * @zh Ⱦо۹ƹԴ
             */
            get spotLights(): Readonly<scene.SpotLight[]>;
            /**
             * @en All point light sources of the render scene.
             * @zh ȾеԴ
             */
            get pointLights(): Readonly<scene.PointLight[]>;
            /**
             * @en All ranged directional light sources of the render scene.
             * @zh ȾзΧƽйԴ
             */
            get rangedDirLights(): Readonly<scene.RangedDirectionalLight[]>;
            /**
             * @en All active models of the render scene.
             * @zh Ⱦģ͡
             */
            get models(): scene.Model[];
            /**
             * @en All active 2d draw batches of the render scene.
             * @zh Ⱦ 2D Ⱦζ
             */
            get batches(): __private._cocos_2d_renderer_draw_batch__DrawBatch2D[];
            /**
             * Register the creation function of the render scene to root.
             * @internal
             */
            static registerCreateFunc(root: Root): void;
            constructor(root: Root);
            /**
             * @en Initialize the render scene
             * @zh ʼȾ
             * @returns Successful
             */
            initialize(info: IRenderSceneInfo): boolean;
            /**
             * @en The update process of the render scene, it updates all rendering related data for the lights and the models.
             * @zh Ⱦĸ̣йԴģ͵Ⱦݡ
             * @param stamp The update time stamp
             * @returns void
             */
            update(stamp: number): void;
            /**
             * @en Destroy the render scene, dangerous, please do not invoke manually.
             * @zh Ⱦ벻Ҫֶ٣δ֪Ϊ
             */
            destroy(): void;
            isCulledByLod(camera: scene.Camera, model: scene.Model): boolean;
            /**
             * @en Attach a camera to the render scene
             * @zh Ⱦһ
             */
            addCamera(cam: scene.Camera): void;
            /**
             * @en Detach a camera to the render scene
             * @zh ȾƳһ
             */
            removeCamera(camera: scene.Camera): void;
            /**
             * @en Detach all cameras to the render scene
             * @zh ȾƳ
             */
            removeCameras(): void;
            /**
             * @en Sets the main light source for the render scene
             * @zh ȾԴ
             * @param dl The main directional light source
             */
            setMainLight(dl: scene.DirectionalLight | null): void;
            /**
             * @en Remove the main light source from the render scene
             * @zh ȾƳԴ
             * @param dl The main directional light source, if it's not the actual main light, nothing happens.
             */
            unsetMainLight(dl: scene.DirectionalLight): void;
            /**
             * @en Add a directional light source, only one directional light is active and act as the main light source.
             * @zh һԴֻһЧģһΪԴ
             * @param dl The directional light.
             */
            addDirectionalLight(dl: scene.DirectionalLight): void;
            /**
             * @en Remove a directional light source.
             * @zh ɾһԴ
             * @param dl The directional light.
             */
            removeDirectionalLight(dl: scene.DirectionalLight): void;
            /**
             * @en Add a sphere light source.
             * @zh һԴ
             * @param pl The sphere light.
             */
            addSphereLight(pl: scene.SphereLight): void;
            /**
             * @en Remove a sphere light source.
             * @zh ɾһԴ
             * @param pl The sphere light.
             */
            removeSphereLight(pl: scene.SphereLight): void;
            /**
             * @en Add a spot light source.
             * @zh һ۹ƹԴ
             * @param sl The spot light.
             */
            addSpotLight(sl: scene.SpotLight): void;
            /**
             * @en Remove a spot light source.
             * @zh ɾһ۹ƹԴ
             * @param sl The spot light.
             */
            removeSpotLight(sl: scene.SpotLight): void;
            /**
             * @en Remove all sphere light sources.
             * @zh ɾԴ
             */
            removeSphereLights(): void;
            /**
             * @en Remove all spot light sources.
             * @zh ɾо۹ƹԴ
             */
            removeSpotLights(): void;
            /**
             * @en Add a point light source.
             * @zh һԴ
             * @param pl @en The point light. @zh Դ
             */
            addPointLight(pl: scene.PointLight): void;
            /**
             * @en Remove a sphere light source.
             * @zh ɾһԴ
             * @param pl @en The point light. @zh Դ
             */
            removePointLight(pl: scene.PointLight): void;
            /**
             * @en Remove all point light sources.
             * @zh ɾеԴ
             */
            removePointLights(): void;
            /**
             * @en Add a ranged directional light source.
             * @zh һΧƽйԴ
             * @param l @en The ranged directional light. @zh Χƽй⡣
             */
            addRangedDirLight(l: scene.RangedDirectionalLight): void;
            /**
             * @en Remove a ranged directional light source.
             * @zh ɾһΧƽйԴ
             * @param l @en The ranged directional light. @zh Χƽй⡣
             */
            removeRangedDirLight(l: scene.RangedDirectionalLight): void;
            /**
             * @en Remove all ranged directional light sources.
             * @zh ɾзΧƽйԴ
             */
            removeRangedDirLights(): void;
            /**
             * @en Add a model, all models attached to the render scene will be submitted for rendering.
             * @zh һģͣȾϹصģͶᱻύȾ
             * @param m The model.
             */
            addModel(m: scene.Model): void;
            /**
             * @en Remove a model, model removed will no longer be submitted for rendering.
             * @zh ɾһģͣƳģͽٱύȾ
             * @param m The model.
             */
            removeModel(model: scene.Model): void;
            /**
             * @en Remove all models.
             * @zh ɾģ͡
             */
            removeModels(): void;
            /**
             * @en Add a draw batch of 2d objects, all draw batches attached to the render scene will be submitted for rendering.
             * @zh һ 2D ȾΣȾϹص 2D ȾζᱻύȾ
             * @param batch The draw batch.
             * @internal
             * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
             */
            addBatch(batch: __private._cocos_2d_renderer_draw_batch__DrawBatch2D): void;
            /**
             * @en Remove a draw batch of 2d objects, draw batch removed will no longer be submitted for rendering.
             * @zh ɾһ 2D ȾΣƳ 2D ȾνٱύȾ
             * @param batch The draw batch.
             * @internal
             * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
             */
            removeBatch(batch: __private._cocos_2d_renderer_draw_batch__DrawBatch2D): void;
            /**
             * @en Remove all 2d draw batches.
             * @zh ɾ 2D ȾΡ
             * @internal
             * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
             */
            removeBatches(): void;
            /**
             * @en Notify all models that the global pipeline state have been updated so that they can update their render data and states.
             * @zh ֪ͨģȫֹ״̬Ѹ£Ҫ״̬
             */
            onGlobalPipelineStateChanged(): void;
            /**
             * @en Generate a new model id.
             * @zh һµģ ID
             * @returns The model id
             */
            generateModelId(): number;
        }
        export const CameraVisFlags: {};
        export const VisibilityFlags: {};
    }
    export type Constructor<T = unknown> = __private.__types_globals__Constructor<T>;
    export namespace math {
        export namespace bits {
            /**
             * @en Returns -1, 0, +1 depending on sign of x.
             * @zh xķŷ -10+1
             */
            export function sign(v: number): number;
            /**
             * @en Computes absolute value of integer.
             * @zh ľֵ
             */
            export function abs(v: number): number;
            /**
             * @en Computes minimum of integers x and y.
             * @zh xyеСֵ
             */
            export function min(x: number, y: number): number;
            /**
             * @en Computes maximum of integers x and y.
             * @zh xyеֵ
             */
            export function max(x: number, y: number): number;
            /**
             * @en Checks if a number is a power of two.
             * @zh һǷ2ݡ
             */
            export function isPow2(v: number): boolean;
            /**
             * @en Computes log base 2 of v.
             * @zh  2 Ϊ׵ v Ķ
             */
            export function log2(v: number): number;
            /**
             * @en Computes log base 10 of v.
             * @zh  10 Ϊ׵ v Ķ
             */
            export function log10(v: number): number;
            /**
             * @en Counts number of bits.
             * @zh 㴫ֶƱʾ 1 
             */
            export function popCount(v: number): number;
            /**
             * @en Counts number of trailing zeros.
             * @zh 㴫ֶƱʾβ
             */
            export function countTrailingZeros(v: number): number;
            /**
             * @en Rounds to next power of 2.
             * @zh ڵvСĶݵ֡
             */
            export function nextPow2(v: number): number;
            /**
             * @en Rounds down to previous power of 2.
             * @zh СڵvСĶݵ֡
             */
            export function prevPow2(v: number): number;
            /**
             * @en Computes parity of word.
             * @zh żУ顣
             */
            export function parity(v: number): number;
            /**
             * @en Reverse bits in a 32 bit word.
             * @zh ת 32 λ֡
             */
            export function reverse(v: number): number;
            /**
             * @en Interleave bits of 2 coordinates with 16 bits. Useful for fast quadtree codes.
             * @zh  16 λְλ롣ڿĲʹá
             */
            export function interleave2(x: number, y: number): number;
            /**
             * @en Extracts the nth interleaved component.
             * @zh ȡ n 
             */
            export function deinterleave2(v: number, n: number): number;
            /**
             * @en Interleave bits of 3 coordinates, each with 10 bits.  Useful for fast octree codes.
             * @zh ְλ룬ÿռʮλڰ˲ʹá
             */
            export function interleave3(x: number, y: number, z: number): number;
            /**
             * @en Extracts nth interleaved component of a 3-tuple.
             * @zh ȡеĵn
             */
            export function deinterleave3(v: number, n: number): number;
            /**
             * @en Compute the lexicographically next bit permutation
             * @zh һֵı
             */
            export function nextCombination(v: number): number;
            /**
             * Bit twiddling hacks for JavaScript.
             *
             * Author: Mikola Lysenko
             *
             * Ported from Stanford bit twiddling hack library:
             *    http://graphics.stanford.edu/~seander/bithacks.html
             */
            /**
             * @en
             * Number of bits in an integer
             * @zh
             * ͵ bit 
             */
            export const INT_BITS = 32;
            /**
             * @en
             * The maximal signed integer number
             * @zh
             * з
             */
            export const INT_MAX = 2147483647;
            /**
             * @en
             * The minimal signed integer number
             * @zh
             * Сз
             */
            export const INT_MIN: number;
        }
        /**
         * @en Representation of 2D vectors and points.
         * @zh ά
         */
        export class Vec2 extends ValueType {
            static ZERO: Readonly<Vec2>;
            static ONE: Readonly<Vec2>;
            static NEG_ONE: Readonly<Vec2>;
            static UNIT_X: Readonly<Vec2>;
            static UNIT_Y: Readonly<Vec2>;
            /**
             * @en Obtains a clone of the given vector object
             * @zh ָĿ
             */
            static clone<Out extends IVec2Like>(a: Out): Vec2;
            /**
             * @en Copy the target vector and save the results to out vector object
             * @zh Ŀ
             */
            static copy<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the out vector with the given x and y values
             * @zh ֵ
             */
            static set<Out extends IVec2Like>(out: Out, x: number, y: number): Out;
            /**
             * @en Element-wise vector addition and save the results to out vector object
             * @zh Ԫӷ
             */
            static add<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector subtraction and save the results to out vector object
             * @zh Ԫ
             */
            static subtract<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector multiplication and save the results to out vector object
             * @zh Ԫ˷
             */
            static multiply<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector division and save the results to out vector object
             * @zh Ԫ
             */
            static divide<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Rounds up by elements of the vector and save the results to out vector object
             * @zh Ԫȡ
             */
            static ceil<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Element-wise rounds down of the current vector and save the results to the out vector
             * @zh Ԫȡ
             */
            static floor<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates element-wise minimum values and save to the out vector
             * @zh ԪСֵ
             */
            static min<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Calculates element-wise maximum values and save to the out vector
             * @zh Ԫֵ
             */
            static max<Out extends IVec2Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Calculates element-wise round results and save to the out vector
             * @zh Ԫȡ
             */
            static round<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Vector scalar multiplication and save the results to out vector object
             * @zh ˷
             */
            static multiplyScalar<Out extends IVec2Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Element-wise multiplication and addition with the equation: a + b * scale
             * @zh Ԫ˼: A + B * scale
             */
            static scaleAndAdd<Out extends IVec2Like>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Calculates the euclidean distance of two vectors
             * @zh ŷϾ
             */
            static distance<Out extends IVec2Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the squared euclidean distance of two vectors
             * @zh ŷϾƽ
             */
            static squaredDistance<Out extends IVec2Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the length of the vector
             * @zh 
             */
            static len<Out extends IVec2Like>(a: Out): number;
            /**
             * @en Calculates the squared length of the vector
             * @zh ƽ
             */
            static lengthSqr<Out extends IVec2Like>(a: Out): number;
            /**
             * @en Sets each element to its negative value
             * @zh Ԫȡ
             */
            static negate<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Sets each element to its inverse value, zero value will become Infinity
             * @zh Ԫȡӽ 0 ʱ Infinity
             */
            static inverse<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Sets each element to its inverse value, zero value will remain zero
             * @zh Ԫȡӽ 0 ʱ 0
             */
            static inverseSafe<Out extends IVec2Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the normalized vector to the out vector, returns a zero vector if input is a zero vector.
             * @zh һ᷵
             */
            static normalize<Out extends IVec2Like, Vec2Like extends IVec2Like>(out: Out, a: Vec2Like): Out;
            /**
             * @en Calculates the dot product of the vector
             * @zh 
             */
            static dot<Out extends IVec2Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the cross product of the vector
             * @zh עάĲΪ Z ƽеά
             * @override (a:Vec2, b:Vec2) => number
             * @override [deprecated] (out:Vec3, a:Vec2, b:Vec2) => Vec3
             */
            static cross(a: IVec2Like, b: IVec2Like): number;
            /**
             * @deprecated Consider use another overrides please.
             */
            static cross<Out extends IVec2Like>(out: Vec3, a: Out, b: Out): Vec3;
            /**
             * @en Calculates the linear interpolation between two vectors with a given ratio: A + t * (B - A)
             * @zh ԪԲֵ A + t * (B - A)
             */
            static lerp<Out extends IVec2Like>(out: Out, a: Out, b: Out, t: number): Out;
            /**
             * @en Generates a uniformly distributed random vector points from center to the surface of the unit sphere
             * @zh һڵλԲϾȷֲ
             * @param scale vector length
             */
            static random<Out extends IVec2Like>(out: Out, scale?: number): Out;
            /**
             * @en Vector and third order matrix multiplication, will complete the vector with a third value as one
             * @zh ά˷ĬλΪ 1
             */
            static transformMat3<Out extends IVec2Like, MatLike extends IMat3Like>(out: Out, a: Out, m: IMat3Like): Out;
            /**
             * @en Vector and third order matrix multiplication, will complete the vector with a third and a fourth element as one
             * @zh ά˷ĬλΪ 0λΪ 1
             */
            static transformMat4<Out extends IVec2Like, MatLike extends IMat4Like>(out: Out, a: Out, m: IMat4Like): Out;
            /**
             * @en Gets the string representation of the given vector
             * @zh ַʾ
             */
            static str<Out extends IVec2Like>(a: Out): string;
            /**
             * @en Converts the given vector to an array
             * @zh ת
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, v: IVec2Like, ofs?: number): Out;
            /**
             * @en Converts the given array to a vector
             * @zh ת
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IVec2Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Check the equality of the two given vectors
             * @zh ȼж
             */
            static strictEquals<Out extends IVec2Like>(a: Out, b: Out): boolean;
            /**
             * @en Check whether the two given vectors are approximately equivalent
             * @zh ųƵȼж
             */
            static equals<Out extends IVec2Like>(a: Out, b: Out, epsilon?: number): boolean;
            /**
             * @en Calculates the radian angle between two vectors, returns zero if either vector is a zero vector.
             * @zh нǻȣһ򷵻㡣
             */
            static angle<Out extends IVec2Like>(a: Out, b: Out): number;
            /**
             * @en x component.
             * @zh x 
             */
            x: number;
            /**
             * @en y component.
             * @zh y 
             */
            y: number;
            constructor(other: Vec2);
            constructor(x?: number, y?: number);
            /**
             * @en clone a Vec2 value
             * @zh ¡ǰ
             */
            clone(): Vec2;
            /**
             * @en Set the current vector value with the given vector.
             * @zh õǰʹָȡ
             * @param other Specified vector
             * @return `this`
             */
            set(other: Vec2): Vec2;
            /**
             * @en Set the value of each component of the current vector.
             * @zh õǰľֵ
             * @param x x value
             * @param y y value
             * @return `this`
             */
            set(x?: number, y?: number): Vec2;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh жϵǰǷΧָȡ
             * @param other Specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @return Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals(other: Vec2, epsilon?: number): boolean;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh жϵǰǷΧָȡ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @return Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals2f(x: number, y: number, epsilon?: number): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec2.
             * @zh жϵǰǷָȡ
             * @param other specified vector
             * @return Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals(other: Vec2): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec2.
             * @zh жϵǰǷָȡ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @return Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals2f(x: number, y: number): boolean;
            /**
             * @en Transform to string with vector information.
             * @zh صǰַʾ
             * @returns The string with vector information
             */
            toString(): string;
            /**
             * @en Calculate linear interpolation result between this vector and another one with given ratio.
             * @zh ָĲֵʣӵǰĿֵ֮
             * @param to Target vector
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Vec2, ratio: number): Vec2;
            /**
             * @en Clamp the vector between minInclusive and maxInclusive.
             * @zh õǰֵʹָķΧڡ
             * @param minInclusive Minimum value allowed
             * @param maxInclusive Maximum value allowed
             * @return `this`
             */
            clampf(minInclusive: Vec2, maxInclusive: Vec2): Vec2;
            /**
             * @en Adds the current vector with another one and return this
             * @zh ӷǰָ
             * @param other specified vector
             */
            add(other: Vec2): Vec2;
            /**
             * @en Adds the current vector with another one and return this
             * @zh ӷǰָ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             */
            add2f(x: number, y: number): Vec2;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh ǰȥָ
             * @param other specified vector
             */
            subtract(other: Vec2): Vec2;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh ǰȥָ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             */
            subtract2f(x: number, y: number): Vec2;
            /**
             * @en Multiplies the current vector with a number, and returns this.
             * @zh ˡǰָ
             * @param scalar scalar number
             */
            multiplyScalar(scalar: number): Vec2;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh ˷ǰָĽֵǰ
             * @param other specified vector
             */
            multiply(other: Vec2): Vec2;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh ˷ǰָ˵Ľֵǰ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             */
            multiply2f(x: number, y: number): Vec2;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh ԪǰָĽֵǰ
             * @param other specified vector
             */
            divide(other: Vec2): Vec2;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh ԪǰָĽֵǰ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             */
            divide2f(x: number, y: number): Vec2;
            /**
             * @en Sets each component of this vector with its negative value
             * @zh ǰĸȡ
             */
            negative(): Vec2;
            /**
             * @en Calculates the dot product with another vector
             * @zh ˡ
             * @param other specified vector
             * @return The result of calculates the dot product with another vector
             */
            dot(other: Vec2): number;
            /**
             * @en Calculates the cross product with another vector.
             * @zh ˡ
             * @param other specified vector
             * @return `out`
             */
            cross(other: Vec2): number;
            /**
             * @en Returns the length of this vector.
             * @zh ĳȣģ
             * @return Length of vector
             */
            length(): number;
            /**
             * @en Returns the squared length of this vector.
             * @zh ȣģƽ
             * @return the squared length of this vector
             */
            lengthSqr(): number;
            /**
             * @en Normalize the current vector.
             * @zh ǰһ
             */
            normalize(): Vec2;
            /**
             * @en Calculates radian angle between two vectors, returns zero if either vector is a zero vector.
             * @zh ȡǰָ֮Ļȣһ򷵻㡣
             * @param other specified vector.
             * @return The angle between the current vector and the specified vector.
             */
            angle(other: Vec2): number;
            /**
             * @en Get angle in radian between this and vector with direction.
             * @zh ȡǰָ֮зŻȡ<br/>
             * зŻȵȡֵΧΪ (-PI, PI]ǰͨʱתзŽǶָͬ<br/>
             * @param other specified vector
             * @return The signed angle between the current vector and the specified vector (in radians);
             * if there is a zero vector in the current vector and the specified vector, 0 is returned.
             */
            signAngle(other: Vec2): number;
            /**
             * @en Rotates the current vector by an angle in radian value. Counterclockwise is the positive direction.
             * @zh ǰתʱΪ
             * @param radians radians of rotation.
             */
            rotate(radians: number): Vec2;
            /**
             * @en Projects the current vector on another one
             * @zh 㵱ǰָϵͶӰ
             * @param other specified vector
             */
            project(other: Vec2): Vec2;
            /**
             * @en Transforms the vec2 with a mat4. 3rd vector component is implicitly '0', 4th vector component is implicitly '1'
             * @zh ǰΪ z Ϊ 0w Ϊ 1 ά<br/>
             * Ӧά任ǰ<br/>
             * @param matrix matrix to transform with
             */
            transformMat4(matrix: Mat4): Vec2;
        }
        export function v2(other: Vec2): Vec2;
        export function v2(x?: number, y?: number): Vec2;
        /**
         * @en Representation of 3D vectors and points.
         * @zh ά
         */
        export class Vec3 extends ValueType {
            static UNIT_X: Readonly<Vec3>;
            static UNIT_Y: Readonly<Vec3>;
            static UNIT_Z: Readonly<Vec3>;
            static RIGHT: Readonly<Vec3>;
            static UP: Readonly<Vec3>;
            static FORWARD: Readonly<Vec3>;
            static ZERO: Readonly<Vec3>;
            static ONE: Readonly<Vec3>;
            static NEG_ONE: Readonly<Vec3>;
            /**
             * @en return a Vec3 object with x = 0, y = 0, z = 0.
             * @zh Ŀ긳ֵΪ
             */
            static zero<Out extends IVec3Like>(out: Out): Out;
            /**
             * @en Obtains a clone of the given vector object
             * @zh ָĿ
             */
            static clone<Out extends IVec3Like>(a: Out): Vec3;
            /**
             * @en Copy the target vector and save the results to out vector object
             * @zh Ŀ
             */
            static copy<Out extends IVec3Like, Vec3Like extends IVec3Like>(out: Out, a: Vec3Like): Out;
            /**
             * @en Sets the out vector with the given x, y and z values
             * @zh ֵ
             */
            static set<Out extends IVec3Like>(out: Out, x: number, y: number, z: number): Out;
            /**
             * @en Element-wise vector addition and save the results to out vector object
             * @zh Ԫӷ
             */
            static add<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Element-wise vector subtraction and save the results to out vector object
             * @zh Ԫ
             */
            static subtract<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Element-wise vector multiplication and save the results to out vector object
             * @zh Ԫ˷ ()
             */
            static multiply<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Element-wise vector division and save the results to out vector object
             * @zh Ԫ
             */
            static divide<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Rounds up by elements of the vector and save the results to out vector object
             * @zh Ԫȡ
             */
            static ceil<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Element-wise rounds down of the current vector and save the results to the out vector
             * @zh Ԫȡ
             */
            static floor<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Calculates element-wise minimum values and save to the out vector
             * @zh ԪСֵ
             */
            static min<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Calculates element-wise maximum values and save to the out vector
             * @zh Ԫֵ
             */
            static max<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Calculates element-wise round results and save to the out vector
             * @zh Ԫȡ
             */
            static round<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Vector scalar multiplication and save the results to out vector object
             * @zh ˷
             */
            static multiplyScalar<Out extends IVec3Like, Vec3Like extends IVec3Like>(out: Out, a: Vec3Like, b: number): Out;
            /**
             * @en Element-wise multiplication and addition with the equation: a + b * scale
             * @zh Ԫ˼: A + B * scale
             */
            static scaleAndAdd<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like, scale: number): Out;
            /**
             * @en Calculates the euclidean distance of two vectors
             * @zh ŷϾ
             */
            static distance(a: IVec3Like, b: IVec3Like): number;
            /**
             * @en Calculates the squared euclidean distance of two vectors
             * @zh ŷϾƽ
             */
            static squaredDistance(a: IVec3Like, b: IVec3Like): number;
            /**
             * @en Calculates the length of the vector
             * @zh 
             */
            static len(a: IVec3Like): number;
            /**
             * @en Calculates the squared length of the vector
             * @zh ƽ
             */
            static lengthSqr(a: IVec3Like): number;
            /**
             * @en Sets each element to its negative value
             * @zh Ԫȡ
             */
            static negate<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Sets each element to its inverse value, zero value will become Infinity
             * @zh Ԫȡӽ 0 ʱ Infinity
             */
            static invert<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Sets each element to its inverse value, zero value will remain zero
             * @zh Ԫȡӽ 0 ʱ 0
             */
            static invertSafe<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Sets the normalized vector to the out vector, returns a zero vector if input is a zero vector.
             * @zh һ᷵
             */
            static normalize<Out extends IVec3Like>(out: Out, a: IVec3Like): Out;
            /**
             * @en Calculates the dot product of the vector
             * @zh 
             */
            static dot<Out extends IVec3Like>(a: Out, b: IVec3Like): number;
            /**
             * @en Calculates the cross product of the vector
             * @zh 
             */
            static cross<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Calculates the linear interpolation between two vectors with a given ratio: A + t * (B - A)
             * @zh ԪԲֵ A + t * (B - A)
             */
            static lerp<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like, t: number): Out;
            /**
             * @zh Բֵڲֵ
             * @en Spherical linear interpolation. Commonly used in interpolation between directional vectors.
             * @param out @zh  @en Output vector.
             * @param from @zh  @en Start vector.
             * @param to @zh յ @en Destination vector.
             * @param t @zh ֵ@en Interpolation parameter.
             * @returns `out`
             * @description
             * @zh
             * -  `from``to` κһӽ `from`  `to` ԲֵĽ
             *
             * -  `from``to` պýӽ෴
             * һļн֮ `t`䳤 `from`  `to` ĳԲֵĽ
             *
             * - 򣬽Ǵӱ׼ `from`  ׼ `to`
             * ԲֵĽ `from`  `to` ĳԲֵĳȡ
             * @en
             * - If either `from` or `to` is close to zero vector,
             * the result would be the (non-spherical) linear interpolation result from `from` to `to`.
             *
             * - Otherwise, if `from` and `to` have almost opposite directions,
             * the result would be such a vector so that:
             * The angle ratio between result vector and input vectors is `t`,
             * the length of result vector is the linear interpolation of lengths from `from` to `to`.
             *
             * - Otherwise, the result would be the spherical linear interpolation result
             * from normalized `from` to normalized `to`,
             * then scaled by linear interpolation of lengths from `from` to `to`.
             */
            static slerp: <Out extends IVec3Like>(out: Out, from: Readonly<IVec3Like>, to: Readonly<IVec3Like>, t: number) => Out;
            /**
             * @en Generates a uniformly distributed random vector points from center to the surface of the unit sphere
             * @zh һڵλϾȷֲ
             * @param scale vector length
             */
            static random<Out extends IVec3Like>(out: Out, scale?: number): Out;
            /**
             * @en Vector and fourth order matrix multiplication, will complete the vector with a fourth value as one
             * @zh ά˷ĬλΪ 1
             */
            static transformMat4<Out extends IVec3Like>(out: Out, a: IVec3Like, m: IMat4Like): Out;
            /**
             * @en Vector and fourth order matrix multiplication, will complete the vector with a fourth element as one
             * @zh ά˷ĬλΪ 0
             */
            static transformMat4Normal<Out extends IVec3Like>(out: Out, a: IVec3Like, m: IMat4Like): Out;
            /**
             * @en Vector and third order matrix multiplication
             * @zh ά˷
             */
            static transformMat3<Out extends IVec3Like>(out: Out, a: IVec3Like, m: IMat3Like): Out;
            /**
             * @en Affine transformation vector
             * @zh 任
             */
            static transformAffine<Out extends IVec3Like>(out: Out, v: IVec3Like, m: IMat4Like): Out;
            /**
             * @en Vector quaternion multiplication: q*a*q^{-1}.
             * @zh Ԫ˷q*a*q^{-1}
             */
            static transformQuat<Out extends IVec3Like>(out: Out, a: IVec3Like, q: IQuatLike): Out;
            /**
             * @en Transforms the current vector with given scale, rotation and translation in order
             * @zh  -> ת -> ƽ˳任
             */
            static transformRTS<Out extends IVec3Like>(out: Out, a: IVec3Like, r: IQuatLike, t: IVec3Like, s: IVec3Like): Out;
            /**
             * @en Transforms the current vector with given scale, rotation and translation in reverse order
             * @zh ƽ -> ת -> ˳任
             */
            static transformInverseRTS<Out extends IVec3Like>(out: Out, a: IVec3Like, r: IQuatLike, t: IVec3Like, s: IVec3Like): Out;
            /**
             * @en Rotates the vector with specified angle around X axis
             * @zh  X תָ
             * @param v rotation vector
             * @param o center of rotation
             * @param a radiance of rotation
             */
            static rotateX<Out extends IVec3Like>(out: Out, v: IVec3Like, o: IVec3Like, a: number): Out;
            /**
             * @en Rotates the vector with specified angle around Y axis
             * @zh  Y תָ
             * @param v rotation vector
             * @param o center of rotation
             * @param a radiance of rotation
             */
            static rotateY<Out extends IVec3Like>(out: Out, v: IVec3Like, o: IVec3Like, a: number): Out;
            /**
             * @en Rotates the vector with specified angle around Z axis
             * @zh  Z תָ
             * @param v rotation vector
             * @param o center of rotation
             * @param a radiance of rotation
             */
            static rotateZ<Out extends IVec3Like>(out: Out, v: IVec3Like, o: IVec3Like, a: number): Out;
            /**
             * @en Rotates the vector with specified angle around any n axis
             * @zh  n תָ
             * @param v rotation vector
             * @param o center of rotation
             * @param n axis of rotation
             * @param a radiance of rotation
             */
            static rotateN<Out extends IVec3Like>(out: Out, v: IVec3Like, o: IVec3Like, n: IVec3Like, a: number): Out;
            /**
             * @en Converts the given vector to an array
             * @zh ת
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, v: IVec3Like, ofs?: number): Out;
            /**
             * @en Converts the given array to a vector
             * @zh ת
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IVec3Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Check the equality of the two given vectors
             * @zh ȼж
             */
            static strictEquals(a: IVec3Like, b: IVec3Like): boolean;
            /**
             * @en Check whether the two given vectors are approximately equivalent
             * @zh ųƵȼж
             */
            static equals(a: IVec3Like, b: IVec3Like, epsilon?: number): boolean;
            /**
             * @en Calculates the radian angle between two vectors
             * @zh нǻ
             */
            static angle(a: IVec3Like, b: IVec3Like): number;
            /**
             * @zh  `a``b` ֮зżнǡ
             *
             *  `a``b` ӱϵָ룬 `a` ָ 12 `normal` κδӱָ
             *  `b` **ʱ**  12 ߵ 6 ĹУǵĽǶȱ仯ΧΪ (0, 180)
             *  `b` **˳ʱ**  12 ߵ 6 ĹУǵĽǶȱ仯ΧΪ (0, -180)
             *
             * ֮ `normal` κδӱַָΧԵ
             *
             * @en Calculates the signed angle between the two vectors `a`, `b`.
             *
             * Suppose that `a` and `b` are two hands on a clock, where pointing at 12 o'clock,
             * and `normal` is arbitrary vector pointing out from the dial side of the clock.
             * As `b` goes counterclockwise from 12 o'clock to 6 o'clock, their angle varies in the range (0, 180);
             * As `b` goes clockwise from 12 o'clock to 6 o'clock, their angle varies in the range (0, -180).
             *
             * Instead, if `normal` is arbitrary vector pointing out from the opposite side of the clock,
             * the two ranges would swap.
             *
             * @param a @zh  `a` @en The vector `a`.
             * @param b @zh  `b` @en The vector `b`.
             * @param normal @zh ο @en The reference vector.
             * @returns @zh  `a`  `b` ֮зżнǡ @en The signed angle between `a`, `b`.
             */
            static signedAngle: (a: Readonly<IVec3Like>, b: Readonly<IVec3Like>, normal: Readonly<IVec3Like>) => number;
            /**
             * @en Calculates the projection vector on the specified plane
             * @zh ָƽϵͶӰ
             * @param a projection vector
             * @param n the normal line of specified plane
             */
            static projectOnPlane<Out extends IVec3Like>(out: Out, a: IVec3Like, n: IVec3Like): Out;
            /**
             * @en Calculates the projection on the specified vector
             * @zh ָϵͶӰ
             * @param a projection vector
             * @param b target vector
             */
            static project<Out extends IVec3Like>(out: Out, a: IVec3Like, b: IVec3Like): Out;
            /**
             * @en Calculates a new position from current to target no more than `maxStep` distance.
             * @zh һλôӵǰλƶ `maxStep` 뵽Ŀλá
             * @param current current position
             * @param target target position
             * @param maxStep maximum moving distance
             */
            static moveTowards<Out extends IVec3Like>(out: Out, current: IVec3Like, target: IVec3Like, maxStep: number): Out;
            /**
             * @zh ָһλָ **ȷ** 򷵻 **ȷ** 
             * @en Generates an unit vector orthogonal to specified vector.
             * If the specified vector is **strictly** zero vector, the result is **strict** zero vector.
             * @param out @zh ɵ@en The generated vector.
             * @param n @zh  **** Ǳ׼ġ @en The input vector. **Need not** to be normalized.
             * @returns `out`
             */
            static generateOrthogonal<Out extends IVec3Like>(out: Out, n: Readonly<IVec3Like>): Out;
            /**
             * @en x component.
             * @zh x 
             */
            x: number;
            /**
             * @en y component.
             * @zh y 
             */
            y: number;
            /**
             * @en z component.
             * @zh z 
             */
            z: number;
            constructor(v: Vec3);
            constructor(x?: number, y?: number, z?: number);
            /**
             * @en clone a Vec3 value
             * @zh ¡ǰ
             */
            clone(): Vec3;
            /**
             * @en Set the current vector value with the given vector.
             * @zh õǰʹָȡ
             * @param other Specified vector
             * @returns `this`
             */
            set(other: Vec3): Vec3;
            /**
             * @en Set the value of each component of the current vector.
             * @zh õǰľֵ
             * @param x x value
             * @param y y value
             * @param z z value
             * @returns `this`
             */
            set(x?: number, y?: number, z?: number): Vec3;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh жϵǰǷΧָȡ
             * @param other Specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals(other: Vec3, epsilon?: number): boolean;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh жϵǰǷΧָȡ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals3f(x: number, y: number, z: number, epsilon?: number): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec3.
             * @zh жϵǰǷָȡ
             * @param other specified vector
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals(other: Vec3): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec3.
             * @zh жϵǰǷָȡ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals3f(x: number, y: number, z: number): boolean;
            /**
             * @en Transform to string with vector information.
             * @zh صǰַʾ
             * @returns The string with vector information
             */
            toString(): string;
            /**
             * @en Calculate linear interpolation result between this vector and another one with given ratio.
             * @zh ָĲֵʣӵǰĿֵ֮
             * @param to Target vector
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Vec3, ratio: number): Vec3;
            /**
             * @en Adds the current vector with another one and return this
             * @zh ӷǰָ
             * @param other specified vector
             */
            add(other: Vec3): Vec3;
            /**
             * @en Adds the current vector with another one and return this
             * @zh ӷǰָ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             */
            add3f(x: number, y: number, z: number): Vec3;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh ǰȥָĽ
             * @param other specified vector
             */
            subtract(other: Vec3): Vec3;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh ǰȥָ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             */
            subtract3f(x: number, y: number, z: number): Vec3;
            /**
             * @en Multiplies the current vector with a number, and returns this.
             * @zh ˡǰָ
             * @param scalar scalar number
             */
            multiplyScalar(scalar: number): Vec3;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh ˷ǰָĽֵǰ
             * @param other specified vector
             */
            multiply(other: Vec3): Vec3;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh ˷ǰָ˵Ľֵǰ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             */
            multiply3f(x: number, y: number, z: number): Vec3;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh ԪǰָĽֵǰ
             * @param other specified vector
             */
            divide(other: Vec3): Vec3;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh ԪǰָĽֵǰ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             */
            divide3f(x: number, y: number, z: number): Vec3;
            /**
             * @en Sets each component of this vector with its negative value
             * @zh ǰĸȡ
             */
            negative(): Vec3;
            /**
             * @en Clamp the vector between minInclusive and maxInclusive.
             * @zh õǰֵʹָķΧڡ
             * @param minInclusive Minimum value allowed
             * @param maxInclusive Maximum value allowed
             * @returns `this`
             */
            clampf(minInclusive: Vec3, maxInclusive: Vec3): Vec3;
            /**
             * @en Calculates the dot product with another vector
             * @zh ˡ
             * @param other specified vector
             * @returns The result of calculates the dot product with another vector
             */
            dot(other: Vec3): number;
            /**
             * @en Calculates the cross product with another vector.
             * @zh ˡǰָ
             * @param other specified vector
             */
            cross(other: Vec3): Vec3;
            /**
             * @en Returns the length of this vector.
             * @zh ĳȣģ
             * @returns Length of vector
             */
            length(): number;
            /**
             * @en Returns the squared length of this vector.
             * @zh ȣģƽ
             * @returns the squared length of this vector
             */
            lengthSqr(): number;
            /**
             * @en Normalize the current vector.
             * @zh ǰһ
             */
            normalize(): Vec3;
            /**
             * @en Transforms the vec3 with a mat4. 4th vector component is implicitly '1'
             * @zh ǰΪ w Ϊ 1 άӦά任ǰ
             * @param matrix matrix to transform with
             */
            transformMat4(matrix: Mat4): Vec3;
        }
        export function v3(other: Vec3): Vec3;
        export function v3(x?: number, y?: number, z?: number): Vec3;
        /**
         * @en Representation of four-dimensional vectors.
         * @zh ά
         */
        export class Vec4 extends ValueType {
            static ZERO: Readonly<Vec4>;
            static ONE: Readonly<Vec4>;
            static NEG_ONE: Readonly<Vec4>;
            static UNIT_X: Readonly<Vec4>;
            static UNIT_Y: Readonly<Vec4>;
            static UNIT_Z: Readonly<Vec4>;
            static UNIT_W: Readonly<Vec4>;
            /**
             * @en Obtains a clone of the given vector object
             * @zh ָĿ
             */
            static clone<Out extends IVec4Like>(a: Out): Vec4;
            /**
             * @en Copy the target vector and save the results to out vector object
             * @zh Ŀ
             */
            static copy<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the out vector with the given x, y, z and w values
             * @zh ֵ
             */
            static set<Out extends IVec4Like>(out: Out, x: number, y: number, z: number, w: number): Out;
            /**
             * @en set value from color
             * @zh ɫֵ
             * @param out
             * @param color
             */
            static fromColor<Out extends IVec4Like>(out: Out, color: IColorLike): Out;
            /**
             * @en The angle between two vectors
             * @zh ֮ļн
             */
            static angle<Out extends IVec4Like>(a: Out, b: Out): number;
            /**
             * @en Element-wise vector addition and save the results to out vector object
             * @zh Ԫӷ
             */
            static add<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector subtraction and save the results to out vector object
             * @zh Ԫ
             */
            static subtract<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector multiplication and save the results to out vector object
             * @zh Ԫ˷
             */
            static multiply<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Element-wise vector division and save the results to out vector object
             * @zh Ԫ
             */
            static divide<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Rounds up by elements of the vector and save the results to out vector object
             * @zh Ԫȡ
             */
            static ceil<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Element-wise rounds down of the current vector and save the results to the out vector
             * @zh Ԫȡ
             */
            static floor<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates the minimum values by elements of the vector and save the results to the out vector
             * @zh ԪСֵ
             */
            static min<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Calculates the maximum values by elements of the vector and save the results to the out vector
             * @zh Ԫֵ
             */
            static max<Out extends IVec4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Calculates element-wise round results and save to the out vector
             * @zh Ԫȡ
             */
            static round<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Vector scalar multiplication and save the results to out vector object
             * @zh ˷
             */
            static multiplyScalar<Out extends IVec4Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Element-wise multiplication and addition with the equation: a + b * scale
             * @zh Ԫ˼: A + B * scale
             */
            static scaleAndAdd<Out extends IVec4Like>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Calculates the euclidean distance of two vectors
             * @zh ŷϾ
             */
            static distance<Out extends IVec4Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the squared euclidean distance of two vectors
             * @zh ŷϾƽ
             */
            static squaredDistance<Out extends IVec4Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the length of the vector
             * @zh 
             */
            static len<Out extends IVec4Like>(a: Out): number;
            /**
             * @en Calculates the squared length of the vector
             * @zh ƽ
             */
            static lengthSqr<Out extends IVec4Like>(a: Out): number;
            /**
             * @en Sets each element to its negative value
             * @zh Ԫȡ
             */
            static negate<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets each element to its inverse value, zero value will become Infinity
             * @zh Ԫȡӽ 0 ʱ Infinity
             */
            static inverse<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets each element to its inverse value, zero value will remain zero
             * @zh Ԫȡӽ 0 ʱ 0
             */
            static inverseSafe<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the normalized vector to the out vector, returns a zero vector if input is a zero vector.
             * @zh һ᷵
             */
            static normalize<Out extends IVec4Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates the dot product of the vector
             * @zh 
             */
            static dot<Out extends IVec4Like>(a: Out, b: Out): number;
            /**
             * @en Calculates the linear interpolation between two vectors with a given ratio
             * @zh ԪԲֵ A + t * (B - A)
             */
            static lerp<Out extends IVec4Like>(out: Out, a: Out, b: Out, t: number): Out;
            /**
             * @en Scales all ell elements of this vector by the specified scalar value
             * @zh Ԫ
             */
            static scale<Out extends IVec4Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Generates a uniformly distributed random vector points from center to the surface of the unit sphere
             * @zh һڵλϾȷֲ
             * @param scale vector length
             */
            static random<Out extends IVec4Like>(out: Out, scale?: number): Out;
            /**
             * @en Vector and fourth order matrix multiplication
             * @zh ά˷
             */
            static transformMat4<Out extends IVec4Like, MatLike extends IMat4Like>(out: Out, a: Out, m: MatLike): Out;
            /**
             * @en Transform the vector with the given affine transformation
             * @zh 任
             */
            static transformAffine<Out extends IVec4Like, VecLike extends IVec4Like, MatLike extends IMat4Like>(out: Out, v: VecLike, m: MatLike): Out;
            /**
             * @en Vector quaternion multiplication
             * @zh Ԫ˷
             */
            static transformQuat<Out extends IVec4Like, QuatLike extends IQuatLike>(out: Out, a: Out, q: QuatLike): Out;
            /**
             * @en Converts the given vector to an array
             * @zh ת
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, v: IVec4Like, ofs?: number): Out;
            /**
             * @en Converts the given array to a vector
             * @zh ת
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IVec4Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Check the equality of the two given vectors
             * @zh ȼж
             */
            static strictEquals<Out extends IVec4Like>(a: Out, b: Out): boolean;
            /**
             * @en Check whether the two given vectors are approximately equivalent
             * @zh ųƵȼж
             */
            static equals<Out extends IVec4Like>(a: Out, b: Out, epsilon?: number): boolean;
            /**
             * @en x component.
             * @zh x 
             */
            x: number;
            /**
             * @en y component.
             * @zh y 
             */
            y: number;
            /**
             * @en z component.
             * @zh z 
             */
            z: number;
            /**
             * @en w component.
             * @zh w 
             */
            w: number;
            constructor(other: Vec4);
            constructor(x?: number, y?: number, z?: number, w?: number);
            /**
             * @en clone the current Vec4 value.
             * @zh ¡ǰ
             */
            clone(): Vec4;
            /**
             * @en Set the current vector value with the given vector.
             * @zh õǰʹָȡ
             * @param other Specified vector
             * @returns `this`
             */
            set(other: Vec4): Vec4;
            /**
             * @en Set the value of each component of the current vector.
             * @zh õǰľֵ
             * @param x x value
             * @param y y value
             * @param z z value
             * @param w w value
             * @returns `this`
             */
            set(x?: number, y?: number, z?: number, w?: number): Vec4;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh жϵǰǷΧָȡ
             * @param other Specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals(other: Vec4, epsilon?: number): boolean;
            /**
             * @en Check whether the vector approximately equals another one.
             * @zh жϵǰǷΧָȡ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            equals4f(x: number, y: number, z: number, w: number, epsilon?: number): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec4.
             * @zh жϵǰǷָȡ
             * @param other specified vector
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals(other: Vec4): boolean;
            /**
             * @en Check whether the current vector strictly equals another Vec4.
             * @zh жϵǰǷָȡ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             * @returns Returns `true` when the components of both vectors are equal within the specified range of error; otherwise it returns `false`.
             */
            strictEquals4f(x: number, y: number, z: number, w: number): boolean;
            /**
             * @en Calculate linear interpolation result between this vector and another one with given ratio.
             * @zh ָĲֵʣӵǰĿֵ֮
             * @param to Target vector
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Vec4, ratio: number): Vec4;
            /**
             * @en Return the information of the vector in string
             * @zh صǰַʾ
             * @returns The string with vector information
             */
            toString(): string;
            /**
             * @en Clamp the vector between minInclusive and maxInclusive.
             * @zh õǰֵʹָķΧڡ
             * @param minInclusive Minimum value allowed
             * @param maxInclusive Maximum value allowed
             * @returns `this`
             */
            clampf(minInclusive: Vec4, maxInclusive: Vec4): Vec4;
            /**
             * @en Adds the current vector with another one and return this
             * @zh ӷǰָ
             * @param other specified vector
             */
            add(other: Vec4): Vec4;
            /**
             * @en Adds the current vector with another one and return this
             * @zh ӷǰָ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             */
            add4f(x: number, y: number, z: number, w: number): Vec4;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh ǰȥָ
             * @param other specified vector
             */
            subtract(other: Vec4): Vec4;
            /**
             * @en Subtracts one vector from this, and returns this.
             * @zh ǰȥָ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             */
            subtract4f(x: number, y: number, z: number, w: number): Vec4;
            /**
             * @en Multiplies the current vector with a number, and returns this.
             * @zh ˡǰָ
             * @param scalar scalar number
             */
            multiplyScalar(scalar: number): Vec4;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh ˷ǰָ
             * @param other specified vector
             */
            multiply(other: Vec4): Vec4;
            /**
             * @en Multiplies the current vector with another one and return this
             * @zh ˷ǰָ˵Ľֵǰ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             */
            multiply4f(x: number, y: number, z: number, w: number): Vec4;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh ԪǰָĽֵǰ
             * @param other specified vector
             */
            divide(other: Vec4): Vec4;
            /**
             * @en Element-wisely divides this vector with another one, and return this.
             * @zh ԪǰָĽֵǰ
             * @param x The x value of specified vector
             * @param y The y value of specified vector
             * @param z The z value of specified vector
             * @param w The w value of specified vector
             */
            divide4f(x: number, y: number, z: number, w: number): Vec4;
            /**
             * @en Sets each component of this vector with its negative value
             * @zh ǰĸȡ
             */
            negative(): Vec4;
            /**
             * @en Calculates the dot product with another vector
             * @zh ˡ
             * @param other specified vector
             * @returns ǰָ˵Ľ
             */
            dot(vector: Vec4): number;
            /**
             * @en Calculates the cross product with another vector.
             * @zh ˡӵǰָΪά w ǰָ
             * @param other specified vector
             *
             * @deprecated since v3.8 cross product only defined in 3D space, use [[Vec3.cross]] instead.
             */
            cross(vector: Vec4): Vec4;
            /**
             * @en Returns the length of this vector.
             * @zh ĳȣģ
             * @returns Length of vector
             */
            length(): number;
            /**
             * @en Returns the squared length of this vector.
             * @zh ȣģƽ
             * @returns the squared length of this vector
             */
            lengthSqr(): number;
            /**
             * @en Normalize the current vector.
             * @zh ǰһ
             */
            normalize(): Vec4;
            /**
             * @en Scales the current vector by a scalar number.
             * @zh ˡ
             */
            scale(scalar: number): Vec4;
            /**
             * @en Transforms the vec4 with a mat4
             * @zh Ӧά任ǰ
             * @param matrix matrix to transform with
             */
            transformMat4(matrix: Mat4): Vec4;
        }
        export function v4(other: Vec4): Vec4;
        export function v4(x?: number, y?: number, z?: number, w?: number): Vec4;
        /**
         * @en quaternion
         * @zh Ԫ
         */
        export class Quat extends ValueType {
            static IDENTITY: Readonly<Quat>;
            /**
             * @en Obtain a copy of the given quaternion
             * @zh ָԪĿ
             */
            static clone<Out extends IQuatLike>(a: Out): Quat;
            /**
             * @en Copy the given quaternion to the out quaternion
             * @zh ĿԪ
             */
            static copy<Out extends IQuatLike, QuatLike extends IQuatLike>(out: Out, a: QuatLike): Out;
            /**
             * @en Sets the out quaternion with values of each component
             * @zh Ԫֵ
             */
            static set<Out extends IQuatLike>(out: Out, x: number, y: number, z: number, w: number): Out;
            /**
             * @en Sets the out quaternion to an identity quaternion
             * @zh Ŀ긳ֵΪλԪ
             */
            static identity<Out extends IQuatLike>(out: Out): Out;
            /**
             * @en Sets the out quaternion with the shortest path orientation between two vectors, considering both vectors normalized
             * @zh ԪΪ·תĬѹһ
             */
            static rotationTo<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, a: VecLike, b: VecLike): Out;
            /**
             * @en Gets the rotation axis and the arc of rotation from the quaternion
             * @zh ȡԪתת
             * @param outAxis output axis
             * @param q input quaternion
             * @return radian of rotation
             */
            static getAxisAngle<Out extends IQuatLike, VecLike extends IVec3Like>(outAxis: VecLike, q: Out): number;
            /**
             * @en Quaternion multiplication and save the results to out quaternion, that is a * b.
             * @zh Ԫ˷a * b
             */
            static multiply<Out extends IQuatLike, QuatLike_1 extends IQuatLike, QuatLike_2 extends IQuatLike>(out: Out, a: QuatLike_1, b: QuatLike_2): Out;
            /**
             * @en Quaternion scalar multiplication and save the results to out quaternion
             * @zh Ԫ˷
             */
            static multiplyScalar<Out extends IQuatLike>(out: Out, a: Out, b: number): Out;
            /**
             * @en Quaternion multiplication and addition: A + B * scale
             * @zh Ԫ˼ӣA + B * scale
             */
            static scaleAndAdd<Out extends IQuatLike>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around x axis
             * @zh  X תָԪ
             * @param rad radian of rotation
             */
            static rotateX<Out extends IQuatLike>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around y axis
             * @zh  Y תָԪ
             * @param rad radian of rotation
             */
            static rotateY<Out extends IQuatLike>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around z axis
             * @zh  Z תָԪ
             * @param rad radian of rotation
             */
            static rotateZ<Out extends IQuatLike>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around a given rotation axis in world space
             * @zh ռָתԪ
             * @param axis axis of rotation, normalized by default
             * @param rad radian of rotation
             */
            static rotateAround<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, rot: Out, axis: VecLike, rad: number): Out;
            /**
             * @en Sets the out quaternion to represent a radian rotation around a given rotation axis in local space
             * @zh ƱؿռָתԪ
             * @param axis axis of rotation
             * @param rad radian of rotation
             */
            static rotateAroundLocal<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, rot: Out, axis: VecLike, rad: number): Out;
            /**
             * @en Calculates the w component with xyz components, considering the given quaternion normalized
             * @zh  xyz  w Ĭѹһ
             */
            static calculateW<Out extends IQuatLike>(out: Out, a: Out): Out;
            /**
             * @en Quaternion dot product (scalar product)
             * @zh Ԫ
             */
            static dot<Out extends IQuatLike>(a: Out, b: Out): number;
            /**
             * @en Element by element linear interpolation: A + t * (B - A)
             * @zh ԪԲֵ A + t * (B - A)
             */
            static lerp<Out extends IQuatLike>(out: Out, a: Out, b: Out, t: number): Out;
            /**
             * @en Spherical quaternion interpolation
             * @zh Ԫֵ
             */
            static slerp<Out extends IQuatLike, QuatLike_1 extends IQuatLike, QuatLike_2 extends IQuatLike>(out: Out, a: QuatLike_1, b: QuatLike_2, t: number): Out;
            /**
             * @en Spherical quaternion interpolation with two control points
             * @zh ƵԪֵ
             * @param out the receiving quaternion
             * @param a the first operand
             * @param b the second operand
             * @param c the third operand
             * @param d the fourth operand
             * @param t interpolation amount, in the range [0-1], between the two inputs
             * @returns out
             */
            static sqlerp<Out extends IQuatLike>(out: Out, a: Out, b: Out, c: Out, d: Out, t: number): Out;
            /**
             * @en Sets the inverse of the given quaternion to out quaternion
             * @zh Ԫ
             */
            static invert<Out extends IQuatLike, QuatLike extends IQuatLike>(out: Out, a: QuatLike): Out;
            /**
             * @en Conjugating a quaternion, it's equivalent to the inverse of the unit quaternion, but more efficient
             * @zh ԪԵλԪȼۣЧ
             */
            static conjugate<Out extends IQuatLike>(out: Out, a: Out): Out;
            /**
             * @en Calculates the length of the quaternion
             * @zh Ԫ
             */
            static len<Out extends IQuatLike>(a: Out): number;
            /**
             * @en Calculates the squared length of the quaternion
             * @zh Ԫƽ
             */
            static lengthSqr<Out extends IQuatLike>(a: Out): number;
            /**
             * @en Normalize the given quaternion, returns a zero quaternion if input is a zero quaternion.
             * @zh һԪԪ᷵Ԫ
             */
            static normalize<Out extends IQuatLike>(out: Out, a: Out): Out;
            /**
             * @en Calculated the quaternion represents the given coordinates, considering all given vectors are normalized and mutually perpendicular
             * @zh ݱᳯԪĬѹһ໥ֱ
             */
            static fromAxes<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, xAxis: VecLike, yAxis: VecLike, zAxis: VecLike): Out;
            /**
             * @en Calculates the quaternion with the up direction and the direction of the viewport
             * @zh ӿڵǰϷԪ
             * @param view The view direction, it`s must be normalized.
             * @param up The view up direction, it`s must be normalized, default value is (0, 1, 0).
             */
            static fromViewUp<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, view: VecLike, up?: Vec3): Out;
            /**
             * @en Calculates the quaternion from a given rotary shaft and a radian rotation around it.
             * @zh תתȼԪ
             */
            static fromAxisAngle<Out extends IQuatLike, VecLike extends IVec3Like>(out: Out, axis: VecLike, rad: number): Out;
            /**
             * @en Calculates the quaternion with the three-dimensional transform matrix, considering no scale included in the matrix
             * @zh άϢԪĬ󲻺Ϣ
             */
            static fromMat3<Out extends IQuatLike>(out: Out, m: Mat3): Out;
            /**
             * @en Calculates the quaternion with Euler angles, the rotation order is YZX, first rotate around Y, then around Z, and finally around X.
             * @zh ŷϢԪת˳Ϊ YZXYתZXת
             */
            static fromEuler<Out extends IQuatLike>(out: Out, x: number, y: number, z: number): Out;
            /**
             * @en Calculates the quaternion with given 2D angle (0, 0, z).
             * @zh  2D Ƕȣ0, 0, zԪ
             *
             * @param out Output quaternion
             * @param z Angle to rotate around Z axis in degrees.
             */
            static fromAngleZ<Out extends IQuatLike>(out: Out, z: number): Out;
            /**
             * @en This returns the X-axis vector of the quaternion
             * @zh ضԪϵ X 
             */
            static toAxisX(out: IVec3Like, q: IQuatLike): IVec3Like;
            /**
             * @en This returns the Y-axis vector of the quaternion
             * @zh ضԪϵ Y 
             */
            static toAxisY(out: IVec3Like, q: IQuatLike): IVec3Like;
            /**
             * @en This returns the Z-axis vector of the quaternion
             * @zh ضԪϵ Z 
             */
            static toAxisZ(out: IVec3Like, q: IQuatLike): IVec3Like;
            /**
             * @en Converts the quaternion to angles, result angle x, y in the range of [-180, 180], z in the range of [-90, 90] interval,
             * the rotation order is YZX, first rotate around Y, then around Z, and finally around X
             * @zh ԪŷǣؽǶ x, y  [-180, 180] , z Ĭ [-90, 90] ڣת˳Ϊ YZXYתZXת
             * @param outerZ change z value range to [-180, -90] U [90, 180]
             */
            static toEuler(out: IVec3Like, q: IQuatLike, outerZ?: boolean): IVec3Like;
            /**
             * @en Converts the quaternion to euler angles, result angle y, z in the range of [-180, 180], x in the range of [-90, 90],
             * the rotation order is YXZ, first rotate around Y, then around X, and finally around Z.
             * @zh ԪŷǣؽǶ yz  [-180, 180], x  [-90, 90]ת˳Ϊ YXZYתXZת
             */
            static toEulerInYXZOrder(out: Vec3, q: IQuatLike): void;
            /**
             * @en Converts quaternion to an array
             * @zh Ԫת
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, q: IQuatLike, ofs?: number): Out;
            /**
             * @en Array to a quaternion
             * @zh תԪ
             * @param ofs Array Start Offset
             */
            static fromArray(out: IQuatLike, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): IQuatLike;
            /**
             * @en Check whether two quaternions are equal
             * @zh Ԫȼж
             */
            static strictEquals(a: IQuatLike, b: IQuatLike): boolean;
            /**
             * @en Check whether two quaternions are approximately equal
             * @zh ųԪƵȼж
             */
            static equals(a: IQuatLike, b: IQuatLike, epsilon?: number): boolean;
            /**
             * @en Gets the angular distance between two unit quaternions
             * @zh ȡλԪļн
             * @param a The first unit quaternion
             * @param b The second unit quaternion
             * @returns Angle between the two quaternions in radians
             */
            static angle(a: IQuatLike, b: IQuatLike): number;
            /**
             * @en Rotate a `from` unit quaternion towards `to` unit quaternion
             * @zh һʼλԪתһĿ굥λԪ
             * @param from The first unit quaternion
             * @param to The second unit quaternion
             * @param maxStep The maximum angle of rotation in degrees
             * @returns new unit quaternion generated during rotation
             */
            static rotateTowards(out: IQuatLike, from: IQuatLike, to: IQuatLike, maxStep: number): IQuatLike;
            /**
             * @en x component.
             * @zh x 
             */
            x: number;
            /**
             * @en y component.
             * @zh y 
             */
            y: number;
            /**
             * @en z component.
             * @zh z 
             */
            z: number;
            /**
             * @en w component.
             * @zh w 
             */
            w: number;
            constructor(other: Quat);
            constructor(x?: number, y?: number, z?: number, w?: number);
            /**
             * @en clone the current Quat
             * @zh ¡ǰԪ
             */
            clone(): Quat;
            /**
             * @en Set values with another quaternion
             * @zh õǰԪʹָԪȡ
             * @param other Specified quaternion
             * @returns `this`
             */
            set(other: Quat): Quat;
            /**
             * @en Set the value of each component of the current quaternion
             * @zh õǰԪָԪֵ
             * @returns `this`
             */
            set(x?: number, y?: number, z?: number, w?: number): Quat;
            /**
             * @en Check whether the quaternion approximately equals another one
             * @zh жϵǰԪǷΧָȡ
             * @param other Comparative quaternion
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @returns Returns `true' when the components of the two quaternions are equal within the specified error range; otherwise, returns `false'.
             */
            equals(other: Quat, epsilon?: number): boolean;
            /**
             * @en Check whether the current quaternion strictly equals other quaternion
             * @zh жϵǰԪǷָԪȡ
             * @param other Comparative quaternion
             * @returns Returns `true' when the components of the two quaternions are equal within the specified error range; otherwise, returns `false'.
             */
            strictEquals(other: Quat): boolean;
            /**
             * @en Convert quaternion to Euler angles
             * @zh ǰԪתΪŷǣx-y-zֵ
             * @param out the output vector
             */
            getEulerAngles(out: Vec3): IVec3Like;
            /**
             * @en Calculate the linear interpolation result between this quaternion and another one with given ratio
             * @zh ָĲֵʣӵǰԪĿԪ֮Բֵ
             * @param to The target quaternion
             * @param ratio The interpolation coefficient. The range is [0,1].
             */
            lerp(to: Quat, ratio: number): Quat;
            /**
             * @en Calculates the spherical interpolation result between this quaternion and another one with the given ratio
             * @zh ָĲֵʣӵǰԪĿԪֵ֮
             * @param to The target quaternion
             * @param ratio The interpolation coefficient. The range is [0,1].
             */
            slerp(to: Quat, ratio: number): Quat;
            /**
             * @en Calculates the length of the quaternion
             * @zh Ԫ
             */
            length(): number;
            /**
             * @en Calculates the squared length of the quaternion
             * @zh Ԫƽ
             */
            lengthSqr(): number;
        }
        export function quat(other: Quat): Quat;
        export function quat(x?: number, y?: number, z?: number, w?: number): Quat;
        /**
         * @en Mathematical 3x3 matrix.
         * @zh ʾά3x3
         */
        export class Mat3 extends ValueType {
            static IDENTITY: Readonly<Mat3>;
            /**
             * @en Clone a matrix and save the results to out matrix
             * @zh ָĿ
             */
            static clone<Out extends IMat3Like>(a: Out): Mat3;
            /**
             * @en Copy content of a matrix into another and save the results to out matrix
             * @zh Ŀ
             */
            static copy<Out extends IMat3Like>(out: Out, a: Out): Out;
            /**
             * @en Sets the elements of a matrix with the given values and save the results to out matrix
             * @zh þֵ
             */
            static set<Out extends IMat3Like>(out: Out, m00: number, m01: number, m02: number, m03: number, m04: number, m05: number, m06: number, m07: number, m08: number): Out;
            /**
             * @en Reset the out matrix to an identity matrix
             * @zh Ŀ긳ֵΪλ
             */
            static identity<Out extends IMat3Like>(out: Out): Out;
            /**
             * @en Transposes a matrix and save the results to out matrix
             * @zh תþ
             */
            static transpose<Out extends IMat3Like>(out: Out, a: Out): Out;
            /**
             * @en Inverts a matrix. When matrix is not invertible the matrix will be set to zeros.
             * @zh 棬ע⣬ھ󲻿ʱ᷵һȫΪ 0 ľ
             */
            static invert<Out extends IMat3Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates the determinant of a matrix
             * @zh ʽ
             */
            static determinant<Out extends IMat3Like>(a: Out): number;
            /**
             * @en Multiply two matrices explicitly and save the results to out matrix: a * b
             * @zh ˷a * b
             */
            static multiply<Out extends IMat3Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Take the first third order of the fourth order matrix and multiply by the third order matrix: a * b
             * @zh ȡĽ׾ǰף׾ˣa * b
             */
            static multiplyMat4<Out extends IMat3Like>(out: Out, a: Out, b: IMat4Like): Out;
            /**
             * @en Multiply a matrix with a translation vector given by a translation offset, first translate, then transforma * T(v).
             * @zh ڸ任ϼλƱ任λƣٱ任a * T(v)
             */
            /**
             * @deprecated since v3.8.0, the function name is misleading, please use translate instead.
             */
            static transform<Out extends IMat3Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): void;
            /**
             * @en Multiply a matrix with a translation vector given by a translation offset, first translate, then transforma * T(v).
             * @zh ڸ任ϼλƱ任λƣٱ任a * T(v)
             */
            static translate<Out extends IMat3Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Multiply a matrix with a scale matrix given by a scale vector and save the results to out matrix, first scale, then transforma * S(v).
             * @zh ڸ任ϼű任ţٱ任a * S(v)
             */
            static scale<Out extends IMat3Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Rotates the transform by the given angle and save the results into the out matrix, first rotate, then transforma * R(rad).
             * @zh ڸ任ϼת任תٱ任a * R(rad)
             * @param rad radian of rotation
             */
            static rotate<Out extends IMat3Like>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Copies the first third order matrix of a fourth order matrix to the out third order matrix
             * @zh ȡĽ׾ǰ
             */
            static fromMat4<Out extends IMat3Like>(out: Out, a: IMat4Like): Out;
            /**
             * @en Sets a third order matrix with view direction and up direction. Then save the results to out matrix
             * @zh ӿǰϷ
             * @param view The view direction, it`s must be normalized.
             * @param up The view up direction, it`s must be normalized, default value is (0, 1, 0).
             */
            static fromViewUp<Out extends IMat3Like, VecLike extends IVec3Like>(out: Out, view: VecLike, up?: Vec3): Out;
            /**
             * @en Sets the given matrix with a translation vector and save the results to out matrix
             * @zh λƾ
             */
            static fromTranslation<Out extends IMat3Like, VecLike extends IVec2Like>(out: Out, v: VecLike): Out;
            /**
             * @en Sets the given matrix with a scale vector and save the results to out matrix
             * @zh ž
             */
            static fromScaling<Out extends IMat3Like, VecLike extends IVec2Like>(out: Out, v: VecLike): Out;
            /**
             * @en Sets the given matrix with a given angle and save the results to out matrix
             * @zh ת
             */
            static fromRotation<Out extends IMat3Like>(out: Out, rad: number): Out;
            /**
             * @en Sets the given matrix with the given quaternion and save the results to out matrix
             * @zh ԪתϢ
             */
            static fromQuat<Out extends IMat3Like>(out: Out, q: IQuatLike): Out;
            /**
             * @deprecated since v3.8.0, this function is too complicated, and should be split into several functions.
             */
            /**
             * @en Calculates the upper-left 3x3 matrix of a 4x4 matrix's inverse transpose
             * @zh ָάתά
             */
            static inverseTransposeMat4<Out extends IMat3Like>(out: Out, a: IMat4Like): Out | null;
            /**
             * @en Transform a matrix object to a flat array
             * @zh ת
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, m: IMat3Like, ofs?: number): Out;
            /**
             * @en Generates or sets a matrix with a flat array
             * @zh ת
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IMat3Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Adds two matrices and save the results to out matrix
             * @zh Ԫؾӷ
             */
            static add<Out extends IMat3Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Subtracts matrix b from matrix a and save the results to out matrix
             * @zh Ԫؾ
             */
            static subtract<Out extends IMat3Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Multiply each element of a matrix by a scalar number and save the results to out matrix
             * @zh ˷
             */
            static multiplyScalar<Out extends IMat3Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Adds two matrices after multiplying each element of the second operand by a scalar number. And save the results to out matrix.
             * @zh Ԫؾ˼: A + B * scale
             */
            static multiplyScalarAndAdd<Out extends IMat3Like>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Returns whether the specified matrices are equal.
             * @zh ȼж
             */
            static strictEquals<Out extends IMat3Like>(a: Out, b: Out): boolean;
            /**
             * @en Returns whether the specified matrices are approximately equal.
             * @zh ųľƵȼж
             */
            static equals<Out extends IMat3Like>(a: Out, b: Out, epsilon?: number): boolean;
            /**
             * @en Convert Matrix to euler angle, resulting angle y, z in the range of [-PI, PI],
             *  x in the range of [-PI/2, PI/2], the rotation order is YXZ, first rotate around Y, then around X, and finally around Z.
             * @zh תŷ, ؽǶ y,z  [-PI, PI] , x  [-PI/2, PI/2] ڣת˳Ϊ YXZYתXZת
             */
            static toEuler<InType extends IMat3Like, VecLike extends IVec3Like>(matrix: InType, v: VecLike): boolean;
            /**
             * matrix layout
             * |m00  m03  m06|
             * |m01  m04  m07|
             * |m02  m05  m08|
             */
            /**
             * @en Value at column 0 row 0 of the matrix.
             * @zh  0 е 0 еԪء
             */
            m00: number;
            /**
             * @en Value at column 0 row 1 of the matrix.
             * @zh  0 е 1 еԪء
             */
            m01: number;
            /**
             * @en Value at column 0 row 2 of the matrix.
             * @zh  0 е 2 еԪء
             */
            m02: number;
            /**
             * @en Value at column 1 row 0 of the matrix.
             * @zh  1 е 0 еԪء
             */
            m03: number;
            /**
             * @en Value at column 1 row 1 of the matrix.
             * @zh  1 е 1 еԪء
             */
            m04: number;
            /**
             * @en Value at column 1 row 2 of the matrix.
             * @zh  1 е 2 еԪء
             */
            m05: number;
            /**
             * @en Value at column 2 row 0 of the matrix.
             * @zh  2 е 0 еԪء
             */
            m06: number;
            /**
             * @en Value at column 2 row 1 of the matrix.
             * @zh  2 е 1 еԪء
             */
            m07: number;
            /**
             * @en Value at column 2 row 2 of the matrix.
             * @zh  2 е 2 еԪء
             */
            m08: number;
            constructor(other: Mat3);
            constructor(m00?: number, m01?: number, m02?: number, m03?: number, m04?: number, m05?: number, m06?: number, m07?: number, m08?: number);
            /**
             * @en Clone a new matrix from the current matrix.
             * @zh ¡ǰ
             */
            clone(): Mat3;
            /**
             * @en Sets the matrix with another one's value.
             * @zh õǰʹָȡ
             * @param other Specified matrix
             * @return this
             */
            set(other: Mat3): Mat3;
            /**
             * @en Set the matrix with values of all elements
             * @zh õǰָԪֵ
             * @return this
             */
            set(m00?: number, m01?: number, m02?: number, m03?: number, m04?: number, m05?: number, m06?: number, m07?: number, m08?: number): Mat3;
            /**
             * @en Returns whether the specified matrices are approximately equal.
             * @zh жϵǰǷΧָȡ
             * @param other Comparative matrix
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @return Returns `true' when the elements of both matrices are equal; otherwise returns `false'.
             */
            equals(other: Mat3, epsilon?: number): boolean;
            /**
             * @en Returns whether the specified matrices are equal.
             * @zh жϵǰǷָȡ
             * @param other Comparative matrix
             * @return Returns `true' when the elements of both matrices are equal; otherwise returns `false'.
             */
            strictEquals(other: Mat3): boolean;
            /**
             * @en Returns a string representation of a matrix.
             * @zh صǰַʾ
             * @return The string representation of this matrix
             */
            toString(): string;
            /**
             * @en set the current matrix to an identity matrix.
             * @zh ǰΪλ
             * @return `this`
             */
            identity(): Mat3;
            /**
             * @en Transposes the current matrix.
             * @zh 㵱ǰתþ
             */
            transpose(): Mat3;
            /**
             * @en Inverts the current matrix. When matrix is not invertible the matrix will be set to zeros.
             * @zh 㵱ǰע⣬ھ󲻿ʱ᷵һȫΪ 0 ľ
             */
            invert(): Mat3;
            /**
             * @en Calculates the determinant of the current matrix.
             * @zh 㵱ǰʽ
             * @return ǰʽ
             */
            determinant(): number;
            /**
             * @en Adds the current matrix and another matrix to the current matrix.
             * @zh ӷǰָӣظǰ
             * @param mat the second operand
             */
            add(mat: Mat3): Mat3;
            /**
             * @en Subtracts another matrix from the current matrix.
             * @zh ǰȥָĽֵǰ
             * @param mat the second operand
             */
            subtract(mat: Mat3): Mat3;
            /**
             * @en Multiply the current matrix with another matrix.
             * @zh ˷ǰָĽֵǰ
             * @param mat the second operand
             */
            multiply(mat: Mat3): Mat3;
            /**
             * @en Multiply each element of the current matrix by a scalar number.
             * @zh ˡǰָ˽ֵǰ
             * @param scalar amount to scale the matrix's elements by
             */
            multiplyScalar(scalar: number): Mat3;
            /**
             * @en Multiply the current matrix with a scale matrix given by a scale vector, that is M * S(vec).
             * @zh ǰžĽֵǰžɸŸM * S(vec)
             * @param vec vector to scale by
             */
            scale(vec: Vec3): Mat3;
            /**
             * @en Rotates the current matrix by the given angle, that is M * R(rad).
             * @zh ǰתĽֵǰתתתǶȸM * R(rad)
             * @param rad radian of rotation
             */
            rotate(rad: number): Mat3;
            /**
             * @en Resets the current matrix from the given quaternion.
             * @zh õǰֵʹʾָԪʾת任
             * @param q The quaternion.
             * @returns this
             */
            fromQuat(q: Quat): Mat3;
        }
        /**
         * @en Mathematical 4x4 matrix.
         * @zh ʾά4x4
         */
        export class Mat4 extends ValueType {
            static IDENTITY: Readonly<Mat4>;
            /**
             * @en Clone a matrix and save the results to out matrix
             * @zh ָĿ
             */
            static clone(a: IMat4Like): Mat4;
            /**
             * @en Copy a matrix into the out matrix
             * @zh Ŀ
             */
            static copy<Out extends IMat4Like>(out: Out, a: Out): Out;
            /**
             * @en Sets a matrix with the given values and save the results to out matrix
             * @zh þֵ
             *
             * @param out The receive matrix
             * @param m00 Component in column 0, row 0 position (index 0)
             * @param m01 Component in column 0, row 1 position (index 1)
             * @param m02 Component in column 0, row 2 position (index 2)
             * @param m03 Component in column 0, row 3 position (index 3)
             * @param m10 Component in column 1, row 0 position (index 4)
             * @param m11 Component in column 1, row 1 position (index 5)
             * @param m12 Component in column 1, row 2 position (index 6)
             * @param m13 Component in column 1, row 3 position (index 7)
             * @param m20 Component in column 2, row 0 position (index 8)
             * @param m21 Component in column 2, row 1 position (index 9)
             * @param m22 Component in column 2, row 2 position (index 10)
             * @param m23 Component in column 2, row 3 position (index 11)
             * @param m30 Component in column 3, row 0 position (index 12)
             * @param m31 Component in column 3, row 1 position (index 13)
             * @param m32 Component in column 3, row 2 position (index 14)
             * @param m33 Component in column 3, row 3 position (index 15)
             * @returns The receive matrix
             */
            static set<Out extends IMat4Like>(out: Out, m00: number, m01: number, m02: number, m03: number, m10: number, m11: number, m12: number, m13: number, m20: number, m21: number, m22: number, m23: number, m30: number, m31: number, m32: number, m33: number): Out;
            /**
             * @en return an identity matrix.
             * @zh Ŀ긳ֵΪλ
             */
            static identity<Out extends IMat4Like>(out: Out): Out;
            /**
             * @en Transposes a matrix and save the results to out matrix
             * @zh תþ
             */
            static transpose<Out extends IMat4Like>(out: Out, a: Out): Out;
            /**
             * @en Inverts a matrix. When matrix is not invertible the matrix will be set to zeros.
             * @zh 棬ע⣬ھ󲻿ʱ᷵һȫΪ 0 ľ
             */
            static invert<Out extends IMat4Like>(out: Out, a: Out): Out;
            /**
             * @en Calculates the determinant of a matrix
             * @zh ʽ
             */
            static determinant<InType extends IMat4Like>(a: InType): number;
            /**
             * @en Multiply two matrices and save the results to out matrix, (out = a * b)
             * @zh ˷ (out = a * b)
             *
             * @param out The out matrix
             * @param a The first operand
             * @param b The second operand
             * @returns out matrix
             */
            static multiply<Out extends IMat4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Translate a matrix with the given vector and save results to the out matrix, the translate is applied before the matrix, i.e. (out = a * T)
             * @zh ڸ任ϼƽƱ任浽 out УƽƱ任Ӧھ任֮ǰ (out = a * T)
             *
             * @param out The out matrix
             * @param a The matrix to translate
             * @param v The vector to translate with
             */
            static transform<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Transform a matrix with the given translation vector and save results to the out matrix,
             * the translate is applied after the transformation, i.e. (out = T * a)
             * @zh ڸ任ϼλƱ任ƽƱ任ڱ任֮Ӧã (out = T * a)
             *
             * @param out The out matrix
             * @param a The matrix to translate
             * @param v The vector to translate with
             * @deprecated Since 3.8.0, please use [[transform]] instead
             */
            static translate<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Multiply a matrix with a scale matrix given by a scale vector and save the results into the out matrix,
             * the scale is applied before the matrix, i.e. (out = a * S)
             * @zh ڸ任ϼű任浽 out Уű任Ӧھ任֮ǰ (out = a * S)
             */
            static scale<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, a: Out, v: VecLike): Out;
            /**
             * @en Rotates the transform by the given angle and save the results into the out matrix, the rotate is applied before
             * the matrix, i.e. (out = a * R)
             * @zh ڸ任ϼת任, 浽 out Уת任Ӧھ任֮ǰ (out = a * R)
             * @param rad Angle of rotation (in radians)
             * @param axis axis of rotation
             */
            static rotate<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, a: Out, rad: number, axis: VecLike): Out | null;
            /**
             * @en Transform a matrix with a given angle around X axis and save the results to the out matrix, the rotate is applied
             * before the matrix, i.e. (out = a * R)
             * @zh ڸ任ϼ X ת任, 浽 out Уת任Ӧھ任֮ǰ (out = a * R)
             * @param rad Angle of rotation (in radians)
             */
            static rotateX<Out extends IMat4Like>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Transform a matrix with a given angle around Y axis and save the results to the out matrix
             * @zh ڸ任ϼ Y ת任
             * @param rad Angle of rotation (in radians)
             */
            static rotateY<Out extends IMat4Like>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Transform a matrix with a given angle around Z axis and save the results to the out matrix
             * @zh ڸ任ϼ Z ת任
             * @param rad Angle of rotation (in radians)
             */
            static rotateZ<Out extends IMat4Like>(out: Out, a: Out, rad: number): Out;
            /**
             * @en Sets the out matrix with a translation vector
             * @zh λƾ
             */
            static fromTranslation<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, v: VecLike): Out;
            /**
             * @en Sets the out matrix with a scale vector
             * @zh ž
             */
            static fromScaling<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, v: VecLike): Out;
            /**
             * @en Sets the out matrix with rotation angle
             * @zh ת
             */
            static fromRotation<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, rad: number, axis: VecLike): Out | null;
            /**
             * @en Calculates the matrix representing a rotation around the X axis
             * @zh  X ת
             */
            static fromXRotation<Out extends IMat4Like>(out: Out, rad: number): Out;
            /**
             * @en Calculates the matrix representing a rotation around the Y axis
             * @zh  Y ת
             */
            static fromYRotation<Out extends IMat4Like>(out: Out, rad: number): Out;
            /**
             * @en Calculates the matrix representing a rotation around the Z axis
             * @zh  Z ת
             */
            static fromZRotation<Out extends IMat4Like>(out: Out, rad: number): Out;
            /**
             * @en Calculates the transform representing the combination of a rotation and a translation, and stores the result in out.
             * The order is rotation then translation.
             * @zh תλϢ
             */
            static fromRT<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike): Out;
            /**
             * @en Extracts the translation from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh ȡλϢ, ĬϾеı任 S->R->T ˳Ӧ
             */
            static getTranslation<InType extends IMat4Like, VecLike extends IVec3Like>(out: VecLike, mat: InType): VecLike;
            /**
             * @en Extracts the scale vector from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh ȡϢ, ĬϾеı任 S->R->T ˳Ӧ
             */
            static getScaling<InType extends IMat4Like, VecLike extends IVec3Like>(out: VecLike, mat: InType): VecLike;
            /**
             * @en Extracts the rotation from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh ȡתϢ, Ĭ󲻺Ϣ翼Ӧʹ `toRTS` 
             */
            static getRotation<InType extends IMat4Like>(out: Quat, mat: InType): Quat;
            /**
             * @en Extracts the scale, rotation and translation from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh ȡתλơϢ ĬϾеı任 S->R->T ˳Ӧ
             *
             * @param m The input transform matrix
             * @param q The corresponding rotation quat
             * @param v The corresponding translate vector
             * @param s The corresponding scaling vector
             *
             * @deprecated Since 3.8.0, please use toSRT instead
             */
            static toRTS<InType extends IMat4Like, VecLike extends IVec3Like>(m: InType, q: Quat | null, v: VecLike | null, s: VecLike | null): void;
            /**
             * @en Extracts the scale, rotation and translation from the matrix, assuming it's composed in order of scale, rotation, translation
             * @zh ȡתλơϢ ĬϾеı任 S->R->T ˳Ӧ
             *
             * @param m The input transform matrix
             * @param q The corresponding rotation quat
             * @param v The corresponding translate vector
             * @param s The corresponding scaling vector
             */
            static toSRT<InType extends IMat4Like, VecLike extends IVec3Like>(m: InType, q: Quat | null, v: VecLike | null, s: VecLike | null): void;
            /**
             * @en Convert Matrix to euler angle, resulting angle y, z in the range of [-PI, PI],
             *  x in the range of [-PI/2, PI/2], the rotation order is YXZ.
             * @zh תΪŷǣǶ y, z  [-PI, PI] Χڣx  [-PI/2, PI/2] ڣת˳Ϊ YXZ.
             */
            static toEuler<InType extends IMat4Like, VecLike extends IVec3Like>(m: InType, v: VecLike): boolean;
            /**
             * @en Compose a matrix from scale, rotation and translation, applied in order.
             * @zh תλơϢ S->R->T ˳Ӧ
             * @deprecated Since 3.8.0, please use [[fromSRT]] instead.
             */
            static fromRTS<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike, s: VecLike): Out;
            /**
             * @en Compose a matrix from scale, rotation and translation, applied in order.
             * @zh תλơϢ S->R->T ˳Ӧ
             * @param out The receiving matrix
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @returns The receiving matrix
             */
            static fromSRT<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike, s: VecLike): Out;
            /**
             * @en Compose a matrix from scale, rotation and translation, applied in order, from a given origin
             * @zh ָתλơż任Ϣ S->R->T ˳Ӧ
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @param o transformation Center
             * @deprecated Please use [[fromSRTOrigin]] instead.
             */
            static fromRTSOrigin<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike, s: VecLike, o: VecLike): Out;
            /**
             * @en Compose a matrix from scale, rotation and translation, applied in order, from a given origin
             * @zh ָתλơż任Ϣ O^{-1}->S->R->O->T ˳Ӧ
             * @param out The receiving matrix
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @param o transformation Center
             * @returns The receiving matrix
             */
            static fromSRTOrigin<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, q: Quat, v: VecLike, s: VecLike, o: VecLike): Out;
            /**
             * @en Sets the out matrix with the given quaternion
             * @zh ָתϢ
             */
            static fromQuat<Out extends IMat4Like>(out: Out, q: Quat): Out;
            /**
             * @en Calculates the matrix representing the given frustum
             * @zh ָ׶Ϣ
             * @param out The receiving matrix.
             * @param left The X coordinate of the left side of the near projection plane in view space.
             * @param right The X coordinate of the right side of the near projection plane in view space.
             * @param bottom The Y coordinate of the bottom side of the near projection plane in view space.
             * @param top The Y coordinate of the top side of the near projection plane in view space.
             * @param near Z distance to the near plane from the origin in view space.
             * @param far Z distance to the far plane from the origin in view space.
             *
             * @return The receiving matrix.
             */
            static frustum<Out extends IMat4Like>(out: Out, left: number, right: number, bottom: number, top: number, near: number, far: number): Out;
            /**
             * @en Calculates perspective projection matrix
             * @zh ͸ͶӰ
             * @param out The receiving matrix.
             * @param fovy Vertical field-of-view in degrees.
             * @param aspect Aspect ratio
             * @param near Near depth clipping plane value.
             * @param far Far depth clipping plane value.
             * @param isFOVY Whether the fovy is based on the vertical field-of-view.
             * @param minClipZ The minimum value of the near clipping plane, e.g. -1 for OpenGL, 0 for Vulkan and Metal.
             * @param projectionSignY The sign of the Y axis of the projection matrix, which is used to flip the Y axis.
             * @param orientation The orientation of the projection matrix, which is used to rotate the projection matrix.
             *
             * @return The receiving matrix.
             */
            static perspective<Out extends IMat4Like>(out: Out, fov: number, aspect: number, near: number, far: number, isFOVY?: boolean, minClipZ?: number, projectionSignY?: number, orientation?: number): Out;
            /**
             * @en Calculates orthogonal projection matrix
             * @zh ͶӰ
             * @param out The receiving matrix.
             * @param left Left-side x-coordinate.
             * @param right Right-side x-coordinate.
             * @param bottom Bottom y-coordinate.
             * @param top Top y-coordinate.
             * @param near Near depth clipping plane value.
             * @param far Far depth clipping plane value.
             * @param minClipZ The minimum value of the near clipping plane, e.g. -1 for OpenGL, 0 for Vulkan and Metal.
             * @param projectionSignY The sign of the Y axis of the projection matrix, which is used to flip the Y axis.
             * @param orientation The orientation of the projection matrix, which is used to rotate the projection matrix.
             *
             * @return The receiving matrix.
             */
            static ortho<Out extends IMat4Like>(out: Out, left: number, right: number, bottom: number, top: number, near: number, far: number, minClipZ?: number, projectionSignY?: number, orientation?: number): Out;
            /**
             * @en
             * Calculates the matrix with the view point information, given by eye position, target center and the up vector.
             * Note that center to eye vector can't be zero or parallel to the up vector
             * @zh
             * ͼ󣬸۾λáĿĺע⣬ĵ۾ΪƽС
             * @out The receiving matrix.
             * @param eye The source point.
             * @param center The target point.
             * @param up The vector describing the up direction.
             * @return The receiving matrix.
             */
            static lookAt<Out extends IMat4Like, VecLike extends IVec3Like>(out: Out, eye: VecLike, center: VecLike, up: VecLike): Out;
            /**
             * @en Calculates the inverse transpose of a matrix and save the results to out matrix
             * @zh תþ
             *
             * @deprecated This function is too complicated, and should be split into several functions.
             */
            static inverseTranspose<Out extends IMat4Like>(out: Out, a: Out): Out | null;
            /**
             * @en Transform a matrix object to a flat array
             * @zh ת
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, m: IMat4Like, ofs?: number): Out;
            /**
             * @en Generates or sets a matrix with a flat array
             * @zh ת
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IMat4Like>(out: Out, arr: __private.__types_globals__IWritableArrayLike<number>, ofs?: number): Out;
            /**
             * @en Adds two matrices and save the results to out matrix
             * @zh Ԫؾӷ
             */
            static add<Out extends IMat4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Subtracts matrix b from matrix a and save the results to out matrix
             * @zh Ԫؾ
             */
            static subtract<Out extends IMat4Like>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Multiply each element of a matrix by a scalar number and save the results to out matrix
             * @zh ˷
             */
            static multiplyScalar<Out extends IMat4Like>(out: Out, a: Out, b: number): Out;
            /**
             * @en Adds two matrices after multiplying each element of the second operand by a scalar number. And save the results to out matrix.
             * @zh Ԫؾ˼: A + B * scale
             */
            static multiplyScalarAndAdd<Out extends IMat4Like>(out: Out, a: Out, b: Out, scale: number): Out;
            /**
             * @en Returns whether the specified matrices are equal.
             * @zh ȼж
             */
            static strictEquals<InType extends IMat4Like>(a: InType, b: InType): boolean;
            /**
             * @en Returns whether the specified matrices are approximately equal.
             * @zh ųľƵȼж
             *
             * @param a The first matrix to be compared.
             * @param b The second matrix to be compared.
             * @param epsilon The tolerance value.
             * @return
             */
            static equals<InType extends IMat4Like>(a: InType, b: InType, epsilon?: number): boolean;
            /**
             * matrix layout
             * |m00  m04  m08 m12|
             * |m01  m05  m09 m13|
             * |m02  m06  m10 m14|
             * |m03  m07  m11 m15|
             */
            /**
             * @en Value at column 0 row 0 of the matrix.
             * @zh  0 е 0 еԪء
             */
            m00: number;
            /**
             * @en Value at column 0 row 1 of the matrix.
             * @zh  0 е 1 еԪء
             */
            m01: number;
            /**
             * @en Value at column 0 row 2 of the matrix.
             * @zh  0 е 2 еԪء
             */
            m02: number;
            /**
             * @en Value at column 0 row 3 of the matrix.
             * @zh  0 е 3 еԪء
             */
            m03: number;
            /**
             * @en Value at column 1 row 0 of the matrix.
             * @zh  1 е 0 еԪء
             */
            m04: number;
            /**
             * @en Value at column 1 row 1 of the matrix.
             * @zh  1 е 1 еԪء
             */
            m05: number;
            /**
             * @en Value at column 1 row 2 of the matrix.
             * @zh  1 е 2 еԪء
             */
            m06: number;
            /**
             * @en Value at column 1 row 3 of the matrix.
             * @zh  1 е 3 еԪء
             */
            m07: number;
            /**
             * @en Value at column 2 row 0 of the matrix.
             * @zh  2 е 0 еԪء
             */
            m08: number;
            /**
             * @en Value at column 2 row 1 of the matrix.
             * @zh  2 е 1 еԪء
             */
            m09: number;
            /**
             * @en Value at column 2 row 2 of the matrix.
             * @zh  2 е 2 еԪء
             */
            m10: number;
            /**
             * @en Value at column 2 row 3 of the matrix.
             * @zh  2 е 3 еԪء
             */
            m11: number;
            /**
             * @en Value at column 3 row 0 of the matrix.
             * @zh  3 е 0 еԪء
             */
            m12: number;
            /**
             * @en Value at column 3 row 1 of the matrix.
             * @zh  3 е 1 еԪء
             */
            m13: number;
            /**
             * @en Value at column 3 row 2 of the matrix.
             * @zh  3 е 2 еԪء
             */
            m14: number;
            /**
             * @en Value at column 3 row 3 of the matrix.
             * @zh  3 е 3 еԪء
             */
            m15: number;
            constructor(other: Mat4);
            constructor(m00?: number, m01?: number, m02?: number, m03?: number, m04?: number, m05?: number, m06?: number, m07?: number, m08?: number, m09?: number, m10?: number, m11?: number, m12?: number, m13?: number, m14?: number, m15?: number);
            /**
             * @en Clone a new matrix from the current matrix.
             * @zh ¡ǰ
             */
            clone(): Mat4;
            /**
             * @en Sets the matrix with another one's value.
             * @zh õǰʹָȡ
             * @param other Specified matrix.
             * @return this
             */
            set(other: Mat4): Mat4;
            /**
             * @en Set the matrix with values of all elements
             * @zh õǰָԪֵ
             *
             * @return this
             */
            set(m00?: number, m01?: number, m02?: number, m03?: number, m04?: number, m05?: number, m06?: number, m07?: number, m08?: number, m09?: number, m10?: number, m11?: number, m12?: number, m13?: number, m14?: number, m15?: number): Mat4;
            /**
             * @en Returns whether the specified matrices are approximately equal.
             * @zh жϵǰǷΧָȡ
             * @param other Comparative matrix
             * @param epsilon The error allowed. It`s should be a non-negative number.
             * @return Returns `true' when the elements of both matrices are equal; otherwise returns `false'.
             */
            equals(other: Mat4, epsilon?: number): boolean;
            /**
             * @en Returns whether the specified matrices are equal.
             * @zh жϵǰǷָȡ
             * @param other Comparative matrix
             * @return Returns `true' when the elements of both matrices are equal; otherwise returns `false'.
             */
            strictEquals(other: Mat4): boolean;
            /**
             * @en Returns a string representation of a matrix.
             * @zh صǰַʾ
             * @return ǰַʾ
             */
            toString(): string;
            /**
             * @en set the current matrix to an identity matrix.
             * @zh ǰΪλ
             * @return `this`
             */
            identity(): Mat4;
            /**
             * @en set the current matrix to an zero matrix.
             * @zh ǰΪ 0
             * @return `this`
             */
            zero(): Mat4;
            /**
             * @en Transposes the current matrix.
             * @zh 㵱ǰתþ
             */
            transpose(): Mat4;
            /**
             * @en Inverts the current matrix. When matrix is not invertible the matrix will be set to zeros.
             * @zh 㵱ǰע⣬ھ󲻿ʱ᷵һȫΪ 0 ľ
             */
            invert(): Mat4;
            /**
             * @en Calculates the determinant of the current matrix.
             * @zh 㵱ǰʽ
             * @return ǰʽ
             */
            determinant(): number;
            /**
             * @en Adds the current matrix and another matrix to the current matrix.
             * @zh ӷǰָӣظǰ
             * @param mat the second operand
             */
            add(mat: Mat4): Mat4;
            /**
             * @en Subtracts another matrix from the current matrix.
             * @zh ǰȥָĽֵǰ
             * @param mat the second operand
             */
            subtract(mat: Mat4): Mat4;
            /**
             * @en Multiply the current matrix with another matrix.
             * @zh ˷ǰָĽֵǰ
             * @param mat the second operand
             */
            multiply(mat: Mat4): Mat4;
            /**
             * @en Multiply each element of the current matrix by a scalar number.
             * @zh ˡǰָ˽ֵǰ
             * @param scalar amount to scale the matrix's elements by
             */
            multiplyScalar(scalar: number): Mat4;
            /**
             * @en Translate the current matrix by the given vector
             * @zh ǰλƾĽֵǰλƾɸλƸ
             * @param vec vector to translate by
             *
             * @deprecated since v3.0, please use [[transform]] instead
             */
            translate(vec: Vec3): Mat4;
            /**
             * @en Translate the current matrix by the given vector
             * @zh ǰλƾĽֵǰλƾɸλƸ
             * @param vec vector to translate by
             */
            transform(vec: Vec3): Mat4;
            /**
             * @en Multiply the current matrix with a scale vector.
             * @zh ǰžĽֵǰžɸŸ
             * @param vec vector to scale by
             */
            scale(vec: Vec3): Mat4;
            /**
             * @en Rotates the current matrix by the given angle around the given axis
             * @zh ǰתĽֵǰתתתǶȸ
             * @param rad Angle of rotation (in radians)
             * @param axis Axis of rotation
             */
            rotate(rad: number, axis: Vec3): Mat4 | null;
            /**
             * @en Returns the translation vector component of a transformation matrix.
             * @zh ӵǰмλƱ任Ĳ֣ԸλƵʽֵ
             * @param out Vector to receive translation component.
             */
            getTranslation(out: Vec3): Vec3;
            /**
             * @en Returns the scale factor component of a transformation matrix
             * @zh ӵǰмű任Ĳ֣Ըŵʽֵ
             * @param out Vector to receive scale component
             */
            getScale(out: Vec3): Vec3;
            /**
             * @en Returns the rotation factor component of a transformation matrix
             * @zh ӵǰмת任Ĳ֣ԪʽֵԪ
             * @param out Vector to receive rotation component
             */
            getRotation(out: Quat): Quat;
            /**
             * @en Resets the matrix values by the given rotation quaternion, translation vector and scale vector
             * @zh õǰֵʹʾָתšλϵı任
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @return `this`
             *
             * @deprecated Since 3.8.0, please use [[fromSRT]] instead
             */
            fromRTS(q: Quat, v: Vec3, s: Vec3): Mat4;
            /**
             * @en Resets the matrix values by the given rotation quaternion, translation vector and scale vector
             * @zh õǰֵʹʾָתšλϵı任
             * @param q Rotation quaternion
             * @param v Translation vector
             * @param s Scaling vector
             * @return `this`
             */
            fromSRT(q: Quat, v: Vec3, s: Vec3): Mat4;
            /**
             * @en Resets the current matrix from the given quaternion.
             * @zh õǰֵʹʾָԪʾת任
             * @param q Rotation quaternion
             * @return `this`
             */
            fromQuat(q: Quat): Mat4;
        }
        export function mat4(other: Mat4): Mat4;
        export function mat4(m00?: number, m01?: number, m02?: number, m03?: number, m10?: number, m11?: number, m12?: number, m13?: number, m20?: number, m21?: number, m22?: number, m23?: number, m30?: number, m31?: number, m32?: number, m33?: number): Mat4;
        /**
         * @en `AffineTransform` class represent an affine transform matrix. It's composed basically by translation, rotation, scale transformations.
         * @zh ά任ƽơתš
         */
        export class AffineTransform {
            /**
             * @en Create an identity transformation matrix.
             * @zh λά任κα任
             */
            static identity(): AffineTransform;
            /**
             * @en Clone an `AffineTransform` object from the specified transform.
             * @zh ¡ָĶά任
             * @param affineTransform Specified `AffineTransform` objects
             */
            static clone(affineTransform: AffineTransform): AffineTransform;
            /**
             * @en Concatenate a transform matrix to another. The results are reflected in the out `AffineTransform`.
             * First apply t1, then t2: out * v = t2 * (t1 * v).
             * @zh ˵ĽֵӦt1Ӧt2: out * v = t2 * (t1 * v)
             * @param out Out object to store the concat result
             * @param t1 The first transform object.
             * @param t2 The transform object to concatenate.
             */
            static concat(out: AffineTransform, t1: AffineTransform, t2: AffineTransform): void;
            /**
             * @en Get the invert transform of an `AffineTransform` object.
             * @zh Ľֵ
             * @param out Out object to store the invert result
             * @param t the input `AffineTransform` object
             */
            static invert(out: AffineTransform, t: AffineTransform): void;
            /**
             * @en Get an `AffineTransform` object from a given matrix 4x4.
             * @zh άתΪά任󲢸ֵ
             * @param out The output matrix to store the result
             * @param mat transform matrix.
             */
            static fromMat4(out: AffineTransform, mat: Mat4): void;
            /**
             * @en Apply the `AffineTransform` on a 2D vector.
             * @zh Ӧöά任󵽶άϣֵ
             * @param out The output vector to store the result
             * @param point Vector to apply transform.
             * @param t transform matrix.
             */
            static transformVec2(out: Vec2, point: Vec2, t: AffineTransform): any;
            /**
             * @en Apply the `AffineTransform` on a 2D vector.
             * @zh Ӧöά任󵽶άϣֵ
             * @param out The output vector to store the result
             * @param x x to apply transform.
             * @param y y to apply transform.
             * @param t transform matrix.
             */
            static transformVec2(out: Vec2, x: number, y: number, t: AffineTransform): any;
            /**
             * @en Apply the `AffineTransform` on a size.
             * @zh Ӧöά任󵽶άߴϣֵߴ硣
             * @param out The output size to store the result
             * @param size The size to apply transform.
             * @param t transform matrix.
             */
            static transformSize(out: Size, size: Size, t: AffineTransform): void;
            /**
             * @en Apply the `AffineTransform` on a rect.
             * @zh Ӧöά任󵽾ϣֵΡ
             * @param out The output rect object to store the result
             * @param rect The rect object to apply transform.
             * @param t transform matrix.
             */
            static transformRect(out: Rect, rect: Rect, t: AffineTransform): void;
            /**
             * @en Apply the `AffineTransform` on a rect, and turns to an Oriented Bounding Box.
             * This function does not allocate any memory, you should create the output vectors by yourself and manage their memory.
             * @zh Ӧöά任󵽾, תΪΧС
             * κڴ棬ҪȴΧеĸ Vector 洢Ϊǰĸ뺯
             * @param out_bl Output vector for storing the bottom left corner coordinates of the Obb object
             * @param out_tl Output vector for storing the top left corner coordinates of the Obb object
             * @param out_tr Output vector for storing the top right corner coordinates of the Obb object
             * @param out_br Output vector for storing the bottom right corner coordinates of the Obb object
             * @param rect The rect object to apply transform.
             * @param anAffineTransform transform matrix.
             */
            static transformObb(out_bl: Vec2, out_tl: Vec2, out_tr: Vec2, out_br: Vec2, rect: Rect, anAffineTransform: AffineTransform, flipY?: boolean): void;
            /**
             * matrix layout
             * |a  c  tx|
             * |b  d  ty|
             * |0  0  1 |
             */
            a: number;
            b: number;
            c: number;
            d: number;
            tx: number;
            ty: number;
            /**
             * @en constructor an `AffineTransform` object.
             * @zh ά任
             * @param a a
             * @param b b
             * @param c c
             * @param d d
             * @param tx tx
             * @param ty ty
             */
            constructor(a?: number, b?: number, c?: number, d?: number, tx?: number, ty?: number);
        }
        /**
         * @en Two dimensional size type representing the width and height.
         * @zh άߴ硣
         */
        export class Size extends ValueType {
            static ZERO: Readonly<Size>;
            static ONE: Readonly<Size>;
            /**
             * @en Calculate the interpolation result between this size and another one with given ratio
             * @zh ָĲֵʣӵǰߴ絽Ŀߴֵ֮
             * @param out Output Size.
             * @param from Original Size.
             * @param to Target Size.
             * @param ratio The interpolation coefficient.The range is [0,1].
             * @returns A vector consisting of linear interpolation of the width and height of the current size to the width and height of the target size at a specified interpolation ratio, respectively.
             */
            static lerp<Out extends ISizeLike>(out: Out, from: Out, to: Out, ratio: number): Out;
            /**
             * @en Check whether `Size` a is equal to `Size` b.
             * @zh жߴǷȡ
             * @param a Size a.
             * @param b Size b.
             * @returns Returns `true' when both dimensions are equal in width and height; otherwise returns `false'.
             */
            static equals<InType extends ISizeLike>(a: InType, b: InType): boolean;
            set x(val: number);
            get x(): number;
            set y(val: number);
            get y(): number;
            width: number;
            height: number;
            /**
             * @en Constructor a size from another one.
             * @zh ָߴȵĳߴ硣
             * @param other Specified Size.
             */
            constructor(other: Size);
            /**
             * @en Constructor a size with specified values.
             * @zh ָȺ͸߶ȵĳߴ硣
             * @param width width of the Size, default value is 0.
             * @param height height of the Size, default value is 0.
             */
            constructor(width?: number, height?: number);
            /**
             * @en clone the current `Size`.
             * @zh ¡ǰߴ硣
             */
            clone(): Size;
            /**
             * @en Set values with another `Size`.
             * @zh õǰߴʹָĳߴȡ
             * @param other Specified Size.
             * @returns `this`
             */
            set(other: Size): any;
            /**
             * @en Set the value of each component of the current `Size`.
             * @zh õǰߴľ
             * @param width Specified width
             * @param height Specified height
             * @returns `this`
             */
            set(width?: number, height?: number): any;
            /**
             * @en Check whether the current `Size` equals another one.
             * @zh жϵǰߴǷָߴȡ
             * @param other Specified Size
             * @returns Returns `true' when both dimensions are equal in width and height; otherwise returns `false'.
             */
            equals(other: Size): boolean;
            /**
             * @en Calculate the interpolation result between this size and another one with given ratio
             * @zh ָĲֵʣӵǰߴ絽Ŀߴֵ֮
             * @param to Target Size.
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Size, ratio: number): Size;
            /**
             * @en Return the information of the current size in string
             * @zh صǰߴַʾ
             * @returns The information of the current size in string
             */
            toString(): string;
        }
        /**
         * @en Constructs a `Size` object.
         * @zh ȼ `new Size(other)`
         * @param other Specified Size.
         * @returns `new Size(other)`
         */
        export function size(other: Size): Size;
        /**
         * @en Constructs a `Size` object.
         * @zh ȼ `new Size(x, y)`
         * @param width Specified width
         * @param height Specified height
         * @returns `new Size(w, h)`
         */
        export function size(width?: number, height?: number): Size;
        /**
         * @en
         * A 2D rectangle defined by x, y position at the bottom-left corner and width, height.
         * All points inside the rectangle are greater than or equal to the minimum point and less than or equal to the maximum point.
         * The width is defined as xMax - xMin and the height is defined as yMax - yMin.
         * @zh
         * ʾһάΣ½ǵ xy ԼȺ͸߶ɡ
         * ڵе㶼ڵھεС (xMin, yMin) Сڵھε (xMax, yMax)
         * εĿȶΪ xMax - xMin߶ȶΪ yMax - yMin
         */
        export class Rect extends ValueType {
            /**
             * @en Creates a rectangle from two coordinate values.
             * @zh 㴴һΣĿμ xy õľΡ
             * @param v1 Specified point 1.
             * @param v2 Specified point 2.
             * @returns Target rectangle.
             */
            static fromMinMax<Out extends IRectLike, VecLike extends IVec2Like>(out: Out, v1: VecLike, v2: VecLike): Out;
            /**
             * @en Calculate the interpolation result between this rect and another one with given ratio
             * @zh ָĲֵʣӵǰεĿֵ֮
             * @param out Output rect.
             * @param from Original rect.
             * @param to Target rect.
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            static lerp<Out extends IRectLike>(out: Out, from: Out, to: Out, ratio: number): Out;
            /**
             * @en Returns the overlapping portion of 2 rectangles.
             * @zh 㵱ǰָصֵľΣ丳ֵΡ
             * @param out Output Rect.
             * @param one One of the specify Rect.
             * @param other Another of the specify Rect.
             */
            static intersection<Out extends IRectLike>(out: Out, one: Out, other: Out): Out;
            /**
             * @en Returns the smallest rectangle that contains the current rect and the given rect.
             * @zh ͬʱǰκָεСΣ丳ֵΡ
             * @param out Output Rect.
             * @param one One of the specify Rect.
             * @param other Another of the specify Rect.
             */
            static union<Out extends IRectLike>(out: Out, one: Out, other: Out): Out;
            /**
             * @en Returns whether rect a is equal to rect b.
             * @zh жǷȡ
             * @param a The first rect to be compared.
             * @param b The second rect to be compared.
             * @returns Returns `true' when the minimum and maximum values of both rectangles are equal, respectively; otherwise, returns `false'.
             */
            static equals<InType extends IRectLike>(a: InType, b: InType): boolean;
            /**
             * @en The minimum x value.
             * @zh ȡþ x ϵСֵ
             */
            get xMin(): number;
            set xMin(value: number);
            /**
             * @en The minimum y value.
             * @zh ȡþ y ϵСֵ
             */
            get yMin(): number;
            set yMin(value: number);
            /**
             * @en The maximum x value.
             * @zh ȡþ x ϵֵ
             */
            get xMax(): number;
            set xMax(value: number);
            /**
             * @en The maximum y value.
             * @zh ȡþ y ϵֵ
             */
            get yMax(): number;
            set yMax(value: number);
            /**
             * @en The position of the center of the rectangle.
             * @zh ȡþĵꡣ
             */
            get center(): Vec2;
            set center(value: Vec2);
            /**
             * @en Returns a new [[Vec2]] object representing the position of the rectangle
             * @zh ȡþε x  y ꡣ
             */
            get origin(): Vec2;
            set origin(value: Vec2);
            /**
             * @en Returns a new [[Size]] object represents the width and height of the rectangle
             * @zh ȡþεĳߴ硣
             */
            get size(): Size;
            set size(value: Size);
            set z(val: number);
            get z(): number;
            set w(val: number);
            get w(): number;
            /**
             * @en The minimum x value.
             * @zh С x ꡣ
             */
            x: number;
            /**
             * @en The minimum y value.
             * @zh С y ꡣ
             */
            y: number;
            /**
             * @en The width of the Rect.
             * @zh εĿȡ
             */
            width: number;
            /**
             * @en The height of the Rect.
             * @zh εĸ߶ȡ
             */
            height: number;
            /**
             * @en Constructs a Rect from another one.
             * @zh ָȵľΡ
             * @param other Specified Rect.
             */
            constructor(other: Rect);
            /**
             * @en Constructs a Rect with specified values.
             * @zh ָСֵͳߴľΡ
             * @param x The minimum X coordinate of the rectangle.
             * @param y The minimum Y coordinate of the rectangle.
             * @param width The width of the rectangle, measured from the X position.
             * @param height The height of the rectangle, measured from the Y position.
             */
            constructor(x?: number, y?: number, width?: number, height?: number);
            /**
             * @en clone the current Rect.
             * @zh ¡ǰΡ
             */
            clone(): Rect;
            /**
             * @en Set values with another Rect.
             * @zh õǰʹָȡ
             * @param other Specified Rect.
             * @returns `this`
             */
            set(other: Rect): any;
            /**
             * @en Set the value of each component of the current Rect.
             * @zh õǰʹָľȡ
             * @param x The x parameter of the specified rectangle
             * @param y The y parameter of the specified rectangle
             * @param width The width parameter of the specified rectangle
             * @param height The height parameter of the specified rectangle
             * @returns `this`
             */
            set(x?: number, y?: number, width?: number, height?: number): any;
            /**
             * @en Check whether the current Rect equals another one.
             * @zh жϵǰǷָȡ
             * @param other Specified rectangles.
             * @returns Returns `true' when the minimum and maximum values of both rectangles are equal, respectively; otherwise, returns `false'.
             */
            equals(other: Rect): boolean;
            /**
             * @en Calculate the interpolation result between this Rect and another one with given ratio.
             * @zh ָĲֵʣӵǰεĿֵ֮
             * @param to Target Rect.
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Rect, ratio: number): Rect;
            /**
             * @en Return the information of the current rect in string
             * @zh صǰεַʾ
             * @returns The information of the current rect in string
             */
            toString(): string;
            /**
             * @en Check whether the current rectangle intersects with the given one.
             * @zh жϵǰǷָཻ
             * @param other Specified rectangles.
             * @returns If intersected, return `true', otherwise return `false'.
             */
            intersects(other: Rect): boolean;
            /**
             * @en Check whether the current rect contains the given point.
             * @zh жϵǰǷָĵ㡣
             * @param point Specified point.
             * @returns The specified point is included in the rectangle and returns `true', otherwise it returns `false'.
             */
            contains(point: Vec2): boolean;
            /**
             * @en Returns true if the other rect entirely inside this rectangle.
             * @zh жϵǰǷָΡ
             * @param other Specified rectangles.
             * @returns Returns `true' if all the points of the specified rectangle are included in the current rectangle, `false' otherwise.
             */
            containsRect(other: Rect): boolean;
            /**
             * @en Apply matrix4 to the rect.
             * @zh
             * Ӧþ任ǰΣ
             * Ӧþ任ǰεСõµС㣬
             * ǰεĳߴΪάӦþ任õµĳߴ磻
             * ˹ɵ¾Ρ
             * @param matrix The matrix4
             */
            transformMat4(mat: Mat4): Rect;
            /**
             * @en
             * Applies a matrix transformation to the current rectangle and outputs the result to the four vertices.
             * @zh
             * Ӧþ任ǰΣĸϡ
             *
             * @param mat The mat4 to apply
             * @param out_lb The left bottom point
             * @param out_lt The left top point
             * @param out_rb The right bottom point
             * @param out_rt The right top point
             */
            transformMat4ToPoints(mat: Mat4, out_lb: Vec2, out_lt: Vec2, out_rt: Vec2, out_rb: Vec2): void;
        }
        /**
         * @en The convenient method to create a new Rect.
         * @zh ָȵľΡȼ `new Rect(rect)`
         * @param rect Specified Rect.
         * @returns `new Rect(rect)`
         */
        export function rect(rect: Rect): Rect;
        /**
         * @en The convenient method to create a new Rect.
         * @zh ָСֵͳߴľΣȼ`new Rect(x, y, width, height)`
         * @param x The minimum X coordinate of the rectangle.
         * @param y The minimum Y coordinate of the rectangle.
         * @param width The width of the rectangle, measured from the X position.
         * @param height The height of the rectangle, measured from the Y position.
         * @returns `new Rect(x, y, width, height)`
         */
        export function rect(x?: number, y?: number, width?: number, height?: number): Rect;
        /**
         * @en Representation of RGBA colors.<br/>
         * Each color component is an integer value with a range from 0 to 255.<br/>
         * @zh ͨ RedGreenBlue ɫͨʾɫͨ Alpha ͨʾ͸ȡ<br/>
         * ÿͨΪȡֵΧ [0, 255] <br/>
         */
        export class Color extends ValueType {
            static WHITE: Readonly<Color>;
            static GRAY: Readonly<Color>;
            static BLACK: Readonly<Color>;
            static TRANSPARENT: Readonly<Color>;
            static RED: Readonly<Color>;
            static GREEN: Readonly<Color>;
            static BLUE: Readonly<Color>;
            static CYAN: Readonly<Color>;
            static MAGENTA: Readonly<Color>;
            static YELLOW: Readonly<Color>;
            /**
             * @en Copy content of a color into another and save the results to out color.
             * @zh ָɫĿ
             */
            static clone<Out extends IColorLike>(a: Out): Color;
            /**
             * @en Clone a color and save the results to out color.
             * @zh Ŀɫ
             */
            static copy<Out extends IColorLike>(out: Out, a: Out): Out;
            /**
             * @en Set the components of a color to the given values and save the results to out color.
             * @zh ɫֵ
             */
            static set<Out extends IColorLike>(out: Out, r: number, g: number, b: number, a: number): Out;
            /**
             * @en Convert linear color from rgb8 0~255 to Vec4 0~1
             * @zh ǰɫתΪ Vec4
             * @returns Vec4 as float color value
             * @example
             * ```
             * const color = Color.YELLOW;
             * color.toVec4();
             * ```
             */
            static toVec4(color: Color, out?: Vec4): Vec4;
            /**
             * @en Convert 8bit linear color from Vec4
             * @zh ʹ Vec4  8 bit ɫ
             * @returns 8 Bit srgb value
             * @example
             * ```
             * color.fromVec4(new Vec4(1,1,1,1));
             * ```
             */
            static fromVec4(value: Vec4, out?: Color): Color;
            /**
             * @en Converts the hexadecimal formal color into rgb formal and save the results to out color.
             *   the argument `hex` could be hex-string or hex-number (8-digit or 6-digit).
             *   the hex-string should be like : '#12345678' '#123456', '123456', '12345678'.
             *   the hex-number should be like : 0x12345678, 0x123456 .
             * @zh ʮɫַжɫ out 
             *    hex ֧ 16ַ  16ֵ (8λ  6λ).
             *   16ַĸʽӦ: '#12345678' '#123456', '123456', '12345678'.
             *   16ֵĸʽӦ:  0x12345678, 0x123456 .
             */
            static fromHEX<Out extends IColorLike>(out: Out, hex: string | number): Out;
            /**
             * @en Add two colors by components. And save the results to out color.
             * @zh ͨɫӷ
             */
            static add<Out extends IColorLike>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Subtract each components of color b from each components of color a. And save the results to out color.
             * @zh ͨɫ
             */
            static subtract<Out extends IColorLike>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Multiply each components of two colors. And save the results to out color.
             * @zh ͨɫ˷
             */
            static multiply<Out extends IColorLike>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Divide each components of color a by each components of color b. And save the results to out color.
             * @zh ͨɫ
             */
            static divide<Out extends IColorLike>(out: Out, a: Out, b: Out): Out;
            /**
             * @en Multiply all channels in a color with the given scale factor, and save the results to out color.
             * @zh ȫͨͳһɫ
             */
            static scale<Out extends IColorLike>(out: Out, a: Out, b: number): Out;
            /**
             * @en Performs a linear interpolation between two colors.
             * @zh ͨɫԲֵA + t * (B - A)
             */
            static lerp<Out extends IColorLike>(out: Out, from: Out, to: Out, ratio: number): Out;
            /**
             * @en Convert a color object to a RGBA array, and save the results to out color.
             * @zh ɫת
             * @param ofs Array Start Offset
             */
            static toArray<Out extends __private.__types_globals__IWritableArrayLike<number>>(out: Out, a: IColorLike, ofs?: number): Out;
            /**
             * @en Sets the given color with RGBA values in an array, and save the results to out color.
             * @zh תɫ
             * @param ofs Array Start Offset
             */
            static fromArray<Out extends IColorLike>(arr: __private.__types_globals__IWritableArrayLike<number>, out: Out, ofs?: number): Out;
            /**
             * @zh ޷ 32 λɫ 8 λΪ alpha ͨθ 8 λΪɫͨε 8 λΪɫͨ 8 λΪɫͨ
             * @en Construct color from a unsigned 32 bit integer, the highest 8 bits is for alpha channel, the second highest 8 bits is for blue channel,
             * the second lowest 8 bits is for green channel, and the lowest 8 bits if for red channel.
             *
             * @param out @en Output color object. @zh ɫ
             * @param uint32 @en The unsigned 32 bit integer @zh 32 λ޷
             * @returns @en The `out` object @zh `out` 
             */
            static fromUint32<Out extends IColorLike>(out: Out, uint32: number): Out;
            /**
             * @zh תǰɫΪ޷ 32 λ,  8 λΪ alpha ͨθ 8 λΪɫͨε 8 λΪɫͨ 8 λΪɫͨ
             * @en Convert the current color to a unsigned 32 bit integer, the highest 8 bits is for alpha channel,
             * the second highest 8 bits is for blue channel, the second lowest 8 bits is for green channel, and the lowest 8 bits if for red channel.
             *
             * @param color @en The color. @zh ɫ
             * @returns @en The converted unsigned 32 bit integer. @zh 32 λ޷
             */
            static toUint32(color: IColorLike): number;
            /**
             * @en Check whether the two given colors are identical
             * @zh ɫȼж
             */
            static strictEquals<Out extends IColorLike>(a: Out, b: Out): boolean;
            /**
             * @en Check whether the two given colors are approximately equivalent. Difference of each channel is smaller that the epsilon.
             * @zh ųɫƵȼж
             */
            static equals<Out extends IColorLike>(a: Out, b: Out, epsilon?: number): boolean;
            /**
             * @en Convert the given color to a hex color value. And save the results to out color.
             * @zh ȡָɫݱʾ
             */
            static hex<Out extends IColorLike>(a: Out): number;
            /**
             * @en Get or set red channel value.
             * @zh ȡõǰɫ Red ͨ
             */
            get r(): number;
            set r(red: number);
            /**
             * @en Get or set green channel value.
             * @zh ȡõǰɫ Green ͨ
             */
            get g(): number;
            set g(green: number);
            /**
             * @en Get or set blue channel value.
             * @zh ȡõǰɫ Blue ͨ
             */
            get b(): number;
            set b(blue: number);
            /** @en Get or set alpha channel value.
             * @zh ȡõǰɫ͸ͨ
             */
            get a(): number;
            set a(alpha: number);
            get x(): number;
            set x(value: number);
            get y(): number;
            set y(value: number);
            get z(): number;
            set z(value: number);
            get w(): number;
            set w(value: number);
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _val: number;
            /**
             * @en Construct a same color from the given color
             * @zh ָɫȵɫ
             * @param other Specified color
             */
            constructor(other: Color);
            /**
             * @en Construct a color form the hex color string
             * @zh ʮɫַйɫ
             * @param hexString Hexadecimal color string.
             */
            constructor(hexString: string);
            /**
             * @en Construct a color
             * @zh ָͨɫ
             * @param r red component of the color, default value is 0.
             * @param g green component of the color, default value is 0.
             * @param b blue component of the color, default value is 0.
             * @param a alpha component of the color, default value is 255.
             */
            constructor(r?: number, g?: number, b?: number, a?: number);
            /**
             * @en Clone a new color from the current color.
             * @zh ¡ǰɫ
             */
            clone(): Color;
            /**
             * @en Check whether the current color is identical with the given color
             * @zh жϵǰɫǷָɫȡ
             * @param other Specified color
             * @returns Returns `true` when all channels of both colours are equal; otherwise returns `false`.
             */
            equals(other: Color): boolean;
            /**
             * @en Calculate linear interpolation result between this color and another one with given ratio
             * @zh ָĲֵʣӵǰɫĿɫֵ֮
             * @param to Target color
             * @param ratio The interpolation coefficient.The range is [0,1].
             */
            lerp(to: Color, ratio: number): Color;
            /**
             * @en Convert to string with color informations
             * @zh صǰɫַʾ
             * @returns A string representation of the current color.
             */
            toString(): string;
            /**
             * @en Convert color to css format.
             * @zh ǰɫתΪ CSS ʽ
             * @param opt "rgba", "rgb", "#rgb" or "#rrggbb".
             * @returns CSS format for the current color.
             * @example
             * ```ts
             * let color = cc.Color.BLACK;
             * color.toCSS();          // "rgba(0,0,0,1.00)";
             * color.toCSS("rgba");    // "rgba(0,0,0,1.00)";
             * color.toCSS("rgb");     // "rgba(0,0,0)";
             * color.toCSS("#rgb");    // "#000";
             * color.toCSS("#rrggbb"); // "#000000";
             * ```
             */
            toCSS(opt?: ("rgba" | "rgb" | "#rrggbb" | "#rrggbbaa")): string;
            /**
             * @en Converts the hexadecimal formal color into rgb formal and save the results to current color object.
             *   the argument `hex` could be hex-string or hex-number (8-digit or 6-digit).
             *   the hex-string should be like : '#12345678' '#123456', '123456', '12345678'.
             *   the hex-number should be like : 0x12345678, 0x123456 .
             * @zh ʮɫַжɫ ǰcolor
             *    hex ֧ 16ַ  16ֵ (8λ  6λ).
             *   16ַĸʽӦ: '#12345678' '#123456', '123456', '12345678'.
             *   16ֵĸʽӦ:  0x12345678, 0x123456 .
             * @param hex the hex-string or hex-number
             * @returns `this`
             */
            fromHEX(hex: string | number): Color;
            /**
             * @en convert Color to HEX color string.
             * @zh תǰɫΪʮɫַ
             * @param fmt "#rrggbb" or "#rrggbbaa".
             * - `'#rrggbbaa'` obtains the hexadecimal value of the Red, Green, Blue, Alpha channels (**two**, high complement 0) and connects them sequentially.
             * - `'#rrggbb'` is similar to `'#rrggbbaa'` but does not include the Alpha channel.
             * @returns the Hex color string
             * @example
             * ```
             * const color = new Color(255, 14, 0, 255);
             * color.toHEX("#rgb");      // "f00";
             * color.toHEX("#rrggbbaa"); // "ff0e00ff"
             * color.toHEX("#rrggbb");   // "ff0e00"
             * ```
             */
            toHEX(fmt?: "#rgb" | "#rrggbb" | "#rrggbbaa"): string;
            /**
             * @en Convert to rgb value.
             * @zh ǰɫתΪ RGB ֵ
             * @returns RGB integer value. Starting from the lowest valid bit, each 8 bits is the value of the Red, Green, and Blue channels respectively.
             * @example
             * ```
             * const color = Color.YELLOW;
             * color.toRGBValue();
             * ```
             */
            toRGBValue(): number;
            /**
             * @en Read HSV model color and convert to RGB color.
             * @zh  HSV ɫж뵱ǰɫ
             * @param h H value
             * @param s S value
             * @param v V value
             * @returns `this`
             * @example
             * ```
             * const color = Color.YELLOW;
             * color.fromHSV(0, 0, 1); // Color {r: 255, g: 255, b: 255, a: 255};
             * ```
             */
            fromHSV(h: number, s: number, v: number): Color;
            /**
             * @en Transform to HSV model color.
             * @zh תǰɫΪ HSV ɫ
             * @returns HSV format color
             * @example
             * ```
             * import { Color } from 'cc';
             * const color = Color.YELLOW;
             * color.toHSV(); // {h: 0.1533864541832669, s: 0.9843137254901961, v: 1}
             * ```
             */
            toHSV(): {
                h: number;
                s: number;
                v: number;
            };
            /**
             * @en Set the color.
             * @zh õǰɫʹָɫȡ
             * @param other The specified color.
             * @overload
             * @param [r=0] red component of the color, the range is [0-255]
             * @param [g=0] green component of the color
             * @param [b=0] blue component of the color
             * @param [a=255] alpha component of the color
             * @returns Current color.
             */
            set(other: Color): Color;
            set(r?: number, g?: number, b?: number, a?: number): Color;
            /**
             * @en Multiplies the current color by the specified color.
             * @zh ǰɫָɫ
             * @param other The specified color.
             */
            multiply(other: Color): Color;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _set_r_unsafe(red: number): Color;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _set_g_unsafe(green: number): Color;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _set_b_unsafe(blue: number): Color;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _set_a_unsafe(alpha: number): Color;
        }
        export function color(other: Color | string): Color;
        export function color(r?: number, g?: number, b?: number, a?: number): Color;
        /**
         * @en Tests whether or not the arguments have approximately the same value, within an absolute<br/>
         * or relative tolerance of glMatrix.EPSILON (an absolute tolerance is used for values less<br/>
         * than or equal to 1.0, and a relative tolerance is used for larger values)
         * @zh glMatrixľԻݲΧڣԲǷнֵͬ<br/>
         * EPSILON(Сڵ1.0ֵþԹ1.0ֵԹ)
         * @param a The first number to test.
         * @param b The second number to test.
         * @return True if the numbers are approximately equal, false otherwise.
         */
        export function equals(a: number, b: number): boolean;
        /**
         * @en Tests whether or not the arguments have approximately the same value by given maxDiff<br/>
         * @zh ͨ죬ԲǷнֵͬ
         * @param a The first number to test.
         * @param b The second number to test.
         * @param maxDiff Maximum difference.
         * @return True if the numbers are approximately equal, false otherwise.
         */
        export function approx(a: number, b: number, maxDiff?: number): boolean;
        /**
         * @en Clamps a value between a minimum float and maximum float value.<br/>
         * @zh С󸡵֮һֵʹ clamp ϱ仯ֵڷΧڡ
         * @param val
         * @param min
         * @param max
         */
        export function clamp(val: number, min: number, max: number): number;
        /**
         * @en Clamps a value between 0 and 1.<br/>
         * @zh ֵ01֮䡣
         * @param val
         */
        export function clamp01(val: number): number;
        /**
         * @en Linear interpolation between two numbers
         * @zh ֮Բֵ
         * @param from - The starting number.
         * @param to - The ending number.
         * @param ratio - The interpolation coefficient, t should be in the range [0, 1].
         */
        export function lerp(from: number, to: number, ratio: number): number;
        /**
         * @en Convert Degree To Radian<br/>
         * @zh ѽǶȻɻȡ
         * @param {Number} a Angle in Degrees
         */
        export function toRadian(a: number): number;
        /**
         * @en Convert Radian To Degree<br/>
         * @zh ѻȻɽǶȡ
         * @param {Number} a Angle in Radian
         */
        export function toDegree(a: number): number;
        /**
         * @method random
         */
        export function random(): number;
        /**
         * @en Set a custom random number generator, default to Math.random
         * @zh ԶĬΪ Math.random
         * @param func custom random number generator
         */
        export function setRandGenerator<TFunction extends (...any: any[]) => number>(func: TFunction): void;
        /**
         * @en Returns a floating-point random number between min (inclusive) and max (exclusive).<br/>
         * @zh С()()֮ĸ
         * @method randomRange
         * @param min
         * @param max
         * @return {Number} The random number.
         */
        export function randomRange(min: number, max: number): number;
        /**
         * @en Returns a random integer between min (inclusive) and max (exclusive).<br/>
         * @zh С()()֮
         * @param min
         * @param max
         * @return The random integer.
         */
        export function randomRangeInt(min: number, max: number): number;
        /**
         * @en
         * Linear congruence generator using Hull-Dobell Theorem.
         * @zh
         * ʹ Hull-Dobell 㷨ͬα
         *
         * @param seed The random seed.
         * @return The pseudo random.
         */
        export function pseudoRandom(seed: number): number;
        /**
         * @en
         * Returns a floating-point pseudo-random number between min (inclusive) and max (exclusive).
         * @zh
         * һڷΧڵĸαע⣬ֵ߽
         *
         * @param seed
         * @param min
         * @param max
         * @return The random number.
         */
        export function pseudoRandomRange(seed: number, min: number, max: number): number;
        /**
         * @en Returns a pseudo-random integer between min (inclusive) and max (exclusive).<br/>
         * @zh С()()֮ĸα
         * @param seed
         * @param min
         * @param max
         * @return The random integer.
         */
        export function pseudoRandomRangeInt(seed: number, min: number, max: number): number;
        /**
         * @en
         * Returns the next power of two for the value.<br/>
         * @zh
         * һӽ 2 
         *
         * @param val
         * @return The the next power of two.
         */
        export function nextPow2(val: number): number;
        /**
         * @en Returns float remainder for t / length.<br/>
         * @zh t / lengthĸ
         * @param t Time start at 0.
         * @param length Time of one cycle.
         * @return The Time wrapped in the first cycle.
         */
        export function repeat(t: number, length: number): number;
        /**
         * @en
         * Returns time wrapped in ping-pong mode.
         * @zh
         * ƹģʽµʱ
         *
         * @param t Time start at 0.
         * @param length Time of one cycle.
         * @return The time wrapped in the first cycle.
         */
        export function pingPong(t: number, length: number): number;
        /**
         * @en Returns ratio of a value within a given range.<br/>
         * @zh ظΧڵֵıʡ
         * @param from Start value.
         * @param to End value.
         * @param value Given value.
         * @return The ratio between [from, to].
         */
        export function inverseLerp(from: number, to: number, value: number): number;
        /**
         * @en Compare the absolute values of all components and the component with the largest absolute value will be returned.
         * @zh зľֵбȽϴСؾֵķ
         * @param v vec3 like value
         * @returns max absolute component
         */
        export function absMaxComponent(v: IVec3Like): number;
        /**
         * @en Compare the absolute value of two values and return the value with the largest absolute value
         * @zh  a b ľֵбȽϴСؾֵֵ
         * @param a number
         * @param b number
         */
        export function absMax(a: number, b: number): number;
        /**
         * @en
         * Make the attributes of the specified class available to be enumerated
         * @zh
         * ʹָضԿɱö
         * @param prototype Inherit the prototype chain of the ValueType class
         * @param attrs List of attributes that need to be enumerated
         */
        export function enumerableProps(prototype: ValueType, attrs: string[]): void;
        export function floatToHalf(val: number): number;
        export function halfToFloat(val: number): number;
        export const HALF_PI: number;
        export const TWO_PI: number;
        export const EPSILON = 0.000001;
        export interface IColorLike {
            r: number;
            g: number;
            b: number;
            a: number;
            _val: number;
        }
        export interface IMat3Like {
            m00: number;
            m01: number;
            m02: number;
            m03: number;
            m04: number;
            m05: number;
            m06: number;
            m07: number;
            m08: number;
        }
        export interface IMat4Like {
            m00: number;
            m01: number;
            m02: number;
            m03: number;
            m04: number;
            m05: number;
            m06: number;
            m07: number;
            m08: number;
            m09: number;
            m10: number;
            m11: number;
            m12: number;
            m13: number;
            m14: number;
            m15: number;
        }
        export interface IQuatLike {
            x: number;
            y: number;
            z: number;
            w: number;
        }
        export interface IRectLike {
            x: number;
            y: number;
            width: number;
            height: number;
        }
        export interface ISizeLike {
            width: number;
            height: number;
        }
        export interface IVec2Like {
            x: number;
            y: number;
        }
        export interface IVec3Like {
            x: number;
            y: number;
            z: number;
        }
        export interface IVec4Like {
            x: number;
            y: number;
            z: number;
            w: number;
        }
        export type FloatArray = Float64Array | Float32Array;
        export type IVec2 = IVec2Like | Readonly<IVec2Like>;
        export type IVec3 = IVec3Like | Readonly<IVec3Like>;
        export type IVec4 = IVec4Like | Readonly<IVec4Like>;
        export type IMat3 = IMat3Like | Readonly<IMat3Like>;
        export type IMat4 = IMat4Like | Readonly<IMat4Like>;
        export type IRect = IRectLike | Readonly<IRectLike>;
        export type IQuat = IQuatLike | Readonly<IQuatLike>;
        export type IColor = IColorLike | Readonly<IColorLike>;
        export const MATH_FLOAT_ARRAY: Float32ArrayConstructor | Float64ArrayConstructor;
        export class MathBase extends ValueType {
            static createFloatArray(size: number): Float64Array | Float32Array;
            /**
             * @en Get the internal array data.
             * @zh ȡڲ array ݡ
             */
            get array(): FloatArray;
            protected _array: FloatArray;
        }
    }
    export namespace memop {
        /**
         * @en Typed object pool.
         * It's a traditional design, you can get elements out of the pool or recycle elements by putting back into the pool.
         * @zh ֧͵ĶءһͳƵĶأԴӶȡǷŻزҪá
         * @see [[RecyclePool]]
         */
        export class Pool<T> extends __private._cocos_core_memop_scalable_container__ScalableContainer {
            /**
             * @en Constructor with the allocator of elements and initial pool size.
             * @zh ʹԪصĹͳʼСĹ캯
             * @param ctor @en The allocator of elements in pool, it's invoked directly without `new` in Pool.
             * @zh ԪصĹPool ڲʹøùֱӴʵ
             * @param elementsPerBatch @en Initial pool size, this size will also be the incremental size when
             * the pool is overloaded.
             * @zh صĳʼСʱҲʹøֵ
             * @param dtor @en The finalizer of element, it's invoked when this Pool is destroyed or shrunk if
             * it is valid.
             * @zh ԪصڵĻٻʱʹø
             */
            constructor(ctor: () => T, elementsPerBatch: number, dtor?: (obj: T) => void);
            /**
             * @en Take an object out of the object pool.
             * @zh Ӷȡһ
             * @returns @en An object ready for use. This function always returns an object.
             * @zh úǷһõĶ
             */
            alloc(): T;
            /**
             * @en Put an object back into the object pool.
             * @zh һŻضС
             * @param obj @en The object to be put back into the pool.
             * @zh ŻضеĶ
             */
            free(obj: T): void;
            /**
             * @en Put multiple objects back into the object pool.
             * @zh һŻضС
             * @param objs @en An array of objects to be put back into the pool.
             * @zh Żضеһ
             */
            freeArray(objs: T[]): void;
            /**
             * @en Try to shrink the object pool to reduce memory usage.
             * @zh ݶأͷڴ档
             */
            tryShrink(): void;
            /**
             * @en Destroy all elements and clear the pool.
             * @zh ͷŶԴջء
             */
            destroy(): void;
        }
        /**
         * @en Recyclable object pool. It's designed to be entirely reused each time.
         * There is no put and get method, each time you get the [[data]], you can use all elements as new.
         * You shouldn't simultaneously use the same RecyclePool in more than two overlapped logic.
         * Its size can be automatically incremented or manually resized.
         * @zh ѭءֳӱΪÿʹöá
         * ûлպȡĺͨȡ [[data]] ԻȡԪأȫӦñ¶ʹá
         * ߲Ӧ໥Ĳͬ߼ͬʱʹͬһѭء
         * ӳߴڳʱԶ䣬Ҳֶ
         * @see [[Pool]]
         */
        export class RecyclePool<T = any> extends __private._cocos_core_memop_scalable_container__ScalableContainer {
            /**
             * @en Constructor with the allocator of elements and initial pool size, all elements will be pre-allocated.
             * @zh ʹԪصĹͳʼСĹ캯ԪضᱻԤ
             * @param fn The allocator of elements in pool, it's invoked directly without `new`
             * @param size Initial pool size
             * @param dtor The finalizer of element, it's invoked when this container is destroyed or shrunk
             */
            constructor(fn: () => T, size: number, dtor?: (obj: T) => void);
            /**
             * @en The length of the object pool.
             * @zh شС
             */
            get length(): number;
            /**
             * @en The underlying array of all pool elements.
             * @zh ʵʶ顣
             */
            get data(): T[];
            /**
             * @en Resets the object pool. Only changes the length to 0.
             * @zh նءĿǰóߴΪ 0
             */
            reset(): void;
            /**
             * @en Resize the object poo, and fills with new created elements.
             * @zh öشСµԪء
             * @param size @en The new size of the pool. @zh µĶشС
             */
            resize(size: number): void;
            /**
             * @en Expand the array size to 2 times the original size, and fills with new created elements.
             * @zh Զߴ絽ԭ 2 µԪء
             */
            add(): T;
            /**
             * @en Destroy the object pool. Please don't use it any more after it is destroyed.
             * @zh ٶءٺܼʹá
             */
            destroy(): void;
            /**
             * @en Try to shrink the object pool to free memory.
             * @zh ԻûõĶͷڴ档
             */
            tryShrink(): void;
            /**
             * @en Remove the element with the specified index from the object pool. This will decrease pool size.
             * @zh ƳָԪأСӳߴ硣
             * @param idx @en The index of the element to remove. @zh ƳԪص
             */
            removeAt(idx: number): void;
        }
        /**
         * @en
         * Cached array is a data structure for objects cache, it's designed for persistent data.
         * Its content array length will keep grow.
         * @zh
         * ڶ󻺴ͷװһڲױƳĳפݡ
         * ڲ鳤Ȼ١
         */
        export class CachedArray<T> extends __private._cocos_core_memop_scalable_container__ScalableContainer {
            /**
             * @en
             * The array which stores actual content.
             * @zh
             * ʵʴ洢ݵ顣
             */
            array: T[];
            /**
             * @en
             * The actual count of data object.
             * @zh
             * ʵʴ洢Ԫ
             */
            length: number;
            /**
             * @en Constructor. @zh 캯
             * @param length @en Initial length of the CachedArray. @zh CachedArray ĳʼȡ
             * @param compareFn @en Function used to determine the order of the elements. It is expected to return
             * a negative value if the first argument is less than the second argument, zero if they're equal, and a positive
             * value otherwise. If omitted, the elements are sorted in ascending, ASCII character order.
             * @zh ȷԪ˳ĺһСڵڶӦ÷һֵȣ򷵻0򷵻һֵ
             * ʡԣԪؽ ASCII ַ
             */
            constructor(length: number, compareFn?: (a: T, b: T) => number);
            /**
             * @en
             * Push an element to the end of the array.
             * @zh
             * ĩβһԪء
             * @param item @en The item to be added. @zh ӵԪء
             */
            push(item: T): void;
            /**
             * @en
             * Pop the last element in the array. The [[length]] will reduce, but the internal array will keep its size.
             * @zh
             * һԪأCachedArray  [[length]] ٣ڲʵʳȲ䡣
             * @returns @en The last element of this CachedArray. If CachedArray is empty, will return undefined.
             * @zh һԪءΪգ undefined
             */
            pop(): T | undefined;
            /**
             * @en
             * Get the element at the specified index of the array.
             * @zh
             * ȡָλõԪء
             * @param idx @en The index of the requested element. @zh ڻȡԪص
             * @returns @en The element at given index. If idx not in [0, [[length]]) or array is empty, will return undefined.
             * @zh ±ӦԪء idx  [0, [[length]]ǿյģ undefined
             */
            get(idx: number): T | undefined;
            /**
             * @en
             * Clear the cache. The [[length]] will be set to 0, but the internal array will keep its size.
             * @zh
             * Ԫء[[length]] ᱻΪ 0ڲʵʳȲ
             */
            clear(): void;
            /**
             * @en
             * Destroy the array. The [[length]] will be set to 0, and clear the internal array.
             * @zh
             * 顣[[length]] ᱻΪ 0ڲ顣
             */
            destroy(): void;
            /**
             * @en Requests the removal of unused capacity.
             * @zh ͷŶڴ档
             */
            tryShrink(): void;
            /**
             * @en
             * Sort the existing elements in cache by [[compareFn]] passed in constructor.
             * If [[compareFn]] is not passed in, the elements are sorted in ascending, ASCII character order.
             * @zh
             * ʹù캯 [[compareFn]] ԪءûдȽϺ ASCII 
             */
            sort(): void;
            /**
             * @en
             * Add all elements of a given array to the end of the current array.
             * @zh
             * һָеԪصǰĩβ
             * @param array @en The given array to be appended. @zh ӵ顣
             */
            concat(array: T[]): void;
            /**
             * @en Delete the element at the specified location and move the last element to that location.
             * @zh ɾָλõԪزһԪƶλá
             * @param idx @en The index of the element to be deleted. If idx out of range [0, length), there is
             * not effect.
             *  @zh ϣɾ [0, length)ûЧ
             */
            fastRemove(idx: number): void;
            /**
             * @en Returns the first index that compares equal to val.
             * @zh ҵĵһ val ȵԪص
             * @param val @en Value to search for. @zh ֵ
             * @returns The index to the first element that compares equal to val. If no elements match, returns -1.
             * @zh һ val ȵԪصûҵ -1
             */
            indexOf(val: T): number;
        }
    }
    export namespace geometry {
        /**
         * ιģ
         * @module geometry
         */
        /**
         * @en
         * The enum type of basic geometry.
         * @zh
         * ״ֵ
         */
        export const enums: {
            SHAPE_RAY: number;
            SHAPE_LINE: number;
            SHAPE_SPHERE: number;
            SHAPE_AABB: number;
            SHAPE_OBB: number;
            SHAPE_PLANE: number;
            SHAPE_TRIANGLE: number;
            SHAPE_FRUSTUM: number;
            SHAPE_FRUSTUM_ACCURATE: number;
            SHAPE_CAPSULE: number;
            SHAPE_SPLINE: number;
        };
        export namespace distance {
            /**
             * @en
             * Calculates the distance between a point and a plane.
             * @zh
             * ƽ֮ľ롣
             * @param point @en The target point. @zh Ŀ㡣
             * @param plane @en The target plane. @zh Ŀƽ档
             * @returns @en The distance between the point and the plane. @zh ƽ֮ľ롣
             */
            export function point_plane(point: math.Vec3, plane_: Plane): number;
            /**
             * @en
             * Calculates the closest point on a plane to a given point.
             * @zh
             * ƽӽĵ㡣
             * @param out @en The closest point. @zh 㡣
             * @param point @en The given point. @zh 㡣
             * @param plane @en The target plane. @zh ƽ档
             * @returns @en The result of the closest point, same as the `out` parameter. @zh 洢 `out` Ϊͬһ
             */
            export function pt_point_plane(out: math.Vec3, point: math.Vec3, plane_: Plane): math.Vec3;
            /**
             * @en
             * Calculates the closest point on an AABB to a given point.
             * @zh
             *  AABB ӽĵ㡣
             * @param out @en The closest point. @zh 㡣
             * @param point @en The given point @zh 㡣
             * @param aabb @en The target AABB to calculate. @zh  AABB ʵ
             * @returns @en The result of the closest point, same as the `out` parameter. @zh 洢 `out` Ϊͬһ
             */
            export function pt_point_aabb(out: math.Vec3, point: math.Vec3, aabb_: AABB): math.Vec3;
            /**
             * @en
             * Calculates the closest point on an OBB to a given point.
             * @zh
             *  OBB ӽĵ㡣
             * @param out @en The closest point. @zh 㡣
             * @param point @en The given point. @zh 㡣
             * @param obb @en The target OBB to calculate. @zh  OBB ʵ
             * @returns @en The result of the closest point, same as the `out` parameter. @zh 洢 `out` Ϊͬһ
             */
            export function pt_point_obb(out: math.Vec3, point: math.Vec3, obb_: OBB): math.Vec3;
            /**
             * @en
             * Calculates the closest point on the line, which is from A to B, to the given point.
             * @zh
             * ߶ AB һ㡣
             * @param out @en The closest point. @zh 㡣
             * @param point @en The given point. @zh 
             * @param linePointA @en Point A on the line. @zh ϵĳ A
             * @param linePointB @en Point B on the line. @zh ϵĳ B
             */
            export function pt_point_line(out: math.Vec3, point: math.Vec3, linePointA: math.Vec3, linePointB: math.Vec3): void;
        }
        /**
         * @en
         * Algorithm of intersect detect for basic geometry.
         * @zh
         * εཻԼ㷨
         */
        export const intersect: {
            raySphere: (ray: Ray, sphere: Sphere) => number;
            rayAABB: (ray: Ray, aabb: AABB) => number;
            rayOBB: (ray: Ray, obb: OBB) => number;
            rayPlane: (ray: Ray, plane: Plane) => number;
            rayTriangle: (ray: Ray, triangle: Triangle, doubleSided?: boolean) => number;
            rayCapsule: (ray: Ray, capsule: Capsule) => number;
            raySubMesh: (ray: Ray, submesh: RenderingSubMesh, options?: IRaySubMeshOptions) => number;
            rayMesh: (ray: Ray, mesh: Mesh, options?: IRayMeshOptions) => number;
            rayModel: (r: Ray, model: renderer.scene.Model, options?: IRayModelOptions) => number;
            lineSphere: typeof __private._cocos_core_geometry_intersect__lineSphere;
            lineAABB: typeof __private._cocos_core_geometry_intersect__lineAABB;
            lineOBB: typeof __private._cocos_core_geometry_intersect__lineOBB;
            linePlane: (line: Line, plane: Plane) => number;
            lineTriangle: (line: Line, triangle: Triangle, outPt?: math.Vec3) => number;
            sphereWithSphere: (sphere0: Sphere, sphere1: Sphere) => boolean;
            sphereAABB: (sphere: Sphere, aabb: AABB) => boolean;
            sphereOBB: (sphere: Sphere, obb: OBB) => boolean;
            spherePlane: (sphere: Sphere, plane: Plane) => number;
            sphereFrustum: (sphere: Sphere, frustum: Frustum) => number;
            sphereFrustumAccurate: (sphere: Sphere, frustum: Frustum) => number;
            sphereCapsule: (sphere: Sphere, capsule: Capsule) => boolean;
            aabbWithAABB: (aabb1: AABB, aabb2: AABB) => boolean;
            aabbWithOBB: (aabb: AABB, obb: OBB) => number;
            aabbPlane: (aabb: AABB, plane: Plane) => number;
            aabbFrustum: (aabb: AABB, frustum: Readonly<Frustum>) => number;
            aabbFrustumAccurate: (aabb: AABB, frustum: Frustum) => number;
            obbWithOBB: (obb1: OBB, obb2: OBB) => number;
            obbPlane: (obb: OBB, plane: Plane) => number;
            obbFrustum: (obb: OBB, frustum: Frustum) => number;
            obbFrustumAccurate: (obb: OBB, frustum: Frustum) => number;
            obbPoint: (obb: OBB, point: math.Vec3) => boolean;
            obbCapsule: (obb: OBB, capsule: Capsule) => boolean | 1 | 0;
            aabbFrustumCompletelyInside: (aabb: AABB, frustum: Readonly<Frustum>) => number;
            capsuleWithCapsule: (capsuleA: Capsule, capsuleB: Capsule) => boolean;
            /**
             * @en Check intersection between two geometries, it accept all basic geometry types in [[geometry]] module.
             * @zh ཻԼ⣬ [[geometry]] ģеĻ״
             * @param g1 @en The first geometry. @zh һ塣
             * @param g2 @en The second geometry. @zh ڶ塣
             * @param outPt @en A 3d point to store the intersection point result, only part of the geometries support this.
             *              @zh ѡڱཻ󡣣ע״ļֵ
             */
            resolve(g1: any, g2: any, outPt?: null): number;
        };
        /**
         * @en
         * Basic Geometry: Line.
         * @zh
         * Σֱߡ
         */
        export class Line {
            /**
             * @en
             * Creates a new line.
             * @zh
             * һµֱߡ
             * @param sx @en The x coordinate of the start position. @zh  x ꡣ
             * @param sy @en The y coordinate of the start position. @zh  y ꡣ
             * @param sz @en The z coordinate of the start position. @zh  z ꡣ
             * @param ex @en The x coordinate of the end position. @zh յ x ꡣ
             * @param ey @en The y coordinate of the end position. @zh յ y ꡣ
             * @param ez @en the z coordinate of the end position. @zh յ z ꡣ
             * @returns @en The created line. @zh ֱߡ
             */
            static create(sx: number, sy: number, sz: number, ex: number, ey: number, ez: number): Line;
            /**
             * @en
             * Creates a new Line initialized with values from an existing Line.
             * @zh
             * ¡һµֱߡ
             * @param a @en The line to clone from. @zh ¡Դ Line 
             * @returns @en The cloned line. @zh ¡ Line 
             */
            static clone(a: Line): Line;
            /**
             * @en
             * Copies the values from one Line to another.
             * @zh
             * һֱߵֵһֱС
             * @param out @en The output line to store the copied data. @zh 洢ݵ Line 
             * @param a @en The line to copy from. @zh  Line 󿽱Ϣ
             * @returns @en The `out` parameter. @zh  `out` 
             */
            static copy(out: Line, a: Line): Line;
            /**
             * @en
             * Creates a line from two points.
             * @zh
             * 㴴һֱߡ
             * @param out @en The output line. @zh ݵ Line 
             * @param start @en The start point. @zh 㡣
             * @param end @en The end point. @zh յ㡣
             * @returns @en The `out` parameter. @zh  out 
             */
            static fromPoints(out: Line, start: math.Vec3, end: math.Vec3): Line;
            /**
             * @en
             * Sets the start point and the end point of a line with the given values.
             * @zh
             * ߶εյΪֵ
             * @param out @en The output line to set properties. to @zh ݵ Line 
             * @param sx @en The x coordinate of the start position. @zh  x ꡣ
             * @param sy @en The y coordinate of the start position. @zh  y ꡣ
             * @param sz @en The z coordinate of the start position. @zh  z ꡣ
             * @param ex @en The x coordinate of the end position. @zh յ x ꡣ
             * @param ey @en The y coordinate of the end position. @zh յ y ꡣ
             * @param ez @en the z coordinate of the end position. @zh յ z ꡣ
             * @returns @en The `out` parameter. @zh  `out` 
             */
            static set(out: Line, sx: number, sy: number, sz: number, ex: number, ey: number, ez: number): Line;
            /**
             * @en Calculates the length of the given line.
             * @zh ߵĳȡ
             * @param a @en The line to calculate length. @zh ڼ㳤ȵ߶Ρ
             * @returns @en The length of the given line. @zh ߶εĳȡ
             */
            static len(a: Line): number;
            /**
             * @en The start point.
             * @zh 㡣
             */
            s: math.Vec3;
            /**
             * @en The end point.
             * @zh յ㡣
             */
            e: math.Vec3;
            /**
             * @en Gets the type of the shape. Always returns `enums.SHAPE_LINE`.
             * @zh ȡ״ͣǷ `enums.SHAPE_LINE`
             */
            get type(): number;
            /**
             * @en Constructs a line.
             * @zh һߡ
             * @param sx @en The x coordinate of the start position. @zh  x ꡣ
             * @param sy @en The y coordinate of the start position. @zh  y ꡣ
             * @param sz @en The z coordinate of the start position. @zh  z ꡣ
             * @param ex @en The x coordinate of the end position. @zh յ x ꡣ
             * @param ey @en The y coordinate of the end position. @zh յ y ꡣ
             * @param ez @en the z coordinate of the end position. @zh յ z ꡣ
             */
            constructor(sx?: number, sy?: number, sz?: number, ex?: number, ey?: number, ez?: number);
            /**
             * @en Calculates the length of the line.
             * @zh ߶εĳȡ
             * @returns @en The length of the line. @zh ߶εĳȡ
             */
            length(): number;
        }
        /**
         * @en
         * Basic Geometry: Plane.
         * Plane Equation: a*x + b*y + c*z - d = 0.
         * @zh
         * Σƽ档
         * ƽ淽: a*x + b*y + c*z - d = 0
         */
        export class Plane {
            /**
             * @en
             * Creates a new plane.
             * @zh
             * һµƽ档
             * @param nx @en The x component of normal vector. @zh  x ֡
             * @param ny @en The y component of normal vector. @zh  y ֡
             * @param nz @en The z component of normal vector. @zh  z ֡
             * @param d  @en The distance between normal vector and the origin. @zh ԭľ롣
             * @returns @en The created plane object. @zh ´ƽ档
             */
            static create(nx: number, ny: number, nz: number, d: number): Plane;
            /**
             * @en
             * Clones a new plane.
             * @zh
             * ¡һµƽ档
             * @param p @en The Plane object to be cloned from. @zh ¡Դƽ
             * @returns @en The cloned Plane object @zh ¡ƽ
             */
            static clone(p: Plane): Plane;
            /**
             * @en
             * Copies the values from one plane to another.
             * @zh
             * һƽֵһ
             * @param out @en The object to be operated on. @zh ܲĶ
             * @param p @en The source of replication. @zh ƵԴ
             * @returns @en The object to be operated on. @zh ܲĶ
             */
            static copy(out: Plane, p: Plane): Plane;
            /**
             * @en
             * Creates a plane from three points
             * @zh
             * 㴴һƽ档
             * @param out @en The Plane object to be operated on. @zh ܲĶ
             * @param a @en The point a. @zh  a
             * @param b @en The point b. @zh  b
             * @param c @en The point c. @zh  c
             * @returns @en The Plane object to be operated on, same as `out` parameter. @zh ܲĶ `out` ͬ
             */
            static fromPoints(out: Plane, a: math.Vec3, b: math.Vec3, c: math.Vec3): Plane;
            /**
             * @en
             * Sets the components of a plane to the given values.
             * @zh
             * ƽΪֵ
             * @param out @en The Plane object to be operated on. @zh ܲĶ
             * @param nx @en The x component of normal vector. @zh  x ֡
             * @param ny @en The y component of normal vector. @zh  y ֡
             * @param nz @en The z component of normal vector. @zh  z ֡
             * @param d  @en The distance between normal vector and the origin. @zh ԭľ롣
             * @returns @en The object to be operated on, same as the `out` parameter. @zh ܲĶ `out` ͬ
             */
            static set(out: Plane, nx: number, ny: number, nz: number, d: number): Plane;
            /**
             * @en
             * Creates plane from normal and point.
             * @zh
             * һߺһ㴴ƽ档
             * @param out @en The object to be operated on. @zh ܲĶ
             * @param normal @en The normal of the plane. @zh ƽķߡ
             * @param point @en A point in the plane. @zh ƽϵһ㡣
             * @returns @en The object to be operated on, same as the `out` parameter. @zh ܲĶ `out` ͬ
             */
            static fromNormalAndPoint(out: Plane, normal: math.Vec3, point: math.Vec3): Plane;
            /**
             * @en
             * Normalizes a plane.
             * @zh
             * һһƽ档
             * @param out @en The object to be operated on. @zh ܲĶ
             * @param a @en Source data for the operation. @zh Դݡ
             * @returns @en The object to be operated on, sames as the `out` parameter. @zh ܲĶ `out` ͬ
             */
            static normalize(out: Plane, a: Plane): Plane;
            /**
             * @en
             * The normal of the plane.
             * @zh
             * 
             */
            n: math.Vec3;
            /**
             * @en
             * The distance from the origin to the plane.
             * @zh
             * ԭ㵽ƽľ롣
             */
            d: number;
            /**
             * @en
             * Gets the type of the Plane, its value is `enums.SHAPE_PLANE`.
             * @zh
             * ȡ״ֵͣΪ `enums.SHAPE_PLANE`
             */
            get type(): number;
            set x(val: number);
            get x(): number;
            set y(val: number);
            get y(): number;
            set z(val: number);
            get z(): number;
            set w(val: number);
            get w(): number;
            protected readonly _type: number;
            /**
             * @en
             * Constructs a plane.
             * @zh
             * һƽ档
             * @param nx @en The x component of normal vector. @zh  x ֡
             * @param ny @en The y component of normal vector. @zh  y ֡
             * @param nz @en The z component of normal vector. @zh  z ֡
             * @param d @en The distance between normal vector and the origin. @zh ԭľ롣
             */
            constructor(nx?: number, ny?: number, nz?: number, d?: number);
            /**
             * @en
             * Transforms this plane by a 4x4 matrix.
             * @zh
             * ʹһ 4x4 任ƽ档
             * @param mat @en The 4x4 matrix for transformation @zh ڱ任 4x4 
             */
            transform(mat: math.Mat4): void;
        }
        /**
         * @en
         * Basic Geometry: Ray.
         * @zh
         * Σߡ
         */
        export class Ray {
            /**
             * @en
             * Creates a new ray.
             * @zh
             * һߡ
             * @param {number} ox @en The x component of start point. @zh  x ֡
             * @param {number} oy @en The y component of start point. @zh  y ֡
             * @param {number} oz @en The z component of start point. @zh  z ֡
             * @param {number} dx @en The x component of direction point. @zh  x ֡
             * @param {number} dy @en The y component of direction point. @zh  y ֡
             * @param {number} dz @en The z component of direction point. @zh  z ֡
             * @returns {Ray} @en The created ray object. @zh ´ߡ
             */
            static create(ox?: number, oy?: number, oz?: number, dx?: number, dy?: number, dz?: number): Ray;
            /**
             * @en
             * Creates a new ray initialized with the values from an existing ray.
             * @zh
             * һ߿¡һµߡ
             * @param a @en The Ray object to be cloned from. @zh ¡Ŀꡣ
             * @returns @en The cloned Ray object. @zh ¡¶
             */
            static clone(a: Ray): Ray;
            /**
             * @en
             * Copies the values from one ray to another.
             * @zh
             * һ Ray ֵһ Ray С
             * @param out @en The Ray object to copy to. @zh ܲߡ
             * @param a @en The Ray object to copy from. @zh Ƶߡ
             * @returns @en The Ray object to copy to, same as the `out` parameter. @zh ܲߣ `out` ͬ
             */
            static copy(out: Ray, a: Ray): Ray;
            /**
             * @en
             * Creates a ray from two points.
             * @zh
             * 㴴һߡ
             * @param out @en The Ray object. @zh ܲߡ
             * @param origin @en The start point of the ray. @zh ߵ㡣
             * @param target @en The target point on the ray. @zh ϵһ㡣
             * @returns @en The Ray object, same as the `out` parameter. @zh ܲߣ `out` ͬ
             */
            static fromPoints(out: Ray, origin: math.Vec3, target: math.Vec3): Ray;
            /**
             * @en
             * Sets the components of a ray to the given values.
             * @zh
             * ߵΪֵ
             * @param out @en The Ray object to be modified @zh ܲߡ
             * @param ox @en The x component of start point. @zh  x ֡
             * @param oy @en The y component of start point. @zh  y ֡
             * @param oz @en The z component of start point. @zh  z ֡
             * @param dx @en The x component of direction point. @zh  x ֡
             * @param dy @en The y component of direction point. @zh  y ֡
             * @param dz @en The z component of direction point. @zh  z ֡
             * @returns @en The Ray object, same as the `out` parameter. @zh ܲߣ `out` ͬ
             */
            static set(out: Ray, ox: number, oy: number, oz: number, dx: number, dy: number, dz: number): Ray;
            /**
             * @en
             * The origin of the ray.
             * @zh
             * 㡣
             */
            o: math.Vec3;
            /**
             * @en
             * The direction of the ray.
             * @zh
             * 
             */
            d: math.Vec3;
            /**
             * @en
             * Gets the type of the ray, its value is `enums.SHAPE_RAY`.
             * @zh
             * ȡ״ֵͣΪ`enums.SHAPE_RAY`
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @en
             * Constructs a ray.
             * @zh
             * һߡ
             * @param ox @en The x component of start point. @zh  x ֡
             * @param oy @en The y component of start point. @zh  y ֡
             * @param oz @en The z component of start point. @zh  z ֡
             * @param dx @en The x component of direction point. @zh  x ֡
             * @param dy @en The y component of direction point. @zh  y ֡
             * @param dz @en The z component of direction point. @zh  z ֡
             */
            constructor(ox?: number, oy?: number, oz?: number, dx?: number, dy?: number, dz?: number);
            /**
             * @en
             * Calculates a point on the ray with the specific distance from the origin point.
             * @zh
             * ݸľϵһ㡣
             * @param out @en Another point on the ray. @zh ϵһ㡣
             * @param distance @en The given distance. @zh ľ롣
             */
            computeHit(out: math.IVec3Like, distance: number): void;
        }
        /**
         * @en
         * Basic Geometry: Triangle.
         * @zh
         * ΣΡ
         */
        export class Triangle {
            /**
             * @en
             * Creates a new triangle instance.
             * @zh
             * һµΡ
             * @param {number} ax @en The x component of point a @zh a  x ֡
             * @param {number} ay @en The y component of point a @zh a  y ֡
             * @param {number} az @en The z component of point a @zh a  z ֡
             * @param {number} bx @en The x component of point b @zh b  x ֡
             * @param {number} by @en The y component of point b @zh b  y ֡
             * @param {number} bz @en The z component of point b @zh b  z ֡
             * @param {number} cx @en The x component of point c @zh c  x ֡
             * @param {number} cy @en The y component of point c @zh c  y ֡
             * @param {number} cz @en The z component of point c @zh c  z ֡
             * @returns {Triangle} @en The created Triangle instance. @zh ʵ
             */
            static create(ax?: number, ay?: number, az?: number, bx?: number, by?: number, bz?: number, cx?: number, cy?: number, cz?: number): Triangle;
            /**
             * @en
             * Clones a triangle instance.
             * @zh
             * ¡һµΡ
             * @param t @en The Triangle object to be cloned from. @zh ¡Ŀꡣ
             * @returns @en The cloned triangle instance. @zh ¡¶
             */
            static clone(t: Triangle): Triangle;
            /**
             * @en
             * Copies the values from one triangle to another.
             * @zh
             * һεֵһС
             * @param out @en The target Triangle object to be copied to. @zh ܲΡ
             * @param t @en A Triangle object to be copied from. @zh ƵΡ
             * @returns @en The target Triangle object to be copied to, same as the `out` parameter. @zh ܲΣ `out` ͬ
             */
            static copy(out: Triangle, t: Triangle): Triangle;
            /**
             * @en
             * Creates a triangle instance from three points.
             * @zh
             * 㴴һΡ
             * @param out @en The Triangle object to be modified. @zh ܲΡ
             * @param a @en The point value to set out.a. @zh a 㡣
             * @param b @en The point value to set out.b. @zh b 㡣
             * @param c @en The point value to set out.c. @zh c 㡣
             * @returns @en The Triangle object to be modified same as the `out` parameter. @zh ܲΣ `out` ͬ
             */
            static fromPoints(out: Triangle, a: math.Vec3, b: math.Vec3, c: math.Vec3): Triangle;
            /**
             * @en
             * Sets the components of a triangle to the given values.
             * @zh
             * εΪֵ
             * @param out @en The Triangle object to be set. @zh ܲΡ
             * @param ax @en The value to set out.a.x. @zh a  x ֡
             * @param ay @en The value to set out.a.y. @zh a  y ֡
             * @param az @en The value to set out.a.z. @zh a  z ֡
             * @param bx @en The value to set out.b.x. @zh b  x ֡
             * @param by @en The value to set out.b.y. @zh b  y ֡
             * @param bz @en The value to set out.b.z. @zh b  z ֡
             * @param cx @en The value to set out.c.x. @zh c  x ֡
             * @param cy @en The value to set out.c.y. @zh c  y ֡
             * @param cz @en The value to set out.c.z. @zh c  z ֡
             * @returns @en The Triangle object to be set, same as the `out` parameter. @zh ܲΣ `out` ͬ
             */
            static set(out: Triangle, ax: number, ay: number, az: number, bx: number, by: number, bz: number, cx: number, cy: number, cz: number): Triangle;
            /**
             * @en
             * Point a.
             * @zh
             *  a
             */
            a: math.Vec3;
            /**
             * @en
             * Point b.
             * @zh
             *  b
             */
            b: math.Vec3;
            /**
             * @en
             * Point c.
             * @zh
             *  c
             */
            c: math.Vec3;
            /**
             * @en
             * Gets the type of the triangle, always returns `enums.SHAPE_TRIANGLE`.
             * @zh
             * ȡε̶ͣ `enums.SHAPE_TRIANGLE`
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @en
             * Constructs a triangle.
             * @zh
             * һΡ
             * @param {number} ax @en x component of point a. @zh a  x ֡
             * @param {number} ay @en y component of point a. @zh a  y ֡
             * @param {number} az @en z component of point a. @zh a  z ֡
             * @param {number} bx @en x component of point b. @zh b  x ֡
             * @param {number} by @en y component of point b. @zh b  y ֡
             * @param {number} bz @en z component of point b. @zh b  z ֡
             * @param {number} cx @en x component of point c. @zh c  x ֡
             * @param {number} cy @en y component of point c. @zh c  y ֡
             * @param {number} cz @en z component of point c. @zh c  z ֡
             */
            constructor(ax?: number, ay?: number, az?: number, bx?: number, by?: number, bz?: number, cx?: number, cy?: number, cz?: number);
        }
        /**
         * @en
         * Basic Geometry: Sphere.
         * @zh
         * Σ
         */
        export class Sphere {
            /**
             * @en
             * Creates a new sphere instance.
             * @zh
             * һµʵ
             * @param cx @en The X-Coordinate of the center point relative to the origin.  @zh ԭĵ X ꡣ
             * @param cy @en The Y-Coordinate of the center point relative to the origin.  @zh ԭĵ Y ꡣ
             * @param cz @en The Z-Coordinate of the center point relative to the origin.  @zh ԭĵ Z ꡣ
             * @param r @en The radius of the sphere. @zh İ뾶
             * @returns @en A new sphere instance. @zh һµʵ
             */
            static create(cx: number, cy: number, cz: number, r: number): Sphere;
            /**
             * @en
             * Clones a sphere instance.
             * @zh
             * ¡һµʵ
             * @param p @en The sphere object to clone from. @zh ¡Ŀꡣ
             * @returns @en The sphere object to clone to. @zh ¡ʵ
             */
            static clone(p: Sphere): Sphere;
            /**
             * @en
             * Copies the values from one sphere to another.
             * @zh
             * һֵһС
             * @param out @en The sphere object to copy to. @zh ܲʵ
             * @param a @en The sphere object to copy from. @zh Ƶʵ
             * @returns @en The sphere object to copy to. @zh ܲʵ
             */
            static copy(out: Sphere, p: Sphere): Sphere;
            /**
             * @en
             * Creates a new sphere instance from two points.
             * @zh
             * 㴴һµʵ
             * @param out - @en The sphere created from the two points. @zh ܲʵ
             * @param minPos - @en The lower point of the sphere. @zh ĽС㡣
             * @param maxPos - @en The upper point of the sphere. @zh Ľϴ㡣
             * @returns @en The created sphere, same as the `out` parameter. @zh ܲʵ `out` ͬ
             */
            static fromPoints(out: Sphere, minPos: math.Vec3, maxPos: math.Vec3): Sphere;
            /**
             * @en
             * Sets the components of a sphere to the given values
             * @zh
             * Ϊֵ
             * @param out @en The sphere to set values to. @zh ܲʵ
             * @param cx @en The X-Coordinate of the center point which relative to the origin.  @zh ԭĵ X ꡣ
             * @param cy @en The Y-Coordinate of the center point which relative to the origin.  @zh ԭĵ Y ꡣ
             * @param cz @en The Z-Coordinate of the center point which relative to the origin.  @zh ԭĵ Z ꡣ
             * @param r @en The radius of the sphere. @zh Ҫõİ뾶
             * @returns @en The sphere to set values to, same as the `out` parameter. @zh ܲʵ `out` ͬ
             * @function
             */
            static set(out: Sphere, cx: number, cy: number, cz: number, r: number): Sphere;
            /**
             * @en
             * The center of this sphere.
             * @zh
             * ǰڱеĵ㡣
             */
            protected _center: math.Vec3;
            get center(): math.Vec3;
            set center(val: math.Vec3);
            /**
             * @en
             * The radius of this sphere.
             * @zh
             * ǰİ뾶
             */
            get radius(): number;
            set radius(val: number);
            /**
             * @en
             * Gets the type of the shape, always returns `enums.SHAPE_SPHERE`.
             * @zh
             * ȡ̶ͣ `enums.SHAPE_SPHERE`
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @en
             * Constructs a sphere instance.
             * @zh
             * һ
             * @param cx @en The X-Coordinate of the sphere. @zh  X ꡣ
             * @param cy @en The Y-Coordinate of the sphere. @zh  Y ꡣ
             * @param cz @en The Z-Coordinate of the sphere. @zh  Z ꡣ
             * @param r @en The radius of the sphere. @zh İ뾶
             */
            constructor(cx?: number, cy?: number, cz?: number, r?: number);
            destroy(): void;
            /**
             * @en
             * Clones a sphere instance.
             * @zh
             * ¡һʵ
             * @returns @en The cloned sphere instance. @zh ¡ʵ
             */
            clone(): Sphere;
            /**
             * @en
             * Copies the values from a sphere to the current sphere.
             * @zh
             * һֵǰʵС
             * @param a @en The sphere to copy from. @zh Ŀꡣ
             */
            copy(a: Sphere): Sphere;
            /**
             * @en
             * Gets the bounding points of this sphere.
             * @zh
             * ȡı߽㡣
             * @param minPos @en The point with maximum coordinates of the sphere. @zh ǰʵС㡣
             * @param maxPos @en The point with minimum coordinates of the sphere. @zh ǰʵ㡣
             */
            getBoundary(minPos: math.Vec3, maxPos: math.Vec3): void;
            /**
             * @en
             * Transforms this sphere by a 4x4 matrix and RTS and stores to the `out` parameter.
             * @zh
             * һ 4x4 һ RTS 任壬洢 `out` С
             * @param m @en The 4x4 transform matrix. @zh 4x4 任
             * @param pos @en The position part of the transform. @zh 任λò֡
             * @param rot @en The rotation part of the transform. @zh 任ת֡
             * @param scale @en The scale part of the transform. @zh 任Ų֡
             * @param out @en The sphere which the transform will be applied to. @zh 任Ŀꡣ
             */
            transform(m: math.Mat4, pos: math.Vec3, rot: math.Quat, scale: math.Vec3, out: Sphere): void;
            /**
             * @en
             * Transforms this sphere by a 4x4 matrix and a quaternion, stores the result to the `out` parameter.
             * @zh
             * ʹһ 4x4 һԪ任壬洢 `out` С
             * @param m @en The 4x4 transform matrix. @zh 4x4 任
             * @param rot @en The rotation part of the transform. @zh 任ת֡
             * @param out @en The sphere which the transform will be applied to. @zh 任Ŀꡣ
             */
            translateAndRotate(m: math.Mat4, rot: math.Quat, out: Sphere): void;
            /**
             * @en
             * Scales this sphere and stores the result to the `out` parameter.
             * @zh
             * ԵǰʵŴ洢 `out` С
             * @param scale @en The scale value. @zh ֵ
             * @param out @en The sphere which the scale will be applied to. @zh ŵĿꡣ
             */
            setScale(scale: math.Vec3, out: Sphere): void;
            /**
             * @en Merges a point to this sphere.
             * @zh ϲһ㵽ǰʵС
             * @param point @en The point to be merged to this sphere. @zh Ҫϲǰʵĵ㡣
             */
            mergePoint(point: math.Vec3): void;
            /**
             * @en Merges some points to this sphere.
             * @zh ϲһЩ㵽ǰʵС
             * @param points @en The points to be merged to this sphere. @zh Ҫϲǰʵĵб
             */
            mergePoints(points: math.Vec3[]): void;
            /**
             * @en Merges a AABB to this sphere.
             * @zh ϲһ AABB ǰʵС
             * @param a @en The AABB instance to be merged to this sphere. @zh Ҫϲǰʵ AABB ʵ
             */
            mergeAABB(a: AABB): void;
        }
        /**
         * @en
         * Basic Geometry: Axis-aligned bounding box, using center and half extents structure.
         * It's a fairly computationally and memory efficient way of checking whether two 3D objects might be touching.
         * @zh
         * ΣΧУʹĵͰ볤ߵĽṹ
         * Ǽ 3D ǷཻһڼڴЧʶ൱ߵķ
         */
        export class AABB {
            /**
             * @en
             * Creates a new AABB instance.
             * @zh
             * һµ AABB ʵ
             * @param px @zh AABB ԭ X ꡣ @en The x coordinate of the origin of the AABB.
             * @param py @zh AABB ԭ Y ꡣ @en The y coordinate of the origin of the AABB.
             * @param pz @zh AABB ԭ Z ꡣ @en The z coordinate of the origin of the AABB.
             * @param hw @zh AABB ȵһ롣 @en Half the width of the AABB.
             * @param hh @zh AABB ߶ȵһ롣 @en Half the height of the AABB.
             * @param hl @zh AABB ȵһ롣 @en Half the length of the AABB.
             * @returns @zh ´ AABB ʵ @en A new instance of AABB.
             */
            static create(px?: number, py?: number, pz?: number, hw?: number, hh?: number, hl?: number): AABB;
            /**
             * @en
             * Clones an AABB, which will create a new AABB instance with the same value as the input parameter `a`. Note that each time `clone` is invoked, a new AABB object will be created, so use `copy` method whenever it could to reduce GC pressure.
             * @zh
             * ¡һ AABBᴴһֵ`a`һ AABB ʵע⣬ÿε `clone` ᴴʵʹ `copy` ԼС GC ѹ
             * @param a @zh ¡Ŀꡣ @en The target object to be cloned.
             * @returns @zh ¡ AABB ʵ@en The cloned AABB instance.
             */
            static clone(a: AABB | Readonly<AABB>): AABB;
            /**
             * @en
             * Copies the values from one AABB to another, the process will not generate temporary objects.
             * @zh
             * һ AABB ֵƵһ AABB У˹̽ʱ
             * @param out @zh ܲ AABB @en The output AABB which is the copy destination.
             * @param a @zh Ƶ AABBΪֻ @en The source object of the copy operation, it's readonly.
             * @returns @zh ܲ AABB `out` á @en The reference to the first parameter `out`.
             */
            static copy(out: AABB, a: AABB | Readonly<AABB>): AABB;
            /**
             * @en
             * Constructs a new AABB from two corner points.
             * @zh
             * 㴴һµ AABB
             * @param out @zh ܲ AABB @en The output AABB.
             * @param minPos @zh AABB С㡣 @en Minimum point of the AABB.
             * @param maxPos @zh AABB 㡣 @en Maximum point of the AABB.
             * @returns @zh ܲ AABB `out` á @en The reference to the first parameter `out`.
             */
            static fromPoints(out: AABB, minPos: math.IVec3, maxPos: math.IVec3): AABB;
            /**
             * @en
             * Sets the components of a AABB to the given values.
             * @zh
             *  AABB Ϊֵ
             * @param @zh out ܲ AABB @en The output AABB to set.
             * @param px @zh - AABB ԭ X ꡣ @en The x coordinate of the origin of the AABB.
             * @param py @zh - AABB ԭ Y ꡣ @en The y coordinate of the origin of the AABB.
             * @param pz @zh - AABB ԭ Z ꡣ @en The z coordinate of the origin of the AABB.
             * @param hw @zh - AABB ȵһ롣 @en Half the width of the AABB.
             * @param hh @zh - AABB ߶ȵһ롣 @en Half the height of the AABB.
             * @param hl @zh - AABB ȵһ롣 @en Half the length of the AABB.
             * @returns @zh ܲ AABB `out` á @en The reference fo the first parameter `out`.
             */
            static set(out: AABB, px: number, py: number, pz: number, hw: number, hh: number, hl: number): AABB;
            /**
             * @en
             * Merges two AABB instances into one.
             * @zh
             * ϲ AABB һĿ AABB С
             * @param out @zh ܲĿ AABB @en The output AABB to storge the merge result.
             * @param a @zh һ AABB out ͬʱ򣬴˺ڲ޸ֵ @en The first AABB to be merged, its value will not be modified if `a` is not equal to the `out` paramater.
             * @param b @zh ڶ AABB out ͬʱ򣬴˺ڲ޸ֵ @en The second AABB to be merged, its value will not be modified if `b` is not equal to the `out` paramater.
             * @returns @zh ܲ AABB `out` á @en The reference to the first parameter `out`.
             */
            static merge(out: AABB, a: AABB | Readonly<AABB>, b: AABB | Readonly<AABB>): AABB;
            /**
             * @en
             * Converts an AABB to a bounding sphere.
             * @zh
             * ΧתΧ
             * @param out @zh ܲİΧ @en The output bounding sphere.
             * @param a @zh  AABBֻ @en The input AABBit's readonly.
             * @returns @zh ܲİΧ `out` . @en The reference to the first parameter `out`.
             */
            static toBoundingSphere(out: Sphere, a: AABB | Readonly<AABB>): Sphere;
            /**
             * @en
             * Transforms an AABB by a 4x4 matrix and stores the result to the `out` parameter.
             * @zh
             * ʹһ 4  4 任һ AABB 洢 out С
             * @param out @zh ܲ AABB @en The output AABB to store the result.
             * @param a @zh Դ AABB out ͬһô a ᱻ˺޸ġ @en The input AABB, if it's different with the `out` parameter, then `a` will not be changed by this function.
             * @param matrix @zh  @en The transformation matrix.
             * @returns @zh ܲ AABB `out` á @en The reference of the first parameter `out`.
             */
            static transform(out: AABB, a: AABB | Readonly<AABB>, matrix: math.Mat4 | Readonly<math.Mat4>): AABB;
            /**
             * @en
             * The center point of this AABB.
             * @zh
             * ĵ㡣
             */
            center: math.Vec3;
            /**
             * @en
             * Half the size of this AABB.
             * @zh
             * ߵһ롣
             */
            halfExtents: math.Vec3;
            /**
             * @en
             * Gets the type of this shape.
             * @zh
             * ȡ״͡
             */
            get type(): number;
            protected readonly _type: number;
            constructor(px?: number, py?: number, pz?: number, hw?: number, hh?: number, hl?: number);
            /**
             * @en
             * Gets the bounding points of this AABB.
             * @zh
             * ȡ AABB С㡣
             * @param minPos @zh Ŵ AABB С @en The minimum position of the AABB to be stored to.
             * @param maxPos @zh Ŵ AABB  @en The maximum position of the AABB to be stored to.
             */
            getBoundary(minPos: math.IVec3Like, maxPos: math.IVec3Like): void;
            /**
             * @en
             * Transforms this AABB by a 4x4 matrix and stores the result to `out` parameter
             * @zh
             * ʹ 4  4 任 AABB 洢 `out` С
             * @param m @zh 任ľ @en The transform matrix.
             * @param pos @zh 任λò֡ @en 3d-vector translation.
             * @param rot @zh 任ת֡ @en Quaternion rotation.
             * @param scale @zh 任Ų֡ @en 3d-vector scale.
             * @param out @zh 洢 AABB @en The output AABB.
             */
            transform(m: math.Mat4, pos: math.Vec3 | null, rot: math.Quat | null, scale: math.Vec3 | null, out: AABB): void;
            /**
             * @en
             * Clones this AABB, which will create a new AABB instance with the same value as this AABB. Note that each time `clone` is invoked, a new AABB object will be created, so use `copy` method whenever it could to reduce GC pressure.
             * @zh
             * ¡һ AABBᴴһֵǰ AABB һʵע⣬ÿε `clone` ᴴʵʹ `copy` ԼС GC ѹ
             * @returns @zh ¡ AABB ʵ @en The cloned AABB instance.
             */
            clone(): AABB;
            /**
             * @en
             * Copies the values from one AABB to this AABB, the process will not generate temporary objects.
             * @zh
             * һ AABB ֵƵǰ AABB У˹̽ʱ
             * @param a @zh Ƶ AABBΪֻ @en The source object of the copy operation, it's readonly.
             * @returns @zh ǰ AABB á @en The reference of this AABB.
             */
            copy(a: AABB | Readonly<AABB>): AABB;
            /**
             * @en Merges a point to this AABB.
             * @zh ϲһ㵽ǰ AABB С
             * @param point @zh 3D ĳһλõĶ㡣 @en A point in 3D space.
             */
            mergePoint(point: math.IVec3): void;
            /**
             * @en Merges some points to this AABB.
             * @zh ϲһϵж㵽ǰ AABB С
             * @param points @zh 3D еĶб @en A list of points in 3D space.
             */
            mergePoints(points: math.IVec3[]): void;
            /**
             * @en Merges all points in a frustum to this AABB.
             * @zh ϲһͷ׶ж㵽 AABB С
             * @param frustum @zh Ľͷ׶ @en The frustum object.
             */
            mergeFrustum(frustum: Frustum | Readonly<Frustum>): void;
        }
        /**
         * @en
         * Basic Geometry: Oriented bounding box.
         * @zh
         * ΣΧС
         */
        export class OBB {
            /**
             * @en
             * Creates a new OBB instance
             * @zh
             * һµ OBB ʵ
             * @param cx @zh ״ԭ X ꡣ @en The x coordinate of origin.
             * @param cy @zh ״ԭ Y ꡣ @en The y coordinate of origin.
             * @param cz @zh ״ԭ Z ꡣ @en The z coordinate of origin.
             * @param hw @zh - OBB ȵһ롣 @en Half the width of the OBB.
             * @param hh @zh - OBB ߶ȵһ롣 @en Half the height of the OBB.
             * @param hl @zh - OBB ȵһ롣 @en Half the length of the OBB.
             * @param ox_1 @zh  1  x  @en The x component of the first axis of the OBB.
             * @param ox_2 @zh  2  x  @en The x component of the second axis of the OBB.
             * @param ox_3 @zh  3  x  @en The x component of the third axis of the OBB.
             * @param oy_1 @zh  1  y  @en The y component of the first axis of the OBB.
             * @param oy_2 @zh  2  y  @en The y component of the second axis of the OBB.
             * @param oy_3 @zh  3  y  @en The y component of the third axis of the OBB.
             * @param oz_1 @zh  1  z  @en The z component of the first axis of the OBB.
             * @param oz_2 @zh  2  z  @en The z component of the second axis of the OBB.
             * @param oz_3 @zh  3  z  @en The z component of the third axis of the OBB.
             * @returns @zh ´ OBB ʵ @en A new OBB instance.
             */
            static create(cx: number, cy: number, cz: number, hw: number, hh: number, hl: number, ox_1: number, ox_2: number, ox_3: number, oy_1: number, oy_2: number, oy_3: number, oz_1: number, oz_2: number, oz_3: number): OBB;
            /**
             * @en
             * Clones a new OBB instance.
             * @zh
             * ¡һ OBB ʵ
             * @param a @zh ¡Ŀꡣ @en The input OBB.
             * @returns @zh The cloned OBB instance.  @en ¡¶
             */
            static clone(a: OBB): OBB;
            /**
             * @en
             * Copies the values from one OBB to another.
             * @zh
             * һ OBB ֵһ OBB С
             * @param  out @zh ܲ OBB @en The output OBB.
             * @param  a @zh Ƶ OBB @en The input OBB.
             * @returns  @zh ܲ OBB `out` ͬ @en The output OBB, same as the `out` parameter.
             */
            static copy(out: OBB, a: OBB): OBB;
            /**
             * @en
             * Creates a new OBB from two corner points.
             * @zh
             * 㴴һµ OBB
             * @param out @zh - ܲ OBB @en The output OBB.
             * @param minPos @zh - OBB С㡣 @en The minimum position of the AABB.
             * @param maxPos @zh - OBB 㡣 @en The maximum position of the AABB.
             * @returns  @zh ܲ OBB `out` ͬ @en The output OBB, same as the `out` parameter.
             */
            static fromPoints(out: OBB, minPos: math.Vec3, maxPos: math.Vec3): OBB;
            /**
             * @en
             * Sets the components of an OBB to the given values.
             * @zh
             *  OBB Ϊֵ
             * @param out @zh Ŀ OBB @en The output OBB instance.
             * @param cx @zh ״ԭ X ꡣ @en The x coordinate of origin.
             * @param cy @zh ״ԭ Y ꡣ @en The y coordinate of origin.
             * @param cz @zh ״ԭ Z ꡣ @en The z coordinate of origin.
             * @param hw @zh - obb ȵһ롣 @en Half the width of the OBB.
             * @param hh @zh - obb ߶ȵһ롣 @en Half the height of the OBB.
             * @param hl @zh - obb ȵһ롣 @en Half the length of the OBB.
             * @param ox_1 @zh  1  x  @en The x component of the first axis of the OBB.
             * @param ox_2 @zh  2  x  @en The x component of the second axis of the OBB.
             * @param ox_3 @zh  3  x  @en The x component of the third axis of the OBB.
             * @param oy_1 @zh  1  y  @en The y component of the first axis of the OBB.
             * @param oy_2 @zh  2  y  @en The y component of the second axis of the OBB.
             * @param oy_3 @zh  3  y  @en The y component of the third axis of the OBB.
             * @param oz_1 @zh  1  z  @en The z component of the first axis of the OBB.
             * @param oz_2 @zh  2  z  @en The z component of the second axis of the OBB.
             * @param oz_3 @zh  3  z  @en The z component of the third axis of the OBB.
             * @returns  @zh ܲ OBB `out` ͬ @en The output OBB, same as the `out` parameter.
             */
            static set(out: OBB, cx: number, cy: number, cz: number, hw: number, hh: number, hl: number, ox_1: number, ox_2: number, ox_3: number, oy_1: number, oy_2: number, oy_3: number, oz_1: number, oz_2: number, oz_3: number): OBB;
            /**
             * @en
             * The center point of an OBB in local coordinate.
             * @zh
             * ĵ㡣
             */
            center: math.Vec3;
            /**
             * @en
             * Half the distance across the OBB in each local axis.
             * @zh
             * ߵһ롣
             */
            halfExtents: math.Vec3;
            /**
             * @en
             * Orientation matrix.
             * @zh
             * 
             */
            orientation: math.Mat3;
            /**
             * @en
             * Gets the type of the OBB. Always returns `enums.SHAPE_OBB`.
             * @zh
             * ȡ״̶ͣ `enums.SHAPE_OBB`
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @param cx @zh ״ԭ X ꡣ @en The x coordinate of origin.
             * @param cy @zh ״ԭ Y ꡣ @en The y coordinate of origin.
             * @param cz @zh ״ԭ Z ꡣ @en The z coordinate of origin.
             * @param hw @zh - OBB ȵһ롣 @en Half the width of the OBB.
             * @param hh @zh - OBB ߶ȵһ롣 @en Half the height of the OBB.
             * @param hl @zh - OBB ȵһ롣 @en Half the length of the OBB.
             * @param ox_1 @zh  1  x  @en The x component of the first axis of the OBB.
             * @param ox_2 @zh  2  x  @en The x component of the second axis of the OBB.
             * @param ox_3 @zh  3  x  @en The x component of the third axis of the OBB.
             * @param oy_1 @zh  1  y  @en The y component of the first axis of the OBB.
             * @param oy_2 @zh  2  y  @en The y component of the second axis of the OBB.
             * @param oy_3 @zh  3  y  @en The y component of the third axis of the OBB.
             * @param oz_1 @zh  1  z  @en The z component of the first axis of the OBB.
             * @param oz_2 @zh  2  z  @en The z component of the second axis of the OBB.
             * @param oz_3 @zh  3  z  @en The z component of the third axis of the OBB.
             */
            constructor(cx?: number, cy?: number, cz?: number, hw?: number, hh?: number, hl?: number, ox_1?: number, ox_2?: number, ox_3?: number, oy_1?: number, oy_2?: number, oy_3?: number, oz_1?: number, oz_2?: number, oz_3?: number);
            /**
             * @en
             * Gets the bounding points of this OBB instance.
             * @zh
             * ȡ OBB С㡣
             * @param minPos @zh  OBB С㡣 @en The out minimum position of the OBB.
             * @param maxPos @zh  OBB 㡣 @en The out maximum position of the OBB.
             */
            getBoundary(minPos: math.Vec3, maxPos: math.Vec3): void;
            /**
             * @en
             * Transforms this OBB and store the result to the `out` parameter.
             * @zh
             * Եǰ OBB ݽб任洢 `out` С
             * @param m @zh 任ľ @en The transform matrix
             * @param pos @zh 任λò֡ @en 3d-vector translation.
             * @param rot @zh 任ת֡ @en Quaternion rotation.
             * @param scale @zh 任Ų֡ @en 3d-vector scale.
             * @param out @zh 任Ŀ OBB @en The output OBB.
             * @note @zh ˷޸ĵǰ OBB ݡ @en This method will not modify the data of current OBB.
             */
            transform(m: math.Mat4, pos: math.Vec3, rot: math.Quat, scale: math.Vec3, out: OBB): void;
            /**
             * @en
             * Transforms this OBB by a 4x4 matrix and a quaternion.
             * @zh
             * һ 4x4 һԪ任 OBB
             * @param m @zh 任ľ @en The transform matrix.
             * @param rot @zh 任ת֡ @en The quaternion for rotation.
             * @param out @zh 任Ŀꡣ @en The output OBB.
             * @note @zh ˷޸ĵǰ OBB ݡ @en This method will not modify the data of current OBB.
             */
            translateAndRotate(m: math.Mat4, rot: math.Quat, out: OBB): void;
            /**
             * @en
             * Scales this OBB by a 3d-vector and store the result to the `out` parameter.
             * @zh
             *  3D Դ OBB ݽŲ洢 out С
             * @param scale @zh ֵ @en 3d-vector scale.
             * @param out @zh ŵĿꡣ @en The output OBB.
             * @note @zh ˷޸ĵǰ OBB ݡ @en This method will not modify the data of current OBB.
             */
            setScale(scale: math.Vec3, out: OBB): void;
        }
        /**
         * @en
         * Basic Geometry: capsule.
         * @zh
         * Σ塣
         */
        export class Capsule {
            /**
             * @en
             * Gets the type of this Capsule, always returns `enums.SHAPE_CAPSULE`.
             * @zh
             * ȡ״̶ֵͣΪ `enums.SHAPE_CAPSULE`
             */
            get type(): number;
            protected readonly _type: number;
            /**
             * @en
             * The radius of the sphere in this capsule.
             * @zh
             * 򲿵İ뾶
             */
            radius: number;
            /**
             * @en
             * The distance between the center point of the capsule and the center of the sphere.
             * @zh
             * ĵԲĵľ롣
             */
            halfHeight: number;
            /**
             * @en
             * The local orientation of this capsule [0,1,2] => [x,y,z].
             * @zh
             * ıسӳϵ [0,1,2] => [x,y,z]
             */
            axis: number;
            /**
             * @en
             * The origin of the capsule.
             * @zh
             * ԭ㡣
             */
            readonly center: math.Vec3;
            /**
             * @en
             * The rotation of the capsule.
             * @zh
             * ת
             */
            readonly rotation: math.Quat;
            /**
             * @internal
             * cache, local center of ellipse
             **/
            readonly ellipseCenter0: math.Vec3;
            /**
             * @internal
             */
            readonly ellipseCenter1: math.Vec3;
            /**
             * @en
             * Constructs a Capsule instance.
             * @zh
             * һʵ
             * @param radius @en The radius of the sphere in this capsule. @zh 򲿵İ뾶
             * @param halfHeight @en The distance between the center point of the capsule and the center of the sphere. @zh ĵԲĵľ롣
             * @param axis @en The local orientation of this capsule [0,1,2] => [x,y,z]. @zh ıسӳϵ [0,1,2] => [x,y,z]
             */
            constructor(radius?: number, halfHeight?: number, axis?: number);
            /**
             * @en
             * Transforms this capsule by a 4x4 matrix and RTS.
             * @zh
             * ʹ 4x4  RTS 任˽塣
             */
            transform(m: math.Mat4, pos: math.IVec3Like, rot: math.IQuatLike, scale: math.IVec3Like, out: Capsule): void;
            /**
             * @en
             * Updates the cache.
             * @zh
             * »档
             */
            updateCache(): void;
            /**
             * @en
             * Updates the center points.
             * @zh
             * ĵϢ
             */
            updateLocalCenter(): void;
        }
        /**
         * @en
         * Basic Geometry: frustum.
         * @zh
         * Σ׶塣
         */
        export class Frustum {
            /**
             * @en Creates an orthographic frustum.
             * @zh һ׶塣
             * @param out @en The result orthographic frustum. @zh ׶塣
             * @param width @en The width of the frustum. @zh ׶Ŀȡ
             * @param height @en The height of the frustum. @zh ׶ĸ߶ȡ
             * @param near @en The near plane of the frustum. @zh ׶Ľƽֵ
             * @param far @en The far plane of the frustum. @zh ׶Զƽֵ
             * @param transform @en The transform matrix of the frustum. @zh ׶ı任
             * @returns @en The result frustum, same as the `out` parameter. @zh 洢׶壬 `out` Ϊͬһ
             */
            static createOrthographic(out: Frustum, width: number, height: number, near: number, far: number, transform: math.Mat4): void;
            /**
             * @en Creates an orthographic frustum.
             * @zh һ׶塣
             * @param out @en The result orthographic frustum. @zh ׶塣
             * @param width @en The width of the frustum. @zh ׶Ŀȡ
             * @param height @en The height of the frustum. @zh ׶ĸ߶ȡ
             * @param near @en The near plane of the frustum. @zh ׶Ľƽֵ
             * @param far @en The far plane of the frustum. @zh ׶Զƽֵ
             * @param transform @en The transform matrix of the frustum. @zh ׶ı任
             * @returns @en The result frustum, same as the `out` parameter. @zh 洢׶壬 `out` Ϊͬһ
             *
             * @deprecated since v3.8.0, please use [[createOrthographic]] instead.
             */
            static createOrtho(out: Frustum, width: number, height: number, near: number, far: number, transform: math.Mat4): void;
            /**
             * @en Creates a perspective frustum.
             * @zh һ͸׶塣
             * @param aspect @en The aspect ratio of the camera. @zh ͼĳȡ
             * @param fov @en The field of view of the camera. @zh ӽǴС
             * @param near @en The near plane of the frustum. @zh ׶Ľƽֵ
             * @param far @en The far plane of the frustum. @zh ׶Զƽֵ
             * @param transform @en The transform matrix. @zh 任
             * @returns @en The result frustum, same as the `out` parameter. @zh 洢׶壬 `out` Ϊͬһ
             */
            static createPerspective(out: Frustum, aspect: number, fov: number, near: number, far: number, transform: math.Mat4): void;
            /**
             * @en Creates a frustum from an AABB instance.
             * @zh һ AABB ʵһ׶塣
             * @param out @en The result frustum. @zh ׶
             * @param aabb @en The AABB to create the result frustum. @zh ڴ׶ AABB
             * @returns @en The result frustum, same as the `out` parameter. @zh 洢׶壬 `out` Ϊͬһ
             *
             * @deprecated since v3.8.0, please use [[createOrthographic]] instead.
             */
            static createFromAABB(out: Frustum, aabb: AABB | Readonly<AABB>): Frustum;
            /**
             * @en Calculates a split frustum.
             * @zh һָ׶塣
             * @param start @en The split start position. @zh ָʼλá
             * @param end @en The split end position. @zh ָĩβλá
             * @param aspect @en The aspect ratio of the camera. @zh ͼĳȡ
             * @param fov @en The field of view of the camera. @zh ӽǴС
             * @param m @en The transform matrix. @zh 任
             *
             * @deprecated since v3.8.0, please use [[createPerspective]] instead.
             */
            split(start: number, end: number, aspect: number, fov: number, m: math.Mat4): void;
            /**
             * @en
             * Creates a new frustum.
             * @zh
             * һµ׵塣
             * @returns @en An empty frustum. @zh һ׵塣
             */
            static create(): Frustum;
            /**
             * @en
             * Clones a frustum.
             * @zh
             * ¡һ׵塣
             * @param f @en The frustum to clone from. @zh ڿ¡׵塣
             * @return @en The cloned frustum. @zh ¡׵塣
             */
            static clone(f: Frustum): Frustum;
            /**
             * @en
             * Copies the values from one frustum to another.
             * @zh
             * һ׶忽һ׶塣
             * @param out @en The result frustum @zh ڴ洢ݵĽ׶
             * @param f @en The frustum to copy from @zh ڿ¡Ľ׶
             * @returns @en The result frustum, same as the `out` parameter. @zh 洢׶壬 `out` Ϊͬһ
             */
            static copy(out: Frustum, f: Readonly<Frustum>): Frustum;
            /**
             * @en
             * Sets whether to use accurate intersection testing function on this frustum.
             * @zh
             * Ƿڴ˽׶ʹþȷཻԺ
             *
             * @deprecated since v3.8.0 no need to set accurate flag since it doesn't affect the calculation at all.
             */
            set accurate(b: boolean);
            /**
             * @en
             * Gets the type of the shape. The value may be `enums.SHAPE_FRUSTUM_ACCURATE` or `enums.SHAPE_FRUSTUM`.
             * @zh
             * ȡ״ֵ͡Ϊ `enums.SHAPE_FRUSTUM_ACCURATE`  `enums.SHAPE_FRUSTUM`
             * @readonly
             */
            get type(): number;
            /**
             * @en
             * The 6 planes of the frustum.
             * @zh
             * ׵ 6 档
             */
            planes: Plane[];
            /**
             * @en
             * The 8 vertices of the frustum.
             * @zh
             * ׵ 8 㡣
             */
            vertices: math.Vec3[];
            protected _type: number;
            constructor();
            /**
             * @en
             * Updates the frustum information according to the given transform matrix.
             * Note that the resulting planes are not normalized under normal mode.
             * @zh
             * ݸı任½׶Ϣעõƽ治ڱ׼ģʽ¹һġ
             * @param m @en The view-projection matrix. @zh ͼͶӰ
             * @param inv @en The inverse view-projection matrix. @zh ͼͶӰ
             */
            update(m: math.Mat4, inv: math.Mat4): void;
            /**
             * @en
             * Transforms this frustum.
             * @zh
             * 任׶塣
             * @param mat @en The transform matrix. @zh 任
             */
            transform(mat: math.Mat4): void;
            /**
             * @en Makes the frustum empty, all vertices will be zero values.
             * @zh ÿմ׶壬ж㽫ֵΪ 0
             */
            zero(): void;
            /**
             * @en Updates all six planes of the frustum.
             * @zh ׶ݡ
             */
            updatePlanes(): void;
        }
        /**
         * @en
         * A key frame in the curve.
         * @zh
         * еһؼ֡
         */
        export class Keyframe {
            /**
             * @en Current frame time.
             * @zh ǰ֡ʱ䡣
             */
            time: number;
            /**
             * @en Current frame value.
             * @zh ǰֵ֡
             */
            value: number;
            /**
             * @en In tangent value.
             * @zh ߡ
             */
            inTangent: number;
            /**
             * @en Out tangent value.
             * @zh ߡ
             */
            outTangent: number;
        }
        /**
         * @en
         * Describe a curve in which three times Hermite interpolation is used for each adjacent key frame.
         * @zh
         * һߣÿڹؼ֡hermiteֵ㡣
         */
        export class AnimationCurve {
            /**
             * For internal usage only.
             * @internal
             */
            get _internalCurve(): RealCurve;
            /**
             * @en
             * The key frame of the curve.
             * @zh
             * ߵĹؼ֡
             */
            get keyFrames(): Keyframe[];
            set keyFrames(value: Keyframe[]);
            /**
             * @en
             * Loop mode [[AnimationClip.WrapMode]] when the sampling time exceeds the left end.
             * @zh
             * ʱ䳬ʱõѭģʽ[[AnimationClip.WrapMode]]
             */
            get preWrapMode(): __private._cocos_core_geometry_curve__WrapModeMask;
            set preWrapMode(value: __private._cocos_core_geometry_curve__WrapModeMask);
            /**
             * @en
             * Cycle mode [[AnimationClip.WrapMode]] when the sampling time exceeds the right end.
             * @zh
             * ʱ䳬Ҷʱõѭģʽ[[AnimationClip.WrapMode]]
             */
            get postWrapMode(): __private._cocos_core_geometry_curve__WrapModeMask;
            set postWrapMode(value: __private._cocos_core_geometry_curve__WrapModeMask);
            /**
             * @en Construct a curve with key frames
             * @zh ͨؼ֡һߡ
             * @param keyFrames @zh ؼ֡ @en Key frames
             */
            constructor(keyFrames?: Keyframe[] | null | RealCurve);
            /**
             * @en
             * Add a keyframe.
             * @zh
             * һؼ֡
             * @param keyFrame @en A keyframe. @zh ؼ֡
             */
            addKey(keyFrame: Keyframe | null): void;
            /**
             * @ignore
             * @param time
             */
            evaluate_slow(time: number): number;
            /**
             * @en
             * Calculate the curve interpolation at a given point in time.
             * @zh
             * ʱֵ߲
             * @param time @en The time. @zh ʱ䡣
             */
            evaluate(time: number): number;
            /**
             * @ignore
             * @param optKey
             * @param leftIndex
             * @param rightIndex
             */
            calcOptimizedKey(optKey: __private._cocos_core_geometry_curve__OptimizedKey, leftIndex: number, rightIndex: number): void;
        }
        export enum SplineMode {
            /**
             * @en
             * Broken line:
             * Each knot is connected with a straight line from the beginning to the end to form a curve. At least two knots.
             * @zh
             * ÿͷβһֱγһߡ ٴ㡣
             */
            LINEAR = 0,
            /**
             * @en
             * Piecewise Bezier curve:
             * Every four knots form a curve. Total knots number must be a multiple of 4.
             * Each curve passes only the first and fourth knots, and does not pass through the middle two control knots.
             *
             * If you need a whole continuous curve:
             * (1) Suppose the four knots of the previous curve are A, B, C, D
             * (2) The four knots of the next curve must be D, E, F, G
             * (3) C and E need to be symmetrical about D
             *
             * @zh
             * ֶαߣ
             * ÿĸγһߡ ܽ 4 ı
             * ÿֻͨһ͵ĸ㣬ͨмƽ㡣
             *
             * Ҫһߣ
             * (1) ǰߵĸֱ A, B, C, D
             * (2) һߵĸ D, E, F, G
             * (3) C  E Ҫ D Գ
             */
            BEZIER = 1,
            /**
             * @en
             * Catmull Rom curve:
             * All knots(including start & end knots) form a whole continuous curve. At least two knots.
             * The whole curve passes through all knots.
             *
             * @zh
             * Catmull Rom ߣ
             * н㣨ʼͽ㣩γһߡ ٴ㡣
             * ߴн㡣
             */
            CATMULL_ROM = 2
        }
        /**
         * @en
         * Basic Geometry: Spline.
         * @zh
         * ΣSpline
         */
        export class Spline {
            /**
             * @en
             * Creates a spline instance.
             * @zh
             * һ Spline ʵ
             * @param mode @en The mode to create the Spline instance. @zh ڴ Spline ʵģʽ
             * @param knots @en The knots to create the Spline instance. @zh ڴ Spline ʵĽб
             * @returns @en The created Spline instance. @zh  Spline ʵ
             */
            static create(mode: SplineMode, knots?: math.Vec3[]): Spline;
            /**
             * @en
             * Clones a Spline instance.
             * @zh
             * ¡һ Spline ʵ
             * @param s @en The Spline instance to be cloned. @zh ڿ¡ Spline ʵ
             * @returns @en The cloned Spline instance. @zh ¡ Spline ʵ
             */
            static clone(s: Spline): Spline;
            /**
             * @en
             * Copies the values of a Spline instance to another.
             * @zh
             * һ Spline ʵֵһС
             * @param out @en The target Spline instance to copy to. @zh Ŀ Spline ʵ
             * @param s @en The source Spline instance to copy from. @zh Դ Spline ʵ
             * @returns @en The target Spline instance to copy to, same as the `out` parameter. @zh Ŀ Spline ʵֵ `out` ͬ
             */
            static copy(out: Spline, s: Spline): Spline;
            /**
             * @en
             * Gets the type of this Spline instance, always returns `enums.SHAPE_SPLINE`.
             * @zh
             * ȡ Spline ̶ͣ `enums.SHAPE_SPLINE`
             */
            get type(): number;
            /**
             * @en
             * Gets the mode of this Spline instance.
             * @zh
             * ȡǰ Spline ʵģʽ
             */
            get mode(): SplineMode;
            /**
             * @en
             * Gets all knots of this Spline instance.
             * @zh
             * ȡǰ Spline ʵн㡣
             */
            get knots(): Readonly<math.Vec3[]>;
            /**
             * @en
             * Sets the mode and knots to this Spline instance.
             * @zh
             * ǰ Spline ʵģʽͽ㡣
             * @param mode @en The mode to be set to this Spline instance. @zh Ҫõǰ Spline ʵģʽ
             * @param knots @en The knots to be set to this spline instance. @zh Ҫõǰ Spline ʵĽб
             */
            setModeAndKnots(mode: SplineMode, knots: math.Vec3[]): void;
            /**
             * @en
             * Clears all knots of this Spline instance.
             * @zh
             * յǰ Spline ʵн㡣
             */
            clearKnots(): void;
            /**
             * @en
             * Gets the knot count of this Spline instance.
             * @zh
             * ȡǰ Spline ʵĽ
             * @returns @en The knot count of this Spline instance. @zh ǰ Spline ʵĽ
             */
            getKnotCount(): number;
            /**
             * @en
             * Adds a knot to this Spline instance.
             * @zh
             * ǰ Spline ʵһ㡣
             * @param knot @en The knot to add to this Spline instance. @zh Ҫӵǰ Spline ʵĽ㡣
             */
            addKnot(knot: math.Vec3): void;
            /**
             * @en
             * Inserts a knot to the specified position of this Spline instance.
             * @zh
             * һ㵽ǰ Spline ʵָλá
             * @param index @en The position of this Spline instance to be inserted. @zh Ҫ뵽 Spline ʵλá
             * @param knot @en The knot to be inserted. @zh ҪĽ㡣
             */
            insertKnot(index: number, knot: math.Vec3): void;
            /**
             * @en
             * Removes a knot at the specified position of this Spline instance.
             * @zh
             * Ƴǰ Spline ʵָλõһ㡣
             * @param index
             */
            removeKnot(index: number): void;
            /**
             * @en
             * Sets a knot to the specified position of this Spline instance.
             * @zh
             * Ϊǰ Spline ʵָλýϢ
             * @param index @en The specified position of this Spline instance. @zh Ҫýָλá
             * @param knot @en The knot to be set to the specified position. @zh ҪõĽ㡣
             */
            setKnot(index: number, knot: math.Vec3): void;
            /**
             * @en
             * Gets the knot of the specified position of this Spline instance.
             * @zh
             * ȡǰ Spline ʵָλõĽ㡣
             * @param index @en The specified position of this Spline instance. @zh Ҫýָλá
             * @returns @en The knot of the specified position of this Spline instance. @zh ǰ Spline ʵָλõĽ㡣
             */
            getKnot(index: number): Readonly<math.Vec3>;
            /**
             * @en
             * Gets a point at t with repect to the `index` segment of curve or the whole curve.
             * @zh
             * ȡ t ĳλߵĵ㡣
             * @param t @en The factor with a range of [0.0, 1.0]. @zh 0.0  1.0 ӡ
             * @param index @en The knot index of this Spline instance, default value is the whole curve. @zh ǰ Spline ʵĳĬֵΪߡ
             * @returns @en The point matches the input `t` factor and `index`. @zh  `t`  `index` ĵ㡣
             */
            getPoint(t: number, index?: number): math.Vec3;
            /**
             * @en
             * Gets points from 0 to 1 uniformly with repect to the `index` segment of curve or the whole curve.
             * @zh
             * ȡĳλϵ n ĵϢ
             * @param num @en The count of points needed. @zh Ҫĵ
             * @param index @en The knot index of this Spline instance, default value is the whole curve. @zh ǰ Spline ʵĳĬֵΪߡ
             * @returns @en The points with `num` size at the `index` segment or the whole curve. @zh ĳλϵ `num` 㡣
             */
            getPoints(num: number, index?: number): math.Vec3[];
        }
        /**
         * @en
         * The raycast mode.
         * @zh
         * ߼ģʽ
         */
        export enum ERaycastMode {
            /**
             * @en
             * Detects and records all data.
             * @zh
             * Ⲣ¼еݡ
             */
            ALL = 0,
            /**
             * @en
             * Detects all data, but records only the most recent data.
             * @zh
             * Уֻ¼ݡ
             */
            CLOSEST = 1,
            /**
             * @en
             * Once the test is successful, the test is stopped and the data is recorded only once.
             * @zh
             * һɹֹͣ⣬ֻ¼һݡ
             */
            ANY = 2
        }
        /**
         * @en
         * The storage structure of the raycast results.
         * @zh
         * ߼Ĵ洢ṹ
         */
        export interface IRaySubMeshResult {
            /**
             * @en
             * The distance between the hit point and the ray.
             * @zh
             * еߵľ롣
             */
            distance: number;
            /**
             * @en
             * The index of the triangle vertex 0
             * @zh
             * ζ0
             */
            vertexIndex0: number;
            /**
             * @en
             * The index of the triangle vertex 1
             * @zh
             * ζ1
             */
            vertexIndex1: number;
            /**
             * @en
             * The index of the triangle vertex 2
             * @zh
             * ζ2
             */
            vertexIndex2: number;
        }
        /**
         * @en
         * The optional param structure of the `raySubMesh`.
         * @zh
         * `raySubMesh`Ŀѡṹ
         */
        export interface IRaySubMeshOptions {
            /**
             * @en
             * The raycast mode`ANY` by default.
             * @zh
             * ߼ģʽ[0, 1, 2]=>[`ALL`, `CLOSEST`, `ANY`]
             */
            mode: ERaycastMode;
            /**
             * @en
             * The maximum distance of the raycast, `Infinity` by default.
             * @zh
             * ߼룬ĬΪ`Infinity`
             */
            distance: number;
            /**
             * @en
             * An array used to store the results of a ray detection.
             * @zh
             * ڴ洢߼顣
             */
            result?: IRaySubMeshResult[];
            /**
             * @en
             * Whether to detect the double-sided or not`false` by default.
             * @zh
             * Ƿ˫棬ĬΪ`false`
             */
            doubleSided?: boolean;
        }
        /**
         * @en
         * The optional param structure of the `rayMesh`.
         * @zh
         * `rayMesh`Ŀѡṹ
         */
        export interface IRayMeshOptions extends IRaySubMeshOptions {
            /**
             * @en
             * The index of the sub mesh.
             * @zh
             * 
             */
            subIndices?: number[];
        }
        /**
         * @en
         * The optional parameter structure of the `rayModel`.
         * @zh
         * `rayModel`Ŀѡṹ
         */
        export type IRayModelOptions = IRayMeshOptions;
        /**
         * @en
         * Alias of [[geometry.Line]]
         * @zh
         * [[geometry.Line]] 
         *
         * @deprecated Since v3.0, please use Line instead
         */
        export class line extends Line {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Plane]]
         *
         * @zh
         * [[geometry.Plane]] 
         *
         * @deprecated Since v3.0, please use Plane instead
         */
        export class plane extends Plane {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Ray]]
         * @zh
         * [[geometry.Ray]] 
         * @deprecated Since v3.0, please use Ray instead
         */
        export class ray extends Ray {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Triangle]]
         *
         * @zh
         * [[geometry.Triangle]] 
         * @deprecated Since v3.0, please use Triangle instead
         */
        export class triangle extends Triangle {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Sphere]]
         *
         * @zh
         * [[geometry.Sphere]] 
         * @deprecated Since v3.0, please use Sphere instead
         */
        export class sphere extends Sphere {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.AABB]]
         *
         * @zh
         * [[geometry.AABB]] 
         * @deprecated Since v3.0, please use AABB instead
         */
        export class aabb extends AABB {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.OBB]]
         *
         * @zh
         * [[geometry.OBB]] 
         * @deprecated Since v3.0, please use OBB instead
         */
        export class obb extends OBB {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Capsule]]
         *
         * @zh
         * [[geometry.Capsule]] 
         * @deprecated Since v3.0, please use Capsule instead
         */
        export class capsule extends Capsule {
            constructor();
        }
        /**
         * @en
         * Alias of [[geometry.Frustum]]
         *
         * @zh
         * [[geometry.Frustum]] 
         * @deprecated Since v3.0, please use Frustum instead
         */
        export class frustum extends Frustum {
            constructor();
        }
    }
    export const VERSION = "3.8.3";
    /**
     * @en
     * The main namespace of Cocos engine, all engine core classes, functions, properties and constants are defined in this namespace.
     * @zh
     * CocosҪռ䣬е࣬Ժͳռж塣
     * @deprecated
     */
    export const cclegacy: Record<string, any> & {
        _global: typeof globalThis;
    };
    /**
     * @en
     * Defines a BitMask type. The editor will display different inspector depending on this data type.  It may define some properties to the object.
     * The keys of new properties are the integer type values, and the values are corresponding keys. See the example below.
     * keys.
     * @zh
     * һλ͡༭ʾͬʾ档ܻڶԡԵ key ԭ valuevalue ǶӦ keyοӡ
     * @param obj
     * @en A JavaScript literal object containing BitMask names and values.
     * @zh  BitMask ƺֵ JavaScript ֶ
     * @returns @en The defined BitMask type @zh λ͡
     * @example
     * ```ts
     * // `type1` and `type2` are single-selected.
     * let obj = {
     *     type1: 0,
     *     type2: 1 << 2,
     * }
     *
     * // `type1` and `type2` are multiple-selected.
     * // New properties are added to obj, obj now is
     * // {
     * //     type1: 0,
     * //     type2: 1<< 2,
     * //     0: type1,
     * //     4: type2
     * // }
     * BitMask(obj);
     * ```
     */
    export function BitMask<T>(obj: T): T;
    export namespace BitMask {
        export var isBitMask: (BitMaskType: any) => any;
        export var getList: (BitMaskDef: any) => any;
        export var update: (BitMaskDef: any) => any;
    }
    /**
     * @en
     * Define an enum type. <br/>
     * If a enum item has a value of -1, it will be given an Integer number according to it's order in the list.<br/>
     * Otherwise it will use the value specified by user who writes the enum definition.
     *
     * @zh
     * һö͡<br/>
     * û԰öֵΪΪ -1ϵͳΪһöֵ + 1
     *
     * @param obj
     * @en A JavaScript literal object containing enum names and values, or a TypeScript enum type.
     * @zh öֵ JavaScript literal 󣬻һ TypeScript enum ͡
     * @return @en The defined enum type. @zh ö͡
     */
    export function Enum<T>(obj: T): T;
    export namespace Enum {
        export var update: <T>(obj: T) => T;
        export var isEnum: <EnumT extends {}>(enumType: EnumT) => boolean;
        export var getList: <EnumT extends {}>(enumType: EnumT) => readonly __private._cocos_core_value_types_enum__Enum.Enumerator<EnumT>[];
        export var sortList: <EnumT extends {}>(enumType: EnumT, compareFn: (a: any, b: any) => number) => void;
    }
    /**
     * Make the enum type `enumType` as enumeration so that Creator may identify, operate on it.
     * Formally, as a result of invocation on this function with enum type `enumType`:
     * - `Enum.isEnum(enumType)` returns `true`;
     * - `Enum.getList(enumType)` returns the enumerators of `enumType`.
     * @param
     * @en enumType An enum type, eg, a kind of type with similar semantic defined by TypeScript.
     * @zh öͣ TypeScript ж͡
     */
    export function ccenum<EnumT extends {}>(enumType: EnumT): void;
    /**
     * @en The base class of all value types.
     * @zh ֵ͵Ļࡣ
     */
    export class ValueType {
        /**
         * @en
         * Clone the current object. The clone result of the object should be equal to the current object,
         * i.e. satisfy `this.equals(this, value.clone())`.
         * The base version of this method do nothing and returns `this'.
         * The derived class **must** rewrite this method and the returned object should not be `this`, i.e. satisfy `this !== this.clone()`.
         * @zh
         * ¡ǰֵ¡ĽֵӦ뵱ǰֵȣ `this.equals(this, value.clone())`
         * Ļ汾򵥵ط `this`
         * ****дҷصĶӦΪ `this` `this !== this.clone()`
         * @returns @en The cloned object. @zh ¡Ķ
         */
        clone(): ValueType;
        /**
         * @en
         * Check whether the current object is equal to the specified object.
         * This check should be interchangeable, i.e. satisfy `this.equals(other) === other.equals(this)`.
         * The base version of this method will returns `false'.
         * @zh
         * жϵǰֵǷֵָȡжӦнԣ `this.equals(other) === other.equals(this)`
         * Ļ汾򵥵ط `false`
         * @param other @en The other object @zh ֵָ
         * @returns @en `true` if equal, otherwise returns `false` @zh ȣ򷵻 `true`򷵻 `false`
         */
        equals(other: this): boolean;
        /**
         * @en
         * Set the property values of the current object with the given object.
         * The base version of this method will returns `this' and the derived class **must** rewrite this method.
         * @zh
         * ֵǰֵʹֵָȡ
         * Ļ汾򵥵ط `this`****д
         * @param other @en The other object. @zh ֵָ
         */
        set(other: this): void;
        /**
         * @en
         * Convert the current object to a string.
         * The base version of this method will returns an empty string.
         * @zh
         * صǰֵַʾ
         * Ļ汾ؿַ
         * @returns @en The string representation of the current value. @zh ǰֵַʾ
         */
        toString(): string;
    }
    export namespace js {
        /**
         * @en
         * ID generator for runtime.
         *
         * @zh
         * ʱ ID 
         */
        export class IDGenerator {
            /**
             * @en
             * The global id generator might have a conflict problem once every 365 days,
             * if the game runs at 60 FPS and each frame 4760273 counts of new id are requested.
             *
             * @zh
             * ȫֵ id Ϸ 60 FPS Уÿ֡ȡ 4760273  id,  365 ͻ
             */
            static global: IDGenerator;
            /**
             * @en A number to record current id. It may increase when invoke `getNewId()`. Should use
             * `getNewId()` to get a unique id.
             * @zh ¼ǰ id ֵ `getNewId()` ʱܱ1Ӧʹ `getNewId()` ȡΨһ id
             */
            id: number;
            /**
             * @en A string value indicates the category this IDGenerator belongs to. It will be an empty
             * string if not be assigned by passed parameter in constructor.
             * @zh ڱʶ IDGenerator 캯ûдֵĻһַ
             */
            prefix: string;
            /**
             * @en Construct a new id generator.
             * @zh һµ id 
             *
             * @param category @en You can specify a unique category to avoid id collision with other instance of IdGenerator.
             * @zh ָһΨһıʶڱ id ͻ
             */
            constructor(category?: string);
            /**
             * @en Gets a unique id. @zh ȡΨһ id
             * @returns @en The unique id. It has the form `prefix+id`, for example `scene55`, `scene` is `prefix`, `55` is `id`.
             * @zh Ψһ idʽ `prefix+id` `scene55``scene`  prefix`55`  `id`
             */
            getNewId(): string;
        }
        /**
         * @en
         * A fixed-length object pool designed for general type.<br>
         * The implementation of this object pool is very simple.
         * It can help you to improve your game performance for objects which need frequent release and recreate operations.<br/>
         * @zh
         * ȹ̶Ķ󻺴أֶ͡<br/>
         * صʵַǳ԰ϷܣŻķ١
         * @class js.Pool
         * @example
         * ```
         *
         * Example 1:
         *
         * function Details () {
         *     this.uuidList = [];
         * };
         * Details.prototype.reset = function () {
         *     this.uuidList.length = 0;
         * };
         * Details.pool = new js.Pool(function (obj) {
         *     obj.reset();
         * }, 5);
         * Details.pool.get = function () {
         *     return this._get() || new Details();
         * };
         *
         * var detail = Details.pool.get();
         * ...
         * Details.pool.put(detail);
         *
         * Example 2:
         *
         * function Details (buffer) {
         *    this.uuidList = buffer;
         * };
         * ...
         * Details.pool.get = function (buffer) {
         *     var cached = this._get();
         *     if (cached) {
         *         cached.uuidList = buffer;
         *         return cached;
         *     }
         *     else {
         *         return new Details(buffer);
         *     }
         * };
         *
         * var detail = Details.pool.get( [] );
         * ...
         * ```
         */
        export class Pool<T> {
            /**
             * @en
             * The current number of available objects, the default is 0. It will gradually increase with the recycle of the object,
             * the maximum will not exceed the size specified when the constructor is called.
             * @zh
             * ǰöһʼĬ 0ŶĻջ󲻻ᳬù캯ʱָ size
             * @default 0
             */
            count: number;
            /**
             * @en
             * Gets an object from pool.
             * @zh Ӷлȡһ
             * @returns @en An object or null if this pool doesn't contain any object.
             * @zh ȡĶûж󣬷 null
             */
            get(): T | null;
            /**
             * @en Constructor. @zh 캯
             * @param cleanupFunc @en Callback method used to process the cleanup logic when the object is recycled.
             * @zh ʱִ߼Ļص
             * @param size @en Pool size. @zh شС
             */
            constructor(cleanup: __private._cocos_core_utils_pool__CleanUpFunction<T>, size: number);
            /**
             * @en Constructor. @zh 캯
             * @param size @en Pool size. @zh شС
             */
            constructor(size: number);
            /**
             * @en
             * Gets an object from pool.
             * @zh Ӷлȡһ
             * @returns @en An object or null if this pool doesn't contain any object.
             * @zh ȡĶûж󣬷 null
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _get(): T | null;
            /**
             * @en Put an object into the pool.
             * @zh طһҪĶ
             */
            put(obj: T): void;
            /**
             * @en Resize the pool.
             * @zh ö
             * @param length @en New pool size.
             * @zh ¶شС
             */
            resize(length: number): void;
        }
        export namespace array {
            /**
             * @zh
             * ƳָԪء
             * @en
             * Removes the array item at the specified index.
             * @param array @zh 顣@en The array to be operated.
             * @param index @zh ƳԪص@en The index of the element to be removed.
             */
            export function removeAt<T>(array: T[], index: number): void;
            /**
             * @zh
             * ƳָԪء
             * ˺ʮָЧıԪش
             * @en
             * Removes the array item at the specified index.
             * It's faster but the order of the array will be changed.
             * @param array @zh 顣@en The array to be operated.
             * @param index @zh ƳԪص@en The index of the element to be removed.
             */
            export function fastRemoveAt<T>(array: T[], index: number): void;
            /**
             * @zh
             * Ƴ׸ָԪءжԪʱ൱ʹ `Array.prototype.indexOf`
             * @en
             * Removes the first occurrence of a specific object from the array.
             * Decision of the equality of elements is similar to `Array.prototype.indexOf`.
             * @param array @zh 顣@en The array to be operated.
             * @param value @zh ƳԪء@en The value to be removed.
             */
            export function remove<T>(array: T[], value: T): boolean;
            /**
             * @zh
             * Ƴ׸ָԪءжԪʱ൱ʹ `Array.prototype.indexOf`
             * ˺ʮָЧıԪش
             * @en
             * Removes the first occurrence of a specific object from the array.
             * Decision of the equality of elements is similar to `Array.prototype.indexOf`.
             * It's faster but the order of the array will be changed.
             * @param array @zh 顣@en The array to be operated.
             * @param value @zh ƳԪء@en The value to be removed.
             */
            export function fastRemove<T>(array: T[], value: T): void;
            /**
             * @zh
             * Ƴ׸ʹνԪء
             * @en
             * Removes the first occurrence of a specific object from the array where `predicate` is `true`.
             * @param array @zh 顣@en The array to be operated.
             * @param predicate @zh һԪνʣҪԪصĻҪ true@en unary predicate which returns true if the element should be removed.
             */
            export function removeIf<T>(array: T[], predicate: (value: T) => boolean): T | undefined;
            /**
             * @zh
             * ֤͡
             * ˺ `instanceof` ֤ÿһԪء
             * @en
             * Verify array's Type.
             * This function tests each element using `instanceof` operator.
             * @param array @zh ֤顣@en The array to be verified.
             * @param type @zh жԪص͡@en The type used to verify the element type.
             * @returns @zh ÿһԪضָʱ `true`򷵻 `false`@en Return true if all elements of the array is the same type, false others.
             */
            export function verifyType<T extends Function>(array: any[], type: T): array is T[];
            /**
             * @zh
             * ƳԪء
             * @en
             * Removes multiple array elements.
             * @param array @zh 顣@en The array to be operated.
             * @param removals @zh дƳԪءÿԪӦ׸ԴԪضᱻƳ
             *                 @en The values to be removed. If a value appears multiple times in the array, only the first math element will be removed.
             */
            export function removeArray<T>(array: T[], removals: T[]): void;
            /**
             * @zh
             * ָϲ
             * @en
             * Inserts some objects at specified index.
             * @param array @zh 顣@en The array to be operated.
             * @param objects @zh ж@en The objects to be inserted.
             * @param index @zh @en The index to insert at.
             * @returns @zh  `array`@en The passed in `array`.
             */
            export function appendObjectsAt<T>(array: T[], objects: T[], index: number): T[];
            /**
             * @zh
             * ǷָԪء
             * @en
             * Determines whether the array contains a specific element.
             * @param array @zh ѯ @en The array to be checked.
             * @param value @zh ѯֵ @en The value used to check for.
             * @returns @zh true Ԫأ򷵻 false@en true if contains the value, false else.
             */
            export function contains<T>(array: T[], value: T): boolean;
            /**
             * @zh
             * 顣
             * @en
             * Copy an array.
             * @param array @zh 顣@en The array to be copied from.
             * @returns @zh ĸ@en A new array has the same values as `array`.
             */
            export function copy<T>(array: T[]): T[];
        }
        /**
         * @deprecated since v3.7.0, `js.js` is deprecated, please access `js` directly instead.
         */
        export const js: {
            IDGenerator: typeof IDGenerator;
            Pool: typeof Pool;
            array: typeof array;
            isNumber: typeof isNumber;
            isString: typeof isString;
            isEmptyObject: typeof isEmptyObject;
            getPropertyDescriptor: typeof getPropertyDescriptor;
            addon: typeof addon;
            mixin: typeof mixin;
            extend: typeof extend;
            getSuper: typeof getSuper;
            isChildClassOf: typeof isChildClassOf;
            clear: typeof clear;
            value: (object: Record<string | number, any>, propertyName: string, value_: any, writable?: boolean | undefined, enumerable?: boolean | undefined) => void;
            getset: (object: Record<string | number, any>, propertyName: string, getter: __private.__types_globals__Getter, setter?: boolean | __private.__types_globals__Setter | undefined, enumerable?: boolean | undefined, configurable?: boolean | undefined) => void;
            get: (object: Record<string | number, any>, propertyName: string, getter: __private.__types_globals__Getter, enumerable?: boolean | undefined, configurable?: boolean | undefined) => void;
            set: (object: Record<string | number, any>, propertyName: string, setter: __private.__types_globals__Setter, enumerable?: boolean | undefined, configurable?: boolean | undefined) => void;
            unregisterClass: typeof unregisterClass;
            getClassName: typeof getClassName;
            setClassName: typeof setClassName;
            setClassAlias: typeof setClassAlias;
            getClassByName: typeof getClassByName;
            getClassById: typeof getClassById;
            /**
             * @en All classes registered in the engine, indexed by name.
             * @zh עͣͨƽ
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             * @example
             * ```
             * import { js } from 'cc';
             * // save all registered classes before loading scripts
             * let builtinClassIds = js._registeredClassIds;
             * let builtinClassNames = js._registeredClassNames;
             * // load some scripts that contain CCClass
             * ...
             * // clear all loaded classes
             * js._registeredClassIds = builtinClassIds;
             * js._registeredClassNames = builtinClassNames;
             * ```
             *
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _registeredClassNames: Record<string, __private.__types_globals__Constructor<unknown>>;
            /**
             * @en All classes registered in the engine, indexed by ID.
             * @zh עͣͨ ID 
             * @example
             * ```
             * import { js } from 'cc';
             * // save all registered classes before loading scripts
             * let builtinClassIds = js._registeredClassIds;
             * let builtinClassNames = js._registeredClassNames;
             * // load some scripts that contain CCClass
             * ...
             * // clear all loaded classes
             * js._registeredClassIds = builtinClassIds;
             * js._registeredClassNames = builtinClassNames;
             * ```
             *
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _registeredClassIds: Record<string, __private.__types_globals__Constructor<unknown>>;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _getClassId: typeof _getClassId;
            getClassId: typeof getClassId;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _setClassId: (id: string, constructor: __private.__types_globals__Constructor<unknown>) => void;
            /**
             * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
             */
            _getClassById: typeof _getClassById;
            obsolete: typeof obsolete;
            obsoletes: typeof obsoletes;
            formatStr: typeof formatStr;
            shiftArguments: typeof shiftArguments;
            createMap: typeof createMap;
        };
        /**
         * @en
         * Checks if an object is `number`.
         * @zh
         * Ƿ number ͡
         * @param object @en The object to check. @zh ҪĶ
         * @returns @en True if it is a number primitive or a `Number` instance, false else.
         * @zh öǻͻ `Number` ʵ `true`򷵻 `false`
         * @example
         * ```ts
         * var obj = 10;
         * isNumber(obj); // returns true
         *
         * obj = new Number(10);
         * isNumber(obj); // returns true
         * ```
         */
        export function isNumber(object: any): boolean;
        /**
         * @en
         * Checks if an object is `string`.
         * @zh
         * Ƿ string ͡
         * @param object @en The object to check. @zh ҪĶ
         * @returns @en True if it is a string primitive or a `String` instance, false else.
         * @zh öǻַͻ `String` ʵ `true`򷵻 `false`
         * @example
         * ```ts
         * var obj = "it is a string";
         * isString(obj); // returns true
         *
         * obj = new String("it is a string");
         * isString(obj); // returns true
         * ```
         */
        export function isString(object: any): boolean;
        /**
         * @en
         * Checks if an object is empty object. If an object does not have any enumerable property
         * (including properties inherits from prototype chains), then it is an empty object.
         * @zh
         * ǷΪն󡣿նĶǣûκοɱöٵԣԭ̳еԣĶ
         * @param obj @en The object to check. @zh ҪĶ
         * @returns @en True if it is not an empty object or not an object, false else.
         * @zh ǿն߲һ󣬷 `true`򷵻 `false`
         */
        export function isEmptyObject(obj: any): boolean;
        /**
         * @en
         * A simple wrapper of `Object.create(null)` which ensures the return object have no prototype (and thus no inherited members).
         * This eliminates the need to make `hasOwnProperty` judgments when we look for values by key on the object,
         * which is helpful for performance in this case.
         * @zh
         * ÷Ƕ `Object.create(null)` ļ򵥷װ
         * `Object.create(null)` ڴ prototype Ҳ޼̳УĿն
         * ڸöϲʱͲý `hasOwnProperty` жϣʱа
         *
         * @param forceDictMode @en Apply the delete operator to newly created map object. This will let V8 put the object in
         * "dictionary mode" and disables creation of hidden classes. This will improve the performance of objects that are
         * constantly changing shape.
         * @zh ´ĵͼӦɾ⽫V8 "ֵģʽ"ֹࡣ⽫Щϱ仯״ܡ
         * @returns @en A newly map object. @zh һµ map 
         */
        export function createMap(forceDictMode?: boolean): any;
        /**
         * @en
         * Gets class name of the object, if object is just a {} (and which class named 'Object'), it will return "".
         * (modified from <a href="http://stackoverflow.com/questions/1249531/how-to-get-a-javascript-objects-class">the code of stackoverflow post</a>)
         * @zh
         * ȡƣ {} ᷵ ""ο stackoverflow Ĵʵ֣
         * <a href="http://stackoverflow.com/questions/1249531/how-to-get-a-javascript-objects-class">stackoverflow ʵ</a>
         * @param objOrCtor @en An object instance or constructor. @zh ʵ߹캯
         * @returns @en The class name. @zh 
         */
        export function getClassName(objOrCtor: any): string;
        /**
         * @en Deprecates a property. It will print waring message if the deprecated property is accessed.
         * The warning message includes new property name to use.
         * @zh һԡԻʹõĻӡϢϢµ
         * @param object @en The object or class of the property to deprecate.
         *               @zh ԵĶࡣ
         * @param obsoleted @en The property name to deprecate. It could be a property name or `className.propertyName`.
         * @zh ҪֱӴ `.` ʽ
         * @param newExpr @en New property name to use. It could be a property name or `className.propertyName`.
         * @zh µֱӴ `.` ʽ
         * @param writable @en Whether the property is writable. Default is false. @zh ǷдĬϲд
         */
        export function obsolete(object: any, obsoleted: string, newExpr: string, writable?: boolean): void;
        /**
         * @en Deprecates some properties. It will print waring message if any deprecated property is accessed.
         * The warning message includes new property name to use.
         * @zh һԡԻʹõĻӡϢϢµ
         * @param obj @en The object or class of these properties to deprecate.
         *            @zh ԵĶࡣ
         * @param objName @en The object name or class name of these properties to deprecate.
         *                @zh ԵĶ
         * @param props @en The property names to deprecate. @zh һ
         * @param writable @en Whether these properties are writable. @zh Ƿд
         */
        export function obsoletes(obj: any, objName: any, props: any, writable: any): void;
        /**
         * @en
         * A string tool to construct a string with format string.
         * @zh
         * ݸʽַһַ
         * @param msg @en A JavaScript string containing zero or more substitution strings (%s).
         * @zh  0 ߶ʽַ
         * @param subst @en JavaScript objects with which to replace substitution strings within msg.
         * @zh 滻 `msg` ʽıʽ
         * @returns @en A new formatted string. @zh ʽַ
         * @example
         * ```
         * import { js } from 'cc';
         * js.formatStr("a: %s, b: %s", a, b);
         * js.formatStr(a, b, c);
         * ```
         */
        export function formatStr(msg: string, ...subst: __private._cocos_core_platform_debug__StringSubstitution[]): string;
        /**
         * @en
         * A string tool to constructs a string from an arbitrary sequence of js object arguments.
         * @zh
         *  js йһַ
         * @returns @en A new formatted string. @zh ʽַ
         * @example
         * ```
         * import { js } from 'cc';
         * js.formatStr({}, null, undefined);  // [object Object] null undefined
         * ```
         */
        export function formatStr(...data: unknown[]): string;
        /**
         * @en Removes the first argument. @zh Ƴһ
         * @returns @en An Array that contains all arguments except the first one.
         * @zh µĲ飬鲻һ
         */
        export function shiftArguments(): any[];
        /**
         * @en Gets a property descriptor by property name of an object or its prototypes.
         * @zh һԭлȡ
         * @param object @en The object to get property descriptor. @zh ȡĶ
         * @param propertyName @en The property name to get property descriptor.
         * @zh ȡ
         * @returns @en A `PropertyDescriptor` instance or null if not found.
         * @zh ûҵĻ null
         */
        export function getPropertyDescriptor(object: any, propertyName: string): PropertyDescriptor | null;
        /**
         * @en Copies all properties except those in `excepts` from `source` to `target`.
         * @zh  `source` ԣЩ `excepts`ԣ `target`
         * @param source @en Source object to copy from. @zh Դ
         * @param target @en Target object to copy to. @zh Ŀ
         * @param excepts @en Properties are not copied. @zh ԡ
         */
        export function copyAllProperties(source: any, target: any, excepts: Array<string>): void;
        /**
         * @en Copies all the properties in "sources" that are not defined in object from "sources" to "object".
         * @zh  "sources" еû object Դ "sources" Ƶ "object"
         * @param object @en Object to copy properties to. @zh Ŀ
         * @param sources @en Source objects to copy properties from. @zh Դ顣
         * @return @en The passing `object` or a new object if passing object is not valid.
         * @zh ĶĶЧû룬һ¶
         */
        export function addon(object?: Record<string | number, any>, ...sources: any[]): Record<string | number, any>;
        /**
         * @en Copies all the properties in "sources" from "sources" to "object".
         * @zh  "sources" еԴ "sources" Ƶ "object"
         * @param object @en Object to copy properties to. @zh Ŀ
         * @param sources @en Source objects to copy properties from. @zh Դ顣
         * @return @en The passing `object` or a new object if passing object is not valid.
         * @zh ĶĶЧû룬һ¶
         */
        export function mixin(object?: Record<string | number, any>, ...sources: any[]): Record<string | number, any>;
        /**
         * @en
         * Makes a class inherit from the supplied base class.
         * @zh
         * һͼ̳һ͡
         * @param cls @en The class to inherit. @zh Ҫ̳еࡣ
         * @param base @en The class to inherit from. @zh ̳еࡣ
         * @returns @en Passed in `cls`. @zh  `cls`
         */
        export function extend(cls: Function, base: Function): Function | undefined;
        /**
         * @en Get super class.
         * @zh ȡࡣ
         * @param constructor @en The constructor to get super class.
         * @zh ҪȡĹ캯
         * @returns @en Super class. @zh ࡣ
         */
        export function getSuper(constructor: Function): any;
        /**
         * @en
         * Checks whether a class is child of another class, or is the same type as another class.
         * @zh жһǷһ͵
         * @param subclass @en Sub class to check. @zh ͡
         * @param superclass @en Super class to check. @zh ͡
         * @return @en True if sub class is child of super class, or they are the same type. False else.
         * @zh Ǹ͵࣬߶ͬͣô true򷵻 false
         */
        export function isChildClassOf<T extends __private.__types_globals__Constructor>(subclass: unknown, superclass: T): subclass is T;
        export function isChildClassOf(subclass: unknown, superclass: unknown): boolean;
        /**
         * @en Removes all enumerable properties from a object.
         * @zh Ƴпö.
         * @param object @en The object to remove enumerable properties from.
         * @zh ҪɾöԵĶ
         */
        export function clear(object: Record<string | number, any>): void;
        /**
         * @en Registers a class by specified name manually.
         * @zh ֶָͨע
         * @param className @en Class name to register. @zh ע
         * @param constructor @en Constructor to register. @zh עĹ캯
         */
        export function setClassName(className: string, constructor: __private.__types_globals__Constructor): void;
        /**
         * @en Sets an alias for a class.
         * After executing `setClassAlias(target, alias)`, `alias` will be a single way short cut for class `target`.
         * `js.getClassByName(alias)` and `getClassById(alias)` will return `target`. But `js.getClassName(target)`
         * will return the original class name of `target`, not the alias.
         * @zh Ϊñִ `setClassAlias(target, alias)` `alias` Ϊ `target`   ID  ơ
         * ˣ`getClassById(alias)`  `getClassByName(alias)` õ `target`ӳǵģζ `getClassName(target)`
         *  `getClassId(target)` ᷵ `alias`
         * @param target @en Constructor of a class to set an alias. @zh ñĹ캯
         * @param alias @en Alias to set. The name shall not have been set as class name or alias of another class.
         * @zh ıظҲ֡
         */
        export function setClassAlias(target: __private.__types_globals__Constructor, alias: string): void;
        /**
         * @en
         * Unregister some classes from engine.
         * If you don't need a registered class anymore, you should unregister the class or engine will keep its reference.
         * Please note that its your responsibility to remove other references to the class.
         * @zh
         * ȡע͡㲻Ҫһע࣬Ӧȡע࣬ỹжá
         * ע⣬ȻͷطԸá
         *
         * @param ...constructor @en The classes to unregister. @zh ȡעб
         */
        export function unregisterClass(...constructors: Function[]): void;
        /**
         * @en Gets a registered class by id.
         * @zh ͨ id ȡע͡
         * @param classId @en An id to get class.
         * @return constructor
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         * Please use `getClassById()` instead.
         */
        export function _getClassById(classId: any): __private.__types_globals__Constructor<unknown>;
        /**
         * @en Gets the registered class by id.
         * @zh ͨ id ȡע͡
         * @param classId @en The class id used to get class. @zh ȡ id
         * @returns @en The constructor of the registered class. @zh ע๹캯
         */
        export function getClassById(classId: any): __private.__types_globals__Constructor<unknown>;
        /**
         * @en
         * Gets the registered class by class name.
         * @zh
         * ͨȡע͡
         * @param classname @en The class name used to get class. @zh ȡ
         * @returns @en The constructor of the registered class. @zh ע๹캯
         */
        export function getClassByName(classname: any): __private.__types_globals__Constructor<unknown>;
        /**
         * @en
         * Get class id of the object
         * @zh
         * ȡ class id
         * @param obj - instance or constructor
         * @param [allowTempId = true]   - can return temp id in editor
         * @return
         * @deprecated since v3.5.0. this is an engine private interface that will be removed in the future.
         * Please use `getClassId()` instead.
         */
        export function _getClassId(obj: any, allowTempId?: boolean): string;
        /**
         * @en
         * Gets class id of an object
         * @zh
         * ȡ class id
         * @param obj @en An object instance to get class id. @zh ȡʶĶ
         * @param allowTempId @en Whether allow to return a temple class id in editor.
         * @zh ڱ༭ʱǷһʱʶ
         * @returns @en Class id if found, empty string else.
         * @zh ҵʶûҵĻؿַ
         */
        export function getClassId(obj: any, allowTempId?: boolean): string;
        /**
         * @en A helper function to add a property to an object, or modifies attributes
         * of an existing property. The property is configurable.
         * @zh ΪԻ޸Եĸǿõġ
         * @param object @en The object to add or modify attributes. @zh Ҫӻ޸ԵĶ
         * @param propertyName @en The property name to add or modify. @zh Ҫӻ޸ĵ
         * @param value_ @en The property value to add or new value to replace a existing attribute.
         * @zh ҪӵֵȡԵֵ
         * @param writable @en If the property is writable. @zh Ƿд
         * @param enumerable @en If the property is enumerable. @zh Ƿö١
         */
        export const value: (object: Record<string | number, any>, propertyName: string, value_: any, writable?: boolean, enumerable?: boolean) => void;
        /**
         * @en A helper function to add or modify `get`, `set`, `enumerable` or `configurable` of a property.
         * @zh ӻ޸Ե `get`, `set`, `enumerable`  `configurable`
         * @param object @en The object to add or modify attributes. @zh Ҫӻ޸ԵĶ
         * @param propertyName @en The property name to add or modify. @zh Ҫӻ޸ĵ
         * @param getter @en The getter of a property. @zh ԵĻȡ
         * @param setter @en The setter of a property. @zh Եú
         * @param enumerable @en If the property is enumerable. @zh Ƿо١
         * @param configurable @en If the property is configurable. @zh Ƿá
         */
        export const getset: (object: Record<string | number, any>, propertyName: string, getter: __private.__types_globals__Getter, setter?: __private.__types_globals__Setter | boolean, enumerable?: boolean, configurable?: boolean) => void;
        /**
         * @en A helper function to add or modify `get`, `enumerable` or `configurable` of a property.
         * @zh ӻ޸Ե `get`, `enumerable`  `configurable`
         * @param object @en The object to add or modify attributes. @zh Ҫӻ޸ԵĶ
         * @param propertyName @en The property name to add or modify. @zh Ҫӻ޸ĵ
         * @param getter @en The getter of a property. @zh ԵĻȡ
         * @param enumerable @en If the property is enumerable. @zh Ƿо١
         * @param configurable @en If the property is configurable. @zh Ƿá
         */
        export const get: (object: Record<string | number, any>, propertyName: string, getter: __private.__types_globals__Getter, enumerable?: boolean, configurable?: boolean) => void;
        /**
         * @en A helper function to add or modify `get`, `enumerable` or `configurable` of a property.
         * @zh ӻ޸Ե `get`, `enumerable`  `configurable`
         * @param object @en The object to add or modify attributes. @zh Ҫӻ޸ԵĶ
         * @param propertyName @en The property name to add or modify. @zh Ҫӻ޸ĵ
         * @param setter @en The setter of a property. @zh Եú
         * @param enumerable @en If the property is enumerable. @zh Ƿо١
         * @param configurable @en If the property is configurable. @zh Ƿá
         */
        export const set: (object: Record<string | number, any>, propertyName: string, setter: __private.__types_globals__Setter, enumerable?: boolean, configurable?: boolean) => void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const _idToClass: Record<string, __private.__types_globals__Constructor>;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const _nameToClass: Record<string, __private.__types_globals__Constructor>;
        /**
         * @en
         * Register the class by specified id, if its classname is not defined, the class name will also be set.
         * @zh
         * ͨ id ע
         * @method _setClassId
         * @param classId
         * @param constructor
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        export const _setClassId: (id: string, constructor: __private.__types_globals__Constructor) => void;
    }
    export namespace misc {
        /**
         * @en Inserts a new element into a map. All values corresponding to the same key are stored in an array.
         * @zh  map һԪءͬһؼֶӦֵ洢һ
         * @param map @en The map to insert element. @zh Ԫص map
         * @param key @en The key of new element. @zh ²ԪصĹؼ֡
         * @param value @en The value of new element. @zh ²Ԫصֵ
         * @param pushFront @en Whether to put new value in front of the vector if key exists.
         * @zh ؼѾڣǷ²ֵŵһλá
         */
        export function pushToMap(map: any, key: any, value: any, pushFront: any): void;
        /**
         * @en Checks whether a node is a descendant of a given node, that is the node itself, one of its direct
         * children (childNodes), one of the children's direct children, and so on.
         * @zh ڵǷһĽڵĺڵ㱾һֱӽڵ㣨childNodesӽڵһֱӽڵ㣬ơ
         * @param refNode @en The node to check. @zh Ľڵ㡣
         * @param otherNode @en The node to test with. @zh ԵĽڵ㡣
         * @returns @en True if otherNode is contained in refNode, false if not.
         * @zh  refNode  otherNode true򷵻 false
         */
        export function contains(refNode: any, otherNode: any): boolean;
        /**
         * @en Checks whether a node is a DOM node. @zh һڵǷһ DOM ڵ㡣
         * @param node @en The node the check. @zh ڵ㡣
         * @returns @en True if node is a DOM node, false else.
         * @zh  DOM ڵ㣬 true򷵻 false
         */
        export function isDomNode(node: any): boolean;
        /**
         * @en Invoke a function in next frame. @zh һִ֡дĺ
         * @param callback @en The function to be invoked next frame. @zh һ֡Ҫִеĺ
         * @param p1 @en The first parameter passed to `callback`. @zh صĵһ
         * @param p2 @en The seconde parameter passed to `callback`. @zh صĵڶ
         */
        export function callInNextTick(callback: any, p1?: any, p2?: any): void;
        /**
         * @en Create a new function that will invoke `functionName` with try catch.
         * @zh һºúʹ try catch Ƶ `functionName`.
         * @param funcName @en The function name to be invoked with try catch.
         * @zh  try catch ĺ
         * @returns @en A new function that will invoke `functionName` with try catch.
         * @zh ʹ try catch Ƶ `functionName` º.
         */
        export function tryCatchFunctor_EDITOR(funcName: string): (comp: Component) => void;
        /**
         * @en Checks whether an object is an empty object.
         * @zh һǷΪն
         * @param obj @en The object to check. @zh ҪĶ
         * @returns @en True if it is an empty object. False if it is not an empty object, not Object type, null or undefined.
         * @ ǿն󣬷 trueǿն󣬲Objectͣջδ壬Ϊ١
         */
        export function isPlainEmptyObj_DEV(obj: any): boolean;
        /**
         * @en Clamps a value between a min and a max value. </br>
         * If the original value is greater than max_inclusive, returns max_inclusive. </br>
         * If the original value is less than min_inclusive, returns min_inclusive. </br>
         * Else returns the original value.
         * @zh ޶Сֵ<br/>
         * ֵ max_inclusive 򷵻 max_inclusive<br/>
         * ֵС min_inclusive 򷵻 min_inclusive<br/>
         * 򷵻
         * @param value @en Original value. @zh ʼֵ
         * @param min_inclusive @en Minimum value in range. @zh Сֵ
         * @param max_inclusive @en Maximum value in range. @zh ֵ
         * @returns @en The clamped value. @zh Ŀֵ
         * @example
         * var v1 = clampf(20, 0, 20); // 20;
         * var v2 = clampf(-1, 0, 20); //  0;
         * var v3 = clampf(10, 0, 20); // 10;
         */
        export function clampf(value: number, min_inclusive: number, max_inclusive: number): number;
        /**
         * @en Converts degree to radian.
         * @zh תΪȡ
         * @param angle @en The degree to convert. @zh Ƕȡ
         * @returns @en The radian. @zh ȡ
         */
        export function degreesToRadians(angle: number): number;
        /**
         * @en Converts radian to degree.
         * @zh תΪǶȡ
         * @param angle @en The radian to convert. @zh ȡ
         * @returns @en The degree. @zh Ƕȡ
         */
        export function radiansToDegrees(angle: any): number;
        export const BUILTIN_CLASSID_RE: RegExp;
        export const BASE64_VALUES: number[];
    }
    export namespace path {
        /**
         * @en Joins strings to be a path.
         * @zh ƴַΪ·
         * @param segments @en Strings to be joined. @zh ƴӵַ顣
         * @returns @en The final path. @zh ƴӺ·
         * @example {@link cocos/core/utils/CCPath/join.js}
         */
        export function join(...segments: string[]): string;
        /**
         * @en Gets the extension name of a path including '.', like '.png'.
         * @zh  Path չ '.' '.png'
         * @param path @en A file path. @zh ļ·
         * @returns @en The extension name. @zh չ
         * @example {@link cocos/core/utils/CCPath/extname.js}
         */
        export function extname(path: string): string;
        /**
         * @en Gets the main name of a file name, exclude extension name.
         * @zh ȡļơ
         * @deprecated
         */
        export function mainFileName(fileName: string): string;
        /**
         * @en Gets the file name of a file path, exclude extension name and directory name.
         * @zh ȡļ·ļչĿ¼
         * @param path @en A file path. @zh ļ·
         * @param extName @en File extension name. @zh ļչ
         * @returns @en The file name. @zh ļ
         * @example {@link cocos/core/utils/CCPath/basename.js}
         */
        export function basename(path: string, extName?: string): string;
        /**
         * @en Gets directory name of a file path.
         * @zh ȡļ·Ŀ¼
         * @param path @en A file path. @zh ļ·
         * @returns @en Directory name. @zh ļĿ¼
         * @example {@link cocos/core/utils/CCPath/dirname.js}
         */
        export function dirname(path: string): string;
        /**
         * @en Changes file extension name.
         * @zh ļչ
         * @param path @en A file path. @zh ļ·
         * @param extName @en New file extension name. @zh ļչ
         * @returns @en New file path. @zh µļ·
         * @example {@link cocos/core/utils/CCPath/changeExtname.js}
         */
        export function changeExtname(path: string, extName?: string): string;
        /**
         * @en Changes file name of a file path.
         * @zh ļ·ļ
         * @param path @en A file path. @zh ļ·
         * @param newBaseName @en New file name. @zh ļ
         * @param keepExt @en Whether to keep extension name. @zh Ƿչ
         * @returns @en New file path. @zh ļ·
         * @example {@link cocos/core/utils/CCPath/changeBasename.js}
         */
        export function changeBasename(path: string, newBaseName: string, keepExt?: boolean): string;
        export function _normalize(url: any): any;
        /**
         * @en Removes the last path separator('/' or '\') of a path if exist.
         * @zh ڵĻɾļ·һָ'/'  '\'
         * @param path @en A file path to modify. @zh Ҫ޸ĵļ·
         * @returns @en A new file path without last file separator.
         * @zh ·ָ·
         */
        export function stripSep(path: string): string;
        /**
         * @en Gets file separator for different platforms. It is `/` on unix like platforms,
         * and `\` on windows.
         * @zh ȡͬƽ̨ļָ unix ϵͳ `/`windows ϵͳ `\`
         * @returns @en File separator. @zh ļָ
         */
        export function getSeperator(): string;
    }
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     */
    export function setDefaultLogTimes(times: number): void;
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     */
    export let replaceProperty: (owner: object, ownerName: string, properties: __private._cocos_core_utils_x_deprecated__IReplacement[]) => void;
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     */
    export let removeProperty: (owner: object, ownerName: string, properties: __private._cocos_core_utils_x_deprecated__IRemoveItem[]) => void;
    /**
     * @deprecated since v3.6.0, this is an engine private interface that will be removed in the future.
     */
    export let markAsWarning: (owner: object, ownerName: string, properties: __private._cocos_core_utils_x_deprecated__IMarkItem[]) => void;
    /**
     * @en
     * Conversion of non-UI nodes to UI Node (Local) Space coordinate system.
     * @zh
     *  UI ڵת UI ڵ(ֲ) ռϵ
     * @deprecated since Cocos Creator 3D v1.2, please use [[Camera.convertToUINode]]
     * @param mainCamera @en The main camera @zh 
     * @param wpos @en The world space location. @zh ռλá
     * @param uiNode @en The UI node. @zh UI ڵ㡣
     * @param out @en The output local position in UI @zh  UI ڵֲꡣ
     */
    export function WorldNode3DToLocalNodeUI(mainCamera: Camera, wpos: math.Vec3, uiNode: Node, out?: math.Vec3): math.Vec3;
    /**
     * @en
     * Conversion of non-UI nodes to UI Node (World) Space coordinate system.
     * @zh
     *  UI ڵת UI ڵ()ռϵ
     * @deprecated since Cocos Creator 3D v1.2, please use [[Camera.convertToUINode]]
     * @param mainCamera @en The main camera @zh 
     * @param wpos @en The world space location. @zh ռλá
     * @param out @en The output world position in UI @zh  UI ռꡣ
     */
    export function WorldNode3DToWorldNodeUI(mainCamera: Camera, wpos: math.Vec3, out?: math.Vec3): math.Vec3;
    /**
     * @en It will be removed in v1.2. Please use [[Camera.convertToUINode]]
     * @zh  v1.2 Ƴʹ Camera  `convertToUINode`
     * @deprecated since Cocos Creator 3D v1.2
     */
    export const convertUtils: {
        WorldNode3DToLocalNodeUI: typeof WorldNode3DToLocalNodeUI;
        WorldNode3DToWorldNodeUI: typeof WorldNode3DToWorldNodeUI;
    };
    export namespace _decorator {
        /**
         * @en
         * Marks the target class as "uniquely referenced" which means, in the aspect of serialization,
         * no more than one object should reference the same instance of that class.
         * When serializing references to objects of such class,
         * they're treated as different objects even if they point to actually the same.
         * While deserializing, these two references would point two distinct objects.
         * For example:
         * ```ts
         * import { _decorator } from 'cc';
         * @_decorator.ccclass
         * @_decorator.uniquelyReferenced
         * class Foo { }
         *
         * @_decorator.ccclass
         * class Bar {
         *   @_decorator.property
         *   public foo = new Foo();
         * }
         *
         * const bar1 = new Bar();
         * const bar2 = new Bar();
         * bar2.foo = bar1.foo; // Programmatically let them reference to the same
         * ```
         * `bar1` and `bar2` reference to the same `Foo` object.
         * However, after deserializing, `bar1.foo === bar2.foo` always evaluates to `false`.
         * @zh
         * ĿΪΨһáģζžлԣжøͬһʵ
         * лĶʱʹָͬһҲᱻǲͬ
         * лýָȻͬ
         * 磺
         * ```ts
         * import { _decorator } from 'cc';
         * @_decorator.ccclass
         * @_decorator.uniquelyReferenced
         * class Foo { }
         *
         * @_decorator.ccclass
         * class Bar {
         *   @_decorator.property
         *   public foo = new Foo();
         * }
         *
         * const bar1 = new Bar();
         * const bar2 = new Bar();
         * bar2.foo = bar1.foo; // ɳ߼ͬһ
         * ```
         * `bar1`  `bar2` ͬһ `Foo` 
         * ڷл֮`bar1.foo === bar2.foo` 
         */
        export const uniquelyReferenced: ClassDecorator;
        /**
         * @en Declare a standard class as a CCClass, please refer to the [document](https://docs.cocos.com/creator3d/manual/en/scripting/ccclass.html)
         * @zh ׼дΪ CC ࣬÷[Ͷ](https://docs.cocos.com/creator3d/manual/zh/scripting/ccclass.html)
         * @param name - The class name used for serialization.
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass} = _decorator;
         *
         * // define a CCClass, omit the name
         *  @ccclass
         * class NewScript extends Component {
         *     // ...
         * }
         *
         * // define a CCClass with a name
         *  @ccclass('LoginData')
         * class LoginData {
         *     // ...
         * }
         * ```
         */
        export const ccclass: ((name?: string) => ClassDecorator) & ClassDecorator;
        /**
         * @en Declare as a CCClass property with options
         * @zh Ϊ CCClass ԡ
         * @param options property options
         */
        export function property(options?: __private._cocos_core_data_decorators_property__IPropertyOptions): __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare as a CCClass property with the property type
         * @zh עΪ cc ԡ<br/>
         * ȼ`@property({type})`
         * @param type A [[ccclass]] type or a [[ValueType]]
         */
        export function property(type: __private._cocos_core_data_decorators_property__PropertyType): __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare as a CCClass property
         * @zh עΪ cc ԡ<br/>
         * ȼ`@property()`
         */
        export function property(...args: Parameters<__private._cocos_core_data_decorators_utils__LegacyPropertyDecorator>): void;
        /**
         * @en Declare that the current component relies on another type of component.
         * If the required component doesn't exist, the engine will create a new empty instance of the required component and add it to the node.
         * @zh ΪΪ CCClass ӵڵʱڣ潫Զӵͬһڵ㣬ֹűʱͬЧ
         * @param requiredComponent The required component type
         * @example
         * ```ts
         * import {_decorator, Sprite, Component} from cc;
         * import {ccclass, requireComponent} from _decorator;
         *
         * @ccclass
         * @requireComponent(Sprite)
         * class SpriteCtrl extends Component {
         *     // ...
         * }
         * ```
         */
        export const requireComponent: (requiredComponent: Function | Function[]) => ClassDecorator;
        /**
         * @en Set the component priority, it decides at which order the life cycle functions of components will be invoked. Smaller priority gets invoked before larger priority.
         * This will affect `onLoad`, `onEnable`, `start`, `update` and `lateUpdate`, but `onDisable` and `onDestroy` won't be affected.
         * @zh ýűڷõȼȼС 0 ִУȼ 0 ӺִСȼӰ onLoad, onEnable, start, update  lateUpdate onDisable  onDestroy Ӱ졣
         * @param priority - The execution order of life cycle methods for Component. Smaller priority gets invoked before larger priority.
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, executionOrder} = _decorator;
         *
         * @ccclass
         * @executionOrder(1)
         * class CameraCtrl extends Component {
         *     // ...
         * }
         * ```
         */
        export const executionOrder: (priority: number) => ClassDecorator;
        /**
         * @en Forbid adds multiple instances of the component to the same node.
         * @zh ֹͬͣͣӵͬһڵ㡣
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, disallowMultiple} = _decorator;
         *
         * @ccclass
         * @disallowMultiple
         * class CameraCtrl extends Component {
         *     // ...
         * }
         * ```
         */
        export const disallowMultiple: ClassDecorator & ((yes?: boolean) => ClassDecorator);
        /**
         * @en Makes a CCClass that inherits from component execute in edit mode.<br/>
         * By default, all components are only executed in play mode,<br/>
         * which means they will not have their callback functions executed while the Editor is in edit mode.<br/>
         * @zh ̳ Component  CCClass ڱ༭ִС<br/>
         * Ĭ£ Component ֻʱŻִУҲ˵ǵڻصڱ༭ﴥ
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, executeInEditMode} = _decorator;
         *
         *  @ccclass
         *  @executeInEditMode
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const executeInEditMode: ClassDecorator & ((yes?: boolean) => ClassDecorator);
        /**
         * @en Add the current component to the specific menu path in `Add Component` selector of the inspector panel
         * @zh ǰӵ˵Уûҡ "Rendering/CameraCtrl"
         * @param path - The path is the menu represented like a pathname. For example, the menu could be "Rendering/CameraCtrl".
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, menu} = _decorator;
         *
         * @ccclass
         * @menu("Rendering/CameraCtrl")
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const menu: (path: string) => ClassDecorator;
        /**
         * @en When [[_decorator.executeInEditMode]] is set,
         * This decorator will make the editor run in high FPS mode when a node with the component is focused
         * @zh ָ [[_decorator.executeInEditMode]] ԺplayOnFocus ѡеǰڵĽڵʱ߱༭ĳˢƵʵ 60 FPS򳡾ֻڱҪʱػ档
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, playOnFocus, executeInEditMode} = _decorator;
         *
         * @ccclass
         * @executeInEditMode
         * @playOnFocus
         * class CameraCtrl extends Component {
         *     // ...
         * }
         * ```
         */
        export const playOnFocus: ClassDecorator & ((yes?: boolean) => ClassDecorator);
        /**
         * @en Use a customized inspector page in the **inspector**
         * @zh Զ嵱ǰ **Լ** Ⱦʱõ UI ҳ
         * @param url The URL of the page definition in js
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, inspector} = _decorator;
         *
         * @ccclass
         * @inspector("packages://inspector/inspectors/comps/camera-ctrl.js")
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const inspector: (url: string) => ClassDecorator;
        /**
         * @en Define the icon of the component.
         * @zh Զ嵱ǰڱ༭ʾͼ url
         * @param url
         * @private
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, icon} = _decorator;
         *
         *  @ccclass
         *  @icon("xxxx.png")
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const icon: (url: string) => ClassDecorator;
        /**
         * @en Define the help documentation URL,
         * if given, the component section in the **Inspector** will have a help documentation icon refers to the web page given.
         * @zh ָǰİĵ urlù **Լ** оͻһͼ꣬ûָҳ
         * @param url The URL of the help documentation
         * @example
         * ```ts
         * import { _decorator, Component } from 'cc';
         * const {ccclass, help} = _decorator;
         *
         * @ccclass
         * @help("app://docs/html/components/spine.html")
         * class NewScript extends Component {
         *     // ...
         * }
         * ```
         */
        export const help: (url: string) => ClassDecorator;
        /**
         * @en Declare the property as the given type
         * @zh ǸԵ͡
         * @param type
         */
        export function type(type: Function | [
            Function
        ] | any): __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        export function type<T>(type: __private._cocos_core_data_utils_attribute__PrimitiveType<T> | [
            __private._cocos_core_data_utils_attribute__PrimitiveType<T>
        ]): __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare the property as integer
         * @zh ԱΪ
         */
        export const integer: __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare the property as float
         * @zh ԱΪ
         */
        export const float: __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare the property as boolean
         * @zh ԱΪֵ
         */
        export const boolean: __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
        /**
         * @en Declare the property as string
         * @zh ԱΪַ
         */
        export const string: __private._cocos_core_data_decorators_utils__LegacyPropertyDecorator;
    }
    export function CCClass<TFunction>(options: {
        name?: string;
        extends: null | (Function & {
            __props__?: any;
            _sealed?: boolean;
        });
        ctor: TFunction;
        properties?: any;
        editor?: any;
    }): any;
    export namespace CCClass {
        export var _isCCClass: (constructor: any) => boolean;
        export var fastDefine: (className: any, constructor: any, serializableFields: any) => void;
        export var Attr: typeof __private._cocos_core_data_utils_attribute;
        export var attr: typeof __private._cocos_core_data_utils_attribute.attr;
        export var isCCClassOrFastDefined: typeof __private._cocos_core_data_class__isCCClassOrFastDefined;
        export var getInheritanceChain: (constructor: any) => any[];
        export var isArray: (defaultVal: any) => boolean;
        export var getDefault: (defaultVal: any) => any;
        export var escapeForJS: (s: any) => string;
        export var IDENTIFIER_RE: RegExp;
        export var getNewValueTypeCode: any;
    }
    /**
     * @en
     * The base class of most of all the objects in Fireball.
     * @zh
     * 󲿷ֶĻࡣ
     * @private
     */
    export class CCObject implements __private._cocos_core_data_editor_extras_tag__EditorExtendableObject {
        static _deferredDestroy(): void;
        /**
         * @internal
         */
        [editorExtrasTag]: unknown;
        /**
         * @internal
         */
        _objFlags: number;
        protected _name: string;
        constructor(name?: string);
        /**
         * @en The name of the object.
         * @zh öơ
         * @default ""
         * @example
         * ```
         * obj.name = "New Obj";
         * ```
         */
        get name(): string;
        set name(value: string);
        /**
         * @en After inheriting CCObject objects, control whether you need to hide, lock, serialize, and other functions.
         * @zh ڼ̳ CCObject 󣬿ǷҪأлȹܡ
         */
        set hideFlags(hideFlags: CCObject.Flags);
        get hideFlags(): CCObject.Flags;
        /**
         * @en
         * Indicates whether the object is not yet destroyed. (It will not be available after being destroyed)<br>
         * When an object's `destroy` is called, it is actually destroyed after the end of this frame.
         * So `isValid` will return false from the next frame, while `isValid` in the current frame will still be true.
         * If you want to determine whether the current frame has called `destroy`, use `isValid(obj, true)`,
         * but this is often caused by a particular logical requirements, which is not normally required.
         *
         * @zh
         * ʾöǷã destroy 󽫲ã<br>
         * һ `destroy` Ժ󣬻һ֡١<br>
         * ˴һ֡ʼ `isValid` ͻ᷵ falseǰ֡ `isValid` Ȼ true<br>
         * ϣжϵǰ֡Ƿù `destroy`ʹ `isValid(obj, true)`ҵģͨ²Ҫ
         * @default true
         * @readOnly
         * @example
         * ```ts
         * import { Node, log } from 'cc';
         * const node = new Node();
         * log(node.isValid);    // true
         * node.destroy();
         * log(node.isValid);    // true, still valid in this frame
         * // after a frame...
         * log(node.isValid);    // false, destroyed in the end of last frame
         * ```
         */
        get isValid(): boolean;
        /**
         * @en
         * Destroy this Object, and release all its own references to other objects.<br/>
         * Actual object destruction will delayed until before rendering.
         * From the next frame, this object is not usable any more.
         * You can use `isValid(obj)` to check whether the object is destroyed before accessing it.
         * @zh
         * ٸö󣬲ͷá<br/>
         * ʵٲӳٵǰ֡ȾǰִСһ֡ʼö󽫲ٿá
         * ڷʶ֮ǰʹ `isValid(obj)` Ƿѱ١
         * @return whether it is the first time the destroy being called
         * @example
         * ```
         * obj.destroy();
         * ```
         */
        destroy(): boolean;
        /**
         * @en
         * Clear all references in the instance.
         *
         * NOTE: this method will not clear the getter or setter functions which defined in the instance of CCObject.
         *
         * @zh
         * ʵ
         * ע⣺˷ʵϵ getter  setter 
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         * @example
         * ```
         * // You can override the _destruct method if you need, for example:
         *       _destruct: function () {
         *           for (var key in this) {
         *               if (this.hasOwnProperty(key)) {
         *                   switch (typeof this[key]) {
         *                       case 'string':
         *                           this[key] = '';
         *                           break;
         *                       case 'object':
         *                       case 'function':
         *                           this[key] = null;
         *                           break;
         *               }
         *           }
         *       }
         * ```
         */
        _destruct(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _destroyImmediate(): void;
    }
    export namespace CCObject {
        export enum Flags {
            Destroyed,
            /**
             * @en The object will not be saved.
             * @zh ö󽫲ᱻ档
             */
            DontSave,
            /**
             * @en The object will not be saved when building a player.
             * @zh Ŀʱö󽫲ᱻ档
             */
            EditorOnly,
            Dirty,
            /**
             * @en Dont destroy automatically when loading a new scene.
             * @zh һ³ʱԶɾö
             * @private
             */
            DontDestroy,
            /**
             * @en
             * @zh
             * @private
             */
            PersistentMask,
            /**
             * @en
             * @zh
             * @private
             */
            Destroying,
            /**
             * @en The node is deactivating.
             * @zh ڵڷĹС
             * @private
             */
            Deactivating,
            /**
             * @en
             * Hide in game and hierarchy.
             * This flag is readonly, it can only be used as an argument of scene.addEntity() or Entity.createWithFlags().
             * @zh
             * ϷͲ㼶ظö<br/>
             * ñֻֻܱ scene.addEntity()һ
             */
            /**
             * @en The lock node, when the node is locked, cannot be clicked in the scene.
             * @zh ڵ㣬󳡾ڲܵ
             * @private
             */
            LockedInEditor,
            /**
             * @en Hide the object in editor.
             * @zh ڱ༭ظö
             */
            HideInHierarchy,
            /**
             * @en The object will not be saved and hide the object in editor,and lock node, when the node is locked,
             * cannot be clicked in the scene,and The object will not be saved when building a player.
             * @zh ö󽫲ᱻ,Ŀʱö󽫲ᱻ, ڵ㣬󳡾ڲܵ, ڱ༭ظö
             */
            AllHideMasks,
            /**
             * @en
             * Hide in game view, hierarchy, and scene view... etc.
             * This flag is readonly, it can only be used as an argument of scene.addEntity() or Entity.createWithFlags().
             * @zh
             * Ϸͼ㼶ͼȵ...ظö
             * ñֻֻܱ scene.addEntity()һ
             */
            IsPreloadStarted,
            IsOnLoadStarted,
            IsOnLoadCalled,
            IsOnEnableCalled,
            IsStartCalled,
            IsEditorOnEnableCalled,
            IsPositionLocked,
            IsRotationLocked,
            IsScaleLocked,
            IsAnchorLocked,
            IsSizeLocked
        }
        export let __props__: string[];
        export let __values__: string[];
    }
    /**
     * @en
     * Indicates that the editor should treat this property or array element as an Integer value.
     * @zh
     * ָ༭ʽԴԻԪء
     * @example
     * ```ts
     * import { CCInteger, _decorator } from "cc";
     *
     * // in the class definition:
     *
     * @_decorator.property({type: CCInteger})
     * count = 0;
     *
     * @_decorator.property({type: [CCInteger]})
     * array = [];
     * ```
     */
    export const CCInteger: __private._cocos_core_data_utils_attribute__PrimitiveType<number>;
    /**
     * @en
     * Indicates that the editor should treat this property or array element as a Float value.
     * @zh
     * ָ༭ԸʽԴԻԪء
     * @example
     * ```ts
     * import { CCFloat, _decorator } from "cc";
     *
     * // in the class definition:
     *
     * @_decorator.property({type: CCFloat})
     * x = 0;
     *
     * @_decorator.property({type: [CCFloat]})
     * array = [];
     * ```
     */
    export const CCFloat: __private._cocos_core_data_utils_attribute__PrimitiveType<number>;
    /**
     * @en
     * Indicates that the editor should treat this property or array element as a Boolean value.
     * @zh
     * ָ༭ԲֵʽԴԻԪء
     *
     * @example
     * ```ts
     * import { CCBoolean, _decorator } from "cc";
     * // in the class definition
     * @_decorator.property({type: CCBoolean})
     * isTrue = false;
     *
     * @_decorator.property({type: [CCBoolean]})
     * array = [];
     * ```
     */
    export const CCBoolean: __private._cocos_core_data_utils_attribute__PrimitiveType<boolean>;
    /**
     * @en
     * Indicates that the editor should treat this property or array element as a String value.
     * @zh
     * ָ༭ַʽԴԻԪء
     * @example
     * ```ts
     * import { CCString, _decorator } from "cc";
     *
     * // in the class definition
     *
     * @_decorator.property({type: CCString})
     * name = '';
     *
     * @_decorator.property({type: [CCString]})
     * array = [];
     * ```
     */
    export const CCString: __private._cocos_core_data_utils_attribute__PrimitiveType<string>;
    /**
     * @deprecated Since V3.5.0.
     */
    export class CompactValueTypeArray {
        static StorageUnit: typeof __private._cocos_core_data_utils_compact_value_type_array__StorageUnit;
        static ElementType: typeof __private._cocos_core_data_utils_compact_value_type_array__ElementType;
        /**
         * Returns the length in bytes that a buffer needs to encode the specified value array in form of CVTA.
         * @param values The value array.
         * @param unit Target element type.
         */
        static lengthFor(values: any[], elementType: __private._cocos_core_data_utils_compact_value_type_array__ElementType, unit: __private._cocos_core_data_utils_compact_value_type_array__StorageUnit): number;
        /**
         * Compresses the specified value array in form of CVTA into target buffer.
         * @param values The value array.
         * @param unit Target element type.
         * @param arrayBuffer Target buffer.
         * @param byteOffset Offset into target buffer.
         */
        static compress(values: any[], elementType: __private._cocos_core_data_utils_compact_value_type_array__ElementType, unit: __private._cocos_core_data_utils_compact_value_type_array__StorageUnit, arrayBuffer: ArrayBuffer, byteOffset: number, presumedByteOffset: number): CompactValueTypeArray;
        /**
         * Decompresses this CVTA.
         * @param arrayBuffer The buffer this CVTA stored in.
         */
        decompress<T>(arrayBuffer: ArrayBuffer): T[];
    }
    /**
     * Tag to visit editor extras of an object. Never be concerned about its value, please.
     */
    export const editorExtrasTag = "__editorExtras__";
    /**
     * Tag to define the custom deserialization method.
     * @internal
     */
    export const deserializeTag: unique symbol;
    /**
     * Tag to define the custom serialization method.
     * @internal
     */
    export const serializeTag: unique symbol;
    export interface SerializationInput {
        /**
         * Reads a property from the input.
         * @param name Property name.
         * @returns The property's value, after deserialized.
         */
        readProperty(name: string): unknown;
        /**
         * Deserializes this object according to the original procedure.
         */
        readThis(): void;
        /**
         * Deserializes super according to the original procedure.
         */
        readSuper(): void;
    }
    export interface SerializationOutput {
        /**
         * Writes a property into output.
         * @param name Property name.
         * @param value Property value.
         */
        writeProperty(name: string, value: unknown): void;
        /**
         * Serialize this object according to the original procedure.
         */
        writeThis(): void;
        /**
         * Serialize super according to the original procedure.
         */
        writeSuper(): void;
    }
    export type SerializationContext = {
        /**
         * The main serializing asset or root node in the scene/prefab passed to the serialization procedure.
         */
        root: unknown;
        /**
         * True if the serialization procedure is targeting CCON.
         */
        toCCON: boolean;
        /**
         * Customized arguments passed to serialization procedure.
         */
        customArguments: Record<PropertyKey, unknown>;
    };
    export interface CustomSerializable {
        [serializeTag](output: SerializationOutput, context: SerializationContext): void;
        [deserializeTag]?(input: SerializationInput, context: __private._cocos_core_data_custom_serializable__DeserializationContext): void;
    }
    /**
     * @internal DO NOT USE IT IN YOUR CODES.
     * @param constructor
     * @returns
     */
    export function getSerializationMetadata(constructor: Function): SerializationMetadata | undefined;
    /**
     * @internal For internal usage only. DO NOT USE IT IN YOUR CODES.
     */
    export interface SerializationMetadata {
        uniquelyReferenced?: boolean;
    }
    /**
     * @en
     * EventTarget is an object to which an event is dispatched when something has occurred.
     * [[Node]]s are the most common event targets, but other objects can be event targets too.
     * If a class cannot extend from EventTarget, it can consider using [[Eventify]].
     *
     * @zh
     * ¼ĿǾעɷ¼࣬[[Node]] ¼Ŀ꣬
     * ҲԼ̳¼ĿԻùɷ¼
     * ޷̳ EventTargetҲʹ [[Eventify]]
     */
    export const EventTarget: new (...args: any[]) => __private._cocos_core_event_event_target__Empty & __private._cocos_core_event_eventify__IEventified;
    export type EventTarget = InstanceType<typeof EventTarget>;
    /**
     * @en Generate a new class from the given base class, after polyfill all functionalities in [[IEventified]] as if it's extended from [[EventTarget]]
     * @zh һָ̳࣬Ļ࣬Ժ [[EventTarget]] ͬķʽʵ [[IEventified]] нӿڡ
     * @param base The base class
     * @example
     * ```ts
     * class Base { say() { console.log('Hello!'); } }
     * class MyClass extends Eventify(Base) { }
     * function (o: MyClass) {
     *     o.say(); // Ok: Extend from `Base`
     *     o.emit('sing', 'The ghost'); // Ok: `MyClass` implements IEventified
     * }
     * ```
     */
    export function Eventify<TBase>(base: __private._cocos_core_event_eventify__Constructor<TBase>): __private._cocos_core_event_eventify__Constructor<TBase & __private._cocos_core_event_eventify__IEventified>;
    /**
     * @zh
     * Async Delegate ֧첽صĴ½һ첽ע첽صȵӦʱ¼
     *
     * @en
     * Async Delegate is a delegate that supports asynchronous callbacks.
     * You can create a new AsyncDelegate, register the asynchronous callback, and wait until the corresponding time to dispatch the event.
     *
     * @example
     * ```ts
     * const ad = new AsyncDelegate();
     * ad.add(() => {
     *     return new Promise((resolve, reject) => {
     *        setTimeout(() => {
     *            console.log('hello world');
     *            resolve();
     *        }, 1000);
     *     })
     * });
     * await ad.dispatch();
     * ```
     */
    export class AsyncDelegate<T extends (...args: any) => (Promise<void> | void) = () => (Promise<void> | void)> {
        /**
         * @en
         * Add an async callback or sync callback.
         *
         * @zh
         * һ첽صͬص
         *
         * @param callback
         * @en The callback to add, and will be invoked when this delegate is dispatching.
         * @zh ҪӵĻصڸίеʱá
         */
        add(callback: T): void;
        /**
         * @zh
         * ѯǷעĳص
         * @en
         * Queries if a callback has been registered.
         *
         * @param callback @en The callback to query. @zh ҪѯĻص
         * @returns @en Whether the callback has been added. @zh ǷѾ˻ص
         */
        hasListener(callback: T): boolean;
        /**
         * @en
         * Remove the specific callback of this delegate.
         *
         * @zh
         * Ƴ˴ĳĻص
         *
         * @param callback @en The callback to remove. @zh ҪƳĳص
         */
        remove(callback: T): void;
        /**
         * @en
         * Dispatching the delegate event. This function will trigger all previously registered callbacks and does not guarantee execution order.
         *
         * @zh
         * ɷ¼˺ᴥ֮ǰעĻصҲִ֤˳
         *
         * @param args @en The parameters to be transferred to callback. @zh ݸصĲ
         * @returns @en The promise awaiting all async callback resolved. @zh ȴ첽ص Promise 
         */
        dispatch(...args: Parameters<T>): Promise<void[]>;
    }
    /**
     * @en Outputs a message at the "debug" log level.
     * @zh һԡ־ȼϢ
     * @param data @zh Ϣ @en The output message object.
     */
    export function debug(...data: unknown[]): void;
    /**
     * @en Outputs a log message to the console. The message may be a single string (with optional substitution values), or it may be any one or more JavaScript objects.
     * @zh ̨һ־ϢϢǵַѡַҲһ
     */
    export function log(...data: unknown[]): void;
    /**
     * @en
     * Outputs an error message to the console. The message may be a single string (with optional substitution values), or it may be any one or more JavaScript objects.
     * - In Cocos Creator, error is red.<br/>
     * - In Chrome, error have a red icon along with red message text.<br/>
     * @zh
     * ̨һϢϢǵַѡַҲһ
     * -  Cocos Creator УϢʾǺɫġ<br/>
     * -  Chrome УϢкɫͼԼɫϢı<br/>
     */
    export function error(...data: unknown[]): void;
    /**
     * @en
     * Outputs a warning message to the console. The message may be a single string (with optional substitution values), or it may be any one or more JavaScript objects.
     * - In Cocos Creator, warning is yellow.
     * - In Chrome, warning have a yellow warning icon with the message text.
     * @zh
     * ̨һϢϢǵַѡַҲһ
     * -  Cocos Creator УϢʾǻɫġ<br/>
     * -  Chrome УϢŻɫͼԼɫϢı<br/>
     */
    export function warn(...data: unknown[]): void;
    /**
     * @en
     * Assert the condition and output error messages if the condition is not true.
     * @zh
     * Լм飬Ϊ true Ϣ
     * @param condition @zh Ҫ @en The condition to check on.
     * @param message @zh Ҫ滻JavaScriptַ@en JavaScript objects to replace substitution strings in msg.
     * @param optionalParams  @zh 滻messageҪ滻JavaScript@en JavaScript objects with which to replace substitution strings within msg.
     * This gives you additional control over the format of the output.
     */
    export function assert(condition: boolean, message?: string, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): asserts condition;
    export function logID(id: number, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): void;
    export function errorID(id: number, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): void;
    export function warnID(id: number, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): void;
    export function assertID(condition: boolean, id: number, ...optionalParams: __private._cocos_core_platform_debug__StringSubstitution[]): void;
    /**
     * @en Returns whether or not to display the FPS and debug information.
     * @zh Ƿʾ FPS ϢͲֵϢ
     * @deprecated @zh v3.6ʼ֧֣ʹ profiler.isShowingStates@en Since v3.6, Please use profiler.isShowingStates instead.
     */
    export function isDisplayStats(): boolean;
    /**
     * @en Sets whether display the FPS and debug informations on the bottom-left corner.
     * @zh Ƿ½ʾ FPS Ͳֵԡ
     * @deprecated @zh v3.6ʼ֧֣ʹ profiler.showStats@en Since v3.6, Please use profiler.showStats instead.
     */
    export function setDisplayStats(displayStats: boolean): void;
    /**
     * @en Gets error message with the error id and possible parameters.
     * @zh ͨ error id ͱҪĲȡϢ
     * @param errorId @zh ID@en Error id.
     * @param param @zh ־@en Output log.
     */
    export function getError(errorId: number, ...param: __private._cocos_core_platform_debug__StringSubstitution[]): string;
    /**
     * @en Enum for debug modes.
     * @zh ģʽ
     */
    export enum DebugMode {
        /**
         * @en The debug mode none.
         * @zh ֹģʽֹʾκ־Ϣ
         */
        NONE = 0,
        /**
         * @en The debug mode none.
         * @zh ģʽʾ־Ϣ
         */
        VERBOSE = 1,
        /**
         * @en Information mode, which display messages with level higher than "information" level.
         * @zh ϢģʽʾϢϵ־Ϣ
         */
        INFO = 2,
        /**
         * @en Information mode, which display messages with level higher than "warning" level.
         * @zh ģʽʾ桱ϵ־Ϣ
         */
        WARN = 3,
        /**
         * @en Information mode, which display only messages with "error" level.
         * @zh ģʽʾ󡱼־Ϣ
         */
        ERROR = 4,
        /**
         * @en The debug mode info for web page.
         * @zh Ϣģʽ WEB ЧڻϢ
         */
        INFO_FOR_WEB_PAGE = 5,
        /**
         * @en The debug mode warn for web page.
         * @zh ģʽ WEB Чڻ warn ϵģ errorϢ
         */
        WARN_FOR_WEB_PAGE = 6,
        /**
         * @en The debug mode error for web page.
         * @zh ģʽ WEB Чڻ error Ϣ
         */
        ERROR_FOR_WEB_PAGE = 7
    }
    export const screen: Screen;
    /**
     * @en The screen API provides an easy way to do some screen managing stuff.
     * @zh screen ṩ򵥵ķĻصĹ
     */
    export class Screen {
        /**
         * @internal
         */
        init(): void;
        /**
         * @en the ratio of the resolution in physical pixels to the resolution in CSS pixels for the current display device
         * NOTE: For performance reasons, the engine will limit the maximum value of DPR on some platforms.
         * This property returns the DPR after the engine limit.
         * @zh ǰʾ豸طֱ CSS طֱ֮ȡ
         * ע⣺ܿǣһЩƽ̨ DPR ֵԷصƺ DPR
         */
        get devicePixelRatio(): number;
        /**
         * @en Get and set the size of current window in physical pixels.
         * NOTE:
         * - Setting window size is only supported on Web platform for now.
         * - On Web platform, if the ContainerStrategy is PROPORTIONAL_TO_FRAME, we set windowSize on game frame,
         *    and get windowSize from the game container after adaptation.
         * @zh ȡõǰڵسߴ硣
         * ע
         * - ôڳߴĿǰֻ Web ƽ̨֧֡
         * - Web ƽ̨ϣ ContainerStrategy Ϊ PROPORTIONAL_TO_FRAME,  windowSize  game frame, ֮ game container ߴȡ windowSize.
         */
        get windowSize(): math.Size;
        set windowSize(size: math.Size);
        /**
         * @en Get the current resolution of game.
         * This is a readonly property.
         * @zh ȡǰϷķֱʡ
         * һֻԡ
         *
         * @readonly
         */
        get resolution(): math.Size;
        /**
         * @en Whether it supports full screen.
         * @zh Ƿ֧ȫ
         * @returns {Boolean}
         */
        get supportsFullScreen(): boolean;
        /**
         * @en Return true if it's in full screen state now.
         * @zh ǰǷȫ״̬¡
         * @returns {boolean}
         */
        fullScreen(): boolean;
        /**
         * @en Request to enter full screen mode with the given element.
         * Many browsers forbid to enter full screen mode without an user intended interaction.
         * If failed to request fullscreen, another attempt will be made to request fullscreen the next time a user interaction occurs.
         * @zh ʹǰڵȫģʽܶ򴥷ΪһûصвŻЧ
         * ȫʧܣһûʱٴγԽȫ
         * @param element @zh ȫ״̬htmlԪء @en The element to request full screen state.
         * @param onFullScreenChange @zh ȫ״̬ıĻص @en callback function when full screen state changed.
         * @param onFullScreenError @zh ȫĻص @en callback function when full screen error.
         * @return {Promise|undefined}
         * @deprecated since v3.3, please use `screen.requestFullScreen(): Promise<void>` instead.
         */
        requestFullScreen(element: HTMLElement, onFullScreenChange?: (this: Document, ev: any) => any, onFullScreenError?: (this: Document, ev: any) => any): Promise<any> | undefined;
        /**
         * @en Request to enter full screen mode.
         * Many browsers forbid to enter full screen mode without an user intended interaction.
         * If failed to request fullscreen, another attempt will be made to request fullscreen the next time a user interaction occurs.
         * @zh ʹǰĻȫģʽܶ򴥷ΪһûصвŻЧ
         * ȫʧܣһûʱٴγԽȫ
         * @param element @zh ȫ״̬htmlԪء @en The element to request full screen state.
         * @param onFullScreenChange @zh ȫ״̬ıĻص @en callback function when full screen state changed.
         * @param onFullScreenError @zh ȫĻص @en callback function when full screen error.
         * @return {Promise}
         */
        requestFullScreen(): Promise<void>;
        /**
         * @en Exit the full mode.
         * @zh ˳ȫģʽ
         * @return {Promise}
         */
        exitFullScreen(): Promise<any>;
        /**
         * @en Automatically request full screen during the next touch/click event.
         * @zh Զ¼һ¼ʱԽȫģʽ
         * @param element @zh ȫ״̬htmlԪء @en The element to request full screen state.
         * @param onFullScreenChange @zh ȫ״̬ıĻص @en callback function when full screen state changed.
         *
         * @deprecated since v3.3, please use screen.requestFullScreen() instead.
         */
        autoFullScreen(element: HTMLElement, onFullScreenChange: (this: Document, ev: any) => any): void;
        /**
         * @param element
         * @deprecated since v3.3
         */
        disableAutoFullScreen(element: any): void;
        /**
         * @en
         * Register screen event callback.
         * @zh
         * עscreen¼ص
         */
        on(type: __private._pal_screen_adapter_enum_type_screen_event__PalScreenEvent, callback: (...args: any) => void, target?: any): void;
        /**
         * @en
         * Register a callback of a specific screen event type once.
         * @zh
         * עᵥεscreen¼ص
         */
        once(type: __private._pal_screen_adapter_enum_type_screen_event__PalScreenEvent, callback: (...args: any) => void, target?: any): void;
        /**
         * @en
         * Unregister screen event callback.
         * @zh
         * ȡעscreen¼ص
         */
        off(type: __private._pal_screen_adapter_enum_type_screen_event__PalScreenEvent, callback?: (...args: any) => void, target?: any): void;
    }
    /**
     * @en A set of system related variables.
     * @zh һϵϵͳػ
     */
    export const sys: {
        Feature: typeof __private._pal_system_info_enum_type_feature__Feature;
        /**
         * @en
         * Returns if the specified platform related feature is supported.
         * @zh
         * ָƽ̨صǷ֧֡
         * @param feature @zh ϵͳԡ @en Feature of the system.
         */
        hasFeature(feature: sys.Feature): boolean;
        /**
         * @en
         * Network type enumeration.
         * @zh
         * ö١
         */
        NetworkType: typeof __private._pal_system_info_enum_type_network_type__NetworkType;
        /**
         * @en
         * LanguageCode type enumeration.
         * @zh
         * ö١
         */
        Language: typeof __private._pal_system_info_enum_type_language__Language;
        /**
         * @en
         * OS type enumeration.
         * @zh
         * ϵͳö١
         */
        OS: typeof __private._pal_system_info_enum_type_operating_system__OS;
        /**
         * @en
         * Platform type enumeration.
         * @zh
         * ƽ̨ö١
         */
        Platform: typeof __private._pal_system_info_enum_type_platform__Platform;
        /**
         * @en
         * Browser type enumeration.
         * @zh
         * ö١
         */
        BrowserType: typeof __private._pal_system_info_enum_type_browser_type__BrowserType;
        /**
         * @en Whether the running platform is native app.
         * @zh ָʾƽ̨Ƿԭƽ̨
         */
        isNative: boolean;
        /**
         * @en Whether the running platform is browser.
         * @zh ָʾƽ̨Ƿ
         */
        isBrowser: boolean;
        /**
         * @en Indicate whether the current running context is a mobile system.
         * @zh ָʾǰƽ̨Ƿƶƽ̨
         */
        isMobile: boolean;
        /**
         * @en Whether the endianness of current platform is little endian.
         * @zh ǰƽֽ̨˳ǷС
         */
        isLittleEndian: boolean;
        /**
         * @en The running platform.
         * @zh ǰƽ̨򻷾
         */
        platform: __private._pal_system_info_enum_type_platform__Platform;
        /**
         * @en Indicate the current language of the running system.
         * @zh ָʾǰлԡ
         */
        language: __private._pal_system_info_enum_type_language__Language;
        /**
         * @en
         * Get current language iso 639-1 code.
         * Examples of valid language codes include "zh-tw", "en", "en-us", "fr", "fr-fr", "es-es", etc.
         * The actual value totally depends on results provided by destination platform.
         * @zh
         * ָʾǰл
         * ȡǰiso 639-1롣
         * ЧԴ "zh-tw""en""en-us""fr""fr-fr""es-es "ȡ
         * ʵֵȫȡĿĵƽ̨ṩĽ
         */
        languageCode: string;
        /**
         * @en Indicate the running os name.
         * @zh ָʾǰϵͳ
         */
        os: __private._pal_system_info_enum_type_operating_system__OS;
        /**
         * @en Indicate the running os version string.
         * @zh ָʾǰϵͳ汾ַ
         */
        osVersion: string;
        /**
         * @en Indicate the running os main version.
         * @zh ָʾǰϵͳ汾
         */
        osMainVersion: number;
        /**
         * @en Indicate the running browser type.
         * @zh ָʾǰе͡
         */
        browserType: __private._pal_system_info_enum_type_browser_type__BrowserType;
        /**
         * @en Indicate the running browser version.
         * @zh ָʾǰе汾
         */
        browserVersion: string;
        /**
         * @en Whether the running platform is xr app.
         * @zh ָʾƽ̨ǷXRƽ̨
         */
        isXR: boolean;
        /**
         * @en Indicate the real pixel resolution of the whole game window.
         * @zh ָʾϷڵطֱʡ
         *
         * @deprecated since v3.4.0, please use screen.windowSize instead.
         */
        windowPixelResolution: math.Size;
        /**
         * @en The capabilities of the current platform.
         * @zh ǰƽ̨Ĺܿԡ
         *
         * @deprecated since v3.4.0, please use sys.hasFeature() instead.
         */
        capabilities: {
            canvas: boolean;
            opengl: boolean;
            webp: boolean;
            imageBitmap: boolean;
            touches: boolean;
            mouse: boolean;
            keyboard: boolean;
            accelerometer: boolean;
        };
        /**
         * @en It is a local storage component based on HTML5 localStorage API, on web platform, it's equal to window.localStorage.
         * @zh HTML5 ׼е localStorage ıش洢ܣ Web ˵ȼ window.localStorage
         */
        localStorage: any;
        /**
         * @en Get the network type of current device, return `sys.NetworkType.LAN` if failure.
         * @zh ȡǰ豸, ޷ȡĬϽ `sys.NetworkType.LAN`
         * @return @zh  LAN  WWAN @en LAN or WWAN.
         */
        getNetworkType(): __private._pal_system_info_enum_type_network_type__NetworkType;
        /**
         * @en Get the battery level of current device, return 1.0 if failure.
         * @zh ȡǰ豸ĵص޷ȡĬϽ 1
         * @return - 0.0 ~ 1.0
         */
        getBatteryLevel(): number;
        /**
         * @en Forces the garbage collection, only available in native platforms.
         * @zh ǿƽ JS ڴգԭƽ̨Ч
         */
        garbageCollect(): void;
        /**
         * @en Check whether an object is valid,
         * In web engine, it will return true if the object exist
         * In native engine, it will return true if the JS object and the correspond native object are both valid
         * @zh һǷǿջԭƽ̨Ч
         *  Web ƽֻ̨Ҫǿջ Undefined ͻ᷵ trueԭƽ̨ǻ鵱ǰ JS 󶨵ԭǷЧ
         * @param obj @zh УĶ@en The object to be checked.
         */
        isObjectValid(obj: any): boolean;
        /**
         * @en Dump systemInfo informations.
         * @zh ڿ̨ӡǰҪϵͳϢ
         */
        dump(): void;
        /**
         * @en Try to open a url in browser, may not work in some platforms.
         * @zh Դһ web ҳ棬ƽ̨Ч
         * @param url @zh ʵӡ @en Visited links.
         */
        openURL(url: string): void;
        /**
         * @en Get the current time in milliseconds.
         * @zh ȡǰʱ䣨Ϊλ
         */
        now(): number;
        /**
         * @en Restart the JS VM, only available in native platforms.
         * @zh JSԭƽ̨Ч
         * @private
         */
        restartVM(): void;
        /**
         * @en
         * Returns the safe area of the screen (in design resolution) based on the game view coordinate system.
         * If the screen is not notched, this method returns a Rect of the same size as visibleSize by default.
         * Currently supports Android, iOS and WeChat, ByteDance Mini Game platform.
         * @zh
         * ػϷͼϵֻĻȫƷֱΪλĬϷһ visibleSize һ Rect
         * Ŀǰְ֧׿iOS ԭƽ̨΢šֽСϷƽ̨
         * @method getSafeAreaRect
         * @return {Rect}
         */
        getSafeAreaRect(): math.Rect;
    };
    export namespace sys {
        /**
         * @en
         * Platform related feature enum type.
         * @zh
         * ƽ̨صö͡
         */
        export type Feature = __private.__types_globals__EnumAlias<typeof __private._pal_system_info_enum_type_feature__Feature>;
    }
    export interface ISchedulable {
        id?: string;
        uuid?: string;
        update?(dt: number): void;
    }
    /**
     * @en
     * Scheduler is responsible of triggering the scheduled callbacks.<br>
     * You should not use NSTimer. Instead use this class.<br>
     * <br>
     * There are 2 different types of callbacks (selectors):<br>
     *     - update callback: the 'update' callback will be called every frame. You can customize the priority.<br>
     *     - custom callback: A custom callback will be called every frame, or with a custom interval of time.<br>
     * <br>
     * The 'custom selectors' should be avoided when possible. It is faster,<br>
     * and consumes less memory to use the 'update callback'. *
     * @zh
     * Scheduler Ǹ𴥷صࡣ<br>
     * ͨ£ʹ `director.getScheduler()` ȡϵͳʱ<br>
     * ֲͬ͵Ķʱ<br>
     *     - update ʱÿһ֡ᴥԶȼ<br>
     *     - Զ嶨ʱԶ嶨ʱÿһ֡Զʱ<br>
     * ϣÿ֡Ӧʹ update ʱʹ update ʱ죬ĸٵڴ档
     */
    export class Scheduler extends System {
        static ID: string;
        /**
         * @en This method should be called for any target which needs to schedule tasks, and this method should be called before any scheduler API usage.
         * This method will add a `id` property if it doesn't exist.
         * @zh κҪ Scheduler Ķ嶼ӦõӦڵκ Scheduler API ֮ǰ
         * һ `id` ԣԲڵĻ
         * @param target
         * @en The target to enable, which type is ISchedulable.
         * @zh õĶΪISchedulable
         */
        static enableForTarget(target: ISchedulable): void;
        constructor();
        /**
         * @en
         * Modifies the time of all scheduled callbacks.<br>
         * You can use this property to create a 'slow motion' or 'fast forward' effect.<br>
         * Default is 1.0. To create a 'slow motion' effect, use values below 1.0.<br>
         * To create a 'fast forward' effect, use values higher than 1.0.<br>
         * NoteIt will affect EVERY scheduled selector / action.
         * @zh
         * ʱű<br>
         * ʹһ slow motion  fast forward Ч<br>
         * Ĭ 1.0Ҫһ slow motion Ч,ʹֵ 1.0<br>
         * Ҫʹ fast forward Чʹֵ 1.0<br>
         * ע⣺Ӱ Scheduler ¹жʱ
         * @param timeScale
         */
        setTimeScale(timeScale: number): void;
        /**
         * @en Returns time scale of scheduler.
         * @zh ȡʱű
         */
        getTimeScale(): number;
        /**
         * @en 'update' the scheduler. (You should NEVER call this method, unless you know what you are doing.)
         * @zh update Ⱥ(Ӧֱӵȫ˽ôĽ)
         * @param dt
         * @en delta time. The unit is seconds.
         * @zh ¼ʱ, λ롣
         */
        update(dt: number): void;
        /**
         * @en Specify the callback to schedule a new timer.
         * If the callback function is already scheduled, then only the interval parameter will be updated without re-scheduling it again.
         * @zh ָص滮һµĶʱ
         * صѾʱʹãôֻ֮ǰʱʱµĶʱ
         * @param callback
         * @en The specified target.
         * @zh ָĵö
         * @param target
         * @en The scheduled method will be called every 'interval' seconds.
         * If 'interval' is 0, it will be called every frame, but if so, it recommended to use 'scheduleUpdateForTarget:' instead.
         * @zh ʱﵽֵָʱõĻصᱻá
         *  interval ֵΪ 0ôصÿһ֡ᱻãʹ scheduleUpdateForTarget 档
         * @param interval
         * @en repeat let the action be repeated repeat + 1 times, use `macro.REPEAT_FOREVER` to let the action run continuously.
         * @zh repeat ֵöʱ repeat + 1 Σʹ `macro.REPEAT_FOREVER` öʱһֱѭ
         * @param repeat
         * @en delay is the amount of time the action will wait before it'll start. Unit: s.
         * @zh delay ֵָӳʱ䣬ʱӳָʱ֮ʼʱλ: 롣
         * @param delay
         * @en If paused is YES, then it won't be called until it is resumed.
         * @zh  paused ֵΪ trueôֱ resume òſʼʱ
         * @param paused
         */
        schedule(callback: __private._cocos_core_scheduler__CallbackType, target: ISchedulable, interval: number, repeat?: number, delay?: number, paused?: boolean): void;
        /**
         * @en The specified target.
         * @zh ָĵö
         * @param target
         * @en Specify the callback to schedule a new timer.
         * If the callback function is already scheduled, then only the interval parameter will be updated without re-scheduling it again.
         * @zh ָص滮һµĶʱ
         * صѾʱʹãôֻ֮ǰʱʱµĶʱ
         * @param callback
         * @en The scheduled method will be called every 'interval' seconds.
         * If 'interval' is 0, it will be called every frame, but if so, it recommended to use 'scheduleUpdateForTarget:' instead.
         * @zh ʱﵽֵָʱõĻصᱻá
         *  interval ֵΪ 0ôصÿһ֡ᱻãʹ scheduleUpdateForTarget 档
         * @param interval
         * @en repeat let the action be repeated repeat + 1 times, use `macro.REPEAT_FOREVER` to let the action run continuously.
         * @zh repeat ֵöʱ repeat + 1 Σʹ `macro.REPEAT_FOREVER` öʱһֱѭ
         * @param repeat
         * @en delay is the amount of time the action will wait before it'll start. Unit: s.
         * @zh delay ֵָӳʱ䣬ʱӳָʱ֮ʼʱλ: 롣
         * @param delay
         * @en If paused is YES, then it won't be called until it is resumed.
         * @zh  paused ֵΪ trueôֱ resume òſʼʱ
         * @param paused
         *
         * @deprecated since v3.8.0, please use `Scheduler.schedule(callback, target, interval)` instead.
         */
        schedule(target: ISchedulable, callback: __private._cocos_core_scheduler__CallbackType, interval: number, repeat?: number, delay?: number, paused?: boolean): void;
        /**
         * @en
         * Schedules the update callback for a given target,
         * During every frame after schedule started, the "update" function of target will be invoked.
         * @zh
         * ʹָȼΪָĶ update ʱ<br>
         * update ʱÿһ֡ᱻʱԶָ "update" <br>
         * ȼֵԽͣʱԽ硣
         * @param target
         * @en The target bound to the callback. @zh ص󶨵Ŀ
         * @param priority
         * @en The priority. @zh ȼ
         * @param paused
         * @en Whether is paused. @zh Ƿͣ
         */
        scheduleUpdate(target: ISchedulable, priority: number, paused: boolean): void;
        /**
         * @en
         * Unschedule a callback for a callback and a given target.
         * If you want to unschedule the "update", use `unscheduleUpdate()`
         * @zh
         * ȡָʱ
         * Ҫȡ update ʱʹ unscheduleUpdate()
         * @param callback @en The callback to be unscheduled @zh ȡȵĻص
         * @param target @en The target bound to the callback. @zh ص󶨵Ŀ
         */
        unschedule(callback: __private.__types_globals__AnyFunction, target: ISchedulable): void;
        /**
         * @en Unschedule the update callback for a given target.
         * @zh ȡָ update ʱ
         * @param target The target to be unscheduled.
         */
        unscheduleUpdate(target: ISchedulable): void;
        /**
         * @en
         * Unschedule all scheduled callbacks for a given target.
         * This also includes the "update" callback.
         * @zh ȡָжʱ update ʱ
         * @param target The target to be unscheduled.
         */
        unscheduleAllForTarget(target: ISchedulable): void;
        /**
         * @en
         * Unschedule all scheduled callbacks from all targets including the system callbacks.
         * You should NEVER call this method, unless you know what you are doing.
         * @zh
         * ȡжжʱϵͳʱ
         * Ҫô˺ȷʲô
         */
        unscheduleAll(): void;
        /**
         * @en
         * Unschedule all callbacks from all targets with a minimum priority.
         * You should only call this with `PRIORITY_NON_SYSTEM_MIN` or higher.
         * @zh
         * ȡȼֵָȼĶʱ
         * Ӧֻȡȼֵ PRIORITY_NON_SYSTEM_MIN Ķʱ
         * @param minPriority
         * @en The minimum priority of selector to be unscheduled.
         * Which means, all selectors which priority is higher than minPriority will be unscheduled.
         * @zh Ҫȡȵѡȼ
         * ζţȼ minPriority ѡȡȡ
         */
        unscheduleAllWithMinPriority(minPriority: number): void;
        /**
         * @en Checks whether a callback for a given target is scheduled.
         * @zh ָĻصͻصǷڶʱ
         * @param callback @en The callback to check. @zh ָĻص
         * @param target @en The target of the callback. @zh صĿ
         * @returns @en True if the specified callback is invoked, false if not. @zh trueָص, 򷵻false
         */
        isScheduled(callback: __private.__types_globals__AnyFunction, target: ISchedulable): boolean;
        /**
         * @en
         * Pause all selectors from all targets.
         * You should NEVER call this method, unless you know what you are doing.
         * @zh
         * ͣжжʱ
         * Ҫ֪ʲô
         */
        pauseAllTargets(): ISchedulable[];
        /**
         * @en
         * Pause all selectors from all targets with a minimum priority.
         * You should only call this with kCCPriorityNonSystemMin or higher.
         * @zh
         * ͣȼֵָȼĶʱ
         * Ӧֻͣȼֵ PRIORITY_NON_SYSTEM_MIN Ķʱ
         * @param minPriority @en the minimum priority. @zn Сȼ
         */
        pauseAllTargetsWithMinPriority(minPriority: number): ISchedulable[];
        /**
         * @en
         * Resume selectors on a set of targets.<br/>
         * This can be useful for undoing a call to pauseAllCallbacks.
         * @zh
         * ָָжĶʱ<br/>
         *  pauseAllCallbacks 
         * @param targetsToResume
         */
        resumeTargets(targetsToResume: ISchedulable[]): void;
        /**
         * @en
         * Pauses the target.<br/>
         * All scheduled selectors/update for a given target won't be 'ticked' until the target is resumed.<br/>
         * If the target is not present, nothing happens.
         * @zh
         * ָͣĶʱ<br/>
         * ָжʱᱻͣ<br/>
         * ָĶûжʱʲôҲᷢ
         * @param target
         */
        pauseTarget(target: ISchedulable): void;
        /**
         * @en
         * Resumes the target.<br/>
         * The 'target' will be unpaused, so all schedule selectors/update will be 'ticked' again.<br/>
         * If the target is not present, nothing happens.
         * @zh
         * ָָжʱ<br/>
         * ָжʱ<br/>
         * ָĶûжʱʲôҲᷢ
         * @param target
         */
        resumeTarget(target: ISchedulable): void;
        /**
         * @en Returns whether or not the target is paused.
         * @zh ָĶʱǷͣ״̬
         * @param target
         */
        isTargetPaused(target: ISchedulable): boolean;
    }
    /**
     * @en
     * Real curve.
     *
     * The real curve is a kind of keyframe curve.
     * When evaluating a real curve:
     * - If the input is just the time of a keyframe,
     *   keyframe value's numeric value is used as result.
     * - Otherwise, if the input is less than the time of the first keyframe or
     *   is greater than the time of the last keyframe time, it performs so-called extrapolation.
     * - Otherwise, the input falls between two keyframes and then it interpolates between the two keyframes.
     *
     * Every keyframe may specify an interpolation mode
     * to indicates how to perform the interpolation
     * from current keyframe to next keyframe.
     * Interpolation modes of keyframes may differ from each other.
     *
     * Real curve allows three interpolation modes: constant, linear and cubic.
     * The constant and linear mode is easy.
     * In case of cubic interpolation,
     * the interpolation algorithm is effectively equivalent to cubic bezier(or cubic hermite) interpolation.
     *
     * Related quantities related to cubic interpolation are:
     * - Keyframe times and numeric values.
     * - The tangent and tangent weight of the previous keyframe and next keyframe.
     *
     * While performing the cubic bezier interpolation,
     * The first control point is calculated from right tangent and right tangent weight of previous keyframe,
     * the second control point is calculated from left tangent and left tangent weight of next keyframe.
     *
     * In equivalent bezier representation,
     * the tangent is the line slope between sample point and control point
     * and the tangent weight is the distance between sample point and control point.
     * The tangent weight on either side can be marked as "not specified" through tangent weight mode.
     * If either side weight is not specified,
     * the tangent weight is treated at `sqrt(d_t^2 + (d_t * tangent)^2) * (1 / 3)`
     * where `d_t` is the difference between two keyframes 's time and `tangent` is the tangent of that side.
     *
     * Note, in some cases, tangent/tangent weight/tangent weight mode may be "meaningless".
     * The meaningless means that value can may not be stored(or serialized).
     * @zh
     * ʵߡ
     *
     * ʵǹؼ֡ߵһ֡
     * ֵʵʱ
     * - þǹؼ֡ϵʱ䣬ؼ֡ϵֵΪ
     * - Сڵһؼ֡ϵʱһؼ֡ϵʱ䣬νơ
     * - ֮֡䣬ֵͨ֡õ
     *
     * ÿؼֵָ֡ģʽ
     * Աʾӵǰֵ֡仯һֵ֡õĲֵ㷨
     * ÿؼ֡ĲֵģʽǸͬġ
     *
     * ʵֲֵģʽԺηģҲ
     * ģʽȽϼ򵥡
     * βֵ£ֵ㷨ʵϵȼαΰأֵ
     *
     * βֵУ
     * - ؼ֡ϵʱֵ
     * - ǰһؼ֡ͺһؼ֡ϵߺȨء
     *
     * ֮֡αֵ߲ʱ
     * ȡǰһ֡ߡȨһƵ㣬
     * ȡһ֡ߡȨڶƵ㡣
     *
     * ڵЧıʾУ
     * ߾ͿƵ֮бʣȨؾͿƵ֮ľ롣
     * һ˵ȨضͨȨģʽΪδָġ
     * һ˵Ȩδָģ
     * ˶ϵȨؽΪ `sqrt(d_t^2 + (d_t * tangent)^2) * (1 / 3)`У
     * `d_t` ֡ʱĲ`tangent` Ǵ˶ϵߡ
     *
     * ע⣬/Ȩ/ȨģʽĳЩ¿ǡġ
     * ζЩֵܲᱻ洢л
     */
    export class RealCurve extends __private._cocos_core_curves_keyframe_curve__KeyframeCurve<RealKeyframeValue> {
        /**
         * @en
         * Gets or sets the pre-extrapolation-mode of this curve.
         * Defaults to `ExtrapolationMode.CLAMP`.
         * @zh
         * ȡôߵǰģʽ
         * ĬΪ `ExtrapolationMode.CLAMP`
         */
        preExtrapolation: ExtrapolationMode;
        /**
         * @en
         * Gets or sets the post-extrapolation-mode of this curve.
         * Defaults to `ExtrapolationMode.CLAMP`.
         * @zh
         * ȡôߵĺģʽ
         * ĬΪ `ExtrapolationMode.CLAMP`
         */
        postExtrapolation: ExtrapolationMode;
        /**
         * @en
         * Evaluates this curve at specified time.
         * @zh
         * ָʱϵֵ
         * @param time Input time.
         * @returns Result value.
         */
        evaluate(time: number): number;
        /**
         * @en
         * Adds a keyframe into this curve.
         * @zh
         * һؼ֡ߡ
         * @param time Time of the keyframe.
         * @param value Value of the keyframe.
         * @returns The index to the new keyframe.
         */
        addKeyFrame(time: number, value: __private._cocos_core_curves_curve__RealKeyframeValueParameters): number;
        /**
         * @en
         * Assigns all keyframes.
         * @zh
         * ֵйؼ֡
         * @param keyframes An iterable to keyframes. The keyframes should be sorted by their time.
         */
        assignSorted(keyframes: Iterable<[
            number,
            __private._cocos_core_curves_curve__RealKeyframeValueParameters
        ]>): void;
        /**
         * Assigns all keyframes.
         * @param times Times array. Should be sorted.
         * @param values Values array. Corresponding to each time in `times`.
         */
        assignSorted(times: readonly number[], values: __private._cocos_core_curves_curve__RealKeyframeValueParameters[]): void;
        /**
         * @en
         * Returns if this curve is constant.
         * @zh
         * شǷǳߡ
         * @param tolerance The tolerance.
         * @returns Whether it is constant.
         */
        isConstant(tolerance: number): boolean;
        /**
         * @internal
         */
        [serializeTag](output: SerializationOutput, context: SerializationContext): void;
        /**
         * @internal
         */
        [deserializeTag](input: SerializationInput, context: __private._cocos_core_data_custom_serializable__DeserializationContext): void;
    }
    /**
     * @en
     * The method used for interpolation method between value of a keyframe and its next keyframe.
     * @zh
     * ĳؼ֡ǰһ֡һֵ֮֡ʱʹõĲֵʽ
     */
    export enum RealInterpolationMode {
        /**
         * @en
         * Perform linear interpolation between previous keyframe value and next keyframe value.
         * @zh
         * ǰһ֡ͺһִ֮֡Բֵ
         */
        LINEAR = 0,
        /**
         * @en
         * Always use the value from this keyframe.
         * @zh
         * Զʹǰһֵ֡
         */
        CONSTANT = 1,
        /**
         * @en
         * Perform cubic(hermite) interpolation between previous keyframe value and next keyframe value.
         * @zh
         * ǰһ֡ͺһִֵ֮֡
         */
        CUBIC = 2
    }
    /**
     * @en
     * Specifies how to extrapolate the value
     * if input time is underflow(less than the the first frame time) or
     * overflow(greater than the last frame time) when evaluating an curve.
     * @zh
     * ֵʱָʱ磨Сڵһ֡ʱ䣩磨һ֡ʱ䣩ʱӦƶϽֵ
     */
    export enum ExtrapolationMode {
        /**
         * @en
         * Compute the result
         * according to the first two frame's linear trend in the case of underflow and
         * according to the last two frame's linear trend in the case of overflow.
         * If there are less than two frames, fallback to `CLAMP`.
         * @zh
         * ʱǰ֡Ƽʱ֡Ƽ
         * ֡С 2˵  `CLAMP`
         */
        LINEAR = 0,
        /**
         * @en
         * Use first frame's value in the case of underflow,
         * use last frame's value in the case of overflow.
         * @zh
         * ʱʹõһֵ֡ʱʹһֵ֡
         */
        CLAMP = 1,
        /**
         * @en
         * Computes the result as if the curve is infinitely and continuously looped.
         * @zh
         * ֵʱѭġ
         */
        LOOP = 2,
        /**
         * @en
         * Computes the result as if the curve is infinitely and continuously looped in a ping-pong manner.
         * @zh
         * ֵʱԡƹҡʽѭġ
         */
        PING_PONG = 3
    }
    /**
     * @en
     * Specifies both side tangent weight mode of a keyframe value.
     * @zh
     * ָؼ֡Ȩģʽ
     */
    export enum TangentWeightMode {
        /**
         * @en
         * Neither side of the keyframe carries tangent weight information.
         * @zh
         * ؼ֡඼ЯȨϢ
         */
        NONE = 0,
        /**
         * @en
         * Only left side of the keyframe carries tangent weight information.
         * @zh
         * ؼ֡ЯȨϢ
         */
        LEFT = 1,
        /**
         * @en
         * Only right side of the keyframe carries tangent weight information.
         * @zh
         * ؼ֡ҲЯȨϢ
         */
        RIGHT = 2,
        /**
         * @en
         * Both sides of the keyframe carries tangent weight information.
         * @zh
         * ؼ֡඼ЯȨϢ
         */
        BOTH = 3
    }
    /**
     * @en View to a real frame value.
     * Note, the view may be invalidated due to keyframe change/add/remove.
     * @zh ʵֵ֡ͼ
     * ע⣬ͼؼ֡ӡı䡢ƳʧЧ
     */
    export class RealKeyframeValue extends __private._cocos_core_data_editor_extendable__EditorExtendable {
        /**
         * @en
         * When perform interpolation, the interpolation method should be taken
         * when for this keyframe is used as starting keyframe.
         * @zh
         * ִвֵʱԴ˹ؼ֡Ϊʼؼ֡ʱӦʹõĲֵʽ
         */
        get interpolationMode(): RealInterpolationMode;
        set interpolationMode(value: RealInterpolationMode);
        /**
         * @en
         * Tangent weight mode when perform cubic interpolation
         * This field is regarded if current interpolation mode is not cubic.
         * @zh
         * ִβֵʱ˹ؼ֡ʹõȨģʽ
         * ǰĲֵģʽβֵʱֶ塣
         */
        get tangentWeightMode(): TangentWeightMode;
        set tangentWeightMode(value: TangentWeightMode);
        /**
         * @en
         * Value of the keyframe.
         * @zh
         * ùؼֵ֡
         */
        value: number;
        /**
         * @en
         * The tangent of this keyframe
         * when it's used as starting point during cubic interpolation.
         * Regarded otherwise.
         * @zh
         * ˹ؼ֡Ϊβֵʼʱ˹ؼ֡ߡ¸ֶ塣
         */
        rightTangent: number;
        /**
         * @en
         * The tangent weight of this keyframe
         * when it's used as starting point during weighted cubic interpolation.
         * Regarded otherwise.
         * @zh
         * ˹ؼ֡Ϊβֵʼʱ˹ؼ֡Ȩء¸ֶ塣
         */
        rightTangentWeight: number;
        /**
         * @en
         * The tangent of this keyframe
         * when it's used as ending point during cubic interpolation.
         * Regarded otherwise.
         * @zh
         * ˹ؼ֡ΪβֵĿʱ˹ؼ֡ߡ¸ֶ塣
         */
        leftTangent: number;
        /**
         * @en
         * The tangent weight of this keyframe
         * when it's used as ending point during weighted cubic interpolation.
         * Regarded otherwise.
         * @zh
         * ˹ؼ֡ΪβֵĿʱ˹ؼ֡Ȩء¸ֶ塣
         */
        leftTangentWeight: number;
        /**
         * @deprecated Reserved for backward compatibility. Will be removed in future.
         */
        get easingMethod(): __private._cocos_core_curves_easing_method__EasingMethod;
        set easingMethod(value: __private._cocos_core_curves_easing_method__EasingMethod);
    }
    /**
     * @en
     * Quaternion curve.
     * @zh
     * Ԫ
     */
    export class QuatCurve extends __private._cocos_core_curves_keyframe_curve__KeyframeCurve<QuatKeyframeValue> {
        /**
         * @en
         * Gets or sets the pre-extrapolation-mode of this curve.
         * Defaults to `ExtrapolationMode.CLAMP`.
         * @zh
         * ȡôߵǰģʽ
         * ĬΪ `ExtrapolationMode.CLAMP`
         */
        preExtrapolation: ExtrapolationMode;
        /**
         * @en
         * Gets or sets the post-extrapolation-mode of this curve.
         * Defaults to `ExtrapolationMode.CLAMP`.
         * @zh
         * ȡôߵĺģʽ
         * ĬΪ `ExtrapolationMode.CLAMP`
         */
        postExtrapolation: ExtrapolationMode;
        /**
         * @en
         * Evaluates this curve at specified time.
         * @zh
         * ָʱϵֵ
         * @param time Input time.
         * @param quat If specified, this value will be filled and returned.
         * Otherwise a new quaternion object will be filled and returned.
         * @returns Result value.
         */
        evaluate(time: number, quat?: math.Quat): math.Quat;
        /**
         * Adds a keyframe into this curve.
         * @param time Time of the keyframe.
         * @param value Value of the keyframe.
         * @returns The index to the new keyframe.
         */
        addKeyFrame(time: number, value: __private._cocos_core_curves_quat_curve__QuatKeyframeValueParameters): number;
        /**
         * Assigns all keyframes.
         * @param keyframes An iterable to keyframes. The keyframes should be sorted by their time.
         */
        assignSorted(keyframes: Iterable<[
            number,
            __private._cocos_core_curves_quat_curve__QuatKeyframeValueParameters
        ]>): void;
        /**
         * Assigns all keyframes.
         * @param times Times array. Should be sorted.
         * @param values Values array. Corresponding to each time in `times`.
         */
        assignSorted(times: readonly number[], values: __private._cocos_core_curves_quat_curve__QuatKeyframeValueParameters[]): void;
        /**
         * @internal
         */
        [serializeTag](output: SerializationOutput, context: SerializationContext): void;
        /**
         * @internal
         */
        [deserializeTag](input: SerializationInput, context: __private._cocos_core_data_custom_serializable__DeserializationContext): void;
    }
    /**
     * @en
     * The method used for interpolation between values of a quaternion keyframe and its next keyframe.
     * @zh
     * ĳԪؼ֡ǰһ֡һֵ֮֡ʱʹõĲֵʽ
     */
    export enum QuatInterpolationMode {
        /**
         * @en
         * Perform spherical linear interpolation between previous keyframe value and next keyframe value.
         * @zh
         * ǰһ֡ͺһִ֮֡Բֵ
         */
        SLERP = 0,
        /**
         * @en
         * Always use the value from this keyframe.
         * @zh
         * Զʹǰһֵ֡
         */
        CONSTANT = 1
    }
    /**
     * View to a quaternion frame value.
     * Note, the view may be invalidated due to keyframe change/add/remove.
     */
    export class QuatKeyframeValue {
        /**
         * @en
         * When perform interpolation, the interpolation method should be taken
         * when for this keyframe is used as starting keyframe.
         * @zh
         * ִвֵʱԴ˹ؼ֡Ϊʼؼ֡ʱӦʹõĲֵʽ
         */
        interpolationMode: QuatInterpolationMode;
        /**
         * @en
         * Value of the keyframe.
         * @zh
         * ùؼֵ֡
         */
        value: math.IQuatLike;
        /**
         * @internal Reserved for backward compatibility. Will be removed in future.
         */
        easingMethod: __private._cocos_core_curves_easing_method__EasingMethod | [
            number,
            number,
            number,
            number
        ];
        constructor({ value, interpolationMode, easingMethod, }?: Partial<QuatKeyframeValue>);
    }
    export class ObjectCurve<T> extends __private._cocos_core_curves_keyframe_curve__KeyframeCurve<ObjectCurveKeyframe<T>> {
        evaluate(time: number): T;
    }
    export type ObjectCurveKeyframe<T> = T;
    export class ColorKey {
        /**
         * @en Color value.
         * @zh ɫֵ
         */
        color: math.Color;
        /**
         * @en Time value.
         * @zh ʱֵ
         */
        time: number;
    }
    export class AlphaKey {
        /**
         * @en Alpha value.
         * @zh ͸ȡ
         */
        alpha: number;
        /**
         * @en Time.
         * @zh ʱ֡
         */
        time: number;
    }
    /**
     * @en Gradient is a component that has a lot of color keys and alpha keys to get the interpolated color value.
     * @zh ߿ؼɫؼ֡͸ȹؼ֡ڹؼ֡нвֵ䷵յɫֵ
     */
    export class Gradient {
        /**
         * @en
         * There are 2 kind of mode:
         * Blend just interpolate the nearest 2 colors from keys.
         * Fixed get the nearest color from keys without interpolate.
         * @zh
         * ؼȡɫģʽ
         * ģʽȡɫ֡вֵ㡣
         * ̶ģʽֱȡɫ֡أвֵ
         */
        static Mode: {
            Blend: number;
            Fixed: number;
        };
        /**
         * @en Array of color key.
         * @zh ɫؼ֡б
         */
        colorKeys: ColorKey[];
        /**
         * @en Array of alpha key.
         * @zh ͸ȹؼ֡б
         */
        alphaKeys: AlphaKey[];
        /**
         * @en Blend mode.
         * @zh ģʽ
         */
        mode: number;
        /**
         * @en Set color keys array and alpha keys array.
         * @zh ɫ͸ȵĹؼ֡б
         * @param colorKeys @en Array of color keys @zh ɫؼ֡б
         * @param alphaKeys @en Array of alpha keys @zh ͸ȹؼ֡б
         */
        setKeys(colorKeys: ColorKey[], alphaKeys: AlphaKey[]): void;
        /**
         * @en Sort color keys and alpha keys.
         * @zh ɫ͸ȵĹؼ֡
         */
        sortKeys(): void;
        /**
         * @en Interpolate color and alpha from color and alpha keys.
         * @zh ɫбֵɫ͸ȡ
         * @param time @en Normalized time to interpolate. @zh ڲֵĹһʱ䡣
         * @returns @en Interpolated color value. @zh ֵɫֵ
         *
         * @deprecated since v3.8 please use [[evaluateFast]] instead.
         */
        evaluate(time: number): math.Color;
        /**
         * @en Interpolate color and alpha from color and alpha keys.
         * @zh ɫбֵɫ͸ȡ
         * @param out @en Interpolated color value. @zh ֵɫֵ
         * @param time @en Normalized time to interpolate. @zh ڲֵĹһʱ䡣
         * @returns @en Interpolated color value. @zh ֵɫֵ
         */
        evaluateFast(out: math.Color, time: number): math.Color;
        /**
         * @en Generates a random color and alpha.
         * @zh ɫ͸ȡ
         * @returns @en Randomized color. @zh ɵɫ
         * @deprecated since v3.8 please use [[getRandomColor]] instead.
         */
        randomColor(): math.Color;
        /**
         * @en Generates a random color and alpha.
         * @zh ɫ͸ȡ
         * @param out @en Randomized color. @zh ɵɫ
         * @returns @en Randomized color. @zh ɵɫ
         */
        getRandomColor(out: math.Color): math.Color;
    }
    /**
     * @zh
     * ģڻȡ settings.json ļеϢͬʱԸһЩôӶӰУɲο [game.init] Ĳѡ˵ͨ [settings] ʴģ鵥
     * @en
     * The Settings module is used to get the configuration information in the settings.json configuration file,
     * and you can override some of the configuration to affect the launch and running of the engine, as described in the [game.init] parameter options.
     * You can access this single instance of the module via [settings].
     */
    export class Settings {
        static Category: typeof __private._cocos_core_settings__Category;
        /**
         * Initialization
         * @internal
         */
        init(path?: string, overrides?: Record<string, any>): Promise<void>;
        /**
         * @zh
         * һݡ
         *
         * @en
         * Override some configuration info in Settings module.
         *
         * @param category @en The category you want to override. @zh Ҫǵķ顣
         * @param name @en The name of the configuration in the category you want to override. @zh Ҫǵľơ
         * @param value @en The value of the configuration you want to override. @zh Ҫǵľֵ
         *
         * @example
         * ```ts
         * console.log(settings.querySettings(Settings.Category.ASSETS, 'server')); // print https://www.cocos.com
         * settings.overrideSettings(Settings.Category.ASSETS, 'server', 'http://www.test.com');
         * console.log(settings.querySettings(Settings.Category.ASSETS, 'server')); // print http://www.test.com
         * ```
         */
        overrideSettings<T = any>(category: __private._cocos_core_settings__Category | string, name: string, value: T): void;
        /**
         * @zh
         * ѯģоеľֵ
         *
         * @en
         * Query specific configuration values in specific category in the settings module.
         *
         * @param category @en The name of category to query. @zh Ҫѯķơ
         * @param name @en The name of configuration in category to query. @zh Ҫѯľơ
         * @returns @en The value of configuration to query. @zh Ҫѯľֵ
         *
         * @example
         * ```ts
         * console.log(settings.querySettings(Settings.Category.ENGINE, 'debug')); // print false
         * ```
         */
        querySettings<T = any>(category: __private._cocos_core_settings__Category | string, name: string): T | null;
    }
    export namespace Settings {
        export type Category = typeof __private._cocos_core_settings__Category;
    }
    /**
     * @zh
     * Settings ģ鵥ͨ˵ settings.json еݡ
     * @en
     * Settings module singleton, through this you can access the configuration data in settings.json.
     */
    export const settings: Settings;
    /**
     * @en Base class for all functional system managed by [[Director]].
     * @zh ϵͳĻ࣬ [[Director]] 
     */
    export class System implements ISchedulable {
        static Priority: {
            LOW: number;
            MEDIUM: number;
            HIGH: number;
            SCHEDULER: number;
        };
        protected _id: string;
        protected _priority: number;
        protected _executeInEditMode: boolean;
        set priority(value: number);
        get priority(): number;
        set id(id: string);
        get id(): string;
        /**
         * @en Sorting between different systems.
         * @zh ͬϵͳ
         * @param a System a
         * @param b System b
         */
        static sortByPriority(a: System, b: System): number;
        /**
         * @en Init the system, will be invoked by [[Director]] when registered, should be implemented if needed.
         * @zh ϵͳʼעʱ [[Director]] ãҪĻӦʵ
         */
        init(): void;
        /**
         * @en Update function of the system, it will be invoked between all components update phase and late update phase.
         * @zh ϵͳ֡º update  lateUpdate ֮䱻
         * @param dt Delta time after the last frame
         */
        update(dt: number): void;
        /**
         * @en Post update function of the system, it will be invoked after all components late update phase and before the rendering process.
         * @zh ϵͳ֡ lateUpdate ֮ԼȾ֮ǰ
         * @param dt Delta time after the last frame
         */
        postUpdate(dt: number): void;
        destroy(): void;
    }
    export namespace easing {
        /**
         * @en Not any easing effect.
         * @zh ûκλЧ
         */
        export function constant(): number;
        /**
         * @en A linear function, `f(k) = k`. Result correlates to input value one to one.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh Ժ`f(k) = k`ֵֵһһӦЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function linear(k: number): number;
        /**
         * @en A quadratic function, f(k) = k * k. The interpolation starts slowly, then progressively speeds up until the end,
         * at which point it stops abruptly. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh һηĺf(k) = k * kֵʼʱȻ𽥼ӿ죬ֱͻȻֹͣЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function quadIn(k: number): number;
        /**
         * @en A quadratic function, f(k) = k * (2-k). The interpolation starts abruptly and then progressively slows down towards the end. Refer to
         * [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh һηĺf(k) = k * (2-k)ֵʼʱͻȻȻڽӽβʱ𽥼ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function quadOut(k: number): number;
        /**
         * @en The interpolation starts slowly, speeds up, and then slows down towards the end. Refer to
         * [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) graphic feature.
         * @zh ֵʼʱżӿ죬ȻڽӽβʱЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function quadInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ٿ졣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function cubicIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh Ѹ٣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function cubicOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ڿʼʱٶڽʱٶȡЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function cubicInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ٿ졣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function quartIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh Ѹ٣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function quartOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ڿʼʱٶڽʱٶȡЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function quartInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ٿ졣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function quintIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh Ѹ٣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function quintOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ڿʼʱٶڽʱٶȡЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function quintInOut(k: number): number;
        /**
         * @en Smoothly accelerates the animation.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ƽؼٶЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function sineIn(k: number): number;
        /**
         * @en Smoothly decelerates the animation.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ƽʹ١ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function sineOut(k: number): number;
        /**
         * @en Smoothly accelerates the animation at the beginning, and smoothly decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ڿʼʱƽؼٶڽʱƽؼٶЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function sineInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ٿ졣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function expoIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh Ѹ٣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function expoOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ڿʼʱٶڽʱٶȡЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function expoInOut(k: number): number;
        /**
         * @en Starts slowly and accelerates. Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ٿ졣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function circIn(k: number): number;
        /**
         * @en Starts quickly and decelerates.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh Ѹ٣ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function circOut(k: number): number;
        /**
         * @en Accelerates the animation at the beginning, and decelerates the animation at the end.
         * Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ڿʼʱٶڽʱٶȡЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function circInOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function elasticIn(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function elasticOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function elasticInOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function backIn(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function backOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function backInOut(k: number): number;
        export function bounceIn(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function bounceOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function bounceInOut(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function smooth(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export function fade(k: number): number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const quadOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const cubicOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const quartOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const quintOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const sineOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const expoOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const circOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const elasticOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const backOutIn: (k: number) => number;
        /**
         * @en Refer to [this doc](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html) for graphic feature.
         * @zh ЧԲο[ĵ](https://docs.cocos.com/creator/manual/zh/tween/tween-function.html)
         */
        export const bounceOutIn: (k: number) => number;
    }
    export function bezier(C1: number, C2: number, C3: number, C4: number, t: number): number;
    export function bezierByTime(controlPoints: BezierControlPoints, x: number): number;
    export type BezierControlPoints = [
        number,
        number,
        number,
        number
    ];
    export function setPropertyEnumType(objectOrConstructor: object, propertyName: string, enumType: __private._cocos_core_value_types_enum__EnumType): void;
    export function setPropertyEnumTypeOnAttrs(attrs: Record<string, any>, propertyName: string, enumType: __private._cocos_core_value_types_enum__EnumType): void;
    export function isCCObject(object: any): object is CCObject;
    export function isValid(value: any, strictMode?: boolean): boolean;
    export namespace pipeline {
        export enum SetIndex {
            GLOBAL = 0,
            MATERIAL = 1,
            LOCAL = 2,
            COUNT = 3
        }
        /**
         * @en The predefined render priorities
         * @zh ԤȾȼ
         */
        export enum RenderPriority {
            MIN = 0,
            MAX = 255,
            DEFAULT = 128
        }
        /**
         * @internal This method only used to init localDescriptorSetLayout.layouts[UBOSkinning.NAME]
         */
        export function localDescriptorSetLayout_ResizeMaxJoints(maxCount: number): void;
        /**
         * @en Does the device support single-channeled half float texture? (for both color attachment and sampling)
         * @zh ǰ豸Ƿֵ֧ͨ븡ͼɫͲ
         */
        export function supportsR16HalfFloatTexture(device: gfx.Device): boolean;
        /**
         * @en Does the device support single-channeled float texture? (for both color attachment and sampling)
         * @zh ǰ豸Ƿֵ֧ͨͼɫͲ
         */
        export function supportsR32FloatTexture(device: gfx.Device): boolean;
        /**
         * @en Does the device support 4-channeled float texture? (for both color attachment and sampling)
         * @zh ǰ豸Ƿ֧4ͨͼɫͲ
         */
        export function supportsRGBA16HalfFloatTexture(device: gfx.Device): boolean;
        /**
         * @en Does the device support 4-channeled float texture? (for both color attachment and sampling)
         * @zh ǰ豸Ƿ֧4ͨͼɫͲ
         */
        export function supportsRGBA32FloatTexture(device: gfx.Device): boolean;
        export function isEnableEffect(): boolean;
        export const PIPELINE_FLOW_MAIN = "MainFlow";
        export const PIPELINE_FLOW_FORWARD = "ForwardFlow";
        export const PIPELINE_FLOW_SHADOW = "ShadowFlow";
        export const PIPELINE_FLOW_SMAA = "SMAAFlow";
        export const PIPELINE_FLOW_TONEMAP = "ToneMapFlow";
        /**
         * @en The predefined render pass stage ids
         * @zh ԤȾ׶Ρ
         */
        export enum RenderPassStage {
            DEFAULT = 100,
            UI = 200
        }
        /**
         * @en Render object interface
         * @zh Ⱦӿڡ
         */
        export interface IRenderObject {
            model: renderer.scene.Model;
            depth: number;
        }
        export interface IRenderPass {
            priority: number;
            hash: number;
            depth: number;
            shaderId: number;
            subModel: renderer.scene.SubModel;
            passIdx: number;
        }
        /**
         * @en Render batch interface
         * @zh Ⱦνӿڡ
         */
        export interface IRenderBatch {
            pass: renderer.Pass;
        }
        /**
         * @en Render queue descriptor
         * @zh Ⱦ
         */
        export interface IRenderQueueDesc {
            isTransparent: boolean;
            phases: number;
            sortFunc: (a: IRenderPass, b: IRenderPass) => number;
        }
        export interface IDescriptorSetLayoutInfo {
            bindings: gfx.DescriptorSetLayoutBinding[];
            layouts: Record<string, gfx.UniformBlock | gfx.UniformSamplerTexture | gfx.UniformStorageImage | gfx.UniformStorageBuffer>;
        }
        export const globalDescriptorSetLayout: IDescriptorSetLayoutInfo;
        export const localDescriptorSetLayout: IDescriptorSetLayoutInfo;
        /**
         * @en The uniform bindings
         * @zh Uniform 󶨡
         */
        export enum PipelineGlobalBindings {
            UBO_GLOBAL = 0,
            UBO_CAMERA = 1,
            UBO_SHADOW = 2,
            UBO_CSM = 3,
            SAMPLER_SHADOWMAP = 4,
            SAMPLER_ENVIRONMENT = 5,
            SAMPLER_SPOT_SHADOW_MAP = 6,
            SAMPLER_DIFFUSEMAP = 7,
            COUNT = 8
        }
        export enum ModelLocalBindings {
            UBO_LOCAL = 0,
            UBO_FORWARD_LIGHTS = 1,
            UBO_SKINNING_ANIMATION = 2,
            UBO_SKINNING_TEXTURE = 3,
            UBO_MORPH = 4,
            UBO_UI_LOCAL = 5,
            UBO_SH = 6,
            SAMPLER_JOINTS = 7,
            SAMPLER_MORPH_POSITION = 8,
            SAMPLER_MORPH_NORMAL = 9,
            SAMPLER_MORPH_TANGENT = 10,
            SAMPLER_LIGHTMAP = 11,
            SAMPLER_SPRITE = 12,
            SAMPLER_REFLECTION = 13,
            STORAGE_REFLECTION = 14,
            SAMPLER_REFLECTION_PROBE_CUBE = 15,
            SAMPLER_REFLECTION_PROBE_PLANAR = 16,
            SAMPLER_REFLECTION_PROBE_DATA_MAP = 17,
            SAMPLER_REFLECTION_PROBE_BLEND_CUBE = 18,
            COUNT = 19
        }
        export const bindingMappingInfo: gfx.BindingMappingInfo;
        /**
         * @en The global uniform buffer object
         * @zh ȫ UBO
         */
        export class UBOGlobal {
            static readonly TIME_OFFSET = 0;
            static readonly SCREEN_SIZE_OFFSET: number;
            static readonly NATIVE_SIZE_OFFSET: number;
            static readonly PROBE_INFO_OFFSET: number;
            static readonly DEBUG_VIEW_MODE_OFFSET: number;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCGlobal";
            static readonly BINDING = PipelineGlobalBindings.UBO_GLOBAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        /**
         * @en The global camera uniform buffer object
         * @zh ȫ UBO
         */
        export class UBOCamera {
            static readonly MAT_VIEW_OFFSET = 0;
            static readonly MAT_VIEW_INV_OFFSET: number;
            static readonly MAT_PROJ_OFFSET: number;
            static readonly MAT_PROJ_INV_OFFSET: number;
            static readonly MAT_VIEW_PROJ_OFFSET: number;
            static readonly MAT_VIEW_PROJ_INV_OFFSET: number;
            static readonly CAMERA_POS_OFFSET: number;
            static readonly SURFACE_TRANSFORM_OFFSET: number;
            static readonly SCREEN_SCALE_OFFSET: number;
            static readonly EXPOSURE_OFFSET: number;
            static readonly MAIN_LIT_DIR_OFFSET: number;
            static readonly MAIN_LIT_COLOR_OFFSET: number;
            static readonly AMBIENT_SKY_OFFSET: number;
            static readonly AMBIENT_GROUND_OFFSET: number;
            static readonly GLOBAL_FOG_COLOR_OFFSET: number;
            static readonly GLOBAL_FOG_BASE_OFFSET: number;
            static readonly GLOBAL_FOG_ADD_OFFSET: number;
            static readonly NEAR_FAR_OFFSET: number;
            static readonly VIEW_PORT_OFFSET: number;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCCamera";
            static readonly BINDING = PipelineGlobalBindings.UBO_CAMERA;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        /**
         * @en The uniform buffer object for 'cast shadow(fixed || csm)' && 'dir fixed area shadow' && 'spot shadow' && 'sphere shadow' && 'planar shadow'
         * @zh  UBO ֻ 'cast shadow(fixed || csm)' && 'dir fixed area shadow' && 'spot shadow' && 'sphere shadow' && 'planar shadow' ʹ
         */
        export class UBOShadow {
            static readonly MAT_LIGHT_VIEW_OFFSET = 0;
            static readonly MAT_LIGHT_VIEW_PROJ_OFFSET: number;
            static readonly SHADOW_INV_PROJ_DEPTH_INFO_OFFSET: number;
            static readonly SHADOW_PROJ_DEPTH_INFO_OFFSET: number;
            static readonly SHADOW_PROJ_INFO_OFFSET: number;
            static readonly SHADOW_NEAR_FAR_LINEAR_SATURATION_INFO_OFFSET: number;
            static readonly SHADOW_WIDTH_HEIGHT_PCF_BIAS_INFO_OFFSET: number;
            static readonly SHADOW_LIGHT_PACKING_NBIAS_NULL_INFO_OFFSET: number;
            static readonly SHADOW_COLOR_OFFSET: number;
            static readonly PLANAR_NORMAL_DISTANCE_INFO_OFFSET: number;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCShadow";
            static readonly BINDING = PipelineGlobalBindings.UBO_SHADOW;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        /**
         * @en The uniform buffer object only for dir csm shadow(level: 1 ~ 4)
         * @zh ӰʹõUBO
         */
        export class UBOCSM {
            static readonly CSM_LEVEL_COUNT = 4;
            static readonly CSM_VIEW_DIR_0_OFFSET = 0;
            static readonly CSM_VIEW_DIR_1_OFFSET: number;
            static readonly CSM_VIEW_DIR_2_OFFSET: number;
            static readonly CSM_ATLAS_OFFSET: number;
            static readonly MAT_CSM_VIEW_PROJ_OFFSET: number;
            static readonly CSM_PROJ_DEPTH_INFO_OFFSET: number;
            static readonly CSM_PROJ_INFO_OFFSET: number;
            static readonly CSM_SPLITS_INFO_OFFSET: number;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCCSM";
            static readonly BINDING = PipelineGlobalBindings.UBO_CSM;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export const UNIFORM_SHADOWMAP_BINDING = PipelineGlobalBindings.SAMPLER_SHADOWMAP;
        export const UNIFORM_ENVIRONMENT_BINDING = PipelineGlobalBindings.SAMPLER_ENVIRONMENT;
        export const UNIFORM_DIFFUSEMAP_BINDING = PipelineGlobalBindings.SAMPLER_DIFFUSEMAP;
        export const UNIFORM_SPOT_SHADOW_MAP_TEXTURE_BINDING = PipelineGlobalBindings.SAMPLER_SPOT_SHADOW_MAP;
        /**
         * @en The local uniform buffer object
         * @zh  UBO
         */
        export class UBOLocal {
            static readonly MAT_WORLD_OFFSET = 0;
            static readonly MAT_WORLD_IT_OFFSET: number;
            static readonly LIGHTINGMAP_UVPARAM: number;
            static readonly LOCAL_SHADOW_BIAS: number;
            static readonly REFLECTION_PROBE_DATA1: number;
            static readonly REFLECTION_PROBE_DATA2: number;
            static readonly REFLECTION_PROBE_BLEND_DATA1: number;
            static readonly REFLECTION_PROBE_BLEND_DATA2: number;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCLocal";
            static readonly BINDING = ModelLocalBindings.UBO_LOCAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        /**
         * @en The world bound uniform buffer object
         * @zh ռΧ UBO
         */
        export class UBOWorldBound {
            static readonly WORLD_BOUND_CENTER = 0;
            static readonly WORLD_BOUND_HALF_EXTENTS: number;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCWorldBound";
            static readonly BINDING = ModelLocalBindings.UBO_LOCAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export const INST_MAT_WORLD = "a_matWorld0";
        export const INST_SH = "a_sh_linear_const_r";
        export class UBOLocalBatched {
            static readonly BATCHING_COUNT = 10;
            static readonly MAT_WORLDS_OFFSET = 0;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCLocalBatched";
            static readonly BINDING = ModelLocalBindings.UBO_LOCAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        /**
         * @en The uniform buffer object for forward lighting
         * @zh ǰƹ UBO
         */
        export class UBOForwardLight {
            static readonly LIGHTS_PER_PASS = 1;
            static readonly LIGHT_POS_OFFSET = 0;
            static readonly LIGHT_COLOR_OFFSET: number;
            static readonly LIGHT_SIZE_RANGE_ANGLE_OFFSET: number;
            static readonly LIGHT_DIR_OFFSET: number;
            static readonly LIGHT_BOUNDING_SIZE_VS_OFFSET: number;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCForwardLight";
            static readonly BINDING = ModelLocalBindings.UBO_FORWARD_LIGHTS;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export class UBODeferredLight {
            static readonly LIGHTS_PER_PASS = 10;
        }
        export const JOINT_UNIFORM_CAPACITY = 30;
        /**
         * @en The uniform buffer object for skinning texture
         * @zh ͼ UBO
         */
        export class UBOSkinningTexture {
            static readonly JOINTS_TEXTURE_INFO_OFFSET = 0;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCSkinningTexture";
            static readonly BINDING = ModelLocalBindings.UBO_SKINNING_TEXTURE;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export class UBOSkinningAnimation {
            static readonly JOINTS_ANIM_INFO_OFFSET = 0;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCSkinningAnimation";
            static readonly BINDING = ModelLocalBindings.UBO_SKINNING_ANIMATION;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export const INST_JOINT_ANIM_INFO = "a_jointAnimInfo";
        export class UBOSkinning {
            static get JOINT_UNIFORM_CAPACITY(): number;
            static get COUNT(): number;
            static get SIZE(): number;
            static readonly NAME = "CCSkinning";
            static readonly BINDING = ModelLocalBindings.UBO_SKINNING_TEXTURE;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
            /**
             * @internal This method only used init UBOSkinning configure.
             */
            static initLayout(capacity: number): void;
        }
        /**
         * @en The uniform buffer object for morph setting
         * @zh αõ UBO
         */
        export class UBOMorph {
            static readonly MAX_MORPH_TARGET_COUNT = 60;
            static readonly OFFSET_OF_WEIGHTS = 0;
            static readonly OFFSET_OF_DISPLACEMENT_TEXTURE_WIDTH: number;
            static readonly OFFSET_OF_DISPLACEMENT_TEXTURE_HEIGHT: number;
            static readonly OFFSET_OF_VERTICES_COUNT: number;
            static readonly COUNT_BASE_4_BYTES: number;
            static readonly SIZE: number;
            static readonly NAME = "CCMorph";
            static readonly BINDING = ModelLocalBindings.UBO_MORPH;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export class UBOUILocal {
            static readonly NAME = "CCUILocal";
            static readonly BINDING = ModelLocalBindings.UBO_UI_LOCAL;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        /**
         * @en The SH uniform buffer object
         * @zh г UBO
         */
        export class UBOSH {
            static readonly SH_LINEAR_CONST_R_OFFSET = 0;
            static readonly SH_LINEAR_CONST_G_OFFSET: number;
            static readonly SH_LINEAR_CONST_B_OFFSET: number;
            static readonly SH_QUADRATIC_R_OFFSET: number;
            static readonly SH_QUADRATIC_G_OFFSET: number;
            static readonly SH_QUADRATIC_B_OFFSET: number;
            static readonly SH_QUADRATIC_A_OFFSET: number;
            static readonly COUNT: number;
            static readonly SIZE: number;
            static readonly NAME = "CCSH";
            static readonly BINDING = ModelLocalBindings.UBO_SH;
            static readonly DESCRIPTOR: gfx.DescriptorSetLayoutBinding;
            static readonly LAYOUT: gfx.UniformBlock;
        }
        export const UNIFORM_JOINT_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_JOINTS;
        export const UNIFORM_REALTIME_JOINT_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_JOINTS;
        export const UNIFORM_POSITION_MORPH_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_MORPH_POSITION;
        export const UNIFORM_NORMAL_MORPH_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_MORPH_NORMAL;
        export const UNIFORM_TANGENT_MORPH_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_MORPH_TANGENT;
        export const UNIFORM_LIGHTMAP_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_LIGHTMAP;
        export const UNIFORM_SPRITE_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_SPRITE;
        export const UNIFORM_REFLECTION_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_REFLECTION;
        export const UNIFORM_REFLECTION_STORAGE_BINDING = ModelLocalBindings.STORAGE_REFLECTION;
        export const UNIFORM_REFLECTION_PROBE_CUBEMAP_BINDING = ModelLocalBindings.SAMPLER_REFLECTION_PROBE_CUBE;
        export const UNIFORM_REFLECTION_PROBE_TEXTURE_BINDING = ModelLocalBindings.SAMPLER_REFLECTION_PROBE_PLANAR;
        export const UNIFORM_REFLECTION_PROBE_DATA_MAP_BINDING = ModelLocalBindings.SAMPLER_REFLECTION_PROBE_DATA_MAP;
        export const UNIFORM_REFLECTION_PROBE_BLEND_CUBEMAP_BINDING = ModelLocalBindings.SAMPLER_REFLECTION_PROBE_BLEND_CUBE;
        export const CAMERA_DEFAULT_MASK: number;
        export const CAMERA_EDITOR_MASK: number;
        export const MODEL_ALWAYS_MASK: number;
    }
    /**
     * @en Render pipeline describes how we handle the rendering process for all render objects in the related render scene root.
     * It contains some general pipeline configurations, necessary rendering resources and some [[RenderFlow]]s.
     * The rendering process function [[render]] is invoked by [[Root]] for all [[Camera]]s.
     * @zh Ⱦ߶ȾµȾʵʩȾ̡
     * ҪһЩͨõĹãҪȾԴһЩ [[RenderFlow]]
     * Ⱦ̺ [[render]]  [[Root]] ò [[Camera]] ִԤȾ̡
     */
    export abstract class RenderPipeline extends Asset implements __private._cocos_rendering_pipeline_event__IPipelineEvent, __private._cocos_rendering_custom_pipeline__PipelineRuntime {
        /**
         * @en The tag of pipeline.
         * @zh ߵıǩ
         * @readonly
         */
        get tag(): number;
        /**
         * @en The flows of pipeline.
         * @zh ߵȾб
         * @readonly
         */
        get flows(): RenderFlow[];
        /**
         * @en Tag
         * @zh ǩ
         * @readonly
         */
        protected _tag: number;
        /**
         * @en Flows
         * @zh Ⱦб
         * @readonly
         */
        protected _flows: RenderFlow[];
        protected _quadIB: gfx.Buffer | null;
        protected _quadVBOnscreen: gfx.Buffer | null;
        protected _quadVBOffscreen: gfx.Buffer | null;
        protected _quadIAOnscreen: gfx.InputAssembler | null;
        protected _quadIAOffscreen: gfx.InputAssembler | null;
        protected _eventProcessor: PipelineEventProcessor;
        /**
         * @zh
         * ı㼯
         */
        get quadIAOnscreen(): gfx.InputAssembler;
        get quadIAOffscreen(): gfx.InputAssembler;
        getPipelineRenderData(): __private._cocos_rendering_render_pipeline__PipelineRenderData;
        /**
         * @en
         * Constant macro string, static throughout the whole runtime.
         * Used to pass device-specific parameters to shader.
         * @zh 궨ַʱȫ̲ı䣬ڸ shader һЩֻƽ̨صĲ
         * @readonly
         */
        get constantMacros(): string;
        /**
         * @en
         * The current global-scoped shader macros.
         * Used to control effects like IBL, fog, etc.
         * @zh ǰȫֺ궨壬ڿ IBLЧģ顣
         * @readonly
         */
        get macros(): renderer.MacroRecord;
        get device(): gfx.Device;
        get globalDSManager(): __private._cocos_rendering_global_descriptor_set_manager__GlobalDSManager;
        get descriptorSetLayout(): gfx.DescriptorSetLayout;
        get descriptorSet(): gfx.DescriptorSet;
        get commandBuffers(): gfx.CommandBuffer[];
        get pipelineUBO(): __private._cocos_rendering_pipeline_ubo__PipelineUBO;
        get pipelineSceneData(): PipelineSceneData;
        set profiler(value: renderer.scene.Model | null);
        get profiler(): renderer.scene.Model | null;
        /**
         * @deprecated since v3.6, please use camera.geometryRenderer instead.
         */
        get geometryRenderer(): GeometryRenderer | null;
        set clusterEnabled(value: boolean);
        get clusterEnabled(): boolean;
        set bloomEnabled(value: boolean);
        get bloomEnabled(): boolean;
        protected _device: gfx.Device;
        protected _globalDSManager: __private._cocos_rendering_global_descriptor_set_manager__GlobalDSManager;
        protected _descriptorSet: gfx.DescriptorSet;
        protected _commandBuffers: gfx.CommandBuffer[];
        protected _pipelineUBO: __private._cocos_rendering_pipeline_ubo__PipelineUBO;
        protected _macros: renderer.MacroRecord;
        protected _constantMacros: string;
        protected _profiler: renderer.scene.Model | null;
        protected _geometryRenderer: GeometryRenderer | null;
        protected _pipelineSceneData: PipelineSceneData;
        protected _pipelineRenderData: __private._cocos_rendering_render_pipeline__PipelineRenderData | null;
        protected _renderPasses: Map<number, gfx.RenderPass>;
        protected _width: number;
        protected _height: number;
        protected _lastUsedRenderArea: gfx.Rect;
        protected _clusterEnabled: boolean;
        protected _bloomEnabled: boolean;
        /**
         * @en The initialization process, user shouldn't use it in most case, only useful when need to generate render pipeline programmatically.
         * @zh ʼ²õڳȾߵ
         * @param info The render pipeline information
         */
        initialize(info: __private._cocos_rendering_render_pipeline__IRenderPipelineInfo): boolean;
        createRenderPass(clearFlags: gfx.ClearFlags, colorFmt: gfx.Format, depthFmt: gfx.Format): gfx.RenderPass;
        getRenderPass(clearFlags: gfx.ClearFlags, fbo: gfx.Framebuffer): gfx.RenderPass;
        newFramebufferByRatio(dyingFramebuffer: gfx.Framebuffer): gfx.Framebuffer;
        /**
         * @en generate renderArea by camera
         * @zh renderArea
         * @param camera the camera
         * @returns
         */
        generateRenderArea(camera: renderer.scene.Camera, out: gfx.Rect): void;
        generateViewport(camera: renderer.scene.Camera, out?: gfx.Viewport): gfx.Viewport;
        generateScissor(camera: renderer.scene.Camera, out?: gfx.Rect): gfx.Rect;
        get shadingScale(): number;
        set shadingScale(val: number);
        getMacroString(name: string): string;
        getMacroInt(name: string): number;
        getMacroBool(name: string): boolean;
        setMacroString(name: string, value: string): void;
        setMacroInt(name: string, value: number): void;
        setMacroBool(name: string, value: boolean): void;
        /**
         * @en Activate the render pipeline after loaded, it mainly activate the flows
         * @zh ȾԴɺùߣҪùڵ flow
         * TODO: remove swapchain dependency at this stage
         * after deferred pipeline can handle multiple swapchains
         */
        activate(swapchain: gfx.Swapchain): boolean;
        protected _ensureEnoughSize(cameras: renderer.scene.Camera[]): void;
        /**
         * @en Render function, it basically run the render process of all flows in sequence for the given view.
         * @zh ȾָȾͼ˳ִȾ̡
         * @param view Render view
         */
        render(cameras: renderer.scene.Camera[]): void;
        /**
         * @zh
         * ı㼯
         */
        protected _destroyQuadInputAssembler(): void;
        protected _destroyBloomData(): void;
        /**
         * @zh
         * ı㼯
         */
        protected _createQuadInputAssembler(): __private._cocos_rendering_render_pipeline__PipelineInputAssemblerData;
        updateQuadVertexData(renderArea: gfx.Rect, window: __private._cocos_render_scene_core_render_window__RenderWindow): void;
        /**
         * @en Internal destroy function
         * @zh ڲٺ
         */
        destroy(): boolean;
        onGlobalPipelineStateChanged(): void;
        protected _generateConstantMacros(): void;
        protected updateGeometryRenderer(cameras: renderer.scene.Camera[]): void;
        generateBloomRenderData(): void;
        /**
         * @en
         * Register an callback of the pipeline event type on the RenderPipeline.
         * @zh
         * Ⱦע¼͵Ļص
         */
        on(type: PipelineEventType, callback: any, target?: any, once?: boolean): typeof callback;
        /**
         * @en
         * Register an callback of the pipeline event type on the RenderPipeline,
         * the callback will remove itself after the first time it is triggered.
         * @zh
         * Ⱦע¼͵Ļص, صڵһʱɾ
         */
        once(type: PipelineEventType, callback: any, target?: any): typeof callback;
        /**
         * @en
         * Removes the listeners previously registered with the same type, callback, target and or useCapture,
         * if only type is passed as parameter, all listeners registered with that type will be removed.
         * @zh
         * ɾ֮ǰͬ͡صĿ useCapture ע¼ֻ typeɾ type ͵¼
         */
        off(type: PipelineEventType, callback?: any, target?: any): void;
        /**
         * @zh ɷһָ¼ҪĲ
         * @en Trigger an event directly with the event name and necessary arguments.
         * @param type - event type
         * @param args - Arguments when the event triggered
         */
        emit(type: PipelineEventType, arg0?: any, arg1?: any, arg2?: any, arg3?: any, arg4?: any): void;
        /**
         * @en Removes all callbacks previously registered with the same target (passed as parameter).
         * This is not for removing all listeners in the current event target,
         * and this is not for removing all listeners the target parameter have registered.
         * It's only for removing all listeners (callback and target couple) registered on the current event target by the target parameter.
         * @zh ڵǰ EventTarget ɾָĿ꣨target ע¼
         * ޷ɾǰ EventTarget ¼Ҳ޷ɾ target ע¼
         * ֻɾ target ڵǰ EventTarget ע¼
         * @param typeOrTarget - The target to be searched for all related listeners
         */
        targetOff(typeOrTarget: any): void;
        /**
         * @zh Ƴض¼עлصĳĿעлص
         * @en Removes all callbacks registered in a certain event type or all callbacks registered with a certain target
         * @param typeOrTarget - The event type or target with which the listeners will be removed
         */
        removeAll(typeOrTarget: any): void;
        /**
         * @zh ָ¼Ƿעص
         * @en Checks whether there is correspond event listener registered on the given event.
         * @param type - Event type.
         * @param callback - Callback function when event triggered.
         * @param target - Callback callee.
         */
        hasEventListener(type: PipelineEventType, callback?: any, target?: any): boolean;
    }
    /**
     * @en Render flow is a sub process of the [[RenderPipeline]], it dispatch the render task to all the [[RenderStage]]s.
     * @zh ȾȾߣ[[RenderPipeline]]һӹ̣ȾɷȾ׶Σ[[RenderStage]]ִС
     */
    export abstract class RenderFlow {
        /**
         * @en The name of the render flow
         * @zh Ⱦ̵
         */
        get name(): string;
        /**
         * @en Priority of the current flow
         * @zh ǰȾ̵ȼ
         */
        get priority(): number;
        /**
         * @en Tag of the current flow
         * @zh ǰȾ̵ıǩ
         */
        get tag(): number;
        /**
         * @en The stages of flow.
         * @zh Ⱦ stage б
         * @readonly
         */
        get stages(): RenderStage[];
        protected _name: string;
        protected _priority: number;
        protected _tag: number;
        protected _stages: RenderStage[];
        protected _pipeline: RenderPipeline;
        /**
         * @en Get pipeline
         * @zh ȡpipeline
         */
        get pipeline(): RenderPipeline;
        /**
         * @en The initialization process, user shouldn't use it in most case, only useful when need to generate render pipeline programmatically.
         * @zh ʼ²õڳȾߵ
         * @param info The render flow information
         */
        initialize(info: __private._cocos_rendering_render_flow__IRenderFlowInfo): boolean;
        /**
         * @en Activate the current render flow in the given pipeline
         * @zh ΪָȾ߿ǰȾ
         * @param pipeline The render pipeline to activate this render flow
         */
        activate(pipeline: RenderPipeline): void;
        /**
         * @en Render function, it basically run all render stages in sequence for the given view.
         * @zh ȾָȾͼ˳ִȾ׶Ρ
         * @param view Render view
         */
        render(camera: renderer.scene.Camera): void;
        /**
         * @en Destroy function.
         * @zh ٺ
         */
        destroy(): void;
    }
    /**
     * @en The render stage actually renders render objects to the output window or other GFX [[gfx.Framebuffer]].
     * Typically, a render stage collects render objects it's responsible for, clear the camera,
     * record and execute command buffer, and at last present the render result.
     * @zh Ⱦ׶ʵϵȾִߣռȾݲִȾȾĻ GFX [[gfx.Framebuffer]] С
     * ͵Ⱦ׶λռȾ󣬰 [[Camera]] ǽ¼ִȾָ棬ճȾ
     */
    export abstract class RenderStage {
        /**
         * @en Name of the current stage
         * @zh ǰȾ׶ε֡
         */
        get name(): string;
        /**
         * @en Priority of the current stage
         * @zh ǰȾ׶εȼ
         */
        get priority(): number;
        /**
         * @en Tag of the current stage
         * @zh ǰȾ׶εıǩ
         */
        get tag(): number;
        /**
         * @en Name
         * @zh ơ
         */
        protected _name: string;
        /**
         * @en Priority
         * @zh ȼ
         */
        protected _priority: number;
        /**
         * @en Whether to enable
         * @zh Ƿá
         */
        protected _enabled: boolean;
        set enabled(val: boolean);
        get enabled(): boolean;
        /**
         * @en Type
         * @zh ͡
         */
        protected _tag: number;
        protected _pipeline: RenderPipeline;
        protected _flow: RenderFlow;
        /**
         * @en The initialization process, user shouldn't use it in most case, only useful when need to generate render pipeline programmatically.
         * @zh ʼ²õڳȾߵ
         * @param info The render stage information
         */
        initialize(info: __private._cocos_rendering_render_stage__IRenderStageInfo): boolean;
        /**
         * @en Activate the current render stage in the given render flow
         * @zh ΪָȾ̿ǰȾ׶
         * @param flow The render flow to activate this render stage
         */
        activate(pipeline: RenderPipeline, flow: RenderFlow): void;
        /**
         * @en Destroy function
         * @zh ٺ
         */
        abstract destroy(): void;
        /**
         * @en Render function
         * @zh Ⱦ
         * @param view The render view
         */
        abstract render(camera: renderer.scene.Camera): void;
    }
    export class PipelineSceneData {
        /**
         * @en Is open HDR.
         * @zh Ƿ HDR
         * @readonly
         */
        get isHDR(): boolean;
        set isHDR(val: boolean);
        get shadingScale(): number;
        set shadingScale(val: number);
        get csmSupported(): boolean;
        set csmSupported(val: boolean);
        get skinMaterialModel(): renderer.scene.Model;
        set skinMaterialModel(val: renderer.scene.Model);
        fog: renderer.scene.Fog;
        ambient: renderer.scene.Ambient;
        skybox: renderer.scene.Skybox;
        shadows: renderer.scene.Shadows;
        csmLayers: __private._cocos_rendering_shadow_csm_layers__CSMLayers;
        octree: renderer.scene.Octree;
        skin: renderer.scene.Skin;
        postSettings: renderer.scene.PostSettings;
        lightProbes: any;
        /**
         * @en The list for valid punctual Lights, only available after the scene culling of the current frame.
         * @zh оȷЧԴڵǰ֡ĳ޳ɺЧ
         */
        validPunctualLights: renderer.scene.Light[];
        /**
         * @en The list for render objects, only available after the scene culling of the current frame.
         * @zh Ⱦ飬ڵǰ֡ĳ޳ɺЧ
         */
        renderObjects: pipeline.IRenderObject[];
        shadowFrameBufferMap: Map<renderer.scene.Light, gfx.Framebuffer>;
        protected _device: gfx.Device;
        protected _geometryRendererMaterials: Material[];
        protected _geometryRendererPasses: renderer.Pass[];
        protected _geometryRendererShaders: gfx.Shader[];
        protected _occlusionQueryVertexBuffer: gfx.Buffer | null;
        protected _occlusionQueryIndicesBuffer: gfx.Buffer | null;
        protected _occlusionQueryInputAssembler: gfx.InputAssembler | null;
        protected _occlusionQueryMaterial: Material | null;
        protected _occlusionQueryShader: gfx.Shader | null;
        protected _isHDR: boolean;
        protected _shadingScale: number;
        protected _csmSupported: boolean;
        constructor();
        activate(device: gfx.Device): boolean;
        initGeometryRendererMaterials(): void;
        get geometryRendererPasses(): renderer.Pass[];
        get geometryRendererShaders(): gfx.Shader[];
        initOcclusionQuery(): void;
        getOcclusionQueryPass(): renderer.Pass | null;
        updatePipelineSceneData(): void;
        destroy(): void;
    }
    /**
     * @en The forward render pipeline
     * @zh ǰȾߡ
     */
    export class ForwardPipeline extends RenderPipeline {
        protected renderTextures: __private._cocos_rendering_pipeline_serialization__RenderTextureConfig[];
        protected _postRenderPass: gfx.RenderPass | null;
        get postRenderPass(): gfx.RenderPass | null;
        initialize(info: __private._cocos_rendering_render_pipeline__IRenderPipelineInfo): boolean;
        activate(swapchain: gfx.Swapchain): boolean;
        protected _ensureEnoughSize(cameras: renderer.scene.Camera[]): void;
        destroy(): boolean;
    }
    export function createDefaultPipeline(): ForwardPipeline;
    /**
     * @en The forward flow in forward render pipeline
     * @zh ǰȾ̡
     */
    export class ForwardFlow extends RenderFlow {
        /**
         * @en The shared initialization information of forward render flow
         * @zh ǰȾ̳ʼ
         */
        static initInfo: __private._cocos_rendering_render_flow__IRenderFlowInfo;
        initialize(info: __private._cocos_rendering_render_flow__IRenderFlowInfo): boolean;
        activate(pipeline: RenderPipeline): void;
        render(camera: renderer.scene.Camera): void;
        destroy(): void;
    }
    /**
     * @en The forward render stage
     * @zh ǰȾ׶Ρ
     */
    export class ForwardStage extends RenderStage {
        static initInfo: __private._cocos_rendering_render_stage__IRenderStageInfo;
        protected renderQueues: __private._cocos_rendering_pipeline_serialization__RenderQueueDesc[];
        protected _renderQueues: __private._cocos_rendering_render_queue__RenderQueue[];
        additiveInstanceQueues: __private._cocos_rendering_render_instanced_queue__RenderInstancedQueue[];
        constructor();
        addRenderInstancedQueue(queue: __private._cocos_rendering_render_instanced_queue__RenderInstancedQueue): void;
        removeRenderInstancedQueue(queue: __private._cocos_rendering_render_instanced_queue__RenderInstancedQueue): void;
        initialize(info: __private._cocos_rendering_render_stage__IRenderStageInfo): boolean;
        activate(pipeline: ForwardPipeline, flow: ForwardFlow): void;
        destroy(): void;
        render(camera: renderer.scene.Camera): void;
    }
    /**
     * @en The deferred render pipeline
     * @zh ӳȾߡ
     */
    export class DeferredPipeline extends RenderPipeline {
        protected renderTextures: __private._cocos_rendering_pipeline_serialization__RenderTextureConfig[];
        initialize(info: __private._cocos_rendering_render_pipeline__IRenderPipelineInfo): boolean;
        activate(swapchain: gfx.Swapchain): boolean;
        destroy(): boolean;
        onGlobalPipelineStateChanged(): void;
        getPipelineRenderData(): __private._cocos_rendering_deferred_deferred_pipeline__DeferredRenderData;
        protected _ensureEnoughSize(cameras: renderer.scene.Camera[]): void;
    }
    /**
     * @en The main flow in deferred render pipeline
     * @zh ӳȾ̡
     */
    export class MainFlow extends RenderFlow {
        /**
         * @en The shared initialization information of main render flow
         * @zh ӳȾ̳ʼ
         */
        static initInfo: __private._cocos_rendering_render_flow__IRenderFlowInfo;
        initialize(info: __private._cocos_rendering_render_flow__IRenderFlowInfo): boolean;
        activate(pipeline: RenderPipeline): void;
        render(camera: renderer.scene.Camera): void;
        destroy(): void;
    }
    /**
     * @en The gbuffer render stage
     * @zh ǰȾ׶Ρ
     */
    export class GbufferStage extends RenderStage {
        static initInfo: __private._cocos_rendering_render_stage__IRenderStageInfo;
        protected renderQueues: __private._cocos_rendering_pipeline_serialization__RenderQueueDesc[];
        protected _renderQueues: __private._cocos_rendering_render_queue__RenderQueue[];
        constructor();
        initialize(info: __private._cocos_rendering_render_stage__IRenderStageInfo): boolean;
        activate(pipeline: DeferredPipeline, flow: MainFlow): void;
        destroy(): void;
        render(camera: renderer.scene.Camera): void;
    }
    /**
     * @en The lighting render stage
     * @zh ǰȾ׶Ρ
     */
    export class LightingStage extends RenderStage {
        static initInfo: __private._cocos_rendering_render_stage__IRenderStageInfo;
        constructor();
        initialize(info: __private._cocos_rendering_render_stage__IRenderStageInfo): boolean;
        gatherLights(camera: renderer.scene.Camera): void;
        protected _createStageDescriptor(pass: renderer.Pass): void;
        activate(pipeline: DeferredPipeline, flow: MainFlow): void;
        destroy(): void;
        render(camera: renderer.scene.Camera): void;
    }
    /**
     * @en The bloom post-process stage
     * @zh Bloom ׶Ρ
     */
    export class BloomStage extends RenderStage {
        static initInfo: __private._cocos_rendering_render_stage__IRenderStageInfo;
        threshold: number;
        intensity: number;
        iterations: number;
        constructor();
        initialize(info: __private._cocos_rendering_render_stage__IRenderStageInfo): boolean;
        activate(pipeline: RenderPipeline, flow: RenderFlow): void;
        destroy(): void;
        render(camera: renderer.scene.Camera): void;
    }
    /**
     * @en The postprocess render stage
     * @zh Ⱦ׶Ρ
     */
    export class PostProcessStage extends RenderStage {
        static initInfo: __private._cocos_rendering_render_stage__IRenderStageInfo;
        constructor();
        initialize(info: __private._cocos_rendering_render_stage__IRenderStageInfo): boolean;
        activate(pipeline: RenderPipeline, flow: RenderFlow): void;
        destroy(): void;
        render(camera: renderer.scene.Camera): void;
    }
    /**
     * @en Shadow map render flow
     * @zh Ӱͼ
     */
    export class ShadowFlow extends RenderFlow {
        /**
         * @en A common initialization info for shadow map render flow
         * @zh һͨõ ShadowFlow ĳʼϢ
         */
        static initInfo: __private._cocos_rendering_render_flow__IRenderFlowInfo;
        initialize(info: __private._cocos_rendering_render_flow__IRenderFlowInfo): boolean;
        activate(pipeline: RenderPipeline): void;
        render(camera: renderer.scene.Camera): void;
        destroy(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _initShadowFrameBuffer(pipeline: RenderPipeline, light: renderer.scene.Light, swapchain: gfx.Swapchain): void;
    }
    /**
     * @en Shadow map render stage
     * @zh ӰȾ׶Ρ
     */
    export class ShadowStage extends RenderStage {
        /**
         * @en A common initialization info for shadow map render stage
         * @zh һͨõ ShadowStage ĳʼϢ
         */
        static initInfo: __private._cocos_rendering_render_stage__IRenderStageInfo;
        /**
         * @en Sets the render shadow map info
         * @zh ӰȾϢ
         * @param light
         * @param shadowFrameBuffer
         * @param level 㼶
         */
        setUsage(globalDS: gfx.DescriptorSet, light: renderer.scene.Light, shadowFrameBuffer: gfx.Framebuffer, level?: number): void;
        destroy(): void;
        clearFramebuffer(camera: renderer.scene.Camera): void;
        render(camera: renderer.scene.Camera): void;
        activate(pipeline: ForwardPipeline, flow: ShadowFlow): void;
    }
    export class InstancedBuffer {
        instances: __private._cocos_rendering_instanced_buffer__IInstancedItem[];
        pass: renderer.Pass;
        hasPendingModels: boolean;
        dynamicOffsets: number[];
        constructor(pass: renderer.Pass);
        destroy(): void;
        merge(subModel: renderer.scene.SubModel, passIdx: number, shaderImplant?: gfx.Shader | null): void;
        uploadBuffers(cmdBuff: gfx.CommandBuffer): void;
        clear(): void;
    }
    export class PipelineStateManager {
        static getOrCreatePipelineState(device: gfx.Device, pass: renderer.Pass, shader: gfx.Shader, renderPass: gfx.RenderPass, ia: gfx.InputAssembler): gfx.PipelineState;
    }
    export class PipelineEventProcessor extends EventTarget {
        eventTargetOn: <TFunction extends (...any: any[]) => void>(type: string | number, callback: TFunction, thisArg?: any, once?: boolean | undefined) => TFunction;
        eventTargetOnce: <TFunction extends (...any: any[]) => void>(type: string | number, callback: TFunction, thisArg?: any) => TFunction;
        on(type: PipelineEventType, callback: any, target?: any, once?: boolean): typeof callback;
        once(type: PipelineEventType, callback: any, target?: any): typeof callback;
    }
    export enum PipelineEventType {
        /**
         * @en
         * The event type for render frame begin event
         *
         * @zh
         * ֡Ⱦʼ¼
         */
        RENDER_FRAME_BEGIN = "render-frame-begin",
        /**
         * @en
         * The event type for render frame end event
         *
         * @zh
         * ֡Ⱦ¼
         */
        RENDER_FRAME_END = "render-frame-end",
        /**
         * @en
         * The event type for render camera begin event
         *
         * @zh
         * Ⱦʼ¼
         */
        RENDER_CAMERA_BEGIN = "render-camera-begin",
        /**
         * @en
         * The event type for render camera end event
         *
         * @zh
         * Ⱦ¼
         */
        RENDER_CAMERA_END = "render-camera-end",
        /**
         * @en
         * FBO attachment texture zoom event
         *
         * @zh
         * FBO¼
         */
        ATTACHMENT_SCALE_CAHNGED = "attachment-scale-changed"
    }
    /**
     * @en Rendering debug view control class
     * @zh ȾԿ
     */
    export class DebugView {
        /**
         * @en Toggle rendering single debug mode.
         * @zh Ⱦģʽ
         */
        get singleMode(): __private._cocos_rendering_debug_view__DebugViewSingleType;
        set singleMode(val: __private._cocos_rendering_debug_view__DebugViewSingleType);
        /**
         * @en Toggle normal / pure lighting mode.
         * @zh лպͽģʽ
         */
        get lightingWithAlbedo(): boolean;
        set lightingWithAlbedo(val: boolean);
        /**
         * @en Toggle CSM layer coloration mode.
         * @zh лӰȾɫģʽ
         */
        get csmLayerColoration(): boolean;
        set csmLayerColoration(val: boolean);
        get debugViewType(): __private._cocos_rendering_debug_view__RenderingDebugViewType;
        protected _singleMode: __private._cocos_rendering_debug_view__DebugViewSingleType;
        protected _compositeModeValue: number;
        protected _lightingWithAlbedo: boolean;
        protected _csmLayerColoration: boolean;
        constructor();
        /**
         * @en Whether enabled with specified rendering composite debug mode.
         * @zh ȡָȾϵģʽǷ
         * @param Specified composite type.
         */
        isCompositeModeEnabled(val: number): boolean;
        /**
         * @en Toggle specified rendering composite debug mode.
         * @zh ָȾϵģʽ
         * @param Specified composite type, enable or disable.
         */
        enableCompositeMode(val: __private._cocos_rendering_debug_view__DebugViewCompositeType, enable: boolean): void;
        /**
         * @en Toggle all rendering composite debug mode.
         * @zh еȾϵģʽ
         */
        enableAllCompositeMode(enable: boolean): void;
        /**
         * @en Get rendering debug view on / off state.
         * @zh ѯǰǷȾģʽ
         */
        isEnabled(): boolean;
        /**
         * @en Disable all debug view modes, reset to standard rendering mode.
         * @zh رеȾģʽָȾ
         */
        reset(): void;
        /**
         * @internal
         */
        protected _activate(): void;
        protected _updatePipeline(): void;
    }
    /**
     * @en reflection probe render flow
     * @zh ̽rendertexture
     */
    export class ReflectionProbeFlow extends RenderFlow {
        static initInfo: __private._cocos_rendering_render_flow__IRenderFlowInfo;
        initialize(info: __private._cocos_rendering_render_flow__IRenderFlowInfo): boolean;
        activate(pipeline: RenderPipeline): void;
        render(camera: renderer.scene.Camera): void;
        destroy(): void;
    }
    /**
     * @en reflection probe render stage
     * @zh ̽Ⱦ׶Ρ
     */
    export class ReflectionProbeStage extends RenderStage {
        /**
         * @en A common initialization info for reflection probe render stage
         * @zh һͨõ reflection probe stage ĳʼϢ
         */
        static initInfo: __private._cocos_rendering_render_stage__IRenderStageInfo;
        /**
         * @en Sets the probe info
         * @zh probeϢ
         * @param probe
         * @param frameBuffer
         */
        setUsageInfo(probe: renderer.scene.ReflectionProbe, frameBuffer: gfx.Framebuffer): void;
        destroy(): void;
        clearFramebuffer(camera: renderer.scene.Camera): void;
        render(camera: renderer.scene.Camera): void;
        activate(pipeline: ForwardPipeline, flow: ReflectionProbeFlow): void;
    }
    export const getPhaseID: (phaseName: string | number) => number;
    export class ForwardPipelineBuilder implements rendering.PipelineBuilder {
        setup(cameras: renderer.scene.Camera[], ppl: rendering.BasicPipeline): void;
    }
    export class DeferredPipelineBuilder implements rendering.PipelineBuilder {
        setup(cameras: renderer.scene.Camera[], ppl: rendering.BasicPipeline): void;
    }
    /**
     * @zh
     * еĻڵ㣬У
     * * в㼶ϵ
     * * и
     * * άռ任ꡢתţϢ
     */
    /**
     * @en
     * Class of all entities in Cocos Creator scenes.
     * Basic functionalities include:
     * * Hierarchy management with parent and children
     * * Components management
     * * Coordinate system with position, scale, rotation in 3d space
     * @zh
     * Cocos Creator енڵࡣ
     * У
     * * в㼶ϵ
     * * и
     * * ά 3D ռ߱任ꡢתţϢ
     */
    export class Node extends CCObject implements ISchedulable, CustomSerializable {
        /**
         * @en Gets all components attached to this node.
         * @zh ȡӵ˽ڵ
         */
        get components(): ReadonlyArray<Component>;
        /**
         * @en If true, the node is an persist node which won't be destroyed during scene transition.
         * If false, the node will be destroyed automatically when loading a new scene. Default is false.
         * @zh Ϊtrueýڵһפڵ㣬ڳתڼ䱻١
         * Ϊfalseڵ㽫ڼ³ʱԶ١ĬΪ false
         * @default false
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _persistNode(): boolean;
        set _persistNode(value: boolean);
        /**
         * @en Name of node.
         * @zh ýڵơ
         */
        get name(): string;
        set name(value: string);
        /**
         * @en The uuid for editor, will be stripped after building project.
         * @zh Ҫڱ༭ uuidڱ༭¿ڳ־û洢Ŀ֮󽫱 id
         * @readOnly
         */
        get uuid(): string;
        /**
         * @en All children nodes.
         * @zh ڵӽڵ㡣
         * @readOnly
         */
        get children(): Node[];
        /**
         * @en
         * The local active state of this node.
         * Note that a Node may be inactive because a parent is not active, even if this returns true.
         * Use [[activeInHierarchy]]
         * if you want to check if the Node is actually treated as active in the scene.
         * @zh
         * ǰڵ״̬
         * ֵעǣһڵĸڵôʹΪȻ޷
         * ڵڳʵʵļ״̬ʹ [[activeInHierarchy]]
         * @default true
         */
        get active(): boolean;
        set active(isActive: boolean);
        /**
         * @en Indicates whether this node is active in the scene.
         * @zh ʾ˽ڵǷڳм
         */
        get activeInHierarchy(): boolean;
        /**
         * @en The parent node
         * @zh ڵ
         */
        get parent(): Node | null;
        set parent(value: Node | null);
        /**
         * @en Which scene this node belongs to.
         * @zh ˽ڵĸ
         * @readonly
         */
        get scene(): Scene;
        /**
         * @en The event processor of the current node, it provides EventTarget ability.
         * @zh ǰڵ¼ṩ EventTarget 
         * @readonly
         *
         * @deprecated since v3.4.0
         */
        get eventProcessor(): __private._cocos_scene_graph_node_event_processor__NodeEventProcessor;
        /**
         * @internal
         */
        protected static idGenerator: js.IDGenerator;
        /**
         * for walk
         * @internal
         */
        protected static _stacks: Array<Array<(Node | null)>>;
        /**
         * @internal
         */
        protected static _stackId: number;
        /**
         * Call `_updateScene` of specified node.
         * @internal
         * @param node The node.
         */
        protected static _setScene(node: Node): void;
        protected static _findComponent<T extends Component>(node: Node, constructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T | null;
        protected static _findComponents<T extends Component>(node: Node, constructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>, components: Component[]): void;
        protected static _findChildComponent<T extends Component>(children: Node[], constructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T | null;
        protected static _findChildComponents(children: Node[], constructor: any, components: any): void;
        protected _parent: this | null;
        protected _children: this[];
        protected _active: boolean;
        protected _components: Component[];
        /**
         * TODO(PP_Pro): this property should be exported to editor only, we should support editorOnly tag.
         * Tracking issue: https://github.com/cocos/cocos-engine/issues/14613
         */
        protected _prefab: Prefab._utils.PrefabInfo | null;
        protected _scene: Scene;
        protected _activeInHierarchy: boolean;
        protected _id: string;
        protected _name: string;
        protected _eventProcessor: __private._cocos_scene_graph_node_event_processor__NodeEventProcessor;
        protected _eventMask: number;
        protected _siblingIndex: number;
        /**
         * @en
         * record scene's id when set this node as persist node
         * @zh
         * ýڵΪפڵʱ¼ id
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _originalSceneId: string;
        /**
         * Set `_scene` field of this node.
         * The derived `Scene` overrides this method to behavior differently.
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        protected _updateScene(): void;
        /**
         * @en
         * Properties configuration function.
         * All properties in attrs will be set to the node,
         * when the setter of the node is available,
         * the property will be set via setter function.
         * @zh ú attrs ԽΪڵԡ
         * @param attrs - Properties to be set to node
         * @example
         * ```
         * var attrs = { name: 'New Name', active: false };
         * node.attr(attrs);
         * ```
         */
        attr(attrs: unknown): void;
        /**
         * @en Get parent of the node.
         * @zh ȡýڵĸڵ㡣
         */
        getParent(): Node | null;
        /**
         * @en Set parent of the node.
         * @zh øýڵĸڵ㡣
         * @param value Parent node
         * @param keepWorldTransform Whether keep node's current world transform unchanged after this operation
         */
        setParent(value: Node | null, keepWorldTransform?: boolean): void;
        /**
         * @en Returns a child with the same uuid.
         * @zh ͨ uuid ȡڵӽڵ㡣
         * @param uuid - The uuid to find the child node.
         * @return a Node whose uuid equals to the input parameter
         */
        getChildByUuid(uuid: string): Node | null;
        /**
         * @en Returns a child with the same name.
         * @zh ͨƻȡڵӽڵ㡣
         * @param name - A name to find the child node.
         * @return a CCNode object whose name equals to the input parameter
         * @example
         * ```
         * var child = node.getChildByName("Test Node");
         * ```
         */
        getChildByName(name: string): Node | null;
        /**
         * @en Returns a child with the given path.
         * @zh ͨ·ȡڵӽڵ㡣
         * @param path - A path to find the child node.
         * @return a Node object whose path equals to the input parameter
         * @example
         * ```
         * var child = node.getChildByPath("subNode/Test Node");
         * ```
         */
        getChildByPath(path: string): Node | null;
        /**
         * @en Add a child to the current node.
         * @zh һӽڵ㡣
         * @param child - the child node to be added
         */
        addChild(child: Node): void;
        /**
         * @en Inserts a child to the node at a specified index.
         * @zh ӽڵ㵽ָλ
         * @param child - the child node to be inserted
         * @param siblingIndex - the sibling index to place the child in
         * @example
         * ```
         * node.insertChild(child, 2);
         * ```
         */
        insertChild(child: Node, siblingIndex: number): void;
        /**
         * @en Get the sibling index of the current node in its parent's children array.
         * @zh ȡǰڵڸڵ children еλá
         */
        getSiblingIndex(): number;
        /**
         * @en Set the sibling index of the current node in its parent's children array.
         * @zh õǰڵڸڵ children еλá
         */
        setSiblingIndex(index: number): void;
        /**
         * @en Walk though the sub children tree of the current node.
         * Each node, including the current node, in the sub tree will be visited two times,
         * before all children and after all children.
         * This function call is not recursive, it's based on stack.
         * Please don't walk any other node inside the walk process.
         * @zh ýڵнڵ㲢ִлص
         * енڵ㣬ǰڵ㣬ִλصpreFunc ڷӽڵ֮ǰãpostFunc ڷӽڵ֮á
         * ʵֲǻڵݹģǻջչݹķʽ
         * 벻Ҫ walk жκĽڵǶִ walk
         * @param preFunc The callback to process node when reach the node for the first time
         * @param postFunc The callback to process node when re-visit the node after walked all children in its sub tree
         * @example
         * ```
         * node.walk(function (target) {
         *     console.log('Walked through node ' + target.name + ' for the first time');
         * }, function (target) {
         *     console.log('Walked through node ' + target.name + ' after walked all children in its sub tree');
         * });
         * ```
         */
        walk(preFunc: (target: this) => void, postFunc?: (target: this) => void): void;
        /**
         * @en
         * Remove itself from its parent node.
         * If the node have no parent, then nothing happens.
         * @zh
         * Ӹڵɾýڵ㡣
         * ڵһڵ㣬ôʲôᷢ
         */
        removeFromParent(): void;
        /**
         * @en Removes a child from the container.
         * @zh Ƴڵָӽڵ㡣
         * @param child - The child node which will be removed.
         */
        removeChild(child: this | Node): void;
        /**
         * @en Removes all children from the container.
         * @zh Ƴڵеӽڵ㡣
         */
        removeAllChildren(): void;
        /**
         * @en Is this node a child of the given node?
         * @zh Ƿָڵӽڵ㣿
         * @return True if this node is a child, deep child or identical to the given node.
         */
        isChildOf(parent: this | Scene | null): boolean;
        /**
         * @en
         * Returns the component of supplied type if the node has one attached, null if it doesn't.
         * You can also get component in the node by passing in the name of the script.
         * @zh
         * ȡڵָ͵ڵиָ͵򷵻أûΪա
         * Ҳǽűơ
         * @param classConstructor The class of the target component
         * @example
         * ```
         * // get sprite component.
         * var sprite = node.getComponent(Sprite);
         * ```
         */
        getComponent<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T | null;
        /**
         * @en
         * Returns the component of supplied type if the node has one attached, null if it doesn't.
         * You can also get component in the node by passing in the name of the script.
         * @zh
         * ȡڵָ͵ڵиָ͵򷵻أûΪա
         * Ҳǽűơ
         * @param className The class name of the target component
         * @example
         * ```
         * // get custom test class.
         * var test = node.getComponent("Test");
         * ```
         */
        getComponent(className: string): Component | null;
        /**
         * @en Returns all components of given type in the node.
         * @zh ؽڵָ͵
         * @param classConstructor The class of the target component
         */
        getComponents<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T[];
        /**
         * @en Returns all components of given type in the node.
         * @zh ؽڵָ͵
         * @param className The class name of the target component
         */
        getComponents(className: string): Component[];
        /**
         * @en Returns the component of given type in any of its children using depth first search.
         * @zh ݹӽڵеһƥָ͵
         * @param classConstructor The class of the target component
         * @example
         * ```
         * var sprite = node.getComponentInChildren(Sprite);
         * ```
         */
        getComponentInChildren<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T | null;
        /**
         * @en Returns the component of given type in any of its children using depth first search.
         * @zh ݹӽڵеһƥָ͵
         * @param className The class name of the target component
         * @example
         * ```
         * var Test = node.getComponentInChildren("Test");
         * ```
         */
        getComponentInChildren(className: string): Component | null;
        /**
         * @en Returns all components of given type in self or any of its children.
         * @zh ݹӽڵָ͵
         * @param classConstructor The class of the target component
         * @example
         * ```
         * var sprites = node.getComponentsInChildren(Sprite);
         * ```
         */
        getComponentsInChildren<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): T[];
        /**
         * @en Returns all components of given type in self or any of its children.
         * @zh ݹӽڵָ͵
         * @param className The class name of the target component
         * @example
         * ```
         * var tests = node.getComponentsInChildren("Test");
         * ```
         */
        getComponentsInChildren(className: string): Component[];
        /**
         * @en Adds a component class to the node. You can also add component to node by passing in the name of the script.
         * @zh ڵһָ͵࣬㻹ͨű
         * @param classConstructor The class of the component to add
         * @throws `TypeError` if the `classConstructor` does not specify a cc-class constructor extending the `Component`.
         * @example
         * ```
         * var sprite = node.addComponent(Sprite);
         * ```
         */
        addComponent<T extends Component>(classConstructor: __private.__types_globals__Constructor<T>): T;
        /**
         * @en Adds a component class to the node. You can also add component to node by passing in the name of the script.
         * @zh ڵһָ͵࣬㻹ͨű
         * @param className The class name of the component to add
         * @throws `TypeError` if the `className` does not specify a cc-class constructor extending the `Component`.
         * @example
         * ```
         * var test = node.addComponent("Test");
         * ```
         */
        addComponent(className: string): Component;
        /**
         * @en
         * Removes a component identified by the given name or removes the component object given.
         * You can also use component.destroy() if you already have the reference.
         * @zh
         * ɾڵϵָһ캯ҲѾõá
         * ѾãҲֱӵ component.destroy()
         * @param classConstructor The class of the component to remove
         * @deprecated please destroy the component to remove it.
         * @example
         * ```
         * node.removeComponent(Sprite);
         * ```
         */
        removeComponent<T extends Component>(classConstructor: __private.__types_globals__Constructor<T> | __private.__types_globals__AbstractedConstructor<T>): void;
        /**
         * @en
         * Removes a component identified by the given name or removes the component object given.
         * You can also use component.destroy() if you already have the reference.
         * @zh
         * ɾڵϵָһ캯ҲѾõá
         * ѾãҲֱӵ component.destroy()
         * @param classNameOrInstance The class name of the component to remove or the component instance to be removed
         * @deprecated please destroy the component to remove it.
         * @example
         * ```
         * import { Sprite } from 'cc';
         * const sprite = node.getComponent(Sprite);
         * if (sprite) {
         *     node.removeComponent(sprite);
         * }
         * node.removeComponent('Sprite');
         * ```
         */
        removeComponent(classNameOrInstance: string | Component): void;
        /**
         * @en
         * Register a callback of a specific event type on Node.
         * Use this method to register touch or mouse event permit propagation based on scene graph,
         * These kinds of event are triggered with dispatchEvent, the dispatch process has three steps:
         * 1. Capturing phase: dispatch in capture targets, e.g. parents in node tree, from root to the real target
         * 2. At target phase: dispatch to the listeners of the real target
         * 3. Bubbling phase: dispatch in bubble targets, e.g. parents in node tree, from the real target to root
         * In any moment of the dispatching process, it can be stopped via `event.stopPropagation()` or `event.stopPropagationImmediate()`.
         * You can also register custom event and use `emit` to trigger custom event on Node.
         * For such events, there won't be capturing and bubbling phase,
         * your event will be dispatched directly to its listeners registered on the same node.
         * You can also pass event callback parameters with `emit` by passing parameters after `type`.
         * @zh
         * ڽڵעָ͵ĻصҲ target ڰӦ this 
         * ¼ᱻϵͳ dispatchEvent Ĺ̰׶Σ
         * 1. ׶Σɷ¼Ŀ꣬磬ڵע˲׶εĸڵ㣬Ӹڵ㿪ʼɷֱĿڵ㡣
         * 2. Ŀ׶ΣɷĿڵļ
         * 3. ðݽ׶Σɷ¼ðĿ꣬磬ڵעðݽ׶εĸڵ㣬Ŀڵ㿪ʼɷֱڵ㡣
         * ͬʱԽ¼ɷڵͨ stopPropagation 
         * ҲעԶ¼ڵϣͨ emit ¼¼ᷢðݽ׶Σֱֻɷעڸýڵϵļ
         * ͨ emit ʱ type ֮󴫵ݶĲΪ¼صĲб
         * @param type - A string representing the event type to listen for.<br>See [[Node.EventType.POSITION_CHANGED]] for all builtin events.
         * @param callback - The callback that will be invoked when the event is dispatched.
         * The callback is ignored if it is a duplicate (the callbacks are unique).
         * @param target - The target (this object) to invoke the callback, can be null
         * @param useCapture - When set to true, the listener will be triggered at capturing phase which is ahead of the final target emit,
         * otherwise it will be triggered during bubbling phase.
         * @return - Just returns the incoming callback so you can save the anonymous function easier.
         * @example
         * ```ts
         * this.node.on(NodeEventType.TOUCH_START, this.memberFunction, this);  // if "this" is component and the "memberFunction" declared in CCClass.
         * node.on(NodeEventType.TOUCH_START, callback, this);
         * node.on(NodeEventType.TOUCH_MOVE, callback, this);
         * node.on(NodeEventType.TOUCH_END, callback, this);
         * ```
         */
        on(type: string | NodeEventType, callback: __private.__types_globals__AnyFunction, target?: unknown, useCapture?: any): void;
        /**
         * @en
         * Removes the callback previously registered with the same type, callback, target and or useCapture.
         * This method is merely an alias to removeEventListener.
         * @zh ɾ֮ǰͬͣصĿ useCapture עĻص
         * @param type - A string representing the event type being removed.
         * @param callback - The callback to remove.
         * @param target - The target (this object) to invoke the callback, if it's not given, only callback without target will be removed
         * @param useCapture - When set to true, the listener will be triggered at capturing phase
         * which is ahead of the final target emit, otherwise it will be triggered during bubbling phase.
         * @example
         * ```ts
         * this.node.off(NodeEventType.TOUCH_START, this.memberFunction, this);
         * node.off(NodeEventType.TOUCH_START, callback, this.node);
         * ```
         */
        off(type: string, callback?: __private.__types_globals__AnyFunction, target?: unknown, useCapture?: any): void;
        /**
         * @en
         * Register an callback of a specific event type on the Node,
         * the callback will remove itself after the first time it is triggered.
         * @zh
         * עڵض¼ͻصصڵһʱ䱻ɾ
         *
         * @param type - A string representing the event type to listen for.
         * @param callback - The callback that will be invoked when the event is dispatched.
         *                              The callback is ignored if it is a duplicate (the callbacks are unique).
         * @param target - The target (this object) to invoke the callback, can be null
         */
        once(type: string, callback: __private.__types_globals__AnyFunction, target?: unknown, useCapture?: any): void;
        /**
         * @en
         * Trigger an event directly with the event name and necessary arguments.
         * @zh
         * ͨ¼Զ¼
         * @param type - event type
         * @param arg1 - First argument in callback
         * @param arg2 - Second argument in callback
         * @param arg3 - Third argument in callback
         * @param arg4 - Fourth argument in callback
         * @param arg5 - Fifth argument in callback
         * @example
         * ```ts
         * eventTarget.emit('fire', event);
         * eventTarget.emit('fire', message, emitter);
         * ```
         */
        emit(type: string, arg0?: any, arg1?: any, arg2?: any, arg3?: any, arg4?: any): void;
        /**
         * @en
         * Dispatches an event into the event flow.
         * The event target is the EventTarget object upon which the dispatchEvent() method is called.
         * @zh ַ¼¼С
         * @param event - The Event object that is dispatched into the event flow
         */
        dispatchEvent(event: Event): void;
        /**
         * @en Checks whether the EventTarget object has any callback registered for a specific type of event.
         * @zh ¼ĿǷΪض͵¼עĻص
         * @param type - The type of event.
         * @param callback - The callback function of the event listener, if absent all event listeners for the given type will be removed
         * @param target - The callback callee of the event listener
         * @return True if a callback of the specified type is registered; false otherwise.
         */
        hasEventListener(type: string, callback?: __private.__types_globals__AnyFunction, target?: unknown): any;
        /**
         * @en Removes all callbacks previously registered with the same target.
         * @zh ƳĿϵע¼
         * @param target - The target to be searched for all related callbacks
         */
        targetOff(target: string | unknown): void;
        destroy(): boolean;
        /**
         * @en
         * Destroy all children from the node, and release all their own references to other objects.
         * Actual destruct operation will delayed until before rendering.
         * @zh
         * ӽڵ㣬ͷǶá
         * ʵٲӳٵǰ֡ȾǰִС
         */
        destroyAllChildren(): void;
        /**
         * Do remove component, only used internally.
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _removeComponent(component: Component): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _updateSiblingIndex(): void;
        protected _instantiate(cloned: any, isSyncedNode: any): any;
        protected _onHierarchyChangedBase(oldParent: this | null): void;
        protected _onPreDestroyBase(): boolean;
        protected _onSiblingIndexChanged?(siblingIndex: number): void;
        /**
         * @en
         * Ensures that this node has already had the specified component(s). If not, this method throws.
         * @zh
         * ڵѾӦûУ׳쳣
         * @param constructor Constructor of the component.
         * @throws If one or more component of same type have been existed in this node.
         */
        protected _checkMultipleComp?<T extends Component>(constructor: __private.__types_globals__Constructor<T>): void;
        /**
         * @en Event types emitted by Node
         * @zh ڵܷ¼
         */
        static EventType: typeof NodeEventType;
        /**
         * @en Coordinates space
         * @zh ռ任ϵ
         */
        static NodeSpace: typeof NodeSpace;
        /**
         * @en Bit masks for Node transformation parts
         * @zh ڵ任µľ岿
         * @deprecated please use [[Node.TransformBit]]
         */
        static TransformDirtyBit: typeof TransformBit;
        /**
         * @en Bit masks for Node transformation parts, can be used to determine which part changed in [[NodeEventType.TRANSFORM_CHANGED]] event
         * @zh ڵ任µľ岿֣ж [[NodeEventType.TRANSFORM_CHANGED]] ¼ľ
         */
        static TransformBit: typeof TransformBit;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        static reserveContentsForAllSyncablePrefabTag: symbol;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _uiProps: __private._cocos_scene_graph_node_ui_properties__NodeUIProperties;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _static: boolean;
        protected _lpos: math.Vec3;
        protected _lrot: math.Quat;
        protected _lscale: math.Vec3;
        protected _mobility: number;
        protected _layer: number;
        protected _euler: math.Vec3;
        protected _transformFlags: TransformBit;
        protected _eulerDirty: boolean;
        protected _flagChangeVersion: number;
        protected _hasChangedFlags: number;
        constructor(name?: string);
        /**
         * @en Determine whether the given object is a normal Node. Will return false if [[Scene]] given.
         * @zh ָǷͨĽڵ㣿 [[Scene]] ᷵ false
         */
        static isNode(obj: unknown): obj is Node;
        protected _onPreDestroy(): boolean;
        /**
         * @en Position in local coordinate system
         * @zh ϵµ
         */
        get position(): Readonly<math.Vec3>;
        set position(val: Readonly<math.Vec3>);
        /**
         * @en Position in world coordinate system
         * @zh ϵµ
         */
        get worldPosition(): Readonly<math.Vec3>;
        set worldPosition(val: Readonly<math.Vec3>);
        /**
         * @en Rotation in local coordinate system, represented by a quaternion
         * @zh ϵµתԪʾ
         */
        get rotation(): Readonly<math.Quat>;
        set rotation(val: Readonly<math.Quat>);
        /**
         * @en Rotation in local coordinate system, represented by euler angles
         * @zh ϵµתŷǱʾ
         */
        set eulerAngles(val: Readonly<math.Vec3>);
        get eulerAngles(): Readonly<math.Vec3>;
        /**
         * @en Rotation in local coordinate system, represented by euler angles, but limited on z axis
         * @zh ϵµתŷǱʾ޶ z ϡ
         */
        get angle(): number;
        set angle(val: number);
        /**
         * @en Rotation in world coordinate system, represented by a quaternion
         * @zh ϵµתԪʾ
         */
        get worldRotation(): Readonly<math.Quat>;
        set worldRotation(val: Readonly<math.Quat>);
        /**
         * @en Scale in local coordinate system
         * @zh ϵµ
         */
        get scale(): Readonly<math.Vec3>;
        set scale(val: Readonly<math.Vec3>);
        /**
         * @en Scale in world coordinate system
         * @zh ϵµ
         */
        get worldScale(): Readonly<math.Vec3>;
        set worldScale(val: Readonly<math.Vec3>);
        /**
         * @en Local transformation matrix
         * @zh ϵ任
         */
        set matrix(val: Readonly<math.Mat4>);
        /**
         * @en World transformation matrix
         * @zh ϵ任
         */
        get worldMatrix(): Readonly<math.Mat4>;
        /**
         * @en The vector representing forward direction in local coordinate system, it's the minus z direction by default
         * @zh ǰڵǰĬǰΪ -z 
         */
        get forward(): math.Vec3;
        set forward(dir: math.Vec3);
        /**
         * @en Return the up direction vertor of this node in world space.
         * @zh صǰڵռгϵķ
         */
        get up(): math.Vec3;
        /**
         * @en Return the right direction vector of this node in world space.
         * @zh صǰڵռгҵķ
         */
        get right(): math.Vec3;
        set mobility(m: number);
        get mobility(): number;
        /**
         * @en Layer of the current Node, it affects raycast, physics etc, refer to [[Layers]]
         * @zh ڵ㣬ҪӰ߼⡢ײȣο [[Layers]]
         */
        set layer(l: number);
        get layer(): number;
        /**
         * @en Whether the node's transformation have changed during the current frame.
         * @zh ڵĿռ任Ϣڵǰ֡Ƿб
         */
        get hasChangedFlags(): number;
        set hasChangedFlags(val: number);
        /**
         * @internal
         */
        [serializeTag](serializationOutput: SerializationOutput, context: SerializationContext): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _onSetParent(oldParent: this | null, keepWorldTransform?: boolean): void;
        protected _onHierarchyChanged(oldParent: this | null): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _onBatchCreated(dontSyncChildPrefab: boolean): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _onBeforeSerialize(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _onPostActivated(active: boolean): void;
        /**
         * @en Perform a translation on the node
         * @zh ƶڵ
         * @param trans The increment on position
         * @param ns The operation coordinate space
         */
        translate(trans: math.Vec3, ns?: NodeSpace): void;
        /**
         * @en Perform a rotation on the node
         * @zh תڵ
         * @param rot The increment on rotation
         * @param ns The operation coordinate space
         */
        rotate(rot: math.Quat, ns?: NodeSpace): void;
        /**
         * @en Set the orientation of the node to face the target position, the node is facing minus z direction by default
         * @zh õǰڵתΪĿλãĬǰΪ -z 
         * @param pos Target position
         * @param up Up direction
         */
        lookAt(pos: Readonly<math.Vec3>, up?: Readonly<math.Vec3>): void;
        /**
         * @en Invalidate the world transform information
         * for this node and all its children recursively
         * @zh ݹǽڵ任Ϊ dirty
         * @param dirtyBit The dirty bits to setup to children, can be composed with multiple dirty bits
         */
        invalidateChildren(dirtyBit: TransformBit): void;
        /**
         * @en Update the world transform information if outdated
         * @zh ½ڵ任Ϣ
         */
        updateWorldTransform(): void;
        /**
         * @en Set position in local coordinate system
         * @zh ñ
         * @param position Target position
         */
        setPosition(position: Readonly<math.Vec3>): void;
        /**
         * @en Set position in local coordinate system
         * @zh ñ
         * @param x X axis position
         * @param y Y axis position
         * @param z Z axis position
         */
        setPosition(x: number, y: number, z?: number): void;
        /**
         * @en Get position in local coordinate system, please try to pass `out` vector and reuse it to avoid garbage.
         * @zh ȡ꣬ע⣬ܴݸõ [[Vec3]] Ա
         * @param out Set the result to out vector
         * @return If `out` given, the return value equals to `out`, otherwise a new vector will be generated and return
         */
        getPosition(out?: math.Vec3): math.Vec3;
        /**
         * @en Set rotation in local coordinate system with a quaternion representing the rotation.
         * Please make sure the rotation is normalized.
         * @zh Ԫñת, ȷõԪѹһ
         * @param rotation Rotation in quaternion
         */
        setRotation(rotation: Readonly<math.Quat>): void;
        /**
         * @en Set rotation in local coordinate system with a quaternion representing the rotation.
         * Please make sure the rotation is normalized.
         * @zh Ԫñת, ȷõԪѹһ
         * @param x X value in quaternion
         * @param y Y value in quaternion
         * @param z Z value in quaternion
         * @param w W value in quaternion
         */
        setRotation(x: number, y: number, z: number, w: number): void;
        /**
         * @en Set rotation in local coordinate system with a vector representing euler angles
         * @zh ŷñת
         * @param rotation Rotation in vector
         */
        setRotationFromEuler(rotation: math.Vec3): void;
        /**
         * @en Set rotation in local coordinate system with euler angles
         * @zh ŷñת
         * @param x X axis rotation
         * @param y Y axis rotation
         * @param z Z axis rotation
         */
        setRotationFromEuler(x: number, y: number, zOpt?: number): void;
        /**
         * @en Get rotation as quaternion in local coordinate system, please try to pass `out` quaternion and reuse it to avoid garbage.
         * @zh ȡתע⣬ܴݸõ [[Quat]] Ա
         * @param out Set the result to out quaternion
         * @return If `out` given, the return value equals to `out`, otherwise a new quaternion will be generated and return
         */
        getRotation(out?: math.Quat): math.Quat;
        /**
         * @en Set scale in local coordinate system
         * @zh ñ
         * @param scale Target scale
         */
        setScale(scale: Readonly<math.Vec3>): void;
        /**
         * @en Set scale in local coordinate system
         * @zh ñ
         * @param x X axis scale
         * @param y Y axis scale
         * @param z Z axis scale
         */
        setScale(x: number, y: number, z?: number): void;
        /**
         * @en Get scale in local coordinate system, please try to pass `out` vector and reuse it to avoid garbage.
         * @zh ȡţע⣬ܴݸõ [[Vec3]] Ա
         * @param out Set the result to out vector
         * @return If `out` given, the return value equals to `out`, otherwise a new vector will be generated and return
         */
        getScale(out?: math.Vec3): math.Vec3;
        /**
         * @en Inversely transform a point from world coordinate system to local coordinate system.
         * @zh 任һռ㣬һڽתϵС
         * @param out The result point in local coordinate system will be stored in this vector
         * @param p A position in world coordinate system
         */
        inverseTransformPoint(out: math.Vec3, p: math.Vec3): math.Vec3;
        /**
         * @en Set position in world coordinate system
         * @zh 
         * @param position Target position
         */
        setWorldPosition(position: math.Vec3): void;
        /**
         * @en Set position in world coordinate system
         * @zh 
         * @param x X axis position
         * @param y Y axis position
         * @param z Z axis position
         */
        setWorldPosition(x: number, y: number, z: number): void;
        /**
         * @en Get position in world coordinate system, please try to pass `out` vector and reuse it to avoid garbage.
         * @zh ȡ꣬ע⣬ܴݸõ [[Vec3]] Ա
         * @param out Set the result to out vector
         * @return If `out` given, the return value equals to `out`, otherwise a new vector will be generated and return
         */
        getWorldPosition(out?: math.Vec3): math.Vec3;
        /**
         * @en Set rotation in world coordinate system with a quaternion representing the rotation
         * @zh Ԫϵµת
         * @param rotation Rotation in quaternion
         */
        setWorldRotation(rotation: math.Quat): void;
        /**
         * @en Set rotation in world coordinate system with a quaternion representing the rotation
         * @zh Ԫϵµת
         * @param x X value in quaternion
         * @param y Y value in quaternion
         * @param z Z value in quaternion
         * @param w W value in quaternion
         */
        setWorldRotation(x: number, y: number, z: number, w: number): void;
        /**
         * @en Set rotation in world coordinate system with euler angles
         * @zh ŷϵµת
         * @param x X axis rotation
         * @param y Y axis rotation
         * @param z Z axis rotation
         */
        setWorldRotationFromEuler(x: number, y: number, z: number): void;
        /**
         * @en Get rotation as quaternion in world coordinate system, please try to pass `out` quaternion and reuse it to avoid garbage.
         * @zh ȡϵµתע⣬ܴݸõ [[Quat]] Ա
         * @param out Set the result to out quaternion
         * @return If `out` given, the return value equals to `out`, otherwise a new quaternion will be generated and return
         */
        getWorldRotation(out?: math.Quat): math.Quat;
        /**
         * @en Set scale in world coordinate system
         * @zh ϵµ
         * @param scale Target scale
         */
        setWorldScale(scale: math.Vec3): void;
        /**
         * @en Set scale in world coordinate system
         * @zh ϵµ
         * @param x X axis scale
         * @param y Y axis scale
         * @param z Z axis scale
         */
        setWorldScale(x: number, y: number, z: number): void;
        /**
         * @en Get scale in world coordinate system, please try to pass `out` vector and reuse it to avoid garbage.
         * @zh ȡţע⣬ܴݸõ [[Vec3]] Ա
         * @param out Set the result to out vector
         * @return If `out` given, the return value equals to `out`, otherwise a new vector will be generated and return
         */
        getWorldScale(out?: math.Vec3): math.Vec3;
        /**
         * @en Get a world transform matrix
         * @zh ȡ任
         * @param out Set the result to out matrix
         * @return If `out` given, the return value equals to `out`, otherwise a new matrix will be generated and return
         */
        getWorldMatrix(out?: math.Mat4): math.Mat4;
        /**
         * @en Get a world transform matrix with only rotation and scale
         * @zh ȡֻתŵ任
         * @param out Set the result to out matrix
         * @return If `out` given, the return value equals to `out`, otherwise a new matrix will be generated and return
         */
        getWorldRS(out?: math.Mat4): math.Mat4;
        /**
         * @en Get a world transform matrix with only rotation and translation
         * @zh ȡֻתλƵ任
         * @param out Set the result to out matrix
         * @return If `out` given, the return value equals to `out`, otherwise a new matrix will be generated and return
         */
        getWorldRT(out?: math.Mat4): math.Mat4;
        /**
         * @en Set local transformation with rotation, position and scale separately.
         * @zh һоֲ任ƽơתţϢ
         * @param rot The rotation
         * @param pos The position
         * @param scale The scale
         */
        setRTS(rot?: math.Quat | math.Vec3, pos?: math.Vec3, scale?: math.Vec3): void;
        /**
         * @en Does the world transform information of this node need to be updated?
         * @zh ڵĿռ任ϢǷҪ£
         */
        isTransformDirty(): boolean;
        /**
         * @en
         * Pause all system events which is dispatched by [[SystemEvent]].
         * If recursive is set to true, then this API will pause the node system events for the node and all nodes in its sub node tree.
         * @zh
         * ͣ [[SystemEvent]] ɷϵͳ¼
         *  recursive Ϊ trueô API ͣڵнڵĽڵϵͳ¼
         *
         * @param recursive Whether pause system events recursively for the child node tree
         */
        pauseSystemEvents(recursive: boolean): void;
        /**
         * @en
         * Resume all paused system events which is dispatched by [[SystemEvent]].
         * If recursive is set to true, then this API will resume the node system events for the node and all nodes in its sub node tree.
         *
         * @zh
         * ָ [[SystemEvent]] ɷϵͳ¼
         *  recursive Ϊ trueô API ָڵнڵĽڵϵͳ¼
         *
         * @param recursive Whether resume system events recursively for the child node tree
         */
        resumeSystemEvents(recursive: boolean): void;
        /**
         * @en
         * clear all node dirty state.
         * @zh
         * нڵǡ
         */
        static resetHasChangedFlags(): void;
        /**
         * @en
         * clear node array
         * @zh
         * ڵ
         */
        static clearNodeArray(): void;
        /**
         * @en
         * Get the complete path of the current node in the hierarchy.
         *
         * @zh
         * õǰڵ hierarchy е·
         */
        getPathInHierarchy(): string;
    }
    /**
     * @en
     * Scene is a subclass of [[Node]], composed by nodes, representing the root of a runnable environment in the game.
     * It's managed by [[Director]] and user can switch from a scene to another using [[Director.loadScene]]
     * @zh
     * Scene  [[Node]] ࣬ɽڵɣϷпеĳһ廷
     *  [[Director]] ûʹ [[Director.loadScene]] л
     */
    export class Scene extends Node {
        /**
         * @en The renderer scene, normally user don't need to use it
         * @zh Ⱦ㳡һûҪ
         */
        get renderScene(): renderer.RenderScene | null;
        get globals(): SceneGlobals;
        /**
         * @en Indicates whether all (directly or indirectly) static referenced assets of this scene are releasable by default after scene unloading.
         * @zh ָʾóֱӻӾ̬õԴǷĬڳлԶͷš
         */
        autoReleaseAssets: boolean;
        /**
         * @en Per-scene level rendering info
         * @zh ȾϢ
         *
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _globals: SceneGlobals;
        dependAssets: null;
        protected _renderScene: renderer.RenderScene | null;
        protected _inited: boolean;
        protected _prefabSyncedInLiveReload: boolean;
        protected _updateScene(): void;
        constructor(name: string);
        /**
         * @en Destroy the current scene and all its nodes, this action won't destroy related assets
         * @zh ٵǰенڵ㣬Դ
         */
        destroy(): boolean;
        /**
         * @en Only for compatibility purpose, user should not add any component to the scene
         * @zh ΪԱûӦڳֱκ
         */
        addComponent(...args: any[]): Component;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _onHierarchyChanged(): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _onPostActivated(active: boolean): void;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _onBatchCreated(dontSyncChildPrefab: boolean): void;
        /**
         * @en
         * Refer to [[Node.updateWorldTransform]]
         * @zh
         * ο [[Node.updateWorldTransform]]
         */
        updateWorldTransform(): void;
        protected _instantiate(): void;
    }
    /**
     * @zh ڵݷʽ洢 [[Node.layer]] У߼⡢ײûԶű߼
     * ÿڵһ㣬ͨ ʽ  ųʽ ּв⡣
     * @en Node's layer manager, it's stored as bit mask data in [[Node.layer]].
     * Layer information is widely used in raycast, physics and user logic.
     * Every node can be assigned to multiple layers with different bit masks, you can setup layer with inclusive or exclusive operation.
     */
    export class Layers {
        /**
         * @en All layers in an Enum
         * @zh  Enum ʽڵвб
         */
        static Enum: {
            NONE: number;
            IGNORE_RAYCAST: number;
            GIZMOS: number;
            EDITOR: number;
            UI_3D: number;
            SCENE_GIZMO: number;
            UI_2D: number;
            PROFILER: number;
            DEFAULT: number;
            ALL: number;
        };
        /**
         * @en All layers in [[BitMask]] type
         * @zh в [[BitMask]]
         */
        static BitMask: {
            NONE: number;
            IGNORE_RAYCAST: number;
            GIZMOS: number;
            EDITOR: number;
            UI_3D: number;
            SCENE_GIZMO: number;
            UI_2D: number;
            PROFILER: number;
            DEFAULT: number;
            ALL: number;
        };
        /**
         * @internal
         */
        static init(): void;
        /**
         * @en
         * Make a layer mask accepting nothing but the listed layers
         * @zh
         * һʽֻбеĲ
         * @param includes All accepted layers
         * @return A filter which can detect all accepted layers
         */
        static makeMaskInclude(includes: number[]): number;
        /**
         * @en
         * Make a layer mask accepting everything but the listed layers
         * @zh
         * һųʽֻܾбеĲ
         * @param excludes All excluded layers
         * @return A filter which can detect for excluded layers
         */
        static makeMaskExclude(excludes: number[]): number;
        /**
         * @zh һ²㣬ûɱ༭ 0 - 19 λΪûԶ
         * @en Add a new layer, user can use layers from bit position 0 to 19, other bits are reserved.
         * @param name Layer's name
         * @param bitNum Layer's bit position
         */
        static addLayer(name: string, bitNum: number): void;
        /**
         * @en Remove a layer, user can remove layers from bit position 0 to 19, other bits are reserved.
         * @zh Ƴһ㣬ûɱ༭ 0 - 19 λΪûԶ
         * @param bitNum Layer's bit position
         */
        static deleteLayer(bitNum: number): void;
        /**
         * @en Given a layer name, returns the layer index as defined by either a Builtin or a User Layer in the Tags and Layers manager.
         * @zh ƣɱǺͲеòû㶨Ĳ
         * @param name layer's name
         */
        static nameToLayer(name: string): number;
        /**
         * @en Given a layer number, returns the name of the layer as defined in either a Builtin or a User Layer in the Tags and Layers manager.
         * @zh ڱǺͲеòûжĲơ
         * @param bitNum layer's value
         */
        static layerToName(bitNum: number): string;
    }
    export namespace Layers {
        export type Enum = __private.__types_globals__EnumAlias<typeof Layers.Enum>;
        export type BitMask = __private.__types_globals__EnumAlias<typeof Layers.BitMask>;
    }
    /**
     * @en
     * The EventHandler class sets the event callback in the scene.
     * This class allows the user to set the callback target node, target component name, component method name, and call the target method through the `emit` method.
     * @zh
     * EventHandler óе¼صûûصĿڵ㣬Ŀͨ emit Ŀ꺯
     *
     * @example
     * ```ts
     * // Let's say we have a MainMenu component on newTarget
     * // file: MainMenu.ts
     * @ccclass('MainMenu')
     * export class MainMenu extends Component {
     *     // sender: the node MainMenu.ts belongs to
     *     // eventType: CustomEventData
     *     onClick (sender, eventType) {
     *         cc.log('click');
     *     }
     * }
     *
     * import { Component } from 'cc';
     * const eventHandler = new Component.EventHandler();
     * eventHandler.target = newTarget;
     * eventHandler.component = "MainMenu";
     * eventHandler.handler = "OnClick";
     * eventHandler.customEventData = "my data";
     * ```
     */
    export class EventHandler {
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _componentName(): any;
        set _componentName(value: any);
        /**
         * @en
         * Dispatching component events.
         * @zh
         * ¼ɷ
         *
         * @param events - The event list to be emitted
         * @param args - The callback arguments
         */
        static emitEvents(events: EventHandler[], ...args: any[]): void;
        /**
         * @en
         * The node that contains target component
         * @zh
         * ¼Ӧͺڽڵ
         */
        target: Node | null;
        /**
         * @en
         * The name of the component(script) that contains target callback, such as the name 'MainMenu' of the script in the example
         * @zh
         * ¼Ӧű, еĽű 'MainMenu'
         */
        component: string;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        _componentId: string;
        /**
         * @en
         * Event handler, such as the callback function name 'onClick' in the example
         * @zh
         * Ӧ¼е 'onClick' 
         */
        handler: string;
        /**
         * @en
         * Custom Event Data
         * @zh
         * Զ¼
         */
        customEventData: string;
        /**
         * @en Trigger the target callback with given arguments
         * @zh Ŀϵָ handler ѡ񴫵ݲ
         * @param params - The arguments for invoking the callback
         * @example
         * ```ts
         * import { Component } from 'cc';
         * const eventHandler = new Component.EventHandler();
         * eventHandler.target = newTarget;
         * eventHandler.component = "MainMenu";
         * eventHandler.handler = "OnClick"
         * eventHandler.emit(["param1", "param2", ....]);
         * ```
         */
        emit(params: any[]): void;
    }
    /**
     * @en
     * Base class for everything attached to Node(Entity).<br/>
     * <br/>
     * NOTE: Not allowed to use construction parameters for Component's subclasses,
     *       because Component is created by the engine.
     * @zh
     * иӵڵĻࡣ<br/>
     * <br/>
     * ע⣺ʹ๹Ϊ洴ġ
     */
    export class Component extends CCObject {
        static EventHandler: typeof EventHandler;
        get name(): string;
        set name(value: string);
        /**
         * @en The uuid for editor.
         * @zh  uuidڱ༭
         * @readOnly
         * @example
         * ```ts
         * import { log } from 'cc';
         * log(comp.uuid);
         * ```
         */
        get uuid(): string;
        /**
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get __scriptAsset(): null;
        /**
         * @en Indicates whether this component is enabled or not.
         * @zh ʾǷá
         * @default true
         * @example
         * ```ts
         * import { log } from 'cc';
         * comp.enabled = true;
         * log(comp.enabled);
         * ```
         */
        get enabled(): boolean;
        set enabled(value: boolean);
        /**
         * @en Indicates whether this component is enabled and its node is also active in the hierarchy.
         * @zh ʾǷòڵĽڵҲڼ״̬
         * @readOnly
         * @example
         * ```ts
         * import { log } from 'cc';
         * log(comp.enabledInHierarchy);
         * ```
         */
        get enabledInHierarchy(): boolean;
        /**
         * @en Returns a value which used to indicate the onLoad get called or not.
         * @zh һֵж onLoad Ƿ񱻵ù 0 ʱù 0 ʱδá
         * @readOnly
         * @example
         * ```ts
         * import { log } from 'cc';
         * log(this._isOnLoadCalled > 0);
         * ```
         *
         * @deprecated since v3.5.0, this is an engine private interface that will be removed in the future.
         */
        get _isOnLoad