import { _decorator, Component, Node, view, Widget, UITransform, UIOpacity, Label, Color, find, Prefab, instantiate } from 'cc';
import Scene from "db://assets/Module/Scene";
import { changeScene } from "db://assets/Module/UIFast";
import { ScrollList, SCROLL_VERTICAL } from "../ScrollList/ScrollList";
import { LOG_TYPE, sendLog, sendWebNet, WebNetName } from '../Utils/WebNet/WebNet';
import { HomeScene } from './HomeScene';
const { ccclass, property } = _decorator;

const MD_MAP = {
  1: 33,
  2: 34
}

@ccclass("RecordScene")
export class RecordScene extends Scene {
  static skin: string = "RecordScene";
  static group: string[] = ["RecordScene"];

  /** 明细页类别 */
  private _type: string = "1";

  get type() {
    return this._type;
  }

  set type(type: string) {
    this._type = type;
  }

  @property({ type: ScrollList, tooltip: "竖行滚动容器" })
  private vScroll: ScrollList;

  @property(Node)
  RecordBox: Node = null;

  @property(Prefab)
  tips: Prefab = null;

  start() {
    this.setRecordBoxHeight();
    this.getCountRecordInfo();
  }

  /** 获取次数明细 */
  async getCountRecordInfo() {
    sendLog(LOG_TYPE.EXPOSURE, 33)
    const res = await sendWebNet(WebNetName.changeDetails);
    if (res?.success) {
      this.recordRender(res?.data || []);
    }
  }

  /** 获取游戏记录 */
  async getGameRecordInfo() {
    sendLog(LOG_TYPE.EXPOSURE, 34);
    const res = await sendWebNet(WebNetName.gameRecord);
    if (res?.success) {
      this.recordRender(res?.data || []);
    }
  }

  /** 明细区域获取 */
  setRecordBoxHeight() {
    const rankCanvas = view.getVisibleSize();
    let rankWidthX = rankCanvas.width;
    let rankHeightX = rankCanvas.height;
    /** 滚动区域前的内容高度 */
    const tab = this.node.getChildByName("TabGroup");
    let topHeight =
      tab.getComponent(Widget).top + tab.getComponent(UITransform).height + 100;
    /** 可滚动区域 */
    const recordListHeight = Math.max(rankHeightX - topHeight, 200);
    const recordList = this.node.getChildByName("ScrollView");
    const viewContent = recordList.getChildByName("view");
    viewContent.getComponent(UITransform).height = recordListHeight;
    recordList.getComponent(UITransform).height = recordListHeight;
    console.log("scrollView高度: ", recordListHeight);
  }

  /** 明细渲染 */
  recordRender(recordInfo = []) {
    this.vScroll.setDataList(recordInfo, SCROLL_VERTICAL, [0, 0, 0]);
    this.vScroll.scrollToTop(0);
    if (recordInfo.length <= 0) {
      this.node.getChildByName("Empty").getComponent(UIOpacity).opacity = 255;
    } else {
      this.node.getChildByName("Empty").getComponent(UIOpacity).opacity = 0;
    }
  }

  /** 切换tab */
  handleClickTab(event, data) {
    this.type = data;
    sendLog(LOG_TYPE.CLICK, MD_MAP[this.type])
    if (data == "1") {
      this.RecordBox.getChildByName("CountBg").getComponent(
        UIOpacity
      ).opacity = 255;
      this.RecordBox.getChildByName("GameBg").getComponent(
        UIOpacity
      ).opacity = 0;
      this.getCountRecordInfo();
    } else if (data == "2") {
      this.RecordBox.getChildByName("CountBg").getComponent(
        UIOpacity
      ).opacity = 0;
      this.RecordBox.getChildByName("GameBg").getComponent(
        UIOpacity
      ).opacity = 255;
      this.getGameRecordInfo();
    }
  }

  /** 返回首页 */
  handleClickBackBtn() {
    changeScene(HomeScene);
  }

  update(deltaTime: number) {}
}

