import { _decorator, Component, Node, Button, Label } from 'cc';
import Panel from '../../Module/Panel';
import { LOG_TYPE, sendLog } from '../Utils/WebNet/WebNet';
const { ccclass, property } = _decorator;

@ccclass("NoGetRankPrizePanel")
export class NoGetRankPrizePanel extends Panel {
  static bundle: string = "";
  static skin = "NoGetRankPrizePanel";
  static group = "NoGetRankPrizePanel";

  /** 关闭按钮 */
  @property(Node)
  closeBtn: Node = null;
  /** 我知道了 */
  @property(Node)
  mainBtn: Node = null;
  /** 排名 */
  @property(Node)
  rankIndex: Node = null;

  start() {
    sendLog(LOG_TYPE.EXPOSURE, 32);
    this.mainBtn.on(Button.EventType.CLICK, this.closePannel, this);
    this.closeBtn.on(Button.EventType.CLICK, this.closePannel, this);
    this.pannelRender();
  }

  /** 渲染 */
  async pannelRender() {
    this.rankIndex.getComponent(Label).string = `最终排名为${this.data?.rank}`;
  }

  /** 关闭弹窗 */
  closePannel() {
    sendLog(LOG_TYPE.CLICK, 32);
    this.hidePanel();
  }
}

