import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Sprite, UITransform, view } from "cc";
import { getWebData, WebNetName } from "../Utils/WebNet/WebNet";
import { loadImg, randomNum } from "../Utils/Utils";


const { ccclass, property } = _decorator;

@ccclass('BrowseImgPanel')
export default class BrowseImgPanel extends Panel {

    static skin = "BrowseImgPanel";
    static group = "BrowseImgPanel";

    @property(Sprite)
    img: Sprite = null;

    @property(Label)
    cdText: Label = null;

    cdNum: number = 15

    async start() {
        this.view["doneBtn"].active = false
        this.view["cdBox"].active = true
        // 获取随机长图
        const { taskBrowseImgs } = getWebData(WebNetName.getFrontVariable).data || {}
        const randomImg = taskBrowseImgs[randomNum(0, taskBrowseImgs.length)]?.image
        if (randomImg) {
            const res = await loadImg(randomImg, this.img.getComponent(UITransform).width);
            this.img.spriteFrame = res?.spriteFrame
            const {width, height} = res.spriteFrame;

            const _h = 750 / width * height;

            this.img.getComponent(UITransform).setContentSize(750, _h);

        }
        // 图片区域获取
        this.view['ScrollView/view/content'].getComponent(UITransform).height = this.img.getComponent(UITransform).height;
        // 倒计时
        this.startCd()

        this.view["back"].on(Button.EventType.CLICK, this.backHandle, this);
        this.view["doneBtn"].on(Button.EventType.CLICK, this.backHandle, this);
    }

    /** 开始倒计时 */
    startCd() {
        console.info('this.cdNum', this.cdNum);
        if (this.cdNum > 0) {
            this.scheduleOnce(() => {
                this.cdNum--
                this.cdText.string = `${this.cdNum}s`
                this.startCd()
            }, 1);
        } else {
            this.view["doneBtn"].active = true
            this.view["cdBox"].active = false
            this.data.doneFun?.();
        }
    }

    /** 返回 */
    async backHandle() {
        this.hidePanel()
    }

}
