import mobx from "mobx";
import {sendWebNet, WebNetName} from "db://assets/Scripts/Utils/WebNet/WebNet";

const {makeAutoObservable} = mobx;

class Store {
    frontVariable: {
        value: number;
    } = {
        value: 1,
    }

    img = "//yun.duiba.com.cn/polaris/baner2img.189c7e28f22607844fe3c250877ec42b95f97ca6.png";

    index = 0;

    homeInfo: {
        remainGameTime?: number;
        boolDayPlayLimit?: boolean;
    } = {}

    async updateHome() {
        const {success, data} = await sendWebNet(WebNetName.index);
        if (!success) {
            return;
        }
        this.homeInfo = data;
    }
}

const store: Store = makeAutoObservable(new Store());

export default store;