import { _decorator, Label, Node, view, Widget, UITransform, Prefab, instantiate, assetManager, ImageAsset, SpriteFrame, Texture2D, Sprite, UIOpacity } from "cc";
import Scene from "db://assets/Module/Scene";
import { changeScene } from "db://assets/Module/UIFast";
import { HomeScene } from "./HomeScene";
import { ScrollList, SCROLL_VERTICAL } from "../ScrollList/ScrollList";
import { loadImg, strFormat } from "../Utils/Utils";
import { LOG_TYPE, sendLog, sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";
const { ccclass, property } = _decorator;

const MD_MAP = {
  1: 30,
  2: 29
}

@ccclass("RankScene")
export class RankScene extends Scene {

  static skin: string = "RankScene";
  static group: string[] = ["RankScene"];

  @property({ type: ScrollList, tooltip: "竖行滚动容器" })
  private vScroll: ScrollList;

  /** 排行榜类别 */
  private _type: string = "2";

  get type() {
    return this._type;
  }

  set type(type: string) {
    this._type = type;
  }

  /** 我的排名 */
  @property(Node)
  myRnak: Node = null;

  /** 奖品展览区域 */
  @property(Node)
  prizeBox: Node = null;

  /** 奖品对象 */
  @property(Prefab)
  prizeItem: Prefab = null;

  /** 奖品对象 */
  @property(Node)
  tabGroup: Node = null;

  onLoad() {
    this.setRankBoxHeight();
  }

  start() {
    console.log("%c RankScene", "font-size: 20px");
    this.getRankInfo();
  }

  /** 排名处理 */
  rankIndexFormat(rank) {
    if (rank == 0 || !!!rank) {
      return "999+";
    }
    if (rank == -1) {
      return "999+"
    }
    return rank;
  }

  /** 获取排行榜首页信息 */
  async getRankInfo() {
    sendLog(LOG_TYPE.EXPOSURE, MD_MAP[this.type]);
    const res = await sendWebNet(WebNetName.rank, {type: this.type});
    const { success, data } = res;
    const { myRank, myRankScore, myNickName, rankInfo = [], prizeInfo = [] } = data || {};
    if (success) {
      /** 我的排名 - 更新 */
      this.myRnak.getChildByName("MyRankIndex").getComponent(Label).string = `${this.rankIndexFormat(myRank)}`;
      this.myRnak.getChildByName("MyCredits").getComponent(Label).string = `${myRankScore > 99999? "99999+": myRankScore}`;
      this.myRnak.getChildByName("MyName").getComponent(Label).string = `${strFormat(myNickName || "", 12)}(我)`;
      /** 排行榜渲染 */
      this.rankRender(rankInfo);
      /** 奖品区域渲染 */
      this.prizeRender(prizeInfo);
    }
  }

  /** 排行榜区域获取 */
  setRankBoxHeight () {
    const rankCanvas = view.getVisibleSize();
    let rankWidthX = rankCanvas.width;
    let rankHeightX = rankCanvas.height;
    /** 滚动区域前的内容高度 */
    const label = this.node.getChildByName("Label");
    let topHeight = label.getComponent(Widget).top + label.getComponent(UITransform).height / 2;
    /** 滚动区域后的内容高度 */
    const myRank = this.node.getChildByName("MyRank");
    const BottomHeight = myRank.getComponent(UITransform).height - 30;
    /** 可滚动区域 */
    const rankListHeight = Math.max(rankHeightX - topHeight - BottomHeight, 200);
    const rankList = this.node.getChildByName("ScrollView");
    const viewContent = rankList.getChildByName("view")
    viewContent.getComponent(UITransform).height = rankListHeight;
    rankList.getComponent(UITransform).height = rankListHeight;
    console.log("scrollView高度: ", rankListHeight, rankList.getComponent(UITransform).height);
  }

  /** 排行榜渲染 */
  rankRender(rankInfo = []) {
    this.vScroll.setDataList(rankInfo, SCROLL_VERTICAL, [0, 0, 0]);
    this.vScroll.scrollToTop(0);
  }

  /** 奖品栏渲染 */
  async prizeRender(prizeInfo = []) {
    this.prizeBox.destroyAllChildren();
    for (let i = 0; i < prizeInfo.length; i ++) {
      const node = instantiate(this.prizeItem);
      node.getChildByName("PrizeName").getComponent(Label).string = strFormat(prizeInfo[i]?.prizeName, 12);
      node.getChildByName("RankIndex").getComponent(Label).string = `第${prizeInfo[i]?.prizeRank}名`
      const res = await loadImg(prizeInfo[i]?.prizeImg, node.getChildByName("PrizeImg").getComponent(UITransform).width);
      node.getChildByName("PrizeImg").getComponent(Sprite).spriteFrame = res?.spriteFrame;
      node.getChildByName("PrizeImg").getComponent(UITransform).width /= res?.scale || 1;
      node.getChildByName("PrizeImg").getComponent(UITransform).height /= res?.scale || 1;
      this.prizeBox.addChild(node);
    }
  }

  /** 切换Tab */
  handleClickTab(tab, data = "2") {
    this.type = data;
    sendLog(LOG_TYPE.CLICK, MD_MAP[this.type]);
    if (data == "1") {
      this.tabGroup.getChildByName("WeekBg").getComponent(UIOpacity).opacity = 0;
      this.tabGroup.getChildByName("TotalBg").getComponent(UIOpacity).opacity = 255;
      this.node.getChildByPath("PrizeBox/CountDownContent").getComponent(Label).string = "4月1日0点后结算奖励";
      this.node.getChildByPath("Label/Score").getComponent(Label).string = "累计游园积分";
    } else if (data == "2") {
      this.tabGroup.getChildByName("WeekBg").getComponent(UIOpacity).opacity = 255;
      this.tabGroup.getChildByName("TotalBg").getComponent(UIOpacity).opacity = 0;
      this.node.getChildByPath("PrizeBox/CountDownContent").getComponent(Label).string = "每周一0点后结算奖励";
      this.node.getChildByPath("Label/Score").getComponent(Label).string = "本周累计积分";
    }
    this.getRankInfo();
  }

  /** 回到首页 */
  async handleClickBack() {
    await changeScene(HomeScene);
  }

  update(deltaTime: number) {}
}
