import { _decorator, Component, Node, Label, Button, find } from 'cc';
import { ScrollListItem } from '../../ScrollList/ScrollListItem';
import TaskCenter from '../../TaskCenter';
import { strFormat } from '../../Utils/Utils';
import { LOG_TYPE, sendLog } from '../../Utils/WebNet/WebNet';
const { ccclass, property } = _decorator;
const MD_MAP = {
    0: 1,
    1: 2
}

@ccclass("TaskItem")
export class TaskItem extends ScrollListItem {

    @property(Node)
    doComplete: Node = null;
    @property(Node)
    receivePrize: Node = null;
    @property(Node)
    completed: Node = null;
    
    isClick: boolean = false;

    /** 首页节点 */
    homeNode: Node = null;

    /** 任务节点 */
    taskNode: Node = null;

    /** 任务信息 */
    taskInfo = null;

    start() {}
    
    onItemRender(data, ...param: any[]) {
        // console.log(`index: ${data}`, param);
        this.homeNode = param?.[1]?.[0] || {};
        this.taskNode = param?.[1]?.[1] || {};
        this.taskInfo = data
        if (data?.code?.startsWith("it")) {
            this.node.getChildByName("Title").getComponent(Label).string = strFormat(`${data?.title}(${data?.completedSize}/${data?.intervalLimitSize})`, 24);
        } else {
            this.node.getChildByName("Title").getComponent(Label).string = strFormat(data?.title, 24);
        }
        // this.node.getChildByName("SubTitle").getComponent(Label).string = `${data?.options?.[0]?.name}+${data?.options?.[0]?.sendCount}`;
        this.node.getChildByName("SubTitle").getComponent(Label).string = strFormat(data?.subTitle, 38);
        switch(data?.taskStatus + "") {
            case "0": {
                this.doComplete.on(Button.EventType.CLICK, this.doCompleteFunc(data?.code, data), this);
                this.doComplete.active = true;
                this.receivePrize.active = false;
                this.completed.active = false
                if (data?.code?.startsWith("it")) {
                    this.node.getChildByPath("BtnGroup/Name").getComponent(Label).string = "去邀请";
                } else if (data?.code?.startsWith("bt")) {
                    this.node.getChildByPath("BtnGroup/Name").getComponent(Label).string = "去完成";
                } else if (data?.code?.startsWith("tt") && (data?.extra == 0 || !!!data?.extra)) {
                    this.node.getChildByPath("BtnGroup/Name").getComponent(Label).string = "立即报名";
                } else {
                    this.node.getChildByPath("BtnGroup/Name").getComponent(Label).string = "去完成";
                }
                break;
            }
            case "1": {
                this.receivePrize.on(Button.EventType.CLICK, this.receivePrizeFunc(data), this);
                this.doComplete.active = false;
                this.receivePrize.active = true;
                this.completed.active = false
                this.node.getChildByPath("BtnGroup/Name").getComponent(Label).string = "待领取";
                break;
            }
            case "2": {
                this.doComplete.active = false;
                this.receivePrize.active = false;
                this.completed.active = true
                if (data?.intervalType == 1) {
                    this.node.getChildByPath("BtnGroup/Name").getComponent(Label).string = "明日再来";
                } else {
                    this.node.getChildByPath("BtnGroup/Name").getComponent(Label).string = "已完成";
                }
                break;
            }
        }
    }

    /** 去完成 */
    doCompleteFunc(taskCode: string, item: any) {
        return () => {
            console.log("****去完成");
            this.logClick(this.taskInfo);
            if (this.isClick) return;
            this.isClick = true;
            setTimeout(() => {
                this.isClick = false;
            }, 2000)
            TaskCenter.ins.handleClickTask(this.taskInfo?.code, this.taskInfo, this.taskNode);
        }
    }

    /** 领取奖励 */
    receivePrizeFunc(item: any) {
        return () => {
            this.logClick(item);
            if (this.isClick) return;
            this.isClick = true;
            setTimeout(() => {
                this.isClick = false;
            }, 2000)
            TaskCenter.ins.receivePrize(item, this.homeNode, this.taskNode);
        }
    }

    /** 点击埋点 */
    logClick(item) {
        // switch(true) {
        //     case item?.code?.startsWith("it") && item?.taskStatus == "0": sendLog(LOG_TYPE.CLICK, 12, 1, 0); break;
        //     case item?.code?.startsWith("bt") && item?.taskStatus == "0": sendLog(LOG_TYPE.CLICK, 12, 1, 2); break;
        //     case item?.code?.startsWith("tt") && item?.taskStatus == "0": sendLog(LOG_TYPE.CLICK, 12, 1, 1); break;
        //     case item?.taskStatus == "1": sendLog(LOG_TYPE.CLICK, 12, 1, 3); break;
        // }
        sendLog(LOG_TYPE.CLICK, 11, 1, item.code, MD_MAP[item.taskStatus]);
    }
}

