import { _decorator, Component, Node, Label, UITransform, Sprite, Button } from 'cc';
import Panel from '../../Module/Panel';
import { loadImg, strFormat } from '../Utils/Utils';
import { LOG_TYPE, sendLog } from '../Utils/WebNet/WebNet';
const { ccclass, property } = _decorator;

@ccclass("GetRankPrizePanel")
export class GetRankPrizePanel extends Panel {
  static bundle: string = "";
  static skin = "GetRankPrizePanel";
  static group = "GetRankPrizePanel";

  /** 关闭按钮 */
  @property(Node)
  closeBtn: Node = null;
  /** 开心收下 */
  @property(Node)
  mainBtn: Node = null;
  /** 排名 */
  @property(Node)
  rankIndex: Node = null;
  /** 奖品图片 */
  @property(Node)
  prizeImg: Node = null;
  /** 奖品名 */
  @property(Node)
  prizeName: Node = null;

  start() {
    sendLog(LOG_TYPE.EXPOSURE, 31);
    this.mainBtn.on(Button.EventType.CLICK, this.closePannel, this);
    this.closeBtn.on(Button.EventType.CLICK, this.closePannel, this);
    this.pannelRender();
  }

  /** 渲染 */
  async pannelRender() {
    this.rankIndex.getComponent(Label).string = `最终排名为${this.data?.rank}`;
    const res = await loadImg(
      this.data?.prizeImg,
      this.prizeImg.getComponent(UITransform).width
    );
    this.prizeImg.getChildByName("Img").getComponent(Sprite).spriteFrame =
      res?.spriteFrame;
    this.prizeImg.getChildByName("Img").getComponent(UITransform).width /=
      res?.scale || 1;
    this.prizeImg.getChildByName("Img").getComponent(UITransform).height /=
      res?.scale || 1;
    this.prizeName.getComponent(Label).string = strFormat(
      this.data?.prizeName,
      20
    );
  }

  /** 关闭弹窗 */
  closePannel() {
    sendLog(LOG_TYPE.CLICK, 31);
    this.hidePanel();
  }
}

