import Panel from "../../Module/Panel";
import { _decorator, Button, Node } from "cc";
import { CirculatePageView } from "db://assets/Component/CirculatePageView/CirculatePageView";
import { LOG_TYPE, sendLog, sendWebNetWithToken, WebNetName } from "db://assets/Scripts/Utils/WebNet/WebNet";
import { HAND_TYPE } from "db://assets/Scripts/const";

const {ccclass, property} = _decorator;

@ccclass('GameChooseHand')
export default class GameChooseHand extends Panel {

    static bundle: string = "";
    static skin = "GameChooseHand";
    static group = "GameChooseHand";


    @property(Node)
    aLeft: Node = null;

    @property(Node)
    aRight: Node = null;

    @property(CirculatePageView)
    pageView: CirculatePageView = null;

    @property(Node)
    okBtn: Node = null;

    start() {
        this.aLeft.on(Button.EventType.CLICK, this.onLeft, this);
        this.aRight.on(Button.EventType.CLICK, this.onRight, this);
        this.okBtn.on(Button.EventType.CLICK, this.onOk, this);

        this.pageView.getPages().forEach((node, idx) => {
            const type = (idx + 1).toString() as HAND_TYPE;
            const current = node.getChildByName("current");
            current.active = type == this.data.curHand;
        });
    }

    onLeft() {
        const pageLen = this.pageView.getPages().length;
        const cur = this.pageView.curPageIdx;
        const idx = ((cur - 1) % pageLen + pageLen) % pageLen;
        this.pageView.scrollToPage(idx);
    }

    onRight() {
        const pageLen = this.pageView.getPages().length;
        const cur = this.pageView.curPageIdx;
        // const idx = (cur + 1) % pageLen;
        const idx = ((cur + 1) % pageLen + pageLen) % pageLen;
        this.pageView.scrollToPage(idx);
    }

    async onOk() {
        this.btnEnable(this.okBtn, false);

        const idx = this.pageView.curPageIdx;
        const type = (idx + 1).toString() as HAND_TYPE;

        const res = await sendWebNetWithToken(WebNetName.changeHand, {id: type});

        this.btnEnable(this.okBtn, true);

        if (!res.success) return;

        this.data.sucCall(type);

        this.hidePanel();
    }

}
