import { sendWebNet, sendWebNetWithToken, WebNetName } from "./Utils/WebNet/WebNet";
import { hideWaiting, showPanel, showWaiting } from "db://assets/Module/UIFast";
import BoxPanel from "db://assets/Scripts/Panels/BoxPanel";
import NoBoxPanel from "db://assets/Scripts/Panels/NoBoxPanel";
import PrizePanel from "db://assets/Scripts/Panels/PrizePanel";
import NoPrizePanel from "db://assets/Scripts/Panels/NoPrizePanel";

export default class GameMgr {

    private static _ins: GameMgr = null;

    public static get ins() {
        !GameMgr._ins && (GameMgr._ins = new GameMgr());
        return GameMgr._ins;
    }

    gameInfo: {
        startId: number,
        isUsedDelay: boolean,
        newGuide: boolean,
        difficultyLevel: string,
        targetNum: number,
        rongNum: number,

        richManNum: number,
        loopType: string,
        handType: string,
        beautyStartTime: number,
        beautyEndTime: number,
        delaySecond: number,
        delayConsumeNum: number,
        isBeauty: boolean,
    } = {
        startId: 0,
        isUsedDelay: false,
        newGuide: false,
        difficultyLevel: "1",
        targetNum: 5,
        rongNum: 8,

        richManNum: 0,
        loopType: "1",
        handType: "1",
        beautyStartTime: 0,
        beautyEndTime: 0,
        delaySecond: 30,
        delayConsumeNum: 10,
        isBeauty: false,
    };

    /**
     * 开始游戏
     */
    async start() {
        const gameIndex = await sendWebNet(WebNetName.gameIndex);
        if (!gameIndex.success) {
            return false;
        }

        const startRes = await sendWebNetWithToken(WebNetName.start);

        if (!startRes.success) {
            return false;
        }

        const isBeauty = (gameIndex.timeStamp >= gameIndex.data.beautyStartTime)
            && (gameIndex.timeStamp <= gameIndex.data.beautyEndTime);

        this.gameInfo = {
            ...startRes.data,
            ...gameIndex.data,
            isBeauty,
        }

        return true;
    }

    /**
     * 提交游戏结果
     */
    async submit(score, hitNum) {

        showWaiting();

        const params = {
            startId: this.gameInfo.startId,
            score,
            hitNum,
        }
        const {success, data} = await sendWebNetWithToken(WebNetName.submit, params);
        hideWaiting();

        if (!success) return false;

        const {
            ifReachTarget, scoreSum,
            prizeName, prizeImg, prizeId,
        } = data;

        const openBox = () => {
            if (prizeId && prizeId != "thanks") {
                showPanel(PrizePanel, {
                    prizeName,
                    prizeImg,
                    score
                });
            } else {
                showPanel(NoPrizePanel);
            }
        }

        if (ifReachTarget) {
            showPanel(BoxPanel, {openBox});
        } else {
            showPanel(NoBoxPanel, {
                totalScore: scoreSum,
                score,
            });
        }

        return success;

    }


    /**
     * 使用道具
     */
    async useSp() {

        // showWaiting();
        const res = await sendWebNetWithToken(WebNetName.consume);
        // hideWaiting();

        if (!res?.success) return false;

        return true;
    }

}
