import { BuildPlugin } from '../@types';

export const load: BuildPlugin.load = function() {
    console.debug(`${PACKAGE_NAME} load`);
};

export const unload: BuildPlugin.load = function() {
    console.debug(`${PACKAGE_NAME} unload`);
};

const PACKAGE_NAME = 'duiba-publish';

export const configs: BuildPlugin.Configs = {
    '*': {
        hooks: './hooks',
        doc: 'editor/publish/custom-build-plugin.html',
        options: {
            uploadDir: {
                label: '上传文件夹',
                description: '要上传到哪个子文件夹',
                default: 'template3d',
                render: {
                    ui: 'ui-input',
                    attributes: {
                        placeholder: 'template3d',
                    },
                },
                verifyRules: ['required']
            },
        },
    },
};
