import { _decorator, Node, Label, Button, Sprite, SpriteFrame } from 'cc';
import { ScrollListItem } from '../../ScrollList/ScrollListItem';
import TaskCenter from '../../TaskCenter';
import { _asyncThrottle, strFormat } from '../../Utils/Utils';
import store from "../../../store/store";
import { getWebData, WebNetName } from "../../Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;


@ccclass("TaskItem")
export class TaskItem extends ScrollListItem {


    @property(Label)
    title: Label = null;

    @property(Label)
    subTitle: Label = null;

    @property({type: Node, displayName: "按钮"})
    btn: Node = null;

    @property({type: SpriteFrame, displayName: "去完成"}) doSf: SpriteFrame = null;
    @property({type: SpriteFrame, displayName: "继续加油"}) fightSf: SpriteFrame = null;
    @property({type: SpriteFrame, displayName: "去邀请"}) inviteSf: SpriteFrame = null;
    @property({type: SpriteFrame, displayName: "已完成"}) doneSf: SpriteFrame = null;
    @property({type: SpriteFrame, displayName: "明日再来"}) tomorrowSf: SpriteFrame = null;
    @property({type: SpriteFrame, displayName: "领取奖励"}) receiveSf: SpriteFrame = null;
    @property({type: SpriteFrame, displayName: "去报名"}) signUpSf: SpriteFrame = null;


    start() {
        this.btn.on(Button.EventType.CLICK, this.clickBtn, this);
    }

    onItemRender(data, index) {
        super.onItemRender(data, index);

        // console.log(`task item: `, index, data);

        if (!data) return;

        const {
            code, title: T = "", subTitle,
            completedSize, intervalLimitSize, taskStatus,
            intervalType, extra,
            desc,
        } = data;

        const [title] = T.split("@");


        if (code?.startsWith("it")) {
            this.title.string = strFormat(`${title}(${completedSize}/${intervalLimitSize})`, 24);
            this.subTitle.string = strFormat(subTitle, 38);
        } else if (code === "bank_2202") {
            const descObj = desc ? JSON.parse(desc) : {};
            const t = descObj?.progressAmount || 0;
            this.title.string = strFormat(`${title}(${~~(t / 1000)}/10)`, 30);
            this.subTitle.string = strFormat(`累计已提升金额：${t}元`, 38);
        } else {
            this.title.string = strFormat(title, 24);
            this.subTitle.string = strFormat(subTitle, 38);
        }

        const btnSp = this.btn.getComponent(Sprite);

        const {timeStamp} = getWebData(WebNetName.index) || {};
        const {activityEndTime} = store.homeInfo;

        // 判断是不是同一天
        const isSameDay = new Date(timeStamp).toDateString() === new Date(activityEndTime).toDateString();

        switch (+taskStatus) {
            case 0: {
                if (code?.startsWith("it")) {
                    btnSp.spriteFrame = this.inviteSf;
                } else if (code?.startsWith("tt") && (extra == 0 || !!!extra)) {
                    btnSp.spriteFrame = this.signUpSf;
                } else if (code?.startsWith("bt")) {
                    btnSp.spriteFrame = this.doSf;
                } else {
                    if (code === "bank_2202") { // 特殊任务
                        // hasReceivedNum 特殊任务的已领奖次数
                        if (completedSize >= 1) {
                            btnSp.spriteFrame = this.fightSf;
                        } else {
                            btnSp.spriteFrame = this.doSf;
                        }
                    } else {
                        btnSp.spriteFrame = this.doSf;
                    }
                }
                break;
            }
            case 1: {
                btnSp.spriteFrame = this.receiveSf;
                break;
            }
            case 2: {
                if (isSameDay || intervalType != 1) {
                    btnSp.spriteFrame = this.doneSf;
                } else {
                    btnSp.spriteFrame = this.tomorrowSf;
                }
                break;
            }
        }
    }

    clickBtn = _asyncThrottle(() => {
        const {taskStatus, code} = this.data;

        if (+taskStatus == 0) {

            if (code !== "bank_2202") { // 特殊任务
                TaskCenter.handleClickTask(this.data);
            }

        } else if (+taskStatus == 1) {

            TaskCenter.receivePrize(this.data);

        } else {


        }

    });


}

