import { _decorator, Component, Node, Label } from 'cc';
import { strFormat } from 'db://assets/Scripts/Utils/Utils';
import { ScrollListItem } from 'db://assets/Scripts/ScrollList/ScrollListItem';
const { ccclass, property } = _decorator;

@ccclass("RankScrollListItem")
export class RankScrollListItem extends ScrollListItem {


    /** 元素渲染 */
    onItemRender(data, ...param: any[]) {
        this.node.getChildByName("Index").getComponent(Label).string = `${param[0] + 1}`;
        this.node.getChildByName("Nickname").getComponent(Label).string = strFormat(data?.nickName, 16);
        this.node.getChildByName("Credits").getComponent(Label).string = `${data?.rankScore > 99999999? "99999999+": data?.rankScore}`
    }
}

