import {
    _decorator,
    Label,
    Node,
    view,
    Widget,
    UITransform,
    Prefab,
    instantiate,
    assetManager,
    ImageAsset,
    SpriteFrame,
    Texture2D,
    Sprite,
    UIOpacity
} from "cc";
import Scene from "db://assets/Module/Scene";
import { changeScene } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import { ScrollList, SCROLL_VERTICAL } from "db://assets/Scripts/ScrollList/ScrollList";
import { strFormat } from "db://assets/Scripts/Utils/Utils";
import { sendWebNet, WebNetName } from "db://assets/Scripts/Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@ccclass("RankScene")
export class RankScene extends Scene {

    static skin: string = "RankScene";
    static group: string[] = ["RankScene"];

    @property({type: ScrollList, tooltip: "竖行滚动容器"})
    private vScroll: ScrollList;

    /** 排行榜类别 */
    private _type: string = "2";

    get type() {
        return this._type;
    }

    set type(type: string) {
        this._type = type;
    }

    /** 我的排名 */
    @property(Node)
    myRnak: Node = null;

    /** 奖品展览区域 */
    @property(Node)
    prizeBox: Node = null;

    /** 奖品对象 */
    @property(Prefab)
    prizeItem: Prefab = null;

    onLoad() {
    }

    start() {
        console.log("%c RankScene", "font-size: 20px");
        this.getRankInfo();
    }

    /** 排名处理 */
    rankIndexFormat(rank) {
        if (rank > 5000) {
            return "5000+";
        }
        if (rank == -1 || rank == 0 || !!!rank) {
            return "-";
        }
        return rank;
    }

    /** 获取排行榜首页信息 */
    async getRankInfo() {
        const res = await sendWebNet(WebNetName.rank, {type: this.type});
        const {success, data} = res;
        const {myRank, myRankScore, myNickName, rankInfo = [], prizeInfo = []} = data || {};
        if (success) {
            /** 我的排名 - 更新 */
            this.myRnak.getChildByName("MyRankIndex").getComponent(Label).string = `${this.rankIndexFormat(myRank)}`;
            this.myRnak.getChildByName("MyCredits").getComponent(Label).string = `${myRankScore > 99999999 ? "99999999+" : myRankScore}`;
            this.myRnak.getChildByName("MyName").getComponent(Label).string = `${strFormat(myNickName || "", 12)}(我)`;
            /** 排行榜渲染 */
            this.rankRender(rankInfo);
            /** 奖品区域渲染 */
            this.prizeRender(prizeInfo);
        }
    }

    /** 排行榜渲染 */
    rankRender(rankInfo = []) {
        this.vScroll.setDataList(rankInfo, SCROLL_VERTICAL, [0, 0, 0]);
        this.vScroll.scrollToTop(0);
    }

    /** 奖品栏渲染 */
    async prizeRender(prizeInfo = []) {
        this.prizeBox.destroyAllChildren();
        for (let i = 0; i < prizeInfo.length; i++) {
            const node = instantiate(this.prizeItem);
            node.getChildByName("PrizeName").getComponent(Label).string = strFormat(prizeInfo[i]?.prizeName, 12);

            let prizeRank = prizeInfo[i]?.prizeRank;
            const spRank = prizeRank.split("-");
            if (spRank[0] == spRank[1]) {
                prizeRank = spRank[0];
            }

            node.getChildByName("RankIndex").getComponent(Label).string = `第${prizeRank}名`
            node.getChildByName("PrizeImg").getComponent(Sprite).spriteFrame = prizeInfo[i]?.prizeImg;
            this.prizeBox.addChild(node);
        }
    }

    /** 回到首页 */
    async handleClickBack() {
        await changeScene(HomeScene);
    }
}
