import { _decorator, Component, Node, Label, UITransform, Sprite, Button } from 'cc';
import Panel from '../../Module/Panel';
import { strFormat } from '../Utils/Utils';

const {ccclass, property} = _decorator;

@ccclass("GetRankPrizePanel")
export class GetRankPrizePanel extends Panel {
    static bundle: string = "";
    static skin = "GetRankPrizePanel";
    static group = "GetRankPrizePanel";

    /** 关闭按钮 */
    @property(Node)
    closeBtn: Node = null;
    /** 开心收下 */
    @property(Node)
    mainBtn: Node = null;
    /** 排名 */
    @property(Node)
    rankIndex: Node = null;
    /** 奖品图片 */
    @property(Sprite)
    prizeImg: Sprite = null;
    /** 奖品名 */
    @property(Node)
    prizeName: Node = null;

    start() {
        this.mainBtn.on(Button.EventType.CLICK, this.closePannel, this);
        this.closeBtn.on(Button.EventType.CLICK, this.closePannel, this);
        this.rankIndex.getComponent(Label).string = `最终排名为${this.data?.rank}`;
        this.prizeImg.spriteFrame = this.data?.prizeImg;
        this.prizeName.getComponent(Label).string = strFormat(
            this.data?.prizeName,
            20
        );
    }

    /** 关闭弹窗 */
    closePannel() {
        this.hidePanel();
    }
}

