import { _decorator, Component, Node, UIOpacity, Button } from 'cc';
import { sendWebNetWithToken, WebNetName } from '../../Utils/WebNet/WebNet';
import { ChangeEquipPanel } from './ChangeEquipPanel';
const { ccclass, property } = _decorator;

@ccclass('HandItem')
export class HandItem extends Component {

    handType: string = "";

    cePanel: Node = null;

    updateInfo(flag: boolean, handType: string, node: Node) {
        this.handType = handType;
        this.cePanel = node;
        if (flag) {
            this.node.getChildByName("UseIcon").active = true;
            this.node.getChildByName("MainBtn").active = false;
            this.node.getChildByPath("Border/Select").getComponent(UIOpacity).opacity = 255;
        } else {
            this.node.getChildByName("UseIcon").active = false;
            this.node.getChildByName("MainBtn").active = true;
            this.node.getChildByPath("Border/Select").getComponent(UIOpacity).opacity = 0;
        }
    }

    start() {
        this.node.getChildByName("MainBtn").on(Button.EventType.CLICK, this.changeHand, this);
    }

    /** 更换爪子 */
    async changeHand() {
        const res = await sendWebNetWithToken(WebNetName.changeHand, {id: this.handType});
        if (res?.success) {
            this.cePanel.getComponent(ChangeEquipPanel).getEquipInfo();
        }
        // await this.cePanel.getComponent(ChangeEquipPanel).handInit();
    }

    update(deltaTime: number) {
        
    }
}

