import {
    _decorator,
    Node,
    Button, v3, tween, easing,
    screen, Widget,
} from "cc";
import Panel from "db://assets/Module/Panel";
import { ScrollList, SCROLL_VERTICAL } from "../../ScrollList/ScrollList";
import { unwatchPageVisibility, watchPageVisibility } from "../../Utils/pageVisibilityNotify";
import { observer, render } from "../../../store/decorators";
import store from "../../../store/store";

const {ccclass, property} = _decorator;


@observer
@ccclass("TaskPanel")
export class TaskPanel extends Panel {
    static bundle: string = "";
    static skin = "TaskPanel";
    static group = "TaskPanel";

    @property({type: ScrollList, tooltip: "竖行滚动容器"})
    private vScroll: ScrollList;

    /** 关闭按钮 */
    @property(Node)
    closeBtn: Node = null;

    onShow() {
        this.node.setPosition(v3(0, -812, 0));
        tween(this.node)
            .to(0.188, {position: v3(0, 0, 0)}, {easing: easing.quadInOut})
            .start();
    }

    async start() {
        this.closeBtn.on(Button.EventType.CLICK, this.closePanel, this);

        store.updateTask();

        watchPageVisibility(this.pageVChange);
    }

    /** 页面显示 */
    pageVChange = async (visible) => {
        console.log('页面', visible ? '可见' : '不可见')
        if (visible) {
            await store.updateTask();
        }
    }

    @render
    render() {
        const {taskInfo} = store;

        const taskList = [];
        taskInfo.forEach((v) => {
            if (v.desc) {
                try {
                    if (JSON.parse(v.desc).taskType == 1) return;
                } catch (e) {
                    taskList.push(v);
                }
            }
            taskList.push(v);
        });

        this.vScroll.setDataList(taskList || [], SCROLL_VERTICAL, [0, 30, 20]);
    }

    /** 关闭弹窗 */
    closePanel() {
        this.hidePanel();
        unwatchPageVisibility(this.pageVChange)
    }

}
