import Panel from "../../Module/Panel";
import { _decorator, Button, RichText, UITransform } from "cc";
import { sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@ccclass('RulePanel')
export default class RulePanel extends Panel {

    static skin = "RulePanel";
    static group = "RulePanel";

    async start() {
        const {data = ""} = await sendWebNet(WebNetName.projectRule);
        this.setRuleTxt(data);
        this.view["close"].on(Button.EventType.CLICK, () => {
            this.hidePanel();
        }, this);
    }

    setRuleTxt(txt) {
        const ruleNode = this.view['ScrollView/view/content/ruleTxt'];
        const ruleTxt = ruleNode.getComponent(RichText);
        const content = this.view['ScrollView/view/content'];
        ruleTxt.maxWidth = content.getComponent(UITransform).width;

        this.scheduleOnce(() => {
            ruleTxt.string = txt.replace(/<p\b.*?(?:\>|\/>)/gi, "").replace(/<\/p\>/gi, "<br/>");
            content.getComponent(UITransform).height = ruleNode.getComponent(UITransform).height;
        }, 0.188);
    }

}
