import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node } from "cc";
import { sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";
import { showToast } from "../../Module/UIFast";
import store from "../../store/store";
import { _asyncThrottle } from "../Utils/Utils";


const {ccclass, property} = _decorator;

@ccclass('ToolBuyConfirmPanel')
export default class ToolBuyConfirmPanel extends Panel {

    static skin = "ToolBuyConfirmPanel";
    static group = "ToolBuyConfirmPanel";

    @property(Label)
    tip: Label = null;

    @property(Node)
    close: Node = null;

    @property(Node)
    okBtn: Node = null;

    @property(Node)
    cancelBtn: Node = null;


    async start() {
        const {buyRichSpCredits} = store.homeInfo;

        this.tip.string = `确认使用${buyRichSpCredits}积分购买\n天降财神道具*1 吗`;

        this.okBtn.on(Button.EventType.CLICK, this.buyHandle, this);
        this.cancelBtn.on(Button.EventType.CLICK, this.hidePanel, this);
        this.close.on(Button.EventType.CLICK, this.hidePanel, this);
    }

    /** 确认购买 */
    buyHandle = _asyncThrottle(async () => {
        const res = await sendWebNetWithToken(WebNetName.buyRichSp);
        if (!res?.success) return;

        showToast("购买成功～快去使用吧");
        this.hidePanel();
    })

}
