import { _decorator, Component, Node, resources, SpriteFrame, Sprite, Label, UITransform, Vec3, tween } from 'cc';
const { ccclass, property } = _decorator;

const LOOP_TYPE_MAP = {
  1: {
    img: "https://yun.duiba.com.cn/polaris/circle_tong.4eef1ace6c6a56dcbcb3dc256bac08305078b864.png",
    name: "青铜财富圈",
  },
  2: {
    img: "https://yun.duiba.com.cn/polaris/circle_yin.230648fcd45b29a6b69c9d793edf3af61734802e.png",
    name: "白银财富圈",
  },
  3: {
    img: "https://yun.duiba.com.cn/polaris/circle_jin.3107e335d2bcceb028cd4d2d6dbabff200091b32.png",
    name: "黄金财富圈",
  },
  4: {
    img: "https://yun.duiba.com.cn/polaris/circle_feicui.c9c20fc9012881379ae5a5c864286cf2e005ac99.png",
    name: "翡翠财富圈",
  },
  5: {
    img: "https://yun.duiba.com.cn/polaris/circle_zhaocai.a149f14ed4c30b4471faa0c72d0da8a5756d0fd0.png",
    name: "财神财富圈",
  },
};

const POSITION = {
    0: {
        x: -840,
        scale: 0.7
    },
    1: {
        x: -420,
        scale: 0.7
    },
    2: {
        x: 0,
        scale: 1
    },
    3: {
        x: 420,
        scale: 0.7
    },
    4: {
        x: 840,
        scale: 0.7
    }
}

@ccclass('CircleItem')
export class CircleItem extends Component {
    start() {

    }

    update(deltaTime: number) {
        
    }

    /** 铜 */
    @property(SpriteFrame)
    circle1: SpriteFrame = null;
    /** 银 */
    @property(SpriteFrame)
    circle2: SpriteFrame = null;
    /** 金 */
    @property(SpriteFrame)
    circle3: SpriteFrame = null;
    /** 翡翠 */
    @property(SpriteFrame)
    circle4: SpriteFrame = null;
    /** 招财 */
    @property(SpriteFrame)
    circle5: SpriteFrame = null;

    /** 当前索引 */
    index: number = 0;

    /** 数据索引 */
    dataIndex: number = 0;

    /** 数据项 */
    data: any = {};

    /** 更新信息 */
    async updateInfo(data: any = {}) {
        this.data = data;
        const circle = this.node.getChildByName("Circle");
        // const res = await loadImg(LOOP_TYPE_MAP?.[data?.loopType]?.img, circle.getComponent(UITransform).width);
        // circle.getComponent(Sprite).spriteFrame = res?.spriteFrame;
        // circle.getComponent(UITransform).width /= res?.scale || 1;
        // circle.getComponent(UITransform).height /= res?.scale || 1;
        const spriteFrame = this[`circle${data?.loopType || "1"}`];
        circle.getComponent(Sprite).spriteFrame = this[`circle${data?.loopType || "1"}`];
        this.node.getChildByName("Name").getComponent(Label).string = LOOP_TYPE_MAP?.[data?.loopType]?.name;
    }

    /** 更新位置 */
    updateItem(targetIndex: number, data: any = null, dataIndex: number) {
        if (!!data) {
            if (targetIndex === 4) {
                this.node.setPosition(new Vec3(POSITION[4].x, 0, 0));
                this.updateInfo(data);
            } else if (targetIndex === 0) {
                this.node.setPosition(new Vec3(POSITION[0].x, 0, 0));
                this.updateInfo(data);
            }
        } else {
            const obj = POSITION?.[targetIndex] || {};
            tween(this.node)
                .to(0.5, { position: new Vec3(obj.x, 0, 0), scale: new Vec3(obj.scale, obj.scale, obj.scale)}, {easing: "linear"})
                .start()
        }
        this.index = targetIndex;
        
    }
    /** 初始化 */
    init(index: number, data: any = {}, dataIndex: number) {
        this.index = index;
        this.dataIndex = dataIndex;
        if (index !== 2) {
            const scale = POSITION?.[index]?.scale;
            this.node.setScale(new Vec3(scale, scale, scale))
        }
        this.updateInfo(data);
    }
}

