import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, RichText } from "cc";
import { showPanel, showToast } from "../../Module/UIFast";
import ToolBuyConfirmPanel from "./ToolBuyConfirmPanel";
import store from "../../store/store";
import { _asyncThrottle } from "../Utils/Utils";
import { sendWebNetWithToken, WebNetName } from "../Utils/WebNet/WebNet";


const {ccclass, property} = _decorator;

@ccclass('ToolBuyPanel')
export default class ToolBuyPanel extends Panel {

    static skin = "ToolBuyPanel";
    static group = "ToolBuyPanel";

    @property(Label)
    tip: Label = null;

    @property(Node)
    close: Node = null;

    @property(Node)
    buyBtn: Node = null;


    async start() {
        const {buyRichSpCredits} = store.homeInfo;

        // this.view["RichText"].getComponent(RichText).string = `<color=#C62F3A>您可消耗</color><color=#fe0114><size=34><b>${buyRichSpCredits}</b></size></color><color=#C62F3A>积分购买道具～</color>`;
        this.tip.string = `您可消耗${buyRichSpCredits}积分购买道具～`;

        this.close.on(Button.EventType.CLICK, this.hidePanel, this);
        this.buyBtn.on(Button.EventType.CLICK, this.buyHandle, this);
    }

    /** 立即购买 */
    // async buyHandle() {
    //     this.hidePanel()
    //     showPanel(ToolBuyConfirmPanel);
    // }

    // 20240729 去掉二次确认弹窗
    /** 确认购买 */
    buyHandle = _asyncThrottle(async () => {
        const res = await sendWebNetWithToken(WebNetName.buyRichSp);
        if (!res?.success) return;

        showToast("购买成功～快去使用吧");
        this.hidePanel();
    })

}
