import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node } from "cc";
import GameMgr from "db://assets/Scripts/GameMgr";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";

const { ccclass, property } = _decorator;

@ccclass('ReviewPanel')
export default class ReviewPanel extends Panel {

    static bundle: string = "";
    static skin = "ReviewPanel";
    static group = "ReviewPanel";

    @property(Node)
    close: Node = null!;

    @property(Node)
    cancel: Node = null!;

    @property(Node)
    ok: Node = null!;

    @property(Label)
    tip: Label = null!;

    async start() {
        sendLog(LOG_TYPE.EXPOSURE, 17)
        this.ok.on(Button.EventType.CLICK, this.onOk, this);
        this.close.on(Button.EventType.CLICK, this.onClose, this);
        this.cancel.on(Button.EventType.CLICK, this.onClose, this);

        const { delaySecond, delayConsumeNum } = GameMgr.ins.gameInfo;
        this.tip.string = `是否通过消耗${delayConsumeNum}积分\n延长${delaySecond}s游戏时间？`;
    }

    /**
     * 确认复活
     */
    onOk = () => {
        sendLog(LOG_TYPE.CLICK, 17)
        this.data.review();
        this.hidePanel();
    }

    /**
     * 取消，关闭
     */
    onClose = () => {
        // 结算
        this.data.submit();
        this.hidePanel();
    }

}
