import { _decorator, BoxCollider, Component, CylinderCollider, EAxisDirection, ITriggerEvent, misc, Quat, RigidBody, v3, Vec3 } from "cc";
import { eventTarget, MEvent } from "../../../Module/MEvent";

const { ccclass, property } = _decorator;

@ccclass("Quan")
export class Quan extends Component {
	rb: RigidBody = null;

	isShoot: boolean = false;

	hit: boolean = false;

	// @property()

	scale: number = 1.35;
	radius: number = 1;

	onLoad() {
		this.rb = this.node.getComponent(RigidBody);
		this.rb.enabled = false;
		// this.rb.useCCD = true;
		this.node.setScale(this.scale, this.scale, this.scale);
		// this.node.children[0].setScale(1.5, 1.5, 1.5);
	}

	start() {
		this.initCollider();
	}

	initCollider() {
		for (let i = 0; i < 12; i++) {
			let r = (360 / 12) * i;
			const deg = misc.degreesToRadians(-r);
			const x = Math.cos(deg) * this.scale;
			const z = Math.sin(deg) * this.scale;
			// console.log(-r, x, z);

			const collider = this.node.addComponent(CylinderCollider);
			collider.direction = EAxisDirection.Z_AXIS;
			Quat.fromEuler(collider.shape["_orient"], 0, r, 0);
			collider.center = v3(x, 0, z);
			collider.height = 0.6 * this.radius * this.scale;
			collider.radius = 0.045 * this.radius * this.scale;
			collider.isTrigger = false;
		}

		const collider = this.node.addComponent(BoxCollider);
		const w = 0.85 * this.radius * this.scale;
		collider.size = v3(w, 0.08, w);
		collider.isTrigger = true;
		collider.on("onTriggerEnter", this.onTriggerEnter, this);
	}

	onTriggerEnter(event: ITriggerEvent) {
		if (this.hit) return;
		const { otherCollider } = event;

		if (otherCollider.node.name == "加分点") {
			// console.log("加分");
			this.hit = true;
			eventTarget.emit(MEvent.ADD_SCORE);
			this.scheduleOnce(() => {
				// 加分时隐藏套中的对象
				// console.log("加分时隐藏套中的对象", otherCollider.node);
				// otherCollider.node.destroy();
				let ip = otherCollider.node.parent;
				ip.active = false;
				this.node.destroy();
				setTimeout(() => {
					ip.active = true;
				}, 1500);
			}, 0.2);
		} else if (otherCollider.node.name == "消失") {
			this.node.destroy();
		}
	}

	shoot(powerScale: number, endX: number) {
		this.isShoot = true;
		this.hit = false;
		this.rb.enabled = true;
		const power = v3(endX, 27.8, -22).multiply3f(1, powerScale, powerScale);
		this.rb.applyImpulse(power);
		// this.rb.setLinearVelocity(new Vec3(0, 15, -25));
		// this.rb.applyForce(new Vec3(0, 800, -2050));

		this.rb.applyLocalTorque(new Vec3(0, -600, 0));
	}

	// 初始值设置的差别大点，不然一出来就没了
	frame1Y = 1000;
	frame2Y = 100;
	frame3Y = 10;

	update(deltaTime: number) {
		this.judgeDestroy();
	}

	v3 = new Vec3();

	/**
	 * 检测是否停止或者消失
	 */
	judgeDestroy() {
		if (!this.isShoot || this.hit) return;

		const y = this.node.getPosition().y;
		this.frame1Y = this.frame2Y;
		this.frame2Y = this.frame3Y;
		this.frame3Y = y;

		this.rb.getLinearVelocity(this.v3);
		if(this.v3.length() < 0.001) {
			this.node.destroy();
			return;
		}
		// const dy32 = Math.abs(this.frame3Y - this.frame2Y);
		// const dy21 = Math.abs(this.frame2Y - this.frame1Y);
		// const dy31 = Math.abs(this.frame3Y - this.frame1Y);

		// if (dy32 < 0.0002 && dy21 < 0.0002 && dy31 < 0.0002) {
		// 	// TODO找个合理的边界值
		// 	// console.log("停止飞行");
		// 	this.node.destroy();
		// 	return;
		// }

		if (y <= -10) {
			// console.log("掉出屏幕");
			this.node.destroy();
			return;
		}
	}
}
