import mobx from "mobx";
import { sendWebNet, WebNetName } from "db://assets/Scripts/Utils/WebNet/WebNet";
import { showPanel, showToast } from "../Module/UIFast";
import { GetRankPrizePanel } from "../Scripts/Panels/GetRankPrizePanel";
import { NoGetRankPrizePanel } from "../Scripts/Panels/NoGetRankPrizePanel";
import { GuidePrizePanel } from "../Scripts/Panels/GuidePrizePanel";

const {makeAutoObservable} = mobx;


export interface IHomeInfo {
    activityStartTime: number;
    activityEndTime: number;
    boolFirstEnter: boolean;
    remainGameTime: number;
    boolDayPlayLimit: boolean;
    hqLoginSend: number;
    assistPopInfo: null | {
        newAssistNum: number;       // 新助力人数(大于0代表要弹弹窗)
        newChallengeNum: number;    // 新获得的挑战次数
    };
    rankPopInfo: null | {
        boolShowPop: boolean;   // 是否展示排行榜弹窗，true：展示，false：不展示
        rank: number;           // 排名
        prizeName: string;      // 奖品名称
        boolGetPrize: boolean;  // 是否获得奖励 true:中奖 false:未中奖
        prizeImg: string;       // 奖品图片
    };
    rank: number;
    rankScore: number;
    buyRichSpCredits: number;
}


class Store {
    frontVariable: { [key in string]: any } = {}

    async updateFrontVariable() {
        const {success, data} = await sendWebNet(WebNetName.getFrontVariable);
        if (!success) {
            return;
        }
        this.frontVariable = data;
    }

    homeInfo: IHomeInfo = {
        activityStartTime: 0,
        activityEndTime: 0,
        boolFirstEnter: false,
        remainGameTime: 0, // 剩余挑战次数
        boolDayPlayLimit: false, // 今日挑战是否已达上限 true:是 false:不是
        hqLoginSend: 0, // 行庆登陆赠送游戏次数
        assistPopInfo: null,
        rankPopInfo: null,
        rank: -1, // 总榜排名(0:未参与 -1:排名超出999)
        rankScore: 0, // 总榜积分
        buyRichSpCredits: 0,    // 购买天降财神道具所需积分
    }

    async updateIndex() {
        const {success, data} = await sendWebNet(WebNetName.index);
        if (!success) {
            return;
        }
        this.homeInfo = data;

        const {
            assistPopInfo, // 助力弹窗信息
            boolFirstEnter, // 是否首次登录 true:是 false:不是
            rankPopInfo, // 总排行榜发奖弹窗信息
        } = data || {};

        /** 总排行榜获奖 */
        if (!!rankPopInfo?.boolShowPop) {
            if (!!rankPopInfo?.boolGetPrize) {
                showPanel(GetRankPrizePanel, rankPopInfo)
            } else {
                showPanel(NoGetRankPrizePanel, rankPopInfo);
            }
        }

        /** 首次登录 */
        if (!!boolFirstEnter) {
            showPanel(GuidePrizePanel);
        }

        if (assistPopInfo) {
            showToast(`${assistPopInfo.newAssistNum}位好友为你助力~\n已获得${assistPopInfo.newChallengeNum}次挑战次数`);
        }

    }

    baseInfo: {
        uid?: string,
    } = {};

    async getBaseInfo() {
        const {success, data} = await sendWebNet(WebNetName.baseInfo);
        if (!success) {
            return;
        }
        this.baseInfo = data;
    }


    taskInfo: [
        {
            code: string;
            title: string;
            subTitle: string;
            desc: string;
            buttonText: string;
            taskStatus: 0 | 1 | 2;
            jumpUrl: string;
            icon: string;
        }?
    ] = [];

    async updateTask() {
        const {success, data} = await sendWebNet(WebNetName.queryTasks);
        if (!success) {
            return false;
        }

        this.taskInfo = data?.item || [];
        return true;
    }


}

const store: Store = makeAutoObservable(new Store());

export default store;