Page({
  onLoad(query) {
    // Page load
    console.info(`Page onLoad with query: ${JSON.stringify(query)}`);
    this.webViewContext = my.createWebViewContext('web-view'); 
  },


  testBack(){
    my.call("popWindow");
  },

  getAuthCode() {
    return new Promise((resolve) => {
      my.getAuthCode({
        scopes: ["BASE_USER_INFO", "USER_NAME"],
        success: (res) => {
          resolve(res.authCode);
          console.log(res);
        },
        fail: (res) => {
          resolve(null);
          console.error(res);
        },
      });
    });
  },
  // onShareAppMessage() {
  //   // Back to custom sharing information
  //   return {
  //     title: 'My App',
  //     desc: 'My App description',
  //     path: 'pages/index/index',
  //   };
  // },

  async onMessage(e) {
    const eventType = e.detail.type;

    console.log(123123, e);

    
    if (eventType == "getAuthCode") {
      const authCode = await this.getAuthCode();
      console.log(authCode);
      this.webViewContext.postMessage({type: eventType, 'authCode': authCode});
    } else if(eventType == "getMiniAppQuery"){
      this.webViewContext.postMessage({type: eventType, query: getApp().globalData.query});
    } else if(eventType == "popWindow"){
      my.call("popWindow");
    } else if(eventType == "goWallet") {
      
      // sandbox: 
      // const scheme = "tngdwallet://client/dl/webview?url=https%3A%2F%2Fsite-sandbox.tngdigital.com.my%2Fs%2Floyalty%2Findex.html%23%2Fcollections%3FbackAction%3Ddefault";

      // sit: 
      // const scheme = "tngdwallet://client/dl/webview?url=https%3A%2F%2Fsite-sit.tngdigital.com.my%2Fs%2Floyalty%2Findex.html%23%2Fcollections%3FbackAction%3Ddefault";

      // prod: 
      const scheme = "tngdwallet://client/dl/webview?url=https%3A%2F%2Fcdn.tngdigital.com.my%2Fs%2Floyalty%2Findex.html%23%2Fcollections%3FbackAction%3Ddefault";
      

      my.call(
        'startDeepLink', 
        {scheme}, 
        function(){
          console.log('success')
        }, 
        function(){
          console.log('fail')
        }
      );
    } else if(eventType == "tngdMPEventTagging") {
      const {pageView, clickName, additionalInfo} = e.detail;
      my.call(
        'tngdMPEventTagging', 
        {
          pageView: pageView,
          clickName: clickName,
          additionalInfo: additionalInfo,
        }, 
        function(){
          console.log('success')
        }, 
        function(){
          console.log('fail')
        }
      );
    } else if(eventType == 'bannerJump') {
      const {bannerUrl} = e.detail
      console.info("bannerUrl", bannerUrl)

      const scheme = "tngdwallet://client/dl/webview?url=" + encodeURIComponent(bannerUrl);

      my.call(
        'startDeepLink', 
        {scheme}, 
        function(){
          console.log('success')
        }, 
        function(){
          console.log('fail')
        }
      );
    }
  },
});
