import { _decorator, Button, Label, Node, screen, UI, UITransform, Widget } from 'cc';
import Scene from "db://assets/Module/Scene";
import { MainGame } from "./MainGame/MainGame";
import { changeScene, showPanel } from "db://assets/Module/UIFast";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import { _asyncThrottle } from "../Utils/Utils";
import { GuideScene } from "./GuideScene";
import GameMgr from "../GameMgr";
import RankPanel from "../Panels/RankPanel";
import { UIMgr } from "../../Module/UIMgr";

const {ccclass, property} = _decorator;

@observer
@ccclass('HomeScene')
export class HomeScene extends Scene {

    static skin: string = "HomeScene";
    static group: string[] = ["HomeScene"];


    @property(Node) startBtn: Node = null;
    @property(Node) ruleBtn: Node = null;
    @property(Node) rankBtn: Node = null;

    onLoad() {

        this.startBtn.on(Button.EventType.CLICK, this.clickStart, this);
        this.ruleBtn.on(Button.EventType.CLICK, this.clickRule, this);
        this.rankBtn.on(Button.EventType.CLICK, this.clickRank, this);
    }

    async start() {
        await store.updateIndex();

        UIMgr.ins.preloadScene(MainGame);

    }

    @render
    render() {
        // const {} = store.homeInfo || {};
    }

    clickStart = _asyncThrottle(async () => {

        const {alreadyGuideSteps, allGuideSteps} = store.homeInfo;

        if (alreadyGuideSteps < allGuideSteps) {
            changeScene(GuideScene);
        } else {

            const success = await GameMgr.ins.start();
            if (!success) {
                return;
            }
            changeScene(MainGame);
        }

    });

    clickRule = _asyncThrottle(async () => {
        // showPanel(RulePanel);
        changeScene(GuideScene, {from: "HomeScene"});
    });

    clickRank = _asyncThrottle(() => {
        showPanel(RankPanel);
    });

}

