import { _decorator, Button, Node } from 'cc';
import Scene from "../../Module/Scene";
import { changeScene } from "../../Module/UIFast";
import { MainGame } from "./MainGame/MainGame";
import GameMgr from "../GameMgr";
import { _asyncThrottle } from "../Utils/Utils";
import { sendWebNet, WebNetName } from "../Utils/WebNet/WebNet";
import { HomeScene } from "./HomeScene";
import store from "../store/store";

const {ccclass, property} = _decorator;

@ccclass('GuideScene')
export class GuideScene extends Scene {

    static skin: string = "GuideScene";
    static group: string[] = ["GuideScene"];

    @property({type: [Node]}) guideNode: Node[] = [];
    @property({type: Node}) nextBtn: Node = null;
    @property({type: Node}) startBtn: Node = null;

    private _guideIndex = 0;
    get guideIndex() {
        return this._guideIndex;
    }

    set guideIndex(value: number) {
        this._guideIndex = value;
        this.guideNode.forEach((node, index) => {
            node.active = index == value;
        });

        const isLastStep = value == this.guideNode.length - 1;
        this.startBtn.active = isLastStep;
        this.nextBtn.active = !isLastStep;
    }

    start() {
        if (this.data?.from !== "HomeScene") {
            this.guideIndex = store.homeInfo.alreadyGuideSteps;
        }
        this.nextBtn.on(Button.EventType.CLICK, this.clickNext, this);
        this.startBtn.on(Button.EventType.CLICK, this.clickStart, this);
    }

    clickNext() {
        this.guideIndex++;
        if (this.data?.from !== "HomeScene") {
            sendWebNet(WebNetName.stepNewGuide);
        }
    }

    clickStart = _asyncThrottle(async () => {
        if (this.data?.from === "HomeScene") {
            changeScene(HomeScene);
            return;
        }

        await sendWebNet(WebNetName.stepNewGuide);
        const success = await GameMgr.ins.start();
        if (!success) {
            changeScene(HomeScene);
            return;
        }
        await changeScene(MainGame);
    })
}


