import { _decorator, Material, postProcess } from 'cc';
const { ccclass, property, menu } = _decorator;

@ccclass('MotionBlurSetting')
@menu('PostProcess/MotionBlurSetting')
export class MotionBlurSetting extends postProcess.PostProcessSetting {
    @property
    blueIntensity = 1

    @property
    showDepth = false

    @property
    depthRange = 30

    @property(Material)
    _material: Material | undefined

    @property(Material)
    get material () {
        return this._material;
    }
    set material (v) {
        this._material = v;
    }
}