import { _decorator, Component, Material, MeshRenderer, Node, v4 } from 'cc';

const {ccclass, property} = _decorator;

@ccclass('Bg')
export class Bg extends Component {

    @property({type: Node}) camera: Node = null;
    @property({type: Node}) player: Node = null;

    initZ = 0;

    material: Material = null;

    onLoad() {
        this.initZ = this.node.position.z;
        this.material = this.getComponent(MeshRenderer).material;
    }

    start() {

    }

    update(dt: number) {
        this.camera.position && this.node.setPosition(0, -this.camera.position.y, this.initZ);
        this.player.position && this.material.setProperty(
            'tilingOffset',
            v4(10, 1, -this.player.position.z / 50, 0)
        );
    }
}


