import Panel from "../../Module/Panel";
import { _decorator, Button, Label, Node, Sprite } from "cc";
import { changeScene } from "db://assets/Module/UIFast";
import { HomeScene } from "db://assets/Scripts/Scenes/HomeScene";
import { strFormat } from "../Utils/Utils";
import { PrizeScene } from "../Scenes/PrizeScene/PrizeScene";
import { LOG_TYPE, sendLog } from "../Utils/WebNet/WebNet";

const {ccclass, property} = _decorator;

@ccclass('FailPrizePanel')
export default class FailPrizePanel extends Panel {

    static skin = "FailPrizePanel";
    static group = "FailPrizePanel";

    @property(Node)
    close: Node = null!;

    @property(Node)
    get: Node = null!;

    @property(Label)
    prizeName: Label = null!;

    @property(Sprite)
    img: Sprite = null!;

    async start() {

        sendLog(LOG_TYPE.EXPOSURE, 4);

        this.close.on(Button.EventType.CLICK, this.onClose, this);
        this.get.on(Button.EventType.CLICK, this.clickGet, this);

        const {optionName, optionImg} = this.data;

        this.prizeName.string = strFormat(
            optionName,
            20
        );

        this.img.spriteFrame = optionImg;
    }

    clickGet = () => {

        sendLog(LOG_TYPE.CLICK, 4);

        this.hidePanel();
        changeScene(PrizeScene);
    }

    /**
     * 返回首页
     */
    onClose = () => {
        changeScene(HomeScene);
        this.hidePanel();
    }

}
