import { _decorator, Component, Node } from 'cc';

const {ccclass, property} = _decorator;

@ccclass('PrizeItem')
export class PrizeItem extends Component {

    data: any;

    start() {
        this.node.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);
    }

    onTouchEnd() {
        const {id, url} = this.data;
        if (url) {
            location.href = url
        } else {
            location.href = `/aaw/projectx/takePrize?projectOrderNo=${id}`
        }
    }

}


